/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleet;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;

public class DescribeCapacityReservationFleetsIterable
implements SdkIterable<DescribeCapacityReservationFleetsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityReservationFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityReservationFleetsIterable(Ec2Client client, DescribeCapacityReservationFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCapacityReservationFleetsResponseFetcher();
    }

    public Iterator<DescribeCapacityReservationFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityReservationFleet> capacityReservationFleets() {
        Function<DescribeCapacityReservationFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservationFleets() != null) {
                return response.capacityReservationFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityReservationFleetsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityReservationFleetsResponse> {
        private DescribeCapacityReservationFleetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityReservationFleetsResponse nextPage(DescribeCapacityReservationFleetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationFleetsIterable.this.client.describeCapacityReservationFleets(DescribeCapacityReservationFleetsIterable.this.firstRequest);
            }
            return DescribeCapacityReservationFleetsIterable.this.client.describeCapacityReservationFleets((DescribeCapacityReservationFleetsRequest)((Object)DescribeCapacityReservationFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

