/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.coordination.Coordinator;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.discovery.Discovery;
import org.opensearch.gateway.ClusterStateUpdaters;
import org.opensearch.gateway.Gateway;
import org.opensearch.gateway.TransportNodesListGatewayMetaState;
import org.opensearch.threadpool.ThreadPool;

public class GatewayService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(GatewayService.class);
    public static final Setting<Integer> EXPECTED_NODES_SETTING = Setting.intSetting("gateway.expected_nodes", -1, -1, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Integer> EXPECTED_DATA_NODES_SETTING = Setting.intSetting("gateway.expected_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> EXPECTED_MASTER_NODES_SETTING = Setting.intSetting("gateway.expected_master_nodes", -1, -1, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<TimeValue> RECOVER_AFTER_TIME_SETTING = Setting.positiveTimeSetting("gateway.recover_after_time", TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_nodes", -1, -1, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Integer> RECOVER_AFTER_DATA_NODES_SETTING = Setting.intSetting("gateway.recover_after_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_MASTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_master_nodes", 0, 0, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    static final TimeValue DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET = TimeValue.timeValueMinutes((long)5L);
    private final ThreadPool threadPool;
    private final AllocationService allocationService;
    private final ClusterService clusterService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterNodes;
    private final int expectedNodes;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    private final int recoverAfterClusterManagerNodes;
    private final int expectedClusterManagerNodes;
    private final Runnable recoveryRunnable;
    private final AtomicBoolean recoveryInProgress = new AtomicBoolean();
    private final AtomicBoolean scheduledRecovery = new AtomicBoolean();

    @Inject
    public GatewayService(Settings settings, AllocationService allocationService, ClusterService clusterService, ThreadPool threadPool, TransportNodesListGatewayMetaState listGatewayMetaState, Discovery discovery) {
        this.allocationService = allocationService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.expectedNodes = EXPECTED_NODES_SETTING.get(settings);
        this.expectedDataNodes = EXPECTED_DATA_NODES_SETTING.get(settings);
        this.expectedClusterManagerNodes = EXPECTED_MASTER_NODES_SETTING.get(settings);
        this.recoverAfterTime = RECOVER_AFTER_TIME_SETTING.exists(settings) ? RECOVER_AFTER_TIME_SETTING.get(settings) : (this.expectedNodes >= 0 || this.expectedDataNodes >= 0 || this.expectedClusterManagerNodes >= 0 ? DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET : null);
        this.recoverAfterNodes = RECOVER_AFTER_NODES_SETTING.get(settings);
        this.recoverAfterDataNodes = RECOVER_AFTER_DATA_NODES_SETTING.get(settings);
        this.recoverAfterClusterManagerNodes = RECOVER_AFTER_MASTER_NODES_SETTING.exists(settings) ? RECOVER_AFTER_MASTER_NODES_SETTING.get(settings) : -1;
        if (discovery instanceof Coordinator) {
            this.recoveryRunnable = () -> clusterService.submitStateUpdateTask("local-gateway-elected-state", new RecoverStateUpdateTask());
        } else {
            Gateway gateway = new Gateway(settings, clusterService, listGatewayMetaState);
            this.recoveryRunnable = () -> gateway.performStateRecovery(new GatewayRecoveryListener());
        }
    }

    protected void doStart() {
        if (DiscoveryNode.isClusterManagerNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedClusterManager()) {
            return;
        }
        if (!state.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        if (state.nodes().getClusterManagerNodeId() == null) {
            logger.debug("not recovering from gateway, no cluster-manager elected yet");
        } else if (this.recoverAfterNodes != -1 && nodes.getClusterManagerAndDataNodes().size() < this.recoverAfterNodes) {
            logger.debug("not recovering from gateway, nodes_size (data+master) [{}] < recover_after_nodes [{}]", (Object)nodes.getClusterManagerAndDataNodes().size(), (Object)this.recoverAfterNodes);
        } else if (this.recoverAfterDataNodes != -1 && nodes.getDataNodes().size() < this.recoverAfterDataNodes) {
            logger.debug("not recovering from gateway, nodes_size (data) [{}] < recover_after_data_nodes [{}]", (Object)nodes.getDataNodes().size(), (Object)this.recoverAfterDataNodes);
        } else if (this.recoverAfterClusterManagerNodes != -1 && nodes.getClusterManagerNodes().size() < this.recoverAfterClusterManagerNodes) {
            logger.debug("not recovering from gateway, nodes_size (master) [{}] < recover_after_master_nodes [{}]", (Object)nodes.getClusterManagerNodes().size(), (Object)this.recoverAfterClusterManagerNodes);
        } else {
            Object reason;
            boolean enforceRecoverAfterTime;
            if (this.expectedNodes == -1 && this.expectedClusterManagerNodes == -1 && this.expectedDataNodes == -1) {
                enforceRecoverAfterTime = true;
                reason = "recover_after_time was set to [" + this.recoverAfterTime + "]";
            } else {
                enforceRecoverAfterTime = false;
                reason = "";
                if (this.expectedNodes != -1 && nodes.getClusterManagerAndDataNodes().size() < this.expectedNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedNodes + "] nodes, but only have [" + nodes.getClusterManagerAndDataNodes().size() + "]";
                } else if (this.expectedDataNodes != -1 && nodes.getDataNodes().size() < this.expectedDataNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedDataNodes + "] data nodes, but only have [" + nodes.getDataNodes().size() + "]";
                } else if (this.expectedClusterManagerNodes != -1 && nodes.getClusterManagerNodes().size() < this.expectedClusterManagerNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedClusterManagerNodes + "] cluster-manager nodes, but only have [" + nodes.getClusterManagerNodes().size() + "]";
                }
            }
            this.performStateRecovery(enforceRecoverAfterTime, (String)reason);
        }
    }

    private void performStateRecovery(boolean enforceRecoverAfterTime, String reason) {
        if (enforceRecoverAfterTime && this.recoverAfterTime != null) {
            if (this.scheduledRecovery.compareAndSet(false, true)) {
                logger.info("delaying initial state recovery for [{}]. {}", (Object)this.recoverAfterTime, (Object)reason);
                this.threadPool.schedule(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("delayed state recovery failed", (Throwable)e);
                        GatewayService.this.resetRecoveredFlags();
                    }

                    @Override
                    protected void doRun() {
                        if (GatewayService.this.recoveryInProgress.compareAndSet(false, true)) {
                            logger.info("recover_after_time [{}] elapsed. performing state recovery...", (Object)GatewayService.this.recoverAfterTime);
                            GatewayService.this.recoveryRunnable.run();
                        }
                    }
                }, this.recoverAfterTime, "generic");
            }
        } else if (this.recoveryInProgress.compareAndSet(false, true)) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn("state recovery failed", (Throwable)e);
                    GatewayService.this.resetRecoveredFlags();
                }

                @Override
                protected void doRun() {
                    logger.debug("performing state recovery...");
                    GatewayService.this.recoveryRunnable.run();
                }
            });
        }
    }

    private void resetRecoveredFlags() {
        this.recoveryInProgress.set(false);
        this.scheduledRecovery.set(false);
    }

    TimeValue recoverAfterTime() {
        return this.recoverAfterTime;
    }

    class GatewayRecoveryListener
    implements Gateway.GatewayStateRecoveredListener {
        GatewayRecoveryListener() {
        }

        @Override
        public void onSuccess(final ClusterState recoveredState) {
            logger.trace("successful state recovery, importing cluster state...");
            GatewayService.this.clusterService.submitStateUpdateTask("local-gateway-elected-state", new RecoverStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ClusterState updatedState = ClusterStateUpdaters.mixCurrentStateAndRecoveredState(currentState, recoveredState);
                    return super.execute(ClusterStateUpdaters.recoverClusterBlocks(updatedState));
                }
            });
        }

        @Override
        public void onFailure(String msg) {
            logger.info("state recovery failed: {}", (Object)msg);
            GatewayService.this.resetRecoveredFlags();
        }
    }

    class RecoverStateUpdateTask
    extends ClusterStateUpdateTask {
        RecoverStateUpdateTask() {
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            if (!currentState.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
                logger.debug("cluster is already recovered");
                return currentState;
            }
            ClusterState newState = Function.identity().andThen(ClusterStateUpdaters::updateRoutingTable).andThen(ClusterStateUpdaters::removeStateNotRecoveredBlock).apply(currentState);
            return GatewayService.this.allocationService.reroute(newState, "state recovered");
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            logger.info("recovered [{}] indices into cluster_state", (Object)newState.metadata().indices().size());
            GatewayService.this.resetRecoveredFlags();
        }

        @Override
        public void onNoLongerClusterManager(String source) {
            logger.debug("stepped down as cluster-manager before recovering state [{}]", (Object)source);
            GatewayService.this.resetRecoveredFlags();
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.info(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
            GatewayService.this.resetRecoveredFlags();
        }
    }
}

