# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoChannelUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'display_name': 'str',
        'description': 'str',
        'support': 'str',
        'bulk_videos_support_update': 'bool'
    }

    attribute_map = {
        'display_name': 'displayName',
        'description': 'description',
        'support': 'support',
        'bulk_videos_support_update': 'bulkVideosSupportUpdate'
    }

    def __init__(self, display_name=None, description=None, support=None, bulk_videos_support_update=None, local_vars_configuration=None):  # noqa: E501
        """VideoChannelUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._display_name = None
        self._description = None
        self._support = None
        self._bulk_videos_support_update = None
        self.discriminator = None

        if display_name is not None:
            self.display_name = display_name
        if description is not None:
            self.description = description
        if support is not None:
            self.support = support
        if bulk_videos_support_update is not None:
            self.bulk_videos_support_update = bulk_videos_support_update

    @property
    def display_name(self):
        """Gets the display_name of this VideoChannelUpdate.  # noqa: E501


        :return: The display_name of this VideoChannelUpdate.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this VideoChannelUpdate.


        :param display_name: The display_name of this VideoChannelUpdate.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """Gets the description of this VideoChannelUpdate.  # noqa: E501


        :return: The description of this VideoChannelUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VideoChannelUpdate.


        :param description: The description of this VideoChannelUpdate.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def support(self):
        """Gets the support of this VideoChannelUpdate.  # noqa: E501

        A text shown by default on all videos of this channel, to tell the audience how to support it  # noqa: E501

        :return: The support of this VideoChannelUpdate.  # noqa: E501
        :rtype: str
        """
        return self._support

    @support.setter
    def support(self, support):
        """Sets the support of this VideoChannelUpdate.

        A text shown by default on all videos of this channel, to tell the audience how to support it  # noqa: E501

        :param support: The support of this VideoChannelUpdate.  # noqa: E501
        :type support: str
        """

        self._support = support

    @property
    def bulk_videos_support_update(self):
        """Gets the bulk_videos_support_update of this VideoChannelUpdate.  # noqa: E501

        Update the support field for all videos of this channel  # noqa: E501

        :return: The bulk_videos_support_update of this VideoChannelUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._bulk_videos_support_update

    @bulk_videos_support_update.setter
    def bulk_videos_support_update(self, bulk_videos_support_update):
        """Sets the bulk_videos_support_update of this VideoChannelUpdate.

        Update the support field for all videos of this channel  # noqa: E501

        :param bulk_videos_support_update: The bulk_videos_support_update of this VideoChannelUpdate.  # noqa: E501
        :type bulk_videos_support_update: bool
        """

        self._bulk_videos_support_update = bulk_videos_support_update

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoChannelUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoChannelUpdate):
            return True

        return self.to_dict() != other.to_dict()
