# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class ServerConfigCustom(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'instance': 'ServerConfigCustomInstance',
        'theme': 'ServerConfigCustomTheme',
        'services': 'ServerConfigCustomServices',
        'cache': 'ServerConfigCustomCache',
        'signup': 'ServerConfigCustomSignup',
        'admin': 'ServerConfigCustomAdmin',
        'contact_form': 'ServerConfigEmail',
        'user': 'ServerConfigUser',
        'transcoding': 'ServerConfigCustomTranscoding',
        '_import': 'ServerConfigImport',
        'auto_blacklist': 'ServerConfigAutoBlacklist',
        'followers': 'ServerConfigCustomFollowers'
    }

    attribute_map = {
        'instance': 'instance',
        'theme': 'theme',
        'services': 'services',
        'cache': 'cache',
        'signup': 'signup',
        'admin': 'admin',
        'contact_form': 'contactForm',
        'user': 'user',
        'transcoding': 'transcoding',
        '_import': 'import',
        'auto_blacklist': 'autoBlacklist',
        'followers': 'followers'
    }

    def __init__(self, instance=None, theme=None, services=None, cache=None, signup=None, admin=None, contact_form=None, user=None, transcoding=None, _import=None, auto_blacklist=None, followers=None, local_vars_configuration=None):  # noqa: E501
        """ServerConfigCustom - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._instance = None
        self._theme = None
        self._services = None
        self._cache = None
        self._signup = None
        self._admin = None
        self._contact_form = None
        self._user = None
        self._transcoding = None
        self.__import = None
        self._auto_blacklist = None
        self._followers = None
        self.discriminator = None

        if instance is not None:
            self.instance = instance
        if theme is not None:
            self.theme = theme
        if services is not None:
            self.services = services
        if cache is not None:
            self.cache = cache
        if signup is not None:
            self.signup = signup
        if admin is not None:
            self.admin = admin
        if contact_form is not None:
            self.contact_form = contact_form
        if user is not None:
            self.user = user
        if transcoding is not None:
            self.transcoding = transcoding
        if _import is not None:
            self._import = _import
        if auto_blacklist is not None:
            self.auto_blacklist = auto_blacklist
        if followers is not None:
            self.followers = followers

    @property
    def instance(self):
        """Gets the instance of this ServerConfigCustom.  # noqa: E501


        :return: The instance of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomInstance
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """Sets the instance of this ServerConfigCustom.


        :param instance: The instance of this ServerConfigCustom.  # noqa: E501
        :type instance: ServerConfigCustomInstance
        """

        self._instance = instance

    @property
    def theme(self):
        """Gets the theme of this ServerConfigCustom.  # noqa: E501


        :return: The theme of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomTheme
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this ServerConfigCustom.


        :param theme: The theme of this ServerConfigCustom.  # noqa: E501
        :type theme: ServerConfigCustomTheme
        """

        self._theme = theme

    @property
    def services(self):
        """Gets the services of this ServerConfigCustom.  # noqa: E501


        :return: The services of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomServices
        """
        return self._services

    @services.setter
    def services(self, services):
        """Sets the services of this ServerConfigCustom.


        :param services: The services of this ServerConfigCustom.  # noqa: E501
        :type services: ServerConfigCustomServices
        """

        self._services = services

    @property
    def cache(self):
        """Gets the cache of this ServerConfigCustom.  # noqa: E501


        :return: The cache of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomCache
        """
        return self._cache

    @cache.setter
    def cache(self, cache):
        """Sets the cache of this ServerConfigCustom.


        :param cache: The cache of this ServerConfigCustom.  # noqa: E501
        :type cache: ServerConfigCustomCache
        """

        self._cache = cache

    @property
    def signup(self):
        """Gets the signup of this ServerConfigCustom.  # noqa: E501


        :return: The signup of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomSignup
        """
        return self._signup

    @signup.setter
    def signup(self, signup):
        """Sets the signup of this ServerConfigCustom.


        :param signup: The signup of this ServerConfigCustom.  # noqa: E501
        :type signup: ServerConfigCustomSignup
        """

        self._signup = signup

    @property
    def admin(self):
        """Gets the admin of this ServerConfigCustom.  # noqa: E501


        :return: The admin of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomAdmin
        """
        return self._admin

    @admin.setter
    def admin(self, admin):
        """Sets the admin of this ServerConfigCustom.


        :param admin: The admin of this ServerConfigCustom.  # noqa: E501
        :type admin: ServerConfigCustomAdmin
        """

        self._admin = admin

    @property
    def contact_form(self):
        """Gets the contact_form of this ServerConfigCustom.  # noqa: E501


        :return: The contact_form of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigEmail
        """
        return self._contact_form

    @contact_form.setter
    def contact_form(self, contact_form):
        """Sets the contact_form of this ServerConfigCustom.


        :param contact_form: The contact_form of this ServerConfigCustom.  # noqa: E501
        :type contact_form: ServerConfigEmail
        """

        self._contact_form = contact_form

    @property
    def user(self):
        """Gets the user of this ServerConfigCustom.  # noqa: E501


        :return: The user of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ServerConfigCustom.


        :param user: The user of this ServerConfigCustom.  # noqa: E501
        :type user: ServerConfigUser
        """

        self._user = user

    @property
    def transcoding(self):
        """Gets the transcoding of this ServerConfigCustom.  # noqa: E501


        :return: The transcoding of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomTranscoding
        """
        return self._transcoding

    @transcoding.setter
    def transcoding(self, transcoding):
        """Sets the transcoding of this ServerConfigCustom.


        :param transcoding: The transcoding of this ServerConfigCustom.  # noqa: E501
        :type transcoding: ServerConfigCustomTranscoding
        """

        self._transcoding = transcoding

    @property
    def _import(self):
        """Gets the _import of this ServerConfigCustom.  # noqa: E501


        :return: The _import of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigImport
        """
        return self.__import

    @_import.setter
    def _import(self, _import):
        """Sets the _import of this ServerConfigCustom.


        :param _import: The _import of this ServerConfigCustom.  # noqa: E501
        :type _import: ServerConfigImport
        """

        self.__import = _import

    @property
    def auto_blacklist(self):
        """Gets the auto_blacklist of this ServerConfigCustom.  # noqa: E501


        :return: The auto_blacklist of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigAutoBlacklist
        """
        return self._auto_blacklist

    @auto_blacklist.setter
    def auto_blacklist(self, auto_blacklist):
        """Sets the auto_blacklist of this ServerConfigCustom.


        :param auto_blacklist: The auto_blacklist of this ServerConfigCustom.  # noqa: E501
        :type auto_blacklist: ServerConfigAutoBlacklist
        """

        self._auto_blacklist = auto_blacklist

    @property
    def followers(self):
        """Gets the followers of this ServerConfigCustom.  # noqa: E501


        :return: The followers of this ServerConfigCustom.  # noqa: E501
        :rtype: ServerConfigCustomFollowers
        """
        return self._followers

    @followers.setter
    def followers(self, followers):
        """Sets the followers of this ServerConfigCustom.


        :param followers: The followers of this ServerConfigCustom.  # noqa: E501
        :type followers: ServerConfigCustomFollowers
        """

        self._followers = followers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerConfigCustom):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerConfigCustom):
            return True

        return self.to_dict() != other.to_dict()
