/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;

public class NumericalHelper {
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int INT_TYPE = 2;
    private static final int LONG_TYPE = 3;
    private static final int FLOAT_TYPE = 4;
    private static final int DOUBLE_TYPE = 5;
    private static final int CHAR_TYPE = 6;
    private static final int STRING_TYPE = -1;
    private static final int BOOLEAN_TYPE = -2;
    private static final int SEQUENCE_TYPE = -3;

    private NumericalHelper() {
    }

    public static int toInt(Object aValue) throws IllegalArgumentException {
        int retValue = 0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = (int)NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = (int)NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = (int)NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Integer.parseInt((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to int: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    public static double toDouble(Object aValue) throws IllegalArgumentException {
        double retValue = 0.0;
        TypeObject aTypeObject = NumericalHelper.getTypeObject(aValue);
        switch (aTypeObject.iType) {
            case 0: {
                retValue = NumericalHelper.getByte(aTypeObject);
                break;
            }
            case 6: {
                retValue = NumericalHelper.getChar(aTypeObject);
                break;
            }
            case 1: {
                retValue = NumericalHelper.getShort(aTypeObject);
                break;
            }
            case 2: {
                retValue = NumericalHelper.getInt(aTypeObject);
                break;
            }
            case 3: {
                retValue = NumericalHelper.getLong(aTypeObject);
                break;
            }
            case 4: {
                retValue = NumericalHelper.getFloat(aTypeObject);
                break;
            }
            case 5: {
                retValue = NumericalHelper.getDouble(aTypeObject);
                break;
            }
            case -1: {
                try {
                    retValue = Float.parseFloat((String)aTypeObject.aValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException((Throwable)e, "Cannot convert to short: " + aTypeObject.aValue);
                }
            }
            case -2: {
                retValue = NumericalHelper.getBool(aTypeObject) ? -1.0 : 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return retValue;
    }

    private static TypeObject getTypeObject(Object aValue) throws IllegalArgumentException {
        TypeObject aTypeObject = new TypeObject();
        if (aValue == null || AnyConverter.isVoid((Object)aValue)) {
            throw new IllegalArgumentException("Cannot convert a null object.");
        }
        int type = AnyConverter.getType((Object)aValue).getTypeClass().getValue();
        switch (type) {
            case 1: {
                aTypeObject.iType = 6;
                aTypeObject.aValue = Character.valueOf(AnyConverter.toChar((Object)aValue));
                break;
            }
            case 3: {
                aTypeObject.iType = 0;
                aTypeObject.aValue = AnyConverter.toByte((Object)aValue);
                break;
            }
            case 4: {
                aTypeObject.iType = 1;
                aTypeObject.aValue = AnyConverter.toShort((Object)aValue);
                break;
            }
            case 6: {
                aTypeObject.iType = 2;
                aTypeObject.aValue = AnyConverter.toInt((Object)aValue);
                break;
            }
            case 8: {
                aTypeObject.iType = 3;
                aTypeObject.aValue = AnyConverter.toLong((Object)aValue);
                break;
            }
            case 10: {
                aTypeObject.iType = 4;
                aTypeObject.aValue = Float.valueOf(AnyConverter.toFloat((Object)aValue));
                break;
            }
            case 11: {
                aTypeObject.iType = 5;
                aTypeObject.aValue = AnyConverter.toDouble((Object)aValue);
                break;
            }
            case 12: {
                aTypeObject.iType = -1;
                aTypeObject.aValue = AnyConverter.toString((Object)aValue);
                break;
            }
            case 2: {
                aTypeObject.iType = -2;
                aTypeObject.aValue = AnyConverter.toBoolean((Object)aValue);
                break;
            }
            case 20: {
                aTypeObject.iType = -3;
                aTypeObject.aValue = aValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + aValue.getClass().getName());
            }
        }
        return aTypeObject;
    }

    private static byte getByte(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 0) {
            throw new IllegalArgumentException("Given argument is not a byte type.");
        }
        return (Byte)typeObject.aValue;
    }

    private static char getChar(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 6) {
            throw new IllegalArgumentException("Given argument is not a char type.");
        }
        return ((Character)typeObject.aValue).charValue();
    }

    private static short getShort(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 1) {
            throw new IllegalArgumentException("Given argument is not a short type.");
        }
        return (Short)typeObject.aValue;
    }

    private static int getInt(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 2) {
            throw new IllegalArgumentException("Given argument is not an int type.");
        }
        return (Integer)typeObject.aValue;
    }

    private static float getFloat(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 4) {
            throw new IllegalArgumentException("Given argument is not a float type.");
        }
        return ((Float)typeObject.aValue).floatValue();
    }

    private static double getDouble(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 5) {
            throw new IllegalArgumentException("Given argument is not a double type.");
        }
        return (Double)typeObject.aValue;
    }

    private static long getLong(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 3) {
            throw new IllegalArgumentException("Given argument is not a long type.");
        }
        return (Long)typeObject.aValue;
    }

    private static boolean getBool(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != -2) {
            throw new IllegalArgumentException("Given argument is not a boolean type.");
        }
        return (Boolean)typeObject.aValue;
    }

    private static class TypeObject {
        public int iType;
        public Object aValue;

        private TypeObject() {
        }
    }
}

