/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ArgsConverter;
import org.jetbrains.kotlin.utils.NamedArgument;
import org.jetbrains.kotlin.utils.ParametersMapKt;
import org.jetbrains.kotlin.utils.StringArgsConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/utils/StringArgsConverter;", "Lorg/jetbrains/kotlin/utils/ArgsConverter;", "", "()V", "tryConvertSingle", "Lorg/jetbrains/kotlin/utils/ArgsConverter$Result;", "parameter", "Lkotlin/reflect/KParameter;", "arg", "Lorg/jetbrains/kotlin/utils/NamedArgument;", "tryConvertTail", "firstArg", "restArgs", "Lkotlin/sequences/Sequence;", "tryConvertVararg", "cli-common"})
@SourceDebugExtension(value={"SMAP\nparametersMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parametersMap.kt\norg/jetbrains/kotlin/utils/StringArgsConverter\n+ 2 parametersMap.kt\norg/jetbrains/kotlin/utils/ParametersMapKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n271#2:324\n272#2:327\n37#3,2:325\n37#3,2:329\n1#4:328\n*S KotlinDebug\n*F\n+ 1 parametersMap.kt\norg/jetbrains/kotlin/utils/StringArgsConverter\n*L\n191#1:324\n191#1:327\n191#1:325,2\n182#1:329,2\n*E\n"})
final class StringArgsConverter
implements ArgsConverter<String> {
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertSingle(@NotNull KParameter parameter2, @NotNull NamedArgument<String> arg) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        Intrinsics.checkNotNullParameter(arg, "arg");
        String string2 = arg.getValue();
        if (string2 == null) {
            return new ArgsConverter.Result.Success((Object)null);
        }
        String value2 = string2;
        KClassifier kClassifier = parameter2.getType().getClassifier();
        String primitive = Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(String.class)) ? value2 : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? StringsKt.toIntOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Long.TYPE)) ? StringsKt.toLongOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Short.TYPE)) ? StringsKt.toShortOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? StringsKt.toByteOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Character.TYPE)) ? StringsKt.singleOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Float.TYPE)) ? StringsKt.toFloatOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Double.TYPE)) ? (Constable)StringsKt.toDoubleOrNull(value2) : (Constable)(Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? Boolean.valueOf(Boolean.parseBoolean(value2)) : null))))))));
        return primitive != null ? (ArgsConverter.Result)new ArgsConverter.Result.Success(primitive) : (ArgsConverter.Result)ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertVararg(@NotNull KParameter parameter2, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        KType parameterType = parameter2.getType();
        if (JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(parameterType)).isArray()) {
            String[] arrayArgCandidate;
            String[] stringArray;
            KType arrayElementType;
            String[] stringArray2 = new String[]{firstArg.getValue()};
            Sequence<String> argsSequence2 = SequencesKt.plus(SequencesKt.sequenceOf(stringArray2), SequencesKt.map(restArgs, tryConvertVararg.argsSequence.1.INSTANCE));
            Object primArrayArgCandidate = StringArgsConverter.tryConvertVararg$convertPrimitivesArray(parameterType, argsSequence2);
            if (primArrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(primArrayArgCandidate);
            }
            KTypeProjection kTypeProjection = CollectionsKt.firstOrNull(parameterType.getArguments());
            KType kType = arrayElementType = kTypeProjection != null ? kTypeProjection.getType() : null;
            KClassifier classifier$iv = kType != null ? kType.getClassifier() : null;
            boolean $i$f$convertAnyArray = false;
            if (Intrinsics.areEqual(classifier$iv, Reflection.getOrCreateKotlinClass(String.class))) {
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList(argsSequence2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                stringArray = thisCollection$iv$iv.toArray(new String[0]);
            } else {
                stringArray = arrayArgCandidate = ParametersMapKt.access$convertAnyArrayImpl(classifier$iv, argsSequence2);
            }
            if (arrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(arrayArgCandidate);
            }
        }
        return ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertTail(@NotNull KParameter parameter2, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        return this.tryConvertVararg(parameter2, firstArg, restArgs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object tryConvertVararg$convertPrimitivesArray(KType type2, Sequence<String> args) {
        List list2;
        Sequence sequence2;
        List list3 = type2.getClassifier();
        if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(int[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.1.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(long[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.2.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(short[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.3.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(byte[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.4.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(char[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.5.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(float[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.6.INSTANCE);
        } else if (Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(double[].class))) {
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.7.INSTANCE);
        } else {
            if (!Intrinsics.areEqual(list3, Reflection.getOrCreateKotlinClass(boolean[].class))) return null;
            sequence2 = SequencesKt.map(args, tryConvertVararg.convertPrimitivesArray.8.INSTANCE);
        }
        Sequence sequence3 = sequence2;
        if (sequence3 == null) return null;
        list3 = SequencesKt.toList(sequence3);
        if (list3 == null) return null;
        List it = list2 = list3;
        boolean bl = false;
        if (it.contains(null)) return null;
        List list4 = list2;
        List list5 = list4;
        if (list5 == null) return null;
        Collection $this$toTypedArray$iv = list5;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return objectArray;
    }
}

