/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AbstractReflectionApiCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH$J\f\u0010'\u001a\u00020\b*\u00020\u000bH\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isWholeReflectionApiAvailable", "", "()Z", "kClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kClass$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "kPropertyClasses", "", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isAllowedKClassMember", "name", "Lorg/jetbrains/kotlin/name/Name;", "isAllowedReflectionApi", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "containingClass", "isReflectionSource", "report", "element", "isKPropertyClass", "frontend"})
@SourceDebugExtension(value={"SMAP\nAbstractReflectionApiCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractReflectionApiCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1747#2,3:103\n*S KotlinDebug\n*F\n+ 1 AbstractReflectionApiCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AbstractReflectionApiCallChecker\n*L\n95#1:103,3\n*E\n"})
public abstract class AbstractReflectionApiCallChecker
implements CallChecker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final NotNullLazyValue kPropertyClasses$delegate;
    @NotNull
    private final NotNullLazyValue kClass$delegate;

    public AbstractReflectionApiCallChecker(@NotNull ReflectionTypes reflectionTypes, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(reflectionTypes, "reflectionTypes");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.reflectionTypes = reflectionTypes;
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<ClassDescriptor> invoke() {
                ClassDescriptor[] classDescriptorArray = new ClassDescriptor[]{AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty0(), AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty1(), AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKProperty2()};
                return SetsKt.setOf(classDescriptorArray);
            }
        });
        this.kClass$delegate = storageManager.createLazyValue((Function0)new Function0<ClassDescriptor>(this){
            final /* synthetic */ AbstractReflectionApiCallChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ClassDescriptor invoke() {
                return AbstractReflectionApiCallChecker.access$getReflectionTypes$p(this.this$0).getKClass();
            }
        });
    }

    protected abstract boolean isWholeReflectionApiAvailable();

    protected abstract void report(@NotNull PsiElement var1, @NotNull CallCheckerContext var2);

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return (Set)StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[0]);
    }

    private final ClassDescriptor getKClass() {
        return (ClassDescriptor)StorageKt.getValue(this.kClass$delegate, (Object)this, $$delegatedProperties[1]);
    }

    protected boolean isAllowedKClassMember(@NotNull Name name2, @NotNull CallCheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(context2, "context");
        switch (name2.asString()) {
            case "isInstance": 
            case "simpleName": {
                bl = true;
                break;
            }
            case "qualifiedName": {
                bl = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public final void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (this.isWholeReflectionApiAvailable()) {
            return;
        }
        if (this.isReflectionSource(reportOn)) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor2;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        Intrinsics.checkNotNull(descriptor2);
        if (!this.isAllowedReflectionApi((CallableDescriptor)descriptor2, containingClass, context2)) {
            this.report(reportOn, context2);
        }
    }

    protected boolean isAllowedReflectionApi(@NotNull CallableDescriptor descriptor2, @NotNull ClassDescriptor containingClass, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
        Name name3 = name2;
        return AbstractReflectionApiCallCheckerKt.access$getALLOWED_MEMBER_NAMES$p().contains(name3.asString()) || DescriptorUtils.isSubclass(containingClass, this.getKClass()) && this.isAllowedKClassMember(name3, context2) || (Intrinsics.areEqual(name3.asString(), "get") || Intrinsics.areEqual(name3.asString(), "set")) && this.isKPropertyClass(containingClass) || AbstractReflectionApiCallCheckerKt.access$getALLOWED_CLASSES$p().contains(DescriptorUtilsKt.getFqNameSafe(containingClass));
    }

    private final boolean isKPropertyClass(ClassDescriptor $this$isKPropertyClass) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getKPropertyClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor kProperty = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorUtils.isSubclass($this$isKPropertyClass, kProperty)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isReflectionSource(PsiElement reportOn) {
        PsiFile psiFile = reportOn.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        return file2.getPackageFqName().startsWith(StandardNames.KOTLIN_REFLECT_FQ_NAME);
    }

    public static final /* synthetic */ ReflectionTypes access$getReflectionTypes$p(AbstractReflectionApiCallChecker $this) {
        return $this.reflectionTypes;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kPropertyClasses", "getKPropertyClasses()Ljava/util/Set;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(AbstractReflectionApiCallChecker.class), "kClass", "getKClass()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;"))};
        $$delegatedProperties = kPropertyArray;
    }
}

