/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.CastingType;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUnificationKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a.\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a\u001a4\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0003\u00a8\u0006$"}, d2={"checkCasting", "Lorg/jetbrains/kotlin/fir/analysis/checkers/CastingType;", "lhsType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rhsType", "isSafeCase", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "findStaticallyKnownSubtype", "supertype", "subTypeClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isCastErased", "subtype", "isExactTypeCast", "candidateType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "targetType", "isFinal", "type", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRefinementUseless", "shouldCheckForExactType", "arg", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isRelated", "aType", "bType", "aClassSymbol", "bClassSymbol", "isUpcast", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "isNonReifiedTypeParameter", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCastDiagnosticsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n83#2:308\n83#2:310\n34#3:309\n34#3:311\n1#4:312\n*S KotlinDebug\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n*L\n44#1:308\n72#1:310\n44#1:309\n72#1:311\n*E\n"})
public final class FirCastDiagnosticsHelpersKt {
    @NotNull
    public static final CastingType checkCasting(@NotNull ConeKotlinType lhsType, @NotNull ConeKotlinType rhsType, boolean isSafeCase, @NotNull CheckerContext context2) {
        block21: {
            block20: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isInterface;
                ClassKind $this$isInterface$iv$iv;
                boolean $i$f$isInterface2;
                FirClassSymbol $this$isInterface$iv;
                FirRegularClassSymbol rhsClassSymbol;
                Intrinsics.checkNotNullParameter(lhsType, "lhsType");
                Intrinsics.checkNotNullParameter(rhsType, "rhsType");
                Intrinsics.checkNotNullParameter(context2, "context");
                ConeSimpleKotlinType lhsLowerType = ConeTypeUtilsKt.lowerBoundIfFlexible(lhsType);
                ConeSimpleKotlinType rhsLowerType = ConeTypeUtilsKt.lowerBoundIfFlexible(rhsType);
                FirSession session2 = context2.getSession();
                if (lhsLowerType instanceof ConeIntersectionType) {
                    boolean result2 = false;
                    for (ConeKotlinType intersectedType : ((ConeIntersectionType)lhsLowerType).getIntersectedTypes()) {
                        boolean bl3;
                        FirRegularClassSymbol intersectedTypeSymbol;
                        CastingType isIntersectedCastPossible = FirCastDiagnosticsHelpersKt.checkCasting(intersectedType, rhsLowerType, isSafeCase, context2);
                        FirRegularClassSymbol firRegularClassSymbol = intersectedTypeSymbol = TypeUtilsKt.toRegularClassSymbol(intersectedType, context2.getSession());
                        if (firRegularClassSymbol != null) {
                            FirClassSymbol $this$isInterface$iv2 = firRegularClassSymbol;
                            boolean $i$f$isInterface3 = false;
                            ClassKind $this$isInterface$iv$iv2 = $this$isInterface$iv2.getClassKind();
                            boolean $i$f$isInterface4 = false;
                            boolean bl4 = $this$isInterface$iv$iv2 == ClassKind.INTERFACE;
                            bl3 = !bl4;
                        } else {
                            bl3 = false;
                        }
                        if (bl3 && isIntersectedCastPossible == CastingType.Impossible) {
                            return CastingType.Impossible;
                        }
                        result2 |= isIntersectedCastPossible != CastingType.Impossible;
                    }
                    return result2 ? CastingType.Possible : CastingType.Impossible;
                }
                boolean lhsNullable = FirTypeUtilsKt.getCanBeNull(lhsLowerType);
                boolean rhsNullable = FirTypeUtilsKt.getCanBeNull(rhsLowerType);
                if (ConeBuiltinTypeUtilsKt.isNothing(lhsLowerType)) {
                    return CastingType.Possible;
                }
                if (ConeBuiltinTypeUtilsKt.isNullableNothing(lhsLowerType) && !rhsNullable) {
                    return isSafeCase ? CastingType.Always : CastingType.Impossible;
                }
                if (ConeBuiltinTypeUtilsKt.isNothing(rhsLowerType)) {
                    return CastingType.Impossible;
                }
                if (ConeBuiltinTypeUtilsKt.isNullableNothing(rhsLowerType)) {
                    return lhsNullable ? CastingType.Possible : CastingType.Impossible;
                }
                if (lhsNullable && rhsNullable) {
                    return CastingType.Possible;
                }
                FirRegularClassSymbol lhsClassSymbol = TypeUtilsKt.toRegularClassSymbol(lhsLowerType, context2.getSession());
                if (FirCastDiagnosticsHelpersKt.isRelated(lhsLowerType, rhsLowerType, lhsClassSymbol, rhsClassSymbol = TypeUtilsKt.toRegularClassSymbol(rhsLowerType, context2.getSession()), context2)) {
                    return CastingType.Possible;
                }
                if (lhsLowerType instanceof ConeTypeParameterType || rhsLowerType instanceof ConeTypeParameterType) {
                    return CastingType.Possible;
                }
                if (FirCastDiagnosticsHelpersKt.isFinal(lhsLowerType, session2) || FirCastDiagnosticsHelpersKt.isFinal(rhsLowerType, session2)) {
                    return CastingType.Impossible;
                }
                FirRegularClassSymbol firRegularClassSymbol = lhsClassSymbol;
                if (firRegularClassSymbol != null) {
                    $this$isInterface$iv = firRegularClassSymbol;
                    $i$f$isInterface2 = false;
                    $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                    $i$f$isInterface = false;
                    bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                } else {
                    bl2 = false;
                }
                if (bl2) break block20;
                FirRegularClassSymbol firRegularClassSymbol2 = rhsClassSymbol;
                if (firRegularClassSymbol2 != null) {
                    $this$isInterface$iv = firRegularClassSymbol2;
                    $i$f$isInterface2 = false;
                    $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                    $i$f$isInterface = false;
                    bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                } else {
                    bl = false;
                }
                if (!bl) break block21;
            }
            return CastingType.Possible;
        }
        return CastingType.Impossible;
    }

    private static final boolean isRelated(ConeSimpleKotlinType aType, ConeSimpleKotlinType bType, FirRegularClassSymbol aClassSymbol, FirRegularClassSymbol bClassSymbol, CheckerContext context2) {
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeContext2, (KotlinTypeMarker)aType, (KotlinTypeMarker)bType, false, 8, null) || AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeContext2, (KotlinTypeMarker)bType, (KotlinTypeMarker)aType, false, 8, null)) {
            return true;
        }
        Object object = aClassSymbol;
        ConeKotlinType aNormalizedType = FirCastDiagnosticsHelpersKt.isRelated$getCorrespondingKotlinClass(context2, object != null && (object = ScopeUtilsKt.defaultType((FirClassSymbol)object)) != null ? (ConeSimpleKotlinType)object : aType);
        Object object2 = bClassSymbol;
        ConeKotlinType bNormalizedType = FirCastDiagnosticsHelpersKt.isRelated$getCorrespondingKotlinClass(context2, object2 != null && (object2 = ScopeUtilsKt.defaultType((FirClassSymbol)object2)) != null ? (ConeSimpleKotlinType)object2 : bType);
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeContext2, (KotlinTypeMarker)aNormalizedType, (KotlinTypeMarker)bNormalizedType, false, 8, null) || AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeContext2, (KotlinTypeMarker)bNormalizedType, (KotlinTypeMarker)aNormalizedType, false, 8, null);
    }

    private static final boolean isFinal(ConeSimpleKotlinType type2, FirSession session2) {
        return !TypeUtilsKt.canHaveSubtypes(type2, session2);
    }

    public static final boolean isCastErased(@NotNull ConeKotlinType supertype2, @NotNull ConeKotlinType subtype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        boolean isNonReifiedTypeParameter = FirCastDiagnosticsHelpersKt.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = FirCastDiagnosticsHelpersKt.isUpcast(context2, supertype2, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !FirTypeUtilsKt.getCanBeNull(subtype) && Intrinsics.areEqual(TypeUtilsKt.withNullability$default(supertype2, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (ConeTypeUtilsKt.isMarkedNullable(supertype2) || ConeTypeUtilsKt.isMarkedNullable(subtype)) {
            return FirCastDiagnosticsHelpersKt.isCastErased(TypeUtilsKt.withNullability$default(supertype2, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), TypeUtilsKt.withNullability$default(subtype, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), context2);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (subtype instanceof ConeTypeParameterType) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(subtype, context2.getSession());
        if (firRegularClassSymbol == null) {
            return true;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        ConeKotlinType staticallyKnownSubtype = FirCastDiagnosticsHelpersKt.findStaticallyKnownSubtype(supertype2, regularClassSymbol, context2);
        return !AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)staticallyKnownSubtype, (KotlinTypeMarker)subtype, false);
    }

    @NotNull
    public static final ConeKotlinType findStaticallyKnownSubtype(@NotNull ConeKotlinType supertype2, @NotNull FirRegularClassSymbol subTypeClassSymbol, @NotNull CheckerContext context2) {
        Collection collection;
        boolean bl;
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subTypeClassSymbol, "subTypeClassSymbol");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl2 = bl = !ConeTypeUtilsKt.isMarkedNullable(supertype2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22);
        }
        FirSession session2 = context2.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session2);
        ConeClassLikeType subtypeWithVariablesType = ScopeUtilsKt.defaultType(subTypeClassSymbol);
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        if (supertype2 instanceof ConeIntersectionType) {
            collection = ((ConeIntersectionType)supertype2).getIntersectedTypes();
        } else {
            ArrayList<ConeKotlinType> arrayList = new ArrayList<ConeKotlinType>(1);
            ArrayList<ConeKotlinType> it = arrayList;
            boolean bl3 = false;
            it.add(supertype2);
            collection = arrayList;
        }
        Collection normalizedTypes = collection;
        Map resultSubstitution = new LinkedHashMap();
        for (ConeKotlinType normalizedType : normalizedTypes) {
            Map map;
            SimpleTypeMarker supertypeWithVariables = CollectionsKt.firstOrNull(AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState2, subtypeWithVariablesType, TypeSystemContextHelpersKt.typeConstructor(normalizedType, typeContext2)));
            List<FirTypeParameterSymbol> variables2 = subTypeClassSymbol.getTypeParameterSymbols();
            if (supertypeWithVariables != null) {
                Map result2 = new LinkedHashMap();
                map = TypeUnificationKt.doUnify(context2.getSession(), supertype2, (ConeKotlinTypeProjection)((Object)supertypeWithVariables), CollectionsKt.toSet((Iterable)variables2), result2) ? result2 : (Map)new LinkedHashMap();
            } else {
                map = new LinkedHashMap();
            }
            Map substitution = map;
            for (FirTypeParameterSymbol variable2 : variables2) {
                ConeTypeProjection value2 = (ConeTypeProjection)substitution.get(variable2);
                ConeKotlinType resultValue = value2 == null ? null : (value2 instanceof ConeStarProjection ? (ConeKotlinType)new ConeStubTypeForTypeVariableInSubtyping(new ConeTypeVariable("", null), ConeNullability.NULLABLE) : ConeTypeProjectionKt.getType(value2));
                if (resultValue == null) continue;
                resultSubstitution.put(variable2, resultValue);
            }
        }
        ConeSubstitutorByMap substitutor2 = new ConeSubstitutorByMap(resultSubstitution, session2);
        return substitutor2.substituteOrSelf(subtypeWithVariablesType);
    }

    public static final boolean isNonReifiedTypeParameter(@NotNull ConeKotlinType $this$isNonReifiedTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isNonReifiedTypeParameter, "<this>");
        return $this$isNonReifiedTypeParameter instanceof ConeTypeParameterType && !((ConeTypeParameterType)$this$isNonReifiedTypeParameter).getLookupTag().getTypeParameterSymbol().isReified();
    }

    public static final boolean shouldCheckForExactType(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression2.getOperation())));
            }
        }
        return bl;
    }

    public static final boolean isRefinementUseless(@NotNull CheckerContext context2, @NotNull ConeSimpleKotlinType candidateType, @NotNull ConeKotlinType targetType, boolean shouldCheckForExactType, @NotNull FirExpression arg) {
        boolean bl;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(candidateType, "candidateType");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Intrinsics.checkNotNullParameter(arg, "arg");
        if (shouldCheckForExactType) {
            if (arg instanceof FirFunctionCall) {
                FirFunctionSymbol functionSymbol;
                FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(arg);
                FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
                if (functionSymbol != null && FirHelpersKt.isFunctionForExpectTypeFromCastFeature(functionSymbol)) {
                    return false;
                }
            }
            bl = FirCastDiagnosticsHelpersKt.isExactTypeCast(context2, candidateType, targetType);
        } else {
            bl = FirCastDiagnosticsHelpersKt.isUpcast(context2, candidateType, targetType);
        }
        return bl;
    }

    private static final boolean isExactTypeCast(CheckerContext context2, ConeSimpleKotlinType candidateType, ConeKotlinType targetType) {
        if (!AbstractTypeChecker.INSTANCE.equalTypes(TypeComponentsKt.getTypeContext(context2.getSession()), candidateType, targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(candidateType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }

    private static final boolean isUpcast(CheckerContext context2, ConeKotlinType candidateType, ConeKotlinType targetType) {
        if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)candidateType, (KotlinTypeMarker)targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(candidateType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }

    private static final ConeKotlinType isRelated$getCorrespondingKotlinClass(CheckerContext $context, ConeSimpleKotlinType type2) {
        Object object = FirPlatformClassMapperKt.getPlatformClassMapper($context.getSession()).getCorrespondingKotlinClass(ConeTypeUtilsKt.getClassId(type2));
        return object != null && (object = ScopeUtilsKt.defaultType((ClassId)object, CollectionsKt.emptyList())) != null ? (ConeKotlinType)object : (ConeKotlinType)type2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

