/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.XmlElement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private static volatile ApplicationInfoImpl instance;
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String mySmallIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private boolean myShowLicensee;
    private String myWelcomeScreenDialog;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private int myWhatsNewEligibility;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> essentialPluginsIds;
    private String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private List<ProgressSlide> progressSlides;
    private XmlElement myFeedbackForm;
    private String myDefaultLightLaf;
    private String myDefaultDarkLaf;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    ApplicationInfoImpl(@NotNull XmlElement element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.svg";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.essentialPluginsIds = new ArrayList<PluginId>();
        this.myEventLogSettingsUrl = "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.progressSlides = Collections.emptyList();
        block56: for (XmlElement child : element.children) {
            switch (child.name) {
                case "version": {
                    this.myMajorVersion = child.getAttributeValue("major");
                    this.myMinorVersion = child.getAttributeValue("minor");
                    this.myMicroVersion = child.getAttributeValue("micro");
                    this.myPatchVersion = child.getAttributeValue("patch");
                    this.myFullVersionFormat = child.getAttributeValue("full");
                    this.myCodeName = child.getAttributeValue("codename");
                    this.myEAP = Boolean.parseBoolean(child.getAttributeValue("eap"));
                    this.myVersionSuffix = child.getAttributeValue("suffix", this.myEAP ? "EAP" : null);
                    break;
                }
                case "company": {
                    this.myCompanyName = child.getAttributeValue("name", this.myCompanyName);
                    this.myShortCompanyName = child.getAttributeValue("shortName", this.myCompanyName == null ? null : ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
                    this.myCompanyUrl = child.getAttributeValue("url", this.myCompanyUrl);
                    this.myCopyrightStart = child.getAttributeValue("copyrightStart", this.myCopyrightStart);
                    break;
                }
                case "build": {
                    this.readBuildInfo(child);
                    break;
                }
                case "logo": {
                    this.readLogoInfo(child);
                    break;
                }
                case "about": {
                    String c;
                    this.myAboutImageUrl = child.getAttributeValue("url");
                    String v = child.getAttributeValue("foreground");
                    if (v != null) {
                        this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((v = child.getAttributeValue("copyrightForeground")) != null) {
                        this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((c = child.getAttributeValue("linkColor")) != null) {
                        this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
                    }
                    String logoX = child.getAttributeValue("logoX");
                    String logoY = child.getAttributeValue("logoY");
                    String logoW = child.getAttributeValue("logoW");
                    String logoH = child.getAttributeValue("logoH");
                    if (logoX == null || logoY == null || logoW == null || logoH == null) continue block56;
                    try {
                        this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "icon": {
                    this.mySmallIconUrl = child.getAttributeValue("size16", this.mySmallIconUrl);
                    String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(child, "size12");
                    if (toolWindowIcon != null) {
                        this.myToolWindowIconUrl = toolWindowIcon;
                    }
                    this.mySvgIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "icon-eap": {
                    this.mySvgEapIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgEapIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "licensee": {
                    this.myShowLicensee = Boolean.parseBoolean(child.getAttributeValue("show"));
                    break;
                }
                case "welcome-screen": {
                    this.myWelcomeScreenLogoUrl = child.getAttributeValue("logo-url");
                    break;
                }
                case "welcome-wizard": {
                    this.myWelcomeScreenDialog = ApplicationInfoImpl.getAttributeValue(child, "dialog");
                    break;
                }
                case "help": {
                    String attValue;
                    String webHelpUrl = ApplicationInfoImpl.getAttributeValue(child, "webhelp-url");
                    if (webHelpUrl != null) {
                        this.myWebHelpUrl = webHelpUrl;
                    }
                    this.myHasHelp = (attValue = child.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
                    attValue = child.getAttributeValue("has-context-help");
                    this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
                    break;
                }
                case "update-urls": {
                    this.myUpdateUrls = new UpdateUrlsImpl(child);
                    break;
                }
                case "documentation": {
                    this.myDocumentationUrl = child.getAttributeValue("url");
                    break;
                }
                case "support": {
                    this.mySupportUrl = child.getAttributeValue("url");
                    break;
                }
                case "youtrack": {
                    this.myYoutrackUrl = child.getAttributeValue("url");
                    break;
                }
                case "feedback": {
                    this.myFeedbackUrl = child.getAttributeValue("url");
                    if (child.getAttributeValue("zendesk-form-id") == null) break;
                    this.myFeedbackForm = child;
                    break;
                }
                case "whatsnew": {
                    this.myWhatsNewUrl = child.getAttributeValue("url");
                    String eligibility = child.getAttributeValue("eligibility");
                    if ("embed".equals(eligibility)) {
                        this.myWhatsNewEligibility = 1;
                        break;
                    }
                    if (!"auto".equals(eligibility)) continue block56;
                    this.myWhatsNewEligibility = 2;
                    break;
                }
                case "plugins": {
                    this.readPluginInfo(child);
                    break;
                }
                case "keymap": {
                    this.myWinKeymapUrl = child.getAttributeValue("win");
                    this.myMacKeymapUrl = child.getAttributeValue("mac");
                    break;
                }
                case "essential-plugin": {
                    String id = child.content;
                    if (id == null || id.isEmpty()) continue block56;
                    this.essentialPluginsIds.add(PluginId.getId(id));
                    break;
                }
                case "statistics": {
                    this.myEventLogSettingsUrl = child.getAttributeValue("event-log-settings");
                    break;
                }
                case "jetbrains-tv": {
                    this.myJetBrainsTvUrl = child.getAttributeValue("url");
                    break;
                }
                case "licensing": {
                    String url = ApplicationInfoImpl.getAttributeValue(child, "key-conversion-url");
                    if (url == null) continue block56;
                    this.myKeyConversionUrl = url.trim();
                    break;
                }
                case "subscriptions": {
                    this.mySubscriptionFormId = child.getAttributeValue("formid");
                    this.mySubscriptionNewsKey = child.getAttributeValue("news-key");
                    this.mySubscriptionNewsValue = child.getAttributeValue("news-value", "yes");
                    this.mySubscriptionTipsKey = child.getAttributeValue("tips-key");
                    this.mySubscriptionTipsAvailable = Boolean.parseBoolean(child.getAttributeValue("tips-available"));
                    this.mySubscriptionAdditionalFormData = child.getAttributeValue("additional-form-data");
                    break;
                }
                case "default-laf": {
                    String laf = ApplicationInfoImpl.getAttributeValue(child, "light");
                    if (laf != null) {
                        this.myDefaultLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark")) == null) break;
                    this.myDefaultDarkLaf = laf.trim();
                }
            }
        }
        this.essentialPluginsIds.sort(null);
    }

    private void readLogoInfo(XmlElement element) {
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element, "url");
        String v = element.getAttributeValue("progressColor");
        if (v != null && !v.isEmpty()) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = element.getAttributeValue("progressTailIcon")) != null && !v.isEmpty()) {
            this.myProgressTailIconName = v;
        }
        if ((v = element.getAttributeValue("progressHeight")) != null && !v.isEmpty()) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = element.getAttributeValue("progressY")) != null && !v.isEmpty()) {
            this.myProgressY = Integer.parseInt(v);
        }
        if (!element.children.isEmpty()) {
            this.progressSlides = new ArrayList<ProgressSlide>(element.children.size());
            for (XmlElement child : element.children) {
                if (!child.name.equals("progressSlide")) continue;
                String slideUrl = Objects.requireNonNull(child.getAttributeValue("url"));
                String progressPercent = Objects.requireNonNull(child.getAttributeValue("progressPercent"));
                int progressPercentInt = Integer.parseInt(progressPercent);
                if (progressPercentInt < 0 || progressPercentInt > 100) {
                    throw new IllegalArgumentException("Expected [0, 100], got " + progressPercent);
                }
                float progressPercentFloat = (float)progressPercentInt / 100.0f;
                this.progressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
            }
        }
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        return ApplicationInfoImpl.getShadowInstanceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static ApplicationInfoImpl getShadowInstanceImpl() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(1);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading", ActivityCategory.DEFAULT);
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build2 = this.getBuild();
        if (this.myApiVersion != null && (api = BuildNumber.fromStringWithProductCode(this.myApiVersion, build2.getProductCode())) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(6);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        return buildNumber;
    }

    @Nullable
    private static String getAttributeValue(XmlElement element, String name2) {
        String value2 = element.getAttributeValue(name2);
        return value2 == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(XmlElement element) {
        String majorReleaseDateString;
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element, "apiVersion");
        String dateString = element.getAttributeValue("date");
        if (dateString != null && !dateString.equals("__BUILD_DATE__")) {
            this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element.getAttributeValue("majorReleaseDate")) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable XmlElement element) {
        String pluginHost;
        String pluginManagerUrl = "https://plugins.jetbrains.com";
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element.getAttributeValue("url");
            if (url != null) {
                String string2 = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element.getAttributeValue("list-url")) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element.getAttributeValue("channel-list-url")) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element.getAttributeValue("download-url")) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if ((builtinPluginsUrl = element.getAttributeValue("builtin-url")) != null && !builtinPluginsUrl.isEmpty()) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginHost = System.getProperty("idea.plugins.host")) != null) {
            pluginManagerUrl = pluginHost.endsWith("/") ? pluginHost.substring(0, pluginHost.length() - 1) : pluginHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string3 = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    private static String shortenCompanyName(String name2) {
        if (name2.endsWith(" s.r.o.")) {
            name2 = name2.substring(0, name2.length() - " s.r.o.".length());
        }
        if (name2.endsWith(" Inc.")) {
            name2 = name2.substring(0, name2.length() - " Inc.".length());
        }
        return name2;
    }

    private static GregorianCalendar parseDate(String dateString) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    private static long parseColor(String colorString) {
        return Long.parseLong(colorString, 16);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId(pluginId));
    }

    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        return PluginManagerCore.CORE_ID.equals(pluginId) || Collections.binarySearch(this.essentialPluginsIds, pluginId) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstanceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "orFromPluginsCompatibleBuild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressSlides";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuild";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuildAsNumber";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(XmlElement element) {
            this.myCheckingUrl = element.getAttributeValue("check");
            this.myPatchesUrl = element.getAttributeValue("patches");
        }
    }
}

