/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Closure;
import org.jruby.Ruby;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;

final class CallbackMemoryIO
extends InvalidMemoryIO
implements AllocatedDirectMemoryIO {
    private final Closure.Handle handle;
    private volatile boolean released;
    private volatile boolean unmanaged;
    private Object proc;

    public CallbackMemoryIO(Ruby runtime2, Closure.Handle handle, Object proc2) {
        super(runtime2, true, handle.getAddress(), "cannot access closure trampoline memory");
        this.handle = handle;
        this.proc = proc2;
    }

    public CallbackMemoryIO(Ruby runtime2, Closure.Handle handle) {
        this(runtime2, handle, null);
    }

    @Override
    public synchronized void free() {
        if (!this.released) {
            this.proc = null;
            this.handle.dispose();
            this.released = true;
            this.unmanaged = true;
        }
    }

    @Override
    public synchronized void setAutoRelease(boolean autorelease2) {
        if (this.isAutoRelease() != autorelease2) {
            this.handle.setAutoRelease(autorelease2);
            this.unmanaged = !autorelease2;
        }
    }

    @Override
    public boolean isAutoRelease() {
        return !this.unmanaged;
    }
}

