/**
 * Parse CLI options.
 *
 * @param {Array<string>} flags
 * @param {Options} configuration
 */
export function options(
  flags: Array<string>,
  configuration: Options
): {
  helpMessage: string
  cwd: string | URL | undefined
  processor: () => import('unified').Processor<any, any, any, any>
  help: unknown
  version: unknown
  files: unknown
  filePath: unknown
  watch: unknown
  extensions: string[]
  output: unknown
  out: unknown
  tree: unknown
  treeIn: unknown
  treeOut: unknown
  inspect: unknown
  rcName: string
  packageField: string
  rcPath: unknown
  detectConfig: unknown
  settings: Record<string, unknown>
  ignoreName: string
  ignorePath: unknown
  ignorePathResolveFrom: unknown
  ignorePatterns: string[]
  silentlyIgnore: unknown
  detectIgnore: unknown
  pluginPrefix: string
  plugins: Record<string, Record<string, unknown> | undefined>
  reporter: string | undefined
  reporterOptions: Record<string, unknown> | undefined
  color: unknown
  silent: unknown
  quiet: unknown
  frail: unknown
}
export type EngineOptions = import('unified-engine').Options
export type Option = import('./schema.js').Option
export type RequiredEngineOptions = Required<
  Pick<
    EngineOptions,
    | 'extensions'
    | 'ignoreName'
    | 'packageField'
    | 'pluginPrefix'
    | 'processor'
    | 'rcName'
  >
>
export type ArgsOptionsFields = {
  /**
   * Name of executable
   */
  name: string
  /**
   * Description of executable
   */
  description: string
  /**
   * Version (semver) of executable
   */
  version: string
}
export type Options = RequiredEngineOptions &
  Pick<EngineOptions, 'cwd'> &
  ArgsOptionsFields
