/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Actions;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VcsResolver;

public class DefaultVcsMappingsStore
implements VcsMappingsStore,
VcsResolver {
    private final Set<Action<? super VcsMapping>> rootVcsMappings = Sets.newLinkedHashSet();
    private final Map<Gradle, Set<Action<? super VcsMapping>>> vcsMappings = Maps.newHashMap();
    private final VcsMappingFactory vcsMappingFactory;

    public DefaultVcsMappingsStore(VcsMappingFactory vcsMappingFactory) {
        this.vcsMappingFactory = vcsMappingFactory;
    }

    public VcsResolver asResolver() {
        return this;
    }

    @Nullable
    public VersionControlSpec locateVcsFor(ModuleComponentSelector selector) {
        if (!this.hasRules()) {
            return null;
        }
        VcsMappingInternal mapping = this.vcsMappingFactory.create((ComponentSelector)selector);
        this.applyTo(mapping);
        if (mapping.hasRepository()) {
            return mapping.getRepository();
        }
        return null;
    }

    private void applyTo(VcsMappingInternal mapping) {
        Actions.composite(this.rootVcsMappings).execute((Object)mapping);
        if (!mapping.hasRepository()) {
            HashSet resolutions = Sets.newHashSet();
            for (Gradle gradle : this.vcsMappings.keySet()) {
                Actions.composite((Iterable)this.vcsMappings.get(gradle)).execute((Object)mapping);
                if (!mapping.hasRepository()) continue;
                resolutions.add(mapping.getRepository());
            }
            if (resolutions.size() > 1) {
                Set resolutionDisplayNames = CollectionUtils.collect((Set)resolutions, (Transformer)new Transformer<String, VersionControlSpec>(){

                    public String transform(VersionControlSpec versionControlSpec) {
                        return versionControlSpec.getDisplayName();
                    }
                });
                throw new GradleException("Conflicting external source dependency rules were found in nested builds for " + mapping.getRequested().getDisplayName() + ":\n  " + CollectionUtils.join((String)"\n  ", (Iterable)resolutionDisplayNames));
            }
        }
    }

    public boolean hasRules() {
        return !this.vcsMappings.isEmpty() || !this.rootVcsMappings.isEmpty();
    }

    public void addRule(Action<? super VcsMapping> rule, Gradle gradle) {
        if (gradle.getParent() == null) {
            this.rootVcsMappings.add(rule);
        } else {
            if (!this.vcsMappings.containsKey(gradle)) {
                this.vcsMappings.put(gradle, Sets.newLinkedHashSet());
            }
            this.vcsMappings.get(gradle).add(rule);
        }
    }
}

