# ToricVarieties, single 5
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("toricvarieties05.tst");

# /doc/_Chunks.xml:211-234
gap> rays := [ [1,0,0], [0,1,0], [0,0,1] ];
[ [1,0,0], [0,1,0], [0,0,1] ]
gap> max_cones := [ [1,2,3] ];
[ [1,2,3] ]
gap> fan := Fan( rays, max_cones );
<A fan in |R^3>
gap> C3 := ToricVariety( rays, max_cones, [[0],[0],[0]], "x1,x2,x3" );
<A toric variety of dimension 3>
gap> B1C3 := BlowupOfToricVariety( C3, "x1,x2,x3", "u0" );
<A toric variety of dimension 3>
gap> [ IsComplete( B1C3 ), IsOrbifold( B1C3 ), IsSmooth( B1C3 ) ];
[ false, true, true ]
gap> B2C3 := BlowupOfToricVariety( B1C3, "x1,u0", "u1" );
<A toric variety of dimension 3>
gap> Rank( ClassGroup( B2C3 ) );
3
gap> B3C3 := BlowupOfToricVariety( B2C3, "x1,u1", "u2" );
<A toric variety of dimension 3>
gap> CoxRing( B3C3 );
Q[x3,x2,x1,u0,u1,u2]
(weights: [ ( 0, 1, 0, 0 ), ( 0, 1, 0, 0 ), ( 0, 1, 1, 1 ), 
( 0, -1, 1, 0 ), ( 0, 0, -1, 1 ), ( 0, 0, 0, -1 ) ])

#
gap> STOP_TEST("toricvarieties05.tst", 1);
