# Modules, single 30
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("modules30.tst");

# doc/../gap/BasicFunctors.gi:1417-1471
gap> ZZ := HomalgRingOfIntegers( );
Z
gap> M := HomalgMatrix( "[ 2, 3, 4,   5, 6, 7 ]", 2, 3, ZZ );
<A 2 x 3 matrix over an internal ring>
gap> M := LeftPresentation( M );
<A non-torsion left module presented by 2 relations for 3 generators>
gap> N := HomalgMatrix( "[ 2, 3, 4, 5,   6, 7, 8, 9 ]", 2, 4, ZZ );
<A 2 x 4 matrix over an internal ring>
gap> N := LeftPresentation( N );
<A non-torsion left module presented by 2 relations for 4 generators>
gap> mat := HomalgMatrix( "[ \
> 1, 0, -3, -6, \
> 0, 1,  6, 11, \
> 1, 0, -3, -6  \
> ]", 3, 4, ZZ );
<A 3 x 4 matrix over an internal ring>
gap> phi := HomalgMap( mat, M, N );
<A "homomorphism" of left modules>
gap> IsMorphism( phi );
true
gap> phi;
<A homomorphism of left modules>
gap> L := Hom( ZZ, M );
<A rank 1 right module on 3 generators satisfying yet unknown relations>
gap> ByASmallerPresentation( L );
<A rank 1 right module on 2 generators satisfying 1 relation>
gap> Display( L );
Z/< 3 > + Z^(1 x 1)
gap> L;
<A rank 1 right module on 2 generators satisfying 1 relation>
gap> psi := phi * L;
<A homomorphism of right modules>
gap> ByASmallerPresentation( psi );
<A non-zero homomorphism of right modules>
gap> Display( psi );
[ [   0,   0,   1,   1 ],
  [   0,   0,   8,   1 ],
  [   0,   0,   0,  -2 ],
  [   0,   0,   0,   2 ] ]

the map is currently represented by the above 4 x 4 matrix
gap> ML := Source( psi );
<A rank 1 right module on 4 generators satisfying 3 relations>
gap> IsIdenticalObj( ML, M * L ); ## the caching at work
true
gap> NL := Range( psi );
<A rank 2 right module on 4 generators satisfying 2 relations>
gap> IsIdenticalObj( NL, N * L ); ## the caching at work
true
gap> Display( ML );
Z/< 3 > + Z/< 3 > + Z/< 3 > + Z^(1 x 1)
gap> Display( NL );
Z/< 3 > + Z/< 12 > + Z^(2 x 1)

#
gap> STOP_TEST("modules30.tst", 1);
