#############################################################################
##
#W  UnicodeTabs.g                GAPDoc                     Frank Lübeck
##
##
#Y  Copyright (C)  2007,  Frank Lübeck,  Lehrstuhl D für Mathematik,  
#Y  RWTH Aachen
##  
##  This file contains non-reversible maps from unicode characters to
##  LaTeX, ASCII, lower case, ...
##  Only some characters are handled, proposed further entries for these
##  tables are welcome!
##  
# This table translates some unicode characters to LaTeX code. It is started
# with data from various data files for supporting UTF-8 in LaTeX,
# ("ucs" package, "enctex")
InstallValue(LaTeXUnicodeTable,
 [
 # we actually start with the ASCII characters which are special characters
 # in  LaTeX
 [ 35, "\\#" ],
 [ 36, "\\$" ],
 [ 37, "\\%" ],
 [ 38, "\\&" ],
 [ 60, "{\\textless}" ],
 [ 62, "{\\textgreater}" ],
 [ 92, "\\texttt{\\symbol{92}}" ],
 [ 94, "\\texttt{\\symbol{94}}" ],
 [ 95, "{\\textunderscore}" ],
 [ 123, "\\texttt{\\symbol{123}}" ],
 [ 125, "\\texttt{\\symbol{125}}" ],
 [ 126, "\\texttt{\\symbol{126}}" ],
 [ 160, "{\\nobreakspace}" ],
 [ 161, "{\\textexclamdown}" ],
 [ 162, "{\\textcent}" ],
 [ 163, "{\\pounds}" ],
 [ 164, "{\\textcurrency}" ],
 [ 165, "{\\textyen}" ],
 [ 166, "{\\textbrokenbar}" ],
 [ 167, "{\\S}" ],
 [ 168, "{\\\"{\\empty}" ],
 [ 169, "{\\copyright}" ],
 [ 170, "{\\textordfeminine}" ],
 [ 171, "{\\guillemotleft}" ],
 [ 172, "{\\ensuremath{\\lnot}}" ],
 [ 173, "{\\-}" ],
 [ 174, "{\\textregistered}" ],
 [ 175, "{\\a={\\empty}" ],
 [ 176, "{\\textdegree}" ],
 [ 177, "{\\ensuremath{\\pm}}" ],
 [ 178, "{\\textsuperscript2}" ],
 [ 179, "{\\textsuperscript3}" ],
 [ 180, "{\\a'{\\empty}" ],
 [ 181, "{\\ensuremath{\\mu}}" ],
 [ 182, "{\\P}" ],
 [ 183, "{\\textperiodcentered}" ],
 [ 184, "{\\c\\space}" ],
 [ 185, "{\\textsuperscript1}" ],
 [ 186, "{\\textordmasculine}" ],
 [ 187, "{\\guillemotright}" ],
 [ 188, "{\\textonequarter}" ],
 [ 189, "{\\textonehalf}" ],
 [ 190, "{\\textthreequarters}" ],
 [ 191, "{\\textquestiondown}" ],
 [ 192, "{\\a`A}" ],
 [ 193, "{\\a'A}" ],
 [ 194, "{\\^A}" ],
 [ 195, "{\\~A}" ],
 [ 196, "{\\\"A}" ],
 [ 197, "{\\r A}" ],
 [ 198, "{\\AE}" ],
 [ 199, "{\\c C}" ],
 [ 200, "{\\a`E}" ],
 [ 201, "{\\a'E}" ],
 [ 202, "{\\^E}" ],
 [ 203, "{\\\"E}" ],
 [ 204, "{\\a`I}" ],
 [ 205, "{\\a'I}" ],
 [ 206, "{\\^I}" ],
 [ 207, "{\\\"I}" ],
 [ 208, "{\\DH}" ],
 [ 209, "{\\~N}" ],
 [ 210, "{\\a`O}" ],
 [ 211, "{\\a'O}" ],
 [ 212, "{\\^O}" ],
 [ 213, "{\\~O}" ],
 [ 214, "{\\\"O}" ],
 [ 215, "{\\ensuremath{\\times}}" ],
 [ 216, "{\\O}" ],
 [ 217, "{\\a`U}" ],
 [ 218, "{\\a'U}" ],
 [ 219, "{\\^U}" ],
 [ 220, "{\\\"U}" ],
 [ 221, "{\\a'Y}" ],
 [ 222, "{\\TH}" ],
 [ 223, "{\\ss}" ],
 [ 224, "{\\a`a}" ],
 [ 225, "{\\a'a}" ],
 [ 226, "{\\^a}" ],
 [ 227, "{\\~a}" ],
 [ 228, "{\\\"a}" ],
 [ 229, "{\\r a}" ],
 [ 230, "{\\ae}" ],
 [ 231, "{\\c c}" ],
 [ 232, "{\\a`e}" ],
 [ 233, "{\\a'e}" ],
 [ 234, "{\\^e}" ],
 [ 235, "{\\\"e}" ],
 [ 236, "{\\a`\\i}" ],
 [ 237, "{\\a'\\i}" ],
 [ 238, "{\\^\\i}" ],
 [ 239, "{\\\"\\i}" ],
 [ 240, "{\\dh}" ],
 [ 241, "{\\~n}" ],
 [ 242, "{\\a`o}" ],
 [ 243, "{\\a'o}" ],
 [ 244, "{\\^o}" ],
 [ 245, "{\\~o}" ],
 [ 246, "{\\\"o}" ],
 [ 247, "{\\ensuremath{\\div}}" ],
 [ 248, "{\\o}" ],
 [ 249, "{\\a`u}" ],
 [ 250, "{\\a'u}" ],
 [ 251, "{\\^u}" ],
 [ 252, "{\\\"u}" ],
 [ 253, "{\\a'y}" ],
 [ 254, "{\\th}" ],
 [ 255, "{\\\"y}" ],
 [ 256, "{\\a=A}" ],
 [ 257, "{\\a=a}" ],
 [ 258, "{\\u A}" ],
 [ 259, "{\\u a}" ],
 [ 260, "{\\k A}" ],
 [ 261, "{\\k a}" ],
 [ 262, "{\\a'C}" ],
 [ 263, "{\\a'c}" ],
 [ 264, "{\\^C}" ],
 [ 265, "{\\^c}" ],
 [ 266, "{\\.C}" ],
 [ 267, "{\\.c}" ],
 [ 268, "{\\v C}" ],
 [ 269, "{\\v c}" ],
 [ 270, "{\\v D}" ],
 [ 271, "{\\v d}" ],
 [ 272, "{\\DJ}" ],
 [ 273, "{\\dj}" ],
 [ 274, "{\\a=E}" ],
 [ 275, "{\\a=e}" ],
 [ 276, "{\\u E}" ],
 [ 277, "{\\u e}" ],
 [ 278, "{\\.E}" ],
 [ 279, "{\\.e}" ],
 [ 280, "{\\k E}" ],
 [ 281, "{\\k e}" ],
 [ 282, "{\\v E}" ],
 [ 283, "{\\v e}" ],
 [ 284, "{\\^G}" ],
 [ 285, "{\\^g}" ],
 [ 286, "{\\u G}" ],
 [ 287, "{\\u g}" ],
 [ 288, "{\\.G}" ],
 [ 289, "{\\.g}" ],
 [ 290, "{\\c G}" ],
 [ 292, "{\\^H}" ],
 [ 293, "{\\^h}" ],
 [ 295, "{\\ensuremath{\\hbar}}" ],
 [ 296, "{\\~I}" ],
 [ 297, "{\\~\\i}" ],
 [ 298, "{\\a=I}" ],
 [ 299, "{\\a=\\i}" ],
 [ 300, "{\\u I}" ],
 [ 301, "{\\u\\i}" ],
 [ 302, "{\\k I}" ],
 [ 303, "{\\k i}" ],
 [ 304, "{\\.I}" ],
 [ 305, "{\\i}" ],
 [ 308, "{\\^J}" ],
 [ 309, "{\\^\\j}" ],
 [ 310, "{\\c K}" ],
 [ 311, "{\\c k}" ],
 [ 313, "{\\a'L}" ],
 [ 314, "{\\a'l}" ],
 [ 315, "{\\c L}" ],
 [ 316, "{\\c l}" ],
 [ 317, "{\\v L}" ],
 [ 318, "{\\v l}" ],
 [ 321, "{\\L}" ],
 [ 322, "{\\l}" ],
 [ 323, "{\\a'N}" ],
 [ 324, "{\\a'n}" ],
 [ 325, "{\\c N}" ],
 [ 326, "{\\c n}" ],
 [ 327, "{\\v N}" ],
 [ 328, "{\\v n}" ],
 [ 330, "{\\NG}" ],
 [ 331, "{\\ng}" ],
 [ 332, "{\\a=O}" ],
 [ 333, "{\\a=o}" ],
 [ 334, "{\\u O}" ],
 [ 335, "{\\u o}" ],
 [ 336, "{\\H O}" ],
 [ 337, "{\\H o}" ],
 [ 338, "{\\OE}" ],
 [ 339, "{\\oe}" ],
 [ 340, "{\\a'R}" ],
 [ 341, "{\\a'r}" ],
 [ 342, "{\\c R}" ],
 [ 343, "{\\c r}" ],
 [ 344, "{\\v R}" ],
 [ 345, "{\\v r}" ],
 [ 346, "{\\a'S}" ],
 [ 347, "{\\a's}" ],
 [ 348, "{\\^S}" ],
 [ 349, "{\\^s}" ],
 [ 350, "{\\c S}" ],
 [ 351, "{\\c s}" ],
 [ 352, "{\\v S}" ],
 [ 353, "{\\v s}" ],
 [ 354, "{\\c T}" ],
 [ 355, "{\\c t}" ],
 [ 356, "{\\v T}" ],
 [ 357, "{\\v t}" ],
 [ 358, "{\\ensuremath{\\bar{\\mathrm{T}}}}" ],
 [ 359, "{\\ensuremath{\\bar{\\mathrm{t}}}}" ],
 [ 360, "{\\~U}" ],
 [ 361, "{\\~u}" ],
 [ 362, "{\\a=U}" ],
 [ 363, "{\\a=u}" ],
 [ 364, "{\\u U}" ],
 [ 365, "{\\u u}" ],
 [ 366, "{\\r U}" ],
 [ 367, "{\\r u}" ],
 [ 368, "{\\H U}" ],
 [ 369, "{\\H u}" ],
 [ 370, "{\\k U}" ],
 [ 371, "{\\k u}" ],
 [ 372, "{\\^W}" ],
 [ 373, "{\\^w}" ],
 [ 374, "{\\^Y}" ],
 [ 375, "{\\^y}" ],
 [ 376, "{\\\"Y}" ],
 [ 377, "{\\a'Z}" ],
 [ 378, "{\\a'z}" ],
 [ 379, "{\\.Z}" ],
 [ 380, "{\\.z}" ],
 [ 381, "{\\v Z}" ],
 [ 382, "{\\v z}" ],
 [ 461, "{\\v A}" ],
 [ 462, "{\\v a}" ],
 [ 463, "{\\v I}" ],
 [ 464, "{\\v\\i}" ],
 [ 465, "{\\v O}" ],
 [ 466, "{\\v o}" ],
 [ 467, "{\\v U}" ],
 [ 468, "{\\v u}" ],
 [ 469, "{\\a={\\\"U}" ],
 [ 470, "{\\a={\\\"u}" ],
 [ 471, "{\\a'{\\\"U}" ],
 [ 472, "{\\a'{\\\"u}" ],
 [ 473, "{\\v{\\\"U}" ],
 [ 474, "{\\v{\\\"u}" ],
 [ 475, "{\\a`{\\\"U}" ],
 [ 476, "{\\a`{\\\"u}" ],
 [ 478, "{\\a={\\\"A}" ],
 [ 479, "{\\a={\\\"a}" ],
 [ 482, "{\\a=\\AE}" ],
 [ 483, "{\\a=\\ae}" ],
 [ 486, "{\\v G}" ],
 [ 487, "{\\v g}" ],
 [ 488, "{\\v K}" ],
 [ 489, "{\\v k}" ],
 [ 490, "{\\k O}" ],
 [ 491, "{\\k o}" ],
 [ 496, "{\\v\\j}" ],
 [ 500, "{\\a'G}" ],
 [ 501, "{\\a'g}" ],
 [ 504, "{\\a`N}" ],
 [ 505, "{\\a`n}" ],
 [ 506, "{\\a'{\\r A}" ],
 [ 507, "{\\a'{\\r a}" ],
 [ 508, "{\\a'\\AE}" ],
 [ 509, "{\\a'\\ae}" ],
 [ 510, "{\\a'\\O}" ],
 [ 511, "{\\a'\\o}" ],
 [ 542, "{\\v H}" ],
 [ 543, "{\\v h}" ],
 [ 550, "{\\.A}" ],
 [ 551, "{\\.a}" ],
 [ 552, "{\\c E}" ],
 [ 553, "{\\c e}" ],
 [ 554, "{\\a={\\\"O}" ],
 [ 555, "{\\a={\\\"o}" ],
 [ 556, "{\\a={\\~O}" ],
 [ 557, "{\\a={\\~o}" ],
 [ 558, "{\\.O}" ],
 [ 559, "{\\.o}" ],
 [ 562, "{\\a=Y}" ],
 [ 563, "{\\a=y}" ],
 [ 697, "{\\ensuremath{'}}" ],
 [ 698, "{\\ensuremath{''}}" ],
 [ 699, "{\\ensuremath{'''}}" ],
 [ 913, "{\\ensuremath\\Alpha}" ],
 [ 914, "{\\ensuremath\\Beta}" ],
 [ 915, "{\\ensuremath\\Gamma}" ],
 [ 916, "{\\ensuremath\\Delta}" ],
 [ 917, "{\\ensuremath\\Epsilon}" ],
 [ 918, "{\\ensuremath\\Zeta}" ],
 [ 919, "{\\ensuremath\\Eta}" ],
 [ 920, "{\\ensuremath\\Theta}" ],
 [ 921, "{\\ensuremath\\Iota}" ],
 [ 922, "{\\ensuremath\\Kappa}" ],
 [ 923, "{\\ensuremath\\Lambda}" ],
 [ 924, "{\\ensuremath\\Mu}" ],
 [ 925, "{\\ensuremath\\Nu}" ],
 [ 926, "{\\ensuremath\\Xi}" ],
 [ 927, "{\\ensuremath\\Omicron}" ],
 [ 928, "{\\ensuremath\\Pi}" ],
 [ 929, "{\\ensuremath\\Rho}" ],
 [ 931, "{\\ensuremath\\Sigma}" ],
 [ 932, "{\\ensuremath\\Tau}" ],
 [ 933, "{\\ensuremath\\Upsilon}" ],
 [ 934, "{\\ensuremath\\Phi}" ],
 [ 935, "{\\ensuremath\\Chi}" ],
 [ 936, "{\\ensuremath\\Psi}" ],
 [ 937, "{\\ensuremath\\Omega}" ],
 [ 945, "{\\ensuremath\\alpha}" ],
 [ 946, "{\\ensuremath\\beta}" ],
 [ 947, "{\\ensuremath\\gamma}" ],
 [ 948, "{\\ensuremath\\delta}" ],
 [ 949, "{\\ensuremath\\varepsilon}" ],
 [ 950, "{\\ensuremath\\zeta}" ],
 [ 951, "{\\ensuremath\\eta}" ],
 [ 952, "{\\ensuremath\\theta}" ],
 [ 953, "{\\ensuremath\\iota}" ],
 [ 954, "{\\ensuremath\\kappa}" ],
 [ 955, "{\\ensuremath\\lambda}" ],
 [ 956, "{\\ensuremath\\mu}" ],
 [ 957, "{\\ensuremath\\nu}" ],
 [ 958, "{\\ensuremath\\xi}" ],
 [ 959, "{\\ensuremath\\omicron}" ],
 [ 960, "{\\ensuremath\\pi}" ],
 [ 961, "{\\ensuremath\\rho}" ],
 [ 962, "{\\ensuremath\\varsigma}" ],
 [ 963, "{\\ensuremath\\sigma}" ],
 [ 964, "{\\ensuremath\\tau}" ],
 [ 965, "{\\ensuremath\\upsilon}" ],
 [ 966, "{\\ensuremath\\varphi}" ],
 [ 967, "{\\ensuremath\\chi}" ],
 [ 968, "{\\ensuremath\\psi}" ],
 [ 969, "{\\ensuremath\\omega}" ],
 [ 977, "{\\ensuremath\\vartheta}" ],
 [ 981, "{\\ensuremath\\phi}" ],
 [ 982, "{\\ensuremath\\varpi}" ],
 [ 1008, "{\\ensuremath\\varkappa}" ],
 [ 1009, "{\\ensuremath\\varrho}" ],
 [ 1013, "{\\ensuremath\\epsilon}" ],
 [ 1014, "{\\ensuremath\\backepsilon}" ],
 [ 7682, "{\\.B}" ],
 [ 7683, "{\\.b}" ],
 [ 7684, "{\\d B}" ],
 [ 7685, "{\\d b}" ],
 [ 7686, "{\\b B}" ],
 [ 7687, "{\\b b}" ],
 [ 7690, "{\\.D}" ],
 [ 7691, "{\\.d}" ],
 [ 7692, "{\\d D}" ],
 [ 7693, "{\\d d}" ],
 [ 7694, "{\\b D}" ],
 [ 7695, "{\\b d}" ],
 [ 7696, "{\\c D}" ],
 [ 7697, "{\\c d}" ],
 [ 7710, "{\\.F}" ],
 [ 7711, "{\\.f}" ],
 [ 7712, "{\\a=G}" ],
 [ 7713, "{\\a=g}" ],
 [ 7714, "{\\.H}" ],
 [ 7715, "{\\.h}" ],
 [ 7716, "{\\d H}" ],
 [ 7717, "{\\d h}" ],
 [ 7718, "{\\\"H}" ],
 [ 7719, "{\\\"h}" ],
 [ 7720, "{\\c H}" ],
 [ 7721, "{\\c h}" ],
 [ 7728, "{\\a'K}" ],
 [ 7729, "{\\a'k}" ],
 [ 7730, "{\\d K}" ],
 [ 7731, "{\\d k}" ],
 [ 7732, "{\\b K}" ],
 [ 7733, "{\\b k}" ],
 [ 7734, "{\\d L}" ],
 [ 7735, "{\\d l}" ],
 [ 7738, "{\\b L}" ],
 [ 7739, "{\\b l}" ],
 [ 7742, "{\\a'M}" ],
 [ 7743, "{\\a'm}" ],
 [ 7744, "{\\.M}" ],
 [ 7745, "{\\.m}" ],
 [ 7746, "{\\d M}" ],
 [ 7747, "{\\d m}" ],
 [ 7748, "{\\.N}" ],
 [ 7749, "{\\.n}" ],
 [ 7750, "{\\d N}" ],
 [ 7751, "{\\d n}" ],
 [ 7752, "{\\b N}" ],
 [ 7753, "{\\b n}" ],
 [ 7764, "{\\a'P}" ],
 [ 7765, "{\\a'p}" ],
 [ 7766, "{\\.P}" ],
 [ 7767, "{\\.p}" ],
 [ 7768, "{\\.R}" ],
 [ 7769, "{\\.r}" ],
 [ 7770, "{\\d R}" ],
 [ 7771, "{\\d r}" ],
 [ 7774, "{\\b R}" ],
 [ 7775, "{\\b r}" ],
 [ 7776, "{\\.S}" ],
 [ 7777, "{\\.s}" ],
 [ 7778, "{\\d S}" ],
 [ 7779, "{\\d s}" ],
 [ 7786, "{\\.T}" ],
 [ 7787, "{\\.t}" ],
 [ 7788, "{\\d T}" ],
 [ 7789, "{\\d t}" ],
 [ 7790, "{\\b T}" ],
 [ 7791, "{\\b t}" ],
 [ 7804, "{\\~V}" ],
 [ 7805, "{\\~v}" ],
 [ 7806, "{\\d V}" ],
 [ 7807, "{\\d v}" ],
 [ 7808, "{\\a`W}" ],
 [ 7809, "{\\a`w}" ],
 [ 7810, "{\\a'W}" ],
 [ 7811, "{\\a'w}" ],
 [ 7812, "{\\\"W}" ],
 [ 7813, "{\\\"w}" ],
 [ 7814, "{\\.W}" ],
 [ 7815, "{\\.w}" ],
 [ 7816, "{\\d W}" ],
 [ 7817, "{\\d w}" ],
 [ 7818, "{\\.X}" ],
 [ 7819, "{\\.x}" ],
 [ 7820, "{\\\"X}" ],
 [ 7821, "{\\\"x}" ],
 [ 7822, "{\\.Y}" ],
 [ 7823, "{\\.y}" ],
 [ 7824, "{\\^Z}" ],
 [ 7825, "{\\^z}" ],
 [ 7826, "{\\d Z}" ],
 [ 7827, "{\\d z}" ],
 [ 7828, "{\\b Z}" ],
 [ 7829, "{\\b z}" ],
 [ 7830, "{\\b h}" ],
 [ 7831, "{\\\"t}" ],
 [ 7832, "{\\r w}" ],
 [ 7833, "{\\r y}" ],
 [ 7840, "{\\d A}" ],
 [ 7841, "{\\d a}" ],
 [ 7864, "{\\d E}" ],
 [ 7865, "{\\d e}" ],
 [ 7868, "{\\~E}" ],
 [ 7869, "{\\~e}" ],
 [ 7882, "{\\d I}" ],
 [ 7883, "{\\d i}" ],
 [ 7884, "{\\d O}" ],
 [ 7885, "{\\d o}" ],
 [ 7908, "{\\d U}" ],
 [ 7909, "{\\d u}" ],
 [ 7922, "{\\a`Y}" ],
 [ 7923, "{\\a`y}" ],
 [ 7924, "{\\d Y}" ],
 [ 7925, "{\\d y}" ],
 [ 7928, "{\\~Y}" ],
 [ 7929, "{\\~y}" ],
 [ 8192, "{\\enskip}" ],
 [ 8193, "{\\quad}" ],
 [ 8194, "{\\enskip}" ],
 [ 8195, "{\\quad}" ],
 [ 8201, "{\\thinspace}" ],
 [ 8203, "" ],
 [ 8208, "{-}" ],
 [ 8211, "{\\textendash}" ],
 [ 8212, "{\\textemdash}" ],
 [ 8216, "{\\textquoteleft}" ],
 [ 8217, "{\\textquoteright}" ],
 [ 8218, "{\\quotesinglbase}" ],
 [ 8220, "{\\textquotedblleft}" ],
 [ 8221, "{\\textquotedblright}" ],
 [ 8222, "{\\quotedblbase}" ],
 [ 8224, "{\\dag}" ],
 [ 8225, "{\\ddag}" ],
 [ 8226, "{\\textbullet}" ],
 [ 8230, "{\\dots}" ],
 [ 8232, "{\\leavevmode\\newline}" ],
 [ 8240, "{\\textperthousand}" ],
 [ 8241, "{\\textpertenthousand}" ],
 [ 8242, "{\\ensuremath{^\\prime}}" ],
 [ 8243, "{\\ensuremath{^{\\prime\\prime}}" ],
 [ 8244, "{\\ensuremath{^{\\prime\\prime\\prime}}" ],
 [ 8249, "{\\guilsinglleft}" ],
 [ 8250, "{\\guilsinglright}" ],
 [ 8251, "{\\textreferencemark}" ],
 [ 8253, "{\\textinterrobang}" ],
 [ 8304, "{\\textsuperscript0}" ],
 [ 8305, "{\\textsuperscript i}" ],
 [ 8308, "{\\textsuperscript4}" ],
 [ 8309, "{\\textsuperscript5}" ],
 [ 8310, "{\\textsuperscript6}" ],
 [ 8311, "{\\textsuperscript7}" ],
 [ 8312, "{\\textsuperscript8}" ],
 [ 8313, "{\\textsuperscript9}" ],
 [ 8314, "{\\textsuperscript+}" ],
 [ 8315, "{\\textsuperscript-}" ],
 [ 8316, "{\\textsuperscript=}" ],
 [ 8317, "{\\textsuperscript(}" ],
 [ 8318, "{\\textsuperscript)}" ],
 [ 8319, "{\\textsuperscript n}" ],
 [ 8320, "{\\ensuremath{_0}}" ],
 [ 8321, "{\\ensuremath{_1}}" ],
 [ 8322, "{\\ensuremath{_2}}" ],
 [ 8323, "{\\ensuremath{_3}}" ],
 [ 8324, "{\\ensuremath{_4}}" ],
 [ 8325, "{\\ensuremath{_5}}" ],
 [ 8326, "{\\ensuremath{_6}}" ],
 [ 8327, "{\\ensuremath{_7}}" ],
 [ 8328, "{\\ensuremath{_8}}" ],
 [ 8329, "{\\ensuremath{_9}}" ],
 [ 8330, "{\\ensuremath{_+}}" ],
 [ 8331, "{\\ensuremath{_-}}" ],
 [ 8332, "{\\ensuremath{_=}}" ],
 [ 8333, "{\\ensuremath{_(}}" ],
 [ 8334, "{\\ensuremath{_)}}" ],
 [ 8353, "{\\textcolonmonetary}" ],
 [ 8356, "{\\textlira}" ],
 [ 8358, "{\\textnaira}" ],
 [ 8361, "{\\textwon}" ],
 [ 8363, "{\\textdong}" ],
 [ 8364, "{\\ifx\\euro\\undefined\\texteuro\\else\\euro\\fi}" ],
 [ 8450, "{\\ensuremath{\\mathbb C}}" ],
 [ 8451, "{\\ensuremath\\degreeC}" ],
 [ 8457, "{\\ensuremath\\degreeF}" ],
 [ 8460, "{\\ensuremath{\\mathfrak H}}" ],
 [ 8461, "{\\ensuremath{\\mathbb H}}" ],
 [ 8462, "{\\ensuremath{\\mathit h}}" ],
 [ 8463, "{\\ensuremath{\\hbar}}" ],
 [ 8465, "{\\ensuremath{\\Im}}" ],
 [ 8467, "{\\ensuremath{\\ell}}" ],
 [ 8469, "{\\ensuremath{\\mathbb N}}" ],
 [ 8470, "{\\textnumero}" ],
 [ 8472, "{\\ensuremath{\\wp}}" ],
 [ 8473, "{\\ensuremath{\\mathbb P}}" ],
 [ 8474, "{\\ensuremath{\\mathbb Q}}" ],
 [ 8476, "{\\ensuremath{\\Re}}" ],
 [ 8477, "{\\ensuremath{\\mathbb R}}" ],
 [ 8480, "{\\textsuperscript{SM}}" ],
 [ 8482, "{\\texttrademark}" ],
 [ 8484, "{\\ensuremath{\\mathbb Z}}" ],
 [ 8486, "{\\ensuremath{\\Omega}}" ],
 [ 8487, "{\\ensuremath{\\mho}}" ],
 [ 8488, "{\\ensuremath{\\mathfrak Z}}" ],
 [ 8490, "{\\ensuremath{\\mathrm K}}" ],
 [ 8491, "{\\ensuremath\\Angstrom}" ],
 [ 8493, "{\\ensuremath{\\mathfrak C}}" ],
 [ 8498, "{\\ensuremath\\Finv}" ],
 [ 8500, "{\\ensuremath{o}}" ],
 [ 8501, "{\\ensuremath\\aleph}" ],
 [ 8502, "{\\ensuremath\\beth}" ],
 [ 8503, "{\\ensuremath\\gimel}" ],
 [ 8504, "{\\ensuremath\\daleth}" ],
 [ 8544, "{\\ensuremath\\romannumI}" ],
 [ 8545, "{\\ensuremath\\romannumII}" ],
 [ 8546, "{\\ensuremath\\romannumIII}" ],
 [ 8547, "{\\ensuremath\\romannumIV}" ],
 [ 8548, "{\\ensuremath\\romannumV}" ],
 [ 8549, "{\\ensuremath\\romannumVI}" ],
 [ 8550, "{\\ensuremath\\romannumVII}" ],
 [ 8551, "{\\ensuremath\\romannumVIII}" ],
 [ 8552, "{\\ensuremath\\romannumIX}" ],
 [ 8553, "{\\ensuremath\\romannumX}" ],
 [ 8554, "{\\ensuremath\\romannumXI}" ],
 [ 8555, "{\\ensuremath\\romannumXII}" ],
 [ 8556, "{\\ensuremath\\romannumL}" ],
 [ 8557, "{\\ensuremath\\romannumC}" ],
 [ 8558, "{\\ensuremath\\romannumD}" ],
 [ 8559, "{\\ensuremath\\romannumM}" ],
 [ 8560, "{\\ensuremath\\romannumi}" ],
 [ 8561, "{\\ensuremath\\romannumii}" ],
 [ 8562, "{\\ensuremath\\romannumiii}" ],
 [ 8563, "{\\ensuremath\\romannumiv}" ],
 [ 8564, "{\\ensuremath\\romannumv}" ],
 [ 8565, "{\\ensuremath\\romannumvi}" ],
 [ 8566, "{\\ensuremath\\romannumvii}" ],
 [ 8567, "{\\ensuremath\\romannumviii}" ],
 [ 8568, "{\\ensuremath\\romannumix}" ],
 [ 8569, "{\\ensuremath\\romannumx}" ],
 [ 8570, "{\\ensuremath\\romannumxi}" ],
 [ 8571, "{\\ensuremath\\romannumxii}" ],
 [ 8572, "{\\ensuremath\\romannuml}" ],
 [ 8573, "{\\ensuremath\\romannumc}" ],
 [ 8574, "{\\ensuremath\\romannumd}" ],
 [ 8575, "{\\ensuremath\\romannumm}" ],
 [ 8592, "{\\ensuremath{\\leftarrow}}" ],
 [ 8593, "{\\ensuremath{\\uparrow}}" ],
 [ 8594, "{\\ensuremath{\\rightarrow}}" ],
 [ 8595, "{\\ensuremath{\\downarrow}}" ],
 [ 8596, "{\\ensuremath{\\leftrightarrow}}" ],
 [ 8597, "{\\ensuremath{\\updownarrow}}" ],
 [ 8598, "{\\ensuremath\\nwarrow}" ],
 [ 8599, "{\\ensuremath\\nearrow}" ],
 [ 8600, "{\\ensuremath\\searrow}" ],
 [ 8601, "{\\ensuremath\\swarrow}" ],
 [ 8602, "{\\ensuremath\\nleftarrow}" ],
 [ 8603, "{\\ensuremath\\nrightarrow}" ],
 [ 8605, "{\\ensuremath\\leadsto}" ],
 [ 8606, "{\\ensuremath\\twoheadleftarrow}" ],
 [ 8608, "{\\ensuremath\\twoheadrightarrow}" ],
 [ 8610, "{\\ensuremath\\leftarrowtail}" ],
 [ 8611, "{\\ensuremath\\rightarrowtail}" ],
 [ 8614, "{\\ensuremath\\mapsto}" ],
 [ 8617, "{\\ensuremath\\hookleftarrow}" ],
 [ 8618, "{\\ensuremath\\hookrightarrow}" ],
 [ 8619, "{\\ensuremath\\looparrowright}" ],
 [ 8620, "{\\ensuremath\\looparrowleft}" ],
 [ 8622, "{\\ensuremath\\nleftrightarrow}" ],
 [ 8624, "{\\ensuremath\\Lsh}" ],
 [ 8625, "{\\ensuremath\\Rsh}" ],
 [ 8630, "{\\ensuremath\\curvearrowleft}" ],
 [ 8631, "{\\ensuremath\\curvearrowright}" ],
 [ 8634, "{\\ensuremath\\circlearrowleft}" ],
 [ 8635, "{\\ensuremath\\circlearrowright}" ],
 [ 8636, "{\\ensuremath\\leftharpoonup}" ],
 [ 8637, "{\\ensuremath\\leftharpoondown}" ],
 [ 8638, "{\\ensuremath\\upharpoonright}" ],
 [ 8639, "{\\ensuremath\\upharpoonleft}" ],
 [ 8640, "{\\ensuremath\\rightharpoonup}" ],
 [ 8641, "{\\ensuremath\\rightharpoondown}" ],
 [ 8642, "{\\ensuremath\\downharpoonright}" ],
 [ 8643, "{\\ensuremath\\downharpoonleft}" ],
 [ 8644, "{\\ensuremath\\rightleftarrows}" ],
 [ 8646, "{\\ensuremath\\leftrightarrows}" ],
 [ 8647, "{\\ensuremath\\leftleftarrows}" ],
 [ 8648, "{\\ensuremath\\upuparrows}" ],
 [ 8649, "{\\ensuremath\\rightrightarrows}" ],
 [ 8650, "{\\ensuremath\\downdownarrows}" ],
 [ 8651, "{\\ensuremath\\leftrightharpoons}" ],
 [ 8652, "{\\ensuremath{\\rightleftharpoons}}" ],
 [ 8653, "{\\ensuremath\\nLeftarrow}" ],
 [ 8654, "{\\ensuremath\\nLeftrightarrow}" ],
 [ 8655, "{\\ensuremath\\nRightarrow}" ],
 [ 8656, "{\\ensuremath\\Leftarrow}" ],
 [ 8657, "{\\ensuremath\\Uparrow}" ],
 [ 8658, "{\\ensuremath{\\Rightarrow}}" ],
 [ 8659, "{\\ensuremath\\Downarrow}" ],
 [ 8660, "{\\ensuremath{\\Leftrightarrow}}" ],
 [ 8661, "{\\ensuremath\\Updownarrow}" ],
 [ 8666, "{\\ensuremath\\Lleftarrow}" ],
 [ 8667, "{\\ensuremath\\Rrightarrow}" ],
 [ 8669, "{\\ensuremath\\rightsquigarrow}" ],
 [ 8672, "{\\ensuremath\\dashleftarrow}" ],
 [ 8674, "{\\ensuremath\\dashrightarrow}" ],
 [ 8704, "{\\ensuremath{\\forall}}" ],
 [ 8705, "{\\ensuremath\\complement}" ],
 [ 8706, "{\\ensuremath{\\partial}}" ],
 [ 8707, "{\\ensuremath{\\exists}}" ],
 [ 8708, "{\\ensuremath\\nexists}" ],
 [ 8709, "{\\ensuremath{\\emptyset}}" ],
 [ 8710, "{\\ensuremath{\\Delta}}" ],
 [ 8711, "{\\ensuremath{\\nabla}}" ],
 [ 8712, "{\\ensuremath{\\in}}" ],
 [ 8713, "{\\ensuremath{\\notin}}" ],
 [ 8715, "{\\ensuremath{\\ni}}" ],
 [ 8716, "{\\ensuremath{\\not\\ni}}" ],
 [ 8718, "{\\ensuremath\\blacksquare}" ],
 [ 8719, "{\\ensuremath{\\prod}}" ],
 [ 8720, "{\\ensuremath{\\coprod}}" ],
 [ 8721, "{\\ensuremath{\\sum}}" ],
 [ 8722, "{\\ensuremath{-}}" ],
 [ 8723, "{\\ensuremath{\\mp}}" ],
 [ 8724, "{\\ensuremath\\dotplus}" ],
 [ 8725, "{\\ensuremath{/}}" ],
 [ 8726, "{\\ensuremath{\\setminus}}" ],
 [ 8727, "{\\ensuremath{\\ast}}" ],
 [ 8728, "{\\ensuremath{\\circ}}" ],
 [ 8729, "{\\ensuremath{\\bullet}}" ],
 [ 8730, "{\\ensuremath{\\surd}}" ],
 [ 8733, "{\\ensuremath{\\propto}}" ],
 [ 8734, "{\\ensuremath{\\infty}}" ],
 [ 8736, "{\\ensuremath{\\angle}}" ],
 [ 8737, "{\\ensuremath\\measuredangle}" ],
 [ 8738, "{\\ensuremath\\sphericalangle}" ],
 [ 8739, "{\\ensuremath{\\mid}}" ],
 [ 8740, "{\\ensuremath\\nmid}" ],
 [ 8741, "{\\ensuremath{\\parallel}}" ],
 [ 8742, "{\\ensuremath\\nparallel}" ],
 [ 8743, "{\\ensuremath{\\wedge}}" ],
 [ 8744, "{\\ensuremath{\\vee}}" ],
 [ 8745, "{\\ensuremath{\\cap}}" ],
 [ 8746, "{\\ensuremath{\\cup}}" ],
 [ 8747, "{\\ensuremath{\\int}}" ],
 [ 8748, "{\\ensuremath\\iint}" ],
 [ 8749, "{\\ensuremath\\iiint}" ],
 [ 8750, "{\\ensuremath{\\oint}}" ],
 [ 8756, "{\\ensuremath\\therefore}" ],
 [ 8757, "{\\ensuremath\\because}" ],
 [ 8758, "{\\ensuremath{:}}" ],
 [ 8764, "{\\ensuremath{\\sim}}" ],
 [ 8765, "{\\ensuremath\\backsim}" ],
 [ 8768, "{\\ensuremath{\\wr}}" ],
 [ 8769, "{\\ensuremath\\nsim}" ],
 [ 8771, "{\\ensuremath{\\simeq}}" ],
 [ 8772, "{\\ensuremath{\\not\\simeq}}" ],
 [ 8773, "{\\ensuremath{\\cong}}" ],
 [ 8775, "{\\ensuremath\\ncong}" ],
 [ 8776, "{\\ensuremath{\\approx}}" ],
 [ 8777, "{\\ensuremath{\\not\\approx}}" ],
 [ 8778, "{\\ensuremath\\approxeq}" ],
 [ 8781, "{\\ensuremath{\\asymp}}" ],
 [ 8782, "{\\ensuremath\\Bumpeq}" ],
 [ 8783, "{\\ensuremath\\bumpeq}" ],
 [ 8784, "{\\ensuremath{\\doteq}}" ],
 [ 8785, "{\\ensuremath\\doteqdot}" ],
 [ 8786, "{\\ensuremath\\fallingdotseq}" ],
 [ 8787, "{\\ensuremath\\risingdotseq}" ],
 [ 8790, "{\\ensuremath\\eqcirc}" ],
 [ 8791, "{\\ensuremath\\circeq}" ],
 [ 8796, "{\\ensuremath\\triangleq}" ],
 [ 8800, "{\\ensuremath{\\neq}}" ],
 [ 8801, "{\\ensuremath{\\equiv}}" ],
 [ 8802, "{\\ensuremath{\\not\\equiv}}" ],
 [ 8804, "{\\ensuremath{\\leq}}" ],
 [ 8805, "{\\ensuremath{\\geq}}" ],
 [ 8806, "{\\ensuremath\\leqq}" ],
 [ 8807, "{\\ensuremath\\geqq}" ],
 [ 8808, "{\\ensuremath\\lneqq}" ],
 [ 8809, "{\\ensuremath\\gneqq}" ],
 [ 8810, "{\\ensuremath{\\ll}}" ],
 [ 8811, "{\\ensuremath{\\gg}}" ],
 [ 8812, "{\\ensuremath\\between}" ],
 [ 8813, "{\\ensuremath{\\not\\asymp}}" ],
 [ 8814, "{\\ensuremath\\nless}" ],
 [ 8815, "{\\ensuremath\\ngtr}" ],
 [ 8816, "{\\ensuremath\\nleq}" ],
 [ 8817, "{\\ensuremath\\ngeq}" ],
 [ 8818, "{\\ensuremath\\lesssim}" ],
 [ 8819, "{\\ensuremath\\gtrsim}" ],
 [ 8820, "{\\ensuremath{\\not\\lesssim}}" ],
 [ 8821, "{\\ensuremath{\\not\\gtrsim}}" ],
 [ 8822, "{\\ensuremath\\lessgtr}" ],
 [ 8823, "{\\ensuremath\\gtrless}" ],
 [ 8826, "{\\ensuremath{\\prec}}" ],
 [ 8827, "{\\ensuremath{\\succ}}" ],
 [ 8828, "{\\ensuremath\\preccurlyeq}" ],
 [ 8829, "{\\ensuremath\\succcurlyeq}" ],
 [ 8830, "{\\ensuremath\\precsim}" ],
 [ 8831, "{\\ensuremath\\succsim}" ],
 [ 8832, "{\\ensuremath\\nprec}" ],
 [ 8833, "{\\ensuremath\\nsucc}" ],
 [ 8834, "{\\ensuremath{\\subset}}" ],
 [ 8835, "{\\ensuremath{\\supset}}" ],
 [ 8836, "{\\ensuremath{\\not\\subset}}" ],
 [ 8837, "{\\ensuremath{\\not\\supset}}" ],
 [ 8838, "{\\ensuremath{\\subseteq}}" ],
 [ 8839, "{\\ensuremath{\\supseteq}}" ],
 [ 8840, "{\\ensuremath\\nsubseteq}" ],
 [ 8841, "{\\ensuremath\\nsupseteq}" ],
 [ 8842, "{\\ensuremath\\subsetneq}" ],
 [ 8843, "{\\ensuremath\\supsetneq}" ],
 [ 8846, "{\\ensuremath{\\uplus}}" ],
 [ 8847, "{\\ensuremath\\sqsubset}" ],
 [ 8848, "{\\ensuremath\\sqsupset}" ],
 [ 8849, "{\\ensuremath{\\sqsubseteq}}" ],
 [ 8850, "{\\ensuremath{\\sqsupseteq}}" ],
 [ 8851, "{\\ensuremath{\\sqcap}}" ],
 [ 8852, "{\\ensuremath{\\sqcup}}" ],
 [ 8853, "{\\ensuremath{\\oplus}}" ],
 [ 8854, "{\\ensuremath{\\ominus}}" ],
 [ 8855, "{\\ensuremath{\\otimes}}" ],
 [ 8856, "{\\ensuremath{\\oslash}}" ],
 [ 8857, "{\\ensuremath{\\odot}}" ],
 [ 8858, "{\\ensuremath\\circledcirc}" ],
 [ 8859, "{\\ensuremath\\circledast}" ],
 [ 8861, "{\\ensuremath\\circleddash}" ],
 [ 8862, "{\\ensuremath\\boxplus}" ],
 [ 8863, "{\\ensuremath\\boxminus}" ],
 [ 8864, "{\\ensuremath\\boxtimes}" ],
 [ 8865, "{\\ensuremath\\boxdot}" ],
 [ 8866, "{\\ensuremath{\\vdash}}" ],
 [ 8867, "{\\ensuremath{\\dashv}}" ],
 [ 8868, "{\\ensuremath{\\top}}" ],
 [ 8869, "{\\ensuremath{\\bot}}" ],
 [ 8871, "{\\ensuremath\\models}" ],
 [ 8873, "{\\ensuremath\\Vdash}" ],
 [ 8874, "{\\ensuremath\\Vvdash}" ],
 [ 8876, "{\\ensuremath\\nvdash}" ],
 [ 8877, "{\\ensuremath\\nvDash}" ],
 [ 8878, "{\\ensuremath\\nVdash}" ],
 [ 8879, "{\\ensuremath\\nVDash}" ],
 [ 8882, "{\\ensuremath\\lhd}" ],
 [ 8883, "{\\ensuremath\\rhd}" ],
 [ 8884, "{\\ensuremath\\unlhd}" ],
 [ 8885, "{\\ensuremath\\unrhd}" ],
 [ 8888, "{\\ensuremath\\multimap}" ],
 [ 8890, "{\\ensuremath\\intercal}" ],
 [ 8891, "{\\ensuremath\\veebar}" ],
 [ 8892, "{\\ensuremath\\barwedge}" ],
 [ 8896, "{\\ensuremath{\\bigwedge}}" ],
 [ 8897, "{\\ensuremath{\\bigvee}}" ],
 [ 8898, "{\\ensuremath{\\bigcap}}" ],
 [ 8899, "{\\ensuremath{\\bigcup}}" ],
 [ 8900, "{\\ensuremath{\\diamond}}" ],
 [ 8901, "{\\ensuremath{\\cdot}}" ],
 [ 8902, "{\\ensuremath{\\star}}" ],
 [ 8903, "{\\ensuremath\\divideontimes}" ],
 [ 8904, "{\\ensuremath{\\bowtie}}" ],
 [ 8905, "{\\ensuremath\\ltimes}" ],
 [ 8906, "{\\ensuremath\\rtimes}" ],
 [ 8907, "{\\ensuremath\\leftthreetimes}" ],
 [ 8908, "{\\ensuremath\\rightthreetimes}" ],
 [ 8909, "{\\ensuremath\\backsimeq}" ],
 [ 8910, "{\\ensuremath\\curlyvee}" ],
 [ 8911, "{\\ensuremath\\curlywedge}" ],
 [ 8912, "{\\ensuremath\\Subset}" ],
 [ 8913, "{\\ensuremath\\Supset}" ],
 [ 8914, "{\\ensuremath\\Cap}" ],
 [ 8915, "{\\ensuremath\\Cup}" ],
 [ 8916, "{\\ensuremath\\pitchfork}" ],
 [ 8918, "{\\ensuremath\\lessdot}" ],
 [ 8919, "{\\ensuremath\\gtrdot}" ],
 [ 8920, "{\\ensuremath\\lll}" ],
 [ 8921, "{\\ensuremath\\ggg}" ],
 [ 8922, "{\\ensuremath\\lesseqgtr}" ],
 [ 8923, "{\\ensuremath\\gtreqless}" ],
 [ 8926, "{\\ensuremath\\curlyeqprec}" ],
 [ 8927, "{\\ensuremath\\curlyeqsucc}" ],
 [ 8928, "{\\ensuremath{\\not\\preccurlyeq}}" ],
 [ 8929, "{\\ensuremath{\\not\\succcurlyeq}}" ],
 [ 8930, "{\\ensuremath{\\not\\sqsubseteq}}" ],
 [ 8931, "{\\ensuremath{\\not\\sqsupseteq}}" ],
 [ 8934, "{\\ensuremath\\lnsim}" ],
 [ 8935, "{\\ensuremath\\gnsim}" ],
 [ 8936, "{\\ensuremath\\precnsim}" ],
 [ 8937, "{\\ensuremath\\succnsim}" ],
 [ 8938, "{\\ensuremath\\ntriangleleft}" ],
 [ 8939, "{\\ensuremath\\ntriangleright}" ],
 [ 8940, "{\\ensuremath\\ntrianglelefteq}" ],
 [ 8941, "{\\ensuremath\\ntrianglerighteq}" ],
 [ 8942, "{\\ensuremath{\\vdots}}" ],
 [ 8943, "{\\ensuremath{\\cdots}}" ],
 [ 8945, "{\\ensuremath{\\ddots}}" ],
 [ 8960, "{\\ensuremath\\varemptyset}" ],
 [ 8968, "{\\ensuremath{\\lceil}}" ],
 [ 8969, "{\\ensuremath{\\rceil}}" ],
 [ 8970, "{\\ensuremath{\\lfloor}}" ],
 [ 8971, "{\\ensuremath{\\rfloor}}" ],
 [ 8988, "{\\ensuremath\\ulcorner}" ],
 [ 8989, "{\\ensuremath\\urcorner}" ],
 [ 8990, "{\\ensuremath\\llcorner}" ],
 [ 8991, "{\\ensuremath\\lrcorner}" ],
 [ 8994, "{\\ensuremath\\frown}" ],
 [ 8995, "{\\ensuremath\\smile}" ],
 [ 9633, "{\\ensuremath\\Box}" ],
 [ 9651, "{\\ensuremath\\bigtriangleup}" ],
 [ 9657, "{\\ensuremath\\triangleright}" ],
 [ 9661, "{\\ensuremath\\bigtriangledown}" ],
 [ 9667, "{\\ensuremath\\triangleleft}" ],
 [ 9671, "{\\ensuremath\\Diamond}" ],
 [ 9674, "{\\ensuremath\\lozenge}" ],
 [ 9824, "{\\ensuremath{\\spadesuit}}" ],
 [ 9825, "{\\ensuremath{\\heartsuit}}" ],
 [ 9826, "{\\ensuremath{\\diamondsuit}}" ],
 [ 9827, "{\\ensuremath{\\clubsuit}}" ],
 [ 9837, "{\\ensuremath{\\flat}}" ],
 [ 9838, "{\\ensuremath{\\natural}}" ],
 [ 9839, "{\\ensuremath{\\sharp}}" ],
 [ 10216, "{\\ensuremath{\\langle}}" ],
 [ 10217, "{\\ensuremath{\\rangle}}" ],
 [ 10229, "{\\ensuremath\\longleftarrow}" ],
 [ 10230, "{\\ensuremath\\longrightarrow}" ],
 [ 10231, "{\\ensuremath\\longleftrightarrow}" ],
 [ 10232, "{\\ensuremath\\Longleftarrow}" ],
 [ 10233, "{\\ensuremath\\Longrightarrow}" ],
 [ 10234, "{\\ensuremath\\Longleftrightarrow}" ],
 [ 10731, "{\\ensuremath\\blacklozenge}" ],
 [ 10752, "{\\ensuremath\\bigodot}" ],
 [ 10753, "{\\ensuremath\\bigoplus}" ],
 [ 10754, "{\\ensuremath\\bigotimes}" ],
 [ 10756, "{\\ensuremath\\biguplus}" ],
 [ 10757, "{\\ensuremath\\bigsqcap}" ],
 [ 10758, "{\\ensuremath\\bigsqcup}" ],
 [ 119808, "{\\ensuremath{\\mathbf A}}" ],
 [ 119809, "{\\ensuremath{\\mathbf B}}" ],
 [ 119810, "{\\ensuremath{\\mathbf C}}" ],
 [ 119811, "{\\ensuremath{\\mathbf D}}" ],
 [ 119812, "{\\ensuremath{\\mathbf E}}" ],
 [ 119813, "{\\ensuremath{\\mathbf F}}" ],
 [ 119814, "{\\ensuremath{\\mathbf G}}" ],
 [ 119815, "{\\ensuremath{\\mathbf H}}" ],
 [ 119816, "{\\ensuremath{\\mathbf I}}" ],
 [ 119817, "{\\ensuremath{\\mathbf J}}" ],
 [ 119818, "{\\ensuremath{\\mathbf K}}" ],
 [ 119819, "{\\ensuremath{\\mathbf L}}" ],
 [ 119820, "{\\ensuremath{\\mathbf M}}" ],
 [ 119821, "{\\ensuremath{\\mathbf N}}" ],
 [ 119822, "{\\ensuremath{\\mathbf O}}" ],
 [ 119823, "{\\ensuremath{\\mathbf P}}" ],
 [ 119824, "{\\ensuremath{\\mathbf Q}}" ],
 [ 119825, "{\\ensuremath{\\mathbf R}}" ],
 [ 119826, "{\\ensuremath{\\mathbf S}}" ],
 [ 119827, "{\\ensuremath{\\mathbf T}}" ],
 [ 119828, "{\\ensuremath{\\mathbf U}}" ],
 [ 119829, "{\\ensuremath{\\mathbf V}}" ],
 [ 119830, "{\\ensuremath{\\mathbf W}}" ],
 [ 119831, "{\\ensuremath{\\mathbf X}}" ],
 [ 119832, "{\\ensuremath{\\mathbf Y}}" ],
 [ 119833, "{\\ensuremath{\\mathbf Z}}" ],
 [ 119834, "{\\ensuremath{\\mathbf a}}" ],
 [ 119835, "{\\ensuremath{\\mathbf b}}" ],
 [ 119836, "{\\ensuremath{\\mathbf c}}" ],
 [ 119837, "{\\ensuremath{\\mathbf d}}" ],
 [ 119838, "{\\ensuremath{\\mathbf e}}" ],
 [ 119839, "{\\ensuremath{\\mathbf f}}" ],
 [ 119840, "{\\ensuremath{\\mathbf g}}" ],
 [ 119841, "{\\ensuremath{\\mathbf h}}" ],
 [ 119842, "{\\ensuremath{\\mathbf i}}" ],
 [ 119843, "{\\ensuremath{\\mathbf j}}" ],
 [ 119844, "{\\ensuremath{\\mathbf k}}" ],
 [ 119845, "{\\ensuremath{\\mathbf l}}" ],
 [ 119846, "{\\ensuremath{\\mathbf m}}" ],
 [ 119847, "{\\ensuremath{\\mathbf n}}" ],
 [ 119848, "{\\ensuremath{\\mathbf o}}" ],
 [ 119849, "{\\ensuremath{\\mathbf p}}" ],
 [ 119850, "{\\ensuremath{\\mathbf q}}" ],
 [ 119851, "{\\ensuremath{\\mathbf r}}" ],
 [ 119852, "{\\ensuremath{\\mathbf s}}" ],
 [ 119853, "{\\ensuremath{\\mathbf t}}" ],
 [ 119854, "{\\ensuremath{\\mathbf u}}" ],
 [ 119855, "{\\ensuremath{\\mathbf v}}" ],
 [ 119856, "{\\ensuremath{\\mathbf w}}" ],
 [ 119857, "{\\ensuremath{\\mathbf x}}" ],
 [ 119858, "{\\ensuremath{\\mathbf y}}" ],
 [ 119859, "{\\ensuremath{\\mathbf z}}" ],
 [ 119860, "{\\ensuremath{\\mathit A}}" ],
 [ 119861, "{\\ensuremath{\\mathit B}}" ],
 [ 119862, "{\\ensuremath{\\mathit C}}" ],
 [ 119863, "{\\ensuremath{\\mathit D}}" ],
 [ 119864, "{\\ensuremath{\\mathit E}}" ],
 [ 119865, "{\\ensuremath{\\mathit F}}" ],
 [ 119866, "{\\ensuremath{\\mathit G}}" ],
 [ 119867, "{\\ensuremath{\\mathit H}}" ],
 [ 119868, "{\\ensuremath{\\mathit I}}" ],
 [ 119869, "{\\ensuremath{\\mathit J}}" ],
 [ 119870, "{\\ensuremath{\\mathit K}}" ],
 [ 119871, "{\\ensuremath{\\mathit L}}" ],
 [ 119872, "{\\ensuremath{\\mathit M}}" ],
 [ 119873, "{\\ensuremath{\\mathit N}}" ],
 [ 119874, "{\\ensuremath{\\mathit O}}" ],
 [ 119875, "{\\ensuremath{\\mathit P}}" ],
 [ 119876, "{\\ensuremath{\\mathit Q}}" ],
 [ 119877, "{\\ensuremath{\\mathit R}}" ],
 [ 119878, "{\\ensuremath{\\mathit S}}" ],
 [ 119879, "{\\ensuremath{\\mathit T}}" ],
 [ 119880, "{\\ensuremath{\\mathit U}}" ],
 [ 119881, "{\\ensuremath{\\mathit V}}" ],
 [ 119882, "{\\ensuremath{\\mathit W}}" ],
 [ 119883, "{\\ensuremath{\\mathit X}}" ],
 [ 119884, "{\\ensuremath{\\mathit Y}}" ],
 [ 119885, "{\\ensuremath{\\mathit Z}}" ],
 [ 119886, "{\\ensuremath{\\mathit a}}" ],
 [ 119887, "{\\ensuremath{\\mathit b}}" ],
 [ 119888, "{\\ensuremath{\\mathit c}}" ],
 [ 119889, "{\\ensuremath{\\mathit d}}" ],
 [ 119890, "{\\ensuremath{\\mathit e}}" ],
 [ 119891, "{\\ensuremath{\\mathit f}}" ],
 [ 119892, "{\\ensuremath{\\mathit g}}" ],
 [ 119894, "{\\ensuremath{\\mathit i}}" ],
 [ 119895, "{\\ensuremath{\\mathit j}}" ],
 [ 119896, "{\\ensuremath{\\mathit k}}" ],
 [ 119897, "{\\ensuremath{\\mathit l}}" ],
 [ 119898, "{\\ensuremath{\\mathit m}}" ],
 [ 119899, "{\\ensuremath{\\mathit n}}" ],
 [ 119900, "{\\ensuremath{\\mathit o}}" ],
 [ 119901, "{\\ensuremath{\\mathit p}}" ],
 [ 119902, "{\\ensuremath{\\mathit q}}" ],
 [ 119903, "{\\ensuremath{\\mathit r}}" ],
 [ 119904, "{\\ensuremath{\\mathit s}}" ],
 [ 119905, "{\\ensuremath{\\mathit t}}" ],
 [ 119906, "{\\ensuremath{\\mathit u}}" ],
 [ 119907, "{\\ensuremath{\\mathit v}}" ],
 [ 119908, "{\\ensuremath{\\mathit w}}" ],
 [ 119909, "{\\ensuremath{\\mathit x}}" ],
 [ 119910, "{\\ensuremath{\\mathit y}}" ],
 [ 119911, "{\\ensuremath{\\mathit z}}" ],
 [ 120068, "{\\ensuremath{\\mathfrak A}}" ],
 [ 120069, "{\\ensuremath{\\mathfrak B}}" ],
 [ 120071, "{\\ensuremath{\\mathfrak D}}" ],
 [ 120072, "{\\ensuremath{\\mathfrak E}}" ],
 [ 120073, "{\\ensuremath{\\mathfrak F}}" ],
 [ 120074, "{\\ensuremath{\\mathfrak G}}" ],
 [ 120077, "{\\ensuremath{\\mathfrak J}}" ],
 [ 120078, "{\\ensuremath{\\mathfrak K}}" ],
 [ 120079, "{\\ensuremath{\\mathfrak L}}" ],
 [ 120080, "{\\ensuremath{\\mathfrak M}}" ],
 [ 120081, "{\\ensuremath{\\mathfrak N}}" ],
 [ 120082, "{\\ensuremath{\\mathfrak O}}" ],
 [ 120083, "{\\ensuremath{\\mathfrak P}}" ],
 [ 120084, "{\\ensuremath{\\mathfrak Q}}" ],
 [ 120086, "{\\ensuremath{\\mathfrak S}}" ],
 [ 120087, "{\\ensuremath{\\mathfrak T}}" ],
 [ 120088, "{\\ensuremath{\\mathfrak U}}" ],
 [ 120089, "{\\ensuremath{\\mathfrak V}}" ],
 [ 120090, "{\\ensuremath{\\mathfrak W}}" ],
 [ 120091, "{\\ensuremath{\\mathfrak X}}" ],
 [ 120092, "{\\ensuremath{\\mathfrak Y}}" ],
 [ 120094, "{\\ensuremath{\\mathfrak a}}" ],
 [ 120095, "{\\ensuremath{\\mathfrak b}}" ],
 [ 120096, "{\\ensuremath{\\mathfrak c}}" ],
 [ 120097, "{\\ensuremath{\\mathfrak d}}" ],
 [ 120098, "{\\ensuremath{\\mathfrak e}}" ],
 [ 120099, "{\\ensuremath{\\mathfrak f}}" ],
 [ 120100, "{\\ensuremath{\\mathfrak g}}" ],
 [ 120101, "{\\ensuremath{\\mathfrak h}}" ],
 [ 120102, "{\\ensuremath{\\mathfrak i}}" ],
 [ 120103, "{\\ensuremath{\\mathfrak j}}" ],
 [ 120104, "{\\ensuremath{\\mathfrak k}}" ],
 [ 120105, "{\\ensuremath{\\mathfrak l}}" ],
 [ 120106, "{\\ensuremath{\\mathfrak m}}" ],
 [ 120107, "{\\ensuremath{\\mathfrak n}}" ],
 [ 120108, "{\\ensuremath{\\mathfrak o}}" ],
 [ 120109, "{\\ensuremath{\\mathfrak p}}" ],
 [ 120110, "{\\ensuremath{\\mathfrak q}}" ],
 [ 120111, "{\\ensuremath{\\mathfrak r}}" ],
 [ 120112, "{\\ensuremath{\\mathfrak s}}" ],
 [ 120113, "{\\ensuremath{\\mathfrak t}}" ],
 [ 120114, "{\\ensuremath{\\mathfrak u}}" ],
 [ 120115, "{\\ensuremath{\\mathfrak v}}" ],
 [ 120116, "{\\ensuremath{\\mathfrak w}}" ],
 [ 120117, "{\\ensuremath{\\mathfrak x}}" ],
 [ 120118, "{\\ensuremath{\\mathfrak y}}" ],
 [ 120119, "{\\ensuremath{\\mathfrak z}}" ],
 [ 120120, "{\\ensuremath{\\mathbb A}}" ],
 [ 120121, "{\\ensuremath{\\mathbb B}}" ],
 [ 120123, "{\\ensuremath{\\mathbb D}}" ],
 [ 120124, "{\\ensuremath{\\mathbb E}}" ],
 [ 120125, "{\\ensuremath{\\mathbb F}}" ],
 [ 120126, "{\\ensuremath{\\mathbb G}}" ],
 [ 120128, "{\\ensuremath{\\mathbb I}}" ],
 [ 120129, "{\\ensuremath{\\mathbb J}}" ],
 [ 120130, "{\\ensuremath{\\mathbb K}}" ],
 [ 120131, "{\\ensuremath{\\mathbb L}}" ],
 [ 120132, "{\\ensuremath{\\mathbb M}}" ],
 [ 120134, "{\\ensuremath{\\mathbb O}}" ],
 [ 120138, "{\\ensuremath{\\mathbb S}}" ],
 [ 120139, "{\\ensuremath{\\mathbb T}}" ],
 [ 120140, "{\\ensuremath{\\mathbb U}}" ],
 [ 120141, "{\\ensuremath{\\mathbb V}}" ],
 [ 120142, "{\\ensuremath{\\mathbb W}}" ],
 [ 120143, "{\\ensuremath{\\mathbb X}}" ],
 [ 120144, "{\\ensuremath{\\mathbb Y}}" ],
 [ 120146, "{\\ensuremath{\\mathbb a}}" ],
 [ 120147, "{\\ensuremath{\\mathbb b}}" ],
 [ 120148, "{\\ensuremath{\\mathbb c}}" ],
 [ 120149, "{\\ensuremath{\\mathbb d}}" ],
 [ 120150, "{\\ensuremath{\\mathbb e}}" ],
 [ 120151, "{\\ensuremath{\\mathbb f}}" ],
 [ 120152, "{\\ensuremath{\\mathbb g}}" ],
 [ 120153, "{\\ensuremath{\\mathbb h}}" ],
 [ 120154, "{\\ensuremath{\\mathbb i}}" ],
 [ 120155, "{\\ensuremath{\\mathbb j}}" ],
 [ 120156, "{\\ensuremath{\\mathbb k}}" ],
 [ 120157, "{\\ensuremath{\\mathbb l}}" ],
 [ 120158, "{\\ensuremath{\\mathbb m}}" ],
 [ 120159, "{\\ensuremath{\\mathbb n}}" ],
 [ 120160, "{\\ensuremath{\\mathbb o}}" ],
 [ 120161, "{\\ensuremath{\\mathbb p}}" ],
 [ 120162, "{\\ensuremath{\\mathbb q}}" ],
 [ 120163, "{\\ensuremath{\\mathbb r}}" ],
 [ 120164, "{\\ensuremath{\\mathbb s}}" ],
 [ 120165, "{\\ensuremath{\\mathbb t}}" ],
 [ 120166, "{\\ensuremath{\\mathbb u}}" ],
 [ 120167, "{\\ensuremath{\\mathbb v}}" ],
 [ 120168, "{\\ensuremath{\\mathbb w}}" ],
 [ 120169, "{\\ensuremath{\\mathbb x}}" ],
 [ 120170, "{\\ensuremath{\\mathbb y}}" ],
 [ 120171, "{\\ensuremath{\\mathbb z}}" ],
 [ 120224, "{\\ensuremath{\\mathsf A}}" ],
 [ 120225, "{\\ensuremath{\\mathsf B}}" ],
 [ 120226, "{\\ensuremath{\\mathsf C}}" ],
 [ 120227, "{\\ensuremath{\\mathsf D}}" ],
 [ 120228, "{\\ensuremath{\\mathsf E}}" ],
 [ 120229, "{\\ensuremath{\\mathsf F}}" ],
 [ 120230, "{\\ensuremath{\\mathsf G}}" ],
 [ 120231, "{\\ensuremath{\\mathsf H}}" ],
 [ 120232, "{\\ensuremath{\\mathsf I}}" ],
 [ 120233, "{\\ensuremath{\\mathsf J}}" ],
 [ 120234, "{\\ensuremath{\\mathsf K}}" ],
 [ 120235, "{\\ensuremath{\\mathsf L}}" ],
 [ 120236, "{\\ensuremath{\\mathsf M}}" ],
 [ 120237, "{\\ensuremath{\\mathsf N}}" ],
 [ 120238, "{\\ensuremath{\\mathsf O}}" ],
 [ 120239, "{\\ensuremath{\\mathsf P}}" ],
 [ 120240, "{\\ensuremath{\\mathsf Q}}" ],
 [ 120241, "{\\ensuremath{\\mathsf R}}" ],
 [ 120242, "{\\ensuremath{\\mathsf S}}" ],
 [ 120243, "{\\ensuremath{\\mathsf T}}" ],
 [ 120244, "{\\ensuremath{\\mathsf U}}" ],
 [ 120245, "{\\ensuremath{\\mathsf V}}" ],
 [ 120246, "{\\ensuremath{\\mathsf W}}" ],
 [ 120247, "{\\ensuremath{\\mathsf X}}" ],
 [ 120248, "{\\ensuremath{\\mathsf Y}}" ],
 [ 120249, "{\\ensuremath{\\mathsf Z}}" ],
 [ 120250, "{\\ensuremath{\\mathsf a}}" ],
 [ 120251, "{\\ensuremath{\\mathsf b}}" ],
 [ 120252, "{\\ensuremath{\\mathsf c}}" ],
 [ 120253, "{\\ensuremath{\\mathsf d}}" ],
 [ 120254, "{\\ensuremath{\\mathsf e}}" ],
 [ 120255, "{\\ensuremath{\\mathsf f}}" ],
 [ 120256, "{\\ensuremath{\\mathsf g}}" ],
 [ 120257, "{\\ensuremath{\\mathsf h}}" ],
 [ 120258, "{\\ensuremath{\\mathsf i}}" ],
 [ 120259, "{\\ensuremath{\\mathsf j}}" ],
 [ 120260, "{\\ensuremath{\\mathsf k}}" ],
 [ 120261, "{\\ensuremath{\\mathsf l}}" ],
 [ 120262, "{\\ensuremath{\\mathsf m}}" ],
 [ 120263, "{\\ensuremath{\\mathsf n}}" ],
 [ 120264, "{\\ensuremath{\\mathsf o}}" ],
 [ 120265, "{\\ensuremath{\\mathsf p}}" ],
 [ 120266, "{\\ensuremath{\\mathsf q}}" ],
 [ 120267, "{\\ensuremath{\\mathsf r}}" ],
 [ 120268, "{\\ensuremath{\\mathsf s}}" ],
 [ 120269, "{\\ensuremath{\\mathsf t}}" ],
 [ 120270, "{\\ensuremath{\\mathsf u}}" ],
 [ 120271, "{\\ensuremath{\\mathsf v}}" ],
 [ 120272, "{\\ensuremath{\\mathsf w}}" ],
 [ 120273, "{\\ensuremath{\\mathsf x}}" ],
 [ 120274, "{\\ensuremath{\\mathsf y}}" ],
 [ 120275, "{\\ensuremath{\\mathsf z}}" ],
 [ 120432, "{\\ensuremath{\\mathtt A}}" ],
 [ 120433, "{\\ensuremath{\\mathtt B}}" ],
 [ 120434, "{\\ensuremath{\\mathtt C}}" ],
 [ 120435, "{\\ensuremath{\\mathtt D}}" ],
 [ 120436, "{\\ensuremath{\\mathtt E}}" ],
 [ 120437, "{\\ensuremath{\\mathtt F}}" ],
 [ 120438, "{\\ensuremath{\\mathtt G}}" ],
 [ 120439, "{\\ensuremath{\\mathtt H}}" ],
 [ 120440, "{\\ensuremath{\\mathtt I}}" ],
 [ 120441, "{\\ensuremath{\\mathtt J}}" ],
 [ 120442, "{\\ensuremath{\\mathtt K}}" ],
 [ 120443, "{\\ensuremath{\\mathtt L}}" ],
 [ 120444, "{\\ensuremath{\\mathtt M}}" ],
 [ 120445, "{\\ensuremath{\\mathtt N}}" ],
 [ 120446, "{\\ensuremath{\\mathtt O}}" ],
 [ 120447, "{\\ensuremath{\\mathtt P}}" ],
 [ 120448, "{\\ensuremath{\\mathtt Q}}" ],
 [ 120449, "{\\ensuremath{\\mathtt R}}" ],
 [ 120450, "{\\ensuremath{\\mathtt S}}" ],
 [ 120451, "{\\ensuremath{\\mathtt T}}" ],
 [ 120452, "{\\ensuremath{\\mathtt U}}" ],
 [ 120453, "{\\ensuremath{\\mathtt V}}" ],
 [ 120454, "{\\ensuremath{\\mathtt W}}" ],
 [ 120455, "{\\ensuremath{\\mathtt X}}" ],
 [ 120456, "{\\ensuremath{\\mathtt Y}}" ],
 [ 120457, "{\\ensuremath{\\mathtt Z}}" ],
 [ 120458, "{\\ensuremath{\\mathtt a}}" ],
 [ 120459, "{\\ensuremath{\\mathtt b}}" ],
 [ 120460, "{\\ensuremath{\\mathtt c}}" ],
 [ 120461, "{\\ensuremath{\\mathtt d}}" ],
 [ 120462, "{\\ensuremath{\\mathtt e}}" ],
 [ 120463, "{\\ensuremath{\\mathtt f}}" ],
 [ 120464, "{\\ensuremath{\\mathtt g}}" ],
 [ 120465, "{\\ensuremath{\\mathtt h}}" ],
 [ 120466, "{\\ensuremath{\\mathtt i}}" ],
 [ 120467, "{\\ensuremath{\\mathtt j}}" ],
 [ 120468, "{\\ensuremath{\\mathtt k}}" ],
 [ 120469, "{\\ensuremath{\\mathtt l}}" ],
 [ 120470, "{\\ensuremath{\\mathtt m}}" ],
 [ 120471, "{\\ensuremath{\\mathtt n}}" ],
 [ 120472, "{\\ensuremath{\\mathtt o}}" ],
 [ 120473, "{\\ensuremath{\\mathtt p}}" ],
 [ 120474, "{\\ensuremath{\\mathtt q}}" ],
 [ 120475, "{\\ensuremath{\\mathtt r}}" ],
 [ 120476, "{\\ensuremath{\\mathtt s}}" ],
 [ 120477, "{\\ensuremath{\\mathtt t}}" ],
 [ 120478, "{\\ensuremath{\\mathtt u}}" ],
 [ 120479, "{\\ensuremath{\\mathtt v}}" ],
 [ 120480, "{\\ensuremath{\\mathtt w}}" ],
 [ 120481, "{\\ensuremath{\\mathtt x}}" ],
 [ 120482, "{\\ensuremath{\\mathtt y}}" ],
 [ 120483, "{\\ensuremath{\\mathtt z}}" ],
 [ 120782, "{\\ensuremath{\\mathbf0}}" ],
 [ 120783, "{\\ensuremath{\\mathbf1}}" ],
 [ 120784, "{\\ensuremath{\\mathbf2}}" ],
 [ 120785, "{\\ensuremath{\\mathbf3}}" ],
 [ 120786, "{\\ensuremath{\\mathbf4}}" ],
 [ 120787, "{\\ensuremath{\\mathbf5}}" ],
 [ 120788, "{\\ensuremath{\\mathbf6}}" ],
 [ 120789, "{\\ensuremath{\\mathbf7}}" ],
 [ 120790, "{\\ensuremath{\\mathbf8}}" ],
 [ 120791, "{\\ensuremath{\\mathbf9}}" ],
 [ 120793, "{\\ensuremath{\\mathbb 1}}" ],
 [ 120794, "{\\ensuremath{\\mathbb 2}}" ],
 [ 120802, "{\\ensuremath{\\mathsf0}}" ],
 [ 120803, "{\\ensuremath{\\mathsf1}}" ],
 [ 120804, "{\\ensuremath{\\mathsf2}}" ],
 [ 120805, "{\\ensuremath{\\mathsf3}}" ],
 [ 120806, "{\\ensuremath{\\mathsf4}}" ],
 [ 120807, "{\\ensuremath{\\mathsf5}}" ],
 [ 120808, "{\\ensuremath{\\mathsf6}}" ],
 [ 120809, "{\\ensuremath{\\mathsf7}}" ],
 [ 120810, "{\\ensuremath{\\mathsf8}}" ],
 [ 120811, "{\\ensuremath{\\mathsf9}}" ],
 [ 120822, "{\\ensuremath{\\mathtt0}}" ],
 [ 120823, "{\\ensuremath{\\mathtt1}}" ],
 [ 120824, "{\\ensuremath{\\mathtt2}}" ],
 [ 120825, "{\\ensuremath{\\mathtt3}}" ],
 [ 120826, "{\\ensuremath{\\mathtt4}}" ],
 [ 120827, "{\\ensuremath{\\mathtt5}}" ],
 [ 120828, "{\\ensuremath{\\mathtt6}}" ],
 [ 120829, "{\\ensuremath{\\mathtt7}}" ],
 [ 120830, "{\\ensuremath{\\mathtt8}}" ],
 [ 120831, "{\\ensuremath{\\mathtt9}}" ],
 ]);


# Some translations of unicode characters (codepoint in first position
# of each entry) to "simpler" ones, often ASCII or sequence of ASCII
# characters. This table is started using  the  "transtab" data by
# Markus Kuhn (http://www.cl.cam.ac.uk/~mgk25/download/transtab.tar.gz)
InstallValue(SimplifiedUnicodeTable, [
[160,32],
[161,33],
[162,99],
[163,[71,66,80]],
[165,89],
[166,124],
[167,83],
[168,34],
[169,[40,99,41],99],
[170,97],
[171,[60,60]],
[172,45],
[173,45],
[174,[40,82,41]],
[175,45],
[176,32],
[177,[43,47,45]],
[178,[94,50],50],
[179,[94,51],51],
[180,39],
[181,956,117],
[182,80],
[183,46],
[184,44],
[185,[94,49],49],
[186,111],
[187,[62,62]],
[188,[32,49,47,52]],
[189,[32,49,47,50]],
[190,[32,51,47,52]],
[191,63],
[192,65],
[193,65],
[194,65],
[195,65],
[196,[65,101],65],
[197,[65,97],65],
[198,[65,69],65],
[199,67],
[200,69],
[201,69],
[202,69],
[203,69],
[204,73],
[205,73],
[206,73],
[207,73],
[208,68],
[209,78],
[210,79],
[211,79],
[212,79],
[213,79],
[214,[79,101],79],
[215,120],
[216,79],
[217,85],
[218,85],
[219,85],
[220,[85,101],85],
[221,89],
[222,[84,104]],
[223,[115,115],946,115],
[224,97],
[225,97],
[226,97],
[227,97],
[228,[97,101],97],
[229,[97,97],97],
[230,[97,101],97],
[231,99],
[232,101],
[233,101],
[234,101],
[235,101],
[236,105],
[237,105],
[238,105],
[239,105],
[240,100],
[241,110],
[242,111],
[243,111],
[244,111],
[245,111],
[246,[111,101],111],
[247,58],
[248,111],
[249,117],
[250,117],
[251,117],
[252,[117,101],117],
[253,121],
[254,[116,104]],
[255,121],
[256,65],
[257,97],
[258,65],
[259,97],
[260,65],
[261,97],
[262,67],
[263,99],
[264,[67,104],67],
[265,[99,104],99],
[266,67],
[267,99],
[268,67],
[269,99],
[270,68],
[271,100],
[272,68],
[273,100],
[274,69],
[275,101],
[276,69],
[277,101],
[278,69],
[279,101],
[280,69],
[281,101],
[282,69],
[283,101],
[284,[71,104],71],
[285,[103,104],103],
[286,71],
[287,103],
[288,71],
[289,103],
[290,71],
[291,103],
[292,[72,104],72],
[293,[104,104],104],
[294,72],
[295,104],
[296,73],
[297,105],
[298,73],
[299,105],
[300,73],
[301,105],
[302,73],
[303,105],
[304,73],
[305,105],
[306,[73,74]],
[307,[105,106]],
[308,[74,104],74],
[309,[106,104],106],
[310,75],
[311,107],
[312,107],
[313,76],
[314,108],
[315,76],
[316,108],
[317,76],
[318,108],
[319,[76,183],[76,46],76],
[320,[108,183],[108,46],108],
[321,76],
[322,108],
[323,78],
[324,110],
[325,78],
[326,110],
[327,78],
[328,110],
[329,[39,110]],
[330,[78,71],78],
[331,[110,103],110],
[332,79],
[333,111],
[334,79],
[335,111],
[336,79],
[337,111],
[338,[79,69]],
[339,[111,101]],
[340,82],
[341,114],
[342,82],
[343,114],
[344,82],
[345,114],
[346,83],
[347,115],
[348,[83,104],83],
[349,[115,104],115],
[350,83],
[351,115],
[352,83],
[353,115],
[354,84],
[355,116],
[356,84],
[357,116],
[358,84],
[359,116],
[360,85],
[361,117],
[362,85],
[363,117],
[364,85],
[365,117],
[366,85],
[367,117],
[368,85],
[369,117],
[370,85],
[371,117],
[372,87],
[373,119],
[374,89],
[375,121],
[376,89],
[377,90],
[378,122],
[379,90],
[380,122],
[381,90],
[382,122],
[383,115],
[402,102],
[536,350,83],
[537,351,115],
[538,354,84],
[539,355,116],
[697,8242,39],
[699,8216],
[700,8217,39],
[701,8219],
[710,94],
[712,39],
[713,175],
[716,44],
[720,58],
[730,176],
[732,126],
[733,34],
[884,39],
[885,44],
[894,59],
[7680,65],
[7681,97],
[7682,66],
[7683,98],
[7684,66],
[7685,98],
[7686,66],
[7687,98],
[7688,67],
[7689,99],
[7690,68],
[7691,100],
[7692,68],
[7693,100],
[7694,68],
[7695,100],
[7696,68],
[7697,100],
[7698,68],
[7699,100],
[7700,69],
[7701,101],
[7702,69],
[7703,101],
[7704,69],
[7705,101],
[7706,69],
[7707,101],
[7708,69],
[7709,101],
[7710,70],
[7711,102],
[7712,71],
[7713,103],
[7714,72],
[7715,104],
[7716,72],
[7717,104],
[7718,72],
[7719,104],
[7720,72],
[7721,104],
[7722,72],
[7723,104],
[7724,73],
[7725,105],
[7726,73],
[7727,105],
[7728,75],
[7729,107],
[7730,75],
[7731,107],
[7732,75],
[7733,107],
[7734,76],
[7735,108],
[7736,76],
[7737,108],
[7738,76],
[7739,108],
[7740,76],
[7741,108],
[7742,77],
[7743,109],
[7744,77],
[7745,109],
[7746,77],
[7747,109],
[7748,78],
[7749,110],
[7750,78],
[7751,110],
[7752,78],
[7753,110],
[7754,78],
[7755,110],
[7756,79],
[7757,111],
[7758,79],
[7759,111],
[7760,79],
[7761,111],
[7762,79],
[7763,111],
[7764,80],
[7765,112],
[7766,80],
[7767,112],
[7768,82],
[7769,114],
[7770,82],
[7771,114],
[7772,82],
[7773,114],
[7774,82],
[7775,114],
[7776,83],
[7777,115],
[7778,83],
[7779,115],
[7780,83],
[7781,115],
[7782,83],
[7783,115],
[7784,83],
[7785,115],
[7786,84],
[7787,116],
[7788,84],
[7789,116],
[7790,84],
[7791,116],
[7792,84],
[7793,116],
[7794,85],
[7795,117],
[7796,85],
[7797,117],
[7798,85],
[7799,117],
[7800,85],
[7801,117],
[7802,85],
[7803,117],
[7804,86],
[7805,118],
[7806,86],
[7807,118],
[7808,87],
[7809,119],
[7810,87],
[7811,119],
[7812,87],
[7813,119],
[7814,87],
[7815,119],
[7816,87],
[7817,119],
[7818,88],
[7819,120],
[7820,88],
[7821,120],
[7822,89],
[7823,121],
[7824,90],
[7825,122],
[7826,90],
[7827,122],
[7828,90],
[7829,122],
[7830,104],
[7831,116],
[7832,119],
[7833,121],
[7834,97],
[7840,65],
[7841,97],
[7842,65],
[7843,97],
[7844,65],
[7845,97],
[7846,65],
[7847,97],
[7848,65],
[7849,97],
[7850,65],
[7851,97],
[7852,65],
[7853,97],
[7854,65],
[7855,97],
[7856,65],
[7857,97],
[7858,65],
[7859,97],
[7860,65],
[7861,97],
[7862,65],
[7863,97],
[7864,69],
[7865,101],
[7866,69],
[7867,101],
[7868,69],
[7869,101],
[7870,69],
[7871,101],
[7872,69],
[7873,101],
[7874,69],
[7875,101],
[7876,69],
[7877,101],
[7878,69],
[7879,101],
[7880,73],
[7881,105],
[7882,73],
[7883,105],
[7884,79],
[7885,111],
[7886,79],
[7887,111],
[7888,79],
[7889,111],
[7890,79],
[7891,111],
[7892,79],
[7893,111],
[7894,79],
[7895,111],
[7896,79],
[7897,111],
[7898,79],
[7899,111],
[7900,79],
[7901,111],
[7902,79],
[7903,111],
[7904,79],
[7905,111],
[7906,79],
[7907,111],
[7908,85],
[7909,117],
[7910,85],
[7911,117],
[7912,85],
[7913,117],
[7914,85],
[7915,117],
[7916,85],
[7917,117],
[7918,85],
[7919,117],
[7920,85],
[7921,117],
[7922,89],
[7923,121],
[7924,89],
[7925,121],
[7926,89],
[7927,121],
[7928,89],
[7929,121],
[8192,32],
[8193,[32,32]],
[8194,32],
[8195,[32,32]],
[8196,32],
[8197,32],
[8198,32],
[8199,32],
[8200,32],
[8201,32],
[8202,[]],
[8203,[]],
[8204,[]],
[8205,[]],
[8206,[]],
[8207,[]],
[8208,45],
[8209,45],
[8210,45],
[8211,45],
[8212,[45,45]],
[8213,[45,45]],
[8214,[124,124]],
[8215,95],
[8216,39],
[8217,39],
[8218,39],
[8219,39],
[8220,34],
[8221,34],
[8222,34],
[8223,34],
[8224,43],
[8225,[43,43]],
[8226,111],
[8227,62],
[8228,46],
[8229,[46,46]],
[8230,[46,46,46]],
[8231,45],
[8234,[]],
[8235,[]],
[8236,[]],
[8237,[]],
[8238,[]],
[8239,32],
[8240,[32,48,47,48,48]],
[8242,39],
[8243,34],
[8244,[39,39,39]],
[8245,96],
[8246,[96,96]],
[8247,[96,96,96]],
[8249,60],
[8250,62],
[8252,[33,33]],
[8254,45],
[8259,45],
[8260,47],
[8264,[63,33]],
[8265,[33,63]],
[8266,55],
[8304,[94,48],48],
[8308,[94,52],52],
[8309,[94,53],53],
[8310,[94,54],54],
[8311,[94,55],55],
[8312,[94,56],56],
[8313,[94,57],57],
[8314,[94,43],43],
[8315,[94,45],45],
[8316,[94,61],61],
[8317,[94,40],40],
[8318,[94,41],41],
[8319,[94,110],110],
[8320,[95,48],48],
[8321,[95,49],49],
[8322,[95,50],50],
[8323,[95,51],51],
[8324,[95,52],52],
[8325,[95,53],53],
[8326,[95,54],54],
[8327,[95,55],55],
[8328,[95,56],56],
[8329,[95,57],57],
[8330,[95,43],43],
[8331,[95,45],45],
[8332,[95,61],61],
[8333,[95,40],40],
[8334,[95,41],41],
[8364,[69,85,82],69],
[8448,[97,47,99]],
[8449,[97,47,115]],
[8450,[67]],
[8451,[176,67],67],
[8453,[99,47,111]],
[8454,[99,47,117]],
[8457,[176,70],70],
[8461,[72]],
[8467,108],
[8469,[78]],
[8470,[78,186],[78,111]],
[8471,[40,80,41]],
[8473,[80]],
[8474,[81]],
[8477,[82]],
[8480,[91,83,77,93]],
[8481,[84,69,76]],
[8482,[91,84,77,93]],
[8484,[90]],
[8486,937,[111,104,109],79],
[8490,75],
[8491,197],
[8494,101],
[8531,[32,49,47,51]],
[8532,[32,50,47,51]],
[8533,[32,49,47,53]],
[8534,[32,50,47,53]],
[8535,[32,51,47,53]],
[8536,[32,52,47,53]],
[8537,[32,49,47,54]],
[8538,[32,53,47,54]],
[8539,[32,49,47,56]],
[8540,[32,51,47,56]],
[8541,[32,53,47,56]],
[8542,[32,55,47,56]],
[8543,[32,49,47]],
[8544,73],
[8545,[73,73]],
[8546,[73,73,73]],
[8547,[73,86]],
[8548,86],
[8549,[86,73]],
[8550,[86,73,73]],
[8551,[86,73,73,73]],
[8552,[73,88]],
[8553,88],
[8554,[88,73]],
[8555,[88,73,73]],
[8556,76],
[8557,67],
[8558,68],
[8559,77],
[8560,105],
[8561,[105,105]],
[8562,[105,105,105]],
[8563,[105,118]],
[8564,118],
[8565,[118,105]],
[8566,[118,105,105]],
[8567,[118,105,105,105]],
[8568,[105,120]],
[8569,120],
[8570,[120,105]],
[8571,[120,105,105]],
[8572,108],
[8573,99],
[8574,100],
[8575,109],
[8592,[60,45]],
[8593,94],
[8594,[45,62]],
[8595,118],
[8596,[60,45,62]],
[8614,[45,62]],
[8618,[45,62]],
[8656,[60,61]],
[8658,[61,62]],
[8660,[60,61,62]],
[8722,8211,45],
[8725,47],
[8726,92],
[8727,42],
[8728,111],
[8729,183],
[8734,[105,110,102]],
[8739,124],
[8741,[124,124]],
[8744,118],
[8758,58],
[8764,126],
[8800,[60,62]],
[8801,61],
[8804,[60,61]],
[8805,[62,61]],
[8806,[60,61]],
[8807,[62,61]],
[8810,[60,60]],
[8811,[62,62]],
[8826,60],
[8827,62],
[8853,[40,43,41]],
[8854,[40,45,41]],
[8855,[40,120,41]],
[8856,[40,47,41]],
[8866,[124,45]],
[8867,[45,124]],
[8870,[124,45]],
[8871,[124,61]],
[8872,[124,61]],
[8873,[124,124,45]],
[8901,183],
[8902,42],
[8917,35],
[8920,[60,60,60]],
[8921,[62,62,62]],
[8943,[46,46,46]],
[9001,60],
[9002,62],
[9216,[78,85,76]],
[9217,[83,79,72]],
[9218,[83,84,88]],
[9219,[69,84,88]],
[9220,[69,79,84]],
[9221,[69,78,81]],
[9222,[65,67,75]],
[9223,[66,69,76]],
[9224,[66,83]],
[9225,[72,84]],
[9226,[76,70]],
[9227,[86,84]],
[9228,[70,70]],
[9229,[67,82]],
[9230,[83,79]],
[9231,[83,73]],
[9232,[68,76,69]],
[9233,[68,67,49]],
[9234,[68,67,50]],
[9235,[68,67,51]],
[9236,[68,67,52]],
[9237,[78,65,75]],
[9238,[83,89,78]],
[9239,[69,84,66]],
[9240,[67,65,78]],
[9241,[69,77]],
[9242,[83,85,66]],
[9243,[69,83,67]],
[9244,[70,83]],
[9245,[71,83]],
[9246,[82,83]],
[9247,[85,83]],
[9248,[83,80]],
[9249,[68,69,76]],
[9251,95],
[9252,[78,76]],
[9253,[47,47,47]],
[9254,63],
[9312,[40,49,41],49],
[9313,[40,50,41],50],
[9314,[40,51,41],51],
[9315,[40,52,41],52],
[9316,[40,53,41],53],
[9317,[40,54,41],54],
[9318,[40,55,41],55],
[9319,[40,56,41],56],
[9320,[40,57,41],57],
[9321,[40,49,48,41]],
[9322,[40,49,49,41]],
[9323,[40,49,50,41]],
[9324,[40,49,51,41]],
[9325,[40,49,52,41]],
[9326,[40,49,53,41]],
[9327,[40,49,54,41]],
[9328,[40,49,55,41]],
[9329,[40,49,56,41]],
[9330,[40,49,57,41]],
[9331,[40,50,48,41]],
[9332,[40,49,41],49],
[9333,[40,50,41],50],
[9334,[40,51,41],51],
[9335,[40,52,41],52],
[9336,[40,53,41],53],
[9337,[40,54,41],54],
[9338,[40,55,41],55],
[9339,[40,56,41],56],
[9340,[40,57,41],57],
[9341,[40,49,48,41]],
[9342,[40,49,49,41]],
[9343,[40,49,50,41]],
[9344,[40,49,51,41]],
[9345,[40,49,52,41]],
[9346,[40,49,53,41]],
[9347,[40,49,54,41]],
[9348,[40,49,55,41]],
[9349,[40,49,56,41]],
[9350,[40,49,57,41]],
[9351,[40,50,48,41]],
[9352,[49,46],49],
[9353,[50,46],50],
[9354,[51,46],51],
[9355,[52,46],52],
[9356,[53,46],53],
[9357,[54,46],54],
[9358,[55,46],55],
[9359,[56,46],56],
[9360,[57,46],57],
[9361,[49,48,46]],
[9362,[49,49,46]],
[9363,[49,50,46]],
[9364,[49,51,46]],
[9365,[49,52,46]],
[9366,[49,53,46]],
[9367,[49,54,46]],
[9368,[49,55,46]],
[9369,[49,56,46]],
[9370,[49,57,46]],
[9371,[50,48,46]],
[9372,[40,97,41],97],
[9373,[40,98,41],98],
[9374,[40,99,41],99],
[9375,[40,100,41],100],
[9376,[40,101,41],101],
[9377,[40,102,41],102],
[9378,[40,103,41],103],
[9379,[40,104,41],104],
[9380,[40,105,41],105],
[9381,[40,106,41],106],
[9382,[40,107,41],107],
[9383,[40,108,41],108],
[9384,[40,109,41],109],
[9385,[40,110,41],110],
[9386,[40,111,41],111],
[9387,[40,112,41],112],
[9388,[40,113,41],113],
[9389,[40,114,41],114],
[9390,[40,115,41],115],
[9391,[40,116,41],116],
[9392,[40,117,41],117],
[9393,[40,118,41],118],
[9394,[40,119,41],119],
[9395,[40,120,41],120],
[9396,[40,121,41],121],
[9397,[40,122,41],122],
[9398,[40,65,41],65],
[9399,[40,66,41],66],
[9400,[40,67,41],67],
[9401,[40,68,41],68],
[9402,[40,69,41],69],
[9403,[40,70,41],70],
[9404,[40,71,41],71],
[9405,[40,72,41],72],
[9406,[40,73,41],73],
[9407,[40,74,41],74],
[9408,[40,75,41],75],
[9409,[40,76,41],76],
[9410,[40,77,41],77],
[9411,[40,78,41],78],
[9412,[40,79,41],79],
[9413,[40,80,41],80],
[9414,[40,81,41],81],
[9415,[40,82,41],82],
[9416,[40,83,41],83],
[9417,[40,84,41],84],
[9418,[40,85,41],85],
[9419,[40,86,41],86],
[9420,[40,87,41],87],
[9421,[40,88,41],88],
[9422,[40,89,41],89],
[9423,[40,90,41],90],
[9424,[40,97,41],97],
[9425,[40,98,41],98],
[9426,[40,99,41],99],
[9427,[40,100,41],100],
[9428,[40,101,41],101],
[9429,[40,102,41],102],
[9430,[40,103,41],103],
[9431,[40,104,41],104],
[9432,[40,105,41],105],
[9433,[40,106,41],106],
[9434,[40,107,41],107],
[9435,[40,108,41],108],
[9436,[40,109,41],109],
[9437,[40,110,41],110],
[9438,[40,111,41],111],
[9439,[40,112,41],112],
[9440,[40,113,41],113],
[9441,[40,114,41],114],
[9442,[40,115,41],115],
[9443,[40,116,41],116],
[9444,[40,117,41],117],
[9445,[40,118,41],118],
[9446,[40,119,41],119],
[9447,[40,120,41],120],
[9448,[40,121,41],121],
[9449,[40,122,41],122],
[9450,[40,48,41],48],
[9472,45],
[9473,61],
[9474,124],
[9475,124],
[9476,45],
[9477,61],
[9478,124],
[9479,124],
[9480,45],
[9481,61],
[9482,124],
[9483,124],
[9484,43],
[9485,43],
[9486,43],
[9487,43],
[9488,43],
[9489,43],
[9490,43],
[9491,43],
[9492,43],
[9493,43],
[9494,43],
[9495,43],
[9496,43],
[9497,43],
[9498,43],
[9499,43],
[9500,43],
[9501,43],
[9502,43],
[9503,43],
[9504,43],
[9505,43],
[9506,43],
[9507,43],
[9508,43],
[9509,43],
[9510,43],
[9511,43],
[9512,43],
[9513,43],
[9514,43],
[9515,43],
[9516,43],
[9517,43],
[9518,43],
[9519,43],
[9520,43],
[9521,43],
[9522,43],
[9523,43],
[9524,43],
[9525,43],
[9526,43],
[9527,43],
[9528,43],
[9529,43],
[9530,43],
[9531,43],
[9532,43],
[9533,43],
[9534,43],
[9535,43],
[9536,43],
[9537,43],
[9538,43],
[9539,43],
[9540,43],
[9541,43],
[9542,43],
[9543,43],
[9544,43],
[9545,43],
[9546,43],
[9547,43],
[9548,45],
[9549,61],
[9550,124],
[9551,124],
[9552,61],
[9553,124],
[9554,43],
[9555,43],
[9556,43],
[9557,43],
[9558,43],
[9559,43],
[9560,43],
[9561,43],
[9562,43],
[9563,43],
[9564,43],
[9565,43],
[9566,43],
[9567,43],
[9568,43],
[9569,43],
[9570,43],
[9571,43],
[9572,43],
[9573,43],
[9574,43],
[9575,43],
[9576,43],
[9577,43],
[9578,43],
[9579,43],
[9580,43],
[9581,43],
[9582,43],
[9583,43],
[9584,43],
[9585,47],
[9586,92],
[9587,88],
[9596,45],
[9597,124],
[9598,45],
[9599,124],
[9675,111],
[9702,111],
[9733,42],
[9734,42],
[9746,88],
[9747,88],
[9785,[58,45,40]],
[9786,[58,45,41]],
[9787,[40,45,58]],
[9837,98],
[9839,35],
[9985,[37,60]],
[9986,[37,60]],
[9987,[37,60]],
[9988,[37,60]],
[9996,86],
[10003,8730],
[10004,8730],
[10005,120],
[10006,120],
[10007,88],
[10008,88],
[10009,43],
[10010,43],
[10011,43],
[10012,43],
[10013,43],
[10014,43],
[10015,43],
[10016,43],
[10017,42],
[10018,43],
[10019,43],
[10020,43],
[10021,43],
[10022,43],
[10023,43],
[10025,42],
[10026,42],
[10027,42],
[10028,42],
[10029,42],
[10030,42],
[10031,42],
[10032,42],
[10033,42],
[10034,42],
[10035,42],
[10036,42],
[10037,42],
[10038,42],
[10039,42],
[10040,42],
[10041,42],
[10042,42],
[10043,42],
[10044,42],
[10045,42],
[10046,42],
[10047,42],
[10048,42],
[10049,42],
[10050,42],
[10051,42],
[10052,42],
[10053,42],
[10054,42],
[10055,42],
[10056,42],
[10057,42],
[10058,42],
[10059,42],
[10216,60],
[10217,62],
[10229,[60,45,45]],
[10230,[45,45,62]],
[10231,[60,45,62]],
[10232,[60,61,61]],
[10233,[61,61,62]],
[10234,[60,61,62]],
[64256,[102,102]],
[64257,[102,105]],
[64258,[102,108]],
[64259,[102,102,105]],
[64260,[102,102,108]],
[64261,[383,116],[115,116]],
[64262,[115,116]],
[65279,[]],
[65533,63]
]);




# map to lower case, extracted from UnicodeData.txt field 14
# [get uppercase map by Set(List(lcmap, Reverse));  ]
InstallValue(LowercaseUnicodeTable, [
[65,97],[66,98],[67,99],[68,100],[69,101],[70,102],
[71,103],[72,104],[73,105],[74,106],[75,107],
[76,108],[77,109],[78,110],[79,111],[80,112],
[81,113],[82,114],[83,115],[84,116],[85,117],
[86,118],[87,119],[88,120],[89,121],[90,122],
[192,224],[193,225],[194,226],[195,227],[196,228],
[197,229],[198,230],[199,231],[200,232],[201,233],
[202,234],[203,235],[204,236],[205,237],[206,238],
[207,239],[208,240],[209,241],[210,242],[211,243],
[212,244],[213,245],[214,246],[216,248],[217,249],
[218,250],[219,251],[220,252],[221,253],[222,254],
[256,257],[258,259],[260,261],[262,263],[264,265],
[266,267],[268,269],[270,271],[272,273],[274,275],
[276,277],[278,279],[280,281],[282,283],[284,285],
[286,287],[288,289],[290,291],[292,293],[294,295],
[296,297],[298,299],[300,301],[302,303],[304,105],
[306,307],[308,309],[310,311],[313,314],[315,316],
[317,318],[319,320],[321,322],[323,324],[325,326],
[327,328],[330,331],[332,333],[334,335],[336,337],
[338,339],[340,341],[342,343],[344,345],[346,347],
[348,349],[350,351],[352,353],[354,355],[356,357],
[358,359],[360,361],[362,363],[364,365],[366,367],
[368,369],[370,371],[372,373],[374,375],[376,255],
[377,378],[379,380],[381,382],[385,595],[386,387],
[388,389],[390,596],[391,392],[393,598],[394,599],
[395,396],[398,477],[399,601],[400,603],[401,402],
[403,608],[404,611],[406,617],[407,616],[408,409],
[412,623],[413,626],[415,629],[416,417],[418,419],
[420,421],[422,640],[423,424],[425,643],[428,429],
[430,648],[431,432],[433,650],[434,651],[435,436],
[437,438],[439,658],[440,441],[444,445],[452,454],
[453,454],[455,457],[456,457],[458,460],[459,460],
[461,462],[463,464],[465,466],[467,468],[469,470],
[471,472],[473,474],[475,476],[478,479],[480,481],
[482,483],[484,485],[486,487],[488,489],[490,491],
[492,493],[494,495],[497,499],[498,499],[500,501],
[502,405],[503,447],[504,505],[506,507],[508,509],
[510,511],[512,513],[514,515],[516,517],[518,519],
[520,521],[522,523],[524,525],[526,527],[528,529],
[530,531],[532,533],[534,535],[536,537],[538,539],
[540,541],[542,543],[544,414],[546,547],[548,549],
[550,551],[552,553],[554,555],[556,557],[558,559],
[560,561],[562,563],[570,11365],[571,572],[573,410],
[574,11366],[577,578],[579,384],[580,649],[581,652],
[582,583],[584,585],[586,587],[588,589],[590,591],
[902,940],[904,941],[905,942],[906,943],[908,972],
[910,973],[911,974],[913,945],[914,946],[915,947],
[916,948],[917,949],[918,950],[919,951],[920,952],
[921,953],[922,954],[923,955],[924,956],[925,957],
[926,958],[927,959],[928,960],[929,961],[931,963],
[932,964],[933,965],[934,966],[935,967],[936,968],
[937,969],[938,970],[939,971],[984,985],[986,987],
[988,989],[990,991],[992,993],[994,995],[996,997],
[998,999],[1000,1001],[1002,1003],[1004,1005],
[1006,1007],[1012,952],[1015,1016],[1017,1010],
[1018,1019],[1021,891],[1022,892],[1023,893],
[1024,1104],[1025,1105],[1026,1106],[1027,1107],
[1028,1108],[1029,1109],[1030,1110],[1031,1111],
[1032,1112],[1033,1113],[1034,1114],[1035,1115],
[1036,1116],[1037,1117],[1038,1118],[1039,1119],
[1040,1072],[1041,1073],[1042,1074],[1043,1075],
[1044,1076],[1045,1077],[1046,1078],[1047,1079],
[1048,1080],[1049,1081],[1050,1082],[1051,1083],
[1052,1084],[1053,1085],[1054,1086],[1055,1087],
[1056,1088],[1057,1089],[1058,1090],[1059,1091],
[1060,1092],[1061,1093],[1062,1094],[1063,1095],
[1064,1096],[1065,1097],[1066,1098],[1067,1099],
[1068,1100],[1069,1101],[1070,1102],[1071,1103],
[1120,1121],[1122,1123],[1124,1125],[1126,1127],
[1128,1129],[1130,1131],[1132,1133],[1134,1135],
[1136,1137],[1138,1139],[1140,1141],[1142,1143],
[1144,1145],[1146,1147],[1148,1149],[1150,1151],
[1152,1153],[1162,1163],[1164,1165],[1166,1167],
[1168,1169],[1170,1171],[1172,1173],[1174,1175],
[1176,1177],[1178,1179],[1180,1181],[1182,1183],
[1184,1185],[1186,1187],[1188,1189],[1190,1191],
[1192,1193],[1194,1195],[1196,1197],[1198,1199],
[1200,1201],[1202,1203],[1204,1205],[1206,1207],
[1208,1209],[1210,1211],[1212,1213],[1214,1215],
[1216,1231],[1217,1218],[1219,1220],[1221,1222],
[1223,1224],[1225,1226],[1227,1228],[1229,1230],
[1232,1233],[1234,1235],[1236,1237],[1238,1239],
[1240,1241],[1242,1243],[1244,1245],[1246,1247],
[1248,1249],[1250,1251],[1252,1253],[1254,1255],
[1256,1257],[1258,1259],[1260,1261],[1262,1263],
[1264,1265],[1266,1267],[1268,1269],[1270,1271],
[1272,1273],[1274,1275],[1276,1277],[1278,1279],
[1280,1281],[1282,1283],[1284,1285],[1286,1287],
[1288,1289],[1290,1291],[1292,1293],[1294,1295],
[1296,1297],[1298,1299],[1329,1377],[1330,1378],
[1331,1379],[1332,1380],[1333,1381],[1334,1382],
[1335,1383],[1336,1384],[1337,1385],[1338,1386],
[1339,1387],[1340,1388],[1341,1389],[1342,1390],
[1343,1391],[1344,1392],[1345,1393],[1346,1394],
[1347,1395],[1348,1396],[1349,1397],[1350,1398],
[1351,1399],[1352,1400],[1353,1401],[1354,1402],
[1355,1403],[1356,1404],[1357,1405],[1358,1406],
[1359,1407],[1360,1408],[1361,1409],[1362,1410],
[1363,1411],[1364,1412],[1365,1413],[1366,1414],
[4256,11520],[4257,11521],[4258,11522],[4259,11523],
[4260,11524],[4261,11525],[4262,11526],[4263,11527],
[4264,11528],[4265,11529],[4266,11530],[4267,11531],
[4268,11532],[4269,11533],[4270,11534],[4271,11535],
[4272,11536],[4273,11537],[4274,11538],[4275,11539],
[4276,11540],[4277,11541],[4278,11542],[4279,11543],
[4280,11544],[4281,11545],[4282,11546],[4283,11547],
[4284,11548],[4285,11549],[4286,11550],[4287,11551],
[4288,11552],[4289,11553],[4290,11554],[4291,11555],
[4292,11556],[4293,11557],[7680,7681],[7682,7683],
[7684,7685],[7686,7687],[7688,7689],[7690,7691],
[7692,7693],[7694,7695],[7696,7697],[7698,7699],
[7700,7701],[7702,7703],[7704,7705],[7706,7707],
[7708,7709],[7710,7711],[7712,7713],[7714,7715],
[7716,7717],[7718,7719],[7720,7721],[7722,7723],
[7724,7725],[7726,7727],[7728,7729],[7730,7731],
[7732,7733],[7734,7735],[7736,7737],[7738,7739],
[7740,7741],[7742,7743],[7744,7745],[7746,7747],
[7748,7749],[7750,7751],[7752,7753],[7754,7755],
[7756,7757],[7758,7759],[7760,7761],[7762,7763],
[7764,7765],[7766,7767],[7768,7769],[7770,7771],
[7772,7773],[7774,7775],[7776,7777],[7778,7779],
[7780,7781],[7782,7783],[7784,7785],[7786,7787],
[7788,7789],[7790,7791],[7792,7793],[7794,7795],
[7796,7797],[7798,7799],[7800,7801],[7802,7803],
[7804,7805],[7806,7807],[7808,7809],[7810,7811],
[7812,7813],[7814,7815],[7816,7817],[7818,7819],
[7820,7821],[7822,7823],[7824,7825],[7826,7827],
[7828,7829],[7840,7841],[7842,7843],[7844,7845],
[7846,7847],[7848,7849],[7850,7851],[7852,7853],
[7854,7855],[7856,7857],[7858,7859],[7860,7861],
[7862,7863],[7864,7865],[7866,7867],[7868,7869],
[7870,7871],[7872,7873],[7874,7875],[7876,7877],
[7878,7879],[7880,7881],[7882,7883],[7884,7885],
[7886,7887],[7888,7889],[7890,7891],[7892,7893],
[7894,7895],[7896,7897],[7898,7899],[7900,7901],
[7902,7903],[7904,7905],[7906,7907],[7908,7909],
[7910,7911],[7912,7913],[7914,7915],[7916,7917],
[7918,7919],[7920,7921],[7922,7923],[7924,7925],
[7926,7927],[7928,7929],[7944,7936],[7945,7937],
[7946,7938],[7947,7939],[7948,7940],[7949,7941],
[7950,7942],[7951,7943],[7960,7952],[7961,7953],
[7962,7954],[7963,7955],[7964,7956],[7965,7957],
[7976,7968],[7977,7969],[7978,7970],[7979,7971],
[7980,7972],[7981,7973],[7982,7974],[7983,7975],
[7992,7984],[7993,7985],[7994,7986],[7995,7987],
[7996,7988],[7997,7989],[7998,7990],[7999,7991],
[8008,8000],[8009,8001],[8010,8002],[8011,8003],
[8012,8004],[8013,8005],[8025,8017],[8027,8019],
[8029,8021],[8031,8023],[8040,8032],[8041,8033],
[8042,8034],[8043,8035],[8044,8036],[8045,8037],
[8046,8038],[8047,8039],[8072,8064],[8073,8065],
[8074,8066],[8075,8067],[8076,8068],[8077,8069],
[8078,8070],[8079,8071],[8088,8080],[8089,8081],
[8090,8082],[8091,8083],[8092,8084],[8093,8085],
[8094,8086],[8095,8087],[8104,8096],[8105,8097],
[8106,8098],[8107,8099],[8108,8100],[8109,8101],
[8110,8102],[8111,8103],[8120,8112],[8121,8113],
[8122,8048],[8123,8049],[8124,8115],[8136,8050],
[8137,8051],[8138,8052],[8139,8053],[8140,8131],
[8152,8144],[8153,8145],[8154,8054],[8155,8055],
[8168,8160],[8169,8161],[8170,8058],[8171,8059],
[8172,8165],[8184,8056],[8185,8057],[8186,8060],
[8187,8061],[8188,8179],[8486,969],[8490,107],
[8491,229],[8498,8526],[8544,8560],[8545,8561],
[8546,8562],[8547,8563],[8548,8564],[8549,8565],
[8550,8566],[8551,8567],[8552,8568],[8553,8569],
[8554,8570],[8555,8571],[8556,8572],[8557,8573],
[8558,8574],[8559,8575],[8579,8580],[9398,9424],
[9399,9425],[9400,9426],[9401,9427],[9402,9428],
[9403,9429],[9404,9430],[9405,9431],[9406,9432],
[9407,9433],[9408,9434],[9409,9435],[9410,9436],
[9411,9437],[9412,9438],[9413,9439],[9414,9440],
[9415,9441],[9416,9442],[9417,9443],[9418,9444],
[9419,9445],[9420,9446],[9421,9447],[9422,9448],
[9423,9449],[11264,11312],[11265,11313],[11266,11314],
[11267,11315],[11268,11316],[11269,11317],[11270,11318],
[11271,11319],[11272,11320],[11273,11321],[11274,11322],
[11275,11323],[11276,11324],[11277,11325],[11278,11326],
[11279,11327],[11280,11328],[11281,11329],[11282,11330],
[11283,11331],[11284,11332],[11285,11333],[11286,11334],
[11287,11335],[11288,11336],[11289,11337],[11290,11338],
[11291,11339],[11292,11340],[11293,11341],[11294,11342],
[11295,11343],[11296,11344],[11297,11345],[11298,11346],
[11299,11347],[11300,11348],[11301,11349],[11302,11350],
[11303,11351],[11304,11352],[11305,11353],[11306,11354],
[11307,11355],[11308,11356],[11309,11357],[11310,11358],
[11360,11361],[11362,619],[11363,7549],[11364,637],
[11367,11368],[11369,11370],[11371,11372],[11381,11382],
[11392,11393],[11394,11395],[11396,11397],[11398,11399],
[11400,11401],[11402,11403],[11404,11405],[11406,11407],
[11408,11409],[11410,11411],[11412,11413],[11414,11415],
[11416,11417],[11418,11419],[11420,11421],[11422,11423],
[11424,11425],[11426,11427],[11428,11429],[11430,11431],
[11432,11433],[11434,11435],[11436,11437],[11438,11439],
[11440,11441],[11442,11443],[11444,11445],[11446,11447],
[11448,11449],[11450,11451],[11452,11453],[11454,11455],
[11456,11457],[11458,11459],[11460,11461],[11462,11463],
[11464,11465],[11466,11467],[11468,11469],[11470,11471],
[11472,11473],[11474,11475],[11476,11477],[11478,11479],
[11480,11481],[11482,11483],[11484,11485],[11486,11487],
[11488,11489],[11490,11491],[65313,65345],[65314,65346],
[65315,65347],[65316,65348],[65317,65349],[65318,65350],
[65319,65351],[65320,65352],[65321,65353],[65322,65354],
[65323,65355],[65324,65356],[65325,65357],[65326,65358],
[65327,65359],[65328,65360],[65329,65361],[65330,65362],
[65331,65363],[65332,65364],[65333,65365],[65334,65366],
[65335,65367],[65336,65368],[65337,65369],[65338,65370],
[66560,66600],[66561,66601],[66562,66602],[66563,66603],
[66564,66604],[66565,66605],[66566,66606],[66567,66607],
[66568,66608],[66569,66609],[66570,66610],[66571,66611],
[66572,66612],[66573,66613],[66574,66614],[66575,66615],
[66576,66616],[66577,66617],[66578,66618],[66579,66619],
[66580,66620],[66581,66621],[66582,66622],[66583,66623],
[66584,66624],[66585,66625],[66586,66626],[66587,66627],
[66588,66628],[66589,66629],[66590,66630],[66591,66631],
[66592,66632],[66593,66633],[66594,66634],[66595,66635],
[66596,66636],[66597,66637],[66598,66638],[66599,66639]
]);
MakeImmutable(LowercaseUnicodeTable);
IsSet(LowercaseUnicodeTable);

# map to character width on terminals
# got from glibc wcwidth in UTF-8 locale, but ignoring the ranges where
# -1 (invalid/control) character) is returned.
# entry [pos, w] means that unicode character p has width w when pos <= p
# < the pos part of the next entry
InstallValue(WidthUnicodeTable,
[
[0,0],
[32,1],
[173,0],
[174,1],
[768,0],
[884,1],
[1155,0],
[1162,1],
[1425,0],
[1470,1],
[1471,0],
[1472,1],
[1473,0],
[1475,1],
[1476,0],
[1488,1],
[1611,0],
[1632,1],
[1648,0],
[1649,1],
[1750,0],
[1765,1],
[1767,0],
[1769,1],
[1770,0],
[1776,1],
[1807,0],
[1808,1],
[1809,0],
[1810,1],
[1840,0],
[1920,1],
[1958,0],
[1969,1],
[2305,0],
[2307,1],
[2364,0],
[2365,1],
[2369,0],
[2377,1],
[2381,0],
[2384,1],
[2385,0],
[2392,1],
[2402,0],
[2404,1],
[2433,0],
[2434,1],
[2492,0],
[2494,1],
[2497,0],
[2503,1],
[2509,0],
[2519,1],
[2530,0],
[2534,1],
[2562,0],
[2565,1],
[2620,0],
[2622,1],
[2625,0],
[2649,1],
[2672,0],
[2674,1],
[2689,0],
[2691,1],
[2748,0],
[2749,1],
[2753,0],
[2761,1],
[2765,0],
[2768,1],
[2817,0],
[2818,1],
[2876,0],
[2877,1],
[2879,0],
[2880,1],
[2881,0],
[2887,1],
[2893,0],
[2903,1],
[2946,0],
[2947,1],
[3008,0],
[3009,1],
[3021,0],
[3031,1],
[3134,0],
[3137,1],
[3142,0],
[3168,1],
[3276,0],
[3285,1],
[3393,0],
[3398,1],
[3405,0],
[3415,1],
[3530,0],
[3535,1],
[3538,0],
[3544,1],
[3633,0],
[3634,1],
[3636,0],
[3647,1],
[3655,0],
[3663,1],
[3761,0],
[3762,1],
[3764,0],
[3773,1],
[3784,0],
[3792,1],
[3864,0],
[3866,1],
[3893,0],
[3894,1],
[3895,0],
[3896,1],
[3897,0],
[3898,1],
[3953,0],
[3967,1],
[3968,0],
[3973,1],
[3974,0],
[3976,1],
[3984,0],
[4030,1],
[4038,0],
[4039,1],
[4141,0],
[4145,1],
[4146,0],
[4152,1],
[4153,0],
[4160,1],
[4184,0],
[4256,1],
[4352,2],
[4448,0],
[4608,1],
[5906,0],
[5920,1],
[5938,0],
[5941,1],
[5970,0],
[5984,1],
[6002,0],
[6016,1],
[6068,0],
[6070,1],
[6071,0],
[6078,1],
[6086,0],
[6087,1],
[6089,0],
[6100,1],
[6155,0],
[6158,1],
[6313,0],
[7680,1],
[8203,0],
[8208,1],
[8234,0],
[8239,1],
[8288,0],
[8304,1],
[8400,0],
[8448,1],
[9001,2],
[9003,1],
[11904,2],
[12330,0],
[12336,2],
[12351,1],
[12353,2],
[12441,0],
[12443,2],
[57344,1],
[63744,2],
[64256,1],
[64286,0],
[64287,1],
[65024,0],
[65072,2],
[65136,1],
[65279,0],
[65281,2],
[65377,1],
[65504,2],
[65512,1],
[65529,0],
[65532,1],
[119143,0],
[119146,1],
[119155,0],
[119171,1],
[119173,0],
[119180,1],
[119210,0],
[119214,1],
[131072,2],
[917505,0],
[983040,1],
]);
MakeImmutable(WidthUnicodeTable);
IsSet(WidthUnicodeTable);
