<?php

   include ("code/functions/tourneyarray.php");
   include ("code/functions/tourneyfile.php");
   include ("code/functions/basictreegeometry.php");
   include ("code/functions/advancedtreegeometry.php");
   include ("code/functions/processing.php");
   include ("code/functions/teams.php");

   include ("lang/".$Language."/submitupdate.php");


// Initialise Array
   $Match = array();
   for ($cnt = 0; $cnt < (1); $cnt++) {$Match[$cnt] = new MatchType;}
   $NumPlayers = 0;
   $EliminationMode = 0;
   $TeamMode = 0;

// Load Tournament Into Array
   LoadTourney ("data/tournament.dat", &$NumPlayers, &$EliminationMode, &$Match, &$TeamMode);

// Check if user has sufficient rights to submit an update
   if ($TeamMode) {
     $user = TeamOf($HTTP_COOKIE_VARS["nickname"]);
     $user = substr($user, 0, strlen($user)-4);
   }else{
     $user = $HTTP_COOKIE_VARS["nickname"];
   }
   if (TeamCaptain($user.".dat") == $HTTP_COOKIE_VARS["nickname"] || !$TeamMode) {$IsCaptain = true;}else{$IsCaptain = false;}

if ($IsCaptain) {
 if ($HTTP_POST_VARS["BeenSubmitted"]) {
// Get Details of our submission
   $opponent = $HTTP_POST_VARS["Opponent"];
   $oppfrags = intval($HTTP_POST_VARS["OppFrags"]);
   $myfrags  = intval($HTTP_POST_VARS["MyFrags"]);
   $matchnum = $HTTP_GET_VARS["match"];

   $theysub = false;
   $theywrong = false;

// check if opponent has submitted; if not, record our submission
   if (file_exists("data/submissions/".$opponent.".dat")) {
   // check if it's a correct submission
      $fhandle = file("data/submissions/".$opponent.".dat");
      $theiropp = substr($fhandle[0],0,strlen($fhandle[0])-2);
      if ($user == $theiropp) {
        $theysub = true;
        $smyfrags = intval(substr($fhandle[1],0,strlen($fhandle[1])-2));
        $soppfrags = intval(substr($fhandle[2],0,strlen($fhandle[2])-2));
        // Now we can try and validate claim, if correct, we can update the tree (and remove past sumissions);
        if ($soppfrags == $myfrags && $oppfrags == $smyfrags) {
          //Update Tree
          $theywrong = false;

          if ($Match[$matchnum]->nameOne() == $user) {
            $Match[$matchnum]->fragsOne($myfrags);
            $Match[$matchnum]->fragsTwo($oppfrags);
          }
          if ($Match[$matchnum]->nameTwo() == $user) {
            $Match[$matchnum]->fragsOne($oppfrags);
            $Match[$matchnum]->fragsTwo($myfrags);
          }
          UpdateTree(&$Match, $NumPlayers, $EliminationMode, $TeamMode);
          SaveTourney ("data/tournament.dat", $NumPlayers, $EliminationMode, $Match, $TeamMode);
          print "<P>&nbsp;</P><P>&nbsp;</P><P ALIGN=\"CENTER\">$LANGTourneyUpdate</P>\n";
          @unlink ("data/submissions/".$opponent.".dat");
          @unlink ("data/submissions/".$user.".dat");
        }else{
          //Conflict of Results
          $theywrong = true;
        }
      }
   }
   if (!$theysub) {print "<P>&nbsp;</P><P>&nbsp;</P><P ALIGN=\"CENTER\">$LANGNoResults</P>\n";}
   if ($theywrong) {print "<P>&nbsp;</P><P>&nbsp;</P><P ALIGN=\"CENTER\">$LANGConflict</P>\n";}

   if (!$theysub || $theywrong) {
     //Record our submission details
     @mkdir ("data/submissions", 0777);
     if ($fhandle = fopen("data/submissions/".$user.".dat", "w")) {
       fwrite($fhandle, $opponent.chr(13).chr(10));
       fwrite($fhandle, $myfrags.chr(13).chr(10));
       fwrite($fhandle, $oppfrags.chr(13).chr(10));
       fclose($fhandle);
       print "<P>&nbsp;</P>\n<P ALIGN=\"CENTER\">$LANGReceived</P>\n";
     }else{
       print "<P>&nbsp;</P>\n<P ALIGN=\"CENTER\">$LANGSaveError</P>\n";
     }
   }
 }else{

  //---------------------------------------
  //--- FIRST PAGE LOAD --- STARTS HERE ---
  //---------------------------------------

 // Get Opponent
   // SetNumberOfMatches
   if ($EliminationMode) {$NumMatches = 2*($NumPlayers-1);}else{$NumMatches = $NumPlayers-1;}
   for ($cnt = 0; $cnt < $NumMatches; $cnt++) {
     if ($Match[$cnt]->nameOne() == $user) {$opponent = $Match[$cnt]->nameTwo; $matchfound = $cnt;}
     if ($Match[$cnt]->nameTwo() == $user) {$opponent = $Match[$cnt]->nameOne; $matchfound = $cnt;}
   }

  if ($opponent == "") {
   // No Opponent
     print "<P>&nbsp;</P>\n";
     print "<P>&nbsp;</P>\n";
     print "<P ALIGN=\"CENTER\">$LANGNoOpponent</P>\n";
   }else{
  // Get Names (Unchanged if not teams)
     if ($TeamMode) {
      $fhandle = file("data/teams/$user.dat");
      $player1 = trim($fhandle[0]);
      $fhandle = file("data/teams/$opponent.dat");
      $player2 = trim($fhandle[0]);
     }else{
      $player1 = $user;
      $player2 = $opponent;
     }
  // Check if opponent has already submitted details
     if (file_exists("data/submissions/".$opponent.".dat")) {
     // submission exists - lets read it
       $fhandle = file("data/submissions/".$opponent.".dat");
       $theiropp = substr($fhandle[0],0,strlen($fhandle[0])-2);
       if ($user == $theiropp) {
        // They've already posted a submission on this match
        $oppfrags = substr($fhandle[1],0,strlen($fhandle[1])-2);
        $myfrags = substr($fhandle[2],0,strlen($fhandle[2])-2);

        // Display these to the user
         print "<P>&nbsp;</P>\n";
         print "<P>&nbsp;</P>\n";
         print "<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\" ALIGN=\"CENTER\">\n";
         print " <TR>\n";
         print "  <TD COLSPAN=\"2\">$player2 $LANGSubmission:</TD>\n";
         print " </TR>\n";
         print " <TR>\n";
         print "  <TD ALIGN=\"RIGHT\">$player1:</TD><TD><FONT COLOR=\"#FFFF00\">$myfrags</FONT> $LANGFrags</TD>\n";
         print " </TR>\n";
         print " <TR>\n";
         print "  <TD ALIGN=\"RIGHT\">$player2:</TD><TD><FONT COLOR=\"#FFFF00\">$oppfrags</FONT> $LANGFrags</TD>\n";
         print " </TR>\n";
         print "</TABLE>\n<HR WIDTH=\"30%\" COLOR=\"$HighColour\" ALIGN=\"CENTER\" />\n";
       }else{
       // it's old discard it (well, not discard... ignore)
         print "<P>&nbsp;</P>\n";
         print "<P>&nbsp;</P>\n";
         print "<P ALIGN=\"CENTER\">$LANGNoResults</P>\n<HR WIDTH=\"30%\" COLOR=\"$HighColour\" ALIGN=\"CENTER\" />";
       }
     }else{
       print "<P>&nbsp;</P>\n";
       print "<P>&nbsp;</P>\n";
       print "<P ALIGN=\"CENTER\">$LANGNoResults</P>\n<HR WIDTH=\"30%\" COLOR=\"$HighColour\" ALIGN=\"CENTER\" />";
     }
     if (file_exists("data/submissions/".$user.".dat")) {
       $fhandle = file("data/submissions/".$user.".dat");
       $myopp = substr($fhandle[0],0,strlen($fhandle[0])-2);
       $prevmyfrags = intval(substr($fhandle[1],0,strlen($fhandle[1])-2));
       $prevoppfrags = intval(substr($fhandle[2],0,strlen($fhandle[2])-2));
       if ($myopp == $opponent) {
         print "<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\" ALIGN=\"CENTER\">\n";
         print " <TR>\n";
         print "  <TD COLSPAN=\"2\">$LANGAlreadySubmitted:</TD>\n";
         print " </TR>\n";
         print " <TR>\n";
         print "  <TD ALIGN=\"RIGHT\">$player1:</TD><TD><FONT COLOR=\"#FFFF00\">$prevmyfrags</FONT> $LANGFrags</TD>\n";
         print " </TR>\n";
         print " <TR>\n";
         print "  <TD ALIGN=\"RIGHT\">$player2:</TD><TD><FONT COLOR=\"#FFFF00\">$prevoppfrags</FONT> $LANGFrags</TD>\n";
         print " </TR>\n";
         print "</TABLE>\n<HR WIDTH=\"30%\" COLOR=\"$HighColour\" ALIGN=\"CENTER\" />\n";
       }
     }
     print "<P>&nbsp;</P>\n";
     print "<FORM METHOD=\"POST\" ACTION=\"main.php?page=loadcode&code=submitupdate&match=".$matchfound."\">\n";
     print "<INPUT TYPE=\"HIDDEN\" NAME=\"BeenSubmitted\" VALUE=\"true\">\n";
     print "<INPUT TYPE=\"HIDDEN\" NAME=\"Opponent\" VALUE=\"$opponent\">\n";
     print "<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\" ALIGN=\"CENTER\">\n";
     print " <TR>\n";
     print "  <TD COLSPAN=\"2\"><FONT COLOR=\"#FFFF00\">$LANGSubmit</FONT></TD>\n";
     print " </TR>\n";
     print " <TR><TD COLSPAN=\"2\" HEIGHT=\"30\"></TD></TR>\n";
     print " <TR>\n";
     print "  <TD ALIGN=\"RIGHT\">$player1:</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"MyFrags\" VALUE\"$prevmyfrags\" SIZE=\"5\"> $LANGFrags</TD>\n";
     print " </TR>\n";
     print " <TR>\n";
     print "  <TD ALIGN=\"RIGHT\">$player2:</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"OppFrags\" VALUE\"$prevoppfrags\" SIZE=\"5\"> $LANGFrags</TD>\n";
     print " </TR>\n";
     print " <TR>\n";
     print "  <TD COLSPAN=\"2\">&nbsp;</TD>\n";
     print " </TR>\n";
     print " <TR>\n";
     print "  <TD COLSPAN=\"2\" ALIGN=\"CENTER\"><INPUT TYPE=\"SUBMIT\" NAME=\"cmdSubmit\" VALUE=\"Update\"></TD>\n";
     print " </TR>\n";
     print "</TABLE>\n";
     print "</FORM>\n";
   }
 }
}else{
  print "<P>&nbsp;</P><P>&nbsp;</P><P ALIGN=\"CENTER\">$LANGNotCaptain</P>\n";
}
?>