<?php

 // This file is an include file, which will provide support for
 // saving and loading tournament files in from and to an array.

 // This array is based on files contained in "tourneyarray.php"

 function ElimMode ($InputText) {
   $OutputValue = false;
   if (strtoupper(substr($InputText,0,6)) == "TRUE") {$OutputValue = true;}
   if (strtoupper(substr($InputText,0,6)) == "DOUBLE") {$OutputValue = true;}
   if (intval($InputText) == 1) {$OutputValue = true;}
   return $OutputValue;
 }
 function TeamMode ($InputText) {
   $OutputValue = false;
   if (strtoupper(substr($InputText,0,6)) == "TRUE") {$OutputValue = true;}
   if (strtoupper(substr($InputText,0,6)) == "TEAMS") {$OutputValue = true;}
   if (intval($InputText) == 1) {$OutputValue = true;}
   return $OutputValue;
 }



 // This Function is input the filename ($filename) of where to
 // Save the tournament.  Usually "data/tournament.dat"

 // If Successful, it will return true, else false.

 function SaveTourney ($filename, $PlayerCount, $EliminationMode, $Match, $TeamMode) {
   if ($fhandle = fopen($filename, "w")) {
     if ($EliminationMode) {$EliminationMode = "true";}else{$EliminationMode = "false";}
     if ($TeamMode) {$TeamMode = "true";}else{$TeamMode = "false";}
     fwrite ($fhandle, strval($EliminationMode).chr(13).chr(10));
     fwrite ($fhandle, strval($TeamMode).chr(13).chr(10));
     fwrite ($fhandle, $PlayerCount.chr(13).chr(10));

     if ($EliminationMode == "true") {$UBound = (2*$PlayerCount)-1;}else{$UBound = ($PlayerCount -1);}
     for ($cnt = 0; $cnt < $UBound; $cnt++){
       fwrite ($fhandle, $Match[$cnt]->nameOne().chr(13).chr(10));
       fwrite ($fhandle, $Match[$cnt]->nameTwo().chr(13).chr(10));
       fwrite ($fhandle, $Match[$cnt]->fragsOne().chr(13).chr(10));
       fwrite ($fhandle, $Match[$cnt]->fragsTwo().chr(13).chr(10));
       fwrite ($fhandle, $Match[$cnt]->serverAddr().chr(13).chr(10));
       fwrite ($fhandle, $Match[$cnt]->startTime().chr(13).chr(10));
     }
     fclose ($fhandle);

     return true;
   }else{
     return false;
   }
 }

 function LoadTourney ($filename, $PlayerCount, $EliminationMode, $Match, $TeamMode) {
   if ($fhandle = file($filename)) {
     $EliminationMode = ElimMode(trim($fhandle[0]));
     $TeamMode = TeamMode(trim($fhandle[1]));
     $PlayerCount = intval(trim($fhandle[2]));

  // Initialise
     $NumMatches = ($PlayerCount -  1);
     if ($EliminationMode) {$NumMatches = $NumMatches *2 +1;}
     for ($cnt = 0; $cnt < ($NumMatches+2); $cnt++) {$Match[$cnt] = new MatchType;}

     for ($cnt = 3; $cnt < (($PlayerCount -1)*6 +2); $cnt += 6) {
      $mtc = (int)round(($cnt-2)/6);
        $Match[$mtc]->nameOne(trim(substr($fhandle[$cnt],0,strlen($fhandle[$cnt])-2)));
        $Match[$mtc]->nameTwo(trim(substr($fhandle[$cnt+1],0,strlen($fhandle[$cnt+1])-2)));
        $Match[$mtc]->fragsOne(substr($fhandle[$cnt+2],0,strlen($fhandle[$cnt+2])-2));
        $Match[$mtc]->fragsTwo(substr($fhandle[$cnt+3],0,strlen($fhandle[$cnt+3])-2));
        $Match[$mtc]->serverAddr(substr($fhandle[$cnt+4],0,strlen($fhandle[$cnt+4])-2));
        $Match[$mtc]->startTime(substr($fhandle[$cnt+5],0,strlen($fhandle[$cnt+5])-2));
     }

     if ($EliminationMode) {
       for (; $cnt < ($NumMatches*6 +2); $cnt += 6) {
        $mtc = (int)round(($cnt-2)/6);
        $Match[$mtc]->nameOne(trim(substr($fhandle[$cnt],0,strlen($fhandle[$cnt])-2)));
        $Match[$mtc]->nameTwo(trim(substr($fhandle[$cnt+1],0,strlen($fhandle[$cnt+1])-2)));
        $Match[$mtc]->fragsOne(substr($fhandle[$cnt+2],0,strlen($fhandle[$cnt+2])-2));
        $Match[$mtc]->fragsTwo(substr($fhandle[$cnt+3],0,strlen($fhandle[$cnt+3])-2));
        $Match[$mtc]->serverAddr(substr($fhandle[$cnt+4],0,strlen($fhandle[$cnt+4])-2));
        $Match[$mtc]->startTime(substr($fhandle[$cnt+5],0,strlen($fhandle[$cnt+5])-2));
       }
     }
     $Match[$NumMatches+1]->nameTwo(".");
     return true;
   }else{
     return false;
   }
 }

?>