<?php

  //include file for team support

 
 //A reverse look-up for a player-team
 //Makes use of data/teamindex.txt
 function TeamOf ($PlayerName) {
   if (file_exists("data/teamindex.txt")) {
     $fhandle = file("data/teamindex.txt");
 
     $cnt = 0;
     $foundteam = false;
     while (!$foundteam && $cnt < count($fhandle)) {
       if ($PlayerName == trim($fhandle[$cnt])) {$foundteam = trim($fhandle[$cnt+1]);}
       $cnt +=2;
     }
     return $foundteam;
   }else{
     return false;
   }
 }
 

 //Find the nickname of team-captain of a team
 function TeamCaptain($TeamFilename) {
   if (file_exists("data/teams/$TeamFilename") && $TeamFilename) {
     $fhandle = file("data/teams/$TeamFilename");
     return trim($fhandle[2]);
   }else{
     return false;
   }
 }

 //Move Player
 function MovePlayerToTeam($PlayerName, $DestinationTeamFilename) {
   //Remove from old team 
   $OldTeam = TeamOf($PlayerName);
   $fhandle = file("data/teams/$OldTeam");
   
   $tmpArray = Array();
   for ($cnt = 0; $cnt < count($fhandle); $cnt++) {$tmpArray[$cnt] = trim($fhandle[$cnt]);}
   
   $fhandle = fopen("data/teams/$OldTeam", "w");
   fwrite ($fhandle, $tmpArray[0].chr(13).chr(10)); 
   fwrite ($fhandle, $tmpArray[1].chr(13).chr(10)); 
   for ($cnt = 2; $cnt < count($tmpArray); $cnt++) {
    if (strtoupper($PlayerName) != strtoupper($tmpArray[$cnt])) { fwrite ($fhandle, $tmpArray[$cnt].chr(13).chr(10));}
   }
   fclose ($fhandle);

   //Add to New Team
   $fhandle = fopen("data/teams/$DestinationTeamFilename","a");
   fwrite ($fhandle, $PlayerName.chr(13).chr(10));
   fclose ($fhandle);

   //Maintain TeamIndex file
   $whandle = fopen("data/teamindex.new", "w");
   $rhandle = file("data/teamindex.txt");
  
   for($cnt = 0; $cnt < count($rhandle); $cnt+=2) {
     $Pname = trim($rhandle[$cnt]);
     $Tfname = trim($rhandle[$cnt+1]);
     if (strtoupper($Pname) == strtoupper($PlayerName)) {$Tfname = $DestinationTeamFilename;}
     fwrite ($whandle, $Pname.chr(13).chr(10));
     fwrite ($whandle, $Tfname.chr(13).chr(10));
   }  
   fclose ($whandle);
   unlink ("data/teamindex.txt");
   rename ("data/teamindex.new", "data/teamindex.txt");
 }

 function renameTeam ($Team, $TeamName) {
   // $Team should be filename including ".dat"
   $fhandle = file("data/teams/$Team");
   $tmpArray = Array();
   for ($cnt = 0; $cnt < count($fhandle); $cnt++) {
     $tmpArray[$cnt] = trim($fhandle[$cnt]);
   }
   $tmpArray[0] = $TeamName;
   
   $fhandle = fopen ("data/teams/$Team","w");
   for ($cnt = 0; $cnt < count($tmpArray); $cnt++) {
     fwrite ($fhandle, $tmpArray[$cnt].chr(13).chr(10));
   }
   fclose($fhandle);
 }

 function colourTeam ($Team, $Colour) {
   // $Team should be filename including ".dat"
   $fhandle = file("data/teams/$Team");
   $tmpArray = Array();
   for ($cnt = 0; $cnt < count($fhandle); $cnt++) {
     $tmpArray[$cnt] = trim($fhandle[$cnt]);
   }
   $tmpArray[1] = $Colour;
   
   $fhandle = fopen ("data/teams/$Team","w");
   for ($cnt = 0; $cnt < count($tmpArray); $cnt++) {
     fwrite ($fhandle, $tmpArray[$cnt].chr(13).chr(10));
   }
   fclose($fhandle);
 }
?>