 <?php

//include file for processing tournament data

//this function will validate and update the tree, according to who wins, using the scores
//this should be called before the tree is displayed, to ensure correct viewing
  function UpdateTree($Match, $NumPlayers, $EliminationMode, $TeamMode) {

     $NumMatches = ($NumPlayers -  1);
     if ($EliminationMode) {$NumMatches = $NumMatches *2 -1;}

 // Primary Tree
    for ($cnt = 0; $cnt < $NumPlayers; $cnt++) {
      if ($Match[$cnt]->fragsOne() > $Match[$cnt]->fragsTwo()) {
        $Winner = $Match[$cnt]->nameOne();
        if ($EliminationMode) {$Loser = $Match[$cnt]->nameTwo();}
      }elseif ($Match[$cnt]->fragsOne() < $Match[$cnt]->fragsTwo()){
        $Winner = $Match[$cnt]->nameTwo();
        if ($EliminationMode) {$Loser = $Match[$cnt]->nameOne();}
      }else{
        $Winner = "";
        if ($EliminationMode) {$Loser = "";}
      }
      
      if (trim($Match[$cnt]->nameTwo()) == "" || trim($Match[$cnt]->nameOne()) == "") {
        $Winner = ""; 
        if($EliminationMode) {$Loser="";}
      }else{
     // Clear-up drop-outs;
       if (!$TeamMode) {
        if (!PlayerExists($Match[$cnt]->nameOne())) {$Winner = $Match[$cnt]->nameTwo(); if ($EliminationMode) {$Loser = $Match[$cnt]->nameOne();}}
        if (!PlayerExists($Match[$cnt]->nameTwo())) {$Winner = $Match[$cnt]->nameOne(); if ($EliminationMode) {$Loser = $Match[$cnt]->nameTwo();}}
       }
      }

      $ChildBox = primaryChildOf(($cnt*2),$NumPlayers);
      $ChildMatch = floor($ChildBox/2);

      if ($Winner == "") {$Winner = " ";}
      if ($Loser == "" && $EliminationMode) {$Loser = " ";}
      if ($ChildBox/2 == round($ChildBox/2)) {
        $Match[$ChildMatch]->nameOne($Winner);
      }else{
        $Match[$ChildMatch]->nameTwo($Winner);
      }

      if ($EliminationMode) {
        $LoserBox = primaryLoserBoxOf(($cnt*2), $NumPlayers) + ($NumPlayers *2)-1;
        $LoserMatch = ceil($LoserBox/2);

        if ($LoserBox/2 != round($LoserBox/2)) {
          $Match[$LoserMatch]->nameOne($Loser);
        }else{
          $Match[$LoserMatch]->nameTwo($Loser);
        }
      }
    }

 // Loser Tree
    if ($EliminationMode) {
     for (; $cnt <= $NumMatches; $cnt++) {
      if ($Match[$cnt]->fragsOne() > $Match[$cnt]->fragsTwo()) {
        $Winner = $Match[$cnt]->nameOne();
      }elseif ($Match[$cnt]->fragsOne() < $Match[$cnt]->fragsTwo()){
        $Winner = $Match[$cnt]->nameTwo();
      }else{
        $Winner = "";
      }

      if (trim($Match[$cnt]->nameTwo()) == "" || trim($Match[$cnt]->nameOne()) == "") {$Winner = "";}

      $LoserMatch = $cnt - $NumPlayers;
      $LoserBox = $LoserMatch *2;

      $ChildBox = loserChildOf($LoserBox,$NumPlayers);
      $ChildMatch = floor($ChildBox/2) + $NumPlayers;


      if ($Winner == "") {$Winner = " ";}
      if ($ChildBox/2 == round($ChildBox/2)) {
        $Match[$ChildMatch]->nameOne($Winner);
      }else{
        $Match[$ChildMatch]->nameTwo($Winner);
      }
     }
     //FINAL
      $FinalMatch = (2 * $NumPlayers)-2;
      $PrimaryMatch = $NumPlayers-2;
      $LoserMatch = $FinalMatch -1;

      if ($Match[$PrimaryMatch]->fragsOne() > $Match[$PrimaryMatch]->fragsTwo()) {
        $PWinner = $Match[$PrimaryMatch]->nameOne();
      }elseif ($Match[$PrimaryMatch]->fragsOne() < $Match[$PrimaryMatch]->fragsTwo()){
        $PWinner = $Match[$PrimaryMatch]->nameTwo();
      }else{
        $PWinner = "";
      }

      if ($Match[$LoserMatch]->fragsOne() > $Match[$LoserMatch]->fragsTwo()) {
        $LWinner = $Match[$LoserMatch]->nameOne();
      }elseif ($Match[$LoserMatch]->fragsOne() < $Match[$LoserMatch]->fragsTwo()){
        $LWinner = $Match[$LoserMatch]->nameTwo();
      }else{
        $LWinner = "";
      }

      $Match[$FinalMatch]->nameOne($PWinner);
      $Match[$FinalMatch]->nameTwo($LWinner);
    }
  }

  function PlayerExists($Nickname) {
    if (file_exists("users/$Nickname.php")) {
      include ("users/$Nickname.php");
      if ($InTourney) {
        return true;
      }else{
        return false;
      }
    }else{
      return false;
    }
  }
?>