<?php

  //include file for team support


 //A reverse look-up for a player-league
 //Makes use of data/teamindex.txt
 function LeagueOf ($PlayerName) {
   if (file_exists("data/leagueindex.txt")) {
     $fhandle = file("data/leagueindex.txt");

     $cnt = 0;
     $foundleague = false;
     while (!$foundleague && $cnt < count($fhandle)) {
       if ($PlayerName == trim($fhandle[$cnt])) {$foundleague = trim($fhandle[$cnt+1]);}
       $cnt +=2;
     }
     return $foundleague;
   }else{
     return false;
   }
 }

 // Modify $UnplayedMatches to return array of Unplayed Matches
 function UnplayedArray($PlayerName, $UnplayedMatches, $TeamMode) {
   if ($TeamMode) {$Pname = TeamOf($PlayerName); $Pname = substr($Pname, 0, strlen($Pname)-4);}else{$Pname = $PlayerName;}
   $League = LeagueOf($Pname);
   if (file_exists("data/leagues/$League")) {
     $fhandle = file("data/leagues/$League");
     $playedhome = Array();
     $playedaway = Array();
     $NameList = Array();
     $Players = 0;
     for ($cnt = 0; $cnt < count($fhandle); $cnt+=4) {
       $NextPlayer = trim($fhandle[$cnt]);
       if (strtoupper($NextPlayer) != strtoupper($Pname)) {
         $NameList[$Players++]=$NextPlayer;
         $playedhome[$NextPlayer]=false;
         $playedaway[$NextPlayer]=false;
         if (file_exists("data/leaguedata/$Pname.dat")) {
           $f2handle = file("data/leaguedata/$Pname.dat");
           for ($cnt2 = 0; $cnt2 < count($f2handle); $cnt2++); {
             $ThisPlayer = substr(trim($f2handle[$cnt2]));
             if (strtoupper($NextPlayer) == strtoupper($ThisPlayer, 0, strlen($NextPlayer))) {
               //Found a Match
               if (strtoupper(substr($f2handle[$cnt2], -4)) == "HOME") {$playedhome[$NextPlayer]=true;}
               if (strtoupper(substr($f2handle[$cnt2], -4)) == "AWAY") {$playedaway[$NextPlayer]=true;}
             }
           }
         }
       }
     }
     $Outnum = 0;
     for ($cnt = 0; $cnt < count($NameList); $cnt++) {
       if (!$playedhome[$NameList[$cnt]]) {$UnplayedMatches[$Outnum++] = $NameList[$cnt]." (Home)";}
       if (!$playedaway[$NameList[$cnt]]) {$UnplayedMatches[$Outnum++] = $NameList[$cnt]." (Away)";}
     }
   }
 }

 //Display a table containing all the players a particular player hasn't played
 function UnplayedMatches($PlayerName, $TeamMode) {
   $League = LeagueOf($PlayerName);
   if (file_exists("data/leagues/$League")) {
     $fhandle = file("data/leagues/$League");
     if ($TeamMode) {$thandle = file("data/teams/$PlayerName.dat"); $Pname = trim($thandle[0]);}else{$Pname = $PlayerName;}

     print "<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" ALIGN=\"CENTER\">\n";
     print " <TR><TD ALIGN=\"CENTER\" HEIGHT=\"30\"><FONT SIZE=\"4\">$Pname</FONT></TD></TR>\n";

     $playedhome = Array();
     $playedaway = Array();
     $NameList = Array();
     $Players = 0;
     for ($cnt = 0; $cnt < count($fhandle); $cnt+=4) {
       $NextPlayer = trim($fhandle[$cnt]);
       // Check if NextPlayer is not themself
       if (strtoupper($NextPlayer) != strtoupper($PlayerName)) {
         //Check if Next Player has not already been played
         $NameList[$Players++]=$NextPlayer;
         $playedhome[$NextPlayer]=false;
         $playedaway[$NextPlayer]=false;
         if (file_exists("data/leaguedata/$PlayerName.dat")) {
           $f2handle = file("data/leaguedata/$PlayerName.dat");
           // This FOR-Loop is why you really shouldn't let each league have too many players, anything under 30 is a pretty healthy amount
           for ($cnt2 = 0; $cnt2 < count($f2handle); $cnt2++); {
             $ThisPlayer = substr(trim($f2handle[$cnt2]));
             if (strtoupper($NextPlayer) == strtoupper($ThisPlayer, 0, strlen($NextPlayer))) {
               //Found a Match
               if (strtoupper(substr($f2handle[$cnt2], -4)) == "HOME") {$playedhome[$NextPlayer]=true;}
               if (strtoupper(substr($f2handle[$cnt2], -4)) == "AWAY") {$playedaway[$NextPlayer]=true;}
             }
           }
         }
       }
     }
     for ($cnt = 0; $cnt < count($NameList); $cnt++) {
       $Pname = $NameList[$cnt];
       if ($TeamMode) {$thandle = file("data/teams/".$NameList[$cnt].".dat"); $Pname = trim($thandle[0]);}
       if ($TeamMode) {$Link = "main.php?page=viewteam&team=".$NameList[$cnt];}else{$Link = "main.php?page=viewuser&user=$Pname";}
       if (!$playedhome[$NameList[$cnt]]) {print "<TR><TD ALIGN=\"CENTER\"><A HREF=\"$Link\"><FONT SIZE=\"2\">$Pname</FONT></A><FONT SIZE=\"2\"> (Home)</FONT></TD></TR>\n";}
       if (!$playedaway[$NameList[$cnt]]) {print "<TR><TD ALIGN=\"CENTER\"><A HREF=\"$Link\"><FONT SIZE=\"2\">$Pname</FONT></A><FONT SIZE=\"2\"> (Away)</FONT></TD></TR>\n";}
     }
     print "</TABLE>\n";
   }
 }

 //League Update Function
 function LeagueUpdate ($PlayerName, $OpponentName, $PlayerMode, $PlayerFrags, $OpponentFrags) {
   //This does not validate existing matches
   $League = LeagueOf($PlayerName);

   //Update Scores
   $fhandle = file ("data/leagues/$League");
   $tmparray = Array();
   for ($cnt = 0; $cnt < count($fhandle); $cnt++) {
     $tmparray[$cnt] = trim($fhandle[$cnt]);
   }

   $fhandle = fopen ("data/leagues/$League","w");
   for ($cnt = 0; $cnt < count($tmparray); $cnt+=4) {
      $Pname = $tmparray[$cnt];
      $Pwin  = intval($tmparray[$cnt+1]);
      $Pdraw = intval($tmparray[$cnt+2]);
      $Ploss = intval($tmparray[$cnt+3]);

      if (strtoupper($Pname) == strtoupper($PlayerName)) {
        if (intval($PlayerFrags) > intval($OpponentFrags)) {$Pwin++;}
        if (intval($PlayerFrags) == intval($OpponentFrags)) {$Pdraw++;}
        if (intval($PlayerFrags) < intval($OpponentFrags)) {$Ploss++;}
      }
      if (strtoupper($Pname) == strtoupper($OpponentName)) {
        if (intval($PlayerFrags) < intval($OpponentFrags)) {$Pwin++;}
        if (intval($PlayerFrags) == intval($OpponentFrags)) {$Pdraw++;}
        if (intval($PlayerFrags) > intval($OpponentFrags)) {$Ploss++;}
      }
      fwrite ($fhandle, $Pname.chr(13).chr(10));
      fwrite ($fhandle, $Pwin.chr(13).chr(10));
      fwrite ($fhandle, $Pdraw.chr(13).chr(10));
      fwrite ($fhandle, $Ploss.chr(13).chr(10));
   }
   fclose($fhandle);

   //Update Players Played Lists
   $fhandle = fopen ("data/leaguedata/$PlayerName.dat","a");
   fwrite ($fhandle, "$OpponentName $PlayerMode".chr(13).chr(10));
   fclose ($fhandle);
   if ($PlayerMode == "AWAY") {$OpponentMode = "HOME";}else{$OpponentMode = "AWAY";}
   $fhandle = fopen ("data/leaguedata/$OpponentName.dat","a");
   fwrite ($fhandle, "$PlayerName $OpponentMode".chr(13).chr(10));
   fclose ($fhandle);

   SortLeague ($League);
 }

 //Sorts League In Order of scores
 function SortLeague ($League) {

   $fhandle = file ("data/leagues/$League");
   $tmparray = Array();
   for ($cnt = 0; $cnt < count($fhandle); $cnt++) {
     $tmparray[$cnt] = trim($fhandle[$cnt]);
   }

   for ($cnt1 = 0; $cnt1 < count($tmparray); $cnt1+=4) {
     for ($cnt2 = 0; $cnt2 < $cnt1; $cnt2+=4) {
       $P1Wins = intval($tmparray[$cnt1+1]);
       $P1Draws = intval($tmparray[$cnt1+2]);
       $P1Losses = intval($tmparray[$cnt1+3]);

       $P2Wins = intval($tmparray[$cnt2+1]);
       $P2Draws = intval($tmparray[$cnt2+2]);
       $P2Losses = intval($tmparray[$cnt2+3]);

       $CNT1Points = ($P1Wins * $WonPoints) + ($P1Draws * $DrawnPoints) + ($P1Losses * $LostPoints);
       $CNT2Points = ($P2Wins * $WonPoints) + ($P2Draws * $DrawnPoints) + ($P2Losses * $LostPoints);
       $ShouldSwap = false;

       if ($P2Losses > $P1Losses) {$ShouldSwap = true;}
       if ($P2Draws < $P1Draws) {$ShouldSwap = true;}
       if ($P2Wins < $P1Wins) {$ShouldSwap = true;}
       if ($CNT2Points < $CNT1Points) {$ShouldSwap = true;}
       if ($ShouldSwap) {
         $P1Name = $tmparray[$cnt1];
         $P1Win  = $tmparray[$cnt1+1];
         $P1Draw = $tmparray[$cnt1+2];
         $P1Loss = $tmparray[$cnt1+3];

         $tmparray[$cnt1]   = $tmparray[$cnt2];
         $tmparray[$cnt1+1] = $tmparray[$cnt2+1];
         $tmparray[$cnt1+2] = $tmparray[$cnt2+2];
         $tmparray[$cnt1+3] = $tmparray[$cnt2+3];

         $tmparray[$cnt2]   = $P1Name;
         $tmparray[$cnt2+1] = $P1Win;
         $tmparray[$cnt2+2] = $P1Draw;
         $tmparray[$cnt2+3] = $P1Loss;
       }
     }
   }

   $fhandle = fopen ("data/leagues/$League","w");
   for ($cnt = 0; $cnt < count($tmparray); $cnt+=4) {
      fwrite ($fhandle, $tmparray[$cnt].chr(13).chr(10));
      fwrite ($fhandle, $tmparray[$cnt+1].chr(13).chr(10));
      fwrite ($fhandle, $tmparray[$cnt+2].chr(13).chr(10));
      fwrite ($fhandle, $tmparray[$cnt+3].chr(13).chr(10));
   }
   fclose($fhandle);
 }

 function IsLeagueComplete($League) { //Include .dat in $League
   if (file_exists("data/leagues/$League")) {
     $fhandle = file("data/leagues/$League");
     $NumPlayers = count($fhandle)/4;
     $NumMatches = 2 * ($NumPlayers - 1);
     $IsComplete = true;
     for ($cnt = 0; ($cnt < count($fhandle) && $IsComplete); $cnt+=4) {
       $Played = intval($fhandle[$cnt+1]) + intval($fhandle[$cnt+2]) + intval($fhandle[$cnt+3]);
       if ($Played < $NumMatches) {$IsComplete = false;}
     }
     return $IsComplete;
   }else{ return true;}   
 }
?>