<?php

 //include file for help displaying tournament trees.
 //specifically text ones.

 function CreateMatrix ($matrix, $rows, $cols, $Match, $NumPlayers, $EliminationMode, $TeamMode, $TreeDetails = false) {
   include ("options/admin/config.php");
   include ("options/admin/colours.php");

   $NameStyle = "WIDTH=\"150\" VALIGN=\"MIDDLE\" BGCOLOR=\"$MenuColour\"";

   $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
   if (!$EliminationMode) {
     $rows = $IdealPlayers * 2;
     $cols = primaryColumns($NumPlayers) * 2;
     $SEOffsetX = 0;
     $SEOffsetY = 0;
   }else{
     $rows = $IdealPlayers *3+1;
     $cl1 = primaryColumns($NumPlayers); $cl2 = loserColumns($NumPlayers);
     if ($cl1>$cl2) {$cl = $cl1;$SEOffsetX=0;$DEOffsetX=($cl1-$cl2)*2;}else{$cl=$cl2;$SEOffsetX=($cl2-$cl1)*2;$DEOffsetX=0;}
     $cols = ($cl+1)* 2;
   }


   $NumBoxes = ($NumPlayers*2)-1;
   if ($EliminationMode) {$NumBoxes += ($NumPlayers *2)-3;}


   for ($cnt = 0; $cnt < $NumBoxes; $cnt++) {
     if ($cnt >= ($NumPlayers*2)-1) {$LoserTree = true;}else{$LoserTree = false;} $PrimaryTree = !$LoserTree;
     if ($PrimaryTree) {$MatchNum = floor($cnt/2);}else{$MatchNum = floor(($cnt+1)/2);}

  // HTML LOCATION

     if ($PrimaryTree) {
       $cl = primaryColumnOf($MatchNum, $NumPlayers);
       $rw = round(pow(2, ($cl -1))-1) + (round(pow(2, $cl)) * ((primaryBoxRow($cnt, $NumPlayers))));
       $col = ($cl * 2) - 1;
       $SEOffsetY=0;

       $DEOffsetY = $IdealPlayers *2;

       $col += $SEOffsetX;
       $rw += $SEOffsetY;
     }else{
       $PMatch = floor(($cnt - (($NumPlayers*2)-1))/2);
       $cl = loserColumnOf($PMatch,$NumPlayers);
       $rw = loserHTMLRow($cnt - (($NumPlayers*2)-1), $NumPlayers);
       $col = (($cl - 1) * 2)+1;

       $DEOffsetY = $IdealPlayers *2;

       $col += $DEOffsetX;
       $rw += $DEOffsetY;
     }

     if ($cnt == ($NumPlayers *2)-2  && $EliminationMode) {$MatchNum=(2 * $NumPlayers)-2;}
     if (($cnt/2 == round($cnt/2) && ($PrimaryTree)) || ($cnt/2 != round($cnt/2) && $LoserTree && $MatchNum != (2 * $NumPlayers)-2)) {
       $PlayerName = $Match[$MatchNum]->nameOne();
       if ($DisplayMatchColours && $TreeDetails) {$Frags = $Match[$MatchNum]->fragsOne();}else{$Frags = "";}
     }else{
       $PlayerName = $Match[$MatchNum]->nameTwo();
       if ($DisplayMatchColours && $TreeDetails) {$Frags = $Match[$MatchNum]->fragsTwo();}else{$Frags = "";}
     }
     if (trim($PlayerName) == "") {$PlayerName = ""; $Frags="";}elseif ($TeamMode) {$thandle = file("data/teams/$PlayerName.dat"); $PlayerName = trim($thandle[0]);}


  // Create Link
     if ($PrimaryTree) {
       $MatchLink = (floor(primaryParentOf($cnt, $NumPlayers)/2));
       if (primaryIsPrimary($cnt, $NumPlayers, false)) {
         if ($TeamMode) {
           $URLLink = "main.php?page=viewteams";
         }else{
           $URLLink = "main.php?page=viewuser&user=".$PlayerName;
         }
       }else{
         $URLLink = "main.php?page=loadcode&code=displaymatch&match=".$MatchLink;
       }
     }else{
       if (loserIsPrimary($cnt- (($NumPlayers*2)-1), $NumPlayers)) {
         $MatchLink = loserNumPrimaryTo($cnt - (($NumPlayers*2)-1), $NumPlayers);
       }else{
         $MatchLink = ($cnt - (($NumPlayers*2)-1) - loserNumPrimaryTo($cnt - (($NumPlayers*2)-1), $NumPlayers)) + $NumPlayers ;
       }
       $URLLink = "main.php?page=loadcode&code=displaymatch&match=".$MatchLink;
     }


     // Display Colours (Green = Winner & Red = Loser)
        if ((!PlayerExists($PlayerName) && !$TeamMode) && trim($PlayerName) != "") {
         if ($DisplayMatchColours || $TreeDetails) {$PlayerName ="<FONT COLOR=\"$LoserColour\">$PlayerName</FONT>"; }
        }else{
         if ($DisplayMatchColours && intval($Match[$MatchNum]->fragsOne()) != intval($Match[$MatchNum]->fragsTwo()) && trim($Match[$MatchNum]->nameOne()) != "" && trim($Match[$MatchNum]->nameTwo()) != "") {
          if (($cnt/2 == round($cnt/2) && ($PrimaryTree)) || ($cnt/2 != round($cnt/2) && $LoserTree && $MatchNum != (2 * $NumPlayers)-2)) {
           if ($Match[$MatchNum]->fragsOne() > $Match[$MatchNum]->fragsTwo()) {$PlayerName = "<FONT COLOR=\"$WinnerColour\">$PlayerName</FONT>";}
           if ($Match[$MatchNum]->fragsTwo() > $Match[$MatchNum]->fragsOne()) {$PlayerName = "<FONT COLOR=\"$LoserColour\">$PlayerName</FONT>";}
          }else{
           if ($Match[$MatchNum]->fragsOne() > $Match[$MatchNum]->fragsTwo()) {$PlayerName = "<FONT COLOR=\"$LoserColour\">$PlayerName</FONT>";}
           if ($Match[$MatchNum]->fragsTwo() > $Match[$MatchNum]->fragsOne()) {$PlayerName = "<FONT COLOR=\"$WinnerColour\">$PlayerName</FONT>";}
          }
         }
        }


  // Fill Matrix Cell
     if (strlen($Frags)>0) {$Frags = " <FONT SIZE=\"2\">($Frags)</FONT>";}
     if (trim($PlayerName) == "") {$PlayerName = "<FONT SIZE=\"1\" COLOR=\"$TextColour\">(unplayed)</FONT>";}
     $Result = $NameStyle."><A HREF=\"".$URLLink."\">$PlayerName</A>$Frags";
     $matrix[$col][$rw] = $Result;


  // Display Match Details if it isn't a primary match, and option is enabled
     if (((!primaryIsPrimary($cnt, $NumPlayers, false) && $PrimaryTree) || ($LoserTree && !loserIsPrimary($cnt - (($NumPlayers*2)-1), $NumPlayers))) && $TreeDetails)  {
       if ($PrimaryTree) {
         $Pcnt = primaryParentOf($cnt, $NumPlayers);
         $PMatchNum = floor($Pcnt /2);
       }else{
         $Pcnt = loserParentOf($cnt - (($NumPlayers*2)-1), $NumPlayers);
         $PMatchNum =$MatchLink;
       }
       $StartTime = $Match[$PMatchNum]->startTime();
       $ServerAddr = $Match[$PMatchNum]->serverAddr();
       if (trim($StartTime)=="") {$StartTime = "(unset)";}
       if (trim($ServerAddr)=="") {$ServerAddr = "(unset)";} 
       $matrix[$col][($rw+1)] = "><FONT SIZE=\"1\">$ServerAddr @$StartTime</FONT>";
     }



  // Draw Lines


     if ((($col < ($cols -1)) && ($cnt/2 == round($cnt/2)) && $PrimaryTree) || (($LoserTree) && ($cnt/2 != round($cnt/2)) && ($col < ($cols -3)))) {
       $linecol = $col+1;
       $toprow = $rw;

       if ($PrimaryTree) {
         $botrow = round(pow(2, ($cl -1))-1) + (round(pow(2, $cl)) * ((primaryBoxRow($cnt+1, $NumPlayers))));
         if ($col == $cols-3 && $EliminationMode) {
           $botrow = loserHTMLRow(($NumPlayers *2)-2, $NumPlayers); // Line connecting Primary & Losers Tree
           $childrow = ceil(($toprow + $botrow)/2);
           $FINALBOX = $childrow;
         }else{
           $childbox = primaryChildOf ($cnt, $NumPlayers);
           $childMatch = floor($childbox/2);
           $childCl = primaryColumnOf($childMatch, $NumPlayers);
           $childrow = round(pow(2, ($childCl -1))-1) + (round(pow(2, $childCl)) * ((primaryBoxRow($childbox, $NumPlayers))));
         }
       }else{
         $me = $cnt - (($NumPlayers*2)-1);
         $botrow = loserHTMLRow($me +1, $NumPlayers) + $DEOffsetY;
         $childbox = loserChildOf ($me, $NumPlayers);
         $childMatch = floor($childbox/2);
         $childCl = loserColumnOf($childMatch, $NumPlayers);
         $childrow = loserHTMLRow($childbox, $NumPlayers) + $DEOffsetY;
       }

       for ($row = $toprow; $row < $botrow +1; $row++) {
         if ($row == $toprow) {
           //Top Corner
           $matrix[$linecol][$row] = "WIDTH=\"10\" BACKGROUND=\"images/tree/ct.gif\">";
         }elseif ($row == $botrow) {
           //Bot Corner
           $matrix[$linecol][$row] = "WIDTH=\"10\" BACKGROUND=\"images/tree/cb.gif\">";
         }elseif ($row == $childrow) {
           //Mid T-Junc
           $matrix[$linecol][$row] = "WIDTH=\"10\" BACKGROUND=\"images/tree/cm.gif\">";
         }else{
           //Normal Vertical Line
           $matrix[$linecol][$row] = "WIDTH=\"10\" BACKGROUND=\"images/tree/vt.gif\">";
         }
       }
     }
   }
   // Elimination Finals
   if ($EliminationMode) {
      $col = $cols-1;
      $rw = $FINALBOX;

      $FinalMatch = ceil($NumBoxes/2);

      $PWinnerMatch = $NumPlayers - 2;
      if ($Match[$FinalMatch]->fragsOne() + $Match[$FinalMatch]->fragsTwo() > 0) {
        if ($Match[$FinalMatch]->fragsOne() > $Match[$FinalMatch]->fragsTwo()) {$Winner = $Match[$FinalMatch]->nameOne();}elseif ($Match[$FinalMatch]->fragsOne() < $Match[$FinalMatch]->fragsTwo()) {$Winner = $Match[$FinalMatch]->nameTwo();}else{$Winner="";}
      }else{$Winner="";}
      if (trim($Winner)=="") {$Winner="";}

      if ($Winner == "") {$Winner = "<FONT SIZE=\"1\" COLOR=\"$TextColour\">(unplayed)</FONT>";}
      $URLLink = "main.php?page=loadcode&code=displaymatch&match=".$FinalMatch;
      $Result = $NameStyle."><A HREF=\"".$URLLink."\">$Winner</A>";
      $matrix[$col][$rw] = $Result;
      $ServerAddr = $Match[$FinalMatch]->serverAddr(); 
      $StartTime = $Match[$FinalMatch]->startTime();
      if (trim($ServerAddr)=="") {$ServerAddr = "(unset)";} 
      if (trim($StartTime)=="") {$StartTime = "(unset)";}
      if ($TreeDetails) {$matrix[$col][($rw+1)] = "><FONT SIZE=\"1\">$ServerAddr @$StartTime</FONT>";}
   }
 }


 //Will turn the multi-dimensional array into an HTML Table
 function DisplayMatrix ($matrix, $rows, $cols) {
   $wdth = ($cols/2) * 180;
   print "<TABLE CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\" WIDTH=\"$wdth\">\n";
   for ($Rcnt = 0; $Rcnt < $rows; $Rcnt++) {
     print "  <TR>\n";
     for ($Ccnt = 0; $Ccnt < $cols; $Ccnt++) {
       $content = $matrix[$Ccnt][$Rcnt];
       if ($content == "") {$content = ">&nbsp;";}
       print ("    <TD ALIGN=\"CENTER\" ".$content."</TD>\n");
     }
     print "  </TR>\n";
   }
   print "</TABLE>\n";
 }
?>