<?php

//Basic Tree Geometry

//This include file will provide support for traversing the tree,
//and being able to find relative places from current, etc.


//Find the number of columns in PrimaryTree
  function primaryColumns ($NumPlayers) {
    return ceil(log($NumPlayers)/log(2))+1;
  }

//Find the column a match is listed in PrimaryTree
  function primaryColumnOf($MatchNum, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    if ($NumPlayers - ($MatchNum +1) == 0) {
      $out = primaryColumns($IdealPlayers);
    }else{
      $out = primaryColumns($NumPlayers) - floor(log($NumPlayers - ($MatchNum + 1))/log(2)) -1;
    }
    return $out;
  }

//Is Match at left-most of tree (the leaves) on Primary Tree
  function primaryIsPrimary ($MatchNum, $NumPlayers, $AsMatch = true) {

    // AsMatch: true MatchNum = Box Of Match(default) ; false = Box of Player (Adv)

    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    if ($IdealPlayers == $NumPlayers) {

      //Perfect Tree

      if (($MatchNum < $NumPlayers/2 && $AsMatch) || (!$AsMatch && $MatchNum < $NumPlayers )) {
        return true;
      }else{
        return false;
      }
    }else{

      //Imperfect Tree

      $PreMatches = ($NumPlayers - ($IdealPlayers - $NumPlayers));
      if ($AsMatch) {$PreMatches = $PreMatches /2; $offset = floor($PreMatches /2);}else{$offset = $PreMatches/2;}
      if ($MatchNum < $PreMatches) {
        return true;
      }else{
        $LBound = $PreMatches + $offset -1;
        if ($AsMatch) {$UBound = ($PreMatches + $offset) + (ceil($NumPlayers/2) - $PreMatches);}else{$UBound = ($PreMatches + $offset) + ($NumPlayers - $PreMatches);}
        if ($MatchNum < $UBound && $MatchNum > $LBound) {
          return true;
        }else{
          return false;
        }
      }
    }
  }

//Find the Row of the PLAYER box in the Primary Tree. This isn't the actual ROW in a text format. This is the row of that particular column.
  function primaryBoxRow ($PlayerBox, $NumPlayers) {
    return ($PlayerBox) - primaryStartRow(primaryColumnOf(floor($PlayerBox/2), $NumPlayers), $NumPlayers);
  }

//Find the Starting PLAYER box in a particular column
  function primaryStartRow ($Column, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    $PrePlayers = (2 * $NumPlayers) - $IdealPlayers;
    $row = 0;
    for  ($cnt = 0; $cnt < ($Column-1); $cnt++) {
      $row += $IdealPlayers / pow(2,$cnt);
    }
    if ($Column > 1 && $NumPlayers != $IdealPlayers) {return $row - ($IdealPlayers - $PrePlayers) ;}else{return $row;}
  }

//Find the number of Player Boxes in a particular Column
  function primaryRowsinColumn($Column, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    if ($Column == 1 && $IdealPlayers != $NumPlayers) {
      return $IdealPlayers - (2*($IdealPlayers - $NumPlayers));
    }else{
      return pow(2,primaryColumns ($NumPlayers) - $Column);
    }
  }

//Find Parent Player Box
  function primaryParentOf($PlayerBox, $NumPlayers) {
    if (!primaryIsPrimary ($PlayerBox, $NumPlayers, false)) {
      $cl = primaryColumnOf(floor($PlayerBox/2), $NumPlayers);
      $rw = primaryBoxRow ($PlayerBox, $NumPlayers);
      $offset = primaryRowsinColumn($cl-1, $NumPlayers);
      return $PlayerBox - $rw - $offset + ($rw * 2);
    }else{
      return 0;
    }
  }

//Find the child-box of the position you're of
  function primaryChildOf ($PlayerBox, $NumPlayers) {
    $cl = primaryColumnOf(floor($PlayerBox/2), $NumPlayers);
    $rw = primaryBoxRow($PlayerBox, $NumPlayers);
    return $PlayerBox + (primaryRowsinColumn($cl, $NumPlayers) - $rw) + floor($rw/2);
  }

  function primaryLoserBoxOf($PlayerBox, $NumPlayers) {
    $Match = floor($PlayerBox/2);
    $Target = -1;
    $out = 0;
    if ($PlayerBox < ($NumPlayers * 2)-2) {
      for ($cnt = 0; $cnt < (($NumPlayers * 2)-2); $cnt++) {
        if (loserIsPrimary($cnt, $NumPlayers)) {$Target++;}
        if ($Target == $Match) {$out = $cnt; break;}
      }
    }else{$out =($NumPlayers * 2)-2;}
    return $out;
  }
?>