<?php

//Advanced Tree Geometry

//This include file will provide support for traversing the losers tree,
//and being able to find relative places from current, etc.


//All Functions in this file require that you refer to matchnumbers by their place on the tree
//And not matchnumbers in file. i.e. MatchNum 0 is the first match on the loser tree.
//Responses are given accordingly.


  function loserPrePlayers ($NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    return $IdealPlayers - (2*($IdealPlayers - $NumPlayers));
  }

//Find the number of columns in Loser Tree
  function loserColumns ($NumPlayers) {
    $out = (2 * ceil(log($NumPlayers)/log(2)))-2;

    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    if (loserPrePlayers($NumPlayers) > $IdealPlayers/2) {$out++;}
    return $out;
  }

//Find the column a match is listed in Loser Tree
  function loserColumnOf($MatchNum, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    $Cl = loserColumns($NumPlayers);
    if (loserPrePlayers($NumPlayers) <= ($IdealPlayers/2)) {$Cl++; $Offby = -1;}else{$Offby = 0;}
    $out = 2*(ceil($Cl/2)-floor(log($NumPlayers - $MatchNum -1)/log(2)));
    $Offset = round(pow(2,ceil(log($NumPlayers)/log(2)))) - $NumPlayers;
    $old =0;
    for ($cnt = ceil(log($NumPlayers)/log(2))-1; $cnt > 0; $cnt--) {
      if (($MatchNum + $Offset >= $old) && ($MatchNum + $Offset < $old + pow(2,$cnt-1))) {$reduction = true;}
      $old += pow(2,$cnt);
    }
    if ($reduction) {$out--;}
    $ret = $out + $Offby;
    if ($ret > $Cl +$Offby) {$ret = $Cl + $Offby;}
    return $ret;
  }


//Find the Starting PLAYER box in a particular column
  function loserStartRow ($Column, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    $row = 0;
    $MaxCols = ceil(loserColumns($NumPlayers)/2);
    if (loserPrePlayers($NumPlayers) <= ($IdealPlayers/2)) {$MaxCols++; $Column++;}

    for  ($cnt = 1; $cnt < $Column; $cnt++) {
      $row += pow(2,($MaxCols - ceil($cnt/2)));
    }
    if ($Column > 1 && $NumPlayers != $IdealPlayers) {
      $out = $row - $IdealPlayers + loserPrePlayers($NumPlayers);
    }else{
      $out = $row;
    }
    return $out;
  }


//Find the Row of the PLAYER box in the Primary Tree.
//This isn't the actual ROW in a text format. This is the row of that particular column
  function loserBoxRow ($PlayerBox, $NumPlayers) {
    return $PlayerBox - loserStartRow(loserColumnOf(floor($PlayerBox/2), $NumPlayers), $NumPlayers);
  }


//Find the number of Player Boxes in a particular Column
  function loserRowsinColumn($Column, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    if ($Column == 1 && $IdealPlayers != $NumPlayers) {
      if (loserPrePlayers($NumPlayers) <= ($IdealPlayers/2)) {return loserPrePlayers($NumPlayers);}else{return loserPrePlayers($NumPlayers)-($IdealPlayers/2);}
    }else{
      $MaxCols = ceil(loserColumns($NumPlayers)/2);
      if (loserPrePlayers($NumPlayers) <= ($IdealPlayers/2)) {$MaxCols++; $Column++;}
      $out = pow(2,($MaxCols - ceil($Column/2)));
      return $out;
    }
  }


//Is Match at left-most of tree (the leaves) on Primary Tree
  function loserIsPrimary ($PlayerBox, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));

     $out = false;
     $Cl = loserColumnOf(floor($PlayerBox/2), $NumPlayers);
     $Rw = loserBoxRow($PlayerBox, $NumPlayers);
     $NumCols = loserColumns($NumPlayers);

     if ($Cl == 1) {$out = true;}
     if (loserPrePlayers($NumPlayers) <= ($IdealPlayers/2)) {
     // Produce Offset
       $NumCols++;
       $Cl++;

       if ($Cl == 3) {
         if (($Rw*2) < ($IdealPlayers/2) - loserPrePlayers($NumPlayers)) {$out = true;}
       }
     }else{
     // Do checks on second column not attached to tree in first column
       if ($Rw < ($IdealPlayers - loserPrePlayers($NumPlayers)) && $Cl == 2) {$out = true;}
     }
     if ($Cl/2 == round($Cl/2) && ($Rw/2) == round($Rw/2)) {$out = true;}

     return $out;
  }


//Find Parent Player Box
  function loserParentOf($PlayerBox, $NumPlayers) {
    if (!loserIsPrimary ($PlayerBox, $NumPlayers, true)) {
      $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
      $Diff = $IdealPlayers - loserPrePlayers($NumPlayers);

      $cl = loserColumnOf(floor(($PlayerBox+$Diff)/2), $IdealPlayers);
      $rw = loserBoxRow (($PlayerBox+$Diff), $IdealPlayers);
      $offset = loserRowsinColumn($cl -1, $IdealPlayers);
      if ($cl/2 == round($cl/2)) {$offby = $rw+1;}else{$offby = 0;}

      $out = $PlayerBox - $rw -  $offset + ($rw * 2) - $offby;
      return $out;
    }else{
      return 0;
    }
  }


//Find the child-box of the position you're of
  function loserChildOf ($PlayerBox, $NumPlayers) {
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
    $Offby = $IdealPlayers - loserPrePlayers($NumPlayers);
    $cl = loserColumnOf(floor(($PlayerBox+$Offby)/2), $IdealPlayers);
    $rw = loserBoxRow($PlayerBox + $Offby, $IdealPlayers);
    if (($cl/2) != round($cl/2)) {$addition = ceil(($rw+1)/2);}else{$addition=0;}
    return $PlayerBox + (loserRowsinColumn($cl, $IdealPlayers) - $rw) + floor($rw/2) + $addition;
  }


 function loserHTMLRow($PlayerBox, $NumPlayers) {
   $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
   $Offset = $IdealPlayers - loserPrePlayers($NumPlayers);

   $cl = loserColumnOf(floor(($PlayerBox + $Offset)/2),$IdealPlayers);
   $rw = loserBoxRow(($PlayerBox + $Offset), $IdealPlayers);
   if ($cl == 1) {
     return 2*($rw+1);
   }elseif ($cl == 2) {
     return (2*$rw)+1;
   }elseif (($cl/2) != round($cl/2)) {
     $out = ((pow(2,($cl+1)/2)-2)/2) + ($rw * pow(2,($cl+1)/2)) +1;
     if ($cl >3) {$out -= ($cl-3)/2;}
     return $out;
   }else{
     if (($rw/2) != round($rw/2)) {
       $out = pow(2,$cl/2) + ((($rw-1)/2)*pow(2,($cl/2)+1));
       if ($cl >4) {$out -= ($cl-4)/2;}
       return $out;
     }else{
       return loserHTMLRow($PlayerBox+1,$NumPlayers)-2;
     }
   }
 }

 function loserNumPrimaryTo($PlayerBox, $NumPlayers) {
   $NumPrimary = 0;
   for ($cnt = 0; $cnt < $PlayerBox; $cnt++) {
     if (loserIsPrimary($cnt, $NumPlayers)) {$NumPrimary++;}
   }
   return ($NumPrimary);
 }
?>