<?php
  include ("lang/".$Language."/code.php");

  if (!$IsAdmin) {exit;} //Don't care about out put for non-administrators, they shouldn't be here in the first place.

  include ("code/functions/tourneyarray.php");
  include ("code/functions/tourneyfile.php");


  // Process Settings
     if ($HTTP_POST_VARS["elimmode"] == "single") {$EliminationMode = false;}else{$EliminationMode = true;}
     if ($HTTP_POST_VARS["teammode"] == "players") {$TeamMode = false;}else{$TeamMode = true;}

     if ($HTTP_POST_VARS["matchmode"] == "random") {$MatchMode = 0;}  //Random
     if ($HTTP_POST_VARS["matchmode"] == "seeds") {$MatchMode = 1;}   //Best Vs Worst
     if ($HTTP_POST_VARS["matchmode"] == "skills") {$MatchMode = 2;}  //Closest Match

  // Save Generation Settings
     if ($fhandle = fopen("options/tourneygen.php","w")) {
	fwrite ($fhandle, "<?php".chr(13).chr(10));
	fwrite ($fhandle, " $"."elimmode = \"$EliminationMode\";".chr(13).chr(10));
	fwrite ($fhandle, " $"."method  = $MatchMode;".chr(13).chr(10));
	fwrite ($fhandle, " $"."teammode  = \"$TeamMode\";".chr(13).chr(10));
	fwrite ($fhandle, "?>");
      fclose ($fhandle);
     }

// functions

   // RandomSort
      function SortRandom ($ArrayList) {
       for ($Pri = 0; $Pri < count($ArrayList); $Pri++) {
        for ($Sec = 0; $Sec < $Pri; $Sec++) {
         if (rand(0,10) > 5) {
          $TmpHolder = $ArrayList[$Pri];
          $ArrayList[$Pri] = $ArrayList[$Sec];
          $ArrayList[$Sec] = $TmpHolder;
         }
        }
       }
      }

      function SortSeeds ($NameList, $SeedList) {
       SortSkills (&$NameList, &$SeedList);
       // Now We can forget about the Seed List.
       for ($cnt = 0; $cnt <count($NameList); $cnt++) {$TmpList[$cnt] = $NameList[$cnt];} //Duplicate Name List
       $barrier = ceil(count($TmpList)/2) -1;
       for ($cnt = 0; $cnt <count($NameList); $cnt++) {
         if ($cnt <= $barrier) {$newID = $cnt *2;}else{$newID = (2*(count($TmpList) - $cnt))-1;}
         $NameList[$newID] = $TmpList[$cnt];
       }
      }

      function SortSkills ($NameList, $SeedList) {
       for ($Pri = 0; $Pri < count($NameList); $Pri++) {
        for ($Sec = 0; $Sec < $Pri; $Sec++) {
         if ($SeedList[$Sec] > $SeedList[$Pri]) {
          $TmpHolder = $NameList[$Pri];
          $NameList[$Pri] = $NameList[$Sec];
          $NameList[$Sec] = $TmpHolder;
          $TmpHolder = $SeedList[$Pri];
          $SeedList[$Pri] = $SeedList[$Sec];
          $SeedList[$Sec] = $TmpHolder;
         }
        }
       }
      }


// *********************
// *** START OF CODE ***
// *********************

// Generate Array Of Players
   if ($TeamMode) {
    $flagwarning = false;
    $NumPlayers = 0;
    $dhandle = opendir("data/teams");
    while ($nextfile = readdir($dhandle)) {
     if ($nextfile != "." && $nextfile != "..") {
      $TeamSeed = 0;
      $fhandle = file("data/teams/".$nextfile);
      $PlayerList[$NumPlayers] = substr($nextfile, 0, strlen($nextfile)-4);
      for ($cnt = 2; $cnt < count($fhandle); $cnt++) {
        include ("users/".trim($fhandle[$cnt]).".php");
        if ($Seed == 0) {$flagwarning = true;}
        $TeamSeed += $Seed;
      }
      $SeedList[$NumPlayers] = $TeamSeed;
      $NumPlayers++;
     }
    }
   }else{
    $flagwarning = false;
    $NumPlayers = 0;
    $dhandle = opendir("users");
    while ($nextfile = readdir($dhandle)) {
     if ($nextfile != "." && $nextfile != "..") {
      $Seed = 0;
      include ("users/".$nextfile);
      if ($InTourney) {
        $PlayerList[$NumPlayers] = substr($nextfile, 0, strlen($nextfile)-4); 
        $SeedList[$NumPlayers] = $Seed; 
        if (intval($Seed) == 0) {$flagwarning=true;}
        $NumPlayers++;
      }
     }
    }
   }


// Sort - List
    if ($MatchMode == 0) {SortRandom (&$PlayerList);}  // (random)
    if ($MatchMode == 1) {SortSeeds  (&$PlayerList, &$SeedList);}  // (seeds)
    if ($MatchMode == 2) {SortSkills (&$PlayerList, &$SeedList);}  // (skills)


// Create Complete Set of Matches for Tournament
    $IdealPlayers = round(pow(2,ceil(log($NumPlayers)/log(2))));
     if ($IdealPlayers != $NumPlayers) {
      $PrePlayers = (2 * $NumPlayers) - $IdealPlayers;
      $offset = ($PrePlayers /2);

      for ($cnt = $NumPlayers; $cnt > -1; $cnt--) {
       if ($cnt <= $PrePlayers/2) {$practicalCnt = $cnt;}else{$practicalCnt = $offset + $cnt;}
       $PlayerList[$practicalCnt] = $PlayerList[$cnt];
       if ($cnt>= $PrePlayers) {$PlayerList[$cnt] = "";}
      }
     }

     $NumMatches = ($NumPlayers - 1);

     If ($EliminationMode) {$NumMatches = $NumMatches * 2;}


// Initialise Array
    $Match = array();
    for ($cnt = 0; $cnt < ($NumMatches+2); $cnt++) {$Match[$cnt] = new MatchType;}


// Input Names into Array
    for ($cnt = 0; $cnt < count($PlayerList); $cnt += 2) {
     $Match[$cnt/2]->nameOne = $PlayerList[$cnt];
     $Match[$cnt/2]->nameTwo = $PlayerList[$cnt+1];
    }


// Back-up Previous Tournament
    $founderror = false;
    if (file_exists("data/tournament.dat")) {
     if (file_exists("data/tournament-OLD.dat")) {if (!@unlink ("data/tournament-OLD.dat")) {$founderror=true;}}
     if (!$founderror) {if (!@rename("data/tournament.dat", "data/tournament-OLD.dat")) {$founderror=true;}}
    }


// Save Tournament
    if (!$founderror) {
     if (!@SaveTourney ("data/tournament.dat", $NumPlayers, $EliminationMode, &$Match, $TeamMode)) {
      $founderror = true;
     }
    }
?>

<P>&nbsp;</P>
<P>&nbsp;</P>
<P>&nbsp;</P>
<P ALIGN="CENTER"><?php if ($founderror) {print $LANGTourneyCreationError;}else{print $LANGTourneyCreated."<BR /><A HREF=\"main.php?page=loadcode&code=displaytournament\">".$LANGViewTourneyLink."</A>";} ?></P>