<?php

 if (!$IsAdmin) {exit();}

 include ("lang/$Language/createteams.php");
 $nmteams = 2;
 $method  = "random";
 @include ("options/teamgen.php");
 $errmsg = "";

 function CreateNameList ($NameList) {
   $cnt = 0;
   $dhandle = opendir("users");
   while ($nextfile = readdir($dhandle)) {
     if ($nextfile != "." && $nextfile != "..") {
       include ("users/$nextfile");
       if ($InTourney) {
         $NameList[$cnt++] = substr($nextfile, 0, strlen($nextfile)-4);
       }
     }
   }
   closedir ($dhandle);
 }

 function CreateSeedList ($SeedList, $NameList) {
   for ($cnt = 0; $cnt < count($NameList); $cnt++) {
     include ("users/".$NameList[$cnt].".php");
     $SeedList[$NameList[$cnt]] = count($NameList) - $Seed;
      //Making sure we use skills, Lowest Seed = Highest Skill, and A Seed of 3 != Seed of 1 + Seed of 2
   }
 }

 function TeamSkill($SeedList, $Team) {
   $TeamSkill = 0;
   for ($cnt = 0; $cnt < count($Team); $cnt++ ) {
     $TeamSkill += $SeedList[$Team[$cnt]];
   }
   return $TeamSkill;
 }

 function ChooseRandom($NameList, $NumTeams, $Teams) {
   $AvgSize = ceil(count($NameList) / $NumTeams);
   $TeamList[0] = "";
   $tml = 0;
   for ($cnt = 0; $cnt < $NumTeams; $cnt++) {
     if (count($Teams[$cnt]) < $AvgSize) {$TeamList[$tml++] = $cnt;}
   }
   $ChosenTeam = round(rand(0,$tml-1));
   return $TeamList[$ChosenTeam];
 }

 function ChooseSize($NumTeams, $Teams) {
   $MinTeam=0;
   $MinSize=0;
   for ($cnt = 0; $cnt < $NumTeams; $cnt++) {
     if ($cnt == 0 || count($Teams[$cnt]) < $MinSize) {$MinSize = count($Teams[$cnt]); $MinTeam = $cnt;}
   }
   return $MinTeam;
 }

 function ChooseSkill($NumTeams, $Teams, $SeedList) {
   $MinTeam=0;
   $MinSKill=0;
   for ($cnt = 0; $cnt < $NumTeams; $cnt++) {
     $TeamSk = TeamSkill($SeedList, $Teams[$cnt]);
     if ($cnt == 0 || $TeamSk <= $MinSkill) {$MinSkill = $TeamSk; $MinTeam = $cnt;}
   }
   return $MinTeam;
 }

 if ($HTTP_POST_VARS["BeenSubmitted"]) {
   // Save Generation Settings
   $nmteams = $HTTP_POST_VARS["numteams"];
   $method  = $HTTP_POST_VARS["genmethod"];
   if ($fhandle = fopen("options/teamgen.php","w")) {
	fwrite ($fhandle, "<?php".chr(13).chr(10));
	fwrite ($fhandle, " $"."nmteams = $nmteams;".chr(13).chr(10));
	fwrite ($fhandle, " $"."method  = $method;".chr(13).chr(10));
	fwrite ($fhandle, "?>");
    fclose ($fhandle);
   }


   // delete old teams
   if ($dhandle = @opendir("data/teams")) {
     while ($nextfile = @readdir($dhandle)) {
       if ($nextfile != "." && $nextfile != "..") {unlink ("data/teams/$nextfile");}
     }
   }

   $NameList = Array();
   $SeedList = Array();
   CreateNameList (&$NameList);
   if ($HTTP_POST_VARS["genmethod"] == "skills") {$SeedList[0]=""; CreateSeedList(&$SeedList, $NameList);}
   $NumTeams = intval($HTTP_POST_VARS["numteams"]);

   @mkdir ("data/teams", 0777);

   $teamindex = "";
   for ($cnt = 0; $cnt < count($NameList); $cnt++) {
     if ($HTTP_POST_VARS["genmethod"] == "random") {$SelTeam = ChooseRandom($NameList, $NumTeams, $Teams);}
     if ($HTTP_POST_VARS["genmethod"] == "skills") {$SelTeam = ChooseSkill($NumTeams, $Teams, $SeedList);}
     if ($HTTP_POST_VARS["genmethod"] == "teamsize") {$SelTeam = ChooseSize($NumTeams, $Teams);}
     $Teams[$SelTeam][] = $NameList[$cnt];
     $teamindex .= $NameList[$cnt].chr(13).chr(10)."team$SelTeam.dat".chr(13).chr(10);
   }
 
   $teamname = "Team ".($teamnum+1);
   $teamcolour = $BackColour;

   // Write to data
   for ($teamnum = 0; $teamnum <$NumTeams; $teamnum++) {
     if ($TeamAutoColour) {
       if ($teamnum == 0) {$teamname = "Red Team"; $teamcolour = "#600000";}
       if ($teamnum == 1) {$teamname = "Blue Team"; $teamcolour = "#000060";}
       if ($teamnum == 2) {$teamname = "Green Team"; $teamcolour = "#006000";}
       if ($teamnum == 3) {$teamname = "Yellow Team"; $teamcolour = "#606000";}
     }
     $fhandle = fopen("data/teams/team$teamnum.dat","w");
     fwrite ($fhandle, $teamname.chr(13).chr(10));
     fwrite ($fhandle, $teamcolour.chr(13).chr(10));
     for ($pyrnum = 0; $pyrnum < count($Teams[$teamnum]); $pyrnum++) {
       fwrite ($fhandle, $Teams[$teamnum][$pyrnum].chr(13).chr(10));
     }
     fclose($fhandle);
     $fhandle = fopen("data/teamindex.txt","w");
     fwrite($fhandle, $teamindex);
     fclose($fhandle);   
   }
   $errmsg = "<P ALIGN=\"CENTER\"><FONT COLOR=\"$HighColour\">$LANGSuccess</FONT><BR /><A HREF=\"main.php?page=viewteams\">$LANGView</A></P>\n";
 }else{
  if (file_exists("data/teams/team0.dat")) {$errmsg .= "<P ALIGN=\"CENTER\"><FONT COLOR=\"$ErrColour\">$LANGOverwrite</FONT></P>\n";}
 }
?>

<H2><?="<FONT COLOR=\"$HighColour\">$LANGTitle";?>:</FONT></H2>
<P>&nbsp;</P>
<?=$errmsg;?>
<FORM METHOD="POST" ACTION="main.php?page=loadcode&code=createteams">
 <INPUT TYPE="HIDDEN" NAME="BeenSubmitted" VALUE="true">
 <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="2" ALIGN="CENTER">
  <TR>
   <TD ALIGN="RIGHT"><?=$LANGNumTeams; ?>:</TD>
   <TD><?="<INPUT TYPE=\"TEXT\" NAME=\"numteams\" VALUE=\"$nmteams\" SIZE=\"4\">";?></TD>
  </TR>
  <TR><TD COLSPAN="2" HEIGHT="25"></TD></TR>
  <TR>
   <TD ALIGN="RIGHT"><?=$LANGGenMethod; ?>:</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"random\" "; if ($method == "random") {print "CHECKED";} print ">"; ?><?=$LANGRandom; ?></TD>
  </TR>
  <TR>
   <TD>&nbsp;</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"teamsize\" "; if ($method == "teamsize") {print "CHECKED";} print ">"; ?><?=$LANGSize; ?></TD>
  </TR>
  <TR>
   <TD>&nbsp;</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"skills\" "; if ($method == "skills") {print "CHECKED";} print ">"; ?><?=$LANGSkill; ?></TD>
  </TR>
  <TR><TD COLSPAN="2" HEIGHT="25"></TD></TR>
  <TR>
   <TD COLSPAN="2" ALIGN="CENTER"><?="<INPUT TYPE=\"SUBMIT\" NAME=\"cmdCreateTeams\" VALUE=\"$LANGSubmit\">";?></TD>
  </TR>
 </TABLE>
</FORM>