<?php

 if (!$IsAdmin) {exit();}

 include ("lang/$Language/createleagues.php");
 $nmleagues = 2;
 $method  = "random";
 $tmmode  = "players";
 include ("code/functions/teams.php");
 @include ("options/leaguegen.php");
 $errmsg = "";

 function CreateNameList ($NameList, $TeamMode) {
   $cnt = 0;
   if ($TeamMode) {
     $dhandle = opendir("data/teams");
   }else{
     $dhandle = opendir("users");
   }
   while ($nextfile = readdir($dhandle)) {
     if ($nextfile != "." && $nextfile != "..") {
       if (!$TeamMode) {include ("users/$nextfile");}
       if ($InTourney || $TeamMode) {
         $NameList[$cnt++] = substr($nextfile, 0, strlen($nextfile)-4);
       }
     }
   }
   closedir ($dhandle);
 }

 function CreateSeedList ($SeedList, $NameList, $TeamMode) {
   for ($cnt = 0; $cnt < count($NameList); $cnt++) {
     include ("users/".$NameList[$cnt].".php");
     $SeedList[$NameList[$cnt]] = count($NameList) - $Seed;
      //Making sure we use skills, Lowest Seed = Highest Skill, and A Seed of 3 != Seed of 1 + Seed of 2
   }
 }

 function LeagueSkill($SeedList, $League) {
   $LeagueSkill = 0;
   for ($cnt = 0; $cnt < count($League); $cnt++ ) {
     $LeagueSkill += $SeedList[$League[$cnt]];
   }
   return $LeagueSkill;
 }

 function ChooseRandom($NameList, $NumLeagues, $Leagues) {
   $AvgSize = ceil(count($NameList) / $NumLeagues);
   $LeagueList[0] = "";
   $lge = 0;
   for ($cnt = 0; $cnt < $NumLeagues; $cnt++) {
     if (count($Leagues[$cnt]) < $AvgSize) {$LeagueList[$lge++] = $cnt;}
     if (count($Leagues[$cnt]) < $AvgSize) {$LeagueList[$lge++] = $cnt;}
   }
   $ChosenLeague = round(rand(0,$lge-1));
   return $LeagueList[$ChosenLeague];
 }

 function ChooseSize($NumLeagues, $Leagues) {
   $MinLeague=0;
   $MinSize=0;
   for ($cnt = 0; $cnt < $NumLeagues; $cnt++) {
     if ($cnt == 0 || count($Leagues[$cnt]) < $MinSize) {$MinSize = count($Leagues[$cnt]); $MinLeague = $cnt;}
   }
   return $MinLeague;
 }

 function ChooseSkill($NumLeagues, $Leagues, $SeedList) {
   $MinLeague=0;
   $MinSKill=0;
   for ($cnt = 0; $cnt < $NumLeagues; $cnt++) {
     $LeagueSk = LeagueSkill($SeedList, $Leagues[$cnt]);
     if ($cnt == 0 || $LeagueSk <= $MinSkill) {$MinSkill = $LeagueSk; $MinLeague = $cnt;}
   }
   return $MinLeague;
 }

 if ($HTTP_POST_VARS["BeenSubmitted"]) {
   // Save Generation Settings
   $nmleagues = $HTTP_POST_VARS["numleagues"];
   $method = $HTTP_POST_VARS["genmethod"];
   $tmmode = $HTTP_POST_VARS["tmmode"];
   if ($fhandle = fopen("options/leaguegen.php","w")) {
     fwrite ($fhandle, "<?php".chr(13).chr(10));
     fwrite ($fhandle, " $"."nmleagues = $nmleagues;".chr(13).chr(10));
     fwrite ($fhandle, " $"."method  = $method;".chr(13).chr(10));
     fwrite ($fhandle, " $"."tmmode  = $tmmode;".chr(13).chr(10));
     fwrite ($fhandle, "?>");
     fclose ($fhandle);
   }
   $TeamMode = false;
   if ($tmmode == "teams" || $Tmmode == "true" || $tmmode == "1") {$TeamMode = true;}


   // delete old Leagues
   if ($dhandle = @opendir("data/leagues")) {
     while ($nextfile = @readdir($dhandle)) {
       if ($nextfile != "." && $nextfile != "..") {unlink ("data/leagues/$nextfile");}
     }
     closedir ($dhandle);
   }
   if ($dhandle = @opendir("data/leaguedata")) {
     while ($nextfile = @readdir($dhandle)) {
       if ($nextfile != "." && $nextfile != "..") {unlink ("data/leaguedata/$nextfile");}
     }
     closedir ($dhandle);
   }
   if ($dhandle = @opendir("data/leaguesubmissions")) {
     while ($nextfile = @readdir($dhandle)) {
       if ($nextfile != "." && $nextfile != "..") {unlink ("data/leaguesubmissions/$nextfile");}
     }
     closedir ($dhandle);
   }

   $NameList = Array();
   $SeedList = Array();
   CreateNameList (&$NameList, $TeamMode);
   if ($HTTP_POST_VARS["genmethod"] == "skills") {$SeedList[0]=""; CreateSeedList(&$SeedList, $NameList, $TeamMode);}
   $NumLeagues = intval($HTTP_POST_VARS["numleagues"]);

   @mkdir ("data/leagues", 0777);
   @mkdir ("data/leaguedata");

   $Leagues = Array();
   $Leagueindex = "";
   for ($cnt = 0; $cnt < count($NameList); $cnt++) {
     if ($HTTP_POST_VARS["genmethod"] == "random") {$SelLeague = ChooseRandom($NameList, $NumLeagues, $Leagues);}
     if ($HTTP_POST_VARS["genmethod"] == "skills") {$SelLeague = ChooseSkill($NumLeagues, $Leagues, $SeedList);}
     if ($HTTP_POST_VARS["genmethod"] == "leaguesize") {$SelLeague = ChooseSize($NumLeagues, $Leagues);}
     $Leagues[$SelLeague][] = $NameList[$cnt];
     $Leagueindex .= $NameList[$cnt].chr(13).chr(10)."league$SelLeague.dat".chr(13).chr(10);
   }

   // Write to data
   for ($Leaguenum = 0; $Leaguenum <$NumLeagues; $Leaguenum++) {
     $fhandle = fopen("data/leagues/league$Leaguenum.dat","w");
     for ($pyrnum = 0; $pyrnum < count($Leagues[$Leaguenum]); $pyrnum++) {
       fwrite ($fhandle, $Leagues[$Leaguenum][$pyrnum].chr(13).chr(10));
       fwrite ($fhandle, "0".chr(13).chr(10)); // Wins
       fwrite ($fhandle, "0".chr(13).chr(10)); // Draws
       fwrite ($fhandle, "0".chr(13).chr(10)); // Losses
     }
     fclose($fhandle);
     $fhandle = fopen("data/leagueindex.txt","w");
     fwrite($fhandle, $Leagueindex);
     fclose($fhandle);
   }
   $errmsg = "<P ALIGN=\"CENTER\"><FONT COLOR=\"$HighColour\">$LANGSuccess</FONT><BR /><A HREF=\"main.php?page=viewleagues\">$LANGView</A></P>\n";
 }else{
  if (file_exists("data/leagues/league0.dat")) {$errmsg .= "<P ALIGN=\"CENTER\"><FONT COLOR=\"$ErrColour\">$LANGOverwrite</FONT></P>\n";}
 }
?>

<H2><?="<FONT COLOR=\"$HighColour\">$LANGTitle";?>:</FONT></H2>
<P>&nbsp;</P>
<?=$errmsg;?>
<FORM METHOD="POST" ACTION="main.php?page=loadcode&code=createleagues">
 <INPUT TYPE="HIDDEN" NAME="BeenSubmitted" VALUE="true">
 <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="2" ALIGN="CENTER">
  <TR>
   <TD ALIGN="RIGHT"><?=$LANGNumLeagues; ?>:</TD>
   <TD><?="<INPUT TYPE=\"TEXT\" NAME=\"numleagues\" VALUE=\"$nmleagues\" SIZE=\"4\">";?></TD>
  </TR>
  <TR><TD COLSPAN="2" HEIGHT="25"></TD></TR>
  <TR>
   <TD ALIGN="RIGHT"><?=$LANGGenMethod; ?>:</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"random\" "; if ($method == "random") {print "CHECKED";} print ">"; ?><?=$LANGRandom; ?></TD>
  </TR>
  <TR>
   <TD>&nbsp;</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"leaguesize\" "; if ($method == "leaguesize") {print "CHECKED";} print ">"; ?><?=$LANGSize; ?></TD>
  </TR>
  <TR>
   <TD>&nbsp;</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"genmethod\" VALUE=\"skills\" "; if ($method == "skills") {print "CHECKED";} print ">"; ?><?=$LANGSkill; ?></TD>
  </TR>
  <TR><TD COLSPAN="2" HEIGHT="25"></TD></TR>
  <TR>
   <TD ALIGN="RIGHT"><?=$LANGTeamMode; ?>:</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"tmmode\" VALUE=\"players\" "; if ($tmmode == "players") {print "CHECKED";} print ">"; ?><?=$LANGPlayers; ?></TD>
  </TR>
  <TR>
   <TD>&nbsp;</TD>
   <TD><?php print "<INPUT TYPE=\"RADIO\" NAME=\"tmmode\" VALUE=\"teams\" "; if ($tmmode == "teams") {print "CHECKED";} print ">"; ?><?=$LANGTeams; ?></TD>
  </TR>
  <TR><TD COLSPAN="2" HEIGHT="25"></TD></TR>
  <TR>
   <TD COLSPAN="2" ALIGN="CENTER"><?="<INPUT TYPE=\"SUBMIT\" NAME=\"cmdCreateLeagues\" VALUE=\"$LANGSubmit\">";?></TD>
  </TR>
 </TABLE>
</FORM>