;// ArenaScout 1.2c Q3:A Server Browser
;// by fuel ( fuel@daed.org )
;// You may not take or modify in any way any of my code unless you have my permission.

on *:load {
  if $version < 5.9 {
    echo $colour(other) -a *** Your version of mIRC ( $+ $version $+ ) is outdated. Please visit www.mirc.co.uk to get the latest copy.
    echo $colour(other) -a *** This script will now self destruct.
    .timer -m 1 1 unload -rs $script
    halt
  }
  else {
    echo $colour(other) -a *** Welcome to ArenaScout by fuel (fuel@daed.org)
    echo $colour(other) -a *** You can find the controls for ArenaScout under your channel popup menu `ascout'
    if $exists($scriptdirlaunch.as) == $false { write -c " $+ $scriptdirlaunch.as $+ " }
    if $exists($scriptdirfriends.as) == $false { write -c " $+ $scriptdirfriends.as $+ " }
    if $exists($scriptdirarena.ini) == $false {
      write -c " $+ $scriptdirarena.ini $+ "
      as.w settings away 0
      as.w settings sping 1
      as.w settings follow 1
      as.w settings pingcorrection 0
      as.w settings autogame 1
      as.w settings desktop ""
      as.w settings autoclose 1
      as.w settings shortnames 0
      as.w settings focus 1
      as.w settings nick 0
      as.w settings col1 n
      as.w settings col2 n
    }
  }
}
on *:start {
  unset %as-follow %as-fflood %as_* %as.*
  .remove " $+ $scriptdirtemp.as $+ "
  .remove " $+ $scriptdirmaster.as $+ "
  .remove " $+ $scriptdirupdate.q $+ "
  .remove " $+ $scriptdirplayers.as $+ "
  while $findfile($scriptdir,master.m*,0) > 0 {
    var %as.master = " $+ $findfile($scriptdir,master.m*,1) $+ "
    if $exists(%as.master) { .remove %as.master }
    if $exists(%as.master) == $false { break }
  }
}
on *:connect {
  unset %as-fflood
}


menu status,channel,menubar,query {
  ascout
  .launch:arenascout
  .-
  .configure:arenascout | did -c arenascout 5
  .servers:arenascout | did -c arenascout 3
  .search:arenascout | did -c arenascout 4
  .friends:arenascout | did -c arenascout 89
  .master:arenascout | did -c arenascout 97
  .help:arenascout | did -c arenascout 6
  .-
  .unload:as.unload
}

dialog arenascout {
  title "ArenaScout Q3:A Server Browser by fuel"
  size -1 -1 450 450
  icon $scriptdirextensions\arenascout.ico, index
  icon 1, 0 0 450 45, " $+ $scriptdirextensions\arenascout.jpg $+ "

  tab "scout", 2, 1 55 448 394
  tab "servers", 3
  tab "search", 4
  tab "setup", 5
  tab "friends", 89
  tab "master list", 97
  tab "help", 6

  ;// scout

  text "servers", 83, 7 85 45 14, tab 2
  edit "", 84, 52 83 244 20, autohs tab 2
  list 7, 5 109 292 115, vsbar tab 2
  icon 8, 302 98 140 105, $as.map(default), tab 2
  text "ArenaScout", 9, 302 83 140 14, right tab 2
  text "players", 10, 7 212 50 14, tab 2
  list 11, 5 227 130 220, autovs extsel tab 2
  text "frags", 12, 140 212 25 14, tab 2
  list 13, 137 227 45 220, autovs tab 2
  text "ping", 14, 188 212 25 14, tab 2
  list 15, 185 227 45 220, autovs tab 2
  button "add red", 16, 233 227 60 19, tab 2
  button "add blue", 17, 233 247 60 19, tab 2
  button "remove", 18, 233 267 60 19, tab 2
  button "add friend", 124, 233 287 60 19, tab 2
  text "red", 19, 233 347 30 12, tab 2
  text "score", 20, 233 359 30 12, tab 2
  text "ping", 21, 233 371 30 13, tab 2
  text "0", 22, 262 359 26 12, right tab 2
  text "0", 23, 262 371 26 12, right tab 2
  text "blue", 24, 233 401 30 12, tab 2
  text "score", 25, 233 413 30 12, tab 2
  text "ping", 26, 233 425 30 13, tab 2
  text "0", 27, 262 413 26 12, right tab 2
  text "0", 28, 262 425 26 12, right tab 2
  text "ping", 29, 304 212 55 13, tab 2
  edit "", 32, 302 225 70 19, read autohs center tab 2
  text "players t/m/p", 31, 376 212 65 13, tab 2
  edit "", 30, 374 225 70 19, read autohs center tab 2
  text "timelimit", 33, 304 244 55 13, tab 2
  edit "", 34, 302 257 70 19, read autohs center tab 2
  text "fraglimit", 35, 376 244 55 13, tab 2
  edit "", 36, 374 257 70 19, read autohs center tab 2
  text "gametype", 37, 304 276 55 13, tab 2
  edit "", 38, 302 289 70 19, read autohs center tab 2
  text "gamename", 39, 376 276 55 13, tab 2
  edit "", 40, 374 289 70 19, read autohs center tab 2
  text "version info", 121, 304 308 55 13, tab 2
  edit "", 122, 302 321 142 19, read autohs center tab 2
  text "password", 41, 304 348 70 13, tab 2
  edit "", 42, 302 361 140 20, tab 2
  button "connect", 43, 302 387 46 24, tab 2
  button "refresh", 44, 348 387 47 24, default tab 2
  button "report", 45, 395 387 46 24, tab 2
  check "auto refresh", 125, 302 414 139 24, push tab 2
  text "", 47, -100 -100 10 10, hide
  text "", 48, -100 -100 10 10, hide

  ;// servers

  list 49, 5 82 440 292, extsel size tab 3
  button "add server", 50, 5 380 80 26, tab 3
  button "delete server", 51, 5 410 80 26, tab 3
  button "move up", 52, 90 380 80 26, tab 3
  button "move down", 53, 90 410 80 26, tab 3
  button "refresh all", 120, 175 380 80 26, tab 3
  button "clear all", 54, 175 410 80 26, tab 3
  check "Auto delete time outs", 118, 265 385 180 20, tab 3
  check "Move time outs to the list's end", 117, 265 415 180 20, tab 3

  ;// search

  combo 126, 102 122 208 300, drop tab 4
  check "population", 55, 102 162 75 15, tab 4
  combo 56, 190 160 120 100, drop disabled tab 4
  check "gametype", 57, 102 187 75 15, tab 4
  combo 58, 190 185 120 100, drop disabled tab 4
  check "gamename", 59, 102 212 75 15, tab 4
  edit "", 60, 189 210 122 22, disabled tab 4
  check "player", 61, 102 237 75 15, tab 4
  combo 62, 190 235 120 100, drop edit disabled tab 4
  button "search", 63, 314 235 55 22, tab 4
  text "results (double click to query the server)", 64, 9 275 200 15, tab 4
  list 65, 5 295 440 145, size tab 4
  text "Fill in any of the fields (or any combination of fields) and click search. The results of your search will be displayed in the lower listbox.", 77, 20 84 400 32, center tab 4
  button "", 94, 433 284 8 8, tab 4

  ;// setup

  text "quake 3 executable", 66, 32 95 120 14, tab 5
  edit "", 67, 30 108 297 22, read autohs tab 5
  button "browse", 68, 330 108 80 22, tab 5
  text "extra launch parameters", 75, 32 133 120 14, autohs tab 5
  combo 76, 30 148 297 100, drop edit tab 5
  button "save", 103, 330 147 39 22, tab 5
  button "delete", 104, 371 147 39 22, tab 5
  check "Listen for and react to -sping in channels", 85, 30 185 350 20, tab 5
  check "Set away on connection to a server", 90, 30 205 350 20, tab 5
  check "Respond with server info when a user types ''?as'' in a channel", 91, 30 225 350 20, tab 5
  check "Enable extra ping correction - if you find your ping is reporting too high", 105, 30 245 350 20, tab 5
  check "Automatically try to set fs_game", 108, 30 265 350 20, tab 5
  check "Launch as a desktop window", 96, 30 285 350 20, tab 5
  check "Automatically close upon game launch", 92, 30 305 350 20, tab 5
  check "Use shortened display names in info report", 106, 30 325 350 20, tab 5
  check "Automatically focus on the scout tab when updating a server", 119, 30 345 350 20, tab 5
  check "Append ''|Q3'' to your nick when launching a game", 116, 30 365 350 20, tab 5
  text "color 1", 110, 30 403 33 14, tab 5
  combo 111, 75 400 80 100, drop tab 5
  text "color 2", 112, 280 403 33 14, tab 5
  combo 113, 325 400 80 100, drop tab 5

  ;// friends

  box "friends list", 69, 70 88 298 337, tab 89
  list 70, 87 110 200 310, vsbar tab 89
  button "add", 71, 290 110 60 23, tab 89
  button "edit", 72, 290 135 60 23, tab 89
  button "delete", 73, 290 160 60 23, tab 89
  button "clear", 74, 290 390 60 23, tab 89

  ;// master list

  list 98, 5 82 440 295, sort size autohs extsel vsbar tab 97
  button "add to favorites", 99, 5 412 90 25, tab 97
  button "save list", 102, 100 412 90 25, tab 97
  button "ping servers", 100, 100 382 90 25, disabled tab 97
  button "update list", 101, 5 382 90 25, tab 97
  text "filters:", 129, 236 388 55 15, tab 97
  text "gametype", 130, 275 388 55 15, tab 97
  combo 131, 335 385 110 100, drop tab 97
  text "gamename", 132, 275 417 55 15, tab 97
  edit "", 133, 334 414 111 22, tab 97

  ;// help

  text "help topics", 78, 7 90 100 14, tab 6
  list 79, 5 105 120 300, size tab 6
  text "content", 80, 137 90 100 14, tab 6
  edit "Click on any of the topics on the left and read about it in this box.", 81, 135 105 305 300, multi tab 6
  button "exit", 82, 379 411 60 26, ok tab 6
  button "readme", 86, 5 411 62 26, tab 6
  button "email", 87, 70 411 62 26, tab 6
  button "notes", 88, 135 411 62 26, tab 6
  button "versions", 95, 200 411 62 26, tab 6
  button "website", 109, 265 411 62 26, tab 6
}

on *:dialog:arenascout:*:* {
  if $devent == init {
    var %as.loadtime = $ticks
    if $exists($scriptdirplayers.as) { .remove " $+ $scriptdirplayers.as $+ " }
    as.serverload
    if %as.ip && %as.port { as.d 84 %as.ip $+ : $+ %as.port }
    as.d 126 -> predefined searches...
    as.d 126 
    as.d 111,113 no color
    as.d 56 populated
    as.d 56 empty
    as.d 67 $as.i(quake3)
    as.d 131 all
    var %x = 1
    while %x > 0 {
      if $calc(%x - 1) < 16 { as.d 111,113 $calc(%x - 1) $+ . $replace($calc(%x - 1),10,cyan,11,lightcyan,12,lightblue,13,pink,14,grey,15,lightgrey,0,white,1,black,2,blue,3,green,4,red,5,brown,6,purple,7,orange,8,yellow,9,lightgreen) }
      if $calc(%x - 1) < 9 { as.d 58,131 $calc(%x - 1) $as.type($calc(%x - 1),asinit,b) }
      if %x <= $lines($scriptdirlaunch.as) { as.d 76 $read($scriptdirlaunch.as,n,%x) }
      if %x <= $lines($as.friends) { as.d 62,70 $read($as.friends,n,%x) }
      if $left($read($scriptdirhelp.ini,%x),1) == $chr(59) && !%as.helpi { as.d 79 $remove($read($scriptdirhelp.ini,%x),$chr(59)) }
      else { var %as.helpi = %x }
      if $readini($scriptdirsearch.ini,searches,%x) != $null && !%as.searches { as.d 126 $remove($gettok($readini($scriptdirsearch.ini,searches,%x),1,43),$chr(9)) }
      else { var %as.searches = %x }
      inc %x
      if %x > $lines($scriptdirlaunch.as) && %x > $lines($as.friends) && %as.helpi && %as.searches { .break }
    }
    did $iif($as.i(sping) == 1,-c,-u) $dname 85
    did $iif($as.i(away) == 1,-c,-u) $dname 90
    did $iif($as.i(follow) == 1,-c,-u) $dname 91
    did $iif($as.i(pingcorrection) == 1,-c,-u) $dname 105
    did $iif($as.i(autogame) == 1,-c,-u) $dname 108
    did $iif(d isin $as.i(desktop),-c,-u) $dname 96
    did $iif($as.i(autoclose) == 1,-c,-u) $dname 92
    did $iif($as.i(shortnames) == 1,-c,-u) $dname 106
    did $iif($as.i(nick) == 1,-c,-u) $dname 116
    did $iif($as.i(focus) == 1,-c,-u) $dname 119
    did -c $dname 111 $iif($as.i(col1) == n,1,$calc($as.i(col1) + 2)) 
    did -c $dname 113 $iif($as.i(col2) == n,1,$calc($as.i(col2) + 2))
    if $exists($scriptdirextensions\scout.dll) == $false { did -b $dname 100,101 }
    did -c $dname 56,58,76,126,131 1
    dialog -t $dname ArenaScout Q3:A Server Browser by fuel - load time: $round($calc(($ticks - %as.loadtime) / 1000),3) seconds
    .timer 1 2 $ $+ iif($dialog($dname),dialog -t $dname ArenaScout Q3:A Server Browser by fuel)
    if $exists($as.i(quake3)) == $false { as.selectq3 }
  }
  if $devent == dclick {
    if $did == 7 { as.scout $gettok($did($dname,7,1).seltext,1,32) }
    if $did == 49 { as.scout $gettok($did($dname,49,1).seltext,1,32) }
    if $did == 65 { as.scout $gettok($did($dname,65,1).seltext,1,32) }
    if $did == 98 && $did($dname,98,0).sel == 1 {
      if $gettok($did($dname,98,1).seltext,0,32) == 1 { as.scout $did($dname,98,1).seltext }
      else { as.scout $remove($gettok($did($dname,98,1).seltext,2,62),$chr(160)) }
    }
  }
  if $devent == edit {
    if $did == 42 && $did($dname,7,1).seltext {
      var %as.pass = $did($dname,42).text
      as.w passwords $gettok($gettok($did($dname,7,1).seltext,1,32),1,160) $iif(%as.pass,%as.pass,"")
    }
  }
  if $devent == sclick {
    if $did == 7 { did -c $dname 49 $did($dname,7).sel }
    if $did == 8 {
      if $lock(run) == $true {
        .timer -m 1 1 var %as.junk = $input(mIRC's /run command is disabled. In order to view the ArenaScout website by clicking on the levelshot you will need enable it. $crlf $crlf $+ To $& 
          do so click on File -> Options -> General -> Lock and then uncheck /run.,68)
        halt
      }
      else { run http://www.clan-dna.com/fuel/arenascout/index.html#Levelshots }
    }
    if $did == 16 {
      if $did($dname,11,0).sel == $null { halt }
      var %x = 0
      unset %as.clients
      set %as.redteam $chr(181)
      set %as.blueteam $chr(181)
      while %x < $did($dname,11).lines {
        inc %x
        var %as.temp = $did($dname,13,%x).text $+ $chr(182) $+ $did($dname,15,%x).text $+ $chr(182) $+ $gettok($did($dname,11,%x).text,2-,32)
        set %as.clients $addtok(%as.clients,%as.temp,181)
        if <r> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.redteam $addtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.blueteam $remtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
        elseif <b> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.blueteam $addtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.redteam $remtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
      }
      var %x = 0
      while %x < $did($dname,11,0).sel {
        inc %x
        set %as.redteam $addtok(%as.redteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),181)
        set %as.blueteam $remtok(%as.blueteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),1,181)
      }
      write -c " $+ $scriptdirplayers.as $+ "
      write " $+ $scriptdirplayers.as $+ " $gettok($did($dname,48).text,1,32) $crlf
      write " $+ $scriptdirplayers.as $+ " %as.redteam $crlf
      write " $+ $scriptdirplayers.as $+ " %as.blueteam
      as.sortplayers
    }
    if $did == 17 {
      if $did($dname,11,0).sel == $null { halt }
      var %x = 0
      unset %as.clients
      set %as.redteam $chr(181)
      set %as.blueteam $chr(181)
      while %x < $did($dname,11).lines {
        inc %x
        var %as.temp = $did($dname,13,%x).text $+ $chr(182) $+ $did($dname,15,%x).text $+ $chr(182) $+ $gettok($did($dname,11,%x).text,2-,32)
        set %as.clients $addtok(%as.clients,%as.temp,181)
        if <r> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.redteam $addtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.blueteam $remtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
        elseif <b> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.blueteam $addtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.redteam $remtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
      }
      var %x = 0
      while %x < $did($dname,11,0).sel {
        inc %x
        set %as.blueteam $addtok(%as.blueteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),181)
        set %as.redteam $remtok(%as.redteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),1,181)
      }
      write -c " $+ $scriptdirplayers.as $+ "
      write " $+ $scriptdirplayers.as $+ " $gettok($did($dname,48).text,1,32) $crlf
      write " $+ $scriptdirplayers.as $+ " %as.redteam $crlf
      write " $+ $scriptdirplayers.as $+ " %as.blueteam
      as.sortplayers
    }
    if $did == 18 {
      if $did($dname,11,0).sel == $null { halt }
      var %x = 0
      unset %as.clients
      set %as.redteam $chr(181)
      set %as.blueteam $chr(181)
      while %x < $did($dname,11).lines {
        inc %x
        var %as.temp = $did($dname,13,%x).text $+ $chr(182) $+ $did($dname,15,%x).text $+ $chr(182) $+ $gettok($did($dname,11,%x).text,2-,32)
        set %as.clients $addtok(%as.clients,%as.temp,181)
        if <r> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.redteam $addtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.blueteam $remtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
        elseif <b> isin $gettok($did($dname,11,%x).text,1,32) {
          set %as.blueteam $addtok(%as.blueteam,$gettok($did($dname,11,%x).text,2-,32),181)
          set %as.redteam $remtok(%as.redteam,$gettok($did($dname,11,%x).text,2-,32),1,181)
          continue
        }
      }
      var %x = 0
      while %x < $did($dname,11,0).sel {
        inc %x
        set %as.blueteam $remtok(%as.blueteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),1,181)
        set %as.redteam $remtok(%as.redteam,$gettok($did($dname,11,$did($dname,11,%x).sel).text,2-,32),1,181)
      }
      write -c " $+ $scriptdirplayers.as $+ "
      write " $+ $scriptdirplayers.as $+ " $gettok($did($dname,48).text,1,32) $crlf
      write " $+ $scriptdirplayers.as $+ " %as.redteam $crlf
      write " $+ $scriptdirplayers.as $+ " %as.blueteam
      as.sortplayers
    }
    if $did == 43 && $did($dname,48).text != $null {
      if $as.i(away) == 1 {
        var %as.conn = $remove($as.removecolor($gettok($did($dname,48).text,2-,32)),$chr(160))
        if $isalias(away) == $true { away Q3:  $+ $gettok($did($dname,48).text,1,32) $+  %as.conn $+  }
        else {
          ame is away_ Q3:  $+ $gettok($did($dname,48).text,1,32) $+  %as.conn $+ 
          raw -q away : $+ Q3:  $+ $gettok($did($dname,48).text,1,32) $+  %as.conn $+ 
        }
      }
      if $as.i(follow) == 1 {
        tokenize 32 $did($dname,48).text
        set %as-follow $1 $ticks $2-
      }
      else { unset %as-follow }
      if $lock(run) == $true {
        .timer -m 1 1 var %as.junk = $input(mIRC's /run command is disabled. In order to run Quake 3 you will need enable it. $crlf $crlf $+ To do so click on File -> Options -> General -> Lock and then uncheck /run.,68)
        halt
      }
      if $as.i(autoclose) == 1 { .timer 1 1 dialog -x $dname }
      if $as.i(nick) == 1 && $right($me,3) != |Q3 { nick $me $+ |Q3 }
      var %as.run = $as.i(quake3)
      var %as.autogame = $iif($as.i(autogame) == 1,+set fs_game " $+ $did($dname,40) $+ ")
      run -p %as.run -nointro -condump console.as $did($dname,76).text +set password " $+ $did($dname,42) $+ " %as.autogame +connect $gettok($did($dname,48),1,32)
    }
    if $did == 44 {
      if $did($dname,84).text { var %as.checkout = $did($dname,84).text }
      else { var %as.checkout = $gettok($did($dname,7,1).seltext,1,32) }
      as.scout %as.checkout
    }
    if $did == 45 {
      if $did($dname,48).text == $null { halt }
      if $as.i(shortnames) == 1 { var %as.msgserver = $left($as.removecolor($gettok($did($dname,48),2-,32)),20) }
      else { var %as.msgserver = $remove($as.removecolor($gettok($did($dname,48),2-,32)),$chr(160)) }
      msg $active $as.cola([)  $+ $as.colb($gettok($did($dname,48),1,32)) $+  $as.cola(]) $as.cola(ping:) $+ $as.colb($did($dname,32) $+ ms) $&
        $as.cola(map:) $+ $as.colb($did($dname,9)) $as.cola(players:) $+ $as.colb($did($dname,30)) $as.cola([) $as.colb(%as.msgserver) $as.cola(])
    }
    if $did == 124 && $did($dname,11).seltext != $null {
      .timer -m 1 1 as.friend addfromlist $left($replace($gettok($did($dname,11,1).seltext,2-,32),$chr(160),$chr(32)),$calc($len($gettok($did($dname,11,1).seltext,2-,32)) - 1))
    }
    if $did == 125 {
      if $did($dname,125).state == 0 {
        .timer_AS.autoupdate off
        halt
      }
      if $did($dname,125).state == 1 && $did($dname,7,1).seltext != $null {
        as.autoscout $gettok($did($dname,7,1).seltext,1,32)
        .timer_AS.autoupdate 0 2 as.autoscout $gettok($did($dname,7,1).seltext,1,32)
        halt
      }
    }
    if $did == 49 { did -c $dname 7 $did($dname,49).sel }
    if $did == 50 { .timer -m 1 1 as.addserver }
    if $did == 51 && $did($dname,49,1).sel != $null {
      var %x = 0
      while %x < $did($dname,49,0).sel {
        inc %x
        write -dl $+ $did($dname,49,1).sel $as.list
      }
      while $did($dname,49,0).sel > 0 { did -d $dname 7,49 $did($dname,49,1).sel }
    }
    if $did == 52 && $did($dname,49).sel {
      var %x = 0, %as._tmp = ""
      while %x < $did($dname,49,0).sel {
        inc %x
        var %as.movetemp = $read($as.list,$did($dname,49,%x).sel)
        var %as.write = $calc($did($dname,49,%x).sel - 1)
        var %as.display = $did($dname,49,$did($dname,49,%x).sel).text
        if %as.write <= 0 { halt }
        var %as._tmp = %as.movetemp $+  $+ %as.write $+  $+ %as.display
        write " $+ $scriptdirarrange.tmp $+ " %as._tmp $+ $crlf
        write -dl $+ $did($dname,49,%x).sel $as.list
        write -il $+ %as.write $as.list $remove(%as.movetemp,$chr(160))
      }
      var %x = 0
      while %x < $lines($scriptdirarrange.tmp) {
        inc %x
        var %as._temp = $read($scriptdirarrange.tmp,%x)
        did -i $dname 7,49 $gettok(%as._temp,2,255) $gettok(%as._temp,3-,255)
        did -ck $dname 7,49 $gettok(%as._temp,2,255)
        did -d $dname 7,49 $calc($gettok(%as._temp,2,255) + 2)
      }
      .remove " $+ $scriptdirarrange.tmp $+ "
    }
    if $did == 53 && $did($dname,49).sel {
      var %x = $did($dname,49,0).sel, %as._tmp = ""
      while %x > 0 {
        var %as.movetemp = $read($as.list,$did($dname,49,%x).sel)
        var %as.write = $calc($did($dname,49,%x).sel + 1)
        var %as.display = $did($dname,49,$did($dname,49,%x).sel).text
        if %as.write >= $lines($as.list) { halt }
        var %as._tmp = %as.movetemp $+  $+ %as.write $+  $+ %as.display
        write " $+ $scriptdirarrange.tmp $+ " %as._tmp $+ $crlf
        write -dl $+ $did($dname,49,%x).sel $as.list
        write -il $+ %as.write $as.list $remove(%as.movetemp,$chr(160))
        dec %x
      }
      var %x = 0
      while %x < $lines($scriptdirarrange.tmp) {
        inc %x
        var %as._temp = $read($scriptdirarrange.tmp,%x)
        did -i $dname 7,49 $calc($gettok(%as._temp,2,255) + 1) $gettok(%as._temp,3-,255)
        did -ck $dname 7,49 $calc($gettok(%as._temp,2,255) + 1)
        did -d $dname 7,49 $calc($gettok(%as._temp,2,255) - 1)
      }
      .remove " $+ $scriptdirarrange.tmp $+ "
    }
    if $did == 54 { .timer -m 1 1 as.clearcheck }
    if $did == 117 {
      if $did($dname,117).state == 1 { did -ub $dname 118 }
      else { did -e $dname 118 }
    }
    if $did == 118 {
      if $did($dname,118).state == 1 { did -ub $dname 117 }
      else { did -e $dname 117 }
    }
    if $did == 120 {
      var %x = 0
      while %x < $lines($as.list) {
        inc %x
        var %as.temp_ = $gettok($read($as.list,%x),1,32)
        if $left(%as.temp_,1) == $chr(59) { continue }
        sockudp -k ASmassupdate $+ %x $gettok(%as.temp_,1,58) $gettok(%as.temp_,2,58) getstatus
        .timer_as.ASmassupdate $+ %x 1 1 as.massupdateremcheck %as.temp_
        dialog -t $dname ArenaScout Q3:A Server Browser by fuel - Refreshing servers $chr(40) $+ $int($calc(%x / $lines($as.list) * 100)) $+ $chr(37) $+ $chr(41)
      }
      dialog -t $dname ArenaScout Q3:A Server Browser by fuel - Sorting servers...
      .timer 1 2 as.serverload
      .timer 1 2 dialog -t $dname ArenaScout Q3:A Server Browser by fuel
    }
    if $did == 55 { did $replace($did($dname,55).state,1,-e,0,-b) $dname 56 }
    if $did == 57 { did $replace($did($dname,57).state,1,-e,0,-b) $dname 58 }
    if $did == 59 { did $replace($did($dname,59).state,1,-e,0,-b) $dname 60 }
    if $did == 61 { did $replace($did($dname,61).state,1,-e,0,-b) $dname 62 }
    if $did == 63 {
      if $did(55).state != 1 && $did(57).state != 1 && $did(59).state != 1 && $did(61).state != 1 { halt }
      unset %as.parsing
      did -ra $dname 65 Searching...
      var %as.search = $chr(181) $+ $iif($did($dname,55).state > 0,$did($dname,56).text,0) $+ $chr(181) $+ $iif($did($dname,57).state > 0,$gettok($did($dname,58).text,1,32),0) $+ $chr(181)
      .timer -m 1 1 as.search %as.search $+ $iif($did($dname,59).state > 0,$did($dname,60).text,0) $+ $chr(181) $+ $iif($did($dname,61).state > 0,$did($dname,62).text,0) $+ $chr(181) 
    }
    if $did == 94 { did -r $dname 65 }
    if $did == 126 && $did($dname,126).sel != 1 && $did($dname,126).text != $chr(160) {
      var %as.preset = $readini($scriptdirsearch.ini,searches,$calc($did($dname,126).sel - 2))
      var %as.preset1 = $gettok(%as.preset,2,43)
      if $gettok(%as.preset1,1,44) != $null {
        did -e $dname 56
        did -c $dname 55
        did -c $dname 56 $gettok(%as.preset1,1,44)
      }
      if $gettok(%as.preset1,1,44) == null {
        did -b $dname 56
        did -u $dname 55
      }
      if $gettok(%as.preset1,2,44) != null {
        did -e $dname 58
        did -c $dname 57
        did -c $dname 58 $calc($gettok(%as.preset1,2,44) + 1)
      }
      if $gettok(%as.preset1,2,44) == null {
        did -b $dname 58
        did -u $dname 57
      }
      if $gettok(%as.preset1,3,44) != null {
        did -e $dname 60
        did -c $dname 59
        did -ra $dname 60 $gettok(%as.preset1,3,44)
      }
      if $gettok(%as.preset1,3,44) == null {
        did -b $dname 60
        did -u $dname 59
      }
    }
    if $did == 68 { .timer -m 1 1 as.selectq3 }
    if $did == 85 { as.w settings sping $did($dname,85).state }
    if $did == 90 { as.w settings away $did($dname,90).state }
    if $did == 91 { as.w settings follow $did($dname,91).state }
    if $did == 92 { as.w settings autoclose $did($dname,92).state }
    if $did == 96 {
      as.w settings desktop " $+ $replace($did($dname,96).state,1,d) $+ "
      dialog -x $dname
      arenascout
      did -c arenascout 5
    }
    if $did == 103 && $did($dname,76).text != $null {
      write " $+ $scriptdirlaunch.as $+ " $did($dname,76).text
      as.d 76 $did($dname,76).text
    }
    if $did == 104 && $did($dname,76).sel != 0 {
      write -dl $+ $did($dname,76).sel " $+ $scriptdirlaunch.as $+ "
      did -d $dname 76 $did($dname,76).sel
    }
    if $did == 105 { as.w settings pingcorrection $did($dname,105).state }
    if $did == 106 { as.w settings shortnames $did($dname,106).state }
    if $did == 108 { as.w settings autogame $did($dname,108).state }
    if $did == 111 {
      var %as.col = $did($dname,111).sel
      if %as.col == 1 { var %as.col = n }
      else { var %as.col = $calc(%as.col - 2) }
      as.w settings col1 %as.col
    }
    if $did == 113 {
      var %as.col = $did($dname,113).sel
      if %as.col == 1 { var %as.col = n }
      else { var %as.col = $calc(%as.col - 2) }
      as.w settings col2 %as.col
    }
    if $did == 116 { as.w settings nick $did($dname,116).state }
    if $did == 119 { as.w settings focus $did($dname,119).state }
    if $did == 71 { .timer -m 1 1 as.friend add }
    if $did == 72 && $did($dname,70).sel { .timer -m 1 1 as.friend edit }
    if $did == 73 && $did($dname,70).sel { .timer -m 1 1 as.friend del }
    if $did == 74 { .timer -m 1 1 as.friend clear }
    if $did == 99 {
      if $did($dname,98,0).sel > 0 {
        if $gettok($did($dname,98,1).seltext,0,32) < 2 {
          var %x = 0
          while %x < $did($dname,98,0).sel {
            inc %x
            as.addserver $did($dname,98,$did($dname,98,%x).sel).text
          }
          halt
        }
        else {
          var %x = 0
          while %x < $did($dname,98,0).sel {
            inc %x
            var %as.newserver = $did($dname,98,$did($dname,98,%x).sel).text, %as.newserver2 = $gettok($gettok(%as.newserver,2,160),2,32)
            write $as.list $remove(%as.newserver2,$chr(160)) >> $remove($gettok($gettok(%as.newserver,4,160),2-,32),$chr(160)) $+ $crlf
            var %as.len = $width(%as.newserver2,ms sans serif,11), %as.serv = %as.newserver2 $+ $str($chr(160),$int($calc((114 - %as.len) / 3)))
            as.d 7,49 %as.serv >> $gettok($gettok(%as.newserver,4,160),2-,32)
          }
        }
      }
      else { halt }
    }
    if $did == 100 {
      if $chr(62) isin $did($dname,98,1).text { halt }
      did -b $dname 100,101,131,133
      as.master refresh
    }
    if $did == 101 { as.master update }
    if $did == 102 {
      if $did($dname,98).lines > 6 {
        var %x = 0
        while %x < $did($dname,98).lines {
          inc %x
          write " $+ $scriptdirserverlist.txt $+ " $did($dname,98,%x).text
        }
        run notepad " $+ $scriptdirserverlist.txt $+ "
      }
    }
    if $did == 79 {
      var %as.help = $readini($scriptdirhelp.ini,$did($dname,79,1).seltext,head)
      if %as.help == $null { halt }
      did -ra $dname 81 %as.help $crfl $crlf
      as.d 81 $crlf $+ $readini($scriptdirhelp.ini,$did($dname,79,1).seltext,text)
    }
    if $did == 86 { run notepad " $+ $scriptdirreadme.txt $+ " }
    if $did == 87 { run mailto:fuel@daed.org?subject=ArenaScout }
    if $did == 88 { run notepad " $+ $scriptdirnotes.txt $+ " }
    if $did == 95 { run notepad " $+ $scriptdirversions.txt $+ " }
    if $did == 109 { run http://www.clan-dna.com/fuel/arenascout/ }
  }
}


alias arenascout {
  $decode(YXMuY2hlY2s=,m)
  if !$dialog(arenascout) {
    unset %as-follow
    if $exists($scriptdirplayers.as) { .remove " $+ $scriptdirplayers.as $+ " }
    dialog -m $+ $as.i(desktop) arenascout arenascout
  }
}
alias asback {
  if $right($me,3) == |Q3 { nick $left($me,$calc($len($me) - 3)) }
  unset %as-follow
  if $away == $true {
    if $isalias(back) == $true { $iif($show == $true,back,.back) }
    else {
      if $show == $true && $left($active,1) == $chr(35) { me is back from playing quake 3... }
      .raw -q away
    }
  }
}
alias -l as.scout {
  if !$1 { halt }
  sockclose ArenaScout
  if $chr(58) isin $1- && $1 != -n { var %as.scout = $gettok($1,1,58) $gettok($1,2,58) }
  else { var %as.scout = $1 27960 }
  var %as.scout = $remove(%as.scout,$chr(160))
  if $remove(%as.scout,$chr(46),$chr(32)) !isnum { halt }
  if $exists($scriptdirplayers.as) {
    var %as.ipcheck = $replace(%as.scout,$chr(32),$chr(58))
    if %as.ipcheck != $read($scriptdirplayers.as,1) { .remove " $+ $scriptdirplayers.as $+ " }
  }
  arenascout
  set %as.ip $gettok(%as.scout,1,32)
  set %as.port $remove($gettok(%as.scout,2,32),$chr(160))
  if $dialog(arenascout) { did -ra arenascout 84 %as.ip $+ : $+ %as.port }
  set %as.players 0
  set %as.teamed 0
  set %as.clients ""
  dialog -t arenascout ArenaScout Q3:A Server Browser by fuel - Querying server
  set %as.ticks $ticks
  sockudp -k ArenaScout %as.scout getstatus
  .timer_as.timeout 1 1 as.timeout
}
alias -l as.unload {
  var %as.junk = $input(Are you sure you wish to unload Arena Scout?,136)
  if %as.junk != $false {
    echo $colour(other) -a *** Unloaded Arena Scout.
    echo $colour(other) -a *** To reload it type /load -rs " $+ $script $+ "
    .timer -m 1 1 .unload -rs $script
  }
}
alias -l as.serverload {
  did -r arenascout 7,49
  var %x = 0
  while %x < $lines($as.list) {
    inc %x
    var %as.read = $read($as.list(s),n,%x)
    tokenize 32 %as.read
    if  isin $1- { write -l $+ %x $as.list $remove($1-,) }
    if $len($gettok($1,2,58)) > 5 { write -l $+ %x $as.list $mid($1,1,$calc($len($1) - 1)) }
    var %as.len = $width($1,ms sans serif,11), %as.serv = $1 $+ $str($chr(160),$int($calc((114 - %as.len) / 3))) $2-
    if $left(%as.serv,1) == $chr(59) {
      as.d 7,49 // $remove($right(%as.serv,$calc($len(%as.serv) - 1)),$chr(160))
      continue
    }
    as.d 7,49 %as.serv
  }
}
alias -l as.w { writeini " $+ $scriptdirarena.ini $+ " $1- }
alias -l as.i { return $readini($scriptdirarena.ini,settings,$1-) }
alias -l as.d { did -a arenascout $1- }
alias -l as.o { did -o arenascout $1- }
alias -l as.list {
  if $1 == s { return $shortfn($scriptdirservers.as) }
  else { return " $+ $scriptdirservers.as $+ " }
}
alias -l as.map { return " $+ $scriptdirimages\ $+ $1 $+ .jpg $+ " }
alias -l as.friends { return " $+ $scriptdirfriends.as $+ " }
alias -l as.selectq3 {
  var %as.q3 = $sfile($left($mircdir,3),Browse for your quake 3 executable)
  if %as.q3 {
    writeini $shortfn($scriptdirarena.ini) settings quake3 " $+ %as.q3 $+ "
    did -ra arenascout 67 %as.q3
  }
}
alias -l as.timeout {
  sockclose ArenaScout
  if !$dialog(arenascout) { halt }
  dialog -t arenascout ArenaScout Q3:A Server Browser by fuel
  did -ra arenascout 32 999
  if $as.i(focus) == 1 { did -c arenascout 2 }
  var %as.server = %as.ip $+ : $+ %as.port, %as.server = $remove(%as.server,$chr(160))
  if %as.server == $chr(58) { var %as.server = $remove($gettok($did(arenascout,7,1).seltext,1,32),$chr(160)) }
  var %as.seltemp = $did(arenascout,7).sel
  if $read($as.list(s),sn,%as.server) != $null { var %as.seltemp = $readn }
  else {
    set %as.seltemp $calc($lines($as.list) + 1)
    as.d 7,49 %as.server
  }
  did -c arenascout 7 %as.seltemp
  var %as.len = $width(%as.server,ms sans serif,11), %as.serv = %as.server $str($chr(160),$int($calc((114 - %as.len) / 3)))
  write -l $+ %as.seltemp $as.list(s) %as.server >> Timed Out
  tokenize 32 $read($as.list(s),%as.seltemp)
  var %as.len = $width($1,ms sans serif,11), %as.serv = $1 $+ $str($chr(160),$int($calc((114 - %as.len) / 3))) >> Timed Out
  as.o 7 %as.seltemp %as.serv
  as.o 49 %as.seltemp %as.serv
  did -c arenascout 7,49 %as.seltemp
  did -g arenascout 8 $as.map(default)
  did -ra arenascout 9 timed out
  did -ra arenascout 22 0
  did -ra arenascout 23 0
  did -ra arenascout 27 0
  did -ra arenascout 28 0
  did -ra arenascout 30 0
  did -ra arenascout 34 0
  did -ra arenascout 36 0
  did -ra arenascout 38 0
  did -ra arenascout 40 0/0
  did -ra arenascout 47 0
  did -ra arenascout 48 %as.server Timed out
  did -r arenascout 11,13,15,42
  unset %as.*
}
alias -l as.removecolor {
  var %as.name = $replace($1-,^1,,^2,,^3,,^4,,^5,,^6,,^7,,^8,,^9,,^0,,^^0,,^!,,^@,,^#,,^$,,^%,,^&,,^*,,^_,,^-,,^\,,^/,,^=,,^",,^',,^+,,^.,,^+,,^a,,^b,,^c,,^d,,^e,,^f,,^g,,^h,,^i,,^j,,^k,,^l,,^m,,^n,,^o,, $&
    ^p,,^q,,^r,,^s,,^t,,^u,,^v,,^w,,^y,,^z,,^,)
  var %as.name = $strip(%as.name) $+ $chr(160)
  if $did(arenascout,40).text == osp || OSP isincs $did(arenascout,122).text {
    if ^x isin %as.name {
      var %x = 0
      var %as.ospname = %as.name
      while %x < $len(%as.name) {
        inc %x
        if $mid(%as.ospname,%x,2) == ^x { var %as.ospname = $strip($replace(%as.ospname,$mid(%as.ospname,%x,8),)) }
        if $mid(%as.ospname,%x,2) == ^x { var %as.ospname = $strip($replace(%as.ospname,$mid(%as.ospname,%x,8),)) }
      }
      var %as.name = %as.ospname
    }
  }
  return %as.name
}
alias -l as.parse {
  var %as.findtoken = $findtok($2-,$1,1,92)
  var %as.gettoken = $remove($gettok($2-,$calc(%as.findtoken + 1),92),$chr(124))
  return %as.gettoken
}
alias -l as.sortplayers {
  if !$dialog(arenascout) { unset %as.* | halt }
  did -r arenascout 11,13,15
  var %x = 0, %as.redteamcache = $read($scriptdirplayers.as,2), %as.blueteamcache = $read($scriptdirplayers.as,3)
  while %x < $gettok(%as.redteamcache,0,181) {
    inc %x
    var %as.cache = $gettok(%as.redteamcache,%x,181)
    set %as.redteam $addtok(%as.redteam,%as.cache,181)
    set %as.blueteam $remtok(%as.blueteam,%as.cache,1,181)
  }
  var %x = 0
  while %x < $gettok(%as.blueteamcache,0,181) {
    inc %x
    var %as.cache = $gettok(%as.blueteamcache,%x,181)
    set %as.blueteam $addtok(%as.blueteam,%as.cache,181)
    set %as.redteam $remtok(%as.redteam,%as.cache,1,181)
  }
  var %x = 0, %as.players = $gettok(%as.clients,0,181)
  set %as.clients $sorttok(%as.clients,181,nr)
  var %as.redping = 0, %as.blueping = 0, %as.redtemp = 0, %as.bluetemp = 0, %as.redscore = 0, %as.bluescore = 0
  while %x < $gettok(%as.clients,0,181) {
    inc %x
    tokenize 182 $gettok(%as.clients,%x,181)
    if $istok(%as.redteam,$3-,181) {
      var %as.icon = <r>
      inc %as.redping $2
      inc %as.redtemp 1
      inc %as.redscore $1
    }
    elseif $istok(%as.blueteam,$3-,181) {
      var %as.icon = <b>
      inc %as.blueping $2
      inc %as.bluetemp 1
      inc %as.bluescore $1
    }
    else { var %as.icon = <n> }
    as.d 11 %as.icon $3-
    as.d 13 $1
    as.d 15 $2
  }
  var %as.showp = $iif($gettok($did(arenascout,30).text,0,47) == 3,$did(arenascout,30).text,$iif(%as.players == $null,0,%as.players) $+ / $+ $did(arenascout,30).text)
  did -ra arenascout 30 %as.showp
  var %as.redping_ = $int($calc(%as.redping / %as.redtemp))
  did -ra arenascout 23 $iif(%as.redping_,%as.redping_,0)
  var %as.blueping_ = $int($calc(%as.blueping / %as.bluetemp))
  did -ra arenascout 28 $iif(%as.blueping_,%as.blueping_,0)
  if $gettok($did(arenascout,38).text,2,32) !isin (ctf)(ca)(tdm) {
    did -ra arenascout 22 %as.redscore
    did -ra arenascout 27 %as.bluescore
  }
  unset %as.*
}
alias -l as.clearcheck {
  var %as.check = $$input(Are you sure you want to clear your entire servers list?,264)
  if %as.check == $true { write -c $as.list }
  as.serverload
}
alias -l as.addserver {
  if $1 {
    write $as.list $remove($1,$chr(160))
    as.d 7,49 $1
    return
  }
  var %as.addserver = $remove($$input(Enter the server name and port in this format: 127.0.0.1:27960 or my.q3server.com:27960. You can also enter a comment by starting the line with a semi colon (;) followed by your comment.,1),$chr(124))
  if $left(%as.addserver,1) == $chr(59) {
    write $as.list $remove(%as.addserver,$chr(160))
    as.d 7,49 // $right(%as.addserver,$calc($len(%as.addserver) - 1))
    halt
  }
  if $remove(%as.addserver,$chr(46),$chr(58),$chr(32)) !isnum && $chr(46) isin %as.addserver {
    if $gettok(%as.addserver,0,58) > 1 { set %as.dns %as.addserver }
    else { set %as.dns %as.addserver $+ : $+ 27960 }
    .dns $gettok(%as.dns,1,58)
    halt
  }
  if $remove(%as.addserver,$chr(46),$chr(58),$chr(32)) isnum {
    if $chr(58) isin %as.addserver {
      if $gettok(%as.addserver,2,58) isnum {
        var %as.addport = $gettok(%as.addserver,2,58)
        goto ip
      }
      else {
        var %as.addport = 27960
        goto ip
      }
    }
    if $gettok(%as.addserver,2,32) != $null && $gettok(%as.addserver,2,32) isnum { var %as.addport = $gettok(%as.addserver,2,32), %as.addip = $gettok(%as.addserver,1,32) }
    else { var %as.addip = $gettok(%as.addserver,1,32), %as.addport = 27960 }
    :ip
    var %as.addip = $gettok($gettok(%as.addserver,1,32),1,58)
    write $as.list %as.addip $+ : $+ %as.addport
    as.d 7,49 %as.addip $+ : $+ %as.addport
  }
  else {
    var %as.junk = $$input(An error has been encountered. Please re-enter the server or comment you wish to add.,516)
    halt
  }
}
alias -l as.autoscout {
  if !$dialog(arenascout) {
    .timer_AS.autoupdate off
    halt
  }
  if $1 { as.scout $1 }
}
alias -l as.friend {
  if $1 == add {
    var %as.addfriend = $$input(Enter the users name or part of a name and wildcard $+ $chr(40) $+ s $+ $chr(41) $chr(40) $+ ie: *dna* or fuel $+ $chr(41),129)
    if %as.addfriend {
      write $as.friends %as.addfriend
      as.d 62,70 %as.addfriend
      halt
    }
    else { halt }
  }
  if $1 == del {
    write -dl $+ $did(arenascout,70,1).sel $as.friends
    did -d arenascout 62,70 $did(arenascout,70,1).sel
    halt
  }
  if $1 == edit {
    var %as.editfriend = $$input(Edit your friends name,129,mIRC,$did(arenascout,70).seltext)
    if %as.editfriend {
      write -l $+ $did(arenascout,70,1).sel $as.friends %as.editfriend
      as.o 62,70 $did(arenascout,70,1).sel %as.editfriend
    }
  }
  if $1 == clear {
    var %as.clear = $$input(Are you sure you want to clear your friends list?,136)
    if %as.clear == $true {
      write -c $as.friends
      did -r arenascout 62,70
      halt
    }
    else { halt }
  }
  if $1 == addfromlist {
    var %as.editfriend = $$input(Add your friend,129,mIRC,$2-)
    if %as.editfriend {
      write $as.friends %as.editfriend
      as.d 62,70 $did(arenascout,70,1).sel %as.editfriend
    }
  }
}
alias -l as.type {
  if $2 == asinit { var %as.type = $replace($1,0,ffa,1,tourney,2,single,3,tdm,4,ctf,5,ca,6,null,7,null,8,ra3) }
  elseif $2 == baseq3 { var %as.type = $replace($1,0,ffa,1,tourney,2,single,3,tdm,4,ctf) }
  elseif $2 == osp || $2 == cpma { var %as.type = $replace($1,0,ffa,1,tourney,2,single,3,tdm,4,ctf,5,ca) }
  elseif $2 == arena { var %as.type = $replace($1,8,ra3) }
  elseif $2 == q3ut2 { var %as.type = $replace($1,0,ffa,1,ffa,2,ffa,3,tdm,4,ts,5,ftl,6,cap,7,ctf) }
  else { var %as.type = $replace($1,0,ffa,1,tourney,2,single,3,tdm,4,ctf) }
  if $3 == b {
    if %as.type == null { return }
    return $chr(40) $+ %as.type $+ $chr(41)
  }
}
alias -l as.massupdateremcheck {
  var %as.readn = $read($as.list(s),sn,$1)
  if $readn == $null { halt }
  if $did(arenascout,101).state == 1 {
    aline -a @ASm 999 >> $1 >> Timed Out
  }
  write -l $+ $readn $as.list(s) $1 >> Timed Out
  if $did(arenascout,117).state == 1 {
    write -dl $+ $readn $as.list(s)
    write $as.list(s) $1 >> Timed Out
    halt
  }
  if $did(arenascout,118).state == 1 { write -dl $+ $readn $as.list(s) }
}
alias -l as.check {
  if $encode($crc($scriptdirextensions\scout.dll),m) != M0VCNzFFMzc= {
    echo $colour(other) -a *** The scout.dll crc does not match that of the original scout.dll. It is being removed for your protection.
    .remove $scriptdirextensions\scout.dll
  }
  else return
}
alias -l as.search {
  set %as.searchmatch $1-
  var %x = 0
  while %x < $lines($as.list) {
    inc %x
    var %as.qserver
    var %as.qserver = $gettok($gettok($read($as.list,%x),1,32),1,58) $gettok($gettok($read($as.list,%x),1,32),2,58)
    if $left(%as.qserver,1) == $chr(59) || %as.qserver == $null { continue }
    sockudp -k ASSearch $+ %x %as.qserver getstatus
    sockmark ASSearch $+ %x 
  }
  .timer_asresults 1 1 as.searchparse
}
alias -l as.searchparse {
  if !$dialog(arenascout) { sockclose ASSearch* }
  set %as.parsing 1
  var %x = 0
  did -r arenascout 65
  while %x < $lines($as.list) {
    inc %x
    var %as.sparse = $sock(ASSearch $+ %x).mark
    if $remove(%as.sparse,$chr(181)) == $null { continue }
    if $did(arenascout,55).state == 1 && $did(arenascout,56).seltext == empty && $istok(%as.sparse,populated,181) == $false { goto next }
    if $did(arenascout,55).state == 1 && $istok(%as.sparse,$did(arenascout,56).seltext,181) == $false { continue }
    :next
    if $did(arenascout,57).state == 1 && $istok(%as.sparse,$gettok($did(arenascout,58).seltext,1,32),181) == $false { continue }
    if $did(arenascout,59).state == 1 && $istok(%as.sparse,$did(arenascout,60).text,181) == $false { continue }
    if $did(arenascout,61).state == 1 && $istok(%as.sparse,found,181) == $false { continue }
    tokenize 32 $read($as.list(s),n,%x)
    var %as.len = $width($1,ms sans serif,11), %as.serv = $1 $+ $str($chr(160),$int($calc((114 - %as.len) / 3))) $2-
    as.d 65 %as.serv
    sockclose ASSearch $+ %x
  }
  if $did(arenascout,65).lines == 0 {
    as.d 65 No matches for: $gettok($replace(%as.searchmatch,$chr(181),$chr(44) $+ $chr(32)),1-4,44) $+ .
  }
  unset %as.searchmatch
}
alias -l as.spingtimeout {
  inc %as_sping_lostpackets 1
  inc %as_sping_sentpackets 1
  if %as_sping_sentpackets < 10 {
    sockclose ASSPing
    set %as_sping_ping $ticks
    sockudp -k ASSPing %as_sping_ip %as_sping_port getstatus
    .timer_spingtimeout 1 1 as.spingtimeout
    halt
  }
  elseif %as_sping_sentpackets >= 10 { 
    msg %as_sping_chan [  $+ %as_sping_ip $+ : $+ %as_sping_port $+  ] ping: $+ $iif(%as_sping_report == 0,N/A,$int($calc(%as_sping_report / (%as_sping_sentpackets - %as_sping_lostpackets))) $+ ms) $&
      sent: $+ %as_sping_sentpackets lost: $+ %as_sping_lostpackets $chr(40) $+ $calc(%as_sping_lostpackets / %as_sping_sentpackets * 100) $+ $chr(37) $+ $chr(41) [ ArenaScout ]
    unset %as_sping_*
    sockclose ASSPing
    .timer_spingtimeout off
  }
}
alias -l as.cola {
  var %as.col = $as.i(col1)
  if %as.col = n || c isin $gettok($chan($active).mode,1,32) { return $1- }
  else { return  $+ %as.col $+  $+ $1- $+  }
}
alias -l as.colb {
  var %as.col = $as.i(col2)
  if %as.col = n || c isin $gettok($chan($active).mode,1,32) { return $1- }
  else { return  $+ %as.col $+  $+ $1- $+  }
}
alias -l as.mastertimeout {
  sockclose ASidmaster
  if !$dialog(arenascout) { halt }
  did -ra arenascout 98 Error! Connection could not be established.
  did -b arenascout 100
  did -e arenascout 101
  halt
}
alias -l as.sortmaster {
  did -e arenascout 100,101
  var %x = 0
  write -c " $+ $scriptdirmaster.as $+ " 
  while $findfile($scriptdir,master.m*,0) > 0 {
    if $exists(%as.master) { .remove %as.master }
    var %as.master = " $+ $findfile($scriptdir,master.m*,1) $+ "
    if $exists(%as.master) == $false { break }
    bread %as.master 23 $lof(%as.master) &as.master
    var %as.master2 = 0
    while %as.master2 < $calc($lof(%as.master) - 22) {
      var %as.master3 = $bvar(&as.master,%as.master2,7).text
      if $left(%as.master3,1) == $chr(92) && $len(%as.master3) == 7 {
        var %as.masterip = $asc($mid(%as.master3,2,1)) $+ . $+ $asc($mid(%as.master3,3,1)) $+ . $+ $asc($mid(%as.master3,4,1)) $+ . $+ $asc($mid(%as.master3,5,1))
        var %as.masterport = $dll($scriptdirextensions\scout.dll,port,$mid(%as.master3,6,2))
        var %as.masternew = %as.masterip $+ : $+ %as.masterport
        var %as.readn = $read($scriptdirmaster.as,s,%as.masternew)
        if $left(%as.masterport,1) != $chr(45) && $readn == 0 { write " $+ $scriptdirmaster.as $+ " %as.masternew $+ $crlf }
      }
      inc %as.master2 7
    }
  }
  var %x = 0
  did -r arenascout 98
  while %x < $lines($scriptdirmaster.as) {
    inc %x
    as.d 98 $read($scriptdirmaster.as,n,%x)
  }
  .remove " $+ $scriptdirmaster.as $+ "
}
alias -l as.master {
  if $1 == update {
    if $lock(dll) == $true {
      .timer -m 1 1 var %as.junk = $input(mIRC's /dll command is disabled. In order to parse the information from the id q3 master server you will need enable it. $crlf $crlf $+ To do so click on File -> Options -> General -> Lock and then uncheck /dll.,68)
      halt
    }
    did -b arenascout 100,101
    did -ra arenascout 98 Requesting list from id master server...
    sockclose ASidmaster
    sockudp -k ASidmaster 192.246.40.56 27950 getservers 67 empty full
    sockudp -k ASidmaster 
    sockmark ASidmaster 1
    .timer_asmastertimeout 1 5 as.mastertimeout
  }
  if $1 == refresh {
    did -b arenascout 100,101,131,133
    if $did(arenascout,98).lines < 6 { halt }
    dialog -t arenascout ArenaScout Q3:A Server Browser by fuel - Pinging Servers
    var %x = 0, %z = 0, %y = 0
    while %x < $did(arenascout,98).lines {
      inc %x 25
      inc %y
      var %a = 0, %as.msq2 = ""
      while %a < 25 {
        inc %z
        inc %a
        var %as.msq = %z $+ : $+ $did(arenascout,98,%z).text
        var %as.msq2 = $addtok(%as.msq2,%as.msq,44)
      }
      write " $+ $scriptdirupdate.q $+ " %as.msq2 $+ $crlf
    }
    write " $+ $scriptdirupdate.q $+ " as.master uref
    write " $+ $scriptdirupdate.q $+ " %y
    .timer_as.update.queue 0 3 as.mqueue
  }
  if $1 == uref {
    if !$dialog(arenascout) {
      sockclose ASmasterquery*
      halt
    }
    if $exists($scriptdirtemp.as) {
      did -e arenascout 101,131,133
      dialog -t arenascout ArenaScout Q3:A Server Browser by fuel
      sockclose ASmasterquery*
      did -r arenascout 98
      var %x = 0
      while %x < $lines($scriptdirtemp.as) {
        inc %x
        as.d 98 $read($scriptdirtemp.as,n,%x)
      }
      .remove " $+ $scriptdirtemp.as $+ "
    }
  }
  else { halt }
}
alias -l as.mqueue {
  if $dialog(arenascout) == $null {
    .timer_as.update.queue off
    .remove " $+ $scriptdirupdate.q $+ "
    .remove " $+ $scriptdirtemp.as $+ "
    halt
  }
  var %x = 0
  if $read($scriptdirupdate.q,n,1) == as.master uref {
    .timer_as.update.queue off
    .remove " $+ $scriptdirupdate.q $+ "
    as.master uref
    halt
  }
  sockclose ASmasterquery*
  tokenize 44 $read($scriptdirupdate.q,n,1)
  write -dl1 " $+ $scriptdirupdate.q $+ "
  while %x < $gettok($1-,0,32) {
    inc %x 
    var %as.randomized = %x $+ $rand(a,z) $+ $rand(a,z) $+ $rand(a,z) $+ $rand(0,9) $+ $rand(0,9) $+ $rand(a,z)
    if $gettok($gettok($1-,%x,32),0,58) > 1 {
      sockudp -k ASmasterquery $+ %as.randomized $gettok($gettok($1-,%x,32),2,58) $gettok($gettok($1-,%x,32),3,58) getstatus
      sockmark ASmasterquery $+ %as.randomized $gettok($gettok($1-,%x,32),1,58) $ticks $gettok($gettok($1-,%x,32),2-,58) 
    }
    dialog -t arenascout ArenaScout Q3:A Server Browser by fuel - Pinging Servers ( $+ $int($calc(100 - (($lines($scriptdirupdate.q) - 2) / $read($scriptdirupdate.q,n,$lines($scriptdirupdate.q)) * 100))) $+ $chr(37) $+ )
  }
}
alias -l as.timeparse {
  if $1 == osp {
    if Paused isin $4 { return Paused }
    if Timeout isin $4 { return $remove($lower($4),Timeout: ) pause }
    if waiting isin $4- { return Waiting }
    if $2 == 5 && $4 == starting { return Starting }
    if $2 == 5 { return round $gettok($4-,2-,32) }
    if OT isincs $3- { return $4 $+ / $+ $3 }
    if $remove($3,$chr(58)) isnum && $remove($4,$chr(58)) isnum { return $4 $+ / $+ $3 }
    if $3 isnum { return $3 }
    else { return unknown }
  }
  if OT isincs $3- { return $4 $+ / $+ $3 }
  if $4- == waiting for players { return Waiting }
  if $remove($3,:) isnum && $remove($4,:) isnum { return $4 $+ / $+ $3 }
  if $3 isnum { return $3 }
  else { return unknown }
}


on *:udpread:ArenaScout {
  var %as.ping = $remove($calc($ticks - %as.ticks),$chr(45))
  if $as.i(pingcorrection) == 1 { var %as.ping = $calc(%as.ping - 10) }
  if $timer(_as.timeout) { .timer_as.timeout off }
  var %as.udp
  sockread %as.udp
  if !$dialog(arenascout) {
    sockclose arenascout
    halt
  }
  if $left(%as.udp,4) ==  {
    dialog -t arenascout ArenaScout Q3:A Server Browser by fuel
    if $as.i(focus) == 1 { did -c arenascout 2 }
    did -ra arenascout 32 $iif(%as.ping > 999,999,%as.ping)
    unset %as.ticks
    .timer -m 1 100 as.sortplayers
  }
  if $left(%as.udp,1) == $chr(92) {
    var %as.server = $sock($sockname).saddr $+ : $+ $sock($sockname).sport, %as.seltemp = $did(arenascout,7).sel
    if $remove(%as.server,$chr(58)) == $null { set %as.server $gettok($did(arenascout,7).seltext,1,32) }
    if $read($as.list(s),sn,%as.server) != $null { set %as.seltemp $readn }
    else {
      set %as.seltemp $calc($lines($as.list) + 1)
      as.d 7,49 %as.server
    }
    did -c arenascout 7,49 %as.seltemp
    write -l $+ %as.seltemp $as.list(s) %as.server >> $remove($as.removecolor($remove($as.parse(sv_hostname,%as.udp),$chr(124))),$chr(160))
    tokenize 32 $read($as.list(s),%as.seltemp)
    var %as.len = $width($1,ms sans serif,11), %as.serv = $1 $+ $str($chr(160),$int($calc((114 - %as.len) / 3))) >> $remove($as.removecolor($as.parse(sv_hostname,%as.udp)),$chr(160))
    as.o 7 %as.seltemp %as.serv
    as.o 49 %as.seltemp %as.serv
    did -c arenascout 7,49 %as.seltemp
    did -ra arenascout 40 $as.parse(gamename,%as.udp)
    did -ra arenascout 47 $as.parse(g_needpass,%as.udp)
    did -ra arenascout 48 %as.server $as.parse(sv_hostname,%as.udp)
    did -ra arenascout 122 $iif($istok(%as.udp,gameversion,92),$gettok($as.parse(version,%as.udp),1-2,32) / $as.parse(gameversion,%as.udp),$gettok($as.parse(version,%as.udp),2-,32))
    if $as.parse(players_red,%as.udp) != $null {
      set %as.redplayers $as.parse(players_red,%as.udp)
      set %as.blueplayers $as.parse(players_blue,%as.udp)
    }
    did -g arenascout 8 $iif($exists($as.map($as.parse(mapname,%as.udp))),$as.map($as.parse(mapname,%as.udp)),$as.map(default))
    did -ra arenascout 9 $iif($lower($as.parse(mapname,%as.udp)) != gamename,$ifmatch,unknown)
    did -ra arenascout 38 $iif($as.parse(g_gametype,%as.udp) isnum,$ifmatch $as.type($as.parse(g_gametype,%as.udp),$did(arenascout,40),b),unknown)
    did -ra arenascout 34 $as.timeparse($as.parse(gamename,%as.udp),$as.parse(g_gametype,%as.udp),$as.parse(timelimit,%as.udp),$as.parse(score_time,%as.udp))
    did -ra arenascout 36 $iif($as.parse(fraglimit,%as.udp) != $null && $as.parse(fraglimit,%as.udp) isnum,$ifmatch,$iif($as.parse(fraglimit,%as.udp) isnum,$ifmatch,unknown))
    did -ra arenascout 30 $iif($as.parse(sv_maxclients,%as.udp) isnum,$ifmatch,unknown) $+ / $+ $iif($as.parse(sv_privateclients,%as.udp) isnum,$ifmatch,??)
    did -ra arenascout 22 $iif($as.parse(score_red,%as.udp) isnum,$ifmatch,0)
    did -ra arenascout 27 $iif($as.parse(score_blue,%as.udp) isnum,$ifmatch,0)
    if $did(arenascout,47) == 1 {
      if $readini($scriptdirarena.ini,passwords,%as.server) != $null { did -ra arenascout 42 $ifmatch }
      else { did -ra arenascout 42 required }
    }
    else { did -r arenascout 42 }
    if $readini($scriptdirarena.ini,passwords,%as.server) != $null { did -ra arenascout 42 $ifmatch }
    unset %as.ip %as.port
    did -r arenascout 11,13,15
  }
  if $gettok(%as.udp,1,32) isnum {
    inc %as.teamed
    var %as.player = $gettok($gettok(%as.udp,1,34),1,32) $gettok($gettok(%as.udp,1,34),2,32) $replace($as.removecolor($gettok(%as.udp,2,34)),$null,noname,$chr(32),$chr(160))
    tokenize 32 %as.player
    if $istok(%as.redplayers,%as.teamed,32) {
      set %as.redteam $addtok(%as.redteam,$3-,181)
    }
    if $istok(%as.blueplayers,%as.teamed,32) {
      set %as.blueteam $addtok(%as.blueteam,$3-,181)
    }
    var %as.client = $1 $+ $chr(182) $+ $2 $+ $chr(182) $+ $3-
    set %as.clients $addtok(%as.clients,%as.client,181)
  }
}
on *:udpread:ASSearch* {
  if %as.parsing { return }
  did -ra arenascout 65 Reading replies...
  var %as.searchresult
  sockread %as.searchresult
  tokenize 181 %as.searchmatch
  if $left(%as.searchresult,1) == \ {
    sockmark $sockname $addtok($sock($sockname).mark,$as.parse(g_gametype,%as.searchresult),181)
    sockmark $sockname $addtok($sock($sockname).mark,$as.parse(gamename,%as.searchresult),181)
    return
  }
  elseif $gettok(%as.searchresult,1,32) isnum {
    sockmark $sockname $addtok($sock($sockname).mark,populated,181)
    if $4- iswm $as.removecolor($gettok(%as.searchresult,2,34)) || $4- == $remove($as.removecolor($gettok(%as.searchresult,2,34)),$chr(160)) && $4 != 0 { sockmark $sockname $addtok($sock($sockname).mark,found,181) }
    else { return }
  }
  else { return }
}
on *:udpread:ASSPing {
  var %as_sping
  sockread %as_sping
  if $left(%as_sping,4) ==  {
    .timer_spingtimeout off
    inc %as_sping_sentpackets 1
    set %as_sping_report $calc($ticks - %as_sping_ping + %as_sping_report)
    if %as_sping_sentpackets < 10 {
      set %as_sping_ping $ticks
      sockclose ASSPing
      sockudp -k ASSPing %as_sping_ip %as_sping_port getstatus
      .timer_spingtimeout 1 1 as.spingtimeout
      halt
    }
    elseif %as_sping_sentpackets >= 10 { 
      .timer_spingtimeout off
      msg %as_sping_chan [  $+ %as_sping_ip $+ : $+ %as_sping_port $+  ] ping: $+ $iif(%as_sping_report == 0,N/A,$int($calc(%as_sping_report / (%as_sping_sentpackets - %as_sping_lostpackets))) $+ ms) $&
        sent: $+ %as_sping_sentpackets lost: $+ %as_sping_lostpackets $chr(40) $+ $calc(%as_sping_lostpackets / %as_sping_sentpackets * 100) $+ $chr(37) $+ $chr(41) [ ArenaScout ]
      unset %as_sping_*
    }
  }
}
on *:udpread:ASidmaster {
  .timer_asmastertimeout off
  .timer_asmasterparse off
  if !$dialog(arenascout) {
    sockclose $sockname
    halt
  }
  did -r arenascout 98
  as.d 98  
  as.d 98 
  as.d 98 
  as.d 98 
  as.d 98 
  as.o 98 1 Socket connected $+ $chr(44) receiving data.
  as.o 98 3 Please be patient while the data is being sorted.
  as.o 98 4 mIRC will "freeze" while this is happening, but it
  as.o 98 5 won't take long.
  if $sockerr {
    did -ra arenascout 98 Socket error: $sockerr
    sockclose $sockname
    return
  }
  var &binvar
  sockread &binvar
  var %as.binaryfile = $scriptdirmaster.m $+ $sock($sockname).mark
  bwrite " $+ %as.binaryfile $+ " -1 -1 $bvar(&binvar,1,8192).text $crlf
  sockmark $sockname $calc($sock($sockname).mark + 1)
  .timer_asmasterparse 1 1 as.sortmaster
}
on *:udpread:ASmasterquery* {
  var %as.udp
  sockread %as.udp
  if !$dialog(arenascout) {
    sockclose arenascout
    halt
  }
  if $left(%as.udp,4) ==  {
    sockmark $sockname $gettok($sock($sockname).mark,1,32) $remove($calc($ticks - $gettok($sock($sockname).mark,2,32) - 30),$chr(45)) $gettok($sock($sockname).mark,3,32)
  }
  if $left(%as.udp,1) == $chr(92) {
    tokenize 32 $sock($sockname).mark
    if $2 > 999 { var %as.qmping = 999 }
    else { var %as.qmping = $2 }
    if $len(%as.qmping) == 2 { var %as.qmping = 0 $+ %as.qmping }
    if $len(%as.qmping) == 1 { var %as.qmping = 00 $+ %as.qmping }
    var %as.len = $width($3,ms sans serif,11), %as.serv = $3 $+ $str($chr(160),$int($calc((114 - %as.len) / 3))) >> $remove($as.removecolor($remove($as.parse(sv_hostname,%as.udp),$chr(124))),$chr(160))
    var %as.len2 = $width(%as.qmping,ms sans serif,11), %as.len3 = $str($chr(160),$int($calc((17 - %as.len2) / 3)))
    if $gettok($did(arenascout,131).text,1,32) == all || $as.parse(g_gametype,%as.udp) == $gettok($did(arenascout,131).text,1,32) {
      if $did(arenascout,133).text == $null || $as.parse(gamename,%as.udp) == $did(arenascout,133).text { write " $+ $scriptdirtemp.as $+ " %as.qmping %as.len3 >> %as.serv }
    }
    sockclose $sockname
  }
}
on *:udpread:ASmassupdate* {
  if $timer(_as. $+ $sockname ) { .timer_as. $+ $sockname off }
  var %as.udp_
  sockread %as.udp_
  if !$dialog(arenascout) {
    sockclose arenascout
    halt
  }
  if $left(%as.udp_,1) == $chr(92) {
    var %as.server_ = $sock($sockname).saddr $+ : $+ $sock($sockname).sport
    var %as.junk_ = $read($as.list(s),sn,%as.server_)
    if $read($as.list(s),sn,%as.server_) != $null { var %as.seltemp_ = $readn }
    else {
      sockclose $sockname
      halt
    }
    var %as._ = %as.server_ >> $remove($as.removecolor($remove($as.parse(sv_hostname,%as.udp_),$chr(124))),$chr(160))
    write -l $+ %as.seltemp_ %as._
    tokenize 32 $read($as.list(s),%as.seltemp_)
    var %as.len_ = $width($1,ms sans serif,11), %as.serv_ = $1 $+ $str($chr(160),$int($calc((114 - %as.len_) / 3))) >> $gettok(%as._,3-,32)
  }
}
on ^*:hotlink:*quake3?//*:* {
  if . isin $1 { return }
  else { halt }
}
on *:hotlink:*quake3?//*:* {
  if $remove($gettok($1,2,47),.,:) isnum {
    as.scout $gettok($1,2,47)
    halt
  }
  else {
    if $gettok($gettok($1,2,47),2,58) isnum { set %as.dnshl $gettok($1,2,47) }
    else { set %as.dnshl $gettok($1,2,47) $+ :27960 }
    .dns $gettok(%as.dnshl,1,58)
    halt
  }
}
on ^*:hotlink:*.*.*.*:* {
  if $right($gettok($1,1,46),1) isnum && $gettok($1,2,46) isnum 0-255 && $gettok($1,3,46) isnum 0-255 && / !isin $gettok($1,1,46) { return }
  else { halt }
}
on *:hotlink:*.*.*.*:* {
  if $gettok($1,0,58) == 2 {
    var %as.temp = $strip($gettok($1,1,58)) $+ : $+ $strip($left($gettok($1,2,58),5))
    if $left(%as.temp,1) !isnum { var %as.temp = $right(%as.temp,$calc($len(%as.temp) - 1)) }
    as.scout %as.temp
  }
  elseif $gettok($1,0,58) > 2 {
    var %as.temp = $strip($gettok($1,3,58)) $+ : $+ $strip($left($gettok($1,4,58),5))
    if $left(%as.temp,1) !isnum { var %as.temp = $right(%as.temp,$calc($len(%as.temp) - 1)) }
    as.scout %as.temp
  }
  elseif $remove($1,$chr(46)) isnum && $gettok($hotline,$calc($findtok($hotline,$1,1,32) + 1),32) isnum {
    as.scout $1 $+ : $+ $gettok($hotline,$calc($findtok($hotline,$1,1,32) + 1),32)
  }
  else {
    var %as.temp = $1
    var %as.temp2 = $right($gettok($1,1,46),3) $+ . $+ $gettok(%as.temp,2-3,46) $+ . $+ $left($gettok(%as.temp,4,46),3)
    if $left(%as.temp2,1) !isnum { var %as.temp2 = $right(%as.temp2,$calc($len(%as.temp2) - 1)) }
    if $left(%as.temp2,1) !isnum { var %as.temp2 = $right(%as.temp2,$calc($len(%as.temp2) - 1)) }
    if $right(%as.temp2,1) !isnum { var %as.temp2 = $left(%as.temp2,$calc($len(%as.temp2) - 1)) }
    if $right(%as.temp2,1) !isnum { var %as.temp2 = $left(%as.temp2,$calc($len(%as.temp2) - 1)) }
    as.scout $remove(%as.temp2,$chr(58))
  }
}
on ^*:hotlink:*ArenaScout*:* { return }
on *:hotlink:*ArenaScout*:* { run http://www.clan-dna.com/fuel/arenascout }

on *:text:*:# {
  if $1 == $chr(63) $+ as && !$2 && %as-fflood == $null {
    if $as.i(follow) == 1 && %as-follow {
      set %as-fflood 1
      .timer 1 $r(0,5) describe $chan connected, $duration($calc(($ticks - $gettok(%as-follow,2,32)) / 1000)) ago, to  $+ $gettok(%as-follow,1,32) $+  $gettok(%as-follow,3-,32)
      .timer_as-fflood 1 60 unset %as-fflood
    }
  }
  if ($1 == -sping && $2) || ($1 == $me && $2 == ping && $3) {
    if %as-fflood != $null { halt }
    set %as-fflood 1
    .timer_as-fflood 1 30 unset %as-fflood
    if $as.i(sping) != 1 { return }
    if %as_sping_sentpackets { return }
    var %as.sping = $2-
    if $1 == $me { tokenize 32 %as.sping }
    if $gettok($2,1,46) isnum 0-255 && $gettok($2,2,46) isnum 0-255 && $gettok($2,3,46) isnum 0-255 {
      if $gettok($2,1,58) == 127.0.0.1 { halt }
      unset %as_sping_*
      set %as_sping_lostpackets 0
      set %as_sping_report 0
      set %as_sping_port 27960
      set %as_sping_chan $chan
      if $chr(58) isin $2 { set %as_sping_port $gettok($2,2,58) }
      set %as_sping_ip $gettok($2,1,58)
      if $3 isnum { set %as_sping_port $3 }
      if $4 == $null {
        sockudp -k ASSPing %as_sping_ip %as_sping_port getstatus
        set %as_sping_ping $ticks
        .timer_spingtimeout 1 1 as.spingtimeout
      }
    }
  }
}
on *:input:# {
  if %as_sping_sentpackets { return }
  if ($1 == -sping && $2) || ($1 == $me && $2 == ping && $3) {
    if $as.i(sping) != 1 { return }
    var %as.sping = $2-
    if $1 == $me { tokenize 32 %as.sping }
    if $gettok($2,1,46) isnum 0-255 && $gettok($2,2,46) isnum 0-255 && $gettok($2,3,46) isnum 0-255 {
      unset %as_sping_*
      set %as_sping_lostpackets 0
      set %as_sping_report 0
      set %as_sping_port 27960
      set %as_sping_chan $chan
      if $chr(58) isin $2 { set %as_sping_port $gettok($2,2,58) }
      set %as_sping_ip $gettok($2,1,58)
      if $3 isnum { set %as_sping_port $3 }
      if $4 == $null {
        sockudp -k ASSPing %as_sping_ip %as_sping_port getstatus
        set %as_sping_ping $ticks
        .timer_spingtimeout 1 1 as.spingtimeout
      }
    }
  }
}

ctcp *:version*:* { .ctcpreply $nick VERSION ArenaScout 1.2c by fuel }

on *:dns {
  if %as.dns {
    if $raddress {
      var %as.dnsdserver = $iaddress $+ : $+ $gettok(%as.dns,2,58)
      write $as.list %as.dnsdserver
      unset %as.dns
      as.d 7,49 %as.dnsdserver
      var %as.junk = $$input(%as.dnsdserver has been added to your favorites.,68)
      halt
    }
    else {
      unset %as.dns
      var %as.junk = $$input(Unable to resolve $naddress $+ .,68)
      halt
    }
  }
  if %as.dnshl {
    if $raddress {
      var %as.dnshl2 = $iaddress $+ : $+ $gettok(%as.dnshl,2,58)
      unset %as.dnshl
      as.scout %as.dnshl2
      halt
    }
    else {
      unset %as.dnshl2
      var %as.junk = $$input(Unable to resolve $naddress for query.,68)
      halt
    }
  }
}
