/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.VirtualDirectory;

public class LocalFilesDataSource
extends VirtualDirectory
implements DataSource {
    private final long objectId;
    private final String deviceId;
    private final String timezone;
    private static final Logger LOGGER = Logger.getLogger(LocalFilesDataSource.class.getName());

    public LocalFilesDataSource(SleuthkitCase db, long objId, long dataSourceObjectId, String deviceId, String name, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, String timezone, String md5Hash, TskData.FileKnown knownState, String parentPath) {
        super(db, objId, dataSourceObjectId, name, dirType, metaType, dirFlag, metaFlags, md5Hash, knownState, parentPath);
        this.objectId = objId;
        this.deviceId = deviceId;
        this.timezone = timezone;
    }

    @Deprecated
    public VirtualDirectory getRootDirectory() {
        return this;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getTimeZone() {
        return this.timezone;
    }

    @Override
    public void setDisplayName(String newName) throws TskCoreException {
        this.getSleuthkitCase().setFileName(newName, this.objectId);
    }

    @Override
    public long getContentSize(SleuthkitCase sleuthkitCase) throws TskCoreException {
        return LocalFilesDataSource.getContentSize(sleuthkitCase, this.objectId);
    }

    static long getContentSize(SleuthkitCase sleuthkitCase, long dataSourceObjId) throws TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        long contentSize = 0L;
        SleuthkitCase.CaseDbConnection connection = sleuthkitCase.getConnection();
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT SUM (size) FROM tsk_files WHERE tsk_files.data_source_obj_id = " + dataSourceObjId);
            if (resultSet.next()) {
                contentSize = resultSet.getLong("sum");
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("There was a problem while querying the database for size data for object ID %d.", dataSourceObjId), ex);
            }
            catch (Throwable throwable) {
                LocalFilesDataSource.closeResultSet(resultSet);
                LocalFilesDataSource.closeStatement(statement);
                connection.close();
                throw throwable;
            }
        }
        LocalFilesDataSource.closeResultSet(resultSet);
        LocalFilesDataSource.closeStatement(statement);
        connection.close();
        return contentSize;
    }

    @Override
    public void setAcquisitionDetails(String details) throws TskCoreException {
        this.getSleuthkitCase().setAcquisitionDetails(this, details);
    }

    @Override
    public String getAcquisitionDetails() throws TskCoreException {
        return this.getSleuthkitCase().getAcquisitionDetails(this);
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing ResultSet", ex);
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing Statement", ex);
            }
        }
    }
}

