/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskDataException;
import org.sleuthkit.datamodel.TskException;
import org.sleuthkit.datamodel.Volume;
import org.sleuthkit.datamodel.VolumeSystem;

public class Image
extends AbstractContent
implements DataSource {
    private final long type;
    private final long ssize;
    private long size;
    private final String[] paths;
    private volatile long imageHandle = 0L;
    private final String deviceId;
    private final String timezone;
    private String md5;
    private String sha1;
    private String sha256;
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private static final Logger LOGGER = Logger.getLogger(Image.class.getName());

    @Deprecated
    protected Image(SleuthkitCase db, long obj_id, long type, long ssize, String name, String[] paths, String timezone, String md5) throws TskCoreException {
        super(db, obj_id, name);
        this.deviceId = "";
        this.type = type;
        this.ssize = ssize;
        this.paths = paths;
        this.timezone = timezone;
        this.size = 0L;
        this.md5 = md5;
        this.sha1 = "";
        this.sha256 = "";
    }

    Image(SleuthkitCase db, long obj_id, long type, String deviceId, long ssize, String name, String[] paths, String timezone, String md5, String sha1, String sha256, long size) throws TskCoreException {
        super(db, obj_id, name);
        this.deviceId = deviceId;
        this.type = type;
        this.ssize = ssize;
        this.paths = paths;
        this.timezone = timezone;
        this.size = size;
        this.md5 = md5;
        this.sha1 = sha1;
        this.sha256 = sha256;
    }

    public synchronized long getImageHandle() throws TskCoreException {
        if (this.paths.length == 0) {
            throw new TskCoreException("Image has no associated paths");
        }
        if (this.imageHandle == 0L) {
            this.imageHandle = SleuthkitJNI.openImage(this.paths, (int)this.ssize, this.getSleuthkitCase());
        }
        return this.imageHandle;
    }

    @Override
    public Content getDataSource() {
        return this;
    }

    @Override
    public void close() {
    }

    public void finalize() throws Throwable {
        try {
            if (this.imageHandle != 0L) {
                this.imageHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.paths.length == 0) {
            return 0;
        }
        return SleuthkitJNI.readImg(this.getImageHandle(), buf, offset, len);
    }

    @Override
    public long getSize() {
        if (this.size == 0L) {
            try {
                if (this.paths.length > 0) {
                    this.size = SleuthkitJNI.findDeviceSize(this.paths[0]);
                }
            }
            catch (TskCoreException ex) {
                Logger.getLogger(Image.class.getName()).log(Level.SEVERE, "Could not find image size, image: " + this.getId(), ex);
            }
        }
        return this.size;
    }

    public TskData.TSK_IMG_TYPE_ENUM getType() {
        return TskData.TSK_IMG_TYPE_ENUM.valueOf(this.type);
    }

    public long getSsize() {
        return this.ssize;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        return "/img_" + this.getName();
    }

    public String[] getPaths() {
        return this.paths;
    }

    public List<VolumeSystem> getVolumeSystems() throws TskCoreException {
        List<Content> children = this.getChildren();
        ArrayList<VolumeSystem> vs = new ArrayList<VolumeSystem>();
        for (Content child : children) {
            if (!(child instanceof VolumeSystem)) continue;
            vs.add((VolumeSystem)child);
        }
        return vs;
    }

    public List<Volume> getVolumes() throws TskCoreException {
        List<Content> children = this.getChildren();
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (Content child : children) {
            if (!(child instanceof Volume)) continue;
            volumes.add((Volume)child);
        }
        return volumes;
    }

    public List<FileSystem> getFileSystems() throws TskCoreException {
        ArrayList<FileSystem> fs = new ArrayList<FileSystem>();
        fs.addAll(this.getSleuthkitCase().getFileSystems(this));
        return fs;
    }

    @Override
    public String getTimeZone() {
        return this.timezone;
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        return this.getSleuthkitCase().getImageChildren(this);
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        return this.getSleuthkitCase().getImageChildrenIds(this);
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "Image [\t\tpaths " + Arrays.toString(this.paths) + "\tsize " + this.size + "\tssize " + this.ssize + "\ttimezone " + this.timezone + "\ttype " + this.type + "]\t";
    }

    public Boolean imageFileExists() {
        if (this.paths.length > 0) {
            File imageFile = new File(this.paths[0]);
            return imageFile.exists();
        }
        return false;
    }

    public String verifyImageSize() {
        Logger logger1 = Logger.getLogger("verifyImageSizes");
        String errorString = "";
        try {
            int readBytes;
            List<VolumeSystem> volumeSystems = this.getVolumeSystems();
            for (VolumeSystem vs : volumeSystems) {
                List<Volume> volumes = vs.getVolumes();
                for (Volume v : volumes) {
                    byte[] buf = new byte[512];
                    long endOffset = (v.getStart() + v.getLength()) * 512L - 512L;
                    try {
                        readBytes = this.read(buf, endOffset, 512L);
                        if (readBytes >= 0) continue;
                        logger1.log(Level.WARNING, "Possible Incomplete Image: Error reading volume at offset {0}", endOffset);
                        errorString = MessageFormat.format(bundle.getString("Image.verifyImageSize.errStr1.text"), endOffset);
                    }
                    catch (TskCoreException ex) {
                        logger1.log(Level.WARNING, "Possible Incomplete Image: Error reading volume at offset {0}: {1}", new Object[]{endOffset, ex.getLocalizedMessage()});
                        errorString = MessageFormat.format(bundle.getString("Image.verifyImageSize.errStr2.text"), endOffset);
                    }
                }
            }
            List<FileSystem> fileSystems = this.getFileSystems();
            for (FileSystem fs : fileSystems) {
                long block_size = fs.getBlock_size();
                long endOffset = fs.getImageOffset() + fs.getSize() - block_size;
                try {
                    byte[] buf = new byte[(int)block_size];
                    readBytes = this.read(buf, endOffset, block_size);
                    if (readBytes >= 0) continue;
                    logger1.log(Level.WARNING, "Possible Incomplete Image: Error reading file system at offset {0}", endOffset);
                    errorString = MessageFormat.format(bundle.getString("Image.verifyImageSize.errStr3.text"), endOffset);
                }
                catch (TskCoreException ex) {
                    logger1.log(Level.WARNING, "Possible Incomplete Image: Error reading file system at offset {0}: {1}", new Object[]{endOffset, ex.getLocalizedMessage()});
                    errorString = MessageFormat.format(bundle.getString("Image.verifyImageSize.errStr4.text"), endOffset);
                }
            }
        }
        catch (TskException tskException) {
            // empty catch block
        }
        return errorString;
    }

    public String getMd5() throws TskCoreException {
        if (this.md5 == null || this.md5.isEmpty()) {
            this.md5 = this.getSleuthkitCase().getMd5ImageHash(this);
        }
        return this.md5;
    }

    public String getSha1() throws TskCoreException {
        if (this.sha1 == null || this.sha1.isEmpty()) {
            this.sha1 = this.getSleuthkitCase().getSha1ImageHash(this);
        }
        return this.sha1;
    }

    public String getSha256() throws TskCoreException {
        if (this.sha256 == null || this.sha256.isEmpty()) {
            this.sha256 = this.getSleuthkitCase().getSha256ImageHash(this);
        }
        return this.sha256;
    }

    public void setMD5(String md5) throws TskCoreException, TskDataException {
        if (!this.getMd5().isEmpty()) {
            throw new TskDataException("MD5 value has already been set");
        }
        this.getSleuthkitCase().setMd5ImageHash(this, md5);
        this.md5 = md5;
    }

    public void setSha1(String sha1) throws TskCoreException, TskDataException {
        if (!this.getSha1().isEmpty()) {
            throw new TskDataException("SHA1 value has already been set");
        }
        this.getSleuthkitCase().setSha1ImageHash(this, sha1);
        this.sha1 = sha1;
    }

    public void setSha256(String sha256) throws TskCoreException, TskDataException {
        if (!this.getSha256().isEmpty()) {
            throw new TskDataException("SHA256 value has already been set");
        }
        this.getSleuthkitCase().setSha256ImageHash(this, sha256);
        this.sha256 = sha256;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void setDisplayName(String newName) throws TskCoreException {
        this.getSleuthkitCase().setImageName(newName, this.getId());
    }

    @Override
    public long getContentSize(SleuthkitCase sleuthkitCase) throws TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        long contentSize = 0L;
        SleuthkitCase.CaseDbConnection connection = sleuthkitCase.getConnection();
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT SUM (size) FROM tsk_image_info WHERE tsk_image_info.obj_id = " + this.getId());
            if (resultSet.next()) {
                contentSize = resultSet.getLong("sum");
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("There was a problem while querying the database for size data for object ID %d.", this.getId()), ex);
            }
            catch (Throwable throwable) {
                Image.closeResultSet(resultSet);
                Image.closeStatement(statement);
                connection.close();
                throw throwable;
            }
        }
        Image.closeResultSet(resultSet);
        Image.closeStatement(statement);
        connection.close();
        return contentSize;
    }

    @Override
    public void setAcquisitionDetails(String details) throws TskCoreException {
        this.getSleuthkitCase().setAcquisitionDetails(this, details);
    }

    @Override
    public String getAcquisitionDetails() throws TskCoreException {
        return this.getSleuthkitCase().getAcquisitionDetails(this);
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing ResultSet", ex);
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing Statement", ex);
            }
        }
    }
}

