/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.TskFileRange;

public final class CarvingResult {
    private final Content parent;
    private final List<CarvedFile> carvedFiles;

    public CarvingResult(Content parent, List<CarvedFile> carvedFiles) {
        this.parent = parent;
        this.carvedFiles = new ArrayList<CarvedFile>(carvedFiles);
    }

    final Content getParent() {
        return this.parent;
    }

    final List<CarvedFile> getCarvedFiles() {
        return this.carvedFiles;
    }

    public static final class CarvedFile {
        private final String name;
        private final long sizeInBytes;
        private final List<TskFileRange> layoutInParent;

        public CarvedFile(String name, long sizeInBytes, List<TskFileRange> layoutInParent) {
            this.name = name;
            this.sizeInBytes = sizeInBytes;
            this.layoutInParent = layoutInParent;
        }

        final String getName() {
            return this.name;
        }

        final long getSizeInBytes() {
            return this.sizeInBytes;
        }

        final List<TskFileRange> getLayoutInParent() {
            return this.layoutInParent;
        }
    }
}

