/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.List;
import org.sleuthkit.datamodel.TskCoreException;

public final class Account {
    private final long account_id;
    private final Type accountType;
    private final String typeSpecificID;

    Account(long account_id, Type accountType, String typeSpecificId) throws TskCoreException {
        this.account_id = account_id;
        this.accountType = accountType;
        this.typeSpecificID = typeSpecificId;
    }

    public String getTypeSpecificID() {
        return this.typeSpecificID;
    }

    public Type getAccountType() {
        return this.accountType;
    }

    public long getAccountID() {
        return this.account_id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (int)(this.account_id ^ this.account_id >>> 32);
        hash = 43 * hash + (this.accountType != null ? this.accountType.hashCode() : 0);
        hash = 43 * hash + (this.typeSpecificID != null ? this.typeSpecificID.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        if (this.account_id != other.account_id) {
            return false;
        }
        if (this.typeSpecificID == null ? other.typeSpecificID != null : !this.typeSpecificID.equals(other.typeSpecificID)) {
            return false;
        }
        return this.accountType == other.accountType || this.accountType != null && this.accountType.equals(other.accountType);
    }

    public static final class Type {
        public static final Type CREDIT_CARD = new Type("CREDIT_CARD", "Credit Card");
        public static final Type DEVICE = new Type("DEVICE", "Device");
        public static final Type PHONE = new Type("PHONE", "Phone");
        public static final Type EMAIL = new Type("EMAIL", "Email");
        public static final Type FACEBOOK = new Type("FACEBOOK", "Facebook");
        public static final Type TWITTER = new Type("TWITTER", "Twitter");
        public static final Type INSTAGRAM = new Type("INSTAGRAM", "Instagram");
        public static final Type WHATSAPP = new Type("WHATSAPP", "WhatsApp");
        public static final Type MESSAGING_APP = new Type("MESSAGING_APP", "MessagingApp");
        public static final Type WEBSITE = new Type("WEBSITE", "Website");
        public static final List<Type> PREDEFINED_ACCOUNT_TYPES = Arrays.asList(CREDIT_CARD, DEVICE, PHONE, EMAIL, FACEBOOK, TWITTER, INSTAGRAM, WHATSAPP, MESSAGING_APP, WEBSITE);
        private final String typeName;
        private final String displayName;

        Type(String typeName, String displayName) {
            this.typeName = typeName;
            this.displayName = displayName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Type)) {
                return false;
            }
            Type thatType = (Type)that;
            return this.typeName.equals(thatType.getTypeName());
        }

        public int hashCode() {
            int hash = 11;
            hash = 83 * hash + (this.typeName != null ? this.typeName.hashCode() : 0);
            hash = 83 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return " displayName=" + this.displayName + ", typeName=" + this.typeName + ")";
        }
    }
}

