require 'swagger/blocks'

module ExploitApiDoc
  include Swagger::Blocks

  swagger_schema :Exploit do
    key :required, [:id, :name]
    property :id, type: :integer, format: :int32
    property :created_at, type: :string, format: :date_time
    property :updated_at, type: :string, format: :date_time
    property :workspace_id, type: :integer, format: :int32
    property :name, type: :string
    property :critical, type: :boolean
    property :seen, type: :string
    property :username, type: :string
    property :info do
      key :type, :object
      property :revision, type: :string
    end
  end

  swagger_path '/api/v1/exploits' do
    # Swagger documentation for /api/v1/exploits POST
    operation :post do
      key :description, 'Create an exploit entry.'
      key :tags, [ 'exploit' ]

      parameter do
        key :in, :body
        key :name, :body
        key :description, 'The attributes to assign to the exploit.'
        key :required, true
        schema do
          property :timestamp, type: :string, format: :date_time
          property :module, type: :string
          property :workspace, required: true, type: :string
          property :port, type: :integer, format: :int32
          property :proto, type: :string, enum: ['tcp','udp']
          property :service, '$ref' => :Service
          property :host, '$ref' => :Host
          property :vuln, '$ref' => :Vuln

          property :refs do
            key :required, true
            key :type, :array
            items do
              key :type, :string
            end
          end

          property :exploit_report_attempt do
            key :type, :string
            key :enum, ['attempt', 'failure', 'success']
          end
        end
      end

      response 200 do
        key :description, RootApiDoc::DEFAULT_RESPONSE_200
        schema do
          property :data do
            key :'$ref', :Exploit
          end
        end
      end

      response 401 do
        key :description, RootApiDoc::DEFAULT_RESPONSE_401
        schema do
          key :'$ref', :AuthErrorModel
        end
      end

      response 500 do
        key :description, RootApiDoc::DEFAULT_RESPONSE_500
        schema do
          key :'$ref', :ErrorModel
        end
      end
    end
  end
end
