# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length.rb'
require 'aws-sdk-core/plugins/credentials_configuration.rb'
require 'aws-sdk-core/plugins/logging.rb'
require 'aws-sdk-core/plugins/param_converter.rb'
require 'aws-sdk-core/plugins/param_validator.rb'
require 'aws-sdk-core/plugins/user_agent.rb'
require 'aws-sdk-core/plugins/helpful_socket_errors.rb'
require 'aws-sdk-core/plugins/retry_errors.rb'
require 'aws-sdk-core/plugins/global_configuration.rb'
require 'aws-sdk-core/plugins/regional_endpoint.rb'
require 'aws-sdk-core/plugins/endpoint_discovery.rb'
require 'aws-sdk-core/plugins/endpoint_pattern.rb'
require 'aws-sdk-core/plugins/response_paging.rb'
require 'aws-sdk-core/plugins/stub_responses.rb'
require 'aws-sdk-core/plugins/idempotency_token.rb'
require 'aws-sdk-core/plugins/jsonvalue_converter.rb'
require 'aws-sdk-core/plugins/client_metrics_plugin.rb'
require 'aws-sdk-core/plugins/client_metrics_send_plugin.rb'
require 'aws-sdk-core/plugins/transfer_encoding.rb'
require 'aws-sdk-core/plugins/http_checksum.rb'
require 'aws-sdk-core/plugins/signature_v4.rb'
require 'aws-sdk-core/plugins/protocols/ec2.rb'
require 'aws-sdk-ec2/plugins/copy_encrypted_snapshot.rb'
require 'aws-sdk-ec2/plugins/region_validation.rb'

Aws::Plugins::GlobalConfiguration.add_identifier(:ec2)

module Aws::EC2
  # An API client for EC2.  To construct a client, you need to configure a `:region` and `:credentials`.
  #
  #     client = Aws::EC2::Client.new(
  #       region: region_name,
  #       credentials: credentials,
  #       # ...
  #     )
  #
  # For details on configuring region and credentials see
  # the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
  #
  # See {#initialize} for a full list of supported configuration options.
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :ec2

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::HttpChecksum)
    add_plugin(Aws::Plugins::SignatureV4)
    add_plugin(Aws::Plugins::Protocols::EC2)
    add_plugin(Aws::EC2::Plugins::CopyEncryptedSnapshot)
    add_plugin(Aws::EC2::Plugins::RegionValidation)

    # @overload initialize(options)
    #   @param [Hash] options
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::SharedCredentials` - Used for loading static credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     * `Aws::AssumeRoleWebIdentityCredentials` - Used when you need to
    #       assume a role after providing credentials via the web.
    #
    #     * `Aws::SSOCredentials` - Used for loading credentials from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     * `Aws::ProcessCredentials` - Used for loading credentials from a
    #       process that outputs to stdout.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::ECSCredentials` - Used for loading credentials from
    #       instances running in ECS.
    #
    #     * `Aws::CognitoIdentityCredentials` - Used for loading credentials
    #       from the Cognito Identity service.
    #
    #     When `:credentials` are not configured directly, the following
    #     locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #     * The `:access_key_id`, `:secret_access_key`, and `:session_token` options.
    #     * ENV['AWS_ACCESS_KEY_ID'], ENV['AWS_SECRET_ACCESS_KEY']
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #     * EC2/ECS IMDS instance profile - When used by default, the timeouts
    #       are very aggressive. Construct and pass an instance of
    #       `Aws::InstanceProfileCredentails` or `Aws::ECSCredentials` to
    #       enable retries and extended timeouts.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is searched for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :adaptive_retry_wait_to_fill (true)
    #     Used only in `adaptive` retry mode.  When true, the request will sleep
    #     until there is sufficent client side capacity to retry the request.
    #     When false, the request will raise a `RetryCapacityNotAvailableError` and will
    #     not retry instead of sleeping.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :correct_clock_skew (true)
    #     Used only in `standard` and adaptive retry modes. Specifies whether to apply
    #     a clock skew correction and retry requests with skewed client clocks.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     Set to true to disable SDK automatically adding host prefix
    #     to default service endpoint when available.
    #
    #   @option options [String] :endpoint
    #     The client endpoint is normally constructed from the `:region`
    #     option. You should only configure an `:endpoint` when connecting
    #     to test or custom endpoints. This should be a valid HTTP(S) URI.
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [Integer] :max_attempts (3)
    #     An integer representing the maximum number attempts that will be made for
    #     a single request, including the initial attempt.  For example,
    #     setting this value to 5 will result in a request being retried up to
    #     4 times. Used in `standard` and `adaptive` retry modes.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file
    #     at HOME/.aws/credentials.  When not specified, 'default' is used.
    #
    #   @option options [Proc] :retry_backoff
    #     A proc or lambda used for backoff. Defaults to 2**retries * retry_base_delay.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function. This option
    #     is only used in the `legacy` retry mode.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function.
    #     Some predefined functions can be referenced by name - :none, :equal, :full,
    #     otherwise a Proc that takes and returns a number. This option is only used
    #     in the `legacy` retry mode.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors, auth errors,
    #     endpoint discovery, and errors from expired credentials.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit)
    #     used by the default backoff function. This option is only used in the
    #     `legacy` retry mode.
    #
    #   @option options [String] :retry_mode ("legacy")
    #     Specifies which retry algorithm to use. Values are:
    #
    #     * `legacy` - The pre-existing retry behavior.  This is default value if
    #       no retry mode is provided.
    #
    #     * `standard` - A standardized set of retry rules across the AWS SDKs.
    #       This includes support for retry quotas, which limit the number of
    #       unsuccessful retries a client can make.
    #
    #     * `adaptive` - An experimental retry mode that includes all the
    #       functionality of `standard` mode along with automatic client side
    #       throttling.  This is a provisional mode that may change behavior
    #       in the future.
    #
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [URI::HTTP,String] :http_proxy A proxy to send
    #     requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_open_timeout (15) The number of
    #     seconds to wait when opening a HTTP session before raising a
    #     `Timeout::Error`.
    #
    #   @option options [Integer] :http_read_timeout (60) The default
    #     number of seconds to wait for response data.  This value can
    #     safely be set per-request on the session.
    #
    #   @option options [Float] :http_idle_timeout (5) The number of
    #     seconds a connection is allowed to sit idle before it is
    #     considered stale.  Stale connections are closed and removed
    #     from the pool before making a request.
    #
    #   @option options [Float] :http_continue_timeout (1) The number of
    #     seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has
    #     "Expect" header set to "100-continue".  Defaults to `nil` which
    #     disables this behaviour.  This value can safely be set per
    #     request on the session.
    #
    #   @option options [Boolean] :http_wire_trace (false) When `true`,
    #     HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Boolean] :ssl_verify_peer (true) When `true`,
    #     SSL peer certificates are verified when establishing a
    #     connection.
    #
    #   @option options [String] :ssl_ca_bundle Full path to the SSL
    #     certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass
    #     `:ssl_ca_bundle` or `:ssl_ca_directory` the the system default
    #     will be used if available.
    #
    #   @option options [String] :ssl_ca_directory Full path of the
    #     directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the
    #     system default will be used if available.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # Accepts the Convertible Reserved Instance exchange quote described in
    # the GetReservedInstancesExchangeQuote call.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :reserved_instance_ids
    #   The IDs of the Convertible Reserved Instances to exchange for another
    #   Convertible Reserved Instance of the same or higher value.
    #
    # @option params [Array<Types::TargetConfigurationRequest>] :target_configurations
    #   The configuration of the target Convertible Reserved Instance to
    #   exchange for your current Convertible Reserved Instances.
    #
    # @return [Types::AcceptReservedInstancesExchangeQuoteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptReservedInstancesExchangeQuoteResult#exchange_id #exchange_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_reserved_instances_exchange_quote({
    #     dry_run: false,
    #     reserved_instance_ids: ["ReservationId"], # required
    #     target_configurations: [
    #       {
    #         instance_count: 1,
    #         offering_id: "ReservedInstancesOfferingId", # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.exchange_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote AWS API Documentation
    #
    # @overload accept_reserved_instances_exchange_quote(params = {})
    # @param [Hash] params ({})
    def accept_reserved_instances_exchange_quote(params = {}, options = {})
      req = build_request(:accept_reserved_instances_exchange_quote, params)
      req.send_request(options)
    end

    # Accepts a request to associate subnets with a transit gateway
    # multicast domain.
    #
    # @option params [String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #
    # @option params [Array<String>] :subnet_ids
    #   The IDs of the subnets to associate with the transit gateway multicast
    #   domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayMulticastDomainAssociationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayMulticastDomainAssociationsResult#associations #associations} => Types::TransitGatewayMulticastDomainAssociations
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_multicast_domain_associations({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     subnet_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.associations.transit_gateway_multicast_domain_id #=> String
    #   resp.associations.transit_gateway_attachment_id #=> String
    #   resp.associations.resource_id #=> String
    #   resp.associations.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.associations.resource_owner_id #=> String
    #   resp.associations.subnets #=> Array
    #   resp.associations.subnets[0].subnet_id #=> String
    #   resp.associations.subnets[0].state #=> String, one of "pendingAcceptance", "associating", "associated", "disassociating", "disassociated", "rejected", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations AWS API Documentation
    #
    # @overload accept_transit_gateway_multicast_domain_associations(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_multicast_domain_associations(params = {}, options = {})
      req = build_request(:accept_transit_gateway_multicast_domain_associations, params)
      req.send_request(options)
    end

    # Accepts a transit gateway peering attachment request. The peering
    # attachment must be in the `pendingAcceptance` state.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayPeeringAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayPeeringAttachmentResult#transit_gateway_peering_attachment #transit_gateway_peering_attachment} => Types::TransitGatewayPeeringAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_peering_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_peering_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.status.code #=> String
    #   resp.transit_gateway_peering_attachment.status.message #=> String
    #   resp.transit_gateway_peering_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_peering_attachment.creation_time #=> Time
    #   resp.transit_gateway_peering_attachment.tags #=> Array
    #   resp.transit_gateway_peering_attachment.tags[0].key #=> String
    #   resp.transit_gateway_peering_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment AWS API Documentation
    #
    # @overload accept_transit_gateway_peering_attachment(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_peering_attachment(params = {}, options = {})
      req = build_request(:accept_transit_gateway_peering_attachment, params)
      req.send_request(options)
    end

    # Accepts a request to attach a VPC to a transit gateway.
    #
    # The VPC attachment must be in the `pendingAcceptance` state. Use
    # DescribeTransitGatewayVpcAttachments to view your pending VPC
    # attachment requests. Use RejectTransitGatewayVpcAttachment to reject a
    # VPC attachment request.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_vpc_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.appliance_mode_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload accept_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:accept_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Accepts one or more interface VPC endpoint connection requests to your
    # VPC endpoint service.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :service_id
    #   The ID of the VPC endpoint service.
    #
    # @option params [required, Array<String>] :vpc_endpoint_ids
    #   The IDs of one or more interface VPC endpoints.
    #
    # @return [Types::AcceptVpcEndpointConnectionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcEndpointConnectionsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_endpoint_connections({
    #     dry_run: false,
    #     service_id: "VpcEndpointServiceId", # required
    #     vpc_endpoint_ids: ["VpcEndpointId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections AWS API Documentation
    #
    # @overload accept_vpc_endpoint_connections(params = {})
    # @param [Hash] params ({})
    def accept_vpc_endpoint_connections(params = {}, options = {})
      req = build_request(:accept_vpc_endpoint_connections, params)
      req.send_request(options)
    end

    # Accept a VPC peering connection request. To accept a request, the VPC
    # peering connection must be in the `pending-acceptance` state, and you
    # must be the owner of the peer VPC. Use DescribeVpcPeeringConnections
    # to view your outstanding VPC peering connection requests.
    #
    # For an inter-Region VPC peering connection request, you must accept
    # the VPC peering connection in the Region of the accepter VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :vpc_peering_connection_id
    #   The ID of the VPC peering connection. You must specify this parameter
    #   in the request.
    #
    # @return [Types::AcceptVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcPeeringConnectionResult#vpc_peering_connection #vpc_peering_connection} => Types::VpcPeeringConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_peering_connection({
    #     dry_run: false,
    #     vpc_peering_connection_id: "VpcPeeringConnectionId",
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.region #=> String
    #   resp.vpc_peering_connection.expiration_time #=> Time
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.region #=> String
    #   resp.vpc_peering_connection.status.code #=> String, one of "initiating-request", "pending-acceptance", "active", "deleted", "rejected", "failed", "expired", "provisioning", "deleting"
    #   resp.vpc_peering_connection.status.message #=> String
    #   resp.vpc_peering_connection.tags #=> Array
    #   resp.vpc_peering_connection.tags[0].key #=> String
    #   resp.vpc_peering_connection.tags[0].value #=> String
    #   resp.vpc_peering_connection.vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection AWS API Documentation
    #
    # @overload accept_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def accept_vpc_peering_connection(params = {}, options = {})
      req = build_request(:accept_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Advertises an IPv4 or IPv6 address range that is provisioned for use
    # with your AWS resources through bring your own IP addresses (BYOIP).
    #
    # You can perform this operation at most once every 10 seconds, even if
    # you specify different address ranges each time.
    #
    # We recommend that you stop advertising the BYOIP CIDR from other
    # locations when you advertise it from AWS. To minimize down time, you
    # can configure your AWS resources to use an address from a BYOIP CIDR
    # before it is advertised, and then simultaneously stop advertising it
    # from the current location and start advertising it through AWS.
    #
    # It can take a few minutes before traffic to the specified addresses
    # starts routing to AWS because of BGP propagation delays.
    #
    # To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
    #
    # @option params [required, String] :cidr
    #   The address range, in CIDR notation. This must be the exact range that
    #   you provisioned. You can't advertise only a portion of the
    #   provisioned range.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AdvertiseByoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AdvertiseByoipCidrResult#byoip_cidr #byoip_cidr} => Types::ByoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.advertise_byoip_cidr({
    #     cidr: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidr.cidr #=> String
    #   resp.byoip_cidr.description #=> String
    #   resp.byoip_cidr.status_message #=> String
    #   resp.byoip_cidr.state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned", "provisioned-not-publicly-advertisable"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr AWS API Documentation
    #
    # @overload advertise_byoip_cidr(params = {})
    # @param [Hash] params ({})
    def advertise_byoip_cidr(params = {}, options = {})
      req = build_request(:advertise_byoip_cidr, params)
      req.send_request(options)
    end

    # Allocates an Elastic IP address to your AWS account. After you
    # allocate the Elastic IP address you can associate it with an instance
    # or network interface. After you release an Elastic IP address, it is
    # released to the IP address pool and can be allocated to a different
    # AWS account.
    #
    # You can allocate an Elastic IP address from an address pool owned by
    # AWS or from an address pool created from a public IPv4 address range
    # that you have brought to AWS for use with your AWS resources using
    # bring your own IP addresses (BYOIP). For more information, see [Bring
    # Your Own IP Addresses (BYOIP)][1] in the *Amazon Elastic Compute Cloud
    # User Guide*.
    #
    # \[EC2-VPC\] If you release an Elastic IP address, you might be able to
    # recover it. You cannot recover an Elastic IP address that you released
    # after it is allocated to another AWS account. You cannot recover an
    # Elastic IP address for EC2-Classic. To attempt to recover an Elastic
    # IP address that you released, specify it in this operation.
    #
    # An Elastic IP address is for use either in the EC2-Classic platform or
    # in a VPC. By default, you can allocate 5 Elastic IP addresses for
    # EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
    # Region.
    #
    # For more information, see [Elastic IP Addresses][2] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    # You can allocate a carrier IP address which is a public IP address
    # from a telecommunication carrier, to a network interface which resides
    # in a subnet in a Wavelength Zone (for example an EC2 instance).
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [String] :domain
    #   Indicates whether the Elastic IP address is for use with instances in
    #   a VPC or instances in EC2-Classic.
    #
    #   Default: If the Region supports EC2-Classic, the default is
    #   `standard`. Otherwise, the default is `vpc`.
    #
    # @option params [String] :address
    #   \[EC2-VPC\] The Elastic IP address to recover or an IPv4 address from
    #   an address pool.
    #
    # @option params [String] :public_ipv_4_pool
    #   The ID of an address pool that you own. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. To specify a
    #   specific address from the address pool, use the `Address` parameter
    #   instead.
    #
    # @option params [String] :network_border_group
    #   A unique set of Availability Zones, Local Zones, or Wavelength Zones
    #   from which AWS advertises IP addresses. Use this parameter to limit
    #   the IP address to this location. IP addresses cannot move between
    #   network border groups.
    #
    #   Use [DescribeAvailabilityZones][1] to view the network border groups.
    #
    #   <note markdown="1"> You cannot use a network border group with EC2 Classic. If you attempt
    #   this operation on EC2 classic, you will receive an
    #   `InvalidParameterCombination` error. For more information, see [Error
    #   Codes][2].
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html
    #
    # @option params [String] :customer_owned_ipv_4_pool
    #   The ID of a customer-owned address pool. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. Alternatively,
    #   specify a specific address from the address pool.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Elastic IP address.
    #
    # @return [Types::AllocateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateAddressResult#public_ip #public_ip} => String
    #   * {Types::AllocateAddressResult#allocation_id #allocation_id} => String
    #   * {Types::AllocateAddressResult#public_ipv_4_pool #public_ipv_4_pool} => String
    #   * {Types::AllocateAddressResult#network_border_group #network_border_group} => String
    #   * {Types::AllocateAddressResult#domain #domain} => String
    #   * {Types::AllocateAddressResult#customer_owned_ip #customer_owned_ip} => String
    #   * {Types::AllocateAddressResult#customer_owned_ipv_4_pool #customer_owned_ipv_4_pool} => String
    #   * {Types::AllocateAddressResult#carrier_ip #carrier_ip} => String
    #
    #
    # @example Example: To allocate an Elastic IP address for EC2-VPC
    #
    #   # This example allocates an Elastic IP address to use with an instance in a VPC.
    #
    #   resp = client.allocate_address({
    #     domain: "vpc", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     allocation_id: "eipalloc-64d5890a", 
    #     domain: "vpc", 
    #     public_ip: "203.0.113.0", 
    #   }
    #
    # @example Example: To allocate an Elastic IP address for EC2-Classic
    #
    #   # This example allocates an Elastic IP address to use with an instance in EC2-Classic.
    #
    #   resp = client.allocate_address({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     domain: "standard", 
    #     public_ip: "198.51.100.0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_address({
    #     domain: "vpc", # accepts vpc, standard
    #     address: "PublicIpAddress",
    #     public_ipv_4_pool: "Ipv4PoolEc2Id",
    #     network_border_group: "String",
    #     customer_owned_ipv_4_pool: "String",
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.public_ip #=> String
    #   resp.allocation_id #=> String
    #   resp.public_ipv_4_pool #=> String
    #   resp.network_border_group #=> String
    #   resp.domain #=> String, one of "vpc", "standard"
    #   resp.customer_owned_ip #=> String
    #   resp.customer_owned_ipv_4_pool #=> String
    #   resp.carrier_ip #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress AWS API Documentation
    #
    # @overload allocate_address(params = {})
    # @param [Hash] params ({})
    def allocate_address(params = {}, options = {})
      req = build_request(:allocate_address, params)
      req.send_request(options)
    end

    # Allocates a Dedicated Host to your account. At a minimum, specify the
    # supported instance type or instance family, the Availability Zone in
    # which to allocate the host, and the number of hosts to allocate.
    #
    # @option params [String] :auto_placement
    #   Indicates whether the host accepts any untargeted instance launches
    #   that match its instance type configuration, or if it only accepts Host
    #   tenancy instance launches that specify its unique host ID. For more
    #   information, see [ Understanding auto-placement and affinity][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #   Default: `on`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to allocate the Dedicated Host.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :instance_type
    #   Specifies the instance type to be supported by the Dedicated Hosts. If
    #   you specify an instance type, the Dedicated Hosts support instances of
    #   the specified instance type only.
    #
    #   If you want the Dedicated Hosts to support multiple instance types in
    #   a specific instance family, omit this parameter and specify
    #   **InstanceFamily** instead. You cannot specify **InstanceType** and
    #   **InstanceFamily** in the same request.
    #
    # @option params [String] :instance_family
    #   Specifies the instance family to be supported by the Dedicated Hosts.
    #   If you specify an instance family, the Dedicated Hosts support
    #   multiple instance types within that instance family.
    #
    #   If you want the Dedicated Hosts to support a specific instance type
    #   only, omit this parameter and specify **InstanceType** instead. You
    #   cannot specify **InstanceFamily** and **InstanceType** in the same
    #   request.
    #
    # @option params [required, Integer] :quantity
    #   The number of Dedicated Hosts to allocate to your account with these
    #   parameters.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Dedicated Host during creation.
    #
    # @option params [String] :host_recovery
    #   Indicates whether to enable or disable host recovery for the Dedicated
    #   Host. Host recovery is disabled by default. For more information, see
    #   [ Host recovery][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html
    #
    # @return [Types::AllocateHostsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateHostsResult#host_ids #host_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_hosts({
    #     auto_placement: "on", # accepts on, off
    #     availability_zone: "String", # required
    #     client_token: "String",
    #     instance_type: "String",
    #     instance_family: "String",
    #     quantity: 1, # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     host_recovery: "on", # accepts on, off
    #   })
    #
    # @example Response structure
    #
    #   resp.host_ids #=> Array
    #   resp.host_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts AWS API Documentation
    #
    # @overload allocate_hosts(params = {})
    # @param [Hash] params ({})
    def allocate_hosts(params = {}, options = {})
      req = build_request(:allocate_hosts, params)
      req.send_request(options)
    end

    # Applies a security group to the association between the target network
    # and the Client VPN endpoint. This action replaces the existing
    # security groups with the specified security groups.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC in which the associated target network is located.
    #
    # @option params [required, Array<String>] :security_group_ids
    #   The IDs of the security groups to apply to the associated target
    #   network. Up to 5 security groups can be applied to an associated
    #   target network.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ApplySecurityGroupsToClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ApplySecurityGroupsToClientVpnTargetNetworkResult#security_group_ids #security_group_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.apply_security_groups_to_client_vpn_target_network({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     vpc_id: "VpcId", # required
    #     security_group_ids: ["SecurityGroupId"], # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.security_group_ids #=> Array
    #   resp.security_group_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork AWS API Documentation
    #
    # @overload apply_security_groups_to_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def apply_security_groups_to_client_vpn_target_network(params = {}, options = {})
      req = build_request(:apply_security_groups_to_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Assigns one or more IPv6 addresses to the specified network interface.
    # You can specify one or more specific IPv6 addresses, or you can
    # specify the number of IPv6 addresses to be automatically assigned from
    # within the subnet's IPv6 CIDR block range. You can assign as many
    # IPv6 addresses to a network interface as you can assign private IPv4
    # addresses, and the limit varies per instance type. For information,
    # see [IP Addresses Per Network Interface Per Instance Type][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    # You must specify either the IPv6 addresses or the IPv6 address count
    # in the request.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of additional IPv6 addresses to assign to the network
    #   interface. The specified number of IPv6 addresses are assigned in
    #   addition to the existing IPv6 addresses that are already assigned to
    #   the network interface. Amazon EC2 automatically selects the IPv6
    #   addresses from the subnet range. You can't use this option if
    #   specifying specific IPv6 addresses.
    #
    # @option params [Array<String>] :ipv_6_addresses
    #   One or more specific IPv6 addresses to be assigned to the network
    #   interface. You can't use this option if you're specifying a number
    #   of IPv6 addresses.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Types::AssignIpv6AddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignIpv6AddressesResult#assigned_ipv_6_addresses #assigned_ipv_6_addresses} => Array&lt;String&gt;
    #   * {Types::AssignIpv6AddressesResult#network_interface_id #network_interface_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_ipv_6_addresses({
    #     ipv_6_address_count: 1,
    #     ipv_6_addresses: ["String"],
    #     network_interface_id: "NetworkInterfaceId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.assigned_ipv_6_addresses #=> Array
    #   resp.assigned_ipv_6_addresses[0] #=> String
    #   resp.network_interface_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses AWS API Documentation
    #
    # @overload assign_ipv_6_addresses(params = {})
    # @param [Hash] params ({})
    def assign_ipv_6_addresses(params = {}, options = {})
      req = build_request(:assign_ipv_6_addresses, params)
      req.send_request(options)
    end

    # Assigns one or more secondary private IP addresses to the specified
    # network interface.
    #
    # You can specify one or more specific secondary IP addresses, or you
    # can specify the number of secondary IP addresses to be automatically
    # assigned within the subnet's CIDR block range. The number of
    # secondary IP addresses that you can assign to an instance varies by
    # instance type. For information about instance types, see [Instance
    # Types][1] in the *Amazon Elastic Compute Cloud User Guide*. For more
    # information about Elastic IP addresses, see [Elastic IP Addresses][2]
    # in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # When you move a secondary private IP address to another network
    # interface, any Elastic IP address that is associated with the IP
    # address is also moved.
    #
    # Remapping an IP address is an asynchronous operation. When you move an
    # IP address from one network interface to another, check
    # `network/interfaces/macs/mac/local-ipv4s` in the instance metadata to
    # confirm that the remapping is complete.
    #
    # You must specify either the IP addresses or the IP address count in
    # the request.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [Boolean] :allow_reassignment
    #   Indicates whether to allow an IP address that is already assigned to
    #   another network interface or instance to be reassigned to the
    #   specified network interface.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [Array<String>] :private_ip_addresses
    #   One or more IP addresses to be assigned as a secondary private IP
    #   address to the network interface. You can't specify this parameter
    #   when also specifying a number of secondary IP addresses.
    #
    #   If you don't specify an IP address, Amazon EC2 automatically selects
    #   an IP address within the subnet range.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary IP addresses to assign to the network
    #   interface. You can't specify this parameter when also specifying
    #   private IP addresses.
    #
    # @return [Types::AssignPrivateIpAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignPrivateIpAddressesResult#network_interface_id #network_interface_id} => String
    #   * {Types::AssignPrivateIpAddressesResult#assigned_private_ip_addresses #assigned_private_ip_addresses} => Array&lt;Types::AssignedPrivateIpAddress&gt;
    #
    #
    # @example Example: To assign a specific secondary private IP address to an interface
    #
    #   # This example assigns the specified secondary private IP address to the specified network interface.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     private_ip_addresses: [
    #       "10.0.0.82", 
    #     ], 
    #   })
    #
    # @example Example: To assign secondary private IP addresses that Amazon EC2 selects to an interface
    #
    #   # This example assigns two secondary private IP addresses to the specified network interface. Amazon EC2 automatically
    #   # assigns these IP addresses from the available IP addresses in the CIDR block range of the subnet the network interface
    #   # is associated with.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     secondary_private_ip_address_count: 2, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_private_ip_addresses({
    #     allow_reassignment: false,
    #     network_interface_id: "NetworkInterfaceId", # required
    #     private_ip_addresses: ["String"],
    #     secondary_private_ip_address_count: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface_id #=> String
    #   resp.assigned_private_ip_addresses #=> Array
    #   resp.assigned_private_ip_addresses[0].private_ip_address #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses AWS API Documentation
    #
    # @overload assign_private_ip_addresses(params = {})
    # @param [Hash] params ({})
    def assign_private_ip_addresses(params = {}, options = {})
      req = build_request(:assign_private_ip_addresses, params)
      req.send_request(options)
    end

    # Associates an Elastic IP address, or carrier IP address (for instances
    # that are in subnets in Wavelength Zones) with an instance or a network
    # interface. Before you can use an Elastic IP address, you must allocate
    # it to your account.
    #
    # An Elastic IP address is for use in either the EC2-Classic platform or
    # in a VPC. For more information, see [Elastic IP Addresses][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    # \[EC2-Classic, VPC in an EC2-VPC-only account\] If the Elastic IP
    # address is already associated with a different instance, it is
    # disassociated from that instance and associated with the specified
    # instance. If you associate an Elastic IP address with an instance that
    # has an existing Elastic IP address, the existing address is
    # disassociated from the instance, but remains allocated to your
    # account.
    #
    # \[VPC in an EC2-Classic account\] If you don't specify a private IP
    # address, the Elastic IP address is associated with the primary IP
    # address. If the Elastic IP address is already associated with a
    # different instance or a network interface, you get an error unless you
    # allow reassociation. You cannot associate an Elastic IP address with
    # an instance or network interface that has an existing Elastic IP
    # address.
    #
    # \[Subnets in Wavelength Zones\] You can associate an IP address from
    # the telecommunication carrier to the instance or network interface.
    #
    # You cannot associate an Elastic IP address with an interface in a
    # different network border group.
    #
    # This is an idempotent operation. If you perform the operation more
    # than once, Amazon EC2 doesn't return an error, and you may be charged
    # for each time the Elastic IP address is remapped to the same instance.
    # For more information, see the *Elastic IP Addresses* section of
    # [Amazon EC2 Pricing][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    # [2]: http://aws.amazon.com/ec2/pricing/
    #
    # @option params [String] :allocation_id
    #   \[EC2-VPC\] The allocation ID. This is required for EC2-VPC.
    #
    # @option params [String] :instance_id
    #   The ID of the instance. The instance must have exactly one attached
    #   network interface. For EC2-VPC, you can specify either the instance ID
    #   or the network interface ID, but not both. For EC2-Classic, you must
    #   specify an instance ID and the instance must be in the running state.
    #
    # @option params [String] :public_ip
    #   \[EC2-Classic\] The Elastic IP address to associate with the instance.
    #   This is required for EC2-Classic.
    #
    # @option params [Boolean] :allow_reassociation
    #   \[EC2-VPC\] For a VPC in an EC2-Classic account, specify true to allow
    #   an Elastic IP address that is already associated with an instance or
    #   network interface to be reassociated with the specified instance or
    #   network interface. Otherwise, the operation fails. In a VPC in an
    #   EC2-VPC-only account, reassociation is automatic, therefore you can
    #   specify false to ensure the operation fails if the Elastic IP address
    #   is already associated with another resource.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :network_interface_id
    #   \[EC2-VPC\] The ID of the network interface. If the instance has more
    #   than one network interface, you must specify a network interface ID.
    #
    #   For EC2-VPC, you can specify either the instance ID or the network
    #   interface ID, but not both.
    #
    # @option params [String] :private_ip_address
    #   \[EC2-VPC\] The primary or secondary private IP address to associate
    #   with the Elastic IP address. If no private IP address is specified,
    #   the Elastic IP address is associated with the primary private IP
    #   address.
    #
    # @return [Types::AssociateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateAddressResult#association_id #association_id} => String
    #
    #
    # @example Example: To associate an Elastic IP address in EC2-VPC
    #
    #   # This example associates the specified Elastic IP address with the specified instance in a VPC.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     instance_id: "i-0b263919b6498b123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Example: To associate an Elastic IP address with a network interface
    #
    #   # This example associates the specified Elastic IP address with the specified network interface.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     network_interface_id: "eni-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Example: To associate an Elastic IP address in EC2-Classic
    #
    #   # This example associates an Elastic IP address with an instance in EC2-Classic.
    #
    #   resp = client.associate_address({
    #     instance_id: "i-07ffe74c7330ebf53", 
    #     public_ip: "198.51.100.0", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_address({
    #     allocation_id: "AllocationId",
    #     instance_id: "InstanceId",
    #     public_ip: "String",
    #     allow_reassociation: false,
    #     dry_run: false,
    #     network_interface_id: "NetworkInterfaceId",
    #     private_ip_address: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress AWS API Documentation
    #
    # @overload associate_address(params = {})
    # @param [Hash] params ({})
    def associate_address(params = {}, options = {})
      req = build_request(:associate_address, params)
      req.send_request(options)
    end

    # Associates a target network with a Client VPN endpoint. A target
    # network is a subnet in a VPC. You can associate multiple subnets from
    # the same VPC with a Client VPN endpoint. You can associate only one
    # subnet in each Availability Zone. We recommend that you associate at
    # least two subnets to provide Availability Zone redundancy.
    #
    # If you specified a VPC when you created the Client VPN endpoint or if
    # you have previous subnet associations, the specified subnet must be in
    # the same VPC. To specify a subnet that's in a different VPC, you must
    # first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and
    # change the VPC that's associated with it.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the Client VPN endpoint.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateClientVpnTargetNetworkResult#association_id #association_id} => String
    #   * {Types::AssociateClientVpnTargetNetworkResult#status #status} => Types::AssociationStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_client_vpn_target_network({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     subnet_id: "SubnetId", # required
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #   resp.status.code #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork AWS API Documentation
    #
    # @overload associate_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def associate_client_vpn_target_network(params = {}, options = {})
      req = build_request(:associate_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Associates a set of DHCP options (that you've previously created)
    # with the specified VPC, or associates no DHCP options with the VPC.
    #
    # After you associate the options with the VPC, any existing instances
    # and all new instances that you launch in that VPC use the options. You
    # don't need to restart or relaunch the instances. They automatically
    # pick up the changes within a few hours, depending on how frequently
    # the instance renews its DHCP lease. You can explicitly renew the lease
    # using the operating system on the instance.
    #
    # For more information, see [DHCP Options Sets][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [required, String] :dhcp_options_id
    #   The ID of the DHCP options set, or `default` to associate no DHCP
    #   options with the VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To associate a DHCP options set with a VPC
    #
    #   # This example associates the specified DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "dopt-d9070ebb", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Example: To associate the default DHCP options set with a VPC
    #
    #   # This example associates the default DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "default", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "DefaultingDhcpOptionsId", # required
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions AWS API Documentation
    #
    # @overload associate_dhcp_options(params = {})
    # @param [Hash] params ({})
    def associate_dhcp_options(params = {}, options = {})
      req = build_request(:associate_dhcp_options, params)
      req.send_request(options)
    end

    # Associates an AWS Identity and Access Management (IAM) role with an
    # AWS Certificate Manager (ACM) certificate. This enables the
    # certificate to be used by the ACM for Nitro Enclaves application
    # inside an enclave. For more information, see [AWS Certificate Manager
    # for Nitro Enclaves][1] in the *AWS Nitro Enclaves User Guide*.
    #
    # When the IAM role is associated with the ACM certificate, the
    # certificate, certificate chain, and encrypted private key are placed
    # in an Amazon S3 bucket that only the associated IAM role can access.
    # The private key of the certificate is encrypted with an AWS-managed
    # KMS customer master (CMK) that has an attached attestation-based CMK
    # policy.
    #
    # To enable the IAM role to access the Amazon S3 object, you must grant
    # it permission to call `s3:GetObject` on the Amazon S3 bucket returned
    # by the command. To enable the IAM role to access the AWS KMS CMK, you
    # must grant it permission to call `kms:Decrypt` on the AWS KMS CMK
    # returned by the command. For more information, see [ Grant the role
    # permission to access the certificate and encryption key][2] in the
    # *AWS Nitro Enclaves User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html
    # [2]: https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy
    #
    # @option params [String] :certificate_arn
    #   The ARN of the ACM certificate with which to associate the IAM role.
    #
    # @option params [String] :role_arn
    #   The ARN of the IAM role to associate with the ACM certificate. You can
    #   associate up to 16 IAM roles with an ACM certificate.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateEnclaveCertificateIamRoleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#certificate_s3_bucket_name #certificate_s3_bucket_name} => String
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#certificate_s3_object_key #certificate_s3_object_key} => String
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#encryption_kms_key_id #encryption_kms_key_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_enclave_certificate_iam_role({
    #     certificate_arn: "ResourceArn",
    #     role_arn: "ResourceArn",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.certificate_s3_bucket_name #=> String
    #   resp.certificate_s3_object_key #=> String
    #   resp.encryption_kms_key_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole AWS API Documentation
    #
    # @overload associate_enclave_certificate_iam_role(params = {})
    # @param [Hash] params ({})
    def associate_enclave_certificate_iam_role(params = {}, options = {})
      req = build_request(:associate_enclave_certificate_iam_role, params)
      req.send_request(options)
    end

    # Associates an IAM instance profile with a running or stopped instance.
    # You cannot associate more than one IAM instance profile with an
    # instance.
    #
    # @option params [required, Types::IamInstanceProfileSpecification] :iam_instance_profile
    #   The IAM instance profile.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @return [Types::AssociateIamInstanceProfileResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateIamInstanceProfileResult#iam_instance_profile_association #iam_instance_profile_association} => Types::IamInstanceProfileAssociation
    #
    #
    # @example Example: To associate an IAM instance profile with an instance
    #
    #   # This example associates an IAM instance profile named admin-role with the specified instance.
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: {
    #       name: "admin-role", 
    #     }, 
    #     instance_id: "i-123456789abcde123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     iam_instance_profile_association: {
    #       association_id: "iip-assoc-0e7736511a163c209", 
    #       iam_instance_profile: {
    #         arn: "arn:aws:iam::123456789012:instance-profile/admin-role", 
    #         id: "AIPAJBLK7RKJKWDXVHIEC", 
    #       }, 
    #       instance_id: "i-123456789abcde123", 
    #       state: "associating", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: { # required
    #       arn: "String",
    #       name: "String",
    #     },
    #     instance_id: "InstanceId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.iam_instance_profile_association.association_id #=> String
    #   resp.iam_instance_profile_association.instance_id #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.arn #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.id #=> String
    #   resp.iam_instance_profile_association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.iam_instance_profile_association.timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile AWS API Documentation
    #
    # @overload associate_iam_instance_profile(params = {})
    # @param [Hash] params ({})
    def associate_iam_instance_profile(params = {}, options = {})
      req = build_request(:associate_iam_instance_profile, params)
      req.send_request(options)
    end

    # Associates a subnet in your VPC or an internet gateway or virtual
    # private gateway attached to your VPC with a route table in your VPC.
    # This association causes traffic from the subnet or gateway to be
    # routed according to the routes in the route table. The action returns
    # an association ID, which you need in order to disassociate the route
    # table later. A route table can be associated with multiple subnets.
    #
    # For more information, see [Route Tables][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @option params [String] :subnet_id
    #   The ID of the subnet.
    #
    # @option params [String] :gateway_id
    #   The ID of the internet gateway or virtual private gateway.
    #
    # @return [Types::AssociateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateRouteTableResult#association_id #association_id} => String
    #   * {Types::AssociateRouteTableResult#association_state #association_state} => Types::RouteTableAssociationState
    #
    #
    # @example Example: To associate a route table with a subnet
    #
    #   # This example associates the specified route table with the specified subnet.
    #
    #   resp = client.associate_route_table({
    #     route_table_id: "rtb-22574640", 
    #     subnet_id: "subnet-9d4a7b6", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "rtbassoc-781d0d1a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_route_table({
    #     dry_run: false,
    #     route_table_id: "RouteTableId", # required
    #     subnet_id: "SubnetId",
    #     gateway_id: "RouteGatewayId",
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #   resp.association_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failed"
    #   resp.association_state.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable AWS API Documentation
    #
    # @overload associate_route_table(params = {})
    # @param [Hash] params ({})
    def associate_route_table(params = {}, options = {})
      req = build_request(:associate_route_table, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your subnet. You can only associate a
    # single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have
    # a prefix length of /64.
    #
    # @option params [required, String] :subnet_id
    #   The ID of your subnet.
    #
    # @option params [required, String] :ipv_6_cidr_block
    #   The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix
    #   length.
    #
    # @return [Types::AssociateSubnetCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateSubnetCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::SubnetIpv6CidrBlockAssociation
    #   * {Types::AssociateSubnetCidrBlockResult#subnet_id #subnet_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_subnet_cidr_block({
    #     subnet_id: "SubnetId", # required
    #     ipv_6_cidr_block: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock AWS API Documentation
    #
    # @overload associate_subnet_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_subnet_cidr_block(params = {}, options = {})
      req = build_request(:associate_subnet_cidr_block, params)
      req.send_request(options)
    end

    # Associates the specified subnets and transit gateway attachments with
    # the specified transit gateway multicast domain.
    #
    # The transit gateway attachment must be in the available state before
    # you can add a resource. Use [DescribeTransitGatewayAttachments][1] to
    # see the state of the attachment.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html
    #
    # @option params [String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the transit
    #   gateway multicast domain.
    #
    # @option params [Array<String>] :subnet_ids
    #   The IDs of the subnets to associate with the transit gateway multicast
    #   domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayMulticastDomainResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayMulticastDomainResult#associations #associations} => Types::TransitGatewayMulticastDomainAssociations
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_multicast_domain({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     subnet_ids: ["SubnetId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.associations.transit_gateway_multicast_domain_id #=> String
    #   resp.associations.transit_gateway_attachment_id #=> String
    #   resp.associations.resource_id #=> String
    #   resp.associations.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.associations.resource_owner_id #=> String
    #   resp.associations.subnets #=> Array
    #   resp.associations.subnets[0].subnet_id #=> String
    #   resp.associations.subnets[0].state #=> String, one of "pendingAcceptance", "associating", "associated", "disassociating", "disassociated", "rejected", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain AWS API Documentation
    #
    # @overload associate_transit_gateway_multicast_domain(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_multicast_domain(params = {}, options = {})
      req = build_request(:associate_transit_gateway_multicast_domain, params)
      req.send_request(options)
    end

    # Associates the specified attachment with the specified transit gateway
    # route table. You can associate only one route table with an
    # attachment.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayRouteTableResult#association #association} => Types::TransitGatewayAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_route_table({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association.transit_gateway_route_table_id #=> String
    #   resp.association.transit_gateway_attachment_id #=> String
    #   resp.association.resource_id #=> String
    #   resp.association.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable AWS API Documentation
    #
    # @overload associate_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:associate_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your VPC. You can associate a secondary
    # IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR
    # block from an IPv6 address pool that you provisioned through bring
    # your own IP addresses ([BYOIP][1]). The IPv6 CIDR block size is fixed
    # at /56.
    #
    # You must specify one of the following in the request: an IPv4 CIDR
    # block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.
    #
    # For more information about associating CIDR blocks with your VPC and
    # applicable restrictions, see [VPC and Subnet Sizing][2] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing
    #
    # @option params [Boolean] :amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IPv6 addresses, or the
    #   size of the CIDR block.
    #
    # @option params [String] :cidr_block
    #   An IPv4 CIDR block to associate with the VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [String] :ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR block.
    #   Use this parameter to limit the CIDR block to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #
    #   You can have one IPv6 CIDR block association per network border group.
    #
    # @option params [String] :ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #
    # @option params [String] :ipv_6_cidr_block
    #   An IPv6 CIDR block from the IPv6 address pool. You must also specify
    #   `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
    #
    # @return [Types::AssociateVpcCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateVpcCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::VpcIpv6CidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#cidr_block_association #cidr_block_association} => Types::VpcCidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#vpc_id #vpc_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_vpc_cidr_block({
    #     amazon_provided_ipv_6_cidr_block: false,
    #     cidr_block: "String",
    #     vpc_id: "VpcId", # required
    #     ipv_6_cidr_block_network_border_group: "String",
    #     ipv_6_pool: "Ipv6PoolEc2Id",
    #     ipv_6_cidr_block: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.ipv_6_cidr_block_association.network_border_group #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_pool #=> String
    #   resp.cidr_block_association.association_id #=> String
    #   resp.cidr_block_association.cidr_block #=> String
    #   resp.cidr_block_association.cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.cidr_block_association.cidr_block_state.status_message #=> String
    #   resp.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock AWS API Documentation
    #
    # @overload associate_vpc_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_vpc_cidr_block(params = {}, options = {})
      req = build_request(:associate_vpc_cidr_block, params)
      req.send_request(options)
    end

    # Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
    # or more of the VPC's security groups. You cannot link an EC2-Classic
    # instance to more than one VPC at a time. You can only link an instance
    # that's in the `running` state. An instance is automatically unlinked
    # from a VPC when it's stopped - you can link it to the VPC again when
    # you restart it.
    #
    # After you've linked an instance, you cannot change the VPC security
    # groups that are associated with it. To change the security groups, you
    # must first unlink the instance, and then link it again.
    #
    # Linking your instance to a VPC is sometimes referred to as *attaching*
    # your instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :groups
    #   The ID of one or more of the VPC's security groups. You cannot
    #   specify security groups from a different VPC.
    #
    # @option params [required, String] :instance_id
    #   The ID of an EC2-Classic instance to link to the ClassicLink-enabled
    #   VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of a ClassicLink-enabled VPC.
    #
    # @return [Types::AttachClassicLinkVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachClassicLinkVpcResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_classic_link_vpc({
    #     dry_run: false,
    #     groups: ["String"], # required
    #     instance_id: "InstanceId", # required
    #     vpc_id: "VpcId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc AWS API Documentation
    #
    # @overload attach_classic_link_vpc(params = {})
    # @param [Hash] params ({})
    def attach_classic_link_vpc(params = {}, options = {})
      req = build_request(:attach_classic_link_vpc, params)
      req.send_request(options)
    end

    # Attaches an internet gateway or a virtual private gateway to a VPC,
    # enabling connectivity between the internet and the VPC. For more
    # information about your VPC and internet gateway, see the [Amazon
    # Virtual Private Cloud User Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :internet_gateway_id
    #   The ID of the internet gateway.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To attach an Internet gateway to a VPC
    #
    #   # This example attaches the specified Internet gateway to the specified VPC.
    #
    #   resp = client.attach_internet_gateway({
    #     internet_gateway_id: "igw-c0a643a9", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_internet_gateway({
    #     dry_run: false,
    #     internet_gateway_id: "InternetGatewayId", # required
    #     vpc_id: "VpcId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway AWS API Documentation
    #
    # @overload attach_internet_gateway(params = {})
    # @param [Hash] params ({})
    def attach_internet_gateway(params = {}, options = {})
      req = build_request(:attach_internet_gateway, params)
      req.send_request(options)
    end

    # Attaches a network interface to an instance.
    #
    # @option params [required, Integer] :device_index
    #   The index of the device for the network interface attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [Integer] :network_card_index
    #   The index of the network card. Some instance types support multiple
    #   network cards. The primary network interface must be assigned to
    #   network card index 0. The default is network card index 0.
    #
    # @return [Types::AttachNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachNetworkInterfaceResult#attachment_id #attachment_id} => String
    #   * {Types::AttachNetworkInterfaceResult#network_card_index #network_card_index} => Integer
    #
    #
    # @example Example: To attach a network interface to an instance
    #
    #   # This example attaches the specified network interface to the specified instance.
    #
    #   resp = client.attach_network_interface({
    #     device_index: 1, 
    #     instance_id: "i-1234567890abcdef0", 
    #     network_interface_id: "eni-e5aa89a3", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachment_id: "eni-attach-66c4350a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_network_interface({
    #     device_index: 1, # required
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     network_interface_id: "NetworkInterfaceId", # required
    #     network_card_index: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.attachment_id #=> String
    #   resp.network_card_index #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface AWS API Documentation
    #
    # @overload attach_network_interface(params = {})
    # @param [Hash] params ({})
    def attach_network_interface(params = {}, options = {})
      req = build_request(:attach_network_interface, params)
      req.send_request(options)
    end

    # Attaches an EBS volume to a running or stopped instance and exposes it
    # to the instance with the specified device name.
    #
    # Encrypted EBS volumes must be attached to instances that support
    # Amazon EBS encryption. For more information, see [Amazon EBS
    # encryption][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # After you attach an EBS volume, you must make it available. For more
    # information, see [Making an EBS volume available for use][2].
    #
    # If a volume has an AWS Marketplace product code:
    #
    # * The volume can be attached only to a stopped instance.
    #
    # * AWS Marketplace product codes are copied from the volume to the
    #   instance.
    #
    # * You must be subscribed to the product.
    #
    # * The instance type and operating system of the instance must support
    #   the product. For example, you can't detach a volume from a Windows
    #   instance and attach it to a Linux instance.
    #
    # For more information, see [Attaching Amazon EBS volumes][3] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html
    #
    # @option params [required, String] :device
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :volume_id
    #   The ID of the EBS volume. The volume and instance must be within the
    #   same Availability Zone.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::VolumeAttachment] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::VolumeAttachment#attach_time #attach_time} => Time
    #   * {Types::VolumeAttachment#device #device} => String
    #   * {Types::VolumeAttachment#instance_id #instance_id} => String
    #   * {Types::VolumeAttachment#state #state} => String
    #   * {Types::VolumeAttachment#volume_id #volume_id} => String
    #   * {Types::VolumeAttachment#delete_on_termination #delete_on_termination} => Boolean
    #
    #
    # @example Example: To attach a volume to an instance
    #
    #   # This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``) as ``/dev/sdf``.
    #
    #   resp = client.attach_volume({
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attach_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     state: "attaching", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_volume({
    #     device: "String", # required
    #     instance_id: "InstanceId", # required
    #     volume_id: "VolumeId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.attach_time #=> Time
    #   resp.device #=> String
    #   resp.instance_id #=> String
    #   resp.state #=> String, one of "attaching", "attached", "detaching", "detached", "busy"
    #   resp.volume_id #=> String
    #   resp.delete_on_termination #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume AWS API Documentation
    #
    # @overload attach_volume(params = {})
    # @param [Hash] params ({})
    def attach_volume(params = {}, options = {})
      req = build_request(:attach_volume, params)
      req.send_request(options)
    end

    # Attaches a virtual private gateway to a VPC. You can attach one
    # virtual private gateway to one VPC at a time.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [required, String] :vpn_gateway_id
    #   The ID of the virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AttachVpnGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachVpnGatewayResult#vpc_attachment #vpc_attachment} => Types::VpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_vpn_gateway({
    #     vpc_id: "VpcId", # required
    #     vpn_gateway_id: "VpnGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_attachment.state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.vpc_attachment.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway AWS API Documentation
    #
    # @overload attach_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def attach_vpn_gateway(params = {}, options = {})
      req = build_request(:attach_vpn_gateway, params)
      req.send_request(options)
    end

    # Adds an ingress authorization rule to a Client VPN endpoint. Ingress
    # authorization rules act as firewall rules that grant access to
    # networks. You must configure ingress authorization rules to enable
    # clients to access resources in AWS or on-premises networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :target_network_cidr
    #   The IPv4 address range, in CIDR notation, of the network for which
    #   access is being authorized.
    #
    # @option params [String] :access_group_id
    #   The ID of the group to grant access to, for example, the Active
    #   Directory group or identity provider (IdP) group. Required if
    #   `AuthorizeAllGroups` is `false` or not specified.
    #
    # @option params [Boolean] :authorize_all_groups
    #   Indicates whether to grant access to all clients. Specify `true` to
    #   grant all clients who successfully establish a VPN connection access
    #   to the network. Must be set to `true` if `AccessGroupId` is not
    #   specified.
    #
    # @option params [String] :description
    #   A brief description of the authorization rule.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AuthorizeClientVpnIngressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeClientVpnIngressResult#status #status} => Types::ClientVpnAuthorizationRuleStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_client_vpn_ingress({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     target_network_cidr: "String", # required
    #     access_group_id: "String",
    #     authorize_all_groups: false,
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "authorizing", "active", "failed", "revoking"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress AWS API Documentation
    #
    # @overload authorize_client_vpn_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_client_vpn_ingress(params = {}, options = {})
      req = build_request(:authorize_client_vpn_ingress, params)
      req.send_request(options)
    end

    # \[VPC only\] Adds the specified egress rules to a security group for
    # use with a VPC.
    #
    # An outbound rule permits instances to send traffic to the specified
    # IPv4 or IPv6 CIDR address ranges, or to the instances associated with
    # the specified destination security groups.
    #
    # You specify a protocol for each rule (for example, TCP). For the TCP
    # and UDP protocols, you must also specify the destination port or port
    # range. For the ICMP protocol, you must also specify the ICMP type and
    # code. You can use -1 for the type or code to mean all types or all
    # codes.
    #
    # Rule changes are propagated to affected instances as quickly as
    # possible. However, a small delay might occur.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :group_id
    #   The ID of the security group.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The sets of IP permissions. You can't specify a destination security
    #   group and a CIDR IP address range in the same set of permissions.
    #
    # @option params [String] :cidr_ip
    #   Not supported. Use a set of IP permissions to specify the CIDR.
    #
    # @option params [Integer] :from_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #
    # @option params [String] :ip_protocol
    #   Not supported. Use a set of IP permissions to specify the protocol
    #   name or number.
    #
    # @option params [Integer] :to_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #
    # @option params [String] :source_security_group_name
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #
    # @option params [String] :source_security_group_owner_id
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a rule that allows outbound traffic to a specific address range
    #
    #   # This example adds a rule that grants access to the specified address ranges on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "10.0.0.0/16", 
    #           }, 
    #         ], 
    #         to_port: 80, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows outbound traffic to a specific security group
    #
    #   # This example adds a rule that grants access to the specified security group on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             group_id: "sg-4b51a32f", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_egress({
    #     dry_run: false,
    #     group_id: "SecurityGroupId", # required
    #     ip_permissions: [
    #       {
    #         from_port: 1,
    #         ip_protocol: "String",
    #         ip_ranges: [
    #           {
    #             cidr_ip: "String",
    #             description: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "String",
    #             description: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             group_id: "String",
    #             group_name: "String",
    #             peering_status: "String",
    #             user_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     cidr_ip: "String",
    #     from_port: 1,
    #     ip_protocol: "String",
    #     to_port: 1,
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress AWS API Documentation
    #
    # @overload authorize_security_group_egress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_egress(params = {}, options = {})
      req = build_request(:authorize_security_group_egress, params)
      req.send_request(options)
    end

    # Adds the specified ingress rules to a security group.
    #
    # An inbound rule permits instances to receive traffic from the
    # specified IPv4 or IPv6 CIDR address ranges, or from the instances
    # associated with the specified destination security groups.
    #
    # You specify a protocol for each rule (for example, TCP). For TCP and
    # UDP, you must also specify the destination port or port range. For
    # ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
    # can use -1 to mean all types or all codes.
    #
    # Rule changes are propagated to instances within the security group as
    # quickly as possible. However, a small delay might occur.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [String] :cidr_ip
    #   The IPv4 address range, in CIDR format. You can't specify this
    #   parameter when specifying a source security group. To specify an IPv6
    #   address range, use a set of IP permissions.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [Integer] :from_port
    #   The start of port range for the TCP and UDP protocols, or an ICMP type
    #   number. For the ICMP type number, use `-1` to specify all types. If
    #   you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [String] :group_id
    #   The ID of the security group. You must specify either the security
    #   group ID or the security group name in the request. For security
    #   groups in a nondefault VPC, you must specify the security group ID.
    #
    # @option params [String] :group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You must
    #   specify either the security group ID or the security group name in the
    #   request.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The sets of IP permissions.
    #
    # @option params [String] :ip_protocol
    #   The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
    #   Numbers][1]). To specify `icmpv6`, use a set of IP permissions.
    #
    #   \[VPC only\] Use `-1` to specify all protocols. If you specify `-1` or
    #   a protocol other than `tcp`, `udp`, or `icmp`, traffic on all ports is
    #   allowed, regardless of any ports you specify.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    #
    #
    #   [1]: http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [String] :source_security_group_name
    #   \[EC2-Classic, default VPC\] The name of the source security group.
    #   You can't specify this parameter in combination with the following
    #   parameters: the CIDR IP address range, the start of the port range,
    #   the IP protocol, and the end of the port range. Creates rules that
    #   grant full ICMP, UDP, and TCP access. To create a rule with a specific
    #   IP protocol and port range, use a set of IP permissions instead. For
    #   EC2-VPC, the source security group must be in the same VPC.
    #
    # @option params [String] :source_security_group_owner_id
    #   \[nondefault VPC\] The AWS account ID for the source security group,
    #   if the source security group is in a different account. You can't
    #   specify this parameter in combination with the following parameters:
    #   the CIDR IP address range, the IP protocol, the start of the port
    #   range, and the end of the port range. Creates rules that grant full
    #   ICMP, UDP, and TCP access. To create a rule with a specific IP
    #   protocol and port range, use a set of IP permissions instead.
    #
    # @option params [Integer] :to_port
    #   The end of port range for the TCP and UDP protocols, or an ICMP code
    #   number. For the ICMP code number, use `-1` to specify all codes. If
    #   you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a rule that allows inbound SSH traffic from an IPv4 address range
    #
    #   # This example enables inbound traffic on TCP port 22 (SSH). The rule includes a description to help you identify it
    #   # later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-903004f8", 
    #     ip_permissions: [
    #       {
    #         from_port: 22, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "203.0.113.0/24", 
    #             description: "SSH access from the LA office", 
    #           }, 
    #         ], 
    #         to_port: 22, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound HTTP traffic from another security group
    #
    #   # This example enables inbound traffic on TCP port 80 from the specified security group. The group must be in the same VPC
    #   # or a peer VPC. Incoming traffic is allowed based on the private IP addresses of instances that are associated with the
    #   # specified security group.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-111aaa22", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             description: "HTTP access from other instances", 
    #             group_id: "sg-1a2b3c4d", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound RDP traffic from an IPv6 address range
    #
    #   # This example adds an inbound rule that allows RDP traffic from the specified IPv6 address range. The rule includes a
    #   # description to help you identify it later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-123abc12 ", 
    #     ip_permissions: [
    #       {
    #         from_port: 3389, 
    #         ip_protocol: "tcp", 
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "2001:db8:1234:1a00::/64", 
    #             description: "RDP access from the NY office", 
    #           }, 
    #         ], 
    #         to_port: 3389, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_ingress({
    #     cidr_ip: "String",
    #     from_port: 1,
    #     group_id: "SecurityGroupId",
    #     group_name: "SecurityGroupName",
    #     ip_permissions: [
    #       {
    #         from_port: 1,
    #         ip_protocol: "String",
    #         ip_ranges: [
    #           {
    #             cidr_ip: "String",
    #             description: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "String",
    #             description: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             group_id: "String",
    #             group_name: "String",
    #             peering_status: "String",
    #             user_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     ip_protocol: "String",
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #     to_port: 1,
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress AWS API Documentation
    #
    # @overload authorize_security_group_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_ingress(params = {}, options = {})
      req = build_request(:authorize_security_group_ingress, params)
      req.send_request(options)
    end

    # Bundles an Amazon instance store-backed Windows instance.
    #
    # During bundling, only the root device volume (C:\\) is bundled. Data
    # on other instance store volumes is not preserved.
    #
    # <note markdown="1"> This action is not applicable for Linux/Unix instances or Windows
    # instances that are backed by Amazon EBS.
    #
    #  </note>
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance to bundle.
    #
    #   Type: String
    #
    #   Default: None
    #
    #   Required: Yes
    #
    # @option params [required, Types::Storage] :storage
    #   The bucket in which to store the AMI. You can specify a bucket that
    #   you already own or a new bucket that Amazon EC2 creates on your
    #   behalf. If you specify a bucket that belongs to someone else, Amazon
    #   EC2 returns an error.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::BundleInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::BundleInstanceResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.bundle_instance({
    #     instance_id: "InstanceId", # required
    #     storage: { # required
    #       s3: {
    #         aws_access_key_id: "String",
    #         bucket: "String",
    #         prefix: "String",
    #         upload_policy: "data",
    #         upload_policy_signature: "String",
    #       },
    #     },
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.update_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance AWS API Documentation
    #
    # @overload bundle_instance(params = {})
    # @param [Hash] params ({})
    def bundle_instance(params = {}, options = {})
      req = build_request(:bundle_instance, params)
      req.send_request(options)
    end

    # Cancels a bundling operation for an instance store-backed Windows
    # instance.
    #
    # @option params [required, String] :bundle_id
    #   The ID of the bundle task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelBundleTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelBundleTaskResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_bundle_task({
    #     bundle_id: "BundleId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.update_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask AWS API Documentation
    #
    # @overload cancel_bundle_task(params = {})
    # @param [Hash] params ({})
    def cancel_bundle_task(params = {}, options = {})
      req = build_request(:cancel_bundle_task, params)
      req.send_request(options)
    end

    # Cancels the specified Capacity Reservation, releases the reserved
    # capacity, and changes the Capacity Reservation's state to
    # `cancelled`.
    #
    # Instances running in the reserved capacity continue running until you
    # stop them. Stopped instances that target the Capacity Reservation can
    # no longer launch. Modify these instances to either target a different
    # Capacity Reservation, launch On-Demand Instance capacity, or run in
    # any open Capacity Reservation that has matching attributes and
    # sufficient capacity.
    #
    # @option params [required, String] :capacity_reservation_id
    #   The ID of the Capacity Reservation to be cancelled.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelCapacityReservationResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_capacity_reservation({
    #     capacity_reservation_id: "CapacityReservationId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation AWS API Documentation
    #
    # @overload cancel_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def cancel_capacity_reservation(params = {}, options = {})
      req = build_request(:cancel_capacity_reservation, params)
      req.send_request(options)
    end

    # Cancels an active conversion task. The task can be the import of an
    # instance or volume. The action removes all artifacts of the
    # conversion, including a partially uploaded volume or instance. If the
    # conversion is complete or is in the process of transferring the final
    # disk image, the command fails and returns an exception.
    #
    # For more information, see [Importing a Virtual Machine Using the
    # Amazon EC2 CLI][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html
    #
    # @option params [required, String] :conversion_task_id
    #   The ID of the conversion task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :reason_message
    #   The reason for canceling the conversion task.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_conversion_task({
    #     conversion_task_id: "ConversionTaskId", # required
    #     dry_run: false,
    #     reason_message: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask AWS API Documentation
    #
    # @overload cancel_conversion_task(params = {})
    # @param [Hash] params ({})
    def cancel_conversion_task(params = {}, options = {})
      req = build_request(:cancel_conversion_task, params)
      req.send_request(options)
    end

    # Cancels an active export task. The request removes all artifacts of
    # the export, including any partially-created Amazon S3 objects. If the
    # export task is complete or is in the process of transferring the final
    # disk image, the command fails and returns an error.
    #
    # @option params [required, String] :export_task_id
    #   The ID of the export task. This is the ID returned by
    #   `CreateInstanceExportTask`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_export_task({
    #     export_task_id: "ExportVmTaskId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask AWS API Documentation
    #
    # @overload cancel_export_task(params = {})
    # @param [Hash] params ({})
    def cancel_export_task(params = {}, options = {})
      req = build_request(:cancel_export_task, params)
      req.send_request(options)
    end

    # Cancels an in-process import virtual machine or import snapshot task.
    #
    # @option params [String] :cancel_reason
    #   The reason for canceling the task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :import_task_id
    #   The ID of the import image or import snapshot task to be canceled.
    #
    # @return [Types::CancelImportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelImportTaskResult#import_task_id #import_task_id} => String
    #   * {Types::CancelImportTaskResult#previous_state #previous_state} => String
    #   * {Types::CancelImportTaskResult#state #state} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_import_task({
    #     cancel_reason: "String",
    #     dry_run: false,
    #     import_task_id: "ImportTaskId",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_task_id #=> String
    #   resp.previous_state #=> String
    #   resp.state #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask AWS API Documentation
    #
    # @overload cancel_import_task(params = {})
    # @param [Hash] params ({})
    def cancel_import_task(params = {}, options = {})
      req = build_request(:cancel_import_task, params)
      req.send_request(options)
    end

    # Cancels the specified Reserved Instance listing in the Reserved
    # Instance Marketplace.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :reserved_instances_listing_id
    #   The ID of the Reserved Instance listing.
    #
    # @return [Types::CancelReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_reserved_instances_listing({
    #     reserved_instances_listing_id: "ReservedInstancesListingId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing AWS API Documentation
    #
    # @overload cancel_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def cancel_reserved_instances_listing(params = {}, options = {})
      req = build_request(:cancel_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Cancels the specified Spot Fleet requests.
    #
    # After you cancel a Spot Fleet request, the Spot Fleet launches no new
    # Spot Instances. You must specify whether the Spot Fleet should also
    # terminate its Spot Instances. If you terminate the instances, the Spot
    # Fleet request enters the `cancelled_terminating` state. Otherwise, the
    # Spot Fleet request enters the `cancelled_running` state and the
    # instances continue to run until they are interrupted or you terminate
    # them manually.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #
    # @option params [required, Boolean] :terminate_instances
    #   Indicates whether to terminate instances for a Spot Fleet request if
    #   it is canceled successfully.
    #
    # @return [Types::CancelSpotFleetRequestsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotFleetRequestsResponse#successful_fleet_requests #successful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsSuccessItem&gt;
    #   * {Types::CancelSpotFleetRequestsResponse#unsuccessful_fleet_requests #unsuccessful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsErrorItem&gt;
    #
    #
    # @example Example: To cancel a Spot fleet request
    #
    #   # This example cancels the specified Spot fleet request and terminates its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_running", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To cancel a Spot fleet request without terminating its Spot Instances
    #
    #   # This example cancels the specified Spot fleet request without terminating its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: false, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_terminating", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     dry_run: false,
    #     spot_fleet_request_ids: ["SpotFleetRequestId"], # required
    #     terminate_instances: false, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_requests #=> Array
    #   resp.successful_fleet_requests[0].current_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].previous_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].spot_fleet_request_id #=> String
    #   resp.unsuccessful_fleet_requests #=> Array
    #   resp.unsuccessful_fleet_requests[0].error.code #=> String, one of "fleetRequestIdDoesNotExist", "fleetRequestIdMalformed", "fleetRequestNotInCancellableState", "unexpectedError"
    #   resp.unsuccessful_fleet_requests[0].error.message #=> String
    #   resp.unsuccessful_fleet_requests[0].spot_fleet_request_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests AWS API Documentation
    #
    # @overload cancel_spot_fleet_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_fleet_requests(params = {}, options = {})
      req = build_request(:cancel_spot_fleet_requests, params)
      req.send_request(options)
    end

    # Cancels one or more Spot Instance requests.
    #
    # Canceling a Spot Instance request does not terminate running Spot
    # Instances associated with the request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_instance_request_ids
    #   One or more Spot Instance request IDs.
    #
    # @return [Types::CancelSpotInstanceRequestsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotInstanceRequestsResult#cancelled_spot_instance_requests #cancelled_spot_instance_requests} => Array&lt;Types::CancelledSpotInstanceRequest&gt;
    #
    #
    # @example Example: To cancel Spot Instance requests
    #
    #   # This example cancels a Spot Instance request.
    #
    #   resp = client.cancel_spot_instance_requests({
    #     spot_instance_request_ids: [
    #       "sir-08b93456", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     cancelled_spot_instance_requests: [
    #       {
    #         spot_instance_request_id: "sir-08b93456", 
    #         state: "cancelled", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_instance_requests({
    #     dry_run: false,
    #     spot_instance_request_ids: ["SpotInstanceRequestId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.cancelled_spot_instance_requests #=> Array
    #   resp.cancelled_spot_instance_requests[0].spot_instance_request_id #=> String
    #   resp.cancelled_spot_instance_requests[0].state #=> String, one of "active", "open", "closed", "cancelled", "completed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests AWS API Documentation
    #
    # @overload cancel_spot_instance_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_instance_requests(params = {}, options = {})
      req = build_request(:cancel_spot_instance_requests, params)
      req.send_request(options)
    end

    # Determines whether a product code is associated with an instance. This
    # action can only be used by the owner of the product code. It is useful
    # when a product code owner must verify whether another user's instance
    # is eligible for support.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :product_code
    #   The product code. This must be a product code that you own.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ConfirmProductInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ConfirmProductInstanceResult#owner_id #owner_id} => String
    #   * {Types::ConfirmProductInstanceResult#return #return} => Boolean
    #
    #
    # @example Example: To confirm the product instance
    #
    #   # This example determines whether the specified product code is associated with the specified instance.
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "i-1234567890abcdef0", 
    #     product_code: "774F4FF8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     owner_id: "123456789012", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "InstanceId", # required
    #     product_code: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.owner_id #=> String
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance AWS API Documentation
    #
    # @overload confirm_product_instance(params = {})
    # @param [Hash] params ({})
    def confirm_product_instance(params = {}, options = {})
      req = build_request(:confirm_product_instance, params)
      req.send_request(options)
    end

    # Copies the specified Amazon FPGA Image (AFI) to the current Region.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :source_fpga_image_id
    #   The ID of the source AFI.
    #
    # @option params [String] :description
    #   The description for the new AFI.
    #
    # @option params [String] :name
    #   The name for the new AFI. The default is the name of the source AFI.
    #
    # @option params [required, String] :source_region
    #   The Region that contains the source AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @return [Types::CopyFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_fpga_image({
    #     dry_run: false,
    #     source_fpga_image_id: "String", # required
    #     description: "String",
    #     name: "String",
    #     source_region: "String", # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage AWS API Documentation
    #
    # @overload copy_fpga_image(params = {})
    # @param [Hash] params ({})
    def copy_fpga_image(params = {}, options = {})
      req = build_request(:copy_fpga_image, params)
      req.send_request(options)
    end

    # Initiates the copy of an AMI. You can copy an AMI from one Region to
    # another, or from a Region to an AWS Outpost. You can't copy an AMI
    # from an Outpost to a Region, from one Outpost to another, or within
    # the same Outpost. To copy an AMI to another partition, see
    # [CreateStoreImageTask][1].
    #
    # To copy an AMI from one Region to another, specify the source Region
    # using the **SourceRegion** parameter, and specify the destination
    # Region using its endpoint. Copies of encrypted backing snapshots for
    # the AMI are encrypted. Copies of unencrypted backing snapshots remain
    # unencrypted, unless you set `Encrypted` during the copy operation. You
    # cannot create an unencrypted copy of an encrypted backing snapshot.
    #
    # To copy an AMI from a Region to an Outpost, specify the source Region
    # using the **SourceRegion** parameter, and specify the ARN of the
    # destination Outpost using **DestinationOutpostArn**. Backing snapshots
    # copied to an Outpost are encrypted by default using the default
    # encryption key for the Region, or a different key that you specify in
    # the request using **KmsKeyId**. Outposts do not support unencrypted
    # snapshots. For more information, [ Amazon EBS local snapshots on
    # Outposts][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # For more information about the prerequisites and limits when copying
    # an AMI, see [Copying an AMI][3] in the *Amazon Elastic Compute Cloud
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   the request. For more information, see [Ensuring idempotency][1] in
    #   the *Amazon EC2 API Reference*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :description
    #   A description for the new AMI in the destination Region.
    #
    # @option params [Boolean] :encrypted
    #   Specifies whether the destination snapshots of the copied image should
    #   be encrypted. You can encrypt a copy of an unencrypted snapshot, but
    #   you cannot create an unencrypted copy of an encrypted snapshot. The
    #   default CMK for EBS is used unless you specify a non-default AWS Key
    #   Management Service (AWS KMS) CMK using `KmsKeyId`. For more
    #   information, see [Amazon EBS Encryption][1] in the *Amazon Elastic
    #   Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the symmetric AWS Key Management Service (AWS KMS)
    #   customer master key (CMK) to use when creating encrypted volumes. If
    #   this parameter is not specified, your AWS managed CMK for EBS is used.
    #   If you specify a CMK, you must also set the encrypted state to `true`.
    #
    #   You can specify a CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify an
    #   identifier that is not valid, the action can appear to complete, but
    #   eventually fails.
    #
    #   The specified CMK must exist in the destination Region.
    #
    #   Amazon EBS does not support asymmetric CMKs.
    #
    # @option params [required, String] :name
    #   The name of the new AMI in the destination Region.
    #
    # @option params [required, String] :source_image_id
    #   The ID of the AMI to copy.
    #
    # @option params [required, String] :source_region
    #   The name of the Region that contains the AMI to copy.
    #
    # @option params [String] :destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   AMI. Only specify this parameter when copying an AMI from an AWS
    #   Region to an Outpost. The AMI must be in the Region of the destination
    #   Outpost. You cannot copy an AMI from an Outpost to a Region, from one
    #   Outpost to another, or within the same Outpost.
    #
    #   For more information, see [ Copying AMIs from an AWS Region to an
    #   Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopyImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To copy an AMI to another region
    #
    #   # This example copies the specified AMI from the us-east-1 region to the current region.
    #
    #   resp = client.copy_image({
    #     description: "", 
    #     name: "My server", 
    #     source_image_id: "ami-5731123e", 
    #     source_region: "us-east-1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-438bea42", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_image({
    #     client_token: "String",
    #     description: "String",
    #     encrypted: false,
    #     kms_key_id: "KmsKeyId",
    #     name: "String", # required
    #     source_image_id: "String", # required
    #     source_region: "String", # required
    #     destination_outpost_arn: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage AWS API Documentation
    #
    # @overload copy_image(params = {})
    # @param [Hash] params ({})
    def copy_image(params = {}, options = {})
      req = build_request(:copy_image, params)
      req.send_request(options)
    end

    # Copies a point-in-time snapshot of an EBS volume and stores it in
    # Amazon S3. You can copy a snapshot within the same Region, from one
    # Region to another, or from a Region to an Outpost. You can't copy a
    # snapshot from an Outpost to a Region, from one Outpost to another, or
    # within the same Outpost.
    #
    # You can use the snapshot to create EBS volumes or Amazon Machine
    # Images (AMIs).
    #
    # When copying snapshots to a Region, copies of encrypted EBS snapshots
    # remain encrypted. Copies of unencrypted snapshots remain unencrypted,
    # unless you enable encryption for the snapshot copy operation. By
    # default, encrypted snapshot copies use the default AWS Key Management
    # Service (AWS KMS) customer master key (CMK); however, you can specify
    # a different CMK. To copy an encrypted snapshot that has been shared
    # from another account, you must have permissions for the CMK used to
    # encrypt the snapshot.
    #
    # Snapshots copied to an Outpost are encrypted by default using the
    # default encryption key for the Region, or a different key that you
    # specify in the request using **KmsKeyId**. Outposts do not support
    # unencrypted snapshots. For more information, [ Amazon EBS local
    # snapshots on Outposts][1] in the *Amazon Elastic Compute Cloud User
    # Guide*.
    #
    # Snapshots created by copying another snapshot have an arbitrary volume
    # ID that should not be used for any purpose.
    #
    # For more information, see [Copying an Amazon EBS snapshot][2] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html
    #
    # @option params [String] :description
    #   A description for the EBS snapshot.
    #
    # @option params [String] :destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   snapshot. Only specify this parameter when copying a snapshot from an
    #   AWS Region to an Outpost. The snapshot must be in the Region for the
    #   destination Outpost. You cannot copy a snapshot from an Outpost to a
    #   Region, from one Outpost to another, or within the same Outpost.
    #
    #   For more information, see [ Copying snapshots from an AWS Region to an
    #   Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots
    #
    # @option params [String] :destination_region
    #   The destination Region to use in the `PresignedUrl` parameter of a
    #   snapshot copy operation. This parameter is only valid for specifying
    #   the destination Region in a `PresignedUrl` parameter, where it is
    #   required.
    #
    #   The snapshot copy is sent to the regional endpoint that you sent the
    #   HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
    #   AWS CLI, this is specified using the `--region` parameter or the
    #   default Region in your AWS configuration file.
    #
    # @option params [Boolean] :encrypted
    #   To encrypt a copy of an unencrypted snapshot if encryption by default
    #   is not enabled, enable encryption using this parameter. Otherwise,
    #   omit this parameter. Encrypted snapshots are encrypted, even if you
    #   omit this parameter and encryption by default is not enabled. You
    #   cannot set this parameter to false. For more information, see [Amazon
    #   EBS encryption][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If `KmsKeyId`
    #   is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify an
    #   ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #
    # @option params [String] :presigned_url
    #   When you copy an encrypted source snapshot using the Amazon EC2 Query
    #   API, you must supply a pre-signed URL. This parameter is optional for
    #   unencrypted snapshots. For more information, see [Query requests][1].
    #
    #   The `PresignedUrl` should use the snapshot source endpoint, the
    #   `CopySnapshot` action, and include the `SourceRegion`,
    #   `SourceSnapshotId`, and `DestinationRegion` parameters. The
    #   `PresignedUrl` must be signed using AWS Signature Version 4. Because
    #   EBS snapshots are stored in Amazon S3, the signing algorithm for this
    #   parameter uses the same logic that is described in [Authenticating
    #   Requests: Using Query Parameters (AWS Signature Version 4)][2] in the
    #   *Amazon Simple Storage Service API Reference*. An invalid or
    #   improperly signed `PresignedUrl` will cause the copy operation to fail
    #   asynchronously, and the snapshot will move to an `error` state.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html
    #   [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #
    # @option params [required, String] :source_region
    #   The ID of the Region that contains the snapshot to be copied.
    #
    # @option params [required, String] :source_snapshot_id
    #   The ID of the EBS snapshot to copy.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new snapshot.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopySnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopySnapshotResult#snapshot_id #snapshot_id} => String
    #   * {Types::CopySnapshotResult#tags #tags} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To copy a snapshot
    #
    #   # This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b`` from the ``us-west-2`` region to the
    #   # ``us-east-1`` region and adds a short description to identify the snapshot.
    #
    #   resp = client.copy_snapshot({
    #     description: "This is my copied snapshot.", 
    #     destination_region: "us-east-1", 
    #     source_region: "us-west-2", 
    #     source_snapshot_id: "snap-066877671789bd71b", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     snapshot_id: "snap-066877671789bd71b", 
    #   }
    #
    # @example Copy snapshot example
    #   source_snapshot_id = 'snapshot-id'
    #   source_region = 'us-east-1'
    #   target_region = 'us-west-2'
    #
    #   # You must configure your EC2 client for the destination region to copy
    #   ec2 = Aws::EC2::Client(region: target_region)
    #
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #   })
    #
    #   snapshot_id = resp.snapshot_id
    #
    #   ec2.wait_until(:snapshot_completed, snapshot_ids: [snapshot_id])
    #
    # @example Copy an encrypted snapshot
    #   # same as above, expect you must pass `encrypted: true`
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #       encrypted: true, # required for encrypted snapshots
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_snapshot({
    #     description: "String",
    #     destination_outpost_arn: "String",
    #     destination_region: "String",
    #     encrypted: false,
    #     kms_key_id: "KmsKeyId",
    #     presigned_url: "String",
    #     source_region: "String", # required
    #     source_snapshot_id: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshot_id #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot AWS API Documentation
    #
    # @overload copy_snapshot(params = {})
    # @param [Hash] params ({})
    def copy_snapshot(params = {}, options = {})
      req = build_request(:copy_snapshot, params)
      req.send_request(options)
    end

    # Creates a new Capacity Reservation with the specified attributes.
    #
    # Capacity Reservations enable you to reserve capacity for your Amazon
    # EC2 instances in a specific Availability Zone for any duration. This
    # gives you the flexibility to selectively add capacity reservations and
    # still get the Regional RI discounts for that usage. By creating
    # Capacity Reservations, you ensure that you always have access to
    # Amazon EC2 capacity when you need it, for as long as you need it. For
    # more information, see [Capacity Reservations][1] in the *Amazon EC2
    # User Guide*.
    #
    # Your request to create a Capacity Reservation could fail if Amazon EC2
    # does not have sufficient capacity to fulfill the request. If your
    # request fails due to Amazon EC2 capacity constraints, either try again
    # at a later time, try in a different Availability Zone, or request a
    # smaller capacity reservation. If your application is flexible across
    # instance types and sizes, try to create a Capacity Reservation with
    # different instance attributes.
    #
    # Your request could also fail if the requested quantity exceeds your
    # On-Demand Instance limit for the selected instance type. If your
    # request fails due to limit constraints, increase your On-Demand
    # Instance limit for the required instance type and try again. For more
    # information about increasing your instance limits, see [Amazon EC2
    # Service Quotas][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :instance_type
    #   The instance type for which to reserve capacity. For more information,
    #   see [Instance types][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #
    # @option params [required, String] :instance_platform
    #   The type of operating system for which to reserve capacity.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which to create the Capacity Reservation.
    #
    # @option params [String] :availability_zone_id
    #   The ID of the Availability Zone in which to create the Capacity
    #   Reservation.
    #
    # @option params [String] :tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that is
    #     shared with other AWS accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single AWS account.
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances for which to reserve capacity.
    #
    # @option params [Boolean] :ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #
    # @option params [Boolean] :ephemeral_storage
    #   Indicates whether the Capacity Reservation supports instances with
    #   temporary, block-level storage.
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end date
    #   and time.
    #
    #   You must provide an `EndDate` value if `EndDateType` is `limited`.
    #   Omit `EndDate` if `EndDateType` is `unlimited`.
    #
    #   If the `EndDateType` is `limited`, the Capacity Reservation is
    #   cancelled within an hour from the specified time. For example, if you
    #   specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to
    #   end between 13:30:55 and 14:30:55 on 5/31/2019.
    #
    # @option params [String] :end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it. Do not provide an `EndDate` if the
    #     `EndDateType` is `unlimited`.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time. You must provide an `EndDate` value if the
    #     `EndDateType` value is `limited`.
    #
    # @option params [String] :instance_match_criteria
    #   Indicates the type of instance launches that the Capacity Reservation
    #   accepts. The options include:
    #
    #   * `open` - The Capacity Reservation automatically matches all
    #     instances that have matching attributes (instance type, platform,
    #     and Availability Zone). Instances that have matching attributes run
    #     in the Capacity Reservation automatically without specifying any
    #     additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and Availability
    #     Zone), and explicitly target the Capacity Reservation. This ensures
    #     that only permitted instances can use the reserved capacity.
    #
    #   Default: `open`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Capacity Reservation during launch.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCapacityReservationResult#capacity_reservation #capacity_reservation} => Types::CapacityReservation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_capacity_reservation({
    #     client_token: "String",
    #     instance_type: "String", # required
    #     instance_platform: "Linux/UNIX", # required, accepts Linux/UNIX, Red Hat Enterprise Linux, SUSE Linux, Windows, Windows with SQL Server, Windows with SQL Server Enterprise, Windows with SQL Server Standard, Windows with SQL Server Web, Linux with SQL Server Standard, Linux with SQL Server Web, Linux with SQL Server Enterprise
    #     availability_zone: "String",
    #     availability_zone_id: "String",
    #     tenancy: "default", # accepts default, dedicated
    #     instance_count: 1, # required
    #     ebs_optimized: false,
    #     ephemeral_storage: false,
    #     end_date: Time.now,
    #     end_date_type: "unlimited", # accepts unlimited, limited
    #     instance_match_criteria: "open", # accepts open, targeted
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.capacity_reservation.capacity_reservation_id #=> String
    #   resp.capacity_reservation.owner_id #=> String
    #   resp.capacity_reservation.capacity_reservation_arn #=> String
    #   resp.capacity_reservation.availability_zone_id #=> String
    #   resp.capacity_reservation.instance_type #=> String
    #   resp.capacity_reservation.instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise"
    #   resp.capacity_reservation.availability_zone #=> String
    #   resp.capacity_reservation.tenancy #=> String, one of "default", "dedicated"
    #   resp.capacity_reservation.total_instance_count #=> Integer
    #   resp.capacity_reservation.available_instance_count #=> Integer
    #   resp.capacity_reservation.ebs_optimized #=> Boolean
    #   resp.capacity_reservation.ephemeral_storage #=> Boolean
    #   resp.capacity_reservation.state #=> String, one of "active", "expired", "cancelled", "pending", "failed"
    #   resp.capacity_reservation.start_date #=> Time
    #   resp.capacity_reservation.end_date #=> Time
    #   resp.capacity_reservation.end_date_type #=> String, one of "unlimited", "limited"
    #   resp.capacity_reservation.instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.capacity_reservation.create_date #=> Time
    #   resp.capacity_reservation.tags #=> Array
    #   resp.capacity_reservation.tags[0].key #=> String
    #   resp.capacity_reservation.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation AWS API Documentation
    #
    # @overload create_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def create_capacity_reservation(params = {}, options = {})
      req = build_request(:create_capacity_reservation, params)
      req.send_request(options)
    end

    # Creates a carrier gateway. For more information about carrier
    # gateways, see [Carrier gateways][1] in the *AWS Wavelength Developer
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC to associate with the carrier gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to associate with the carrier gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateCarrierGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCarrierGatewayResult#carrier_gateway #carrier_gateway} => Types::CarrierGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_carrier_gateway({
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.carrier_gateway.carrier_gateway_id #=> String
    #   resp.carrier_gateway.vpc_id #=> String
    #   resp.carrier_gateway.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.carrier_gateway.owner_id #=> String
    #   resp.carrier_gateway.tags #=> Array
    #   resp.carrier_gateway.tags[0].key #=> String
    #   resp.carrier_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway AWS API Documentation
    #
    # @overload create_carrier_gateway(params = {})
    # @param [Hash] params ({})
    def create_carrier_gateway(params = {}, options = {})
      req = build_request(:create_carrier_gateway, params)
      req.send_request(options)
    end

    # Creates a Client VPN endpoint. A Client VPN endpoint is the resource
    # you create and configure to enable and manage client VPN sessions. It
    # is the destination endpoint at which all client VPN sessions are
    # terminated.
    #
    # @option params [required, String] :client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which to assign client
    #   IP addresses. The address range cannot overlap with the local CIDR of
    #   the VPC in which the associated subnet is located, or the routes that
    #   you add manually. The address range cannot be changed after the Client
    #   VPN endpoint has been created. The CIDR block should be /22 or
    #   greater.
    #
    # @option params [required, String] :server_certificate_arn
    #   The ARN of the server certificate. For more information, see the [AWS
    #   Certificate Manager User Guide][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/acm/latest/userguide/
    #
    # @option params [required, Array<Types::ClientVpnAuthenticationRequest>] :authentication_options
    #   Information about the authentication method to be used to authenticate
    #   clients.
    #
    # @option params [required, Types::ConnectionLogOptions] :connection_log_options
    #   Information about the client connection logging options.
    #
    #   If you enable client connection logging, data about client connections
    #   is sent to a Cloudwatch Logs log stream. The following information is
    #   logged:
    #
    #   * Client connection requests
    #
    #   * Client connection results (successful and unsuccessful)
    #
    #   * Reasons for unsuccessful client connection requests
    #
    #   * Client connection termination time
    #
    # @option params [Array<String>] :dns_servers
    #   Information about the DNS servers to be used for DNS resolution. A
    #   Client VPN endpoint can have up to two DNS servers. If no DNS server
    #   is specified, the DNS address configured on the device is used for the
    #   DNS server.
    #
    # @option params [String] :transport_protocol
    #   The transport protocol to be used by the VPN session.
    #
    #   Default value: `udp`
    #
    # @option params [Integer] :vpn_port
    #   The port number to assign to the Client VPN endpoint for TCP and UDP
    #   traffic.
    #
    #   Valid Values: `443` \| `1194`
    #
    #   Default Value: `443`
    #
    # @option params [String] :description
    #   A brief description of the Client VPN endpoint.
    #
    # @option params [Boolean] :split_tunnel
    #   Indicates whether split-tunnel is enabled on the AWS Client VPN
    #   endpoint.
    #
    #   By default, split-tunnel on a VPN endpoint is disabled.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-Tunnel
    #   AWS Client VPN Endpoint][1] in the *AWS Client VPN Administrator
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Client VPN endpoint during creation.
    #
    # @option params [Array<String>] :security_group_ids
    #   The IDs of one or more security groups to apply to the target network.
    #   You must also specify the ID of the VPC that contains the security
    #   groups.
    #
    # @option params [String] :vpc_id
    #   The ID of the VPC to associate with the Client VPN endpoint. If no
    #   security group IDs are specified in the request, the default security
    #   group for the VPC is applied.
    #
    # @option params [String] :self_service_portal
    #   Specify whether to enable the self-service portal for the Client VPN
    #   endpoint.
    #
    #   Default Value: `enabled`
    #
    # @option params [Types::ClientConnectOptions] :client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #
    # @return [Types::CreateClientVpnEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnEndpointResult#client_vpn_endpoint_id #client_vpn_endpoint_id} => String
    #   * {Types::CreateClientVpnEndpointResult#status #status} => Types::ClientVpnEndpointStatus
    #   * {Types::CreateClientVpnEndpointResult#dns_name #dns_name} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_endpoint({
    #     client_cidr_block: "String", # required
    #     server_certificate_arn: "String", # required
    #     authentication_options: [ # required
    #       {
    #         type: "certificate-authentication", # accepts certificate-authentication, directory-service-authentication, federated-authentication
    #         active_directory: {
    #           directory_id: "String",
    #         },
    #         mutual_authentication: {
    #           client_root_certificate_chain_arn: "String",
    #         },
    #         federated_authentication: {
    #           saml_provider_arn: "String",
    #           self_service_saml_provider_arn: "String",
    #         },
    #       },
    #     ],
    #     connection_log_options: { # required
    #       enabled: false,
    #       cloudwatch_log_group: "String",
    #       cloudwatch_log_stream: "String",
    #     },
    #     dns_servers: ["String"],
    #     transport_protocol: "tcp", # accepts tcp, udp
    #     vpn_port: 1,
    #     description: "String",
    #     split_tunnel: false,
    #     dry_run: false,
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     security_group_ids: ["SecurityGroupId"],
    #     vpc_id: "VpcId",
    #     self_service_portal: "enabled", # accepts enabled, disabled
    #     client_connect_options: {
    #       enabled: false,
    #       lambda_function_arn: "String",
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_endpoint_id #=> String
    #   resp.status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.status.message #=> String
    #   resp.dns_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint AWS API Documentation
    #
    # @overload create_client_vpn_endpoint(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_endpoint(params = {}, options = {})
      req = build_request(:create_client_vpn_endpoint, params)
      req.send_request(options)
    end

    # Adds a route to a network to a Client VPN endpoint. Each Client VPN
    # endpoint has a route table that describes the available destination
    # network routes. Each route in the route table specifies the path for
    # traﬃc to speciﬁc resources or networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which to add the route.
    #
    # @option params [required, String] :destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   For example:
    #
    #   * To add a route for Internet access, enter `0.0.0.0/0`
    #
    #   * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
    #     range
    #
    #   * To add a route for an on-premises network, enter the AWS
    #     Site-to-Site VPN connection's IPv4 CIDR range
    #
    #   * To add a route for the local network, enter the client CIDR range
    #
    # @option params [required, String] :target_vpc_subnet_id
    #   The ID of the subnet through which you want to route traffic. The
    #   specified subnet must be an existing target network of the Client VPN
    #   endpoint.
    #
    #   Alternatively, if you're adding a route for the local network,
    #   specify `local`.
    #
    # @option params [String] :description
    #   A brief description of the route.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateClientVpnRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnRouteResult#status #status} => Types::ClientVpnRouteStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_route({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     destination_cidr_block: "String", # required
    #     target_vpc_subnet_id: "SubnetId", # required
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute AWS API Documentation
    #
    # @overload create_client_vpn_route(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_route(params = {}, options = {})
      req = build_request(:create_client_vpn_route, params)
      req.send_request(options)
    end

    # Provides information to AWS about your VPN customer gateway device.
    # The customer gateway is the appliance at your end of the VPN
    # connection. (The device on the AWS side of the VPN connection is the
    # virtual private gateway.) You must provide the internet-routable IP
    # address of the customer gateway's external interface. The IP address
    # must be static and can be behind a device performing network address
    # translation (NAT).
    #
    # For devices that use Border Gateway Protocol (BGP), you can also
    # provide the device's BGP Autonomous System Number (ASN). You can use
    # an existing ASN assigned to your network. If you don't have an ASN
    # already, you can use a private ASN (in the 64512 - 65534 range).
    #
    # <note markdown="1"> Amazon EC2 supports all 4-byte ASN numbers in the range of 1 -
    # 2147483647, with the exception of the following:
    #
    #  * 7224 - reserved in the `us-east-1` Region
    #
    # * 9059 - reserved in the `eu-west-1` Region
    #
    # * 17943 - reserved in the `ap-southeast-1` Region
    #
    # * 10124 - reserved in the `ap-northeast-1` Region
    #
    #  </note>
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    # To create more than one customer gateway with the same VPN type, IP
    # address, and BGP ASN, specify a unique device name for each customer
    # gateway. Identical requests return information about the existing
    # customer gateway and do not create new customer gateways.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, Integer] :bgp_asn
    #   For devices that support BGP, the customer gateway's BGP ASN.
    #
    #   Default: 65000
    #
    # @option params [String] :public_ip
    #   The Internet-routable IP address for the customer gateway's outside
    #   interface. The address must be static.
    #
    # @option params [String] :certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #
    # @option params [required, String] :type
    #   The type of VPN connection that this customer gateway supports
    #   (`ipsec.1`).
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the customer gateway.
    #
    # @option params [String] :device_name
    #   A name for the customer gateway device.
    #
    #   Length Constraints: Up to 255 characters.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCustomerGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCustomerGatewayResult#customer_gateway #customer_gateway} => Types::CustomerGateway
    #
    #
    # @example Example: To create a customer gateway
    #
    #   # This example creates a customer gateway with the specified IP address for its outside interface.
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 65534, 
    #     public_ip: "12.1.2.3", 
    #     type: "ipsec.1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     customer_gateway: {
    #       bgp_asn: "65534", 
    #       customer_gateway_id: "cgw-0e11f167", 
    #       ip_address: "12.1.2.3", 
    #       state: "available", 
    #       type: "ipsec.1", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 1, # required
    #     public_ip: "String",
    #     certificate_arn: "String",
    #     type: "ipsec.1", # required, accepts ipsec.1
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     device_name: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.customer_gateway.bgp_asn #=> String
    #   resp.customer_gateway.customer_gateway_id #=> String
    #   resp.customer_gateway.ip_address #=> String
    #   resp.customer_gateway.certificate_arn #=> String
    #   resp.customer_gateway.state #=> String
    #   resp.customer_gateway.type #=> String
    #   resp.customer_gateway.device_name #=> String
    #   resp.customer_gateway.tags #=> Array
    #   resp.customer_gateway.tags[0].key #=> String
    #   resp.customer_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway AWS API Documentation
    #
    # @overload create_customer_gateway(params = {})
    # @param [Hash] params ({})
    def create_customer_gateway(params = {}, options = {})
      req = build_request(:create_customer_gateway, params)
      req.send_request(options)
    end

    # Creates a default subnet with a size `/20` IPv4 CIDR block in the
    # specified Availability Zone in your default VPC. You can have only one
    # default subnet per Availability Zone. For more information, see
    # [Creating a Default Subnet][1] in the *Amazon Virtual Private Cloud
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to create the default subnet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDefaultSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultSubnetResult#subnet #subnet} => Types::Subnet
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_subnet({
    #     availability_zone: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #   resp.subnet.map_customer_owned_ip_on_launch #=> Boolean
    #   resp.subnet.customer_owned_ipv_4_pool #=> String
    #   resp.subnet.state #=> String, one of "pending", "available"
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #   resp.subnet.outpost_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet AWS API Documentation
    #
    # @overload create_default_subnet(params = {})
    # @param [Hash] params ({})
    def create_default_subnet(params = {}, options = {})
      req = build_request(:create_default_subnet, params)
      req.send_request(options)
    end

    # Creates a default VPC with a size `/16` IPv4 CIDR block and a default
    # subnet in each Availability Zone. For more information about the
    # components of a default VPC, see [Default VPC and Default Subnets][1]
    # in the *Amazon Virtual Private Cloud User Guide*. You cannot specify
    # the components of the default VPC yourself.
    #
    # If you deleted your previous default VPC, you can create a default
    # VPC. You cannot have more than one default VPC per Region.
    #
    # If your account supports EC2-Classic, you cannot use this action to
    # create a default VPC in a Region that supports EC2-Classic. If you
    # want a default VPC in a Region that supports EC2-Classic, see "I
    # really want a default VPC for my existing EC2 account. Is that
    # possible?" in the [Default VPCs FAQ][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html
    # [2]: http://aws.amazon.com/vpc/faqs/#Default_VPCs
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDefaultVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultVpcResult#vpc #vpc} => Types::Vpc
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_vpc({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc.cidr_block #=> String
    #   resp.vpc.dhcp_options_id #=> String
    #   resp.vpc.state #=> String, one of "pending", "available"
    #   resp.vpc.vpc_id #=> String
    #   resp.vpc.owner_id #=> String
    #   resp.vpc.instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.vpc.ipv_6_cidr_block_association_set #=> Array
    #   resp.vpc.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].network_border_group #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_pool #=> String
    #   resp.vpc.cidr_block_association_set #=> Array
    #   resp.vpc.cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.status_message #=> String
    #   resp.vpc.is_default #=> Boolean
    #   resp.vpc.tags #=> Array
    #   resp.vpc.tags[0].key #=> String
    #   resp.vpc.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc AWS API Documentation
    #
    # @overload create_default_vpc(params = {})
    # @param [Hash] params ({})
    def create_default_vpc(params = {}, options = {})
      req = build_request(:create_default_vpc, params)
      req.send_request(options)
    end

    # Creates a set of DHCP options for your VPC. After creating the set,
    # you must associate it with the VPC, causing all existing and new
    # instances that you launch in the VPC to use this set of DHCP options.
    # The following are the individual DHCP options you can specify. For
    # more information about the options, see [RFC 2132][1].
    #
    # * `domain-name-servers` - The IP addresses of up to four domain name
    #   servers, or AmazonProvidedDNS. The default DHCP option set specifies
    #   AmazonProvidedDNS. If specifying more than one domain name server,
    #   specify the IP addresses in a single parameter, separated by commas.
    #   To have your instance receive a custom DNS hostname as specified in
    #   `domain-name`, you must set `domain-name-servers` to a custom DNS
    #   server.
    #
    # * `domain-name` - If you're using AmazonProvidedDNS in `us-east-1`,
    #   specify `ec2.internal`. If you're using AmazonProvidedDNS in
    #   another Region, specify `region.compute.internal` (for example,
    #   `ap-northeast-1.compute.internal`). Otherwise, specify a domain name
    #   (for example, `ExampleCompany.com`). This value is used to complete
    #   unqualified DNS hostnames. **Important**\: Some Linux operating
    #   systems accept multiple domain names separated by spaces. However,
    #   Windows and other Linux operating systems treat the value as a
    #   single domain, which results in unexpected behavior. If your DHCP
    #   options set is associated with a VPC that has instances with
    #   multiple operating systems, specify only one domain name.
    #
    # * `ntp-servers` - The IP addresses of up to four Network Time Protocol
    #   (NTP) servers.
    #
    # * `netbios-name-servers` - The IP addresses of up to four NetBIOS name
    #   servers.
    #
    # * `netbios-node-type` - The NetBIOS node type (1, 2, 4, or 8). We
    #   recommend that you specify 2 (broadcast and multicast are not
    #   currently supported). For more information about these node types,
    #   see [RFC 2132][1].
    #
    # Your VPC automatically starts out with a set of DHCP options that
    # includes only a DNS server that we provide (AmazonProvidedDNS). If you
    # create a set of options, and if your VPC has an internet gateway, make
    # sure to set the `domain-name-servers` option either to
    # `AmazonProvidedDNS` or to a domain name server of your choice. For
    # more information, see [DHCP Options Sets][2] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: http://www.ietf.org/rfc/rfc2132.txt
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [required, Array<Types::NewDhcpConfiguration>] :dhcp_configurations
    #   A DHCP configuration option.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the DHCP option.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDhcpOptionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDhcpOptionsResult#dhcp_options #dhcp_options} => Types::DhcpOptions
    #
    #
    # @example Example: To create a DHCP options set
    #
    #   # This example creates a DHCP options set.
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [
    #       {
    #         key: "domain-name-servers", 
    #         values: [
    #           "10.2.5.1", 
    #           "10.2.5.2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     dhcp_options: {
    #       dhcp_configurations: [
    #         {
    #           key: "domain-name-servers", 
    #           values: [
    #             {
    #               value: "10.2.5.2", 
    #             }, 
    #             {
    #               value: "10.2.5.1", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #       dhcp_options_id: "dopt-d9070ebb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [ # required
    #       {
    #         key: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.dhcp_options.dhcp_configurations #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].key #=> String
    #   resp.dhcp_options.dhcp_configurations[0].values #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].values[0] #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.dhcp_options.dhcp_options_id #=> String
    #   resp.dhcp_options.owner_id #=> String
    #   resp.dhcp_options.tags #=> Array
    #   resp.dhcp_options.tags[0].key #=> String
    #   resp.dhcp_options.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions AWS API Documentation
    #
    # @overload create_dhcp_options(params = {})
    # @param [Hash] params ({})
    def create_dhcp_options(params = {}, options = {})
      req = build_request(:create_dhcp_options, params)
      req.send_request(options)
    end

    # \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An
    # egress-only internet gateway is used to enable outbound communication
    # over IPv6 from instances in your VPC to the internet, and prevents
    # hosts outside of your VPC from initiating an IPv6 connection with your
    # instance.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC for which to create the egress-only internet
    #   gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the egress-only internet gateway.
    #
    # @return [Types::CreateEgressOnlyInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateEgressOnlyInternetGatewayResult#client_token #client_token} => String
    #   * {Types::CreateEgressOnlyInternetGatewayResult#egress_only_internet_gateway #egress_only_internet_gateway} => Types::EgressOnlyInternetGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_egress_only_internet_gateway({
    #     client_token: "String",
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.egress_only_internet_gateway.attachments #=> Array
    #   resp.egress_only_internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.egress_only_internet_gateway.attachments[0].vpc_id #=> String
    #   resp.egress_only_internet_gateway.egress_only_internet_gateway_id #=> String
    #   resp.egress_only_internet_gateway.tags #=> Array
    #   resp.egress_only_internet_gateway.tags[0].key #=> String
    #   resp.egress_only_internet_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway AWS API Documentation
    #
    # @overload create_egress_only_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_egress_only_internet_gateway(params = {}, options = {})
      req = build_request(:create_egress_only_internet_gateway, params)
      req.send_request(options)
    end

    # Launches an EC2 Fleet.
    #
    # You can create a single EC2 Fleet that includes multiple launch
    # specifications that vary by instance type, AMI, Availability Zone, or
    # subnet.
    #
    # For more information, see [Launching an EC2 Fleet][1] in the *Amazon
    # EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Types::SpotOptionsRequest] :spot_options
    #   Describes the configuration of Spot Instances in an EC2 Fleet.
    #
    # @option params [Types::OnDemandOptionsRequest] :on_demand_options
    #   Describes the configuration of On-Demand Instances in an EC2 Fleet.
    #
    # @option params [String] :excess_capacity_termination_policy
    #   Indicates whether running instances should be terminated if the total
    #   target capacity of the EC2 Fleet is decreased below the current size
    #   of the EC2 Fleet.
    #
    # @option params [required, Array<Types::FleetLaunchTemplateConfigRequest>] :launch_template_configs
    #   The configuration for the EC2 Fleet.
    #
    # @option params [required, Types::TargetCapacitySpecificationRequest] :target_capacity_specification
    #   The number of units to request.
    #
    # @option params [Boolean] :terminate_instances_with_expiration
    #   Indicates whether running instances should be terminated when the EC2
    #   Fleet expires.
    #
    # @option params [String] :type
    #   The type of request. The default value is `maintain`.
    #
    #   * `maintain` - The EC2 Fleet places an asynchronous request for your
    #     desired capacity, and continues to maintain your desired Spot
    #     capacity by replenishing interrupted Spot Instances.
    #
    #   * `request` - The EC2 Fleet places an asynchronous one-time request
    #     for your desired capacity, but does submit Spot requests in
    #     alternative capacity pools if Spot capacity is unavailable, and does
    #     not maintain Spot capacity if Spot Instances are interrupted.
    #
    #   * `instant` - The EC2 Fleet places a synchronous one-time request for
    #     your desired capacity, and returns errors for any instances that
    #     could not be launched.
    #
    #   For more information, see [EC2 Fleet request types][1] in the *Amazon
    #   EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_from
    #   The start date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). The default is to start
    #   fulfilling the request immediately.
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_until
    #   The end date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). At this point, no new EC2 Fleet
    #   requests are placed or able to fulfill the request. If no value is
    #   specified, the request remains until you cancel it.
    #
    # @option params [Boolean] :replace_unhealthy_instances
    #   Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
    #   Supported only for fleets of type `maintain`. For more information,
    #   see [EC2 Fleet health checks][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key-value pair for tagging the EC2 Fleet request on creation. The
    #   value for `ResourceType` must be `fleet`, otherwise the fleet request
    #   fails. To tag instances at launch, specify the tags in the [launch
    #   template][1]. For information about tagging after launch, see [Tagging
    #   your resources][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources
    #
    # @return [Types::CreateFleetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFleetResult#fleet_id #fleet_id} => String
    #   * {Types::CreateFleetResult#errors #errors} => Array&lt;Types::CreateFleetError&gt;
    #   * {Types::CreateFleetResult#instances #instances} => Array&lt;Types::CreateFleetInstance&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fleet({
    #     dry_run: false,
    #     client_token: "String",
    #     spot_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, diversified, capacity-optimized, capacity-optimized-prioritized
    #       maintenance_strategies: {
    #         capacity_rebalance: {
    #           replacement_strategy: "launch", # accepts launch
    #         },
    #       },
    #       instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #       instance_pools_to_use_count: 1,
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     on_demand_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, prioritized
    #       capacity_reservation_options: {
    #         usage_strategy: "use-capacity-reservations-first", # accepts use-capacity-reservations-first
    #       },
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     excess_capacity_termination_policy: "no-termination", # accepts no-termination, termination
    #     launch_template_configs: [ # required
    #       {
    #         launch_template_specification: {
    #           launch_template_id: "LaunchTemplateId",
    #           launch_template_name: "LaunchTemplateName",
    #           version: "String",
    #         },
    #         overrides: [
    #           {
    #             instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal
    #             max_price: "String",
    #             subnet_id: "SubnetId",
    #             availability_zone: "String",
    #             weighted_capacity: 1.0,
    #             priority: 1.0,
    #             placement: {
    #               availability_zone: "String",
    #               affinity: "String",
    #               group_name: "String",
    #               partition_number: 1,
    #               host_id: "String",
    #               tenancy: "default", # accepts default, dedicated, host
    #               spread_domain: "String",
    #               host_resource_group_arn: "String",
    #             },
    #           },
    #         ],
    #       },
    #     ],
    #     target_capacity_specification: { # required
    #       total_target_capacity: 1, # required
    #       on_demand_target_capacity: 1,
    #       spot_target_capacity: 1,
    #       default_target_capacity_type: "spot", # accepts spot, on-demand
    #     },
    #     terminate_instances_with_expiration: false,
    #     type: "request", # accepts request, maintain, instant
    #     valid_from: Time.now,
    #     valid_until: Time.now,
    #     replace_unhealthy_instances: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.fleet_id #=> String
    #   resp.errors #=> Array
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.errors[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.errors[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.errors[0].error_code #=> String
    #   resp.errors[0].error_message #=> String
    #   resp.instances #=> Array
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.instances[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.instances[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.instances[0].instance_ids #=> Array
    #   resp.instances[0].instance_ids[0] #=> String
    #   resp.instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.instances[0].platform #=> String, one of "Windows"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet AWS API Documentation
    #
    # @overload create_fleet(params = {})
    # @param [Hash] params ({})
    def create_fleet(params = {}, options = {})
      req = build_request(:create_fleet, params)
      req.send_request(options)
    end

    # Creates one or more flow logs to capture information about IP traffic
    # for a specific network interface, subnet, or VPC.
    #
    # Flow log data for a monitored network interface is recorded as flow
    # log records, which are log events consisting of fields that describe
    # the traffic flow. For more information, see [Flow Log Records][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    # When publishing to CloudWatch Logs, flow log records are published to
    # a log group, and each network interface has a unique log stream in the
    # log group. When publishing to Amazon S3, flow log records for all of
    # the monitored network interfaces are published to a single log file
    # object that is stored in the specified bucket.
    #
    # For more information, see [VPC Flow Logs][2] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [String] :deliver_logs_permission_arn
    #   The ARN for the IAM role that permits Amazon EC2 to publish flow logs
    #   to a CloudWatch Logs log group in your account.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    # @option params [String] :log_group_name
    #   The name of a new or existing CloudWatch Logs log group where Amazon
    #   EC2 publishes your flow logs.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    # @option params [required, Array<String>] :resource_ids
    #   The ID of the subnet, network interface, or VPC for which you want to
    #   create a flow log.
    #
    #   Constraints: Maximum of 1000 resources
    #
    # @option params [required, String] :resource_type
    #   The type of resource for which to create the flow log. For example, if
    #   you specified a VPC ID for the `ResourceId` property, specify `VPC`
    #   for this property.
    #
    # @option params [required, String] :traffic_type
    #   The type of traffic to log. You can log traffic that the resource
    #   accepts or rejects, or all traffic.
    #
    # @option params [String] :log_destination_type
    #   Specifies the type of destination to which the flow log data is to be
    #   published. Flow log data can be published to CloudWatch Logs or Amazon
    #   S3. To publish flow log data to CloudWatch Logs, specify
    #   `cloud-watch-logs`. To publish flow log data to Amazon S3, specify
    #   `s3`.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    #   Default: `cloud-watch-logs`
    #
    # @option params [String] :log_destination
    #   Specifies the destination to which the flow log data is to be
    #   published. Flow log data can be published to a CloudWatch Logs log
    #   group or an Amazon S3 bucket. The value specified for this parameter
    #   depends on the value specified for `LogDestinationType`.
    #
    #   If `LogDestinationType` is not specified or `cloud-watch-logs`,
    #   specify the Amazon Resource Name (ARN) of the CloudWatch Logs log
    #   group. For example, to publish to a log group called `my-logs`,
    #   specify `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`.
    #   Alternatively, use `LogGroupName` instead.
    #
    #   If LogDestinationType is `s3`, specify the ARN of the Amazon S3
    #   bucket. You can also specify a subfolder in the bucket. To specify a
    #   subfolder in the bucket, use the following ARN format:
    #   `bucket_ARN/subfolder_name/`. For example, to specify a subfolder
    #   named `my-logs` in a bucket named `my-bucket`, use the following ARN:
    #   `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a
    #   subfolder name. This is a reserved term.
    #
    # @option params [String] :log_format
    #   The fields to include in the flow log record, in the order in which
    #   they should appear. For a list of available fields, see [Flow Log
    #   Records][1]. If you omit this parameter, the flow log is created using
    #   the default format. If you specify this parameter, you must specify at
    #   least one field.
    #
    #   Specify the fields using the `$\{field-id\}` format, separated by
    #   spaces. For the AWS CLI, use single quotation marks (' ') to
    #   surround the parameter value.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the flow logs.
    #
    # @option params [Integer] :max_aggregation_interval
    #   The maximum interval of time during which a flow of packets is
    #   captured and aggregated into a flow log record. You can specify 60
    #   seconds (1 minute) or 600 seconds (10 minutes).
    #
    #   When a network interface is attached to a [Nitro-based instance][1],
    #   the aggregation interval is always 60 seconds or less, regardless of
    #   the value that you specify.
    #
    #   Default: 600
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #
    # @return [Types::CreateFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFlowLogsResult#client_token #client_token} => String
    #   * {Types::CreateFlowLogsResult#flow_log_ids #flow_log_ids} => Array&lt;String&gt;
    #   * {Types::CreateFlowLogsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_flow_logs({
    #     dry_run: false,
    #     client_token: "String",
    #     deliver_logs_permission_arn: "String",
    #     log_group_name: "String",
    #     resource_ids: ["FlowLogResourceId"], # required
    #     resource_type: "VPC", # required, accepts VPC, Subnet, NetworkInterface
    #     traffic_type: "ACCEPT", # required, accepts ACCEPT, REJECT, ALL
    #     log_destination_type: "cloud-watch-logs", # accepts cloud-watch-logs, s3
    #     log_destination: "String",
    #     log_format: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     max_aggregation_interval: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.flow_log_ids #=> Array
    #   resp.flow_log_ids[0] #=> String
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs AWS API Documentation
    #
    # @overload create_flow_logs(params = {})
    # @param [Hash] params ({})
    def create_flow_logs(params = {}, options = {})
      req = build_request(:create_flow_logs, params)
      req.send_request(options)
    end

    # Creates an Amazon FPGA Image (AFI) from the specified design
    # checkpoint (DCP).
    #
    # The create operation is asynchronous. To verify that the AFI is ready
    # for use, check the output logs.
    #
    # An AFI contains the FPGA bitstream that is ready to download to an
    # FPGA. You can securely deploy an AFI on multiple FPGA-accelerated
    # instances. For more information, see the [AWS FPGA Hardware
    # Development Kit][1].
    #
    #
    #
    # [1]: https://github.com/aws/aws-fpga/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Types::StorageLocation] :input_storage_location
    #   The location of the encrypted design checkpoint in Amazon S3. The
    #   input must be a tarball.
    #
    # @option params [Types::StorageLocation] :logs_storage_location
    #   The location in Amazon S3 for the output logs.
    #
    # @option params [String] :description
    #   A description for the AFI.
    #
    # @option params [String] :name
    #   A name for the AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the FPGA image during creation.
    #
    # @return [Types::CreateFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #   * {Types::CreateFpgaImageResult#fpga_image_global_id #fpga_image_global_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fpga_image({
    #     dry_run: false,
    #     input_storage_location: { # required
    #       bucket: "String",
    #       key: "String",
    #     },
    #     logs_storage_location: {
    #       bucket: "String",
    #       key: "String",
    #     },
    #     description: "String",
    #     name: "String",
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #   resp.fpga_image_global_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage AWS API Documentation
    #
    # @overload create_fpga_image(params = {})
    # @param [Hash] params ({})
    def create_fpga_image(params = {}, options = {})
      req = build_request(:create_fpga_image, params)
      req.send_request(options)
    end

    # Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
    # that is either running or stopped.
    #
    # If you customized your instance with instance store volumes or EBS
    # volumes in addition to the root device volume, the new AMI contains
    # block device mapping information for those volumes. When you launch an
    # instance from this new AMI, the instance automatically launches with
    # those additional volumes.
    #
    # For more information, see [Creating Amazon EBS-Backed Linux AMIs][1]
    # in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html
    #
    # @option params [Array<Types::BlockDeviceMapping>] :block_device_mappings
    #   The block device mappings. This parameter cannot be used to modify the
    #   encryption status of existing volumes or snapshots. To create an AMI
    #   with encrypted snapshots, use the CopyImage action.
    #
    # @option params [String] :description
    #   A description for the new image.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :name
    #   A name for the new image.
    #
    #   Constraints: 3-128 alphanumeric characters, parentheses (()), square
    #   brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
    #   single quotes ('), at-signs (@), or underscores(\_)
    #
    # @option params [Boolean] :no_reboot
    #   By default, Amazon EC2 attempts to shut down and reboot the instance
    #   before creating the image. If the `No Reboot` option is set, Amazon
    #   EC2 doesn't shut down the instance before creating the image. When
    #   this option is used, file system integrity on the created image can't
    #   be guaranteed.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the AMI and snapshots on creation. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots that are created of the root volume and of
    #     other EBS volumes that are attached to the instance, the value for
    #     `ResourceType` must be `snapshot`. The same tag is applied to all of
    #     the snapshots that are created.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #
    # @return [Types::CreateImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To create an AMI from an Amazon EBS-backed instance
    #
    #   # This example creates an AMI from the specified instance and adds an EBS volume with the device name /dev/sdh and an
    #   # instance store volume with the device name /dev/sdc.
    #
    #   resp = client.create_image({
    #     block_device_mappings: [
    #       {
    #         device_name: "/dev/sdh", 
    #         ebs: {
    #           volume_size: 100, 
    #         }, 
    #       }, 
    #       {
    #         device_name: "/dev/sdc", 
    #         virtual_name: "ephemeral1", 
    #       }, 
    #     ], 
    #     description: "An AMI for my server", 
    #     instance_id: "i-1234567890abcdef0", 
    #     name: "My server", 
    #     no_reboot: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-1a2b3c4d", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_image({
    #     block_device_mappings: [
    #       {
    #         device_name: "String",
    #         virtual_name: "String",
    #         ebs: {
    #           delete_on_termination: false,
    #           iops: 1,
    #           snapshot_id: "String",
    #           volume_size: 1,
    #           volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #           kms_key_id: "String",
    #           throughput: 1,
    #           outpost_arn: "String",
    #           encrypted: false,
    #         },
    #         no_device: "String",
    #       },
    #     ],
    #     description: "String",
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     name: "String", # required
    #     no_reboot: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage AWS API Documentation
    #
    # @overload create_image(params = {})
    # @param [Hash] params ({})
    def create_image(params = {}, options = {})
      req = build_request(:create_image, params)
      req.send_request(options)
    end

    # Exports a running or stopped instance to an Amazon S3 bucket.
    #
    # For information about the supported operating systems, image formats,
    # and known limitations for the types of instances you can export, see
    # [Exporting an instance as a VM Using VM Import/Export][1] in the *VM
    # Import/Export User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
    #
    # @option params [String] :description
    #   A description for the conversion task or the resource being exported.
    #   The maximum length is 255 characters.
    #
    # @option params [required, Types::ExportToS3TaskSpecification] :export_to_s3_task
    #   The format and location for an export instance task.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :target_environment
    #   The target virtualization environment.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the export instance task during creation.
    #
    # @return [Types::CreateInstanceExportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInstanceExportTaskResult#export_task #export_task} => Types::ExportTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_instance_export_task({
    #     description: "String",
    #     export_to_s3_task: { # required
    #       container_format: "ova", # accepts ova
    #       disk_image_format: "VMDK", # accepts VMDK, RAW, VHD
    #       s3_bucket: "String",
    #       s3_prefix: "String",
    #     },
    #     instance_id: "InstanceId", # required
    #     target_environment: "citrix", # required, accepts citrix, vmware, microsoft
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.export_task.description #=> String
    #   resp.export_task.export_task_id #=> String
    #   resp.export_task.export_to_s3_task.container_format #=> String, one of "ova"
    #   resp.export_task.export_to_s3_task.disk_image_format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.export_task.export_to_s3_task.s3_bucket #=> String
    #   resp.export_task.export_to_s3_task.s3_key #=> String
    #   resp.export_task.instance_export_details.instance_id #=> String
    #   resp.export_task.instance_export_details.target_environment #=> String, one of "citrix", "vmware", "microsoft"
    #   resp.export_task.state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.export_task.status_message #=> String
    #   resp.export_task.tags #=> Array
    #   resp.export_task.tags[0].key #=> String
    #   resp.export_task.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask AWS API Documentation
    #
    # @overload create_instance_export_task(params = {})
    # @param [Hash] params ({})
    def create_instance_export_task(params = {}, options = {})
      req = build_request(:create_instance_export_task, params)
      req.send_request(options)
    end

    # Creates an internet gateway for use with a VPC. After creating the
    # internet gateway, you attach it to a VPC using AttachInternetGateway.
    #
    # For more information about your VPC and internet gateway, see the
    # [Amazon Virtual Private Cloud User Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the internet gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInternetGatewayResult#internet_gateway #internet_gateway} => Types::InternetGateway
    #
    #
    # @example Example: To create an Internet gateway
    #
    #   # This example creates an Internet gateway.
    #
    #   resp = client.create_internet_gateway({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     internet_gateway: {
    #       attachments: [
    #       ], 
    #       internet_gateway_id: "igw-c0a643a9", 
    #       tags: [
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_internet_gateway({
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.internet_gateway.attachments #=> Array
    #   resp.internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.internet_gateway.attachments[0].vpc_id #=> String
    #   resp.internet_gateway.internet_gateway_id #=> String
    #   resp.internet_gateway.owner_id #=> String
    #   resp.internet_gateway.tags #=> Array
    #   resp.internet_gateway.tags[0].key #=> String
    #   resp.internet_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway AWS API Documentation
    #
    # @overload create_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_internet_gateway(params = {}, options = {})
      req = build_request(:create_internet_gateway, params)
      req.send_request(options)
    end

    # Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
    # stores the public key and displays the private key for you to save to
    # a file. The private key is returned as an unencrypted PEM encoded
    # PKCS#1 private key. If a key with the specified name already exists,
    # Amazon EC2 returns an error.
    #
    # You can have up to five thousand key pairs per Region.
    #
    # The key pair returned to you is available only in the Region in which
    # you create it. If you prefer, you can create your own key pair using a
    # third-party tool and upload it to any Region using ImportKeyPair.
    #
    # For more information, see [Key Pairs][1] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
    #
    # @option params [required, String] :key_name
    #   A unique name for the key pair.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new key pair.
    #
    # @return [Types::KeyPair] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::KeyPair#key_fingerprint #key_fingerprint} => String
    #   * {Types::KeyPair#key_material #key_material} => String
    #   * {Types::KeyPair#key_name #key_name} => String
    #   * {Types::KeyPair#key_pair_id #key_pair_id} => String
    #   * {Types::KeyPair#tags #tags} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To create a key pair
    #
    #   # This example creates a key pair named my-key-pair.
    #
    #   resp = client.create_key_pair({
    #     key_name: "my-key-pair", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_key_pair({
    #     key_name: "String", # required
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.key_fingerprint #=> String
    #   resp.key_material #=> String
    #   resp.key_name #=> String
    #   resp.key_pair_id #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair AWS API Documentation
    #
    # @overload create_key_pair(params = {})
    # @param [Hash] params ({})
    def create_key_pair(params = {}, options = {})
      req = build_request(:create_key_pair, params)
      req.send_request(options)
    end

    # Creates a launch template. A launch template contains the parameters
    # to launch an instance. When you launch an instance using RunInstances,
    # you can specify a launch template instead of providing the launch
    # parameters in the request. For more information, see [Launching an
    # instance from a launch template][1]in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :launch_template_name
    #   A name for the launch template.
    #
    # @option params [String] :version_description
    #   A description for the first version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the launch template during creation.
    #
    # @return [Types::CreateLaunchTemplateResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateResult#launch_template #launch_template} => Types::LaunchTemplate
    #   * {Types::CreateLaunchTemplateResult#warning #warning} => Types::ValidationWarning
    #
    #
    # @example Example: To create a launch template
    #
    #   # This example creates a launch template that specifies the subnet in which to launch the instance, assigns a public IP
    #   # address and an IPv6 address to the instance, and creates a tag for the instance.
    #
    #   resp = client.create_launch_template({
    #     launch_template_data: {
    #       image_id: "ami-8c1be5f6", 
    #       instance_type: "t2.small", 
    #       network_interfaces: [
    #         {
    #           associate_public_ip_address: true, 
    #           device_index: 0, 
    #           ipv_6_address_count: 1, 
    #           subnet_id: "subnet-7b16de0c", 
    #         }, 
    #       ], 
    #       tag_specifications: [
    #         {
    #           resource_type: "instance", 
    #           tags: [
    #             {
    #               key: "Name", 
    #               value: "webserver", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #     }, 
    #     launch_template_name: "my-template", 
    #     version_description: "WebVersion1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template: {
    #       create_time: Time.parse("2017-11-27T09:13:24.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version_number: 1, 
    #       latest_version_number: 1, 
    #       launch_template_id: "lt-01238c059e3466abc", 
    #       launch_template_name: "my-template", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_name: "LaunchTemplateName", # required
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "KernelId",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "KmsKeyId",
    #             snapshot_id: "SnapshotId",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #             throughput: 1,
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_carrier_ip_address: false,
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["SecurityGroupId"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "NetworkInterfaceId",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "SubnetId",
    #           network_card_index: 1,
    #         },
    #       ],
    #       image_id: "ImageId",
    #       instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal
    #       key_name: "KeyPairName",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         affinity: "String",
    #         group_name: "PlacementGroupName",
    #         host_id: "DedicatedHostId",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #         host_resource_group_arn: "String",
    #         partition_number: 1,
    #       },
    #       ram_disk_id: "RamdiskId",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "String",
    #       tag_specifications: [
    #         {
    #           resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #           count: 1,
    #         },
    #       ],
    #       security_group_ids: ["SecurityGroupId"],
    #       security_groups: ["SecurityGroupName"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "open", # accepts open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "CapacityReservationId",
    #           capacity_reservation_resource_group_arn: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #       metadata_options: {
    #         http_tokens: "optional", # accepts optional, required
    #         http_put_response_hop_limit: 1,
    #         http_endpoint: "disabled", # accepts disabled, enabled
    #       },
    #       enclave_options: {
    #         enabled: false,
    #       },
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template.launch_template_id #=> String
    #   resp.launch_template.launch_template_name #=> String
    #   resp.launch_template.create_time #=> Time
    #   resp.launch_template.created_by #=> String
    #   resp.launch_template.default_version_number #=> Integer
    #   resp.launch_template.latest_version_number #=> Integer
    #   resp.launch_template.tags #=> Array
    #   resp.launch_template.tags[0].key #=> String
    #   resp.launch_template.tags[0].value #=> String
    #   resp.warning.errors #=> Array
    #   resp.warning.errors[0].code #=> String
    #   resp.warning.errors[0].message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate AWS API Documentation
    #
    # @overload create_launch_template(params = {})
    # @param [Hash] params ({})
    def create_launch_template(params = {}, options = {})
      req = build_request(:create_launch_template, params)
      req.send_request(options)
    end

    # Creates a new version for a launch template. You can specify an
    # existing version of launch template from which to base the new
    # version.
    #
    # Launch template versions are numbered in the order in which they are
    # created. You cannot specify, change, or replace the numbering of
    # launch template versions.
    #
    # For more information, see [Managing launch template versions][1]in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :source_version
    #   The version number of the launch template version on which to base the
    #   new version. The new version inherits the same launch parameters as
    #   the source version, except for parameters that you specify in
    #   `LaunchTemplateData`. Snapshots applied to the block device mapping
    #   are ignored when creating a new version unless they are explicitly
    #   included.
    #
    # @option params [String] :version_description
    #   A description for the version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @return [Types::CreateLaunchTemplateVersionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateVersionResult#launch_template_version #launch_template_version} => Types::LaunchTemplateVersion
    #   * {Types::CreateLaunchTemplateVersionResult#warning #warning} => Types::ValidationWarning
    #
    #
    # @example Example: To create a launch template version
    #
    #   # This example creates a new launch template version based on version 1 of the specified launch template and specifies a
    #   # different AMI ID.
    #
    #   resp = client.create_launch_template_version({
    #     launch_template_data: {
    #       image_id: "ami-c998b6b2", 
    #     }, 
    #     launch_template_id: "lt-0abcd290751193123", 
    #     source_version: "1", 
    #     version_description: "WebVersion2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template_version: {
    #       create_time: Time.parse("2017-12-01T13:35:46.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version: false, 
    #       launch_template_data: {
    #         image_id: "ami-c998b6b2", 
    #         instance_type: "t2.micro", 
    #         network_interfaces: [
    #           {
    #             associate_public_ip_address: true, 
    #             device_index: 0, 
    #             ipv_6_addresses: [
    #               {
    #                 ipv_6_address: "2001:db8:1234:1a00::123", 
    #               }, 
    #             ], 
    #             subnet_id: "subnet-7b16de0c", 
    #           }, 
    #         ], 
    #       }, 
    #       launch_template_id: "lt-0abcd290751193123", 
    #       launch_template_name: "my-template", 
    #       version_description: "WebVersion2", 
    #       version_number: 2, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template_version({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_id: "LaunchTemplateId",
    #     launch_template_name: "LaunchTemplateName",
    #     source_version: "String",
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "KernelId",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "KmsKeyId",
    #             snapshot_id: "SnapshotId",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #             throughput: 1,
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_carrier_ip_address: false,
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["SecurityGroupId"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "NetworkInterfaceId",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "SubnetId",
    #           network_card_index: 1,
    #         },
    #       ],
    #       image_id: "ImageId",
    #       instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal
    #       key_name: "KeyPairName",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         affinity: "String",
    #         group_name: "PlacementGroupName",
    #         host_id: "DedicatedHostId",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #         host_resource_group_arn: "String",
    #         partition_number: 1,
    #       },
    #       ram_disk_id: "RamdiskId",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "String",
    #       tag_specifications: [
    #         {
    #           resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #           count: 1,
    #         },
    #       ],
    #       security_group_ids: ["SecurityGroupId"],
    #       security_groups: ["SecurityGroupName"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "open", # accepts open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "CapacityReservationId",
    #           capacity_reservation_resource_group_arn: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #       metadata_options: {
    #         http_tokens: "optional", # accepts optional, required
    #         http_put_response_hop_limit: 1,
    #         http_endpoint: "disabled", # accepts disabled, enabled
    #       },
    #       enclave_options: {
    #         enabled: false,
    #       },
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template_version.launch_template_id #=> String
    #   resp.launch_template_version.launch_template_name #=> String
    #   resp.launch_template_version.version_number #=> Integer
    #   resp.launch_template_version.version_description #=> String
    #   resp.launch_template_version.create_time #=> Time
    #   resp.launch_template_version.created_by #=> String
    #   resp.launch_template_version.default_version #=> Boolean
    #   resp.launch_template_version.launch_template_data.kernel_id #=> String
    #   resp.launch_template_version.launch_template_data.ebs_optimized #=> Boolean
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.arn #=> String
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings #=> Array
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].device_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].virtual_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].no_device #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].associate_carrier_ip_address #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].description #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].device_index #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].interface_type #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].network_interface_id #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].subnet_id #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].network_card_index #=> Integer
    #   resp.launch_template_version.launch_template_data.image_id #=> String
    #   resp.launch_template_version.launch_template_data.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.launch_template_version.launch_template_data.key_name #=> String
    #   resp.launch_template_version.launch_template_data.monitoring.enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.placement.availability_zone #=> String
    #   resp.launch_template_version.launch_template_data.placement.affinity #=> String
    #   resp.launch_template_version.launch_template_data.placement.group_name #=> String
    #   resp.launch_template_version.launch_template_data.placement.host_id #=> String
    #   resp.launch_template_version.launch_template_data.placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.launch_template_version.launch_template_data.placement.spread_domain #=> String
    #   resp.launch_template_version.launch_template_data.placement.host_resource_group_arn #=> String
    #   resp.launch_template_version.launch_template_data.placement.partition_number #=> Integer
    #   resp.launch_template_version.launch_template_data.ram_disk_id #=> String
    #   resp.launch_template_version.launch_template_data.disable_api_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.instance_initiated_shutdown_behavior #=> String, one of "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.user_data #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].resource_type #=> String, one of "client-vpn-endpoint", "customer-gateway", "dedicated-host", "dhcp-options", "egress-only-internet-gateway", "elastic-ip", "elastic-gpu", "export-image-task", "export-instance-task", "fleet", "fpga-image", "host-reservation", "image", "import-image-task", "import-snapshot-task", "instance", "internet-gateway", "key-pair", "launch-template", "local-gateway-route-table-vpc-association", "natgateway", "network-acl", "network-interface", "network-insights-analysis", "network-insights-path", "placement-group", "reserved-instances", "route-table", "security-group", "snapshot", "spot-fleet-request", "spot-instances-request", "subnet", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-connect-peer", "transit-gateway-multicast-domain", "transit-gateway-route-table", "volume", "vpc", "vpc-peering-connection", "vpn-connection", "vpn-gateway", "vpc-flow-log"
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].key #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].value #=> String
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications[0].type #=> String
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators[0].type #=> String
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators[0].count #=> Integer
    #   resp.launch_template_version.launch_template_data.security_group_ids #=> Array
    #   resp.launch_template_version.launch_template_data.security_group_ids[0] #=> String
    #   resp.launch_template_version.launch_template_data.security_groups #=> Array
    #   resp.launch_template_version.launch_template_data.security_groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.market_type #=> String, one of "spot"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.max_price #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.spot_instance_type #=> String, one of "one-time", "persistent"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.block_duration_minutes #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.valid_until #=> Time
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.credit_specification.cpu_credits #=> String
    #   resp.launch_template_version.launch_template_data.cpu_options.core_count #=> Integer
    #   resp.launch_template_version.launch_template_data.cpu_options.threads_per_core #=> Integer
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_preference #=> String, one of "open", "none"
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_resource_group_arn #=> String
    #   resp.launch_template_version.launch_template_data.license_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.license_specifications[0].license_configuration_arn #=> String
    #   resp.launch_template_version.launch_template_data.hibernation_options.configured #=> Boolean
    #   resp.launch_template_version.launch_template_data.metadata_options.state #=> String, one of "pending", "applied"
    #   resp.launch_template_version.launch_template_data.metadata_options.http_tokens #=> String, one of "optional", "required"
    #   resp.launch_template_version.launch_template_data.metadata_options.http_put_response_hop_limit #=> Integer
    #   resp.launch_template_version.launch_template_data.metadata_options.http_endpoint #=> String, one of "disabled", "enabled"
    #   resp.launch_template_version.launch_template_data.enclave_options.enabled #=> Boolean
    #   resp.warning.errors #=> Array
    #   resp.warning.errors[0].code #=> String
    #   resp.warning.errors[0].message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion AWS API Documentation
    #
    # @overload create_launch_template_version(params = {})
    # @param [Hash] params ({})
    def create_launch_template_version(params = {}, options = {})
      req = build_request(:create_launch_template_version, params)
      req.send_request(options)
    end

    # Creates a static route for the specified local gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :local_gateway_virtual_interface_group_id
    #   The ID of the virtual interface group.
    #
    # @return [Types::CreateLocalGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteResult#route #route} => Types::LocalGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route({
    #     destination_cidr_block: "String", # required
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     dry_run: false,
    #     local_gateway_virtual_interface_group_id: "LocalGatewayVirtualInterfaceGroupId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.local_gateway_virtual_interface_group_id #=> String
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #   resp.route.local_gateway_route_table_id #=> String
    #   resp.route.local_gateway_route_table_arn #=> String
    #   resp.route.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute AWS API Documentation
    #
    # @overload create_local_gateway_route(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route(params = {}, options = {})
      req = build_request(:create_local_gateway_route, params)
      req.send_request(options)
    end

    # Associates the specified VPC with the specified local gateway route
    # table.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the local gateway route table VPC association.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateLocalGatewayRouteTableVpcAssociationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteTableVpcAssociationResult#local_gateway_route_table_vpc_association #local_gateway_route_table_vpc_association} => Types::LocalGatewayRouteTableVpcAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route_table_vpc_association({
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_vpc_association_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_arn #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_id #=> String
    #   resp.local_gateway_route_table_vpc_association.vpc_id #=> String
    #   resp.local_gateway_route_table_vpc_association.owner_id #=> String
    #   resp.local_gateway_route_table_vpc_association.state #=> String
    #   resp.local_gateway_route_table_vpc_association.tags #=> Array
    #   resp.local_gateway_route_table_vpc_association.tags[0].key #=> String
    #   resp.local_gateway_route_table_vpc_association.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation AWS API Documentation
    #
    # @overload create_local_gateway_route_table_vpc_association(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route_table_vpc_association(params = {}, options = {})
      req = build_request(:create_local_gateway_route_table_vpc_association, params)
      req.send_request(options)
    end

    # Creates a managed prefix list. You can specify one or more entries for
    # the prefix list. Each entry consists of a CIDR block and an optional
    # description.
    #
    # You must specify the maximum number of entries for the prefix list.
    # The maximum number of entries cannot be changed later.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :prefix_list_name
    #   A name for the prefix list.
    #
    #   Constraints: Up to 255 characters in length. The name cannot start
    #   with `com.amazonaws`.
    #
    # @option params [Array<Types::AddPrefixListEntry>] :entries
    #   One or more entries for the prefix list.
    #
    # @option params [required, Integer] :max_entries
    #   The maximum number of entries for the prefix list.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the prefix list during creation.
    #
    # @option params [required, String] :address_family
    #   The IP address type.
    #
    #   Valid Values: `IPv4` \| `IPv6`
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraints: Up to 255 UTF-8 characters in length.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateManagedPrefixListResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateManagedPrefixListResult#prefix_list #prefix_list} => Types::ManagedPrefixList
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_managed_prefix_list({
    #     dry_run: false,
    #     prefix_list_name: "String", # required
    #     entries: [
    #       {
    #         cidr: "String", # required
    #         description: "String",
    #       },
    #     ],
    #     max_entries: 1, # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     address_family: "String", # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.prefix_list.prefix_list_id #=> String
    #   resp.prefix_list.address_family #=> String
    #   resp.prefix_list.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "restore-in-progress", "restore-complete", "restore-failed", "delete-in-progress", "delete-complete", "delete-failed"
    #   resp.prefix_list.state_message #=> String
    #   resp.prefix_list.prefix_list_arn #=> String
    #   resp.prefix_list.prefix_list_name #=> String
    #   resp.prefix_list.max_entries #=> Integer
    #   resp.prefix_list.version #=> Integer
    #   resp.prefix_list.tags #=> Array
    #   resp.prefix_list.tags[0].key #=> String
    #   resp.prefix_list.tags[0].value #=> String
    #   resp.prefix_list.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList AWS API Documentation
    #
    # @overload create_managed_prefix_list(params = {})
    # @param [Hash] params ({})
    def create_managed_prefix_list(params = {}, options = {})
      req = build_request(:create_managed_prefix_list, params)
      req.send_request(options)
    end

    # Creates a NAT gateway in the specified public subnet. This action
    # creates a network interface in the specified subnet with a private IP
    # address from the IP address range of the subnet. Internet-bound
    # traffic from a private subnet can be routed to the NAT gateway,
    # therefore enabling instances in the private subnet to connect to the
    # internet. For more information, see [NAT Gateways][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :subnet_id
    #   The subnet in which to create the NAT gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the NAT gateway.
    #
    # @option params [required, String] :allocation_id
    #   The allocation ID of an Elastic IP address to associate with the NAT
    #   gateway. If the Elastic IP address is associated with another
    #   resource, you must first disassociate it.
    #
    # @return [Types::CreateNatGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNatGatewayResult#client_token #client_token} => String
    #   * {Types::CreateNatGatewayResult#nat_gateway #nat_gateway} => Types::NatGateway
    #
    #
    # @example Example: To create a NAT gateway
    #
    #   # This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic IP address with the allocation ID
    #   # eipalloc-37fc1a52 with the NAT gateway.
    #
    #   resp = client.create_nat_gateway({
    #     allocation_id: "eipalloc-37fc1a52", 
    #     subnet_id: "subnet-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateway: {
    #       create_time: Time.parse("2015-12-17T12:45:26.732Z"), 
    #       nat_gateway_addresses: [
    #         {
    #           allocation_id: "eipalloc-37fc1a52", 
    #         }, 
    #       ], 
    #       nat_gateway_id: "nat-08d48af2a8e83edfd", 
    #       state: "pending", 
    #       subnet_id: "subnet-1a2b3c4d", 
    #       vpc_id: "vpc-1122aabb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_nat_gateway({
    #     client_token: "String",
    #     dry_run: false,
    #     subnet_id: "SubnetId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     allocation_id: "AllocationId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.nat_gateway.create_time #=> Time
    #   resp.nat_gateway.delete_time #=> Time
    #   resp.nat_gateway.failure_code #=> String
    #   resp.nat_gateway.failure_message #=> String
    #   resp.nat_gateway.nat_gateway_addresses #=> Array
    #   resp.nat_gateway.nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateway.nat_gateway_id #=> String
    #   resp.nat_gateway.provisioned_bandwidth.provision_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.provisioned #=> String
    #   resp.nat_gateway.provisioned_bandwidth.request_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.requested #=> String
    #   resp.nat_gateway.provisioned_bandwidth.status #=> String
    #   resp.nat_gateway.state #=> String, one of "pending", "failed", "available", "deleting", "deleted"
    #   resp.nat_gateway.subnet_id #=> String
    #   resp.nat_gateway.vpc_id #=> String
    #   resp.nat_gateway.tags #=> Array
    #   resp.nat_gateway.tags[0].key #=> String
    #   resp.nat_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway AWS API Documentation
    #
    # @overload create_nat_gateway(params = {})
    # @param [Hash] params ({})
    def create_nat_gateway(params = {}, options = {})
      req = build_request(:create_nat_gateway, params)
      req.send_request(options)
    end

    # Creates a network ACL in a VPC. Network ACLs provide an optional layer
    # of security (in addition to security groups) for the instances in your
    # VPC.
    #
    # For more information, see [Network ACLs][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the network ACL.
    #
    # @return [Types::CreateNetworkAclResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkAclResult#network_acl #network_acl} => Types::NetworkAcl
    #
    #
    # @example Example: To create a network ACL
    #
    #   # This example creates a network ACL for the specified VPC.
    #
    #   resp = client.create_network_acl({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_acl: {
    #       associations: [
    #       ], 
    #       entries: [
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: true, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: false, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #       ], 
    #       is_default: false, 
    #       network_acl_id: "acl-5fb85d36", 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl({
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.network_acl.associations #=> Array
    #   resp.network_acl.associations[0].network_acl_association_id #=> String
    #   resp.network_acl.associations[0].network_acl_id #=> String
    #   resp.network_acl.associations[0].subnet_id #=> String
    #   resp.network_acl.entries #=> Array
    #   resp.network_acl.entries[0].cidr_block #=> String
    #   resp.network_acl.entries[0].egress #=> Boolean
    #   resp.network_acl.entries[0].icmp_type_code.code #=> Integer
    #   resp.network_acl.entries[0].icmp_type_code.type #=> Integer
    #   resp.network_acl.entries[0].ipv_6_cidr_block #=> String
    #   resp.network_acl.entries[0].port_range.from #=> Integer
    #   resp.network_acl.entries[0].port_range.to #=> Integer
    #   resp.network_acl.entries[0].protocol #=> String
    #   resp.network_acl.entries[0].rule_action #=> String, one of "allow", "deny"
    #   resp.network_acl.entries[0].rule_number #=> Integer
    #   resp.network_acl.is_default #=> Boolean
    #   resp.network_acl.network_acl_id #=> String
    #   resp.network_acl.tags #=> Array
    #   resp.network_acl.tags[0].key #=> String
    #   resp.network_acl.tags[0].value #=> String
    #   resp.network_acl.vpc_id #=> String
    #   resp.network_acl.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl AWS API Documentation
    #
    # @overload create_network_acl(params = {})
    # @param [Hash] params ({})
    def create_network_acl(params = {}, options = {})
      req = build_request(:create_network_acl, params)
      req.send_request(options)
    end

    # Creates an entry (a rule) in a network ACL with the specified rule
    # number. Each network ACL has a set of numbered ingress rules and a
    # separate set of numbered egress rules. When determining whether a
    # packet should be allowed in or out of a subnet associated with the
    # ACL, we process the entries in the ACL according to the rule numbers,
    # in ascending order. Each network ACL has a set of ingress rules and a
    # separate set of egress rules.
    #
    # We recommend that you leave room between the rule numbers (for
    # example, 100, 110, 120, ...), and not number them one right after the
    # other (for example, 101, 102, 103, ...). This makes it easier to add a
    # rule between existing ones without having to renumber the rules.
    #
    # After you add an entry, you can't modify it; you must either replace
    # it, or create an entry and delete the old one.
    #
    # For more information about network ACLs, see [Network ACLs][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html
    #
    # @option params [String] :cidr_block
    #   The IPv4 network range to allow or deny, in CIDR notation (for example
    #   `172.16.0.0/24`). We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Boolean] :egress
    #   Indicates whether this is an egress rule (rule is applied to traffic
    #   leaving the subnet).
    #
    # @option params [Types::IcmpTypeCode] :icmp_type_code
    #   ICMP protocol: The ICMP or ICMPv6 type and code. Required if
    #   specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR
    #   block.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range to allow or deny, in CIDR notation (for example
    #   `2001:db8:1234:1a00::/64`).
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @option params [Types::PortRange] :port_range
    #   TCP or UDP protocols: The range of ports the rule applies to. Required
    #   if specifying protocol 6 (TCP) or 17 (UDP).
    #
    # @option params [required, String] :protocol
    #   The protocol number. A value of "-1" means all protocols. If you
    #   specify "-1" or a protocol number other than "6" (TCP), "17"
    #   (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of
    #   any ports or ICMP types or codes that you specify. If you specify
    #   protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
    #   all ICMP types and codes allowed, regardless of any that you specify.
    #   If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
    #   block, you must specify an ICMP type and code.
    #
    # @option params [required, String] :rule_action
    #   Indicates whether to allow or deny the traffic that matches the rule.
    #
    # @option params [required, Integer] :rule_number
    #   The rule number for the entry (for example, 100). ACL entries are
    #   processed in ascending order by rule number.
    #
    #   Constraints: Positive integer from 1 to 32766. The range 32767 to
    #   65535 is reserved for internal use.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To create a network ACL entry
    #
    #   # This example creates an entry for the specified network ACL. The rule allows ingress traffic from anywhere (0.0.0.0/0)
    #   # on UDP port 53 (DNS) into any associated subnet.
    #
    #   resp = client.create_network_acl_entry({
    #     cidr_block: "0.0.0.0/0", 
    #     egress: false, 
    #     network_acl_id: "acl-5fb85d36", 
    #     port_range: {
    #       from: 53, 
    #       to: 53, 
    #     }, 
    #     protocol: "17", 
    #     rule_action: "allow", 
    #     rule_number: 100, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl_entry({
    #     cidr_block: "String",
    #     dry_run: false,
    #     egress: false, # required
    #     icmp_type_code: {
    #       code: 1,
    #       type: 1,
    #     },
    #     ipv_6_cidr_block: "String",
    #     network_acl_id: "NetworkAclId", # required
    #     port_range: {
    #       from: 1,
    #       to: 1,
    #     },
    #     protocol: "String", # required
    #     rule_action: "allow", # required, accepts allow, deny
    #     rule_number: 1, # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry AWS API Documentation
    #
    # @overload create_network_acl_entry(params = {})
    # @param [Hash] params ({})
    def create_network_acl_entry(params = {}, options = {})
      req = build_request(:create_network_acl_entry, params)
      req.send_request(options)
    end

    # Creates a path to analyze for reachability.
    #
    # Reachability Analyzer enables you to analyze and debug network
    # reachability between two resources in your virtual private cloud
    # (VPC). For more information, see [What is Reachability Analyzer][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/reachability/
    #
    # @option params [String] :source_ip
    #   The IP address of the AWS resource that is the source of the path.
    #
    # @option params [String] :destination_ip
    #   The IP address of the AWS resource that is the destination of the
    #   path.
    #
    # @option params [required, String] :source
    #   The AWS resource that is the source of the path.
    #
    # @option params [required, String] :destination
    #   The AWS resource that is the destination of the path.
    #
    # @option params [required, String] :protocol
    #   The protocol.
    #
    # @option params [Integer] :destination_port
    #   The destination port.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to add to the path.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateNetworkInsightsPathResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInsightsPathResult#network_insights_path #network_insights_path} => Types::NetworkInsightsPath
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_insights_path({
    #     source_ip: "IpAddress",
    #     destination_ip: "IpAddress",
    #     source: "String", # required
    #     destination: "String", # required
    #     protocol: "tcp", # required, accepts tcp, udp
    #     destination_port: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_insights_path.network_insights_path_id #=> String
    #   resp.network_insights_path.network_insights_path_arn #=> String
    #   resp.network_insights_path.created_date #=> Time
    #   resp.network_insights_path.source #=> String
    #   resp.network_insights_path.destination #=> String
    #   resp.network_insights_path.source_ip #=> String
    #   resp.network_insights_path.destination_ip #=> String
    #   resp.network_insights_path.protocol #=> String, one of "tcp", "udp"
    #   resp.network_insights_path.destination_port #=> Integer
    #   resp.network_insights_path.tags #=> Array
    #   resp.network_insights_path.tags[0].key #=> String
    #   resp.network_insights_path.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath AWS API Documentation
    #
    # @overload create_network_insights_path(params = {})
    # @param [Hash] params ({})
    def create_network_insights_path(params = {}, options = {})
      req = build_request(:create_network_insights_path, params)
      req.send_request(options)
    end

    # Creates a network interface in the specified subnet.
    #
    # For more information about network interfaces, see [Elastic Network
    # Interfaces][1] in the *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
    #
    # @option params [String] :description
    #   A description for the network interface.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :groups
    #   The IDs of one or more security groups.
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of IPv6 addresses to assign to a network interface. Amazon
    #   EC2 automatically selects the IPv6 addresses from the subnet range.
    #   You can't use this option if specifying specific IPv6 addresses. If
    #   your subnet has the `AssignIpv6AddressOnCreation` attribute set to
    #   `true`, you can specify `0` to override this setting.
    #
    # @option params [Array<Types::InstanceIpv6Address>] :ipv_6_addresses
    #   One or more specific IPv6 addresses from the IPv6 CIDR block range of
    #   your subnet. You can't use this option if you're specifying a number
    #   of IPv6 addresses.
    #
    # @option params [String] :private_ip_address
    #   The primary private IPv4 address of the network interface. If you
    #   don't specify an IPv4 address, Amazon EC2 selects one for you from
    #   the subnet's IPv4 CIDR range. If you specify an IP address, you
    #   cannot indicate any IP addresses specified in `privateIpAddresses` as
    #   primary (only one IP address can be designated as primary).
    #
    # @option params [Array<Types::PrivateIpAddressSpecification>] :private_ip_addresses
    #   One or more private IPv4 addresses.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary private IPv4 addresses to assign to a network
    #   interface. When you specify a number of secondary IPv4 addresses,
    #   Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR
    #   range. You can't specify this option and specify more than one
    #   private IP address using `privateIpAddresses`.
    #
    #   The number of IP addresses you can assign to a network interface
    #   varies by instance type. For more information, see [IP Addresses Per
    #   ENI Per Instance Type][1] in the *Amazon Virtual Private Cloud User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
    #
    # @option params [String] :interface_type
    #   Indicates the type of network interface. To create an Elastic Fabric
    #   Adapter (EFA), specify `efa`. For more information, see [ Elastic
    #   Fabric Adapter][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the network interface.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new network interface.
    #
    # @return [Types::CreateNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfaceResult#network_interface #network_interface} => Types::NetworkInterface
    #
    #
    # @example Example: To create a network interface
    #
    #   # This example creates a network interface for the specified subnet.
    #
    #   resp = client.create_network_interface({
    #     description: "my network interface", 
    #     groups: [
    #       "sg-903004f8", 
    #     ], 
    #     private_ip_address: "10.0.2.17", 
    #     subnet_id: "subnet-9d4a7b6c", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_interface: {
    #       availability_zone: "us-east-1d", 
    #       description: "my network interface", 
    #       groups: [
    #         {
    #           group_id: "sg-903004f8", 
    #           group_name: "default", 
    #         }, 
    #       ], 
    #       mac_address: "02:1a:80:41:52:9c", 
    #       network_interface_id: "eni-e5aa89a3", 
    #       owner_id: "123456789012", 
    #       private_ip_address: "10.0.2.17", 
    #       private_ip_addresses: [
    #         {
    #           primary: true, 
    #           private_ip_address: "10.0.2.17", 
    #         }, 
    #       ], 
    #       requester_managed: false, 
    #       source_dest_check: true, 
    #       status: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       tag_set: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface({
    #     description: "String",
    #     dry_run: false,
    #     groups: ["SecurityGroupId"],
    #     ipv_6_address_count: 1,
    #     ipv_6_addresses: [
    #       {
    #         ipv_6_address: "String",
    #       },
    #     ],
    #     private_ip_address: "String",
    #     private_ip_addresses: [
    #       {
    #         primary: false,
    #         private_ip_address: "String",
    #       },
    #     ],
    #     secondary_private_ip_address_count: 1,
    #     interface_type: "efa", # accepts efa
    #     subnet_id: "SubnetId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface.association.allocation_id #=> String
    #   resp.network_interface.association.association_id #=> String
    #   resp.network_interface.association.ip_owner_id #=> String
    #   resp.network_interface.association.public_dns_name #=> String
    #   resp.network_interface.association.public_ip #=> String
    #   resp.network_interface.association.customer_owned_ip #=> String
    #   resp.network_interface.association.carrier_ip #=> String
    #   resp.network_interface.attachment.attach_time #=> Time
    #   resp.network_interface.attachment.attachment_id #=> String
    #   resp.network_interface.attachment.delete_on_termination #=> Boolean
    #   resp.network_interface.attachment.device_index #=> Integer
    #   resp.network_interface.attachment.network_card_index #=> Integer
    #   resp.network_interface.attachment.instance_id #=> String
    #   resp.network_interface.attachment.instance_owner_id #=> String
    #   resp.network_interface.attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.network_interface.availability_zone #=> String
    #   resp.network_interface.description #=> String
    #   resp.network_interface.groups #=> Array
    #   resp.network_interface.groups[0].group_name #=> String
    #   resp.network_interface.groups[0].group_id #=> String
    #   resp.network_interface.interface_type #=> String, one of "interface", "natGateway", "efa"
    #   resp.network_interface.ipv_6_addresses #=> Array
    #   resp.network_interface.ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.network_interface.mac_address #=> String
    #   resp.network_interface.network_interface_id #=> String
    #   resp.network_interface.outpost_arn #=> String
    #   resp.network_interface.owner_id #=> String
    #   resp.network_interface.private_dns_name #=> String
    #   resp.network_interface.private_ip_address #=> String
    #   resp.network_interface.private_ip_addresses #=> Array
    #   resp.network_interface.private_ip_addresses[0].association.allocation_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.association_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].association.customer_owned_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].association.carrier_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].primary #=> Boolean
    #   resp.network_interface.private_ip_addresses[0].private_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].private_ip_address #=> String
    #   resp.network_interface.requester_id #=> String
    #   resp.network_interface.requester_managed #=> Boolean
    #   resp.network_interface.source_dest_check #=> Boolean
    #   resp.network_interface.status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.network_interface.subnet_id #=> String
    #   resp.network_interface.tag_set #=> Array
    #   resp.network_interface.tag_set[0].key #=> String
    #   resp.network_interface.tag_set[0].value #=> String
    #   resp.network_interface.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface AWS API Documentation
    #
    # @overload create_network_interface(params = {})
    # @param [Hash] params ({})
    def create_network_interface(params = {}, options = {})
      req = build_request(:create_network_interface, params)
      req.send_request(options)
    end

    # Grants an AWS-authorized account permission to attach the specified
    # network interface to an instance in their account.
    #
    # You can grant permission to a single AWS account only, and only one
    # account at a time.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [String] :aws_account_id
    #   The AWS account ID.
    #
    # @option params [String] :aws_service
    #   The AWS service. Currently not supported.
    #
    # @option params [required, String] :permission
    #   The type of permission to grant.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateNetworkInterfacePermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfacePermissionResult#interface_permission #interface_permission} => Types::NetworkInterfacePermission
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface_permission({
    #     network_interface_id: "NetworkInterfaceId", # required
    #     aws_account_id: "String",
    #     aws_service: "String",
    #     permission: "INSTANCE-ATTACH", # required, accepts INSTANCE-ATTACH, EIP-ASSOCIATE
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.interface_permission.network_interface_permission_id #=> String
    #   resp.interface_permission.network_interface_id #=> String
    #   resp.interface_permission.aws_account_id #=> String
    #   resp.interface_permission.aws_service #=> String
    #   resp.interface_permission.permission #=> String, one of "INSTANCE-ATTACH", "EIP-ASSOCIATE"
    #   resp.interface_permission.permission_state.state #=> String, one of "pending", "granted", "revoking", "revoked"
    #   resp.interface_permission.permission_state.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission AWS API Documentation
    #
    # @overload create_network_interface_permission(params = {})
    # @param [Hash] params ({})
    def create_network_interface_permission(params = {}, options = {})
      req = build_request(:create_network_interface_permission, params)
      req.send_request(options)
    end

    # Creates a placement group in which to launch instances. The strategy
    # of the placement group determines how the instances are organized
    # within the group.
    #
    # A `cluster` placement group is a logical grouping of instances within
    # a single Availability Zone that benefit from low network latency, high
    # network throughput. A `spread` placement group places instances on
    # distinct hardware. A `partition` placement group places groups of
    # instances in different partitions, where instances in one partition do
    # not share the same hardware with instances in another partition.
    #
    # For more information, see [Placement groups][1] in the *Amazon EC2
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :group_name
    #   A name for the placement group. Must be unique within the scope of
    #   your account for the Region.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [String] :strategy
    #   The placement strategy.
    #
    # @option params [Integer] :partition_count
    #   The number of partitions. Valid only when **Strategy** is set to
    #   `partition`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new placement group.
    #
    # @return [Types::CreatePlacementGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreatePlacementGroupResult#placement_group #placement_group} => Types::PlacementGroup
    #
    #
    # @example Example: To create a placement group
    #
    #   # This example creates a placement group with the specified name.
    #
    #   resp = client.create_placement_group({
    #     group_name: "my-cluster", 
    #     strategy: "cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_placement_group({
    #     dry_run: false,
    #     group_name: "String",
    #     strategy: "cluster", # accepts cluster, spread, partition
    #     partition_count: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.placement_group.group_name #=> String
    #   resp.placement_group.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.placement_group.strategy #=> String, one of "cluster", "spread", "partition"
    #   resp.placement_group.partition_count #=> Integer
    #   resp.placement_group.group_id #=> String
    #   resp.placement_group.tags #=> Array
    #   resp.placement_group.tags[0].key #=> String
    #   resp.placement_group.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup AWS API Documentation
    #
    # @overload create_placement_group(params = {})
    # @param [Hash] params ({})
    def create_placement_group(params = {}, options = {})
      req = build_request(:create_placement_group, params)
      req.send_request(options)
    end

    # Creates a root volume replacement task for an Amazon EC2 instance. The
    # root volume can either be restored to its initial launch state, or it
    # can be restored using a specific snapshot.
    #
    # For more information, see [Replace a root volume][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance for which to replace the root volume.
    #
    # @option params [String] :snapshot_id
    #   The ID of the snapshot from which to restore the replacement root
    #   volume. If you want to restore the volume to the initial launch state,
    #   omit this parameter.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If you do not specify a client token, a
    #   randomly generated token is used for the request to ensure
    #   idempotency. For more information, see [Ensuring Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the root volume replacement task.
    #
    # @return [Types::CreateReplaceRootVolumeTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateReplaceRootVolumeTaskResult#replace_root_volume_task #replace_root_volume_task} => Types::ReplaceRootVolumeTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_replace_root_volume_task({
    #     instance_id: "InstanceId", # required
    #     snapshot_id: "SnapshotId",
    #     client_token: "String",
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.replace_root_volume_task.replace_root_volume_task_id #=> String
    #   resp.replace_root_volume_task.instance_id #=> String
    #   resp.replace_root_volume_task.task_state #=> String, one of "pending", "in-progress", "failing", "succeeded", "failed", "failed-detached"
    #   resp.replace_root_volume_task.start_time #=> String
    #   resp.replace_root_volume_task.complete_time #=> String
    #   resp.replace_root_volume_task.tags #=> Array
    #   resp.replace_root_volume_task.tags[0].key #=> String
    #   resp.replace_root_volume_task.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask AWS API Documentation
    #
    # @overload create_replace_root_volume_task(params = {})
    # @param [Hash] params ({})
    def create_replace_root_volume_task(params = {}, options = {})
      req = build_request(:create_replace_root_volume_task, params)
      req.send_request(options)
    end

    # Creates a listing for Amazon EC2 Standard Reserved Instances to be
    # sold in the Reserved Instance Marketplace. You can submit one Standard
    # Reserved Instance listing at a time. To get a list of your Standard
    # Reserved Instances, you can use the DescribeReservedInstances
    # operation.
    #
    # <note markdown="1"> Only Standard Reserved Instances can be sold in the Reserved Instance
    # Marketplace. Convertible Reserved Instances cannot be sold.
    #
    #  </note>
    #
    # The Reserved Instance Marketplace matches sellers who want to resell
    # Standard Reserved Instance capacity that they no longer need with
    # buyers who want to purchase additional capacity. Reserved Instances
    # bought and sold through the Reserved Instance Marketplace work like
    # any other Reserved Instances.
    #
    # To sell your Standard Reserved Instances, you must first register as a
    # seller in the Reserved Instance Marketplace. After completing the
    # registration process, you can create a Reserved Instance Marketplace
    # listing of some or all of your Standard Reserved Instances, and
    # specify the upfront price to receive for them. Your Standard Reserved
    # Instance listings then become available for purchase. To view the
    # details of your Standard Reserved Instance listing, you can use the
    # DescribeReservedInstancesListings operation.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   your listings. This helps avoid duplicate listings. For more
    #   information, see [Ensuring Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances that are a part of a Reserved Instance account
    #   to be listed in the Reserved Instance Marketplace. This number should
    #   be less than or equal to the instance count associated with the
    #   Reserved Instance ID specified in this call.
    #
    # @option params [required, Array<Types::PriceScheduleSpecification>] :price_schedules
    #   A list specifying the price of the Standard Reserved Instance for each
    #   month remaining in the Reserved Instance term.
    #
    # @option params [required, String] :reserved_instances_id
    #   The ID of the active Standard Reserved Instance.
    #
    # @return [Types::CreateReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_reserved_instances_listing({
    #     client_token: "String", # required
    #     instance_count: 1, # required
    #     price_schedules: [ # required
    #       {
    #         currency_code: "USD", # accepts USD
    #         price: 1.0,
    #         term: 1,
    #       },
    #     ],
    #     reserved_instances_id: "ReservationId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing AWS API Documentation
    #
    # @overload create_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def create_reserved_instances_listing(params = {}, options = {})
      req = build_request(:create_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Starts a task that restores an AMI from an S3 object that was
    # previously created by using [CreateStoreImageTask][1].
    #
    # To use this API, you must have the required permissions. For more
    # information, see [Permissions for storing and restoring AMIs using
    # S3][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # For more information, see [Store and restore an AMI using S3][3] in
    # the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html
    #
    # @option params [required, String] :bucket
    #   The name of the S3 bucket that contains the stored AMI object.
    #
    # @option params [required, String] :object_key
    #   The name of the stored AMI object in the bucket.
    #
    # @option params [String] :name
    #   The name for the restored AMI. The name must be unique for AMIs in the
    #   Region for this account. If you do not provide a name, the new AMI
    #   gets the same name as the original AMI.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the AMI and snapshots on restoration. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots, the value for `ResourceType` must be
    #     `snapshot`. The same tag is applied to all of the snapshots that are
    #     created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateRestoreImageTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRestoreImageTaskResult#image_id #image_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_restore_image_task({
    #     bucket: "String", # required
    #     object_key: "String", # required
    #     name: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask AWS API Documentation
    #
    # @overload create_restore_image_task(params = {})
    # @param [Hash] params ({})
    def create_restore_image_task(params = {}, options = {})
      req = build_request(:create_restore_image_task, params)
      req.send_request(options)
    end

    # Creates a route in a route table within a VPC.
    #
    # You must specify one of the following targets: internet gateway or
    # virtual private gateway, NAT instance, NAT gateway, VPC peering
    # connection, network interface, egress-only internet gateway, or
    # transit gateway.
    #
    # When determining how to route traffic, we use the route with the most
    # specific match. For example, traffic is destined for the IPv4 address
    # `192.0.2.3`, and the route table includes the following two IPv4
    # routes:
    #
    # * `192.0.2.0/24` (goes to some target A)
    #
    # * `192.0.2.0/28` (goes to some target B)
    #
    # Both routes apply to the traffic destined for `192.0.2.3`. However,
    # the second route in the list covers a smaller number of IP addresses
    # and is therefore more specific, so we use that route to determine
    # where to target the traffic.
    #
    # For more information about route tables, see [Route Tables][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [String] :destination_cidr_block
    #   The IPv4 CIDR address block used for the destination match. Routing
    #   decisions are based on the most specific match. We modify the
    #   specified CIDR block to its canonical form; for example, if you
    #   specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
    #
    # @option params [String] :destination_ipv_6_cidr_block
    #   The IPv6 CIDR block used for the destination match. Routing decisions
    #   are based on the most specific match.
    #
    # @option params [String] :destination_prefix_list_id
    #   The ID of a prefix list used for the destination match.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :vpc_endpoint_id
    #   The ID of a VPC endpoint. Supported for Gateway Load Balancer
    #   endpoints only.
    #
    # @option params [String] :egress_only_internet_gateway_id
    #   \[IPv6 traffic only\] The ID of an egress-only internet gateway.
    #
    # @option params [String] :gateway_id
    #   The ID of an internet gateway or virtual private gateway attached to
    #   your VPC.
    #
    # @option params [String] :instance_id
    #   The ID of a NAT instance in your VPC. The operation fails if you
    #   specify an instance ID unless exactly one network interface is
    #   attached.
    #
    # @option params [String] :nat_gateway_id
    #   \[IPv4 traffic only\] The ID of a NAT gateway.
    #
    # @option params [String] :transit_gateway_id
    #   The ID of a transit gateway.
    #
    # @option params [String] :local_gateway_id
    #   The ID of the local gateway.
    #
    # @option params [String] :carrier_gateway_id
    #   The ID of the carrier gateway.
    #
    #   You can only use this option when the VPC contains a subnet which is
    #   associated with a Wavelength Zone.
    #
    # @option params [String] :network_interface_id
    #   The ID of a network interface.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table for the route.
    #
    # @option params [String] :vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #
    # @return [Types::CreateRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteResult#return #return} => Boolean
    #
    #
    # @example Example: To create a route
    #
    #   # This example creates a route for the specified route table. The route matches all traffic (0.0.0.0/0) and routes it to
    #   # the specified Internet gateway.
    #
    #   resp = client.create_route({
    #     destination_cidr_block: "0.0.0.0/0", 
    #     gateway_id: "igw-c0a643a9", 
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route({
    #     destination_cidr_block: "String",
    #     destination_ipv_6_cidr_block: "String",
    #     destination_prefix_list_id: "PrefixListResourceId",
    #     dry_run: false,
    #     vpc_endpoint_id: "VpcEndpointId",
    #     egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId",
    #     gateway_id: "RouteGatewayId",
    #     instance_id: "InstanceId",
    #     nat_gateway_id: "NatGatewayId",
    #     transit_gateway_id: "TransitGatewayId",
    #     local_gateway_id: "LocalGatewayId",
    #     carrier_gateway_id: "CarrierGatewayId",
    #     network_interface_id: "NetworkInterfaceId",
    #     route_table_id: "RouteTableId", # required
    #     vpc_peering_connection_id: "VpcPeeringConnectionId",
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute AWS API Documentation
    #
    # @overload create_route(params = {})
    # @param [Hash] params ({})
    def create_route(params = {}, options = {})
      req = build_request(:create_route, params)
      req.send_request(options)
    end

    # Creates a route table for the specified VPC. After you create a route
    # table, you can add routes and associate the table with a subnet.
    #
    # For more information, see [Route Tables][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the route table.
    #
    # @return [Types::CreateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteTableResult#route_table #route_table} => Types::RouteTable
    #
    #
    # @example Example: To create a route table
    #
    #   # This example creates a route table for the specified VPC.
    #
    #   resp = client.create_route_table({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     route_table: {
    #       associations: [
    #       ], 
    #       propagating_vgws: [
    #       ], 
    #       route_table_id: "rtb-22574640", 
    #       routes: [
    #         {
    #           destination_cidr_block: "10.0.0.0/16", 
    #           gateway_id: "local", 
    #           state: "active", 
    #         }, 
    #       ], 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_table({
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.route_table.associations #=> Array
    #   resp.route_table.associations[0].main #=> Boolean
    #   resp.route_table.associations[0].route_table_association_id #=> String
    #   resp.route_table.associations[0].route_table_id #=> String
    #   resp.route_table.associations[0].subnet_id #=> String
    #   resp.route_table.associations[0].gateway_id #=> String
    #   resp.route_table.associations[0].association_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failed"
    #   resp.route_table.associations[0].association_state.status_message #=> String
    #   resp.route_table.propagating_vgws #=> Array
    #   resp.route_table.propagating_vgws[0].gateway_id #=> String
    #   resp.route_table.route_table_id #=> String
    #   resp.route_table.routes #=> Array
    #   resp.route_table.routes[0].destination_cidr_block #=> String
    #   resp.route_table.routes[0].destination_ipv_6_cidr_block #=> String
    #   resp.route_table.routes[0].destination_prefix_list_id #=> String
    #   resp.route_table.routes[0].egress_only_internet_gateway_id #=> String
    #   resp.route_table.routes[0].gateway_id #=> String
    #   resp.route_table.routes[0].instance_id #=> String
    #   resp.route_table.routes[0].instance_owner_id #=> String
    #   resp.route_table.routes[0].nat_gateway_id #=> String
    #   resp.route_table.routes[0].transit_gateway_id #=> String
    #   resp.route_table.routes[0].local_gateway_id #=> String
    #   resp.route_table.routes[0].carrier_gateway_id #=> String
    #   resp.route_table.routes[0].network_interface_id #=> String
    #   resp.route_table.routes[0].origin #=> String, one of "CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation"
    #   resp.route_table.routes[0].state #=> String, one of "active", "blackhole"
    #   resp.route_table.routes[0].vpc_peering_connection_id #=> String
    #   resp.route_table.tags #=> Array
    #   resp.route_table.tags[0].key #=> String
    #   resp.route_table.tags[0].value #=> String
    #   resp.route_table.vpc_id #=> String
    #   resp.route_table.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable AWS API Documentation
    #
    # @overload create_route_table(params = {})
    # @param [Hash] params ({})
    def create_route_table(params = {}, options = {})
      req = build_request(:create_route_table, params)
      req.send_request(options)
    end

    # Creates a security group.
    #
    # A security group acts as a virtual firewall for your instance to
    # control inbound and outbound traffic. For more information, see
    # [Amazon EC2 Security Groups][1] in the *Amazon Elastic Compute Cloud
    # User Guide* and [Security Groups for Your VPC][2] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    # When you create a security group, you specify a friendly name of your
    # choice. You can have a security group for use in EC2-Classic with the
    # same name as a security group for use in a VPC. However, you can't
    # have two security groups for use in EC2-Classic with the same name or
    # two security groups for use in a VPC with the same name.
    #
    # You have a default security group for use in EC2-Classic and a default
    # security group for use in your VPC. If you don't specify a security
    # group when you launch an instance, the instance is launched into the
    # appropriate default security group. A default security group includes
    # a default rule that grants instances unrestricted network access to
    # each other.
    #
    # You can add or remove rules from your security groups using
    # AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
    # RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][3].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html
    # [2]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [required, String] :description
    #   A description for the security group. This is informational only.
    #
    #   Constraints: Up to 255 characters in length
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #
    # @option params [required, String] :group_name
    #   The name of the security group.
    #
    #   Constraints: Up to 255 characters in length. Cannot start with `sg-`.
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #
    # @option params [String] :vpc_id
    #   \[EC2-VPC\] The ID of the VPC. Required for EC2-VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the security group.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateSecurityGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSecurityGroupResult#group_id #group_id} => String
    #   * {Types::CreateSecurityGroupResult#tags #tags} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To create a security group for a VPC
    #
    #   # This example creates a security group for the specified VPC.
    #
    #   resp = client.create_security_group({
    #     description: "My security group", 
    #     group_name: "my-security-group", 
    #     vpc_id: "vpc-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     group_id: "sg-903004f8", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_security_group({
    #     description: "String", # required
    #     group_name: "String", # required
    #     vpc_id: "VpcId",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.group_id #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup AWS API Documentation
    #
    # @overload create_security_group(params = {})
    # @param [Hash] params ({})
    def create_security_group(params = {}, options = {})
      req = build_request(:create_security_group, params)
      req.send_request(options)
    end

    # Creates a snapshot of an EBS volume and stores it in Amazon S3. You
    # can use snapshots for backups, to make copies of EBS volumes, and to
    # save data before shutting down an instance.
    #
    # You can create snapshots of volumes in a Region and volumes on an
    # Outpost. If you create a snapshot of a volume in a Region, the
    # snapshot must be stored in the same Region as the volume. If you
    # create a snapshot of a volume on an Outpost, the snapshot can be
    # stored on the same Outpost as the volume, or in the Region for that
    # Outpost.
    #
    # When a snapshot is created, any AWS Marketplace product codes that are
    # associated with the source volume are propagated to the snapshot.
    #
    # You can take a snapshot of an attached volume that is in use. However,
    # snapshots only capture data that has been written to your EBS volume
    # at the time the snapshot command is issued; this might exclude any
    # data that has been cached by any applications or the operating system.
    # If you can pause any file systems on the volume long enough to take a
    # snapshot, your snapshot should be complete. However, if you cannot
    # pause all file writes to the volume, you should unmount the volume
    # from within the instance, issue the snapshot command, and then remount
    # the volume to ensure a consistent and complete snapshot. You may
    # remount and use your volume while the snapshot status is `pending`.
    #
    # To create a snapshot for EBS volumes that serve as root devices, you
    # should stop the instance before taking the snapshot.
    #
    # Snapshots that are taken from encrypted volumes are automatically
    # encrypted. Volumes that are created from encrypted snapshots are also
    # automatically encrypted. Your encrypted volumes and any associated
    # snapshots always remain protected.
    #
    # You can tag your snapshots during creation. For more information, see
    # [Tagging your Amazon EC2 resources][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # For more information, see [Amazon Elastic Block Store][2] and [Amazon
    # EBS encryption][3] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :description
    #   A description for the snapshot.
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the AWS Outpost on which to create a
    #   local snapshot.
    #
    #   * To create a snapshot of a volume in a Region, omit this parameter.
    #     The snapshot is created in the same Region as the volume.
    #
    #   * To create a snapshot of a volume on an Outpost and store the
    #     snapshot in the Region, omit this parameter. The snapshot is created
    #     in the Region for the Outpost.
    #
    #   * To create a snapshot of a volume on an Outpost and store the
    #     snapshot on an Outpost, specify the ARN of the destination Outpost.
    #     The snapshot must be created on the same Outpost as the volume.
    #
    #   For more information, see [ Creating local snapshots from volumes on
    #   an Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot
    #
    # @option params [required, String] :volume_id
    #   The ID of the EBS volume.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the snapshot during creation.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::Snapshot] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Snapshot#data_encryption_key_id #data_encryption_key_id} => String
    #   * {Types::Snapshot#description #description} => String
    #   * {Types::Snapshot#encrypted #encrypted} => Boolean
    #   * {Types::Snapshot#kms_key_id #kms_key_id} => String
    #   * {Types::Snapshot#owner_id #owner_id} => String
    #   * {Types::Snapshot#progress #progress} => String
    #   * {Types::Snapshot#snapshot_id #snapshot_id} => String
    #   * {Types::Snapshot#start_time #start_time} => Time
    #   * {Types::Snapshot#state #state} => String
    #   * {Types::Snapshot#state_message #state_message} => String
    #   * {Types::Snapshot#volume_id #volume_id} => String
    #   * {Types::Snapshot#volume_size #volume_size} => Integer
    #   * {Types::Snapshot#owner_alias #owner_alias} => String
    #   * {Types::Snapshot#outpost_arn #outpost_arn} => String
    #   * {Types::Snapshot#tags #tags} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To create a snapshot
    #
    #   # This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0`` and a short description to
    #   # identify the snapshot.
    #
    #   resp = client.create_snapshot({
    #     description: "This is my root volume snapshot.", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     description: "This is my root volume snapshot.", 
    #     owner_id: "012345678910", 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     start_time: Time.parse("2014-02-28T21:06:01.000Z"), 
    #     state: "pending", 
    #     tags: [
    #     ], 
    #     volume_id: "vol-1234567890abcdef0", 
    #     volume_size: 8, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshot({
    #     description: "String",
    #     outpost_arn: "String",
    #     volume_id: "VolumeId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.data_encryption_key_id #=> String
    #   resp.description #=> String
    #   resp.encrypted #=> Boolean
    #   resp.kms_key_id #=> String
    #   resp.owner_id #=> String
    #   resp.progress #=> String
    #   resp.snapshot_id #=> String
    #   resp.start_time #=> Time
    #   resp.state #=> String, one of "pending", "completed", "error"
    #   resp.state_message #=> String
    #   resp.volume_id #=> String
    #   resp.volume_size #=> Integer
    #   resp.owner_alias #=> String
    #   resp.outpost_arn #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot AWS API Documentation
    #
    # @overload create_snapshot(params = {})
    # @param [Hash] params ({})
    def create_snapshot(params = {}, options = {})
      req = build_request(:create_snapshot, params)
      req.send_request(options)
    end

    # Creates crash-consistent snapshots of multiple EBS volumes and stores
    # the data in S3. Volumes are chosen by specifying an instance. Any
    # attached volumes will produce one snapshot each that is
    # crash-consistent across the instance. Boot volumes can be excluded by
    # changing the parameters.
    #
    # You can create multi-volume snapshots of instances in a Region and
    # instances on an Outpost. If you create snapshots from an instance in a
    # Region, the snapshots must be stored in the same Region as the
    # instance. If you create snapshots from an instance on an Outpost, the
    # snapshots can be stored on the same Outpost as the instance, or in the
    # Region for that Outpost.
    #
    # @option params [String] :description
    #   A description propagated to every snapshot specified by the instance.
    #
    # @option params [required, Types::InstanceSpecification] :instance_specification
    #   The instance to specify which volumes should be included in the
    #   snapshots.
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the AWS Outpost on which to create
    #   the local snapshots.
    #
    #   * To create snapshots from an instance in a Region, omit this
    #     parameter. The snapshots are created in the same Region as the
    #     instance.
    #
    #   * To create snapshots from an instance on an Outpost and store the
    #     snapshots in the Region, omit this parameter. The snapshots are
    #     created in the Region for the Outpost.
    #
    #   * To create snapshots from an instance on an Outpost and store the
    #     snapshots on an Outpost, specify the ARN of the destination Outpost.
    #     The snapshots must be created on the same Outpost as the instance.
    #
    #   For more information, see [ Creating multi-volume local snapshots from
    #   instances on an Outpost][1] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Tags to apply to every snapshot specified by the instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :copy_tags_from_source
    #   Copies the tags from the specified volume to corresponding snapshot.
    #
    # @return [Types::CreateSnapshotsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSnapshotsResult#snapshots #snapshots} => Array&lt;Types::SnapshotInfo&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshots({
    #     description: "String",
    #     instance_specification: { # required
    #       instance_id: "InstanceId",
    #       exclude_boot_volume: false,
    #     },
    #     outpost_arn: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     copy_tags_from_source: "volume", # accepts volume
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshots #=> Array
    #   resp.snapshots[0].description #=> String
    #   resp.snapshots[0].tags #=> Array
    #   resp.snapshots[0].tags[0].key #=> String
    #   resp.snapshots[0].tags[0].value #=> String
    #   resp.snapshots[0].encrypted #=> Boolean
    #   resp.snapshots[0].volume_id #=> String
    #   resp.snapshots[0].state #=> String, one of "pending", "completed", "error"
    #   resp.snapshots[0].volume_size #=> Integer
    #   resp.snapshots[0].start_time #=> Time
    #   resp.snapshots[0].progress #=> String
    #   resp.snapshots[0].owner_id #=> String
    #   resp.snapshots[0].snapshot_id #=> String
    #   resp.snapshots[0].outpost_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots AWS API Documentation
    #
    # @overload create_snapshots(params = {})
    # @param [Hash] params ({})
    def create_snapshots(params = {}, options = {})
      req = build_request(:create_snapshots, params)
      req.send_request(options)
    end

    # Creates a data feed for Spot Instances, enabling you to view Spot
    # Instance usage logs. You can create one data feed per AWS account. For
    # more information, see [Spot Instance data feed][1] in the *Amazon EC2
    # User Guide for Linux Instances*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html
    #
    # @option params [required, String] :bucket
    #   The name of the Amazon S3 bucket in which to store the Spot Instance
    #   data feed. For more information about bucket names, see [Rules for
    #   bucket naming][1] in the *Amazon S3 Developer Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :prefix
    #   The prefix for the data feed file names.
    #
    # @return [Types::CreateSpotDatafeedSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSpotDatafeedSubscriptionResult#spot_datafeed_subscription #spot_datafeed_subscription} => Types::SpotDatafeedSubscription
    #
    #
    # @example Example: To create a Spot Instance datafeed
    #
    #   # This example creates a Spot Instance data feed for your AWS account.
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     bucket: "my-s3-bucket", 
    #     prefix: "spotdata", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_datafeed_subscription: {
    #       bucket: "my-s3-bucket", 
    #       owner_id: "123456789012", 
    #       prefix: "spotdata", 
    #       state: "Active", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     bucket: "String", # required
    #     dry_run: false,
    #     prefix: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.spot_datafeed_subscription.bucket #=> String
    #   resp.spot_datafeed_subscription.fault.code #=> String
    #   resp.spot_datafeed_subscription.fault.message #=> String
    #   resp.spot_datafeed_subscription.owner_id #=> String
    #   resp.spot_datafeed_subscription.prefix #=> String
    #   resp.spot_datafeed_subscription.state #=> String, one of "Active", "Inactive"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription AWS API Documentation
    #
    # @overload create_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def create_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:create_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Stores an AMI as a single object in an S3 bucket.
    #
    # To use this API, you must have the required permissions. For more
    # information, see [Permissions for storing and restoring AMIs using
    # S3][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # For more information, see [Store and restore an AMI using S3][2] in
    # the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [required, String] :bucket
    #   The name of the S3 bucket in which the AMI object will be stored. The
    #   bucket must be in the Region in which the request is being made. The
    #   AMI object appears in the bucket only after the upload task has
    #   completed.
    #
    # @option params [Array<Types::S3ObjectTag>] :s3_object_tags
    #   The tags to apply to the AMI object that will be stored in the S3
    #   bucket.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateStoreImageTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateStoreImageTaskResult#object_key #object_key} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_store_image_task({
    #     image_id: "ImageId", # required
    #     bucket: "String", # required
    #     s3_object_tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.object_key #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask AWS API Documentation
    #
    # @overload create_store_image_task(params = {})
    # @param [Hash] params ({})
    def create_store_image_task(params = {}, options = {})
      req = build_request(:create_store_image_task, params)
      req.send_request(options)
    end

    # Creates a subnet in a specified VPC.
    #
    # You must specify an IPv4 CIDR block for the subnet. After you create a
    # subnet, you can't change its CIDR block. The allowed block size is
    # between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP
    # addresses). The CIDR block must not overlap with the CIDR block of an
    # existing subnet in the VPC.
    #
    # If you've associated an IPv6 CIDR block with your VPC, you can create
    # a subnet with an IPv6 CIDR block that uses a /64 prefix length.
    #
    # AWS reserves both the first four and the last IPv4 address in each
    # subnet's CIDR block. They're not available for use.
    #
    # If you add more than one subnet to a VPC, they're set up in a star
    # topology with a logical router in the middle.
    #
    # When you stop an instance in a subnet, it retains its private IPv4
    # address. It's therefore possible to have a subnet with no running
    # instances (they're all stopped), but no remaining IP addresses
    # available.
    #
    # For more information about subnets, see [Your VPC and Subnets][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the subnet.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone or Local Zone for the subnet.
    #
    #   Default: AWS selects one for you. If you create more than one subnet
    #   in your VPC, we do not necessarily select a different zone for each
    #   subnet.
    #
    #   To create a subnet in a Local Zone, set this value to the Local Zone
    #   ID, for example `us-west-2-lax-1a`. For information about the Regions
    #   that support Local Zones, see [Available Regions][1] in the *Amazon
    #   Elastic Compute Cloud User Guide*.
    #
    #   To create a subnet in an Outpost, set this value to the Availability
    #   Zone for the Outpost and specify the Outpost ARN.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions
    #
    # @option params [String] :availability_zone_id
    #   The AZ ID or the Local Zone ID of the subnet.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range for the subnet, in CIDR notation. The subnet
    #   size must use a /64 prefix length.
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost. If you specify an
    #   Outpost ARN, you must also specify the Availability Zone of the
    #   Outpost subnet.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :cidr_block
    #   The IPv4 network range for the subnet, in CIDR notation. For example,
    #   `10.0.0.0/24`. We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #
    # @return [Types::CreateSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSubnetResult#subnet #subnet} => Types::Subnet
    #
    #
    # @example Example: To create a subnet
    #
    #   # This example creates a subnet in the specified VPC with the specified CIDR block. We recommend that you let us select an
    #   # Availability Zone for you.
    #
    #   resp = client.create_subnet({
    #     cidr_block: "10.0.1.0/24", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     subnet: {
    #       availability_zone: "us-west-2c", 
    #       available_ip_address_count: 251, 
    #       cidr_block: "10.0.1.0/24", 
    #       state: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_subnet({
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     availability_zone: "String",
    #     availability_zone_id: "String",
    #     ipv_6_cidr_block: "String",
    #     outpost_arn: "String",
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #     cidr_block: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #   resp.subnet.map_customer_owned_ip_on_launch #=> Boolean
    #   resp.subnet.customer_owned_ipv_4_pool #=> String
    #   resp.subnet.state #=> String, one of "pending", "available"
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #   resp.subnet.outpost_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet AWS API Documentation
    #
    # @overload create_subnet(params = {})
    # @param [Hash] params ({})
    def create_subnet(params = {}, options = {})
      req = build_request(:create_subnet, params)
      req.send_request(options)
    end

    # Adds or overwrites only the specified tags for the specified Amazon
    # EC2 resource or resources. When you specify an existing tag key, the
    # value is overwritten with the new value. Each resource can have a
    # maximum of 50 tags. Each tag consists of a key and optional value. Tag
    # keys must be unique per resource.
    #
    # For more information about tags, see [Tagging Your Resources][1] in
    # the *Amazon Elastic Compute Cloud User Guide*. For more information
    # about creating IAM policies that control users' access to resources
    # based on tags, see [Supported Resource-Level Permissions for Amazon
    # EC2 API Actions][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #
    # @option params [required, Array<Types::Tag>] :tags
    #   The tags. The `value` parameter is required, but if you don't want
    #   the tag to have a value, specify the parameter with no value, and we
    #   set the value to an empty string.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a tag to a resource
    #
    #   # This example adds the tag Stack=production to the specified image, or overwrites an existing tag for the AMI where the
    #   # tag key is Stack.
    #
    #   resp = client.create_tags({
    #     resources: [
    #       "ami-78a54011", 
    #     ], 
    #     tags: [
    #       {
    #         key: "Stack", 
    #         value: "production", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_tags({
    #     dry_run: false,
    #     resources: ["TaggableResourceId"], # required
    #     tags: [ # required
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags AWS API Documentation
    #
    # @overload create_tags(params = {})
    # @param [Hash] params ({})
    def create_tags(params = {}, options = {})
      req = build_request(:create_tags, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror filter.
    #
    # A Traffic Mirror filter is a set of rules that defines the traffic to
    # mirror.
    #
    # By default, no traffic is mirrored. To mirror traffic, use
    # [CreateTrafficMirrorFilterRule][1] to add Traffic Mirror rules to the
    # filter. The rules you add define what traffic gets mirrored. You can
    # also use [ModifyTrafficMirrorFilterNetworkServices][2] to mirror
    # supported network services.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror filter.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorFilterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterResult#traffic_mirror_filter #traffic_mirror_filter} => Types::TrafficMirrorFilter
    #   * {Types::CreateTrafficMirrorFilterResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter({
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.network_services #=> Array
    #   resp.traffic_mirror_filter.network_services[0] #=> String, one of "amazon-dns"
    #   resp.traffic_mirror_filter.description #=> String
    #   resp.traffic_mirror_filter.tags #=> Array
    #   resp.traffic_mirror_filter.tags[0].key #=> String
    #   resp.traffic_mirror_filter.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter AWS API Documentation
    #
    # @overload create_traffic_mirror_filter(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror filter rule.
    #
    # A Traffic Mirror rule defines the Traffic Mirror source traffic to
    # mirror.
    #
    # You need the Traffic Mirror filter ID when you create the rule.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the filter that this rule is associated with.
    #
    # @option params [required, String] :traffic_direction
    #   The type of traffic (`ingress` \| `egress`).
    #
    # @option params [required, Integer] :rule_number
    #   The number of the Traffic Mirror rule. This number must be unique for
    #   each Traffic Mirror rule in a given direction. The rules are processed
    #   in ascending order by rule number.
    #
    # @option params [required, String] :rule_action
    #   The action to take (`accept` \| `reject`) on the filtered traffic.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :destination_port_range
    #   The destination port range.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :source_port_range
    #   The source port range.
    #
    # @option params [Integer] :protocol
    #   The protocol, for example UDP, to assign to the Traffic Mirror rule.
    #
    #   For information about the protocol value, see [Protocol Numbers][1] on
    #   the Internet Assigned Numbers Authority (IANA) website.
    #
    #
    #
    #   [1]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [required, String] :destination_cidr_block
    #   The destination CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [required, String] :source_cidr_block
    #   The source CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorFilterRuleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterRuleResult#traffic_mirror_filter_rule #traffic_mirror_filter_rule} => Types::TrafficMirrorFilterRule
    #   * {Types::CreateTrafficMirrorFilterRuleResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter_rule({
    #     traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #     traffic_direction: "ingress", # required, accepts ingress, egress
    #     rule_number: 1, # required
    #     rule_action: "accept", # required, accepts accept, reject
    #     destination_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     source_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     protocol: 1,
    #     destination_cidr_block: "String", # required
    #     source_cidr_block: "String", # required
    #     description: "String",
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter_rule.rule_number #=> Integer
    #   resp.traffic_mirror_filter_rule.rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter_rule.protocol #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.source_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.description #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule AWS API Documentation
    #
    # @overload create_traffic_mirror_filter_rule(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter_rule(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter_rule, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror session.
    #
    # A Traffic Mirror session actively copies packets from a Traffic Mirror
    # source to a Traffic Mirror target. Create a filter, and then assign it
    # to the session to define a subset of the traffic to mirror, for
    # example all TCP traffic.
    #
    # The Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in a different VPC connected
    # via VPC peering or a transit gateway.
    #
    # By default, no traffic is mirrored. Use [CreateTrafficMirrorFilter][1]
    # to create filter rules that specify the traffic to mirror.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the source network interface.
    #
    # @option params [required, String] :traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Integer] :packet_length
    #   The number of bytes in each packet to mirror. These are bytes after
    #   the VXLAN header. Do not specify this parameter when you want to
    #   mirror the entire packet. To mirror a subset of the packet, set this
    #   to the length (in bytes) that you want to mirror. For example, if you
    #   set this value to 100, then the first 100 bytes that meet the filter
    #   criteria are copied to the target.
    #
    #   If you do not want to mirror the entire packet, use the `PacketLength`
    #   parameter to specify the number of bytes in each packet to mirror.
    #
    # @option params [required, Integer] :session_number
    #   The session number determines the order in which sessions are
    #   evaluated when an interface is used by multiple sessions. The first
    #   session with a matching filter is the one that mirrors the packets.
    #
    #   Valid values are 1-32766.
    #
    # @option params [Integer] :virtual_network_id
    #   The VXLAN ID for the Traffic Mirror session. For more information
    #   about the VXLAN protocol, see [RFC 7348][1]. If you do not specify a
    #   `VirtualNetworkId`, an account-wide unique id is chosen at random.
    #
    #
    #
    #   [1]: https://tools.ietf.org/html/rfc7348
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror session.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorSessionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorSessionResult#traffic_mirror_session #traffic_mirror_session} => Types::TrafficMirrorSession
    #   * {Types::CreateTrafficMirrorSessionResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_session({
    #     network_interface_id: "NetworkInterfaceId", # required
    #     traffic_mirror_target_id: "TrafficMirrorTargetId", # required
    #     traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #     packet_length: 1,
    #     session_number: 1, # required
    #     virtual_network_id: 1,
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_session.traffic_mirror_session_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_session.network_interface_id #=> String
    #   resp.traffic_mirror_session.owner_id #=> String
    #   resp.traffic_mirror_session.packet_length #=> Integer
    #   resp.traffic_mirror_session.session_number #=> Integer
    #   resp.traffic_mirror_session.virtual_network_id #=> Integer
    #   resp.traffic_mirror_session.description #=> String
    #   resp.traffic_mirror_session.tags #=> Array
    #   resp.traffic_mirror_session.tags[0].key #=> String
    #   resp.traffic_mirror_session.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession AWS API Documentation
    #
    # @overload create_traffic_mirror_session(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_session(params = {}, options = {})
      req = build_request(:create_traffic_mirror_session, params)
      req.send_request(options)
    end

    # Creates a target for your Traffic Mirror session.
    #
    # A Traffic Mirror target is the destination for mirrored traffic. The
    # Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in different VPCs connected via
    # VPC peering or a transit gateway.
    #
    # A Traffic Mirror target can be a network interface, or a Network Load
    # Balancer.
    #
    # To use the target in a Traffic Mirror session, use
    # [CreateTrafficMirrorSession][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm
    #
    # @option params [String] :network_interface_id
    #   The network interface ID that is associated with the target.
    #
    # @option params [String] :network_load_balancer_arn
    #   The Amazon Resource Name (ARN) of the Network Load Balancer that is
    #   associated with the target.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror target.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Traffic Mirror target.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorTargetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorTargetResult#traffic_mirror_target #traffic_mirror_target} => Types::TrafficMirrorTarget
    #   * {Types::CreateTrafficMirrorTargetResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_target({
    #     network_interface_id: "NetworkInterfaceId",
    #     network_load_balancer_arn: "String",
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_target.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_target.network_interface_id #=> String
    #   resp.traffic_mirror_target.network_load_balancer_arn #=> String
    #   resp.traffic_mirror_target.type #=> String, one of "network-interface", "network-load-balancer"
    #   resp.traffic_mirror_target.description #=> String
    #   resp.traffic_mirror_target.owner_id #=> String
    #   resp.traffic_mirror_target.tags #=> Array
    #   resp.traffic_mirror_target.tags[0].key #=> String
    #   resp.traffic_mirror_target.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget AWS API Documentation
    #
    # @overload create_traffic_mirror_target(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_target(params = {}, options = {})
      req = build_request(:create_traffic_mirror_target, params)
      req.send_request(options)
    end

    # Creates a transit gateway.
    #
    # You can use a transit gateway to interconnect your virtual private
    # clouds (VPC) and on-premises networks. After the transit gateway
    # enters the `available` state, you can attach your VPCs and VPN
    # connections to the transit gateway.
    #
    # To attach your VPCs, use CreateTransitGatewayVpcAttachment.
    #
    # To attach a VPN connection, use CreateCustomerGateway to create a
    # customer gateway and specify the ID of the customer gateway and the ID
    # of the transit gateway in a call to CreateVpnConnection.
    #
    # When you create a transit gateway, we create a default transit gateway
    # route table and use it as the default association route table and the
    # default propagation route table. You can use
    # CreateTransitGatewayRouteTable to create additional transit gateway
    # route tables. If you disable automatic route propagation, we do not
    # create a default transit gateway route table. You can use
    # EnableTransitGatewayRouteTablePropagation to propagate routes from a
    # resource attachment to a transit gateway route table. If you disable
    # automatic associations, you can use AssociateTransitGatewayRouteTable
    # to associate a resource attachment with a transit gateway route table.
    #
    # @option params [String] :description
    #   A description of the transit gateway.
    #
    # @option params [Types::TransitGatewayRequestOptions] :options
    #   The transit gateway options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayResult#transit_gateway #transit_gateway} => Types::TransitGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway({
    #     description: "String",
    #     options: {
    #       amazon_side_asn: 1,
    #       auto_accept_shared_attachments: "enable", # accepts enable, disable
    #       default_route_table_association: "enable", # accepts enable, disable
    #       default_route_table_propagation: "enable", # accepts enable, disable
    #       vpn_ecmp_support: "enable", # accepts enable, disable
    #       dns_support: "enable", # accepts enable, disable
    #       multicast_support: "enable", # accepts enable, disable
    #       transit_gateway_cidr_blocks: ["String"],
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway.transit_gateway_id #=> String
    #   resp.transit_gateway.transit_gateway_arn #=> String
    #   resp.transit_gateway.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateway.owner_id #=> String
    #   resp.transit_gateway.description #=> String
    #   resp.transit_gateway.creation_time #=> Time
    #   resp.transit_gateway.options.amazon_side_asn #=> Integer
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks #=> Array
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks[0] #=> String
    #   resp.transit_gateway.options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.association_default_route_table_id #=> String
    #   resp.transit_gateway.options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.propagation_default_route_table_id #=> String
    #   resp.transit_gateway.options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.multicast_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.tags #=> Array
    #   resp.transit_gateway.tags[0].key #=> String
    #   resp.transit_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway AWS API Documentation
    #
    # @overload create_transit_gateway(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway(params = {}, options = {})
      req = build_request(:create_transit_gateway, params)
      req.send_request(options)
    end

    # Creates a Connect attachment from a specified transit gateway
    # attachment. A Connect attachment is a GRE-based tunnel attachment that
    # you can use to establish a connection between a transit gateway and an
    # appliance.
    #
    # A Connect attachment uses an existing VPC or AWS Direct Connect
    # attachment as the underlying transport mechanism.
    #
    # @option params [required, String] :transport_transit_gateway_attachment_id
    #   The ID of the transit gateway attachment. You can specify a VPC
    #   attachment or a AWS Direct Connect attachment.
    #
    # @option params [required, Types::CreateTransitGatewayConnectRequestOptions] :options
    #   The Connect attachment options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Connect attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayConnectResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayConnectResult#transit_gateway_connect #transit_gateway_connect} => Types::TransitGatewayConnect
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_connect({
    #     transport_transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     options: { # required
    #       protocol: "gre", # required, accepts gre
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transport_transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transit_gateway_id #=> String
    #   resp.transit_gateway_connect.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_connect.creation_time #=> Time
    #   resp.transit_gateway_connect.options.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect.tags #=> Array
    #   resp.transit_gateway_connect.tags[0].key #=> String
    #   resp.transit_gateway_connect.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect AWS API Documentation
    #
    # @overload create_transit_gateway_connect(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_connect(params = {}, options = {})
      req = build_request(:create_transit_gateway_connect, params)
      req.send_request(options)
    end

    # Creates a Connect peer for a specified transit gateway Connect
    # attachment between a transit gateway and an appliance.
    #
    # The peer address and transit gateway address must be the same IP
    # address family (IPv4 or IPv6).
    #
    # For more information, see [Connect peers][1] in the *Transit Gateways
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #
    # @option params [String] :transit_gateway_address
    #   The peer IP address (GRE outer IP address) on the transit gateway side
    #   of the Connect peer, which must be specified from a transit gateway
    #   CIDR block. If not specified, Amazon automatically assigns the first
    #   available IP address from the transit gateway CIDR block.
    #
    # @option params [required, String] :peer_address
    #   The peer IP address (GRE outer IP address) on the appliance side of
    #   the Connect peer.
    #
    # @option params [Types::TransitGatewayConnectRequestBgpOptions] :bgp_options
    #   The BGP options for the Connect peer.
    #
    # @option params [required, Array<String>] :inside_cidr_blocks
    #   The range of inside IP addresses that are used for BGP peering. You
    #   must specify a size /29 IPv4 CIDR block from the `169.254.0.0/16`
    #   range. The first address from the range must be configured on the
    #   appliance as the BGP IP address. You can also optionally specify a
    #   size /125 IPv6 CIDR block from the `fd00::/8` range.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Connect peer.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayConnectPeerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayConnectPeerResult#transit_gateway_connect_peer #transit_gateway_connect_peer} => Types::TransitGatewayConnectPeer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_connect_peer({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     transit_gateway_address: "String",
    #     peer_address: "String", # required
    #     bgp_options: {
    #       peer_asn: 1,
    #     },
    #     inside_cidr_blocks: ["String"], # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect_peer.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect_peer.transit_gateway_connect_peer_id #=> String
    #   resp.transit_gateway_connect_peer.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_connect_peer.creation_time #=> Time
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks[0] #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].bgp_status #=> String, one of "up", "down"
    #   resp.transit_gateway_connect_peer.tags #=> Array
    #   resp.transit_gateway_connect_peer.tags[0].key #=> String
    #   resp.transit_gateway_connect_peer.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer AWS API Documentation
    #
    # @overload create_transit_gateway_connect_peer(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_connect_peer(params = {}, options = {})
      req = build_request(:create_transit_gateway_connect_peer, params)
      req.send_request(options)
    end

    # Creates a multicast domain using the specified transit gateway.
    #
    # The transit gateway must be in the available state before you create a
    # domain. Use [DescribeTransitGateways][1] to see the state of transit
    # gateway.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Types::CreateTransitGatewayMulticastDomainRequestOptions] :options
    #   The options for the transit gateway multicast domain.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags for the transit gateway multicast domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayMulticastDomainResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayMulticastDomainResult#transit_gateway_multicast_domain #transit_gateway_multicast_domain} => Types::TransitGatewayMulticastDomain
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_multicast_domain({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     options: {
    #       igmpv_2_support: "enable", # accepts enable, disable
    #       static_sources_support: "enable", # accepts enable, disable
    #       auto_accept_shared_associations: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_arn #=> String
    #   resp.transit_gateway_multicast_domain.owner_id #=> String
    #   resp.transit_gateway_multicast_domain.options.igmpv_2_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.static_sources_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.auto_accept_shared_associations #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_multicast_domain.creation_time #=> Time
    #   resp.transit_gateway_multicast_domain.tags #=> Array
    #   resp.transit_gateway_multicast_domain.tags[0].key #=> String
    #   resp.transit_gateway_multicast_domain.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain AWS API Documentation
    #
    # @overload create_transit_gateway_multicast_domain(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_multicast_domain(params = {}, options = {})
      req = build_request(:create_transit_gateway_multicast_domain, params)
      req.send_request(options)
    end

    # Requests a transit gateway peering attachment between the specified
    # transit gateway (requester) and a peer transit gateway (accepter). The
    # transit gateways must be in different Regions. The peer transit
    # gateway can be in your account or a different AWS account.
    #
    # After you create the peering attachment, the owner of the accepter
    # transit gateway must accept the attachment request.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [required, String] :peer_transit_gateway_id
    #   The ID of the peer transit gateway with which to create the peering
    #   attachment.
    #
    # @option params [required, String] :peer_account_id
    #   The AWS account ID of the owner of the peer transit gateway.
    #
    # @option params [required, String] :peer_region
    #   The Region where the peer transit gateway is located.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway peering attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayPeeringAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayPeeringAttachmentResult#transit_gateway_peering_attachment #transit_gateway_peering_attachment} => Types::TransitGatewayPeeringAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_peering_attachment({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     peer_transit_gateway_id: "TransitAssociationGatewayId", # required
    #     peer_account_id: "String", # required
    #     peer_region: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_peering_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.status.code #=> String
    #   resp.transit_gateway_peering_attachment.status.message #=> String
    #   resp.transit_gateway_peering_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_peering_attachment.creation_time #=> Time
    #   resp.transit_gateway_peering_attachment.tags #=> Array
    #   resp.transit_gateway_peering_attachment.tags[0].key #=> String
    #   resp.transit_gateway_peering_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment AWS API Documentation
    #
    # @overload create_transit_gateway_peering_attachment(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_peering_attachment(params = {}, options = {})
      req = build_request(:create_transit_gateway_peering_attachment, params)
      req.send_request(options)
    end

    # Creates a reference (route) to a prefix list in a specified transit
    # gateway route table.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :prefix_list_id
    #   The ID of the prefix list that is used for destination matches.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the attachment to which traffic is routed.
    #
    # @option params [Boolean] :blackhole
    #   Indicates whether to drop traffic that matches this route.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayPrefixListReferenceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayPrefixListReferenceResult#transit_gateway_prefix_list_reference #transit_gateway_prefix_list_reference} => Types::TransitGatewayPrefixListReference
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_prefix_list_reference({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     prefix_list_id: "PrefixListResourceId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     blackhole: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_owner_id #=> String
    #   resp.transit_gateway_prefix_list_reference.state #=> String, one of "pending", "available", "modifying", "deleting"
    #   resp.transit_gateway_prefix_list_reference.blackhole #=> Boolean
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference AWS API Documentation
    #
    # @overload create_transit_gateway_prefix_list_reference(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_prefix_list_reference(params = {}, options = {})
      req = build_request(:create_transit_gateway_prefix_list_reference, params)
      req.send_request(options)
    end

    # Creates a static route for the specified transit gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :blackhole
    #   Indicates whether to drop traffic that matches this route.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayRouteResult#route #route} => Types::TransitGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_route({
    #     destination_cidr_block: "String", # required
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     blackhole: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.prefix_list_id #=> String
    #   resp.route.transit_gateway_attachments #=> Array
    #   resp.route.transit_gateway_attachments[0].resource_id #=> String
    #   resp.route.transit_gateway_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.route.transit_gateway_attachments[0].resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute AWS API Documentation
    #
    # @overload create_transit_gateway_route(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_route(params = {}, options = {})
      req = build_request(:create_transit_gateway_route, params)
      req.send_request(options)
    end

    # Creates a route table for the specified transit gateway.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayRouteTableResult#transit_gateway_route_table #transit_gateway_route_table} => Types::TransitGatewayRouteTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_route_table({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_route_table.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_route_table.transit_gateway_id #=> String
    #   resp.transit_gateway_route_table.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_route_table.default_association_route_table #=> Boolean
    #   resp.transit_gateway_route_table.default_propagation_route_table #=> Boolean
    #   resp.transit_gateway_route_table.creation_time #=> Time
    #   resp.transit_gateway_route_table.tags #=> Array
    #   resp.transit_gateway_route_table.tags[0].key #=> String
    #   resp.transit_gateway_route_table.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable AWS API Documentation
    #
    # @overload create_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:create_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Attaches the specified VPC to the specified transit gateway.
    #
    # If you attach a VPC with a CIDR range that overlaps the CIDR range of
    # a VPC that is already attached, the new VPC CIDR range is not
    # propagated to the default propagation route table.
    #
    # To send VPC traffic to an attached transit gateway, add a route to the
    # VPC route table using CreateRoute.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [required, Array<String>] :subnet_ids
    #   The IDs of one or more subnets. You can specify only one subnet per
    #   Availability Zone. You must specify at least one subnet, but we
    #   recommend that you specify two subnets for better availability. The
    #   transit gateway uses one IP address from each specified subnet.
    #
    # @option params [Types::CreateTransitGatewayVpcAttachmentRequestOptions] :options
    #   The VPC attachment options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the VPC attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_vpc_attachment({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     vpc_id: "VpcId", # required
    #     subnet_ids: ["SubnetId"], # required
    #     options: {
    #       dns_support: "enable", # accepts enable, disable
    #       ipv_6_support: "enable", # accepts enable, disable
    #       appliance_mode_support: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.appliance_mode_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload create_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:create_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Creates an EBS volume that can be attached to an instance in the same
    # Availability Zone.
    #
    # You can create a new empty volume or restore a volume from an EBS
    # snapshot. Any AWS Marketplace product codes from the snapshot are
    # propagated to the volume.
    #
    # You can create encrypted volumes. Encrypted volumes must be attached
    # to instances that support Amazon EBS encryption. Volumes that are
    # created from encrypted snapshots are also automatically encrypted. For
    # more information, see [Amazon EBS encryption][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    # You can tag your volumes during creation. For more information, see
    # [Tagging your Amazon EC2 resources][2] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # For more information, see [Creating an Amazon EBS volume][3] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to create the volume.
    #
    # @option params [Boolean] :encrypted
    #   Indicates whether the volume should be encrypted. The effect of
    #   setting the encryption state to `true` depends on the volume origin
    #   (new or from a snapshot), starting encryption state, ownership, and
    #   whether encryption by default is enabled. For more information, see
    #   [Encryption by default][1] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #   Encrypted Amazon EBS volumes must be attached to instances that
    #   support Amazon EBS encryption. For more information, see [Supported
    #   instance types][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances
    #
    # @option params [Integer] :iops
    #   The number of I/O operations per second (IOPS). For `gp3`, `io1`, and
    #   `io2` volumes, this represents the number of IOPS that are provisioned
    #   for the volume. For `gp2` volumes, this represents the baseline
    #   performance of the volume and the rate at which the volume accumulates
    #   I/O credits for bursting.
    #
    #   The following are the supported values for each volume type:
    #
    #   * `gp3`\: 3,000-16,000 IOPS
    #
    #   * `io1`\: 100-64,000 IOPS
    #
    #   * `io2`\: 100-64,000 IOPS
    #
    #   For `io1` and `io2` volumes, we guarantee 64,000 IOPS only for
    #   [Instances built on the Nitro System][1]. Other instance families
    #   guarantee performance up to 32,000 IOPS.
    #
    #   This parameter is required for `io1` and `io2` volumes. The default
    #   for `gp3` volumes is 3,000 IOPS. This parameter is not supported for
    #   `gp2`, `st1`, `sc1`, or `standard` volumes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #
    # @option params [String] :kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If `KmsKeyId`
    #   is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify an
    #   ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost.
    #
    # @option params [Integer] :size
    #   The size of the volume, in GiBs. You must specify either a snapshot ID
    #   or a volume size. If you specify a snapshot, the default is the
    #   snapshot size. You can specify a volume size that is equal to or
    #   larger than the snapshot size.
    #
    #   The following are the supported volumes sizes for each volume type:
    #
    #   * `gp2` and `gp3`\: 1-16,384
    #
    #   * `io1` and `io2`\: 4-16,384
    #
    #   * `st1` and `sc1`\: 125-16,384
    #
    #   * `standard`\: 1-1,024
    #
    # @option params [String] :snapshot_id
    #   The snapshot from which to create the volume. You must specify either
    #   a snapshot ID or a volume size.
    #
    # @option params [String] :volume_type
    #   The volume type. This parameter can be one of the following values:
    #
    #   * General Purpose SSD: `gp2` \| `gp3`
    #
    #   * Provisioned IOPS SSD: `io1` \| `io2`
    #
    #   * Throughput Optimized HDD: `st1`
    #
    #   * Cold HDD: `sc1`
    #
    #   * Magnetic: `standard`
    #
    #   For more information, see [Amazon EBS volume types][1] in the *Amazon
    #   Elastic Compute Cloud User Guide*.
    #
    #   Default: `gp2`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the volume during creation.
    #
    # @option params [Boolean] :multi_attach_enabled
    #   Indicates whether to enable Amazon EBS Multi-Attach. If you enable
    #   Multi-Attach, you can attach the volume to up to 16 [Instances built
    #   on the Nitro System][1] in the same Availability Zone. This parameter
    #   is supported with `io1` and `io2` volumes only. For more information,
    #   see [ Amazon EBS Multi-Attach][2] in the *Amazon Elastic Compute Cloud
    #   User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html
    #
    # @option params [Integer] :throughput
    #   The throughput to provision for a volume, with a maximum of 1,000
    #   MiB/s.
    #
    #   This parameter is valid only for `gp3` volumes.
    #
    #   Valid Range: Minimum value of 125. Maximum value of 1000.
    #
    # @return [Types::Volume] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Volume#attachments #attachments} => Array&lt;Types::VolumeAttachment&gt;
    #   * {Types::Volume#availability_zone #availability_zone} => String
    #   * {Types::Volume#create_time #create_time} => Time
    #   * {Types::Volume#encrypted #encrypted} => Boolean
    #   * {Types::Volume#kms_key_id #kms_key_id} => String
    #   * {Types::Volume#outpost_arn #outpost_arn} => String
    #   * {Types::Volume#size #size} => Integer
    #   * {Types::Volume#snapshot_id #snapshot_id} => String
    #   * {Types::Volume#state #state} => String
    #   * {Types::Volume#volume_id #volume_id} => String
    #   * {Types::Volume#iops #iops} => Integer
    #   * {Types::Volume#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::Volume#volume_type #volume_type} => String
    #   * {Types::Volume#fast_restored #fast_restored} => Boolean
    #   * {Types::Volume#multi_attach_enabled #multi_attach_enabled} => Boolean
    #   * {Types::Volume#throughput #throughput} => Integer
    #
    #
    # @example Example: To create a new volume
    #
    #   # This example creates an 80 GiB General Purpose (SSD) volume in the Availability Zone ``us-east-1a``.
    #
    #   resp = client.create_volume({
    #     availability_zone: "us-east-1a", 
    #     size: 80, 
    #     volume_type: "gp2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     availability_zone: "us-east-1a", 
    #     create_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     encrypted: false, 
    #     iops: 240, 
    #     size: 80, 
    #     snapshot_id: "", 
    #     state: "creating", 
    #     volume_id: "vol-6b60b7c7", 
    #     volume_type: "gp2", 
    #   }
    #
    # @example Example: To create a new Provisioned IOPS (SSD) volume from a snapshot
    #
    #   # This example creates a new Provisioned IOPS (SSD) volume with 1000 provisioned IOPS from a snapshot in the Availability
    #   # Zone ``us-east-1a``.
    #
    #   resp = client.create_volume({
    #     availability_zone: "us-east-1a", 
    #     iops: 1000, 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     volume_type: "io1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachments: [
    #     ], 
    #     availability_zone: "us-east-1a", 
    #     create_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     iops: 1000, 
    #     size: 500, 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     state: "creating", 
    #     tags: [
    #     ], 
    #     volume_id: "vol-1234567890abcdef0", 
    #     volume_type: "io1", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_volume({
    #     availability_zone: "String", # required
    #     encrypted: false,
    #     iops: 1,
    #     kms_key_id: "KmsKeyId",
    #     outpost_arn: "String",
    #     size: 1,
    #     snapshot_id: "SnapshotId",
    #     volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     multi_attach_enabled: false,
    #     throughput: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.attachments #=> Array
    #   resp.attachments[0].attach_time #=> Time
    #   resp.attachments[0].device #=> String
    #   resp.attachments[0].instance_id #=> String
    #   resp.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached", "busy"
    #   resp.attachments[0].volume_id #=> String
    #   resp.attachments[0].delete_on_termination #=> Boolean
    #   resp.availability_zone #=> String
    #   resp.create_time #=> Time
    #   resp.encrypted #=> Boolean
    #   resp.kms_key_id #=> String
    #   resp.outpost_arn #=> String
    #   resp.size #=> Integer
    #   resp.snapshot_id #=> String
    #   resp.state #=> String, one of "creating", "available", "in-use", "deleting", "deleted", "error"
    #   resp.volume_id #=> String
    #   resp.iops #=> Integer
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.fast_restored #=> Boolean
    #   resp.multi_attach_enabled #=> Boolean
    #   resp.throughput #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume AWS API Documentation
    #
    # @overload create_volume(params = {})
    # @param [Hash] params ({})
    def create_volume(params = {}, options = {})
      req = build_request(:create_volume, params)
      req.send_request(options)
    end

    # Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
    # can create uses a /28 netmask (16 IPv4 addresses), and the largest
    # uses a /16 netmask (65,536 IPv4 addresses). For more information about
    # how large to make your VPC, see [Your VPC and Subnets][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    # You can optionally request an IPv6 CIDR block for the VPC. You can
    # request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6
    # addresses, or an IPv6 CIDR block from an IPv6 address pool that you
    # provisioned through bring your own IP addresses ([BYOIP][2]).
    #
    # By default, each instance you launch in the VPC has the default DHCP
    # options, which include only a default DNS server that we provide
    # (AmazonProvidedDNS). For more information, see [DHCP Options Sets][3]
    # in the *Amazon Virtual Private Cloud User Guide*.
    #
    # You can specify the instance tenancy value for the VPC when you create
    # it. You can't change this value for the VPC after you create it. For
    # more information, see [Dedicated Instances][4] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    # [4]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html
    #
    # @option params [required, String] :cidr_block
    #   The IPv4 network range for the VPC, in CIDR notation. For example,
    #   `10.0.0.0/16`. We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #
    # @option params [Boolean] :amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IP addresses, or the size
    #   of the CIDR block.
    #
    # @option params [String] :ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 CIDR block from the IPv6 address pool. You must also specify
    #   `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :instance_tenancy
    #   The tenancy options for instances launched into the VPC. For
    #   `default`, instances are launched with shared tenancy by default. You
    #   can launch instances with any tenancy into a shared tenancy VPC. For
    #   `dedicated`, instances are launched as dedicated tenancy instances by
    #   default. You can only launch instances with a tenancy of `dedicated`
    #   or `host` into a dedicated tenancy VPC.
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #
    # @option params [String] :ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR block.
    #   Use this parameter to limit the address to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the VPC.
    #
    # @return [Types::CreateVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcResult#vpc #vpc} => Types::Vpc
    #
    #
    # @example Example: To create a VPC
    #
    #   # This example creates a VPC with the specified CIDR block.
    #
    #   resp = client.create_vpc({
    #     cidr_block: "10.0.0.0/16", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     vpc: {
    #       cidr_block: "10.0.0.0/16", 
    #       dhcp_options_id: "dopt-7a8b9c2d", 
    #       instance_tenancy: "default", 
    #       state: "pending", 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc({
    #     cidr_block: "String", # required
    #     amazon_provided_ipv_6_cidr_block: false,
    #     ipv_6_pool: "Ipv6PoolEc2Id",
    #     ipv_6_cidr_block: "String",
    #     dry_run: false,
    #     instance_tenancy: "default", # accepts default, dedicated, host
    #     ipv_6_cidr_block_network_border_group: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc.cidr_block #=> String
    #   resp.vpc.dhcp_options_id #=> String
    #   resp.vpc.state #=> String, one of "pending", "available"
    #   resp.vpc.vpc_id #=> String
    #   resp.vpc.owner_id #=> String
    #   resp.vpc.instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.vpc.ipv_6_cidr_block_association_set #=> Array
    #   resp.vpc.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].network_border_group #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_pool #=> String
    #   resp.vpc.cidr_block_association_set #=> Array
    #   resp.vpc.cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.status_message #=> String
    #   resp.vpc.is_default #=> Boolean
    #   resp.vpc.tags #=> Array
    #   resp.vpc.tags[0].key #=> String
    #   resp.vpc.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc AWS API Documentation
    #
    # @overload create_vpc(params = {})
    # @param [Hash] params ({})
    def create_vpc(params = {}, options = {})
      req = build_request(:create_vpc, params)
      req.send_request(options)
    end

    # Creates a VPC endpoint for a specified service. An endpoint enables
    # you to create a private connection between your VPC and the service.
    # The service may be provided by AWS, an AWS Marketplace Partner, or
    # another AWS account. For more information, see [VPC Endpoints][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    # A `gateway` endpoint serves as a target for a route in your route
    # table for traffic destined for the AWS service. You can specify an
    # endpoint policy to attach to the endpoint, which will control access
    # to the service from your VPC. You can also specify the VPC route
    # tables that use the endpoint.
    #
    # An `interface` endpoint is a network interface in your subnet that
    # serves as an endpoint for communicating with the specified service.
    # You can specify the subnets in which to create an endpoint, and the
    # security groups to associate with the endpoint network interface.
    #
    # A `GatewayLoadBalancer` endpoint is a network interface in your subnet
    # that serves an endpoint for communicating with a Gateway Load Balancer
    # that you've configured as a VPC endpoint service.
    #
    # Use DescribeVpcEndpointServices to get a list of supported services.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :vpc_endpoint_type
    #   The type of endpoint.
    #
    #   Default: Gateway
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC in which the endpoint will be used.
    #
    # @option params [required, String] :service_name
    #   The service name. To get a list of available services, use the
    #   DescribeVpcEndpointServices request, or get the name from the service
    #   provider.
    #
    # @option params [String] :policy_document
    #   (Interface and gateway endpoints) A policy to attach to the endpoint
    #   that controls access to the service. The policy must be in valid JSON
    #   format. If this parameter is not specified, we attach a default policy
    #   that allows full access to the service.
    #
    # @option params [Array<String>] :route_table_ids
    #   (Gateway endpoint) One or more route table IDs.
    #
    # @option params [Array<String>] :subnet_ids
    #   (Interface and Gateway Load Balancer endpoints) The ID of one or more
    #   subnets in which to create an endpoint network interface. For a
    #   Gateway Load Balancer endpoint, you can specify one subnet only.
    #
    # @option params [Array<String>] :security_group_ids
    #   (Interface endpoint) The ID of one or more security groups to
    #   associate with the endpoint network interface.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :private_dns_enabled
    #   (Interface endpoint) Indicates whether to associate a private hosted
    #   zone with the specified VPC. The private hosted zone contains a record
    #   set for the default public DNS name for the service for the Region
    #   (for example, `kinesis.us-east-1.amazonaws.com`), which resolves to
    #   the private IP addresses of the endpoint network interfaces in the
    #   VPC. This enables you to make requests to the default public DNS name
    #   for the service instead of the public DNS names that are automatically
    #   generated by the VPC endpoint service.
    #
    #   To use a private hosted zone, you must set the following VPC
    #   attributes to `true`\: `enableDnsHostnames` and `enableDnsSupport`.
    #   Use ModifyVpcAttribute to set the VPC attributes.
    #
    #   Default: `true`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to associate with the endpoint.
    #
    # @return [Types::CreateVpcEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointResult#vpc_endpoint #vpc_endpoint} => Types::VpcEndpoint
    #   * {Types::CreateVpcEndpointResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint({
    #     dry_run: false,
    #     vpc_endpoint_type: "Interface", # accepts Interface, Gateway, GatewayLoadBalancer
    #     vpc_id: "VpcId", # required
    #     service_name: "String", # required
    #     policy_document: "String",
    #     route_table_ids: ["RouteTableId"],
    #     subnet_ids: ["SubnetId"],
    #     security_group_ids: ["SecurityGroupId"],
    #     client_token: "String",
    #     private_dns_enabled: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_endpoint.vpc_endpoint_id #=> String
    #   resp.vpc_endpoint.vpc_endpoint_type #=> String, one of "Interface", "Gateway", "GatewayLoadBalancer"
    #   resp.vpc_endpoint.vpc_id #=> String
    #   resp.vpc_endpoint.service_name #=> String
    #   resp.vpc_endpoint.state #=> String, one of "PendingAcceptance", "Pending", "Available", "Deleting", "Deleted", "Rejected", "Failed", "Expired"
    #   resp.vpc_endpoint.policy_document #=> String
    #   resp.vpc_endpoint.route_table_ids #=> Array
    #   resp.vpc_endpoint.route_table_ids[0] #=> String
    #   resp.vpc_endpoint.subnet_ids #=> Array
    #   resp.vpc_endpoint.subnet_ids[0] #=> String
    #   resp.vpc_endpoint.groups #=> Array
    #   resp.vpc_endpoint.groups[0].group_id #=> String
    #   resp.vpc_endpoint.groups[0].group_name #=> String
    #   resp.vpc_endpoint.private_dns_enabled #=> Boolean
    #   resp.vpc_endpoint.requester_managed #=> Boolean
    #   resp.vpc_endpoint.network_interface_ids #=> Array
    #   resp.vpc_endpoint.network_interface_ids[0] #=> String
    #   resp.vpc_endpoint.dns_entries #=> Array
    #   resp.vpc_endpoint.dns_entries[0].dns_name #=> String
    #   resp.vpc_endpoint.dns_entries[0].hosted_zone_id #=> String
    #   resp.vpc_endpoint.creation_timestamp #=> Time
    #   resp.vpc_endpoint.tags #=> Array
    #   resp.vpc_endpoint.tags[0].key #=> String
    #   resp.vpc_endpoint.tags[0].value #=> String
    #   resp.vpc_endpoint.owner_id #=> String
    #   resp.vpc_endpoint.last_error.message #=> String
    #   resp.vpc_endpoint.last_error.code #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint AWS API Documentation
    #
    # @overload create_vpc_endpoint(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint(params = {}, options = {})
      req = build_request(:create_vpc_endpoint, params)
      req.send_request(options)
    end

    # Creates a connection notification for a specified VPC endpoint or VPC
    # endpoint service. A connection notification notifies you of specific
    # endpoint events. You must create an SNS topic to receive
    # notifications. For more information, see [Create a Topic][1] in the
    # *Amazon Simple Notification Service Developer Guide*.
    #
    # You can create a connection notification for interface endpoints only.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :service_id
    #   The ID of the endpoint service.
    #
    # @option params [String] :vpc_endpoint_id
    #   The ID of the endpoint.
    #
    # @option params [required, String] :connection_notification_arn
    #   The ARN of the SNS topic for the notifications.
    #
    # @option params [required, Array<String>] :connection_events
    #   One or more endpoint events for which to receive notifications. Valid
    #   values are `Accept`, `Connect`, `Delete`, and `Reject`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateVpcEndpointConnectionNotificationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointConnectionNotificationResult#connection_notification #connection_notification} => Types::ConnectionNotification
    #   * {Types::CreateVpcEndpointConnectionNotificationResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint_connection_notification({
    #     dry_run: false,
    #     service_id: "VpcEndpointServiceId",
    #     vpc_endpoint_id: "VpcEndpointId",
    #     connection_notification_arn: "String", # required
    #     connection_events: ["String"], # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.connection_notification.connection_notification_id #=> String
    #   resp.connection_notification.service_id #=> String
    #   resp.connection_notification.vpc_endpoint_id #=> String
    #   resp.connection_notification.connection_notification_type #=> String, one of "Topic"
    #   resp.connection_notification.connection_notification_arn #=> String
    #   resp.connection_notification.connection_events #=> Array
    #   resp.connection_notification.connection_events[0] #=> String
    #   resp.connection_notification.connection_notification_state #=> String, one of "Enabled", "Disabled"
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification AWS API Documentation
    #
    # @overload create_vpc_endpoint_connection_notification(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint_connection_notification(params = {}, options = {})
      req = build_request(:create_vpc_endpoint_connection_notification, params)
      req.send_request(options)
    end

    # Creates a VPC endpoint service configuration to which service
    # consumers (AWS accounts, IAM users, and IAM roles) can connect.
    #
    # To create an endpoint service configuration, you must first create one
    # of the following for your service:
    #
    # * A [Network Load Balancer][1]. Service consumers connect to your
    #   service using an interface endpoint.
    #
    # * A [Gateway Load Balancer][2]. Service consumers connect to your
    #   service using a Gateway Load Balancer endpoint.
    #
    # For more information, see [VPC Endpoint Services][3] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    # If you set the private DNS name, you must prove that you own the
    # private DNS domain name. For more information, see [VPC Endpoint
    # Service Private DNS Name Verification][4] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html
    # [2]: https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html
    # [4]: https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :acceptance_required
    #   Indicates whether requests from service consumers to create an
    #   endpoint to your service must be accepted. To accept a request, use
    #   AcceptVpcEndpointConnections.
    #
    # @option params [String] :private_dns_name
    #   (Interface endpoint configuration) The private DNS name to assign to
    #   the VPC endpoint service.
    #
    # @option params [Array<String>] :network_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of one or more Network Load Balancers
    #   for your service.
    #
    # @option params [Array<String>] :gateway_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of one or more Gateway Load
    #   Balancers.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to associate with the service.
    #
    # @return [Types::CreateVpcEndpointServiceConfigurationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointServiceConfigurationResult#service_configuration #service_configuration} => Types::ServiceConfiguration
    #   * {Types::CreateVpcEndpointServiceConfigurationResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint_service_configuration({
    #     dry_run: false,
    #     acceptance_required: false,
    #     private_dns_name: "String",
    #     network_load_balancer_arns: ["String"],
    #     gateway_load_balancer_arns: ["String"],
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.service_configuration.service_type #=> Array
    #   resp.service_configuration.service_type[0].service_type #=> String, one of "Interface", "Gateway", "GatewayLoadBalancer"
    #   resp.service_configuration.service_id #=> String
    #   resp.service_configuration.service_name #=> String
    #   resp.service_configuration.service_state #=> String, one of "Pending", "Available", "Deleting", "Deleted", "Failed"
    #   resp.service_configuration.availability_zones #=> Array
    #   resp.service_configuration.availability_zones[0] #=> String
    #   resp.service_configuration.acceptance_required #=> Boolean
    #   resp.service_configuration.manages_vpc_endpoints #=> Boolean
    #   resp.service_configuration.network_load_balancer_arns #=> Array
    #   resp.service_configuration.network_load_balancer_arns[0] #=> String
    #   resp.service_configuration.gateway_load_balancer_arns #=> Array
    #   resp.service_configuration.gateway_load_balancer_arns[0] #=> String
    #   resp.service_configuration.base_endpoint_dns_names #=> Array
    #   resp.service_configuration.base_endpoint_dns_names[0] #=> String
    #   resp.service_configuration.private_dns_name #=> String
    #   resp.service_configuration.private_dns_name_configuration.state #=> String, one of "pendingVerification", "verified", "failed"
    #   resp.service_configuration.private_dns_name_configuration.type #=> String
    #   resp.service_configuration.private_dns_name_configuration.value #=> String
    #   resp.service_configuration.private_dns_name_configuration.name #=> String
    #   resp.service_configuration.tags #=> Array
    #   resp.service_configuration.tags[0].key #=> String
    #   resp.service_configuration.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration AWS API Documentation
    #
    # @overload create_vpc_endpoint_service_configuration(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint_service_configuration(params = {}, options = {})
      req = build_request(:create_vpc_endpoint_service_configuration, params)
      req.send_request(options)
    end

    # Requests a VPC peering connection between two VPCs: a requester VPC
    # that you own and an accepter VPC with which to create the connection.
    # The accepter VPC can belong to another AWS account and can be in a
    # different Region to the requester VPC. The requester VPC and accepter
    # VPC cannot have overlapping CIDR blocks.
    #
    # <note markdown="1"> Limitations and rules apply to a VPC peering connection. For more
    # information, see the [limitations][1] section in the *VPC Peering
    # Guide*.
    #
    #  </note>
    #
    # The owner of the accepter VPC must accept the peering request to
    # activate the peering connection. The VPC peering connection request
    # expires after 7 days, after which it cannot be accepted or rejected.
    #
    # If you create a VPC peering connection request between VPCs with
    # overlapping CIDR blocks, the VPC peering connection has a status of
    # `failed`.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :peer_owner_id
    #   The AWS account ID of the owner of the accepter VPC.
    #
    #   Default: Your AWS account ID
    #
    # @option params [String] :peer_vpc_id
    #   The ID of the VPC with which you are creating the VPC peering
    #   connection. You must specify this parameter in the request.
    #
    # @option params [String] :vpc_id
    #   The ID of the requester VPC. You must specify this parameter in the
    #   request.
    #
    # @option params [String] :peer_region
    #   The Region code for the accepter VPC, if the accepter VPC is located
    #   in a Region other than the Region in which you make the request.
    #
    #   Default: The Region in which you make the request.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the peering connection.
    #
    # @return [Types::CreateVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcPeeringConnectionResult#vpc_peering_connection #vpc_peering_connection} => Types::VpcPeeringConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_peering_connection({
    #     dry_run: false,
    #     peer_owner_id: "String",
    #     peer_vpc_id: "String",
    #     vpc_id: "VpcId",
    #     peer_region: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.region #=> String
    #   resp.vpc_peering_connection.expiration_time #=> Time
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.region #=> String
    #   resp.vpc_peering_connection.status.code #=> String, one of "initiating-request", "pending-acceptance", "active", "deleted", "rejected", "failed", "expired", "provisioning", "deleting"
    #   resp.vpc_peering_connection.status.message #=> String
    #   resp.vpc_peering_connection.tags #=> Array
    #   resp.vpc_peering_connection.tags[0].key #=> String
    #   resp.vpc_peering_connection.tags[0].value #=> String
    #   resp.vpc_peering_connection.vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection AWS API Documentation
    #
    # @overload create_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def create_vpc_peering_connection(params = {}, options = {})
      req = build_request(:create_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Creates a VPN connection between an existing virtual private gateway
    # or transit gateway and a customer gateway. The supported connection
    # type is `ipsec.1`.
    #
    # The response includes information that you need to give to your
    # network administrator to configure your customer gateway.
    #
    # We strongly recommend that you use HTTPS when calling this operation
    # because the response contains sensitive cryptographic information for
    # configuring your customer gateway device.
    #
    # If you decide to shut down your VPN connection for any reason and
    # later create a new VPN connection, you must reconfigure your customer
    # gateway with the new information returned from this call.
    #
    # This is an idempotent operation. If you perform the operation more
    # than once, Amazon EC2 doesn't return an error.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :customer_gateway_id
    #   The ID of the customer gateway.
    #
    # @option params [required, String] :type
    #   The type of VPN connection (`ipsec.1`).
    #
    # @option params [String] :vpn_gateway_id
    #   The ID of the virtual private gateway. If you specify a virtual
    #   private gateway, you cannot specify a transit gateway.
    #
    # @option params [String] :transit_gateway_id
    #   The ID of the transit gateway. If you specify a transit gateway, you
    #   cannot specify a virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Types::VpnConnectionOptionsSpecification] :options
    #   The options for the VPN connection.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the VPN connection.
    #
    # @return [Types::CreateVpnConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpnConnectionResult#vpn_connection #vpn_connection} => Types::VpnConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_connection({
    #     customer_gateway_id: "CustomerGatewayId", # required
    #     type: "String", # required
    #     vpn_gateway_id: "VpnGatewayId",
    #     transit_gateway_id: "TransitGatewayId",
    #     dry_run: false,
    #     options: {
    #       enable_acceleration: false,
    #       static_routes_only: false,
    #       tunnel_inside_ip_version: "ipv4", # accepts ipv4, ipv6
    #       tunnel_options: [
    #         {
    #           tunnel_inside_cidr: "String",
    #           tunnel_inside_ipv_6_cidr: "String",
    #           pre_shared_key: "String",
    #           phase_1_lifetime_seconds: 1,
    #           phase_2_lifetime_seconds: 1,
    #           rekey_margin_time_seconds: 1,
    #           rekey_fuzz_percentage: 1,
    #           replay_window_size: 1,
    #           dpd_timeout_seconds: 1,
    #           dpd_timeout_action: "String",
    #           phase_1_encryption_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_2_encryption_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_1_integrity_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_2_integrity_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_1_dh_group_numbers: [
    #             {
    #               value: 1,
    #             },
    #           ],
    #           phase_2_dh_group_numbers: [
    #             {
    #               value: 1,
    #             },
    #           ],
    #           ike_versions: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           startup_action: "String",
    #         },
    #       ],
    #       local_ipv_4_network_cidr: "String",
    #       remote_ipv_4_network_cidr: "String",
    #       local_ipv_6_network_cidr: "String",
    #       remote_ipv_6_network_cidr: "String",
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.vpn_connection.customer_gateway_configuration #=> String
    #   resp.vpn_connection.customer_gateway_id #=> String
    #   resp.vpn_connection.category #=> String
    #   resp.vpn_connection.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_connection.type #=> String, one of "ipsec.1"
    #   resp.vpn_connection.vpn_connection_id #=> String
    #   resp.vpn_connection.vpn_gateway_id #=> String
    #   resp.vpn_connection.transit_gateway_id #=> String
    #   resp.vpn_connection.options.enable_acceleration #=> Boolean
    #   resp.vpn_connection.options.static_routes_only #=> Boolean
    #   resp.vpn_connection.options.local_ipv_4_network_cidr #=> String
    #   resp.vpn_connection.options.remote_ipv_4_network_cidr #=> String
    #   resp.vpn_connection.options.local_ipv_6_network_cidr #=> String
    #   resp.vpn_connection.options.remote_ipv_6_network_cidr #=> String
    #   resp.vpn_connection.options.tunnel_inside_ip_version #=> String, one of "ipv4", "ipv6"
    #   resp.vpn_connection.options.tunnel_options #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].outside_ip_address #=> String
    #   resp.vpn_connection.options.tunnel_options[0].tunnel_inside_cidr #=> String
    #   resp.vpn_connection.options.tunnel_options[0].tunnel_inside_ipv_6_cidr #=> String
    #   resp.vpn_connection.options.tunnel_options[0].pre_shared_key #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_lifetime_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_lifetime_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].rekey_margin_time_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].rekey_fuzz_percentage #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].replay_window_size #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].dpd_timeout_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].dpd_timeout_action #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_encryption_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_encryption_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_encryption_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_encryption_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_integrity_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_integrity_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_integrity_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_integrity_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_dh_group_numbers #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_dh_group_numbers[0].value #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_dh_group_numbers #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_dh_group_numbers[0].value #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].ike_versions #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].ike_versions[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].startup_action #=> String
    #   resp.vpn_connection.routes #=> Array
    #   resp.vpn_connection.routes[0].destination_cidr_block #=> String
    #   resp.vpn_connection.routes[0].source #=> String, one of "Static"
    #   resp.vpn_connection.routes[0].state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_connection.tags #=> Array
    #   resp.vpn_connection.tags[0].key #=> String
    #   resp.vpn_connection.tags[0].value #=> String
    #   resp.vpn_connection.vgw_telemetry #=> Array
    #   resp.vpn_connection.vgw_telemetry[0].accepted_route_count #=> Integer
    #   resp.vpn_connection.vgw_telemetry[0].last_status_change #=> Time
    #   resp.vpn_connection.vgw_telemetry[0].outside_ip_address #=> String
    #   resp.vpn_connection.vgw_telemetry[0].status #=> String, one of "UP", "DOWN"
    #   resp.vpn_connection.vgw_telemetry[0].status_message #=> String
    #   resp.vpn_connection.vgw_telemetry[0].certificate_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection AWS API Documentation
    #
    # @overload create_vpn_connection(params = {})
    # @param [Hash] params ({})
    def create_vpn_connection(params = {}, options = {})
      req = build_request(:create_vpn_connection, params)
      req.send_request(options)
    end

    # Creates a static route associated with a VPN connection between an
    # existing virtual private gateway and a VPN customer gateway. The
    # static route allows traffic to be routed from the virtual private
    # gateway to the VPN customer gateway.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_connection_route({
    #     destination_cidr_block: "String", # required
    #     vpn_connection_id: "VpnConnectionId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute AWS API Documentation
    #
    # @overload create_vpn_connection_route(params = {})
    # @param [Hash] params ({})
    def create_vpn_connection_route(params = {}, options = {})
      req = build_request(:create_vpn_connection_route, params)
      req.send_request(options)
    end

    # Creates a virtual private gateway. A virtual private gateway is the
    # endpoint on the VPC side of your VPN connection. You can create a
    # virtual private gateway before creating the VPC itself.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [String] :availability_zone
    #   The Availability Zone for the virtual private gateway.
    #
    # @option params [required, String] :type
    #   The type of VPN connection this virtual private gateway supports.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the virtual private gateway.
    #
    # @option params [Integer] :amazon_side_asn
    #   A private Autonomous System Number (ASN) for the Amazon side of a BGP
    #   session. If you're using a 16-bit ASN, it must be in the 64512 to
    #   65534 range. If you're using a 32-bit ASN, it must be in the
    #   4200000000 to 4294967294 range.
    #
    #   Default: 64512
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateVpnGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpnGatewayResult#vpn_gateway #vpn_gateway} => Types::VpnGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_gateway({
    #     availability_zone: "String",
    #     type: "ipsec.1", # required, accepts ipsec.1
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     amazon_side_asn: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpn_gateway.availability_zone #=> String
    #   resp.vpn_gateway.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_gateway.type #=> String, one of "ipsec.1"
    #   resp.vpn_gateway.vpc_attachments #=> Array
    #   resp.vpn_gateway.vpc_attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.vpn_gateway.vpc_attachments[0].vpc_id #=> String
    #   resp.vpn_gateway.vpn_gateway_id #=> String
    #   resp.vpn_gateway.amazon_side_asn #=> Integer
    #   resp.vpn_gateway.tags #=> Array
    #   resp.vpn_gateway.tags[0].key #=> String
    #   resp.vpn_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway AWS API Documentation
    #
    # @overload create_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def create_vpn_gateway(params = {}, options = {})
      req = build_request(:create_vpn_gateway, params)
      req.send_request(options)
    end

    # Deletes a carrier gateway.
    #
    # If you do not delete the route that contains the carrier gateway as
    # the Target, the route is a blackhole route. For information about how
    # to delete a route, see [DeleteRoute][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html
    #
    # @option params [required, String] :carrier_gateway_id
    #   The ID of the carrier gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteCarrierGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteCarrierGatewayResult#carrier_gateway #carrier_gateway} => Types::CarrierGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_carrier_gateway({
    #     carrier_gateway_id: "CarrierGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.carrier_gateway.carrier_gateway_id #=> String
    #   resp.carrier_gateway.vpc_id #=> String
    #   resp.carrier_gateway.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.carrier_gateway.owner_id #=> String
    #   resp.carrier_gateway.tags #=> Array
    #   resp.carrier_gateway.tags[0].key #=> String
    #   resp.carrier_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway AWS API Documentation
    #
    # @overload delete_carrier_gateway(params = {})
    # @param [Hash] params ({})
    def delete_carrier_gateway(params = {}, options = {})
      req = build_request(:delete_carrier_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified Client VPN endpoint. You must disassociate all
    # target networks before you can delete a Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN to be deleted.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteClientVpnEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteClientVpnEndpointResult#status #status} => Types::ClientVpnEndpointStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_client_vpn_endpoint({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint AWS API Documentation
    #
    # @overload delete_client_vpn_endpoint(params = {})
    # @param [Hash] params ({})
    def delete_client_vpn_endpoint(params = {}, options = {})
      req = build_request(:delete_client_vpn_endpoint, params)
      req.send_request(options)
    end

    # Deletes a route from a Client VPN endpoint. You can only delete routes
    # that you manually added using the **CreateClientVpnRoute** action. You
    # cannot delete routes that were automatically added when associating a
    # subnet. To remove routes that have been automatically added,
    # disassociate the target subnet from the Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint from which the route is to be
    #   deleted.
    #
    # @option params [String] :target_vpc_subnet_id
    #   The ID of the target subnet used by the route.
    #
    # @option params [required, String] :destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route to be deleted.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteClientVpnRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteClientVpnRouteResult#status #status} => Types::ClientVpnRouteStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_client_vpn_route({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     target_vpc_subnet_id: "SubnetId",
    #     destination_cidr_block: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute AWS API Documentation
    #
    # @overload delete_client_vpn_route(params = {})
    # @param [Hash] params ({})
    def delete_client_vpn_route(params = {}, options = {})
      req = build_request(:delete_client_vpn_route, params)
      req.send_request(options)
    end

    # Deletes the specified customer gateway. You must delete the VPN
    # connection before you can delete the customer gateway.
    #
    # @option params [required, String] :customer_gateway_id
    #   The ID of the customer gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a customer gateway
    #
    #   # This example deletes the specified customer gateway.
    #
    #   resp = client.delete_customer_gateway({
    #     customer_gateway_id: "cgw-0e11f167", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_customer_gateway({
    #     customer_gateway_id: "CustomerGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway AWS API Documentation
    #
    # @overload delete_customer_gateway(params = {})
    # @param [Hash] params ({})
    def delete_customer_gateway(params = {}, options = {})
      req = build_request(:delete_customer_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified set of DHCP options. You must disassociate the
    # set of DHCP options before you can delete it. You can disassociate the
    # set of DHCP options by associating either a new set of options or the
    # default set of options with the VPC.
    #
    # @option params [required, String] :dhcp_options_id
    #   The ID of the DHCP options set.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DHCP options set
    #
    #   # This example deletes the specified DHCP options set.
    #
    #   resp = client.delete_dhcp_options({
    #     dhcp_options_id: "dopt-d9070ebb", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_dhcp_options({
    #     dhcp_options_id: "DhcpOptionsId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions AWS API Documentation
    #
    # @overload delete_dhcp_options(params = {})
    # @param [Hash] params ({})
    def delete_dhcp_options(params = {}, options = {})
      req = build_request(:delete_dhcp_options, params)
      req.send_request(options)
    end

    # Deletes an egress-only internet gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :egress_only_internet_gateway_id
    #   The ID of the egress-only internet gateway.
    #
    # @return [Types::DeleteEgressOnlyInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteEgressOnlyInternetGatewayResult#return_code #return_code} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_egress_only_internet_gateway({
    #     dry_run: false,
    #     egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return_code #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway AWS API Documentation
    #
    # @overload delete_egress_only_internet_gateway(params = {})
    # @param [Hash] params ({})
    def delete_egress_only_internet_gateway(params = {}, options = {})
      req = build_request(:delete_egress_only_internet_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified EC2 Fleet.
    #
    # After you delete an EC2 Fleet, it launches no new instances.
    #
    # You must specify whether a deleted EC2 Fleet should also terminate its
    # instances. If you choose to terminate the instances, the EC2 Fleet
    # enters the `deleted_terminating` state. Otherwise, the EC2 Fleet
    # enters the `deleted_running` state, and the instances continue to run
    # until they are interrupted or you terminate them manually.
    #
    # For `instant` fleets, EC2 Fleet must terminate the instances when the
    # fleet is deleted. A deleted `instant` fleet with running instances is
    # not supported.
    #
    # **Restrictions**
    #
    # * You can delete up to 25 `instant` fleets in a single request. If you
    #   exceed this number, no `instant` fleets are deleted and an error is
    #   returned. There is no restriction on the number of fleets of type
    #   `maintain` or `request` that can be deleted in a single request.
    #
    # * Up to 1000 instances can be terminated in a single request to delete
    #   `instant` fleets.
    #
    # For more information, see [Deleting an EC2 Fleet][1] in the *Amazon
    # EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :fleet_ids
    #   The IDs of the EC2 Fleets.
    #
    # @option params [required, Boolean] :terminate_instances
    #   Indicates whether to terminate the instances when the EC2 Fleet is
    #   deleted. The default is to terminate the instances.
    #
    #   To let the instances continue to run after the EC2 Fleet is deleted,
    #   specify `NoTerminateInstances`. Supported only for fleets of type
    #   `maintain` and `request`.
    #
    #   For `instant` fleets, you cannot specify `NoTerminateInstances`. A
    #   deleted `instant` fleet with running instances is not supported.
    #
    # @return [Types::DeleteFleetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFleetsResult#successful_fleet_deletions #successful_fleet_deletions} => Array&lt;Types::DeleteFleetSuccessItem&gt;
    #   * {Types::DeleteFleetsResult#unsuccessful_fleet_deletions #unsuccessful_fleet_deletions} => Array&lt;Types::DeleteFleetErrorItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_fleets({
    #     dry_run: false,
    #     fleet_ids: ["FleetId"], # required
    #     terminate_instances: false, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_deletions #=> Array
    #   resp.successful_fleet_deletions[0].current_fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.successful_fleet_deletions[0].previous_fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.successful_fleet_deletions[0].fleet_id #=> String
    #   resp.unsuccessful_fleet_deletions #=> Array
    #   resp.unsuccessful_fleet_deletions[0].error.code #=> String, one of "fleetIdDoesNotExist", "fleetIdMalformed", "fleetNotInDeletableState", "unexpectedError"
    #   resp.unsuccessful_fleet_deletions[0].error.message #=> String
    #   resp.unsuccessful_fleet_deletions[0].fleet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets AWS API Documentation
    #
    # @overload delete_fleets(params = {})
    # @param [Hash] params ({})
    def delete_fleets(params = {}, options = {})
      req = build_request(:delete_fleets, params)
      req.send_request(options)
    end

    # Deletes one or more flow logs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #
    # @return [Types::DeleteFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFlowLogsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_flow_logs({
    #     dry_run: false,
    #     flow_log_ids: ["VpcFlowLogId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs AWS API Documentation
    #
    # @overload delete_flow_logs(params = {})
    # @param [Hash] params ({})
    def delete_flow_logs(params = {}, options = {})
      req = build_request(:delete_flow_logs, params)
      req.send_request(options)
    end

    # Deletes the specified Amazon FPGA Image (AFI).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :fpga_image_id
    #   The ID of the AFI.
    #
    # @return [Types::DeleteFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFpgaImageResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_fpga_image({
    #     dry_run: false,
    #     fpga_image_id: "FpgaImageId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage AWS API Documentation
    #
    # @overload delete_fpga_image(params = {})
    # @param [Hash] params ({})
    def delete_fpga_image(params = {}, options = {})
      req = build_request(:delete_fpga_image, params)
      req.send_request(options)
    end

    # Deletes the specified internet gateway. You must detach the internet
    # gateway from the VPC before you can delete it.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :internet_gateway_id
    #   The ID of the internet gateway.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete an Internet gateway
    #
    #   # This example deletes the specified Internet gateway.
    #
    #   resp = client.delete_internet_gateway({
    #     internet_gateway_id: "igw-c0a643a9", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_internet_gateway({
    #     dry_run: false,
    #     internet_gateway_id: "InternetGatewayId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway AWS API Documentation
    #
    # @overload delete_internet_gateway(params = {})
    # @param [Hash] params ({})
    def delete_internet_gateway(params = {}, options = {})
      req = build_request(:delete_internet_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified key pair, by removing the public key from Amazon
    # EC2.
    #
    # @option params [String] :key_name
    #   The name of the key pair.
    #
    # @option params [String] :key_pair_id
    #   The ID of the key pair.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a key pair
    #
    #   # This example deletes the specified key pair.
    #
    #   resp = client.delete_key_pair({
    #     key_name: "my-key-pair", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_key_pair({
    #     key_name: "KeyPairName",
    #     key_pair_id: "KeyPairId",
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair AWS API Documentation
    #
    # @overload delete_key_pair(params = {})
    # @param [Hash] params ({})
    def delete_key_pair(params = {}, options = {})
      req = build_request(:delete_key_pair, params)
      req.send_request(options)
    end

    # Deletes a launch template. Deleting a launch template deletes all of
    # its versions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @return [Types::DeleteLaunchTemplateResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLaunchTemplateResult#launch_template #launch_template} => Types::LaunchTemplate
    #
    #
    # @example Example: To delete a launch template
    #
    #   # This example deletes the specified launch template.
    #
    #   resp = client.delete_launch_template({
    #     launch_template_id: "lt-0abcd290751193123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template: {
    #       create_time: Time.parse("2017-11-23T16:46:25.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version_number: 2, 
    #       latest_version_number: 2, 
    #       launch_template_id: "lt-0abcd290751193123", 
    #       launch_template_name: "my-template", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_launch_template({
    #     dry_run: false,
    #     launch_template_id: "LaunchTemplateId",
    #     launch_template_name: "LaunchTemplateName",
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template.launch_template_id #=> String
    #   resp.launch_template.launch_template_name #=> String
    #   resp.launch_template.create_time #=> Time
    #   resp.launch_template.created_by #=> String
    #   resp.launch_template.default_version_number #=> Integer
    #   resp.launch_template.latest_version_number #=> Integer
    #   resp.launch_template.tags #=> Array
    #   resp.launch_template.tags[0].key #=> String
    #   resp.launch_template.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate AWS API Documentation
    #
    # @overload delete_launch_template(params = {})
    # @param [Hash] params ({})
    def delete_launch_template(params = {}, options = {})
      req = build_request(:delete_launch_template, params)
      req.send_request(options)
    end

    # Deletes one or more versions of a launch template. You cannot delete
    # the default version of a launch template; you must first assign a
    # different version as the default. If the default version is the only
    # version for the launch template, you must delete the entire launch
    # template using DeleteLaunchTemplate.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [required, Array<String>] :versions
    #   The version numbers of one or more launch template versions to delete.
    #
    # @return [Types::DeleteLaunchTemplateVersionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLaunchTemplateVersionsResult#successfully_deleted_launch_template_versions #successfully_deleted_launch_template_versions} => Array&lt;Types::DeleteLaunchTemplateVersionsResponseSuccessItem&gt;
    #   * {Types::DeleteLaunchTemplateVersionsResult#unsuccessfully_deleted_launch_template_versions #unsuccessfully_deleted_launch_template_versions} => Array&lt;Types::DeleteLaunchTemplateVersionsResponseErrorItem&gt;
    #
    #
    # @example Example: To delete a launch template version
    #
    #   # This example deletes the specified launch template version.
    #
    #   resp = client.delete_launch_template_versions({
    #     launch_template_id: "lt-0abcd290751193123", 
    #     versions: [
    #       "1", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successfully_deleted_launch_template_versions: [
    #       {
    #         launch_template_id: "lt-0abcd290751193123", 
    #         launch_template_name: "my-template", 
    #         version_number: 1, 
    #       }, 
    #     ], 
    #     unsuccessfully_deleted_launch_template_versions: [
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_launch_template_versions({
    #     dry_run: false,
    #     launch_template_id: "LaunchTemplateId",
    #     launch_template_name: "LaunchTemplateName",
    #     versions: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successfully_deleted_launch_template_versions #=> Array
    #   resp.successfully_deleted_launch_template_versions[0].launch_template_id #=> String
    #   resp.successfully_deleted_launch_template_versions[0].launch_template_name #=> String
    #   resp.successfully_deleted_launch_template_versions[0].version_number #=> Integer
    #   resp.unsuccessfully_deleted_launch_template_versions #=> Array
    #   resp.unsuccessfully_deleted_launch_template_versions[0].launch_template_id #=> String
    #   resp.unsuccessfully_deleted_launch_template_versions[0].launch_template_name #=> String
    #   resp.unsuccessfully_deleted_launch_template_versions[0].version_number #=> Integer
    #   resp.unsuccessfully_deleted_launch_template_versions[0].response_error.code #=> String, one of "launchTemplateIdDoesNotExist", "launchTemplateIdMalformed", "launchTemplateNameDoesNotExist", "launchTemplateNameMalformed", "launchTemplateVersionDoesNotExist", "unexpectedError"
    #   resp.unsuccessfully_deleted_launch_template_versions[0].response_error.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions AWS API Documentation
    #
    # @overload delete_launch_template_versions(params = {})
    # @param [Hash] params ({})
    def delete_launch_template_versions(params = {}, options = {})
      req = build_request(:delete_launch_template_versions, params)
      req.send_request(options)
    end

    # Deletes the specified route from the specified local gateway route
    # table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteLocalGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLocalGatewayRouteResult#route #route} => Types::LocalGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_local_gateway_route({
    #     destination_cidr_block: "String", # required
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.local_gateway_virtual_interface_group_id #=> String
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #   resp.route.local_gateway_route_table_id #=> String
    #   resp.route.local_gateway_route_table_arn #=> String
    #   resp.route.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute AWS API Documentation
    #
    # @overload delete_local_gateway_route(params = {})
    # @param [Hash] params ({})
    def delete_local_gateway_route(params = {}, options = {})
      req = build_request(:delete_local_gateway_route, params)
      req.send_request(options)
    end

    # Deletes the specified association between a VPC and local gateway
    # route table.
    #
    # @option params [required, String] :local_gateway_route_table_vpc_association_id
    #   The ID of the association.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteLocalGatewayRouteTableVpcAssociationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLocalGatewayRouteTableVpcAssociationResult#local_gateway_route_table_vpc_association #local_gateway_route_table_vpc_association} => Types::LocalGatewayRouteTableVpcAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_local_gateway_route_table_vpc_association({
    #     local_gateway_route_table_vpc_association_id: "LocalGatewayRouteTableVpcAssociationId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_vpc_association_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_arn #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_id #=> String
    #   resp.local_gateway_route_table_vpc_association.vpc_id #=> String
    #   resp.local_gateway_route_table_vpc_association.owner_id #=> String
    #   resp.local_gateway_route_table_vpc_association.state #=> String
    #   resp.local_gateway_route_table_vpc_association.tags #=> Array
    #   resp.local_gateway_route_table_vpc_association.tags[0].key #=> String
    #   resp.local_gateway_route_table_vpc_association.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation AWS API Documentation
    #
    # @overload delete_local_gateway_route_table_vpc_association(params = {})
    # @param [Hash] params ({})
    def delete_local_gateway_route_table_vpc_association(params = {}, options = {})
      req = build_request(:delete_local_gateway_route_table_vpc_association, params)
      req.send_request(options)
    end

    # Deletes the specified managed prefix list. You must first remove all
    # references to the prefix list in your resources.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :prefix_list_id
    #   The ID of the prefix list.
    #
    # @return [Types::DeleteManagedPrefixListResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteManagedPrefixListResult#prefix_list #prefix_list} => Types::ManagedPrefixList
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_managed_prefix_list({
    #     dry_run: false,
    #     prefix_list_id: "PrefixListResourceId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.prefix_list.prefix_list_id #=> String
    #   resp.prefix_list.address_family #=> String
    #   resp.prefix_list.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "restore-in-progress", "restore-complete", "restore-failed", "delete-in-progress", "delete-complete", "delete-failed"
    #   resp.prefix_list.state_message #=> String
    #   resp.prefix_list.prefix_list_arn #=> String
    #   resp.prefix_list.prefix_list_name #=> String
    #   resp.prefix_list.max_entries #=> Integer
    #   resp.prefix_list.version #=> Integer
    #   resp.prefix_list.tags #=> Array
    #   resp.prefix_list.tags[0].key #=> String
    #   resp.prefix_list.tags[0].value #=> String
    #   resp.prefix_list.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList AWS API Documentation
    #
    # @overload delete_managed_prefix_list(params = {})
    # @param [Hash] params ({})
    def delete_managed_prefix_list(params = {}, options = {})
      req = build_request(:delete_managed_prefix_list, params)
      req.send_request(options)
    end

    # Deletes the specified NAT gateway. Deleting a NAT gateway
    # disassociates its Elastic IP address, but does not release the address
    # from your account. Deleting a NAT gateway does not delete any NAT
    # gateway routes in your route tables.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :nat_gateway_id
    #   The ID of the NAT gateway.
    #
    # @return [Types::DeleteNatGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNatGatewayResult#nat_gateway_id #nat_gateway_id} => String
    #
    #
    # @example Example: To delete a NAT gateway
    #
    #   # This example deletes the specified NAT gateway.
    #
    #   resp = client.delete_nat_gateway({
    #     nat_gateway_id: "nat-04ae55e711cec5680", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateway_id: "nat-04ae55e711cec5680", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_nat_gateway({
    #     dry_run: false,
    #     nat_gateway_id: "NatGatewayId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.nat_gateway_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway AWS API Documentation
    #
    # @overload delete_nat_gateway(params = {})
    # @param [Hash] params ({})
    def delete_nat_gateway(params = {}, options = {})
      req = build_request(:delete_nat_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified network ACL. You can't delete the ACL if it's
    # associated with any subnets. You can't delete the default network
    # ACL.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network ACL
    #
    #   # This example deletes the specified network ACL.
    #
    #   resp = client.delete_network_acl({
    #     network_acl_id: "acl-5fb85d36", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_acl({
    #     dry_run: false,
    #     network_acl_id: "NetworkAclId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl AWS API Documentation
    #
    # @overload delete_network_acl(params = {})
    # @param [Hash] params ({})
    def delete_network_acl(params = {}, options = {})
      req = build_request(:delete_network_acl, params)
      req.send_request(options)
    end

    # Deletes the specified ingress or egress entry (rule) from the
    # specified network ACL.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Boolean] :egress
    #   Indicates whether the rule is an egress rule.
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @option params [required, Integer] :rule_number
    #   The rule number of the entry to delete.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network ACL entry
    #
    #   # This example deletes ingress rule number 100 from the specified network ACL.
    #
    #   resp = client.delete_network_acl_entry({
    #     egress: true, 
    #     network_acl_id: "acl-5fb85d36", 
    #     rule_number: 100, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_acl_entry({
    #     dry_run: false,
    #     egress: false, # required
    #     network_acl_id: "NetworkAclId", # required
    #     rule_number: 1, # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry AWS API Documentation
    #
    # @overload delete_network_acl_entry(params = {})
    # @param [Hash] params ({})
    def delete_network_acl_entry(params = {}, options = {})
      req = build_request(:delete_network_acl_entry, params)
      req.send_request(options)
    end

    # Deletes the specified network insights analysis.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_insights_analysis_id
    #   The ID of the network insights analysis.
    #
    # @return [Types::DeleteNetworkInsightsAnalysisResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNetworkInsightsAnalysisResult#network_insights_analysis_id #network_insights_analysis_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_insights_analysis({
    #     dry_run: false,
    #     network_insights_analysis_id: "NetworkInsightsAnalysisId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_insights_analysis_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis AWS API Documentation
    #
    # @overload delete_network_insights_analysis(params = {})
    # @param [Hash] params ({})
    def delete_network_insights_analysis(params = {}, options = {})
      req = build_request(:delete_network_insights_analysis, params)
      req.send_request(options)
    end

    # Deletes the specified path.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_insights_path_id
    #   The ID of the path.
    #
    # @return [Types::DeleteNetworkInsightsPathResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNetworkInsightsPathResult#network_insights_path_id #network_insights_path_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_insights_path({
    #     dry_run: false,
    #     network_insights_path_id: "NetworkInsightsPathId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_insights_path_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath AWS API Documentation
    #
    # @overload delete_network_insights_path(params = {})
    # @param [Hash] params ({})
    def delete_network_insights_path(params = {}, options = {})
      req = build_request(:delete_network_insights_path, params)
      req.send_request(options)
    end

    # Deletes the specified network interface. You must detach the network
    # interface before you can delete it.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network interface
    #
    #   # This example deletes the specified network interface.
    #
    #   resp = client.delete_network_interface({
    #     network_interface_id: "eni-e5aa89a3", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_interface({
    #     dry_run: false,
    #     network_interface_id: "NetworkInterfaceId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface AWS API Documentation
    #
    # @overload delete_network_interface(params = {})
    # @param [Hash] params ({})
    def delete_network_interface(params = {}, options = {})
      req = build_request(:delete_network_interface, params)
      req.send_request(options)
    end

    # Deletes a permission for a network interface. By default, you cannot
    # delete the permission if the account for which you're removing the
    # permission has attached the network interface to an instance. However,
    # you can force delete the permission, regardless of any attachment.
    #
    # @option params [required, String] :network_interface_permission_id
    #   The ID of the network interface permission.
    #
    # @option params [Boolean] :force
    #   Specify `true` to remove the permission even if the network interface
    #   is attached to an instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteNetworkInterfacePermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNetworkInterfacePermissionResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_interface_permission({
    #     network_interface_permission_id: "NetworkInterfacePermissionId", # required
    #     force: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission AWS API Documentation
    #
    # @overload delete_network_interface_permission(params = {})
    # @param [Hash] params ({})
    def delete_network_interface_permission(params = {}, options = {})
      req = build_request(:delete_network_interface_permission, params)
      req.send_request(options)
    end

    # Deletes the specified placement group. You must terminate all
    # instances in the placement group before you can delete the placement
    # group. For more information, see [Placement groups][1] in the *Amazon
    # EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :group_name
    #   The name of the placement group.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a placement group
    #
    #   # This example deletes the specified placement group.
    #
    #   resp = client.delete_placement_group({
    #     group_name: "my-cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_placement_group({
    #     dry_run: false,
    #     group_name: "PlacementGroupName", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup AWS API Documentation
    #
    # @overload delete_placement_group(params = {})
    # @param [Hash] params ({})
    def delete_placement_group(params = {}, options = {})
      req = build_request(:delete_placement_group, params)
      req.send_request(options)
    end

    # Deletes the queued purchases for the specified Reserved Instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :reserved_instances_ids
    #   The IDs of the Reserved Instances.
    #
    # @return [Types::DeleteQueuedReservedInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteQueuedReservedInstancesResult#successful_queued_purchase_deletions #successful_queued_purchase_deletions} => Array&lt;Types::SuccessfulQueuedPurchaseDeletion&gt;
    #   * {Types::DeleteQueuedReservedInstancesResult#failed_queued_purchase_deletions #failed_queued_purchase_deletions} => Array&lt;Types::FailedQueuedPurchaseDeletion&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_queued_reserved_instances({
    #     dry_run: false,
    #     reserved_instances_ids: ["ReservationId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_queued_purchase_deletions #=> Array
    #   resp.successful_queued_purchase_deletions[0].reserved_instances_id #=> String
    #   resp.failed_queued_purchase_deletions #=> Array
    #   resp.failed_queued_purchase_deletions[0].error.code #=> String, one of "reserved-instances-id-invalid", "reserved-instances-not-in-queued-state", "unexpected-error"
    #   resp.failed_queued_purchase_deletions[0].error.message #=> String
    #   resp.failed_queued_purchase_deletions[0].reserved_instances_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances AWS API Documentation
    #
    # @overload delete_queued_reserved_instances(params = {})
    # @param [Hash] params ({})
    def delete_queued_reserved_instances(params = {}, options = {})
      req = build_request(:delete_queued_reserved_instances, params)
      req.send_request(options)
    end

    # Deletes the specified route from the specified route table.
    #
    # @option params [String] :destination_cidr_block
    #   The IPv4 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #
    # @option params [String] :destination_ipv_6_cidr_block
    #   The IPv6 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #
    # @option params [String] :destination_prefix_list_id
    #   The ID of the prefix list for the route.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a route
    #
    #   # This example deletes the specified route from the specified route table.
    #
    #   resp = client.delete_route({
    #     destination_cidr_block: "0.0.0.0/0", 
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_route({
    #     destination_cidr_block: "String",
    #     destination_ipv_6_cidr_block: "String",
    #     destination_prefix_list_id: "PrefixListResourceId",
    #     dry_run: false,
    #     route_table_id: "RouteTableId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute AWS API Documentation
    #
    # @overload delete_route(params = {})
    # @param [Hash] params ({})
    def delete_route(params = {}, options = {})
      req = build_request(:delete_route, params)
      req.send_request(options)
    end

    # Deletes the specified route table. You must disassociate the route
    # table from any subnets before you can delete it. You can't delete the
    # main route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a route table
    #
    #   # This example deletes the specified route table.
    #
    #   resp = client.delete_route_table({
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_route_table({
    #     dry_run: false,
    #     route_table_id: "RouteTableId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable AWS API Documentation
    #
    # @overload delete_route_table(params = {})
    # @param [Hash] params ({})
    def delete_route_table(params = {}, options = {})
      req = build_request(:delete_route_table, params)
      req.send_request(options)
    end

    # Deletes a security group.
    #
    # If you attempt to delete a security group that is associated with an
    # instance, or is referenced by another security group, the operation
    # fails with `InvalidGroup.InUse` in EC2-Classic or
    # `DependencyViolation` in EC2-VPC.
    #
    # @option params [String] :group_id
    #   The ID of the security group. Required for a nondefault VPC.
    #
    # @option params [String] :group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You can
    #   specify either the security group name or the security group ID.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a security group
    #
    #   # This example deletes the specified security group.
    #
    #   resp = client.delete_security_group({
    #     group_id: "sg-903004f8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_security_group({
    #     group_id: "SecurityGroupId",
    #     group_name: "SecurityGroupName",
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup AWS API Documentation
    #
    # @overload delete_security_group(params = {})
    # @param [Hash] params ({})
    def delete_security_group(params = {}, options = {})
      req = build_request(:delete_security_group, params)
      req.send_request(options)
    end

    # Deletes the specified snapshot.
    #
    # When you make periodic snapshots of a volume, the snapshots are
    # incremental, and only the blocks on the device that have changed since
    # your last snapshot are saved in the new snapshot. When you delete a
    # snapshot, only the data not needed for any other snapshot is removed.
    # So regardless of which prior snapshots have been deleted, all active
    # snapshots will have access to all the information needed to restore
    # the volume.
    #
    # You cannot delete a snapshot of the root device of an EBS volume used
    # by a registered AMI. You must first de-register the AMI before you can
    # delete the snapshot.
    #
    # For more information, see [Deleting an Amazon EBS snapshot][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html
    #
    # @option params [required, String] :snapshot_id
    #   The ID of the EBS snapshot.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a snapshot
    #
    #   # This example deletes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``. If the command succeeds, no output
    #   # is returned.
    #
    #   resp = client.delete_snapshot({
    #     snapshot_id: "snap-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_snapshot({
    #     snapshot_id: "SnapshotId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot AWS API Documentation
    #
    # @overload delete_snapshot(params = {})
    # @param [Hash] params ({})
    def delete_snapshot(params = {}, options = {})
      req = build_request(:delete_snapshot, params)
      req.send_request(options)
    end

    # Deletes the data feed for Spot Instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To cancel a Spot Instance data feed subscription
    #
    #   # This example deletes a Spot data feed subscription for the account.
    #
    #   resp = client.delete_spot_datafeed_subscription({
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_spot_datafeed_subscription({
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription AWS API Documentation
    #
    # @overload delete_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def delete_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:delete_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Deletes the specified subnet. You must terminate all running instances
    # in the subnet before you can delete the subnet.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a subnet
    #
    #   # This example deletes the specified subnet.
    #
    #   resp = client.delete_subnet({
    #     subnet_id: "subnet-9d4a7b6c", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_subnet({
    #     subnet_id: "SubnetId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet AWS API Documentation
    #
    # @overload delete_subnet(params = {})
    # @param [Hash] params ({})
    def delete_subnet(params = {}, options = {})
      req = build_request(:delete_subnet, params)
      req.send_request(options)
    end

    # Deletes the specified set of tags from the specified set of resources.
    #
    # To list the current tags, use DescribeTags. For more information about
    # tags, see [Tagging Your Resources][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #
    # @option params [Array<Types::Tag>] :tags
    #   The tags to delete. Specify a tag key and an optional tag value to
    #   delete specific tags. If you specify a tag key without a tag value, we
    #   delete any tag with this key regardless of its value. If you specify a
    #   tag key with an empty string as the tag value, we delete the tag only
    #   if its value is an empty string.
    #
    #   If you omit this parameter, we delete all user-defined tags for the
    #   specified resources. We do not delete AWS-generated tags (tags that
    #   have the `aws:` prefix).
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a tag from a resource
    #
    #   # This example deletes the tag Stack=test from the specified image.
    #
    #   resp = client.delete_tags({
    #     resources: [
    #       "ami-78a54011", 
    #     ], 
    #     tags: [
    #       {
    #         key: "Stack", 
    #         value: "test", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_tags({
    #     dry_run: false,
    #     resources: ["TaggableResourceId"], # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags AWS API Documentation
    #
    # @overload delete_tags(params = {})
    # @param [Hash] params ({})
    def delete_tags(params = {}, options = {})
      req = build_request(:delete_tags, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror filter.
    #
    # You cannot delete a Traffic Mirror filter that is in use by a Traffic
    # Mirror session.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorFilterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorFilterResult#traffic_mirror_filter_id #traffic_mirror_filter_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_filter({
    #     traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter AWS API Documentation
    #
    # @overload delete_traffic_mirror_filter(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_filter(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_filter, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror rule.
    #
    # @option params [required, String] :traffic_mirror_filter_rule_id
    #   The ID of the Traffic Mirror rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorFilterRuleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorFilterRuleResult#traffic_mirror_filter_rule_id #traffic_mirror_filter_rule_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_filter_rule({
    #     traffic_mirror_filter_rule_id: "TrafficMirrorFilterRuleId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_rule_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule AWS API Documentation
    #
    # @overload delete_traffic_mirror_filter_rule(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_filter_rule(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_filter_rule, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror session.
    #
    # @option params [required, String] :traffic_mirror_session_id
    #   The ID of the Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorSessionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorSessionResult#traffic_mirror_session_id #traffic_mirror_session_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_session({
    #     traffic_mirror_session_id: "TrafficMirrorSessionId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_session_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession AWS API Documentation
    #
    # @overload delete_traffic_mirror_session(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_session(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_session, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror target.
    #
    # You cannot delete a Traffic Mirror target that is in use by a Traffic
    # Mirror session.
    #
    # @option params [required, String] :traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorTargetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorTargetResult#traffic_mirror_target_id #traffic_mirror_target_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_target({
    #     traffic_mirror_target_id: "TrafficMirrorTargetId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_target_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget AWS API Documentation
    #
    # @overload delete_traffic_mirror_target(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_target(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_target, params)
      req.send_request(options)
    end

    # Deletes the specified transit gateway.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayResult#transit_gateway #transit_gateway} => Types::TransitGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway.transit_gateway_id #=> String
    #   resp.transit_gateway.transit_gateway_arn #=> String
    #   resp.transit_gateway.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateway.owner_id #=> String
    #   resp.transit_gateway.description #=> String
    #   resp.transit_gateway.creation_time #=> Time
    #   resp.transit_gateway.options.amazon_side_asn #=> Integer
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks #=> Array
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks[0] #=> String
    #   resp.transit_gateway.options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.association_default_route_table_id #=> String
    #   resp.transit_gateway.options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.propagation_default_route_table_id #=> String
    #   resp.transit_gateway.options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.multicast_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.tags #=> Array
    #   resp.transit_gateway.tags[0].key #=> String
    #   resp.transit_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway AWS API Documentation
    #
    # @overload delete_transit_gateway(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway(params = {}, options = {})
      req = build_request(:delete_transit_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified Connect attachment. You must first delete any
    # Connect peers for the attachment.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayConnectResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayConnectResult#transit_gateway_connect #transit_gateway_connect} => Types::TransitGatewayConnect
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_connect({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transport_transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transit_gateway_id #=> String
    #   resp.transit_gateway_connect.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_connect.creation_time #=> Time
    #   resp.transit_gateway_connect.options.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect.tags #=> Array
    #   resp.transit_gateway_connect.tags[0].key #=> String
    #   resp.transit_gateway_connect.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect AWS API Documentation
    #
    # @overload delete_transit_gateway_connect(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_connect(params = {}, options = {})
      req = build_request(:delete_transit_gateway_connect, params)
      req.send_request(options)
    end

    # Deletes the specified Connect peer.
    #
    # @option params [required, String] :transit_gateway_connect_peer_id
    #   The ID of the Connect peer.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayConnectPeerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayConnectPeerResult#transit_gateway_connect_peer #transit_gateway_connect_peer} => Types::TransitGatewayConnectPeer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_connect_peer({
    #     transit_gateway_connect_peer_id: "TransitGatewayConnectPeerId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect_peer.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect_peer.transit_gateway_connect_peer_id #=> String
    #   resp.transit_gateway_connect_peer.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_connect_peer.creation_time #=> Time
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks[0] #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].bgp_status #=> String, one of "up", "down"
    #   resp.transit_gateway_connect_peer.tags #=> Array
    #   resp.transit_gateway_connect_peer.tags[0].key #=> String
    #   resp.transit_gateway_connect_peer.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer AWS API Documentation
    #
    # @overload delete_transit_gateway_connect_peer(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_connect_peer(params = {}, options = {})
      req = build_request(:delete_transit_gateway_connect_peer, params)
      req.send_request(options)
    end

    # Deletes the specified transit gateway multicast domain.
    #
    # @option params [required, String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayMulticastDomainResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayMulticastDomainResult#transit_gateway_multicast_domain #transit_gateway_multicast_domain} => Types::TransitGatewayMulticastDomain
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_multicast_domain({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_arn #=> String
    #   resp.transit_gateway_multicast_domain.owner_id #=> String
    #   resp.transit_gateway_multicast_domain.options.igmpv_2_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.static_sources_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.auto_accept_shared_associations #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_multicast_domain.creation_time #=> Time
    #   resp.transit_gateway_multicast_domain.tags #=> Array
    #   resp.transit_gateway_multicast_domain.tags[0].key #=> String
    #   resp.transit_gateway_multicast_domain.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain AWS API Documentation
    #
    # @overload delete_transit_gateway_multicast_domain(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_multicast_domain(params = {}, options = {})
      req = build_request(:delete_transit_gateway_multicast_domain, params)
      req.send_request(options)
    end

    # Deletes a transit gateway peering attachment.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the transit gateway peering attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayPeeringAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayPeeringAttachmentResult#transit_gateway_peering_attachment #transit_gateway_peering_attachment} => Types::TransitGatewayPeeringAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_peering_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_peering_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.status.code #=> String
    #   resp.transit_gateway_peering_attachment.status.message #=> String
    #   resp.transit_gateway_peering_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_peering_attachment.creation_time #=> Time
    #   resp.transit_gateway_peering_attachment.tags #=> Array
    #   resp.transit_gateway_peering_attachment.tags[0].key #=> String
    #   resp.transit_gateway_peering_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment AWS API Documentation
    #
    # @overload delete_transit_gateway_peering_attachment(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_peering_attachment(params = {}, options = {})
      req = build_request(:delete_transit_gateway_peering_attachment, params)
      req.send_request(options)
    end

    # Deletes a reference (route) to a prefix list in a specified transit
    # gateway route table.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the route table.
    #
    # @option params [required, String] :prefix_list_id
    #   The ID of the prefix list.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayPrefixListReferenceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayPrefixListReferenceResult#transit_gateway_prefix_list_reference #transit_gateway_prefix_list_reference} => Types::TransitGatewayPrefixListReference
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_prefix_list_reference({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     prefix_list_id: "PrefixListResourceId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_owner_id #=> String
    #   resp.transit_gateway_prefix_list_reference.state #=> String, one of "pending", "available", "modifying", "deleting"
    #   resp.transit_gateway_prefix_list_reference.blackhole #=> Boolean
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference AWS API Documentation
    #
    # @overload delete_transit_gateway_prefix_list_reference(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_prefix_list_reference(params = {}, options = {})
      req = build_request(:delete_transit_gateway_prefix_list_reference, params)
      req.send_request(options)
    end

    # Deletes the specified route from the specified transit gateway route
    # table.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayRouteResult#route #route} => Types::TransitGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_route({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     destination_cidr_block: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.prefix_list_id #=> String
    #   resp.route.transit_gateway_attachments #=> Array
    #   resp.route.transit_gateway_attachments[0].resource_id #=> String
    #   resp.route.transit_gateway_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.route.transit_gateway_attachments[0].resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering"
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute AWS API Documentation
    #
    # @overload delete_transit_gateway_route(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_route(params = {}, options = {})
      req = build_request(:delete_transit_gateway_route, params)
      req.send_request(options)
    end

    # Deletes the specified transit gateway route table. You must
    # disassociate the route table from any transit gateway route tables
    # before you can delete it.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayRouteTableResult#transit_gateway_route_table #transit_gateway_route_table} => Types::TransitGatewayRouteTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_route_table({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_route_table.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_route_table.transit_gateway_id #=> String
    #   resp.transit_gateway_route_table.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_route_table.default_association_route_table #=> Boolean
    #   resp.transit_gateway_route_table.default_propagation_route_table #=> Boolean
    #   resp.transit_gateway_route_table.creation_time #=> Time
    #   resp.transit_gateway_route_table.tags #=> Array
    #   resp.transit_gateway_route_table.tags[0].key #=> String
    #   resp.transit_gateway_route_table.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable AWS API Documentation
    #
    # @overload delete_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:delete_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Deletes the specified VPC attachment.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_vpc_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.appliance_mode_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload delete_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:delete_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Deletes the specified EBS volume. The volume must be in the
    # `available` state (not attached to an instance).
    #
    # The volume can remain in the `deleting` state for several minutes.
    #
    # For more information, see [Deleting an Amazon EBS volume][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html
    #
    # @option params [required, String] :volume_id
    #   The ID of the volume.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a volume
    #
    #   # This example deletes an available volume with the volume ID of ``vol-049df61146c4d7901``. If the command succeeds, no
    #   # output is returned.
    #
    #   resp = client.delete_volume({
    #     volume_id: "vol-049df61146c4d7901", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_volume({
    #     volume_id: "VolumeId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume AWS API Documentation
    #
    # @overload delete_volume(params = {})
    # @param [Hash] params ({})
    def delete_volume(params = {}, options = {})
      req = build_request(:delete_volume, params)
      req.send_request(options)
    end

    # Deletes the specified VPC. You must detach or delete all gateways and
    # resources that are associated with the VPC before you can delete it.
    # For example, you must terminate all instances running in the VPC,
    # delete all security groups associated with the VPC (except the default
    # one), delete all route tables associated with the VPC (except the
    # default one), and so on.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a VPC
    #
    #   # This example deletes the specified VPC.
    #
    #   resp = client.delete_vpc({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc({
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc AWS API Documentation
    #
    # @overload delete_vpc(params = {})
    # @param [Hash] params ({})
    def delete_vpc(params = {}, options = {})
      req = build_request(:delete_vpc, params)
      req.send_request(options)
    end

    # Deletes one or more VPC endpoint connection notifications.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :connection_notification_ids
    #   One or more notification IDs.
    #
    # @return [Types::DeleteVpcEndpointConnectionNotificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointConnectionNotificationsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoint_connection_notifications({
    #     dry_run: false,
    #     connection_notification_ids: ["ConnectionNotificationId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications AWS API Documentation
    #
    # @overload delete_vpc_endpoint_connection_notifications(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoint_connection_notifications(params = {}, options = {})
      req = build_request(:delete_vpc_endpoint_connection_notifications, params)
      req.send_request(options)
    end

    # Deletes one or more VPC endpoint service configurations in your
    # account. Before you delete the endpoint service configuration, you
    # must reject any `Available` or `PendingAcceptance` interface endpoint
    # connections that are attached to the service.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :service_ids
    #   The IDs of one or more services.
    #
    # @return [Types::DeleteVpcEndpointServiceConfigurationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointServiceConfigurationsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoint_service_configurations({
    #     dry_run: false,
    #     service_ids: ["VpcEndpointServiceId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations AWS API Documentation
    #
    # @overload delete_vpc_endpoint_service_configurations(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoint_service_configurations(params = {}, options = {})
      req = build_request(:delete_vpc_endpoint_service_configurations, params)
      req.send_request(options)
    end

    # Deletes one or more specified VPC endpoints. You can delete any of the
    # following types of VPC endpoints.
    #
    # * Gateway endpoint,
    #
    # * Gateway Load Balancer endpoint,
    #
    # * Interface endpoint
    #
    # The following rules apply when you delete a VPC endpoint:
    #
    # * When you delete a gateway endpoint, we delete the endpoint routes in
    #   the route tables that are associated with the endpoint.
    #
    # * When you delete a Gateway Load Balancer endpoint, we delete the
    #   endpoint network interfaces.
    #
    #   You can only delete Gateway Load Balancer endpoints when the routes
    #   that are associated with the endpoint are deleted.
    #
    # * When you delete an interface endpoint, we delete the endpoint
    #   network interfaces.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :vpc_endpoint_ids
    #   One or more VPC endpoint IDs.
    #
    # @return [Types::DeleteVpcEndpointsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoints({
    #     dry_run: false,
    #     vpc_endpoint_ids: ["VpcEndpointId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints AWS API Documentation
    #
    # @overload delete_vpc_endpoints(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoints(params = {}, options = {})
      req = build_request(:delete_vpc_endpoints, params)
      req.send_request(options)
    end

    # Deletes a VPC peering connection. Either the owner of the requester
    # VPC or the owner of the accepter VPC can delete the VPC peering
    # connection if it's in the `active` state. The owner of the requester
    # VPC can delete a VPC peering connection in the `pending-acceptance`
    # state. You cannot delete a VPC peering connection that's in the
    # `failed` state.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_peering_connection_id
    #   The ID of the VPC peering connection.
    #
    # @return [Types::DeleteVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcPeeringConnectionResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_peering_connection({
    #     dry_run: false,
    #     vpc_peering_connection_id: "VpcPeeringConnectionId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection AWS API Documentation
    #
    # @overload delete_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def delete_vpc_peering_connection(params = {}, options = {})
      req = build_request(:delete_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Deletes the specified VPN connection.
    #
    # If you're deleting the VPC and its associated components, we
    # recommend that you detach the virtual private gateway from the VPC and
    # delete the VPC before deleting the VPN connection. If you believe that
    # the tunnel credentials for your VPN connection have been compromised,
    # you can delete the VPN connection and create a new one that has new
    # keys, without needing to delete the VPC or virtual private gateway. If
    # you create a new VPN connection, you must reconfigure the customer
    # gateway device using the new configuration information returned with
    # the new VPN connection ID.
    #
    # For certificate-based authentication, delete all AWS Certificate
    # Manager (ACM) private certificates used for the AWS-side tunnel
    # endpoints for the VPN connection before deleting the VPN connection.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_connection({
    #     vpn_connection_id: "VpnConnectionId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection AWS API Documentation
    #
    # @overload delete_vpn_connection(params = {})
    # @param [Hash] params ({})
    def delete_vpn_connection(params = {}, options = {})
      req = build_request(:delete_vpn_connection, params)
      req.send_request(options)
    end

    # Deletes the specified static route associated with a VPN connection
    # between an existing virtual private gateway and a VPN customer
    # gateway. The static route allows traffic to be routed from the virtual
    # private gateway to the VPN customer gateway.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_connection_route({
    #     destination_cidr_block: "String", # required
    #     vpn_connection_id: "VpnConnectionId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute AWS API Documentation
    #
    # @overload delete_vpn_connection_route(params = {})
    # @param [Hash] params ({})
    def delete_vpn_connection_route(params = {}, options = {})
      req = build_request(:delete_vpn_connection_route, params)
      req.send_request(options)
    end

    # Deletes the specified virtual private gateway. You must first detach
    # the virtual private gateway from the VPC. Note that you don't need to
    # delete the virtual private gateway if you plan to delete and recreate
    # the VPN connection between your VPC and your network.
    #
    # @option params [required, String] :vpn_gateway_id
    #   The ID of the virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_gateway({
    #     vpn_gateway_id: "VpnGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway AWS API Documentation
    #
    # @overload delete_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def delete_vpn_gateway(params = {}, options = {})
      req = build_request(:delete_vpn_gateway, params)
      req.send_request(options)
    end

    # Releases the specified address range that you provisioned for use with
    # your AWS resources through bring your own IP addresses (BYOIP) and
    # deletes the corresponding address pool.
    #
    # Before you can release an address range, you must stop advertising it
    # using WithdrawByoipCidr and you must not have any IP addresses
    # allocated from its address range.
    #
    # @option params [required, String] :cidr
    #   The address range, in CIDR notation. The prefix must be the same
    #   prefix that you specified when you provisioned the address range.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeprovisionByoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeprovisionByoipCidrResult#byoip_cidr #byoip_cidr} => Types::ByoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deprovision_byoip_cidr({
    #     cidr: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidr.cidr #=> String
    #   resp.byoip_cidr.description #=> String
    #   resp.byoip_cidr.status_message #=> String
    #   resp.byoip_cidr.state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned", "provisioned-not-publicly-advertisable"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr AWS API Documentation
    #
    # @overload deprovision_byoip_cidr(params = {})
    # @param [Hash] params ({})
    def deprovision_byoip_cidr(params = {}, options = {})
      req = build_request(:deprovision_byoip_cidr, params)
      req.send_request(options)
    end

    # Deregisters the specified AMI. After you deregister an AMI, it can't
    # be used to launch new instances; however, it doesn't affect any
    # instances that you've already launched from the AMI. You'll continue
    # to incur usage costs for those instances until you terminate them.
    #
    # When you deregister an Amazon EBS-backed AMI, it doesn't affect the
    # snapshot that was created for the root volume of the instance during
    # the AMI creation process. When you deregister an instance store-backed
    # AMI, it doesn't affect the files that you uploaded to Amazon S3 when
    # you created the AMI.
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_image({
    #     image_id: "ImageId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage AWS API Documentation
    #
    # @overload deregister_image(params = {})
    # @param [Hash] params ({})
    def deregister_image(params = {}, options = {})
      req = build_request(:deregister_image, params)
      req.send_request(options)
    end

    # Deregisters tag keys to prevent tags that have the specified tag keys
    # from being included in scheduled event notifications for resources in
    # the Region.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Types::DeregisterInstanceTagAttributeRequest] :instance_tag_attribute
    #   Information about the tag keys to deregister.
    #
    # @return [Types::DeregisterInstanceEventNotificationAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeregisterInstanceEventNotificationAttributesResult#instance_tag_attribute #instance_tag_attribute} => Types::InstanceTagNotificationAttribute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_instance_event_notification_attributes({
    #     dry_run: false,
    #     instance_tag_attribute: {
    #       include_all_tags_of_instance: false,
    #       instance_tag_keys: ["String"],
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_tag_attribute.instance_tag_keys #=> Array
    #   resp.instance_tag_attribute.instance_tag_keys[0] #=> String
    #   resp.instance_tag_attribute.include_all_tags_of_instance #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes AWS API Documentation
    #
    # @overload deregister_instance_event_notification_attributes(params = {})
    # @param [Hash] params ({})
    def deregister_instance_event_notification_attributes(params = {}, options = {})
      req = build_request(:deregister_instance_event_notification_attributes, params)
      req.send_request(options)
    end

    # Deregisters the specified members (network interfaces) from the
    # transit gateway multicast group.
    #
    # @option params [String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [String] :group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #
    # @option params [Array<String>] :network_interface_ids
    #   The IDs of the group members' network interfaces.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeregisterTransitGatewayMulticastGroupMembersResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeregisterTransitGatewayMulticastGroupMembersResult#deregistered_multicast_group_members #deregistered_multicast_group_members} => Types::TransitGatewayMulticastDeregisteredGroupMembers
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_transit_gateway_multicast_group_members({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #     group_ip_address: "String",
    #     network_interface_ids: ["NetworkInterfaceId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.deregistered_multicast_group_members.transit_gateway_multicast_domain_id #=> String
    #   resp.deregistered_multicast_group_members.deregistered_network_interface_ids #=> Array
    #   resp.deregistered_multicast_group_members.deregistered_network_interface_ids[0] #=> String
    #   resp.deregistered_multicast_group_members.group_ip_address #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers AWS API Documentation
    #
    # @overload deregister_transit_gateway_multicast_group_members(params = {})
    # @param [Hash] params ({})
    def deregister_transit_gateway_multicast_group_members(params = {}, options = {})
      req = build_request(:deregister_transit_gateway_multicast_group_members, params)
      req.send_request(options)
    end

    # Deregisters the specified sources (network interfaces) from the
    # transit gateway multicast group.
    #
    # @option params [String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [String] :group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #
    # @option params [Array<String>] :network_interface_ids
    #   The IDs of the group sources' network interfaces.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeregisterTransitGatewayMulticastGroupSourcesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeregisterTransitGatewayMulticastGroupSourcesResult#deregistered_multicast_group_sources #deregistered_multicast_group_sources} => Types::TransitGatewayMulticastDeregisteredGroupSources
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_transit_gateway_multicast_group_sources({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #     group_ip_address: "String",
    #     network_interface_ids: ["NetworkInterfaceId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.deregistered_multicast_group_sources.transit_gateway_multicast_domain_id #=> String
    #   resp.deregistered_multicast_group_sources.deregistered_network_interface_ids #=> Array
    #   resp.deregistered_multicast_group_sources.deregistered_network_interface_ids[0] #=> String
    #   resp.deregistered_multicast_group_sources.group_ip_address #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources AWS API Documentation
    #
    # @overload deregister_transit_gateway_multicast_group_sources(params = {})
    # @param [Hash] params ({})
    def deregister_transit_gateway_multicast_group_sources(params = {}, options = {})
      req = build_request(:deregister_transit_gateway_multicast_group_sources, params)
      req.send_request(options)
    end

    # Describes attributes of your AWS account. The following are the
    # supported account attributes:
    #
    # * `supported-platforms`\: Indicates whether your account can launch
    #   instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.
    #
    # * `default-vpc`\: The ID of the default VPC for your account, or
    #   `none`.
    #
    # * `max-instances`\: This attribute is no longer supported. The
    #   returned value does not reflect your actual vCPU limit for running
    #   On-Demand Instances. For more information, see [On-Demand Instance
    #   Limits][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # * `vpc-max-security-groups-per-interface`\: The maximum number of
    #   security groups that you can assign to a network interface.
    #
    # * `max-elastic-ips`\: The maximum number of Elastic IP addresses that
    #   you can allocate for use with EC2-Classic.
    #
    # * `vpc-max-elastic-ips`\: The maximum number of Elastic IP addresses
    #   that you can allocate for use with EC2-VPC.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits
    #
    # @option params [Array<String>] :attribute_names
    #   The account attribute names.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAccountAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAccountAttributesResult#account_attributes #account_attributes} => Array&lt;Types::AccountAttribute&gt;
    #
    #
    # @example Example: To describe a single attribute for your AWS account
    #
    #   # This example describes the supported-platforms attribute for your AWS account.
    #
    #   resp = client.describe_account_attributes({
    #     attribute_names: [
    #       "supported-platforms", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     account_attributes: [
    #       {
    #         attribute_name: "supported-platforms", 
    #         attribute_values: [
    #           {
    #             attribute_value: "EC2", 
    #           }, 
    #           {
    #             attribute_value: "VPC", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe all attributes for your AWS account
    #
    #   # This example describes the attributes for your AWS account.
    #
    #   resp = client.describe_account_attributes({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     account_attributes: [
    #       {
    #         attribute_name: "supported-platforms", 
    #         attribute_values: [
    #           {
    #             attribute_value: "EC2", 
    #           }, 
    #           {
    #             attribute_value: "VPC", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "vpc-max-security-groups-per-interface", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "max-elastic-ips", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "max-instances", 
    #         attribute_values: [
    #           {
    #             attribute_value: "20", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "vpc-max-elastic-ips", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "default-vpc", 
    #         attribute_values: [
    #           {
    #             attribute_value: "none", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_account_attributes({
    #     attribute_names: ["supported-platforms"], # accepts supported-platforms, default-vpc
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.account_attributes #=> Array
    #   resp.account_attributes[0].attribute_name #=> String
    #   resp.account_attributes[0].attribute_values #=> Array
    #   resp.account_attributes[0].attribute_values[0].attribute_value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes AWS API Documentation
    #
    # @overload describe_account_attributes(params = {})
    # @param [Hash] params ({})
    def describe_account_attributes(params = {}, options = {})
      req = build_request(:describe_account_attributes, params)
      req.send_request(options)
    end

    # Describes the specified Elastic IP addresses or all of your Elastic IP
    # addresses.
    #
    # An Elastic IP address is for use in either the EC2-Classic platform or
    # in a VPC. For more information, see [Elastic IP Addresses][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `allocation-id` - \[EC2-VPC\] The allocation ID for the address.
    #
    #   * `association-id` - \[EC2-VPC\] The association ID for the address.
    #
    #   * `domain` - Indicates whether the address is for use in EC2-Classic
    #     (`standard`) or in a VPC (`vpc`).
    #
    #   * `instance-id` - The ID of the instance the address is associated
    #     with, if any.
    #
    #   * `network-border-group` - A unique set of Availability Zones, Local
    #     Zones, or Wavelength Zones from where AWS advertises IP addresses.
    #
    #   * `network-interface-id` - \[EC2-VPC\] The ID of the network interface
    #     that the address is associated with, if any.
    #
    #   * `network-interface-owner-id` - The AWS account ID of the owner.
    #
    #   * `private-ip-address` - \[EC2-VPC\] The private IP address associated
    #     with the Elastic IP address.
    #
    #   * `public-ip` - The Elastic IP address, or the carrier IP address.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :public_ips
    #   One or more Elastic IP addresses.
    #
    #   Default: Describes all your Elastic IP addresses.
    #
    # @option params [Array<String>] :allocation_ids
    #   \[EC2-VPC\] Information about the allocation IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAddressesResult#addresses #addresses} => Array&lt;Types::Address&gt;
    #
    #
    # @example Example: To describe your Elastic IP addresses
    #
    #   # This example describes your Elastic IP addresses.
    #
    #   resp = client.describe_addresses({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         domain: "standard", 
    #         instance_id: "i-1234567890abcdef0", 
    #         public_ip: "198.51.100.0", 
    #       }, 
    #       {
    #         allocation_id: "eipalloc-12345678", 
    #         association_id: "eipassoc-12345678", 
    #         domain: "vpc", 
    #         instance_id: "i-1234567890abcdef0", 
    #         network_interface_id: "eni-12345678", 
    #         network_interface_owner_id: "123456789012", 
    #         private_ip_address: "10.0.1.241", 
    #         public_ip: "203.0.113.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe your Elastic IP addresses for EC2-VPC
    #
    #   # This example describes your Elastic IP addresses for use with instances in a VPC.
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "domain", 
    #         values: [
    #           "vpc", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         allocation_id: "eipalloc-12345678", 
    #         association_id: "eipassoc-12345678", 
    #         domain: "vpc", 
    #         instance_id: "i-1234567890abcdef0", 
    #         network_interface_id: "eni-12345678", 
    #         network_interface_owner_id: "123456789012", 
    #         private_ip_address: "10.0.1.241", 
    #         public_ip: "203.0.113.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe your Elastic IP addresses for EC2-Classic
    #
    #   # This example describes your Elastic IP addresses for use with instances in EC2-Classic.
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "domain", 
    #         values: [
    #           "standard", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         domain: "standard", 
    #         instance_id: "i-1234567890abcdef0", 
    #         public_ip: "198.51.100.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     public_ips: ["String"],
    #     allocation_ids: ["AllocationId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.addresses #=> Array
    #   resp.addresses[0].instance_id #=> String
    #   resp.addresses[0].public_ip #=> String
    #   resp.addresses[0].allocation_id #=> String
    #   resp.addresses[0].association_id #=> String
    #   resp.addresses[0].domain #=> String, one of "vpc", "standard"
    #   resp.addresses[0].network_interface_id #=> String
    #   resp.addresses[0].network_interface_owner_id #=> String
    #   resp.addresses[0].private_ip_address #=> String
    #   resp.addresses[0].tags #=> Array
    #   resp.addresses[0].tags[0].key #=> String
    #   resp.addresses[0].tags[0].value #=> String
    #   resp.addresses[0].public_ipv_4_pool #=> String
    #   resp.addresses[0].network_border_group #=> String
    #   resp.addresses[0].customer_owned_ip #=> String
    #   resp.addresses[0].customer_owned_ipv_4_pool #=> String
    #   resp.addresses[0].carrier_ip #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses AWS API Documentation
    #
    # @overload describe_addresses(params = {})
    # @param [Hash] params ({})
    def describe_addresses(params = {}, options = {})
      req = build_request(:describe_addresses, params)
      req.send_request(options)
    end

    # Describes the attributes of the specified Elastic IP addresses. For
    # requirements, see [Using reverse DNS for email applications][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS
    #
    # @option params [Array<String>] :allocation_ids
    #   \[EC2-VPC\] The allocation IDs.
    #
    # @option params [String] :attribute
    #   The attribute of the IP address.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAddressesAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAddressesAttributeResult#addresses #addresses} => Array&lt;Types::AddressAttribute&gt;
    #   * {Types::DescribeAddressesAttributeResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_addresses_attribute({
    #     allocation_ids: ["AllocationId"],
    #     attribute: "domain-name", # accepts domain-name
    #     next_token: "NextToken",
    #     max_results: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.addresses #=> Array
    #   resp.addresses[0].public_ip #=> String
    #   resp.addresses[0].allocation_id #=> String
    #   resp.addresses[0].ptr_record #=> String
    #   resp.addresses[0].ptr_record_update.value #=> String
    #   resp.addresses[0].ptr_record_update.status #=> String
    #   resp.addresses[0].ptr_record_update.reason #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute AWS API Documentation
    #
    # @overload describe_addresses_attribute(params = {})
    # @param [Hash] params ({})
    def describe_addresses_attribute(params = {}, options = {})
      req = build_request(:describe_addresses_attribute, params)
      req.send_request(options)
    end

    # Describes the longer ID format settings for all resource types in a
    # specific Region. This request is useful for performing a quick audit
    # to determine whether a specific Region is fully opted in for longer
    # IDs (17-character IDs).
    #
    # This request only returns information about resource types that
    # support longer IDs.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAggregateIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAggregateIdFormatResult#use_long_ids_aggregated #use_long_ids_aggregated} => Boolean
    #   * {Types::DescribeAggregateIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_aggregate_id_format({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.use_long_ids_aggregated #=> Boolean
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat AWS API Documentation
    #
    # @overload describe_aggregate_id_format(params = {})
    # @param [Hash] params ({})
    def describe_aggregate_id_format(params = {}, options = {})
      req = build_request(:describe_aggregate_id_format, params)
      req.send_request(options)
    end

    # Describes the Availability Zones, Local Zones, and Wavelength Zones
    # that are available to you. If there is an event impacting a zone, you
    # can use this request to view the state and any provided messages for
    # that zone.
    #
    # For more information about Availability Zones, Local Zones, and
    # Wavelength Zones, see [Regions, Zones and Outposts][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `group-name` - For Availability Zones, use the Region name. For
    #     Local Zones, use the name of the group associated with the Local
    #     Zone (for example, `us-west-2-lax-1`) For Wavelength Zones, use the
    #     name of the group associated with the Wavelength Zone (for example,
    #     `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `message` - The Zone message.
    #
    #   * `opt-in-status` - The opt-in status (`opted-in`, and `not-opted-in`
    #     \| `opt-in-not-required`).
    #
    #   * `parent-zoneID` - The ID of the zone that handles some of the Local
    #     Zone and Wavelength Zone control plane operations, such as API
    #     calls.
    #
    #   * `parent-zoneName` - The ID of the zone that handles some of the
    #     Local Zone and Wavelength Zone control plane operations, such as API
    #     calls.
    #
    #   * `region-name` - The name of the Region for the Zone (for example,
    #     `us-east-1`).
    #
    #   * `state` - The state of the Availability Zone, the Local Zone, or the
    #     Wavelength Zone (`available` \| `information` \| `impaired` \|
    #     `unavailable`).
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `use1-az1`), the Local Zone (for example, `usw2-lax1-az1`), or the
    #     Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-type` - The type of zone, for example, `local-zone`.
    #
    #   * `zone-name` - The name of the Availability Zone (for example,
    #     `us-east-1a`), the Local Zone (for example, `us-west-2-lax-1a`), or
    #     the Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-type` - The type of zone, for example, `local-zone`.
    #
    # @option params [Array<String>] :zone_names
    #   The names of the Availability Zones, Local Zones, and Wavelength
    #   Zones.
    #
    # @option params [Array<String>] :zone_ids
    #   The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
    #
    # @option params [Boolean] :all_availability_zones
    #   Include all Availability Zones, Local Zones, and Wavelength Zones
    #   regardless of your opt-in status.
    #
    #   If you do not use this parameter, the results include only the zones
    #   for the Regions where you have chosen the option to opt in.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAvailabilityZonesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAvailabilityZonesResult#availability_zones #availability_zones} => Array&lt;Types::AvailabilityZone&gt;
    #
    #
    # @example Example: To describe your Availability Zones
    #
    #   # This example describes the Availability Zones that are available to you. The response includes Availability Zones only
    #   # for the current region.
    #
    #   resp = client.describe_availability_zones({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     availability_zones: [
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1b", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1c", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1d", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1e", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_availability_zones({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     zone_names: ["String"],
    #     zone_ids: ["String"],
    #     all_availability_zones: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.availability_zones #=> Array
    #   resp.availability_zones[0].state #=> String, one of "available", "information", "impaired", "unavailable"
    #   resp.availability_zones[0].opt_in_status #=> String, one of "opt-in-not-required", "opted-in", "not-opted-in"
    #   resp.availability_zones[0].messages #=> Array
    #   resp.availability_zones[0].messages[0].message #=> String
    #   resp.availability_zones[0].region_name #=> String
    #   resp.availability_zones[0].zone_name #=> String
    #   resp.availability_zones[0].zone_id #=> String
    #   resp.availability_zones[0].group_name #=> String
    #   resp.availability_zones[0].network_border_group #=> String
    #   resp.availability_zones[0].zone_type #=> String
    #   resp.availability_zones[0].parent_zone_name #=> String
    #   resp.availability_zones[0].parent_zone_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones AWS API Documentation
    #
    # @overload describe_availability_zones(params = {})
    # @param [Hash] params ({})
    def describe_availability_zones(params = {}, options = {})
      req = build_request(:describe_availability_zones, params)
      req.send_request(options)
    end

    # Describes the specified bundle tasks or all of your bundle tasks.
    #
    # <note markdown="1"> Completed bundle tasks are listed for only a limited time. If your
    # bundle task is no longer in the list, you can still register an AMI
    # from it. Just use `RegisterImage` with the Amazon S3 bucket name and
    # image manifest name you provided to the bundle task.
    #
    #  </note>
    #
    # @option params [Array<String>] :bundle_ids
    #   The bundle task IDs.
    #
    #   Default: Describes all your bundle tasks.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `bundle-id` - The ID of the bundle task.
    #
    #   * `error-code` - If the task failed, the error code returned.
    #
    #   * `error-message` - If the task failed, the error message returned.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `progress` - The level of task completion, as a percentage (for
    #     example, 20%).
    #
    #   * `s3-bucket` - The Amazon S3 bucket to store the AMI.
    #
    #   * `s3-prefix` - The beginning of the AMI name.
    #
    #   * `start-time` - The time the task started (for example,
    #     2013-09-15T17:15:20.000Z).
    #
    #   * `state` - The state of the task (`pending` \| `waiting-for-shutdown`
    #     \| `bundling` \| `storing` \| `cancelling` \| `complete` \|
    #     `failed`).
    #
    #   * `update-time` - The time of the most recent update for the task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeBundleTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeBundleTasksResult#bundle_tasks #bundle_tasks} => Array&lt;Types::BundleTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_bundle_tasks({
    #     bundle_ids: ["BundleId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_tasks #=> Array
    #   resp.bundle_tasks[0].bundle_id #=> String
    #   resp.bundle_tasks[0].bundle_task_error.code #=> String
    #   resp.bundle_tasks[0].bundle_task_error.message #=> String
    #   resp.bundle_tasks[0].instance_id #=> String
    #   resp.bundle_tasks[0].progress #=> String
    #   resp.bundle_tasks[0].start_time #=> Time
    #   resp.bundle_tasks[0].state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_tasks[0].storage.s3.aws_access_key_id #=> String
    #   resp.bundle_tasks[0].storage.s3.bucket #=> String
    #   resp.bundle_tasks[0].storage.s3.prefix #=> String
    #   resp.bundle_tasks[0].storage.s3.upload_policy #=> String
    #   resp.bundle_tasks[0].storage.s3.upload_policy_signature #=> String
    #   resp.bundle_tasks[0].update_time #=> Time
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * bundle_task_complete
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks AWS API Documentation
    #
    # @overload describe_bundle_tasks(params = {})
    # @param [Hash] params ({})
    def describe_bundle_tasks(params = {}, options = {})
      req = build_request(:describe_bundle_tasks, params)
      req.send_request(options)
    end

    # Describes the IP address ranges that were specified in calls to
    # ProvisionByoipCidr.
    #
    # To describe the address pools that were created when you provisioned
    # the address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeByoipCidrsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeByoipCidrsResult#byoip_cidrs #byoip_cidrs} => Array&lt;Types::ByoipCidr&gt;
    #   * {Types::DescribeByoipCidrsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_byoip_cidrs({
    #     dry_run: false,
    #     max_results: 1, # required
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidrs #=> Array
    #   resp.byoip_cidrs[0].cidr #=> String
    #   resp.byoip_cidrs[0].description #=> String
    #   resp.byoip_cidrs[0].status_message #=> String
    #   resp.byoip_cidrs[0].state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned", "provisioned-not-publicly-advertisable"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs AWS API Documentation
    #
    # @overload describe_byoip_cidrs(params = {})
    # @param [Hash] params ({})
    def describe_byoip_cidrs(params = {}, options = {})
      req = build_request(:describe_byoip_cidrs, params)
      req.send_request(options)
    end

    # Describes one or more of your Capacity Reservations. The results
    # describe only the Capacity Reservations in the AWS Region that you're
    # currently using.
    #
    # @option params [Array<String>] :capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `instance-type` - The type of instance for which the Capacity
    #     Reservation reserves capacity.
    #
    #   * `owner-id` - The ID of the AWS account that owns the Capacity
    #     Reservation.
    #
    #   * `availability-zone-id` - The Availability Zone ID of the Capacity
    #     Reservation.
    #
    #   * `instance-platform` - The type of operating system for which the
    #     Capacity Reservation reserves capacity.
    #
    #   * `availability-zone` - The Availability Zone ID of the Capacity
    #     Reservation.
    #
    #   * `tenancy` - Indicates the tenancy of the Capacity Reservation. A
    #     Capacity Reservation can have one of the following tenancy settings:
    #
    #     * `default` - The Capacity Reservation is created on hardware that
    #       is shared with other AWS accounts.
    #
    #     * `dedicated` - The Capacity Reservation is created on single-tenant
    #       hardware that is dedicated to a single AWS account.
    #
    #   * `state` - The current state of the Capacity Reservation. A Capacity
    #     Reservation can be in one of the following states:
    #
    #     * `active`- The Capacity Reservation is active and the capacity is
    #       available for your use.
    #
    #     * `expired` - The Capacity Reservation expired automatically at the
    #       date and time specified in your request. The reserved capacity is
    #       no longer available for your use.
    #
    #     * `cancelled` - The Capacity Reservation was cancelled. The reserved
    #       capacity is no longer available for your use.
    #
    #     * `pending` - The Capacity Reservation request was successful but
    #       the capacity provisioning is still pending.
    #
    #     * `failed` - The Capacity Reservation request has failed. A request
    #       might fail due to invalid request parameters, capacity
    #       constraints, or instance limit constraints. Failed requests are
    #       retained for 60 minutes.
    #
    #   * `start-date` - The date and time at which the Capacity Reservation
    #     was started.
    #
    #   * `end-date` - The date and time at which the Capacity Reservation
    #     expires. When a Capacity Reservation expires, the reserved capacity
    #     is released and you can no longer launch instances into it. The
    #     Capacity Reservation's state changes to expired when it reaches its
    #     end date and time.
    #
    #   * `end-date-type` - Indicates the way in which the Capacity
    #     Reservation ends. A Capacity Reservation can have one of the
    #     following end types:
    #
    #     * `unlimited` - The Capacity Reservation remains active until you
    #       explicitly cancel it.
    #
    #     * `limited` - The Capacity Reservation expires automatically at a
    #       specified date and time.
    #
    #   * `instance-match-criteria` - Indicates the type of instance launches
    #     that the Capacity Reservation accepts. The options include:
    #
    #     * `open` - The Capacity Reservation accepts all instances that have
    #       matching attributes (instance type, platform, and Availability
    #       Zone). Instances that have matching attributes launch into the
    #       Capacity Reservation automatically without specifying any
    #       additional parameters.
    #
    #     * `targeted` - The Capacity Reservation only accepts instances that
    #       have matching attributes (instance type, platform, and
    #       Availability Zone), and explicitly target the Capacity
    #       Reservation. This ensures that only permitted instances can use
    #       the reserved capacity.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCapacityReservationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCapacityReservationsResult#next_token #next_token} => String
    #   * {Types::DescribeCapacityReservationsResult#capacity_reservations #capacity_reservations} => Array&lt;Types::CapacityReservation&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_capacity_reservations({
    #     capacity_reservation_ids: ["CapacityReservationId"],
    #     next_token: "String",
    #     max_results: 1,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.capacity_reservations #=> Array
    #   resp.capacity_reservations[0].capacity_reservation_id #=> String
    #   resp.capacity_reservations[0].owner_id #=> String
    #   resp.capacity_reservations[0].capacity_reservation_arn #=> String
    #   resp.capacity_reservations[0].availability_zone_id #=> String
    #   resp.capacity_reservations[0].instance_type #=> String
    #   resp.capacity_reservations[0].instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise"
    #   resp.capacity_reservations[0].availability_zone #=> String
    #   resp.capacity_reservations[0].tenancy #=> String, one of "default", "dedicated"
    #   resp.capacity_reservations[0].total_instance_count #=> Integer
    #   resp.capacity_reservations[0].available_instance_count #=> Integer
    #   resp.capacity_reservations[0].ebs_optimized #=> Boolean
    #   resp.capacity_reservations[0].ephemeral_storage #=> Boolean
    #   resp.capacity_reservations[0].state #=> String, one of "active", "expired", "cancelled", "pending", "failed"
    #   resp.capacity_reservations[0].start_date #=> Time
    #   resp.capacity_reservations[0].end_date #=> Time
    #   resp.capacity_reservations[0].end_date_type #=> String, one of "unlimited", "limited"
    #   resp.capacity_reservations[0].instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.capacity_reservations[0].create_date #=> Time
    #   resp.capacity_reservations[0].tags #=> Array
    #   resp.capacity_reservations[0].tags[0].key #=> String
    #   resp.capacity_reservations[0].tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations AWS API Documentation
    #
    # @overload describe_capacity_reservations(params = {})
    # @param [Hash] params ({})
    def describe_capacity_reservations(params = {}, options = {})
      req = build_request(:describe_capacity_reservations, params)
      req.send_request(options)
    end

    # Describes one or more of your carrier gateways.
    #
    # @option params [Array<String>] :carrier_gateway_ids
    #   One or more carrier gateway IDs.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `carrier-gateway-id` - The ID of the carrier gateway.
    #
    #   * `state` - The state of the carrier gateway (`pending` \| `failed` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `owner-id` - The AWS account ID of the owner of the carrier gateway.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC associated with the carrier gateway.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCarrierGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCarrierGatewaysResult#carrier_gateways #carrier_gateways} => Array&lt;Types::CarrierGateway&gt;
    #   * {Types::DescribeCarrierGatewaysResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_carrier_gateways({
    #     carrier_gateway_ids: ["CarrierGatewayId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.carrier_gateways #=> Array
    #   resp.carrier_gateways[0].carrier_gateway_id #=> String
    #   resp.carrier_gateways[0].vpc_id #=> String
    #   resp.carrier_gateways[0].state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.carrier_gateways[0].owner_id #=> String
    #   resp.carrier_gateways[0].tags #=> Array
    #   resp.carrier_gateways[0].tags[0].key #=> String
    #   resp.carrier_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways AWS API Documentation
    #
    # @overload describe_carrier_gateways(params = {})
    # @param [Hash] params ({})
    def describe_carrier_gateways(params = {}, options = {})
      req = build_request(:describe_carrier_gateways, params)
      req.send_request(options)
    end

    # Describes one or more of your linked EC2-Classic instances. This
    # request only returns information about EC2-Classic instances linked to
    # a VPC through ClassicLink. You cannot use this request to return
    # information about other instances.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `group-id` - The ID of a VPC security group that's associated with
    #     the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC to which the instance is linked.
    #
    #     `vpc-id` - The ID of the VPC that the instance is linked to.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :instance_ids
    #   One or more instance IDs. Must be instances linked to a VPC through
    #   ClassicLink.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    #   Constraint: If the value is greater than 1000, we return only 1000
    #   items.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeClassicLinkInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClassicLinkInstancesResult#instances #instances} => Array&lt;Types::ClassicLinkInstance&gt;
    #   * {Types::DescribeClassicLinkInstancesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_classic_link_instances({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     instance_ids: ["InstanceId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.instances #=> Array
    #   resp.instances[0].groups #=> Array
    #   resp.instances[0].groups[0].group_name #=> String
    #   resp.instances[0].groups[0].group_id #=> String
    #   resp.instances[0].instance_id #=> String
    #   resp.instances[0].tags #=> Array
    #   resp.instances[0].tags[0].key #=> String
    #   resp.instances[0].tags[0].value #=> String
    #   resp.instances[0].vpc_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances AWS API Documentation
    #
    # @overload describe_classic_link_instances(params = {})
    # @param [Hash] params ({})
    def describe_classic_link_instances(params = {}, options = {})
      req = build_request(:describe_classic_link_instances, params)
      req.send_request(options)
    end

    # Describes the authorization rules for a specified Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `description` - The description of the authorization rule.
    #
    #   * `destination-cidr` - The CIDR of the network to which the
    #     authorization rule applies.
    #
    #   * `group-id` - The ID of the Active Directory group to which the
    #     authorization rule grants access.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @return [Types::DescribeClientVpnAuthorizationRulesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnAuthorizationRulesResult#authorization_rules #authorization_rules} => Array&lt;Types::AuthorizationRule&gt;
    #   * {Types::DescribeClientVpnAuthorizationRulesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_authorization_rules({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     dry_run: false,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.authorization_rules #=> Array
    #   resp.authorization_rules[0].client_vpn_endpoint_id #=> String
    #   resp.authorization_rules[0].description #=> String
    #   resp.authorization_rules[0].group_id #=> String
    #   resp.authorization_rules[0].access_all #=> Boolean
    #   resp.authorization_rules[0].destination_cidr #=> String
    #   resp.authorization_rules[0].status.code #=> String, one of "authorizing", "active", "failed", "revoking"
    #   resp.authorization_rules[0].status.message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules AWS API Documentation
    #
    # @overload describe_client_vpn_authorization_rules(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_authorization_rules(params = {}, options = {})
      req = build_request(:describe_client_vpn_authorization_rules, params)
      req.send_request(options)
    end

    # Describes active client connections and connections that have been
    # terminated within the last 60 minutes for the specified Client VPN
    # endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `connection-id` - The ID of the connection.
    #
    #   * `username` - For Active Directory client authentication, the user
    #     name of the client who established the client connection.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnConnectionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnConnectionsResult#connections #connections} => Array&lt;Types::ClientVpnConnection&gt;
    #   * {Types::DescribeClientVpnConnectionsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_connections({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "NextToken",
    #     max_results: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.connections #=> Array
    #   resp.connections[0].client_vpn_endpoint_id #=> String
    #   resp.connections[0].timestamp #=> String
    #   resp.connections[0].connection_id #=> String
    #   resp.connections[0].username #=> String
    #   resp.connections[0].connection_established_time #=> String
    #   resp.connections[0].ingress_bytes #=> String
    #   resp.connections[0].egress_bytes #=> String
    #   resp.connections[0].ingress_packets #=> String
    #   resp.connections[0].egress_packets #=> String
    #   resp.connections[0].client_ip #=> String
    #   resp.connections[0].common_name #=> String
    #   resp.connections[0].status.code #=> String, one of "active", "failed-to-terminate", "terminating", "terminated"
    #   resp.connections[0].status.message #=> String
    #   resp.connections[0].connection_end_time #=> String
    #   resp.connections[0].posture_compliance_statuses #=> Array
    #   resp.connections[0].posture_compliance_statuses[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections AWS API Documentation
    #
    # @overload describe_client_vpn_connections(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_connections(params = {}, options = {})
      req = build_request(:describe_client_vpn_connections, params)
      req.send_request(options)
    end

    # Describes one or more Client VPN endpoints in the account.
    #
    # @option params [Array<String>] :client_vpn_endpoint_ids
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `endpoint-id` - The ID of the Client VPN endpoint.
    #
    #   * `transport-protocol` - The transport protocol (`tcp` \| `udp`).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnEndpointsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnEndpointsResult#client_vpn_endpoints #client_vpn_endpoints} => Array&lt;Types::ClientVpnEndpoint&gt;
    #   * {Types::DescribeClientVpnEndpointsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_endpoints({
    #     client_vpn_endpoint_ids: ["ClientVpnEndpointId"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_endpoints #=> Array
    #   resp.client_vpn_endpoints[0].client_vpn_endpoint_id #=> String
    #   resp.client_vpn_endpoints[0].description #=> String
    #   resp.client_vpn_endpoints[0].status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.client_vpn_endpoints[0].status.message #=> String
    #   resp.client_vpn_endpoints[0].creation_time #=> String
    #   resp.client_vpn_endpoints[0].deletion_time #=> String
    #   resp.client_vpn_endpoints[0].dns_name #=> String
    #   resp.client_vpn_endpoints[0].client_cidr_block #=> String
    #   resp.client_vpn_endpoints[0].dns_servers #=> Array
    #   resp.client_vpn_endpoints[0].dns_servers[0] #=> String
    #   resp.client_vpn_endpoints[0].split_tunnel #=> Boolean
    #   resp.client_vpn_endpoints[0].vpn_protocol #=> String, one of "openvpn"
    #   resp.client_vpn_endpoints[0].transport_protocol #=> String, one of "tcp", "udp"
    #   resp.client_vpn_endpoints[0].vpn_port #=> Integer
    #   resp.client_vpn_endpoints[0].associated_target_networks #=> Array
    #   resp.client_vpn_endpoints[0].associated_target_networks[0].network_id #=> String
    #   resp.client_vpn_endpoints[0].associated_target_networks[0].network_type #=> String, one of "vpc"
    #   resp.client_vpn_endpoints[0].server_certificate_arn #=> String
    #   resp.client_vpn_endpoints[0].authentication_options #=> Array
    #   resp.client_vpn_endpoints[0].authentication_options[0].type #=> String, one of "certificate-authentication", "directory-service-authentication", "federated-authentication"
    #   resp.client_vpn_endpoints[0].authentication_options[0].active_directory.directory_id #=> String
    #   resp.client_vpn_endpoints[0].authentication_options[0].mutual_authentication.client_root_certificate_chain #=> String
    #   resp.client_vpn_endpoints[0].authentication_options[0].federated_authentication.saml_provider_arn #=> String
    #   resp.client_vpn_endpoints[0].authentication_options[0].federated_authentication.self_service_saml_provider_arn #=> String
    #   resp.client_vpn_endpoints[0].connection_log_options.enabled #=> Boolean
    #   resp.client_vpn_endpoints[0].connection_log_options.cloudwatch_log_group #=> String
    #   resp.client_vpn_endpoints[0].connection_log_options.cloudwatch_log_stream #=> String
    #   resp.client_vpn_endpoints[0].tags #=> Array
    #   resp.client_vpn_endpoints[0].tags[0].key #=> String
    #   resp.client_vpn_endpoints[0].tags[0].value #=> String
    #   resp.client_vpn_endpoints[0].security_group_ids #=> Array
    #   resp.client_vpn_endpoints[0].security_group_ids[0] #=> String
    #   resp.client_vpn_endpoints[0].vpc_id #=> String
    #   resp.client_vpn_endpoints[0].self_service_portal_url #=> String
    #   resp.client_vpn_endpoints[0].client_connect_options.enabled #=> Boolean
    #   resp.client_vpn_endpoints[0].client_connect_options.lambda_function_arn #=> String
    #   resp.client_vpn_endpoints[0].client_connect_options.status.code #=> String, one of "applying", "applied"
    #   resp.client_vpn_endpoints[0].client_connect_options.status.message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints AWS API Documentation
    #
    # @overload describe_client_vpn_endpoints(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_endpoints(params = {}, options = {})
      req = build_request(:describe_client_vpn_endpoints, params)
      req.send_request(options)
    end

    # Describes the routes for the specified Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `destination-cidr` - The CIDR of the route destination.
    #
    #   * `origin` - How the route was associated with the Client VPN endpoint
    #     (`associate` \| `add-route`).
    #
    #   * `target-subnet` - The ID of the subnet through which traffic is
    #     routed.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnRoutesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnRoutesResult#routes #routes} => Array&lt;Types::ClientVpnRoute&gt;
    #   * {Types::DescribeClientVpnRoutesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_routes({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.routes #=> Array
    #   resp.routes[0].client_vpn_endpoint_id #=> String
    #   resp.routes[0].destination_cidr #=> String
    #   resp.routes[0].target_subnet #=> String
    #   resp.routes[0].type #=> String
    #   resp.routes[0].origin #=> String
    #   resp.routes[0].status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.routes[0].status.message #=> String
    #   resp.routes[0].description #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes AWS API Documentation
    #
    # @overload describe_client_vpn_routes(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_routes(params = {}, options = {})
      req = build_request(:describe_client_vpn_routes, params)
      req.send_request(options)
    end

    # Describes the target networks associated with the specified Client VPN
    # endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<String>] :association_ids
    #   The IDs of the target network associations.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `association-id` - The ID of the association.
    #
    #   * `target-network-id` - The ID of the subnet specified as the target
    #     network.
    #
    #   * `vpc-id` - The ID of the VPC in which the target network is located.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnTargetNetworksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnTargetNetworksResult#client_vpn_target_networks #client_vpn_target_networks} => Array&lt;Types::TargetNetwork&gt;
    #   * {Types::DescribeClientVpnTargetNetworksResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_target_networks({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     association_ids: ["String"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_target_networks #=> Array
    #   resp.client_vpn_target_networks[0].association_id #=> String
    #   resp.client_vpn_target_networks[0].vpc_id #=> String
    #   resp.client_vpn_target_networks[0].target_network_id #=> String
    #   resp.client_vpn_target_networks[0].client_vpn_endpoint_id #=> String
    #   resp.client_vpn_target_networks[0].status.code #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated"
    #   resp.client_vpn_target_networks[0].status.message #=> String
    #   resp.client_vpn_target_networks[0].security_groups #=> Array
    #   resp.client_vpn_target_networks[0].security_groups[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks AWS API Documentation
    #
    # @overload describe_client_vpn_target_networks(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_target_networks(params = {}, options = {})
      req = build_request(:describe_client_vpn_target_networks, params)
      req.send_request(options)
    end

    # Describes the specified customer-owned address pools or all of your
    # customer-owned address pools.
    #
    # @option params [Array<String>] :pool_ids
    #   The IDs of the address pools.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters. The following are the possible values:
    #
    #   * `coip-pool.pool-id`
    #
    #   ^
    #   ^
    #
    #   * `coip-pool.local-gateway-route-table-id`
    #
    #   ^
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCoipPoolsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCoipPoolsResult#coip_pools #coip_pools} => Array&lt;Types::CoipPool&gt;
    #   * {Types::DescribeCoipPoolsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_coip_pools({
    #     pool_ids: ["CoipPoolId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.coip_pools #=> Array
    #   resp.coip_pools[0].pool_id #=> String
    #   resp.coip_pools[0].pool_cidrs #=> Array
    #   resp.coip_pools[0].pool_cidrs[0] #=> String
    #   resp.coip_pools[0].local_gateway_route_table_id #=> String
    #   resp.coip_pools[0].tags #=> Array
    #   resp.coip_pools[0].tags[0].key #=> String
    #   resp.coip_pools[0].tags[0].value #=> String
    #   resp.coip_pools[0].pool_arn #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools AWS API Documentation
    #
    # @overload describe_coip_pools(params = {})
    # @param [Hash] params ({})
    def describe_coip_pools(params = {}, options = {})
      req = build_request(:describe_coip_pools, params)
      req.send_request(options)
    end

    # Describes the specified conversion tasks or all your conversion tasks.
    # For more information, see the [VM Import/Export User Guide][1].
    #
    # For information about the import manifest referenced by this API
    # action, see [VM Import Manifest][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vm-import/latest/userguide/
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html
    #
    # @option params [Array<String>] :conversion_task_ids
    #   The conversion task IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeConversionTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeConversionTasksResult#conversion_tasks #conversion_tasks} => Array&lt;Types::ConversionTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_conversion_tasks({
    #     conversion_task_ids: ["ConversionTaskId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.conversion_tasks #=> Array
    #   resp.conversion_tasks[0].conversion_task_id #=> String
    #   resp.conversion_tasks[0].expiration_time #=> String
    #   resp.conversion_tasks[0].import_instance.description #=> String
    #   resp.conversion_tasks[0].import_instance.instance_id #=> String
    #   resp.conversion_tasks[0].import_instance.platform #=> String, one of "Windows"
    #   resp.conversion_tasks[0].import_instance.volumes #=> Array
    #   resp.conversion_tasks[0].import_instance.volumes[0].availability_zone #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].bytes_converted #=> Integer
    #   resp.conversion_tasks[0].import_instance.volumes[0].description #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.checksum #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.import_manifest_url #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.size #=> Integer
    #   resp.conversion_tasks[0].import_instance.volumes[0].status #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].status_message #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].volume.id #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].volume.size #=> Integer
    #   resp.conversion_tasks[0].import_volume.availability_zone #=> String
    #   resp.conversion_tasks[0].import_volume.bytes_converted #=> Integer
    #   resp.conversion_tasks[0].import_volume.description #=> String
    #   resp.conversion_tasks[0].import_volume.image.checksum #=> String
    #   resp.conversion_tasks[0].import_volume.image.format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.conversion_tasks[0].import_volume.image.import_manifest_url #=> String
    #   resp.conversion_tasks[0].import_volume.image.size #=> Integer
    #   resp.conversion_tasks[0].import_volume.volume.id #=> String
    #   resp.conversion_tasks[0].import_volume.volume.size #=> Integer
    #   resp.conversion_tasks[0].state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.conversion_tasks[0].status_message #=> String
    #   resp.conversion_tasks[0].tags #=> Array
    #   resp.conversion_tasks[0].tags[0].key #=> String
    #   resp.conversion_tasks[0].tags[0].value #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * conversion_task_cancelled
    #   * conversion_task_completed
    #   * conversion_task_deleted
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks AWS API Documentation
    #
    # @overload describe_conversion_tasks(params = {})
    # @param [Hash] params ({})
    def describe_conversion_tasks(params = {}, options = {})
      req = build_request(:describe_conversion_tasks, params)
      req.send_request(options)
    end

    # Describes one or more of your VPN customer gateways.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [Array<String>] :customer_gateway_ids
    #   One or more customer gateway IDs.
    #
    #   Default: Describes all your customer gateways.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
    #     Autonomous System Number (ASN).
    #
    #   * `customer-gateway-id` - The ID of the customer gateway.
    #
    #   * `ip-address` - The IP address of the customer gateway's
    #     Internet-routable external interface.
    #
    #   * `state` - The state of the customer gateway (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `type` - The type of customer gateway. Currently, the only supported
    #     type is `ipsec.1`.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCustomerGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCustomerGatewaysResult#customer_gateways #customer_gateways} => Array&lt;Types::CustomerGateway&gt;
    #
    #
    # @example Example: To describe a customer gateway
    #
    #   # This example describes the specified customer gateway.
    #
    #   resp = client.describe_customer_gateways({
    #     customer_gateway_ids: [
    #       "cgw-0e11f167", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     customer_gateways: [
    #       {
    #         bgp_asn: "65534", 
    #         customer_gateway_id: "cgw-0e11f167", 
    #         ip_address: "12.1.2.3", 
    #         state: "available", 
    #         type: "ipsec.1", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_customer_gateways({
    #     customer_gateway_ids: ["CustomerGatewayId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.customer_gateways #=> Array
    #   resp.customer_gateways[0].bgp_asn #=> String
    #   resp.customer_gateways[0].customer_gateway_id #=> String
    #   resp.customer_gateways[0].ip_address #=> String
    #   resp.customer_gateways[0].certificate_arn #=> String
    #   resp.customer_gateways[0].state #=> String
    #   resp.customer_gateways[0].type #=> String
    #   resp.customer_gateways[0].device_name #=> String
    #   resp.customer_gateways[0].tags #=> Array
    #   resp.customer_gateways[0].tags[0].key #=> String
    #   resp.customer_gateways[0].tags[0].value #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * customer_gateway_available
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways AWS API Documentation
    #
    # @overload describe_customer_gateways(params = {})
    # @param [Hash] params ({})
    def describe_customer_gateways(params = {}, options = {})
      req = build_request(:describe_customer_gateways, params)
      req.send_request(options)
    end

    # Describes one or more of your DHCP options sets.
    #
    # For more information, see [DHCP Options Sets][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [Array<String>] :dhcp_options_ids
    #   The IDs of one or more DHCP options sets.
    #
    #   Default: Describes all your DHCP options sets.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `dhcp-options-id` - The ID of a DHCP options set.
    #
    #   * `key` - The key for one of the options (for example, `domain-name`).
    #
    #   * `value` - The value for one of the options.
    #
    #   * `owner-id` - The ID of the AWS account that owns the DHCP options
    #     set.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeDhcpOptionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDhcpOptionsResult#dhcp_options #dhcp_options} => Array&lt;Types::DhcpOptions&gt;
    #   * {Types::DescribeDhcpOptionsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe a DHCP options set
    #
    #   # This example describes the specified DHCP options set.
    #
    #   resp = client.describe_dhcp_options({
    #     dhcp_options_ids: [
    #       "dopt-d9070ebb", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     dhcp_options: [
    #       {
    #         dhcp_configurations: [
    #           {
    #             key: "domain-name-servers", 
    #             values: [
    #               {
    #                 value: "10.2.5.2", 
    #               }, 
    #               {
    #                 value: "10.2.5.1", 
    #               }, 
    #             ], 
    #           }, 
    #         ], 
    #         dhcp_options_id: "dopt-d9070ebb", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_dhcp_options({
    #     dhcp_options_ids: ["DhcpOptionsId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.dhcp_options #=> Array
    #   resp.dhcp_options[0].dhcp_configurations #=> Array
    #   resp.dhcp_options[0].dhcp_configurations[0].key #=> String
    #   resp.dhcp_options[0].dhcp_configurations[0].values #=> Array
    #   resp.dhcp_options[0].dhcp_configurations[0].values[0] #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.dhcp_options[0].dhcp_options_id #=> String
    #   resp.dhcp_options[0].owner_id #=> String
    #   resp.dhcp_options[0].tags #=> Array
    #   resp.dhcp_options[0].tags[0].key #=> String
    #   resp.dhcp_options[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions AWS API Documentation
    #
    # @overload describe_dhcp_options(params = {})
    # @param [Hash] params ({})
    def describe_dhcp_options(params = {}, options = {})
      req = build_request(:describe_dhcp_options, params)
      req.send_request(options)
    end

    # Describes one or more of your egress-only internet gateways.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :egress_only_internet_gateway_ids
    #   One or more egress-only internet gateway IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @return [Types::DescribeEgressOnlyInternetGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeEgressOnlyInternetGatewaysResult#egress_only_internet_gateways #egress_only_internet_gateways} => Array&lt;Types::EgressOnlyInternetGateway&gt;
    #   * {Types::DescribeEgressOnlyInternetGatewaysResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_egress_only_internet_gateways({
    #     dry_run: false,
    #     egress_only_internet_gateway_ids: ["EgressOnlyInternetGatewayId"],
    #     max_results: 1,
    #     next_token: "String",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.egress_only_internet_gateways #=> Array
    #   resp.egress_only_internet_gateways[0].attachments #=> Array
    #   resp.egress_only_internet_gateways[0].attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.egress_only_internet_gateways[0].attachments[0].vpc_id #=> String
    #   resp.egress_only_internet_gateways[0].egress_only_internet_gateway_id #=> String
    #   resp.egress_only_internet_gateways[0].tags #=> Array
    #   resp.egress_only_internet_gateways[0].tags[0].key #=> String
    #   resp.egress_only_internet_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways AWS API Documentation
    #
    # @overload describe_egress_only_internet_gateways(params = {})
    # @param [Hash] params ({})
    def describe_egress_only_internet_gateways(params = {}, options = {})
      req = build_request(:describe_egress_only_internet_gateways, params)
      req.send_request(options)
    end

    # Describes the Elastic Graphics accelerator associated with your
    # instances. For more information about Elastic Graphics, see [Amazon
    # Elastic Graphics][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html
    #
    # @option params [Array<String>] :elastic_gpu_ids
    #   The Elastic Graphics accelerator IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone in which the Elastic
    #     Graphics accelerator resides.
    #
    #   * `elastic-gpu-health` - The status of the Elastic Graphics
    #     accelerator (`OK` \| `IMPAIRED`).
    #
    #   * `elastic-gpu-state` - The state of the Elastic Graphics accelerator
    #     (`ATTACHED`).
    #
    #   * `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
    #     example, `eg1.medium`.
    #
    #   * `instance-id` - The ID of the instance to which the Elastic Graphics
    #     accelerator is associated.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeElasticGpusResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeElasticGpusResult#elastic_gpu_set #elastic_gpu_set} => Array&lt;Types::ElasticGpus&gt;
    #   * {Types::DescribeElasticGpusResult#max_results #max_results} => Integer
    #   * {Types::DescribeElasticGpusResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_elastic_gpus({
    #     elastic_gpu_ids: ["ElasticGpuId"],
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.elastic_gpu_set #=> Array
    #   resp.elastic_gpu_set[0].elastic_gpu_id #=> String
    #   resp.elastic_gpu_set[0].availability_zone #=> String
    #   resp.elastic_gpu_set[0].elastic_gpu_type #=> String
    #   resp.elastic_gpu_set[0].elastic_gpu_health.status #=> String, one of "OK", "IMPAIRED"
    #   resp.elastic_gpu_set[0].elastic_gpu_state #=> String, one of "ATTACHED"
    #   resp.elastic_gpu_set[0].instance_id #=> String
    #   resp.elastic_gpu_set[0].tags #=> Array
    #   resp.elastic_gpu_set[0].tags[0].key #=> String
    #   resp.elastic_gpu_set[0].tags[0].value #=> String
    #   resp.max_results #=> Integer
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus AWS API Documentation
    #
    # @overload describe_elastic_gpus(params = {})
    # @param [Hash] params ({})
    def describe_elastic_gpus(params = {}, options = {})
      req = build_request(:describe_elastic_gpus, params)
      req.send_request(options)
    end

    # Describes the specified export image tasks or all of your export image
    # tasks.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #
    # @option params [Array<String>] :export_image_task_ids
    #   The IDs of the export image tasks.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeExportImageTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeExportImageTasksResult#export_image_tasks #export_image_tasks} => Array&lt;Types::ExportImageTask&gt;
    #   * {Types::DescribeExportImageTasksResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_export_image_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     export_image_task_ids: ["ExportImageTaskId"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.export_image_tasks #=> Array
    #   resp.export_image_tasks[0].description #=> String
    #   resp.export_image_tasks[0].export_image_task_id #=> String
    #   resp.export_image_tasks[0].image_id #=> String
    #   resp.export_image_tasks[0].progress #=> String
    #   resp.export_image_tasks[0].s3_export_location.s3_bucket #=> String
    #   resp.export_image_tasks[0].s3_export_location.s3_prefix #=> String
    #   resp.export_image_tasks[0].status #=> String
    #   resp.export_image_tasks[0].status_message #=> String
    #   resp.export_image_tasks[0].tags #=> Array
    #   resp.export_image_tasks[0].tags[0].key #=> String
    #   resp.export_image_tasks[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks AWS API Documentation
    #
    # @overload describe_export_image_tasks(params = {})
    # @param [Hash] params ({})
    def describe_export_image_tasks(params = {}, options = {})
      req = build_request(:describe_export_image_tasks, params)
      req.send_request(options)
    end

    # Describes the specified export instance tasks or all of your export
    # instance tasks.
    #
    # @option params [Array<String>] :export_task_ids
    #   The export task IDs.
    #
    # @option params [Array<Types::Filter>] :filters
    #   the filters for the export tasks.
    #
    # @return [Types::DescribeExportTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeExportTasksResult#export_tasks #export_tasks} => Array&lt;Types::ExportTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_export_tasks({
    #     export_task_ids: ["ExportTaskId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.export_tasks #=> Array
    #   resp.export_tasks[0].description #=> String
    #   resp.export_tasks[0].export_task_id #=> String
    #   resp.export_tasks[0].export_to_s3_task.container_format #=> String, one of "ova"
    #   resp.export_tasks[0].export_to_s3_task.disk_image_format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.export_tasks[0].export_to_s3_task.s3_bucket #=> String
    #   resp.export_tasks[0].export_to_s3_task.s3_key #=> String
    #   resp.export_tasks[0].instance_export_details.instance_id #=> String
    #   resp.export_tasks[0].instance_export_details.target_environment #=> String, one of "citrix", "vmware", "microsoft"
    #   resp.export_tasks[0].state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.export_tasks[0].status_message #=> String
    #   resp.export_tasks[0].tags #=> Array
    #   resp.export_tasks[0].tags[0].key #=> String
    #   resp.export_tasks[0].tags[0].value #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * export_task_cancelled
    #   * export_task_completed
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks AWS API Documentation
    #
    # @overload describe_export_tasks(params = {})
    # @param [Hash] params ({})
    def describe_export_tasks(params = {}, options = {})
      req = build_request(:describe_export_tasks, params)
      req.send_request(options)
    end

    # Describes the state of fast snapshot restores for your snapshots.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters. The possible values are:
    #
    #   * `availability-zone`\: The Availability Zone of the snapshot.
    #
    #   * `owner-id`\: The ID of the AWS account that enabled fast snapshot
    #     restore on the snapshot.
    #
    #   * `snapshot-id`\: The ID of the snapshot.
    #
    #   * `state`\: The state of fast snapshot restores for the snapshot
    #     (`enabling` \| `optimizing` \| `enabled` \| `disabling` \|
    #     `disabled`).
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeFastSnapshotRestoresResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFastSnapshotRestoresResult#fast_snapshot_restores #fast_snapshot_restores} => Array&lt;Types::DescribeFastSnapshotRestoreSuccessItem&gt;
    #   * {Types::DescribeFastSnapshotRestoresResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fast_snapshot_restores({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.fast_snapshot_restores #=> Array
    #   resp.fast_snapshot_restores[0].snapshot_id #=> String
    #   resp.fast_snapshot_restores[0].availability_zone #=> String
    #   resp.fast_snapshot_restores[0].state #=> String, one of "enabling", "optimizing", "enabled", "disabling", "disabled"
    #   resp.fast_snapshot_restores[0].state_transition_reason #=> String
    #   resp.fast_snapshot_restores[0].owner_id #=> String
    #   resp.fast_snapshot_restores[0].owner_alias #=> String
    #   resp.fast_snapshot_restores[0].enabling_time #=> Time
    #   resp.fast_snapshot_restores[0].optimizing_time #=> Time
    #   resp.fast_snapshot_restores[0].enabled_time #=> Time
    #   resp.fast_snapshot_restores[0].disabling_time #=> Time
    #   resp.fast_snapshot_restores[0].disabled_time #=> Time
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores AWS API Documentation
    #
    # @overload describe_fast_snapshot_restores(params = {})
    # @param [Hash] params ({})
    def describe_fast_snapshot_restores(params = {}, options = {})
      req = build_request(:describe_fast_snapshot_restores, params)
      req.send_request(options)
    end

    # Describes the events for the specified EC2 Fleet during the specified
    # time.
    #
    # EC2 Fleet events are delayed by up to 30 seconds before they can be
    # described. This ensures that you can query by the last evaluated time
    # and not miss a recorded event. EC2 Fleet events are available for 48
    # hours.
    #
    # For more information, see [Monitoring your EC2 Fleet][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :event_type
    #   The type of events to describe. By default, all events are described.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :fleet_id
    #   The ID of the EC2 Fleet.
    #
    # @option params [required, Time,DateTime,Date,Integer,String] :start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #
    # @return [Types::DescribeFleetHistoryResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetHistoryResult#history_records #history_records} => Array&lt;Types::HistoryRecordEntry&gt;
    #   * {Types::DescribeFleetHistoryResult#last_evaluated_time #last_evaluated_time} => Time
    #   * {Types::DescribeFleetHistoryResult#next_token #next_token} => String
    #   * {Types::DescribeFleetHistoryResult#fleet_id #fleet_id} => String
    #   * {Types::DescribeFleetHistoryResult#start_time #start_time} => Time
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleet_history({
    #     dry_run: false,
    #     event_type: "instance-change", # accepts instance-change, fleet-change, service-error
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_id: "FleetId", # required
    #     start_time: Time.now, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.history_records #=> Array
    #   resp.history_records[0].event_information.event_description #=> String
    #   resp.history_records[0].event_information.event_sub_type #=> String
    #   resp.history_records[0].event_information.instance_id #=> String
    #   resp.history_records[0].event_type #=> String, one of "instance-change", "fleet-change", "service-error"
    #   resp.history_records[0].timestamp #=> Time
    #   resp.last_evaluated_time #=> Time
    #   resp.next_token #=> String
    #   resp.fleet_id #=> String
    #   resp.start_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory AWS API Documentation
    #
    # @overload describe_fleet_history(params = {})
    # @param [Hash] params ({})
    def describe_fleet_history(params = {}, options = {})
      req = build_request(:describe_fleet_history, params)
      req.send_request(options)
    end

    # Describes the running instances for the specified EC2 Fleet.
    #
    # For more information, see [Monitoring your EC2 Fleet][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :fleet_id
    #   The ID of the EC2 Fleet.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-type` - The instance type.
    #
    #   ^
    #
    # @return [Types::DescribeFleetInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetInstancesResult#active_instances #active_instances} => Array&lt;Types::ActiveInstance&gt;
    #   * {Types::DescribeFleetInstancesResult#next_token #next_token} => String
    #   * {Types::DescribeFleetInstancesResult#fleet_id #fleet_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleet_instances({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_id: "FleetId", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.active_instances #=> Array
    #   resp.active_instances[0].instance_id #=> String
    #   resp.active_instances[0].instance_type #=> String
    #   resp.active_instances[0].spot_instance_request_id #=> String
    #   resp.active_instances[0].instance_health #=> String, one of "healthy", "unhealthy"
    #   resp.next_token #=> String
    #   resp.fleet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances AWS API Documentation
    #
    # @overload describe_fleet_instances(params = {})
    # @param [Hash] params ({})
    def describe_fleet_instances(params = {}, options = {})
      req = build_request(:describe_fleet_instances, params)
      req.send_request(options)
    end

    # Describes the specified EC2 Fleets or all of your EC2 Fleets.
    #
    # For more information, see [Monitoring your EC2 Fleet][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [Array<String>] :fleet_ids
    #   The ID of the EC2 Fleets.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `activity-status` - The progress of the EC2 Fleet ( `error` \|
    #     `pending-fulfillment` \| `pending-termination` \| `fulfilled`).
    #
    #   * `excess-capacity-termination-policy` - Indicates whether to
    #     terminate running instances if the target capacity is decreased
    #     below the current EC2 Fleet size (`true` \| `false`).
    #
    #   * `fleet-state` - The state of the EC2 Fleet (`submitted` \| `active`
    #     \| `deleted` \| `failed` \| `deleted-running` \|
    #     `deleted-terminating` \| `modifying`).
    #
    #   * `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
    #     replace unhealthy instances (`true` \| `false`).
    #
    #   * `type` - The type of request (`instant` \| `request` \| `maintain`).
    #
    # @return [Types::DescribeFleetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetsResult#next_token #next_token} => String
    #   * {Types::DescribeFleetsResult#fleets #fleets} => Array&lt;Types::FleetData&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleets({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_ids: ["FleetId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.fleets #=> Array
    #   resp.fleets[0].activity_status #=> String, one of "error", "pending_fulfillment", "pending_termination", "fulfilled"
    #   resp.fleets[0].create_time #=> Time
    #   resp.fleets[0].fleet_id #=> String
    #   resp.fleets[0].fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.fleets[0].client_token #=> String
    #   resp.fleets[0].excess_capacity_termination_policy #=> String, one of "no-termination", "termination"
    #   resp.fleets[0].fulfilled_capacity #=> Float
    #   resp.fleets[0].fulfilled_on_demand_capacity #=> Float
    #   resp.fleets[0].launch_template_configs #=> Array
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.version #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides #=> Array
    #   resp.fleets[0].launch_template_configs[0].overrides[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.fleets[0].launch_template_configs[0].overrides[0].max_price #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].subnet_id #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].availability_zone #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].weighted_capacity #=> Float
    #   resp.fleets[0].launch_template_configs[0].overrides[0].priority #=> Float
    #   resp.fleets[0].launch_template_configs[0].overrides[0].placement.group_name #=> String
    #   resp.fleets[0].target_capacity_specification.total_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.on_demand_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.spot_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.default_target_capacity_type #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].terminate_instances_with_expiration #=> Boolean
    #   resp.fleets[0].type #=> String, one of "request", "maintain", "instant"
    #   resp.fleets[0].valid_from #=> Time
    #   resp.fleets[0].valid_until #=> Time
    #   resp.fleets[0].replace_unhealthy_instances #=> Boolean
    #   resp.fleets[0].spot_options.allocation_strategy #=> String, one of "lowest-price", "diversified", "capacity-optimized", "capacity-optimized-prioritized"
    #   resp.fleets[0].spot_options.maintenance_strategies.capacity_rebalance.replacement_strategy #=> String, one of "launch"
    #   resp.fleets[0].spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.fleets[0].spot_options.instance_pools_to_use_count #=> Integer
    #   resp.fleets[0].spot_options.single_instance_type #=> Boolean
    #   resp.fleets[0].spot_options.single_availability_zone #=> Boolean
    #   resp.fleets[0].spot_options.min_target_capacity #=> Integer
    #   resp.fleets[0].spot_options.max_total_price #=> String
    #   resp.fleets[0].on_demand_options.allocation_strategy #=> String, one of "lowest-price", "prioritized"
    #   resp.fleets[0].on_demand_options.capacity_reservation_options.usage_strategy #=> String, one of "use-capacity-reservations-first"
    #   resp.fleets[0].on_demand_options.single_instance_type #=> Boolean
    #   resp.fleets[0].on_demand_options.single_availability_zone #=> Boolean
    #   resp.fleets[0].on_demand_options.min_target_capacity #=> Integer
    #   resp.fleets[0].on_demand_options.max_total_price #=> String
    #   resp.fleets[0].tags #=> Array
    #   resp.fleets[0].tags[0].key #=> String
    #   resp.fleets[0].tags[0].value #=> String
    #   resp.fleets[0].errors #=> Array
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.fleets[0].errors[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].errors[0].error_code #=> String
    #   resp.fleets[0].errors[0].error_message #=> String
    #   resp.fleets[0].instances #=> Array
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.fleets[0].instances[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].instances[0].instance_ids #=> Array
    #   resp.fleets[0].instances[0].instance_ids[0] #=> String
    #   resp.fleets[0].instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.fleets[0].instances[0].platform #=> String, one of "Windows"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets AWS API Documentation
    #
    # @overload describe_fleets(params = {})
    # @param [Hash] params ({})
    def describe_fleets(params = {}, options = {})
      req = build_request(:describe_fleets, params)
      req.send_request(options)
    end

    # Describes one or more flow logs. To view the information in your flow
    # logs (the log streams for the network interfaces), you must use the
    # CloudWatch Logs console or the CloudWatch Logs API.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filter
    #   One or more filters.
    #
    #   * `deliver-log-status` - The status of the logs delivery (`SUCCESS` \|
    #     `FAILED`).
    #
    #   * `log-destination-type` - The type of destination to which the flow
    #     log publishes data. Possible destination types include
    #     `cloud-watch-logs` and `s3`.
    #
    #   * `flow-log-id` - The ID of the flow log.
    #
    #   * `log-group-name` - The name of the log group.
    #
    #   * `resource-id` - The ID of the VPC, subnet, or network interface.
    #
    #   * `traffic-type` - The type of traffic (`ACCEPT` \| `REJECT` \|
    #     `ALL`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFlowLogsResult#flow_logs #flow_logs} => Array&lt;Types::FlowLog&gt;
    #   * {Types::DescribeFlowLogsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_flow_logs({
    #     dry_run: false,
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     flow_log_ids: ["VpcFlowLogId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.flow_logs #=> Array
    #   resp.flow_logs[0].creation_time #=> Time
    #   resp.flow_logs[0].deliver_logs_error_message #=> String
    #   resp.flow_logs[0].deliver_logs_permission_arn #=> String
    #   resp.flow_logs[0].deliver_logs_status #=> String
    #   resp.flow_logs[0].flow_log_id #=> String
    #   resp.flow_logs[0].flow_log_status #=> String
    #   resp.flow_logs[0].log_group_name #=> String
    #   resp.flow_logs[0].resource_id #=> String
    #   resp.flow_logs[0].traffic_type #=> String, one of "ACCEPT", "REJECT", "ALL"
    #   resp.flow_logs[0].log_destination_type #=> String, one of "cloud-watch-logs", "s3"
    #   resp.flow_logs[0].log_destination #=> String
    #   resp.flow_logs[0].log_format #=> String
    #   resp.flow_logs[0].tags #=> Array
    #   resp.flow_logs[0].tags[0].key #=> String
    #   resp.flow_logs[0].tags[0].value #=> String
    #   resp.flow_logs[0].max_aggregation_interval #=> Integer
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs AWS API Documentation
    #
    # @overload describe_flow_logs(params = {})
    # @param [Hash] params ({})
    def describe_flow_logs(params = {}, options = {})
      req = build_request(:describe_flow_logs, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified Amazon FPGA Image
    # (AFI).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :fpga_image_id
    #   The ID of the AFI.
    #
    # @option params [required, String] :attribute
    #   The AFI attribute.
    #
    # @return [Types::DescribeFpgaImageAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFpgaImageAttributeResult#fpga_image_attribute #fpga_image_attribute} => Types::FpgaImageAttribute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fpga_image_attribute({
    #     dry_run: false,
    #     fpga_image_id: "FpgaImageId", # required
    #     attribute: "description", # required, accepts description, name, loadPermission, productCodes
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_attribute.fpga_image_id #=> String
    #   resp.fpga_image_attribute.name #=> String
    #   resp.fpga_image_attribute.description #=> String
    #   resp.fpga_image_attribute.load_permissions #=> Array
    #   resp.fpga_image_attribute.load_permissions[0].user_id #=> String
    #   resp.fpga_image_attribute.load_permissions[0].group #=> String, one of "all"
    #   resp.fpga_image_attribute.product_codes #=> Array
    #   resp.fpga_image_attribute.product_codes[0].product_code_id #=> String
    #   resp.fpga_image_attribute.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute AWS API Documentation
    #
    # @overload describe_fpga_image_attribute(params = {})
    # @param [Hash] params ({})
    def describe_fpga_image_attribute(params = {}, options = {})
      req = build_request(:describe_fpga_image_attribute, params)
      req.send_request(options)
    end

    # Describes the Amazon FPGA Images (AFIs) available to you. These
    # include public AFIs, private AFIs that you own, and AFIs owned by
    # other AWS accounts for which you have load permissions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :fpga_image_ids
    #   The AFI IDs.
    #
    # @option params [Array<String>] :owners
    #   Filters the AFI by owner. Specify an AWS account ID, `self` (owner is
    #   the sender of the request), or an AWS owner alias (valid values are
    #   `amazon` \| `aws-marketplace`).
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `create-time` - The creation time of the AFI.
    #
    #   * `fpga-image-id` - The FPGA image identifier (AFI ID).
    #
    #   * `fpga-image-global-id` - The global FPGA image identifier (AGFI ID).
    #
    #   * `name` - The name of the AFI.
    #
    #   * `owner-id` - The AWS account ID of the AFI owner.
    #
    #   * `product-code` - The product code.
    #
    #   * `shell-version` - The version of the AWS Shell that was used to
    #     create the bitstream.
    #
    #   * `state` - The state of the AFI (`pending` \| `failed` \| `available`
    #     \| `unavailable`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `update-time` - The time of the most recent update.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @return [Types::DescribeFpgaImagesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFpgaImagesResult#fpga_images #fpga_images} => Array&lt;Types::FpgaImage&gt;
    #   * {Types::DescribeFpgaImagesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fpga_images({
    #     dry_run: false,
    #     fpga_image_ids: ["FpgaImageId"],
    #     owners: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "NextToken",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_images #=> Array
    #   resp.fpga_images[0].fpga_image_id #=> String
    #   resp.fpga_images[0].fpga_image_global_id #=> String
    #   resp.fpga_images[0].name #=> String
    #   resp.fpga_images[0].description #=> String
    #   resp.fpga_images[0].shell_version #=> String
    #   resp.fpga_images[0].pci_id.device_id #=> String
    #   resp.fpga_images[0].pci_id.vendor_id #=> String
    #   resp.fpga_images[0].pci_id.subsystem_id #=> String
    #   resp.fpga_images[0].pci_id.subsystem_vendor_id #=> String
    #   resp.fpga_images[0].state.code #=> String, one of "pending", "failed", "available", "unavailable"
    #   resp.fpga_images[0].state.message #=> String
    #   resp.fpga_images[0].create_time #=> Time
    #   resp.fpga_images[0].update_time #=> Time
    #   resp.fpga_images[0].owner_id #=> String
    #   resp.fpga_images[0].owner_alias #=> String
    #   resp.fpga_images[0].product_codes #=> Array
    #   resp.fpga_images[0].product_codes[0].product_code_id #=> String
    #   resp.fpga_images[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.fpga_images[0].tags #=> Array
    #   resp.fpga_images[0].tags[0].key #=> String
    #   resp.fpga_images[0].tags[0].value #=> String
    #   resp.fpga_images[0].public #=> Boolean
    #   resp.fpga_images[0].data_retention_support #=> Boolean
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages AWS API Documentation
    #
    # @overload describe_fpga_images(params = {})
    # @param [Hash] params ({})
    def describe_fpga_images(params = {}, options = {})
      req = build_request(:describe_fpga_images, params)
      req.send_request(options)
    end

    # Describes the Dedicated Host reservations that are available to
    # purchase.
    #
    # The results describe all of the Dedicated Host reservation offerings,
    # including offerings that might not match the instance family and
    # Region of your Dedicated Hosts. When purchasing an offering, ensure
    # that the instance family and Region of the offering matches that of
    # the Dedicated Hosts with which it is to be associated. For more
    # information about supported instance types, see [Dedicated Hosts][1]
    # in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `instance-family` - The instance family of the offering (for
    #     example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    # @option params [Integer] :max_duration
    #   This is the maximum duration of the reservation to purchase, specified
    #   in seconds. Reservations are available in one-year and three-year
    #   terms. The number of seconds specified must be the number of seconds
    #   in a year (365x24x60x60) times one of the supported durations (1 or
    #   3). For example, specify 94608000 for three years.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    # @option params [Integer] :min_duration
    #   This is the minimum duration of the reservation you'd like to
    #   purchase, specified in seconds. Reservations are available in one-year
    #   and three-year terms. The number of seconds specified must be the
    #   number of seconds in a year (365x24x60x60) times one of the supported
    #   durations (1 or 3). For example, specify 31536000 for one year.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @option params [String] :offering_id
    #   The ID of the reservation offering.
    #
    # @return [Types::DescribeHostReservationOfferingsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostReservationOfferingsResult#next_token #next_token} => String
    #   * {Types::DescribeHostReservationOfferingsResult#offering_set #offering_set} => Array&lt;Types::HostOffering&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_host_reservation_offerings({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_duration: 1,
    #     max_results: 1,
    #     min_duration: 1,
    #     next_token: "String",
    #     offering_id: "OfferingId",
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.offering_set #=> Array
    #   resp.offering_set[0].currency_code #=> String, one of "USD"
    #   resp.offering_set[0].duration #=> Integer
    #   resp.offering_set[0].hourly_price #=> String
    #   resp.offering_set[0].instance_family #=> String
    #   resp.offering_set[0].offering_id #=> String
    #   resp.offering_set[0].payment_option #=> String, one of "AllUpfront", "PartialUpfront", "NoUpfront"
    #   resp.offering_set[0].upfront_price #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings AWS API Documentation
    #
    # @overload describe_host_reservation_offerings(params = {})
    # @param [Hash] params ({})
    def describe_host_reservation_offerings(params = {}, options = {})
      req = build_request(:describe_host_reservation_offerings, params)
      req.send_request(options)
    end

    # Describes reservations that are associated with Dedicated Hosts in
    # your account.
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `instance-family` - The instance family (for example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    #   * `state` - The state of the reservation (`payment-pending` \|
    #     `payment-failed` \| `active` \| `retired`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :host_reservation_id_set
    #   The host reservation IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @return [Types::DescribeHostReservationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostReservationsResult#host_reservation_set #host_reservation_set} => Array&lt;Types::HostReservation&gt;
    #   * {Types::DescribeHostReservationsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_host_reservations({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     host_reservation_id_set: ["HostReservationId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.host_reservation_set #=> Array
    #   resp.host_reservation_set[0].count #=> Integer
    #   resp.host_reservation_set[0].currency_code #=> String, one of "USD"
    #   resp.host_reservation_set[0].duration #=> Integer
    #   resp.host_reservation_set[0].end #=> Time
    #   resp.host_reservation_set[0].host_id_set #=> Array
    #   resp.host_reservation_set[0].host_id_set[0] #=> String
    #   resp.host_reservation_set[0].host_reservation_id #=> String
    #   resp.host_reservation_set[0].hourly_price #=> String
    #   resp.host_reservation_set[0].instance_family #=> String
    #   resp.host_reservation_set[0].offering_id #=> String
    #   resp.host_reservation_set[0].payment_option #=> String, one of "AllUpfront", "PartialUpfront", "NoUpfront"
    #   resp.host_reservation_set[0].start #=> Time
    #   resp.host_reservation_set[0].state #=> String, one of "payment-pending", "payment-failed", "active", "retired"
    #   resp.host_reservation_set[0].upfront_price #=> String
    #   resp.host_reservation_set[0].tags #=> Array
    #   resp.host_reservation_set[0].tags[0].key #=> String
    #   resp.host_reservation_set[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations AWS API Documentation
    #
    # @overload describe_host_reservations(params = {})
    # @param [Hash] params ({})
    def describe_host_reservations(params = {}, options = {})
      req = build_request(:describe_host_reservations, params)
      req.send_request(options)
    end

    # Describes the specified Dedicated Hosts or all your Dedicated Hosts.
    #
    # The results describe only the Dedicated Hosts in the Region you're
    # currently using. All listed instances consume capacity on your
    # Dedicated Host. Dedicated Hosts that have recently been released are
    # listed with the state `released`.
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `auto-placement` - Whether auto-placement is enabled or disabled
    #     (`on` \| `off`).
    #
    #   * `availability-zone` - The Availability Zone of the host.
    #
    #   * `client-token` - The idempotency token that you provided when you
    #     allocated the host.
    #
    #   * `host-reservation-id` - The ID of the reservation assigned to this
    #     host.
    #
    #   * `instance-type` - The instance type size that the Dedicated Host is
    #     configured to support.
    #
    #   * `state` - The allocation state of the Dedicated Host (`available` \|
    #     `under-assessment` \| `permanent-failure` \| `released` \|
    #     `released-permanent-failure`).
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :host_ids
    #   The IDs of the Dedicated Hosts. The IDs are used for targeted instance
    #   launches.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    #   You cannot specify this parameter and the host IDs parameter in the
    #   same request.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @return [Types::DescribeHostsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostsResult#hosts #hosts} => Array&lt;Types::Host&gt;
    #   * {Types::DescribeHostsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_hosts({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     host_ids: ["DedicatedHostId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.hosts #=> Array
    #   resp.hosts[0].auto_placement #=> String, one of "on", "off"
    #   resp.hosts[0].availability_zone #=> String
    #   resp.hosts[0].available_capacity.available_instance_capacity #=> Array
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].available_capacity #=> Integer
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].instance_type #=> String
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].total_capacity #=> Integer
    #   resp.hosts[0].available_capacity.available_v_cpus #=> Integer
    #   resp.hosts[0].client_token #=> String
    #   resp.hosts[0].host_id #=> String
    #   resp.hosts[0].host_properties.cores #=> Integer
    #   resp.hosts[0].host_properties.instance_type #=> String
    #   resp.hosts[0].host_properties.instance_family #=> String
    #   resp.hosts[0].host_properties.sockets #=> Integer
    #   resp.hosts[0].host_properties.total_v_cpus #=> Integer
    #   resp.hosts[0].host_reservation_id #=> String
    #   resp.hosts[0].instances #=> Array
    #   resp.hosts[0].instances[0].instance_id #=> String
    #   resp.hosts[0].instances[0].instance_type #=> String
    #   resp.hosts[0].instances[0].owner_id #=> String
    #   resp.hosts[0].state #=> String, one of "available", "under-assessment", "permanent-failure", "released", "released-permanent-failure", "pending"
    #   resp.hosts[0].allocation_time #=> Time
    #   resp.hosts[0].release_time #=> Time
    #   resp.hosts[0].tags #=> Array
    #   resp.hosts[0].tags[0].key #=> String
    #   resp.hosts[0].tags[0].value #=> String
    #   resp.hosts[0].host_recovery #=> String, one of "on", "off"
    #   resp.hosts[0].allows_multiple_instance_types #=> String, one of "on", "off"
    #   resp.hosts[0].owner_id #=> String
    #   resp.hosts[0].availability_zone_id #=> String
    #   resp.hosts[0].member_of_service_linked_resource_group #=> Boolean
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts AWS API Documentation
    #
    # @overload describe_hosts(params = {})
    # @param [Hash] params ({})
    def describe_hosts(params = {}, options = {})
      req = build_request(:describe_hosts, params)
      req.send_request(options)
    end

    # Describes your IAM instance profile associations.
    #
    # @option params [Array<String>] :association_ids
    #   The IAM instance profile associations.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `state` - The state of the association (`associating` \|
    #     `associated` \| `disassociating`).
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeIamInstanceProfileAssociationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIamInstanceProfileAssociationsResult#iam_instance_profile_associations #iam_instance_profile_associations} => Array&lt;Types::IamInstanceProfileAssociation&gt;
    #   * {Types::DescribeIamInstanceProfileAssociationsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe an IAM instance profile association
    #
    #   # This example describes the specified IAM instance profile association.
    #
    #   resp = client.describe_iam_instance_profile_associations({
    #     association_ids: [
    #       "iip-assoc-0db249b1f25fa24b8", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     iam_instance_profile_associations: [
    #       {
    #         association_id: "iip-assoc-0db249b1f25fa24b8", 
    #         iam_instance_profile: {
    #           arn: "arn:aws:iam::123456789012:instance-profile/admin-role", 
    #           id: "AIPAJVQN4F5WVLGCJDRGM", 
    #         }, 
    #         instance_id: "i-09eb09efa73ec1dee", 
    #         state: "associated", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_iam_instance_profile_associations({
    #     association_ids: ["IamInstanceProfileAssociationId"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.iam_instance_profile_associations #=> Array
    #   resp.iam_instance_profile_associations[0].association_id #=> String
    #   resp.iam_instance_profile_associations[0].instance_id #=> String
    #   resp.iam_instance_profile_associations[0].iam_instance_profile.arn #=> String
    #   resp.iam_instance_profile_associations[0].iam_instance_profile.id #=> String
    #   resp.iam_instance_profile_associations[0].state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.iam_instance_profile_associations[0].timestamp #=> Time
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations AWS API Documentation
    #
    # @overload describe_iam_instance_profile_associations(params = {})
    # @param [Hash] params ({})
    def describe_iam_instance_profile_associations(params = {}, options = {})
      req = build_request(:describe_iam_instance_profile_associations, params)
      req.send_request(options)
    end

    # Describes the ID format settings for your resources on a per-Region
    # basis, for example, to view which resource types are enabled for
    # longer IDs. This request only returns information about resource types
    # whose ID formats can be modified; it does not return information about
    # other resource types.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # These settings apply to the IAM user who makes the request; they do
    # not apply to the entire AWS account. By default, an IAM user defaults
    # to the same settings as the root user, unless they explicitly override
    # the settings by running the ModifyIdFormat command. Resources created
    # with longer IDs are visible to all IAM users, regardless of these
    # settings and provided that they have permission to use the relevant
    # `Describe` command for the resource type.
    #
    # @option params [String] :resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image` \|
    #   `import-task` \| `instance` \| `internet-gateway` \| `network-acl` \|
    #   `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \| `volume`
    #   \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint` \|
    #   `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #
    # @return [Types::DescribeIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_id_format({
    #     resource: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat AWS API Documentation
    #
    # @overload describe_id_format(params = {})
    # @param [Hash] params ({})
    def describe_id_format(params = {}, options = {})
      req = build_request(:describe_id_format, params)
      req.send_request(options)
    end

    # Describes the ID format settings for resources for the specified IAM
    # user, IAM role, or root user. For example, you can view the resource
    # types that are enabled for longer IDs. This request only returns
    # information about resource types whose ID formats can be modified; it
    # does not return information about other resource types. For more
    # information, see [Resource IDs][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # These settings apply to the principal specified in the request. They
    # do not apply to the principal that makes the request.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html
    #
    # @option params [required, String] :principal_arn
    #   The ARN of the principal, which can be an IAM role, IAM user, or the
    #   root user.
    #
    # @option params [String] :resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image` \|
    #   `import-task` \| `instance` \| `internet-gateway` \| `network-acl` \|
    #   `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \| `volume`
    #   \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint` \|
    #   `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #
    # @return [Types::DescribeIdentityIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIdentityIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_identity_id_format({
    #     principal_arn: "String", # required
    #     resource: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat AWS API Documentation
    #
    # @overload describe_identity_id_format(params = {})
    # @param [Hash] params ({})
    def describe_identity_id_format(params = {}, options = {})
      req = build_request(:describe_identity_id_format, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified AMI. You can
    # specify only one attribute at a time.
    #
    # @option params [required, String] :attribute
    #   The AMI attribute.
    #
    #   **Note**\: The `blockDeviceMapping` attribute is deprecated. Using
    #   this attribute returns the `Client.AuthFailure` error. To get
    #   information about the block device mappings for an AMI, use the
    #   DescribeImages action.
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ImageAttribute] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ImageAttribute#block_device_mappings #block_device_mappings} => Array&lt;Types::BlockDeviceMapping&gt;
    #   * {Types::ImageAttribute#image_id #image_id} => String
    #   * {Types::ImageAttribute#launch_permissions #launch_permissions} => Array&lt;Types::LaunchPermission&gt;
    #   * {Types::ImageAttribute#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::ImageAttribute#description #description} => Types::AttributeValue
    #   * {Types::ImageAttribute#kernel_id #kernel_id} => Types::AttributeValue
    #   * {Types::ImageAttribute#ramdisk_id #ramdisk_id} => Types::AttributeValue
    #   * {Types::ImageAttribute#sriov_net_support #sriov_net_support} => Types::AttributeValue
    #   * {Types::ImageAttribute#boot_mode #boot_mode} => Types::AttributeValue
    #
    #
    # @example Example: To describe the launch permissions for an AMI
    #
    #   # This example describes the launch permissions for the specified AMI.
    #
    #   resp = client.describe_image_attribute({
    #     attribute: "launchPermission", 
    #     image_id: "ami-5731123e", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-5731123e", 
    #     launch_permissions: [
    #       {
    #         user_id: "123456789012", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_image_attribute({
    #     attribute: "description", # required, accepts description, kernel, ramdisk, launchPermission, productCodes, blockDeviceMapping, sriovNetSupport, bootMode
    #     image_id: "ImageId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.block_device_mappings #=> Array
    #   resp.block_device_mappings[0].device_name #=> String
    #   resp.block_device_mappings[0].virtual_name #=> String
    #   resp.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.block_device_mappings[0].ebs.outpost_arn #=> String
    #   resp.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.block_device_mappings[0].no_device #=> String
    #   resp.image_id #=> String
    #   resp.launch_permissions #=> Array
    #   resp.launch_permissions[0].group #=> String, one of "all"
    #   resp.launch_permissions[0].user_id #=> String
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.description #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.kernel_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.ramdisk_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.sriov_net_support #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.boot_mode #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute AWS API Documentation
    #
    # @overload describe_image_attribute(params = {})
    # @param [Hash] params ({})
    def describe_image_attribute(params = {}, options = {})
      req = build_request(:describe_image_attribute, params)
      req.send_request(options)
    end

    # Describes the specified images (AMIs, AKIs, and ARIs) available to you
    # or all of the images available to you.
    #
    # The images available to you include public images, private images that
    # you own, and private images owned by other AWS accounts for which you
    # have explicit launch permissions.
    #
    # Recently deregistered images appear in the returned results for a
    # short interval and then return empty results. After all instances that
    # reference a deregistered AMI are terminated, specifying the ID of the
    # image results in an error indicating that the AMI ID cannot be found.
    #
    # @option params [Array<String>] :executable_users
    #   Scopes the images by users with explicit launch permissions. Specify
    #   an AWS account ID, `self` (the sender of the request), or `all`
    #   (public AMIs).
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `architecture` - The image architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean value that
    #     indicates whether the Amazon EBS volume is deleted on instance
    #     termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.snapshot-id` - The ID of the snapshot used for
    #     the EBS volume.
    #
    #   * `block-device-mapping.volume-size` - The volume size of the EBS
    #     volume, in GiB.
    #
    #   * `block-device-mapping.volume-type` - The volume type of the EBS
    #     volume (`gp2` \| `io1` \| `io2` \| `st1 `\| `sc1` \| `standard`).
    #
    #   * `block-device-mapping.encrypted` - A Boolean that indicates whether
    #     the EBS volume is encrypted.
    #
    #   * `description` - The description of the image (provided during image
    #     creation).
    #
    #   * `ena-support` - A Boolean that indicates whether enhanced networking
    #     with ENA is enabled.
    #
    #   * `hypervisor` - The hypervisor type (`ovm` \| `xen`).
    #
    #   * `image-id` - The ID of the image.
    #
    #   * `image-type` - The image type (`machine` \| `kernel` \| `ramdisk`).
    #
    #   * `is-public` - A Boolean that indicates whether the image is public.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `manifest-location` - The location of the image manifest.
    #
    #   * `name` - The name of the AMI (provided during image creation).
    #
    #   * `owner-alias` - The owner alias (`amazon` \| `aws-marketplace`). The
    #     valid aliases are defined in an Amazon-maintained list. This is not
    #     the AWS account alias that can be set using the IAM console. We
    #     recommend that you use the **Owner** request parameter instead of
    #     this filter.
    #
    #   * `owner-id` - The AWS account ID of the owner. We recommend that you
    #     use the **Owner** request parameter instead of this filter.
    #
    #   * `platform` - The platform. To only list Windows-based AMIs, use
    #     `windows`.
    #
    #   * `product-code` - The product code.
    #
    #   * `product-code.type` - The type of the product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `root-device-name` - The device name of the root device volume (for
    #     example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `state` - The state of the image (`available` \| `pending` \|
    #     `failed`).
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - The message for the state change.
    #
    #   * `sriov-net-support` - A value of `simple` indicates that enhanced
    #     networking with the Intel 82599 VF interface is enabled.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `virtualization-type` - The virtualization type (`paravirtual` \|
    #     `hvm`).
    #
    # @option params [Array<String>] :image_ids
    #   The image IDs.
    #
    #   Default: Describes all images available to you.
    #
    # @option params [Array<String>] :owners
    #   Scopes the results to images with the specified owners. You can
    #   specify a combination of AWS account IDs, `self`, `amazon`, and
    #   `aws-marketplace`. If you omit this parameter, the results include all
    #   images for which you have launch permissions, regardless of ownership.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeImagesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImagesResult#images #images} => Array&lt;Types::Image&gt;
    #
    #
    # @example Example: To describe an AMI
    #
    #   # This example describes the specified AMI.
    #
    #   resp = client.describe_images({
    #     image_ids: [
    #       "ami-5731123e", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     images: [
    #       {
    #         architecture: "x86_64", 
    #         block_device_mappings: [
    #           {
    #             device_name: "/dev/sda1", 
    #             ebs: {
    #               delete_on_termination: true, 
    #               snapshot_id: "snap-1234567890abcdef0", 
    #               volume_size: 8, 
    #               volume_type: "standard", 
    #             }, 
    #           }, 
    #         ], 
    #         description: "An AMI for my server", 
    #         hypervisor: "xen", 
    #         image_id: "ami-5731123e", 
    #         image_location: "123456789012/My server", 
    #         image_type: "machine", 
    #         kernel_id: "aki-88aa75e1", 
    #         name: "My server", 
    #         owner_id: "123456789012", 
    #         public: false, 
    #         root_device_name: "/dev/sda1", 
    #         root_device_type: "ebs", 
    #         state: "available", 
    #         virtualization_type: "paravirtual", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_images({
    #     executable_users: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     image_ids: ["ImageId"],
    #     owners: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.images #=> Array
    #   resp.images[0].architecture #=> String, one of "i386", "x86_64", "arm64"
    #   resp.images[0].creation_date #=> String
    #   resp.images[0].image_id #=> String
    #   resp.images[0].image_location #=> String
    #   resp.images[0].image_type #=> String, one of "machine", "kernel", "ramdisk"
    #   resp.images[0].public #=> Boolean
    #   resp.images[0].kernel_id #=> String
    #   resp.images[0].owner_id #=> String
    #   resp.images[0].platform #=> String, one of "Windows"
    #   resp.images[0].platform_details #=> String
    #   resp.images[0].usage_operation #=> String
    #   resp.images[0].product_codes #=> Array
    #   resp.images[0].product_codes[0].product_code_id #=> String
    #   resp.images[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.images[0].ramdisk_id #=> String
    #   resp.images[0].state #=> String, one of "pending", "available", "invalid", "deregistered", "transient", "failed", "error"
    #   resp.images[0].block_device_mappings #=> Array
    #   resp.images[0].block_device_mappings[0].device_name #=> String
    #   resp.images[0].block_device_mappings[0].virtual_name #=> String
    #   resp.images[0].block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.images[0].block_device_mappings[0].ebs.iops #=> Integer
    #   resp.images[0].block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.images[0].block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.images[0].block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.images[0].block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.images[0].block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.images[0].block_device_mappings[0].ebs.outpost_arn #=> String
    #   resp.images[0].block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.images[0].block_device_mappings[0].no_device #=> String
    #   resp.images[0].description #=> String
    #   resp.images[0].ena_support #=> Boolean
    #   resp.images[0].hypervisor #=> String, one of "ovm", "xen"
    #   resp.images[0].image_owner_alias #=> String
    #   resp.images[0].name #=> String
    #   resp.images[0].root_device_name #=> String
    #   resp.images[0].root_device_type #=> String, one of "ebs", "instance-store"
    #   resp.images[0].sriov_net_support #=> String
    #   resp.images[0].state_reason.code #=> String
    #   resp.images[0].state_reason.message #=> String
    #   resp.images[0].tags #=> Array
    #   resp.images[0].tags[0].key #=> String
    #   resp.images[0].tags[0].value #=> String
    #   resp.images[0].virtualization_type #=> String, one of "hvm", "paravirtual"
    #   resp.images[0].boot_mode #=> String, one of "legacy-bios", "uefi"
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * image_available
    #   * image_exists
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages AWS API Documentation
    #
    # @overload describe_images(params = {})
    # @param [Hash] params ({})
    def describe_images(params = {}, options = {})
      req = build_request(:describe_images, params)
      req.send_request(options)
    end

    # Displays details about an import virtual machine or import snapshot
    # tasks that are already created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #
    # @option params [Array<String>] :import_task_ids
    #   The IDs of the import image tasks.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeImportImageTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImportImageTasksResult#import_image_tasks #import_image_tasks} => Array&lt;Types::ImportImageTask&gt;
    #   * {Types::DescribeImportImageTasksResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_import_image_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     import_task_ids: ["ImportImageTaskId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_image_tasks #=> Array
    #   resp.import_image_tasks[0].architecture #=> String
    #   resp.import_image_tasks[0].description #=> String
    #   resp.import_image_tasks[0].encrypted #=> Boolean
    #   resp.import_image_tasks[0].hypervisor #=> String
    #   resp.import_image_tasks[0].image_id #=> String
    #   resp.import_image_tasks[0].import_task_id #=> String
    #   resp.import_image_tasks[0].kms_key_id #=> String
    #   resp.import_image_tasks[0].license_type #=> String
    #   resp.import_image_tasks[0].platform #=> String
    #   resp.import_image_tasks[0].progress #=> String
    #   resp.import_image_tasks[0].snapshot_details #=> Array
    #   resp.import_image_tasks[0].snapshot_details[0].description #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].device_name #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].disk_image_size #=> Float
    #   resp.import_image_tasks[0].snapshot_details[0].format #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].progress #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].snapshot_id #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].status #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].status_message #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].url #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].user_bucket.s3_bucket #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].user_bucket.s3_key #=> String
    #   resp.import_image_tasks[0].status #=> String
    #   resp.import_image_tasks[0].status_message #=> String
    #   resp.import_image_tasks[0].tags #=> Array
    #   resp.import_image_tasks[0].tags[0].key #=> String
    #   resp.import_image_tasks[0].tags[0].value #=> String
    #   resp.import_image_tasks[0].license_specifications #=> Array
    #   resp.import_image_tasks[0].license_specifications[0].license_configuration_arn #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks AWS API Documentation
    #
    # @overload describe_import_image_tasks(params = {})
    # @param [Hash] params ({})
    def describe_import_image_tasks(params = {}, options = {})
      req = build_request(:describe_import_image_tasks, params)
      req.send_request(options)
    end

    # Describes your import snapshot tasks.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    # @option params [Array<String>] :import_task_ids
    #   A list of import snapshot task IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeImportSnapshotTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImportSnapshotTasksResult#import_snapshot_tasks #import_snapshot_tasks} => Array&lt;Types::ImportSnapshotTask&gt;
    #   * {Types::DescribeImportSnapshotTasksResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_import_snapshot_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     import_task_ids: ["ImportSnapshotTaskId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_snapshot_tasks #=> Array
    #   resp.import_snapshot_tasks[0].description #=> String
    #   resp.import_snapshot_tasks[0].import_task_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.description #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.disk_image_size #=> Float
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.encrypted #=> Boolean
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.format #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.kms_key_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.progress #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.snapshot_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.status #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.status_message #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.url #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.user_bucket.s3_bucket #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.user_bucket.s3_key #=> String
    #   resp.import_snapshot_tasks[0].tags #=> Array
    #   resp.import_snapshot_tasks[0].tags[0].key #=> String
    #   resp.import_snapshot_tasks[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks AWS API Documentation
    #
    # @overload describe_import_snapshot_tasks(params = {})
    # @param [Hash] params ({})
    def describe_import_snapshot_tasks(params = {}, options = {})
      req = build_request(:describe_import_snapshot_tasks, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified instance. You can
    # specify only one attribute at a time. Valid attribute values are:
    # `instanceType` \| `kernel` \| `ramdisk` \| `userData` \|
    # `disableApiTermination` \| `instanceInitiatedShutdownBehavior` \|
    # `rootDeviceName` \| `blockDeviceMapping` \| `productCodes` \|
    # `sourceDestCheck` \| `groupSet` \| `ebsOptimized` \| `sriovNetSupport`
    #
    # @option params [required, String] :attribute
    #   The instance attribute.
    #
    #   Note: The `enaSupport` attribute is not supported at this time.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @return [Types::InstanceAttribute] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::InstanceAttribute#groups #groups} => Array&lt;Types::GroupIdentifier&gt;
    #   * {Types::InstanceAttribute#block_device_mappings #block_device_mappings} => Array&lt;Types::InstanceBlockDeviceMapping&gt;
    #   * {Types::InstanceAttribute#disable_api_termination #disable_api_termination} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#ena_support #ena_support} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#enclave_options #enclave_options} => Types::EnclaveOptions
    #   * {Types::InstanceAttribute#ebs_optimized #ebs_optimized} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#instance_id #instance_id} => String
    #   * {Types::InstanceAttribute#instance_initiated_shutdown_behavior #instance_initiated_shutdown_behavior} => Types::AttributeValue
    #   * {Types::InstanceAttribute#instance_type #instance_type} => Types::AttributeValue
    #   * {Types::InstanceAttribute#kernel_id #kernel_id} => Types::AttributeValue
    #   * {Types::InstanceAttribute#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::InstanceAttribute#ramdisk_id #ramdisk_id} => Types::AttributeValue
    #   * {Types::InstanceAttribute#root_device_name #root_device_name} => Types::AttributeValue
    #   * {Types::InstanceAttribute#source_dest_check #source_dest_check} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#sriov_net_support #sriov_net_support} => Types::AttributeValue
    #   * {Types::InstanceAttribute#user_data #user_data} => Types::AttributeValue
    #
    #
    # @example Example: To describe the instance type
    #
    #   # This example describes the instance type of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "instanceType", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     instance_id: "i-1234567890abcdef0", 
    #     instance_type: {
    #       value: "t1.micro", 
    #     }, 
    #   }
    #
    # @example Example: To describe the disableApiTermination attribute
    #
    #   # This example describes the ``disableApiTermination`` attribute of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "disableApiTermination", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     disable_api_termination: {
    #       value: false, 
    #     }, 
    #     instance_id: "i-1234567890abcdef0", 
    #   }
    #
    # @example Example: To describe the block device mapping for an instance
    #
    #   # This example describes the ``blockDeviceMapping`` attribute of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "blockDeviceMapping", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     block_device_mappings: [
    #       {
    #         device_name: "/dev/sda1", 
    #         ebs: {
    #           attach_time: Time.parse("2013-05-17T22:42:34.000Z"), 
    #           delete_on_termination: true, 
    #           status: "attached", 
    #           volume_id: "vol-049df61146c4d7901", 
    #         }, 
    #       }, 
    #       {
    #         device_name: "/dev/sdf", 
    #         ebs: {
    #           attach_time: Time.parse("2013-09-10T23:07:00.000Z"), 
    #           delete_on_termination: false, 
    #           status: "attached", 
    #           volume_id: "vol-049df61146c4d7901", 
    #         }, 
    #       }, 
    #     ], 
    #     instance_id: "i-1234567890abcdef0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "instanceType", # required, accepts instanceType, kernel, ramdisk, userData, disableApiTermination, instanceInitiatedShutdownBehavior, rootDeviceName, blockDeviceMapping, productCodes, sourceDestCheck, groupSet, ebsOptimized, sriovNetSupport, enaSupport, enclaveOptions
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.groups #=> Array
    #   resp.groups[0].group_name #=> String
    #   resp.groups[0].group_id #=> String
    #   resp.block_device_mappings #=> Array
    #   resp.block_device_mappings[0].device_name #=> String
    #   resp.block_device_mappings[0].ebs.attach_time #=> Time
    #   resp.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.block_device_mappings[0].ebs.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.block_device_mappings[0].ebs.volume_id #=> String
    #   resp.disable_api_termination.value #=> Boolean
    #   resp.ena_support.value #=> Boolean
    #   resp.enclave_options.enabled #=> Boolean
    #   resp.ebs_optimized.value #=> Boolean
    #   resp.instance_id #=> String
    #   resp.instance_initiated_shutdown_behavior #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.instance_type #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.kernel_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.ramdisk_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.root_device_name #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.source_dest_check.value #=> Boolean
    #   resp.sriov_net_support #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.user_data #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute AWS API Documentation
    #
    # @overload describe_instance_attribute(params = {})
    # @param [Hash] params ({})
    def describe_instance_attribute(params = {}, options = {})
      req = build_request(:describe_instance_attribute, params)
      req.send_request(options)
    end

    # Describes the credit option for CPU usage of the specified burstable
    # performance instances. The credit options are `standard` and
    # `unlimited`.
    #
    # If you do not specify an instance ID, Amazon EC2 returns burstable
    # performance instances with the `unlimited` credit option, as well as
    # instances that were previously configured as T2, T3, and T3a with the
    # `unlimited` credit option. For example, if you resize a T2 instance,
    # while it is configured as `unlimited`, to an M4 instance, Amazon EC2
    # returns the M4 instance.
    #
    # If you specify one or more instance IDs, Amazon EC2 returns the credit
    # option (`standard` or `unlimited`) of those instances. If you specify
    # an instance ID that is not valid, such as an instance that is not a
    # burstable performance instance, an error is returned.
    #
    # Recently terminated instances might appear in the returned results.
    # This interval is usually less than one hour.
    #
    # If an Availability Zone is experiencing a service disruption and you
    # specify instance IDs in the affected zone, or do not specify any
    # instance IDs at all, the call fails. If you specify only instance IDs
    # in an unaffected zone, the call works normally.
    #
    # For more information, see [Burstable performance instances][1] in the
    # *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   ^
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 1000 explicitly specified instance IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeInstanceCreditSpecificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceCreditSpecificationsResult#instance_credit_specifications #instance_credit_specifications} => Array&lt;Types::InstanceCreditSpecification&gt;
    #   * {Types::DescribeInstanceCreditSpecificationsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_credit_specifications({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["InstanceId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_credit_specifications #=> Array
    #   resp.instance_credit_specifications[0].instance_id #=> String
    #   resp.instance_credit_specifications[0].cpu_credits #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications AWS API Documentation
    #
    # @overload describe_instance_credit_specifications(params = {})
    # @param [Hash] params ({})
    def describe_instance_credit_specifications(params = {}, options = {})
      req = build_request(:describe_instance_credit_specifications, params)
      req.send_request(options)
    end

    # Describes the tag keys that are registered to appear in scheduled
    # event notifications for resources in the current Region.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeInstanceEventNotificationAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceEventNotificationAttributesResult#instance_tag_attribute #instance_tag_attribute} => Types::InstanceTagNotificationAttribute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_event_notification_attributes({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_tag_attribute.instance_tag_keys #=> Array
    #   resp.instance_tag_attribute.instance_tag_keys[0] #=> String
    #   resp.instance_tag_attribute.include_all_tags_of_instance #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes AWS API Documentation
    #
    # @overload describe_instance_event_notification_attributes(params = {})
    # @param [Hash] params ({})
    def describe_instance_event_notification_attributes(params = {}, options = {})
      req = build_request(:describe_instance_event_notification_attributes, params)
      req.send_request(options)
    end

    # Describes the status of the specified instances or all of your
    # instances. By default, only running instances are described, unless
    # you specifically indicate to return the status of all instances.
    #
    # Instance status includes the following components:
    #
    # * **Status checks** - Amazon EC2 performs status checks on running EC2
    #   instances to identify hardware and software issues. For more
    #   information, see [Status checks for your instances][1] and
    #   [Troubleshooting instances with failed status checks][2] in the
    #   *Amazon EC2 User Guide*.
    #
    # * **Scheduled events** - Amazon EC2 can schedule events (such as
    #   reboot, stop, or terminate) for your instances related to hardware
    #   issues, software updates, or system maintenance. For more
    #   information, see [Scheduled events for your instances][3] in the
    #   *Amazon EC2 User Guide*.
    #
    # * **Instance state** - You can manage your instances from the moment
    #   you launch them through their termination. For more information, see
    #   [Instance lifecycle][4] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html
    # [4]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `event.code` - The code for the scheduled event (`instance-reboot`
    #     \| `system-reboot` \| `system-maintenance` \| `instance-retirement`
    #     \| `instance-stop`).
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.instance-event-id` - The ID of the event whose date and time
    #     you are modifying.
    #
    #   * `event.not-after` - The latest end time for the scheduled event (for
    #     example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before` - The earliest start time for the scheduled event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before-deadline` - The deadline for starting the event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `instance-state-code` - The code for the instance state, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-status.reachability` - Filters on instance status where
    #     the name is `reachability` (`passed` \| `failed` \| `initializing`
    #     \| `insufficient-data`).
    #
    #   * `instance-status.status` - The status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    #   * `system-status.reachability` - Filters on system status where the
    #     name is `reachability` (`passed` \| `failed` \| `initializing` \|
    #     `insufficient-data`).
    #
    #   * `system-status.status` - The system status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 100 explicitly specified instance IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :include_all_instances
    #   When `true`, includes the health status for all instances. When
    #   `false`, includes the health status for running instances only.
    #
    #   Default: `false`
    #
    # @return [Types::DescribeInstanceStatusResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceStatusResult#instance_statuses #instance_statuses} => Array&lt;Types::InstanceStatus&gt;
    #   * {Types::DescribeInstanceStatusResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the status of an instance
    #
    #   # This example describes the current status of the specified instance.
    #
    #   resp = client.describe_instance_status({
    #     instance_ids: [
    #       "i-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     instance_statuses: [
    #       {
    #         availability_zone: "us-east-1d", 
    #         instance_id: "i-1234567890abcdef0", 
    #         instance_state: {
    #           code: 16, 
    #           name: "running", 
    #         }, 
    #         instance_status: {
    #           details: [
    #             {
    #               name: "reachability", 
    #               status: "passed", 
    #             }, 
    #           ], 
    #           status: "ok", 
    #         }, 
    #         system_status: {
    #           details: [
    #             {
    #               name: "reachability", 
    #               status: "passed", 
    #             }, 
    #           ], 
    #           status: "ok", 
    #         }, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_status({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["InstanceId"],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #     include_all_instances: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_statuses #=> Array
    #   resp.instance_statuses[0].availability_zone #=> String
    #   resp.instance_statuses[0].outpost_arn #=> String
    #   resp.instance_statuses[0].events #=> Array
    #   resp.instance_statuses[0].events[0].instance_event_id #=> String
    #   resp.instance_statuses[0].events[0].code #=> String, one of "instance-reboot", "system-reboot", "system-maintenance", "instance-retirement", "instance-stop"
    #   resp.instance_statuses[0].events[0].description #=> String
    #   resp.instance_statuses[0].events[0].not_after #=> Time
    #   resp.instance_statuses[0].events[0].not_before #=> Time
    #   resp.instance_statuses[0].events[0].not_before_deadline #=> Time
    #   resp.instance_statuses[0].instance_id #=> String
    #   resp.instance_statuses[0].instance_state.code #=> Integer
    #   resp.instance_statuses[0].instance_state.name #=> String, one of "pending", "running", "shutting-down", "terminated", "stopping", "stopped"
    #   resp.instance_statuses[0].instance_status.details #=> Array
    #   resp.instance_statuses[0].instance_status.details[0].impaired_since #=> Time
    #   resp.instance_statuses[0].instance_status.details[0].name #=> String, one of "reachability"
    #   resp.instance_statuses[0].instance_status.details[0].status #=> String, one of "passed", "failed", "insufficient-data", "initializing"
    #   resp.instance_statuses[0].instance_status.status #=> String, one of "ok", "impaired", "insufficient-data", "not-applicable", "initializing"
    #   resp.instance_statuses[0].system_status.details #=> Array
    #   resp.instance_statuses[0].system_status.details[0].impaired_since #=> Time
    #   resp.instance_statuses[0].system_status.details[0].name #=> String, one of "reachability"
    #   resp.instance_statuses[0].system_status.details[0].status #=> String, one of "passed", "failed", "insufficient-data", "initializing"
    #   resp.instance_statuses[0].system_status.status #=> String, one of "ok", "impaired", "insufficient-data", "not-applicable", "initializing"
    #   resp.next_token #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * instance_status_ok
    #   * system_status_ok
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus AWS API Documentation
    #
    # @overload describe_instance_status(params = {})
    # @param [Hash] params ({})
    def describe_instance_status(params = {}, options = {})
      req = build_request(:describe_instance_status, params)
      req.send_request(options)
    end

    # Returns a list of all instance types offered. The results can be
    # filtered by location (Region or Availability Zone). If no location is
    # specified, the instance types offered in the current Region are
    # returned.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :location_type
    #   The location type.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `location` - This depends on the location type. For example, if the
    #     location type is `region` (default), the location is the Region code
    #     (for example, `us-east-2`.)
    #
    #   * `instance-type` - The instance type. For example, `c5.2xlarge`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the next token value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeInstanceTypeOfferingsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceTypeOfferingsResult#instance_type_offerings #instance_type_offerings} => Array&lt;Types::InstanceTypeOffering&gt;
    #   * {Types::DescribeInstanceTypeOfferingsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_type_offerings({
    #     dry_run: false,
    #     location_type: "region", # accepts region, availability-zone, availability-zone-id
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_type_offerings #=> Array
    #   resp.instance_type_offerings[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.instance_type_offerings[0].location_type #=> String, one of "region", "availability-zone", "availability-zone-id"
    #   resp.instance_type_offerings[0].location #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings AWS API Documentation
    #
    # @overload describe_instance_type_offerings(params = {})
    # @param [Hash] params ({})
    def describe_instance_type_offerings(params = {}, options = {})
      req = build_request(:describe_instance_type_offerings, params)
      req.send_request(options)
    end

    # Describes the details of the instance types that are offered in a
    # location. The results can be filtered by the attributes of the
    # instance types.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :instance_types
    #   The instance types. For more information, see [Instance types][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `auto-recovery-supported` - Indicates whether auto recovery is
    #     supported (`true` \| `false`).
    #
    #   * `bare-metal` - Indicates whether it is a bare metal instance type
    #     (`true` \| `false`).
    #
    #   * `burstable-performance-supported` - Indicates whether it is a
    #     burstable performance instance type (`true` \| `false`).
    #
    #   * `current-generation` - Indicates whether this instance type is the
    #     latest generation instance type of an instance family (`true` \|
    #     `false`).
    #
    #   * `ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps` - The
    #     baseline bandwidth performance for an EBS-optimized instance type,
    #     in Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-iops` - The baseline
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-throughput-in-mbps` - The
    #     baseline throughput performance for an EBS-optimized instance type,
    #     in MB/s.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps` - The
    #     maximum bandwidth performance for an EBS-optimized instance type, in
    #     Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-iops` - The maximum
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-throughput-in-mbps` - The
    #     maximum throughput performance for an EBS-optimized instance type,
    #     in MB/s.
    #
    #   * `ebs-info.ebs-optimized-support` - Indicates whether the instance
    #     type is EBS-optimized (`supported` \| `unsupported` \| `default`).
    #
    #   * `ebs-info.encryption-support` - Indicates whether EBS encryption is
    #     supported (`supported` \| `unsupported`).
    #
    #   * `ebs-info.nvme-support` - Indicates whether non-volatile memory
    #     express (NVMe) is supported for EBS volumes (`required` \|
    #     `supported` \| `unsupported`).
    #
    #   * `free-tier-eligible` - Indicates whether the instance type is
    #     eligible to use in the free tier (`true` \| `false`).
    #
    #   * `hibernation-supported` - Indicates whether On-Demand hibernation is
    #     supported (`true` \| `false`).
    #
    #   * `hypervisor` - The hypervisor (`nitro` \| `xen`).
    #
    #   * `instance-storage-info.disk.count` - The number of local disks.
    #
    #   * `instance-storage-info.disk.size-in-gb` - The storage size of each
    #     instance storage disk, in GB.
    #
    #   * `instance-storage-info.disk.type` - The storage technology for the
    #     local instance storage disks (`hdd` \| `ssd`).
    #
    #   * `instance-storage-info.nvme-support` - Indicates whether
    #     non-volatile memory express (NVMe) is supported for instance store
    #     (`required` \| `supported`) \| `unsupported`).
    #
    #   * `instance-storage-info.total-size-in-gb` - The total amount of
    #     storage available from all local instance storage, in GB.
    #
    #   * `instance-storage-supported` - Indicates whether the instance type
    #     has local instance storage (`true` \| `false`).
    #
    #   * `instance-type` - The instance type (for example `c5.2xlarge` or
    #     c5*).
    #
    #   * `memory-info.size-in-mib` - The memory size.
    #
    #   * `network-info.efa-info.maximum-efa-interfaces` - The maximum number
    #     of Elastic Fabric Adapters (EFAs) per instance.
    #
    #   * `network-info.efa-supported` - Indicates whether the instance type
    #     supports Elastic Fabric Adapter (EFA) (`true` \| `false`).
    #
    #   * `network-info.ena-support` - Indicates whether Elastic Network
    #     Adapter (ENA) is supported or required (`required` \| `supported` \|
    #     `unsupported`).
    #
    #   * `network-info.ipv4-addresses-per-interface` - The maximum number of
    #     private IPv4 addresses per network interface.
    #
    #   * `network-info.ipv6-addresses-per-interface` - The maximum number of
    #     private IPv6 addresses per network interface.
    #
    #   * `network-info.ipv6-supported` - Indicates whether the instance type
    #     supports IPv6 (`true` \| `false`).
    #
    #   * `network-info.maximum-network-interfaces` - The maximum number of
    #     network interfaces per instance.
    #
    #   * `network-info.network-performance` - The network performance (for
    #     example, "25 Gigabit").
    #
    #   * `processor-info.supported-architecture` - The CPU architecture
    #     (`arm64` \| `i386` \| `x86_64`).
    #
    #   * `processor-info.sustained-clock-speed-in-ghz` - The CPU clock speed,
    #     in GHz.
    #
    #   * `supported-boot-mode` - The boot mode (`legacy-bios` \| `uefi`).
    #
    #   * `supported-root-device-type` - The root device type (`ebs` \|
    #     `instance-store`).
    #
    #   * `supported-usage-class` - The usage class (`on-demand` \| `spot`).
    #
    #   * `supported-virtualization-type` - The virtualization type (`hvm` \|
    #     `paravirtual`).
    #
    #   * `vcpu-info.default-cores` - The default number of cores for the
    #     instance type.
    #
    #   * `vcpu-info.default-threads-per-core` - The default number of threads
    #     per core for the instance type.
    #
    #   * `vcpu-info.default-vcpus` - The default number of vCPUs for the
    #     instance type.
    #
    #   * `vcpu-info.valid-cores` - The number of cores that can be configured
    #     for the instance type.
    #
    #   * `vcpu-info.valid-threads-per-core` - The number of threads per core
    #     that can be configured for the instance type. For example, "1" or
    #     "1,2".
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the next token value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeInstanceTypesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceTypesResult#instance_types #instance_types} => Array&lt;Types::InstanceTypeInfo&gt;
    #   * {Types::DescribeInstanceTypesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_types({
    #     dry_run: false,
    #     instance_types: ["t1.micro"], # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_types #=> Array
    #   resp.instance_types[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.instance_types[0].current_generation #=> Boolean
    #   resp.instance_types[0].free_tier_eligible #=> Boolean
    #   resp.instance_types[0].supported_usage_classes #=> Array
    #   resp.instance_types[0].supported_usage_classes[0] #=> String, one of "spot", "on-demand"
    #   resp.instance_types[0].supported_root_device_types #=> Array
    #   resp.instance_types[0].supported_root_device_types[0] #=> String, one of "ebs", "instance-store"
    #   resp.instance_types[0].supported_virtualization_types #=> Array
    #   resp.instance_types[0].supported_virtualization_types[0] #=> String, one of "hvm", "paravirtual"
    #   resp.instance_types[0].bare_metal #=> Boolean
    #   resp.instance_types[0].hypervisor #=> String, one of "nitro", "xen"
    #   resp.instance_types[0].processor_info.supported_architectures #=> Array
    #   resp.instance_types[0].processor_info.supported_architectures[0] #=> String, one of "i386", "x86_64", "arm64"
    #   resp.instance_types[0].processor_info.sustained_clock_speed_in_ghz #=> Float
    #   resp.instance_types[0].v_cpu_info.default_v_cpus #=> Integer
    #   resp.instance_types[0].v_cpu_info.default_cores #=> Integer
    #   resp.instance_types[0].v_cpu_info.default_threads_per_core #=> Integer
    #   resp.instance_types[0].v_cpu_info.valid_cores #=> Array
    #   resp.instance_types[0].v_cpu_info.valid_cores[0] #=> Integer
    #   resp.instance_types[0].v_cpu_info.valid_threads_per_core #=> Array
    #   resp.instance_types[0].v_cpu_info.valid_threads_per_core[0] #=> Integer
    #   resp.instance_types[0].memory_info.size_in_mi_b #=> Integer
    #   resp.instance_types[0].instance_storage_supported #=> Boolean
    #   resp.instance_types[0].instance_storage_info.total_size_in_gb #=> Integer
    #   resp.instance_types[0].instance_storage_info.disks #=> Array
    #   resp.instance_types[0].instance_storage_info.disks[0].size_in_gb #=> Integer
    #   resp.instance_types[0].instance_storage_info.disks[0].count #=> Integer
    #   resp.instance_types[0].instance_storage_info.disks[0].type #=> String, one of "hdd", "ssd"
    #   resp.instance_types[0].instance_storage_info.nvme_support #=> String, one of "unsupported", "supported", "required"
    #   resp.instance_types[0].ebs_info.ebs_optimized_support #=> String, one of "unsupported", "supported", "default"
    #   resp.instance_types[0].ebs_info.encryption_support #=> String, one of "unsupported", "supported"
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.baseline_bandwidth_in_mbps #=> Integer
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.baseline_throughput_in_m_bps #=> Float
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.baseline_iops #=> Integer
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.maximum_bandwidth_in_mbps #=> Integer
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.maximum_throughput_in_m_bps #=> Float
    #   resp.instance_types[0].ebs_info.ebs_optimized_info.maximum_iops #=> Integer
    #   resp.instance_types[0].ebs_info.nvme_support #=> String, one of "unsupported", "supported", "required"
    #   resp.instance_types[0].network_info.network_performance #=> String
    #   resp.instance_types[0].network_info.maximum_network_interfaces #=> Integer
    #   resp.instance_types[0].network_info.maximum_network_cards #=> Integer
    #   resp.instance_types[0].network_info.default_network_card_index #=> Integer
    #   resp.instance_types[0].network_info.network_cards #=> Array
    #   resp.instance_types[0].network_info.network_cards[0].network_card_index #=> Integer
    #   resp.instance_types[0].network_info.network_cards[0].network_performance #=> String
    #   resp.instance_types[0].network_info.network_cards[0].maximum_network_interfaces #=> Integer
    #   resp.instance_types[0].network_info.ipv_4_addresses_per_interface #=> Integer
    #   resp.instance_types[0].network_info.ipv_6_addresses_per_interface #=> Integer
    #   resp.instance_types[0].network_info.ipv_6_supported #=> Boolean
    #   resp.instance_types[0].network_info.ena_support #=> String, one of "unsupported", "supported", "required"
    #   resp.instance_types[0].network_info.efa_supported #=> Boolean
    #   resp.instance_types[0].network_info.efa_info.maximum_efa_interfaces #=> Integer
    #   resp.instance_types[0].gpu_info.gpus #=> Array
    #   resp.instance_types[0].gpu_info.gpus[0].name #=> String
    #   resp.instance_types[0].gpu_info.gpus[0].manufacturer #=> String
    #   resp.instance_types[0].gpu_info.gpus[0].count #=> Integer
    #   resp.instance_types[0].gpu_info.gpus[0].memory_info.size_in_mi_b #=> Integer
    #   resp.instance_types[0].gpu_info.total_gpu_memory_in_mi_b #=> Integer
    #   resp.instance_types[0].fpga_info.fpgas #=> Array
    #   resp.instance_types[0].fpga_info.fpgas[0].name #=> String
    #   resp.instance_types[0].fpga_info.fpgas[0].manufacturer #=> String
    #   resp.instance_types[0].fpga_info.fpgas[0].count #=> Integer
    #   resp.instance_types[0].fpga_info.fpgas[0].memory_info.size_in_mi_b #=> Integer
    #   resp.instance_types[0].fpga_info.total_fpga_memory_in_mi_b #=> Integer
    #   resp.instance_types[0].placement_group_info.supported_strategies #=> Array
    #   resp.instance_types[0].placement_group_info.supported_strategies[0] #=> String, one of "cluster", "partition", "spread"
    #   resp.instance_types[0].inference_accelerator_info.accelerators #=> Array
    #   resp.instance_types[0].inference_accelerator_info.accelerators[0].count #=> Integer
    #   resp.instance_types[0].inference_accelerator_info.accelerators[0].name #=> String
    #   resp.instance_types[0].inference_accelerator_info.accelerators[0].manufacturer #=> String
    #   resp.instance_types[0].hibernation_supported #=> Boolean
    #   resp.instance_types[0].burstable_performance_supported #=> Boolean
    #   resp.instance_types[0].dedicated_hosts_supported #=> Boolean
    #   resp.instance_types[0].auto_recovery_supported #=> Boolean
    #   resp.instance_types[0].supported_boot_modes #=> Array
    #   resp.instance_types[0].supported_boot_modes[0] #=> String, one of "legacy-bios", "uefi"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes AWS API Documentation
    #
    # @overload describe_instance_types(params = {})
    # @param [Hash] params ({})
    def describe_instance_types(params = {}, options = {})
      req = build_request(:describe_instance_types, params)
      req.send_request(options)
    end

    # Describes the specified instances or all instances.
    #
    # If you specify instance IDs, the output includes information for only
    # the specified instances. If you specify filters, the output includes
    # information for only those instances that meet the filter criteria. If
    # you do not specify instance IDs or filters, the output includes
    # information for all instances, which can affect performance. We
    # recommend that you use pagination to ensure that the operation returns
    # quickly and successfully.
    #
    # If you specify an instance ID that is not valid, an error is returned.
    # If you specify an instance that you do not own, it is not included in
    # the output.
    #
    # Recently terminated instances might appear in the returned results.
    # This interval is usually less than one hour.
    #
    # If you describe instances in the rare case where an Availability Zone
    # is experiencing a service disruption and you specify instance IDs that
    # are in the affected zone, or do not specify any instance IDs at all,
    # the call fails. If you describe instances and specify only instance
    # IDs that are in an unaffected zone, the call works normally.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `affinity` - The affinity setting for an instance running on a
    #     Dedicated Host (`default` \| `host`).
    #
    #   * `architecture` - The instance architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `block-device-mapping.attach-time` - The attach time for an EBS
    #     volume mapped to the instance, for example,
    #     `2010-09-15T17:15:20.000Z`.
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean that
    #     indicates whether the EBS volume is deleted on instance termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.status` - The status for the EBS volume
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `block-device-mapping.volume-id` - The volume ID of the EBS volume.
    #
    #   * `client-token` - The idempotency token you provided when you
    #     launched the instance.
    #
    #   * `dns-name` - The public DNS name of the instance.
    #
    #   * `group-id` - The ID of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `group-name` - The name of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `hibernation-options.configured` - A Boolean that indicates whether
    #     the instance is enabled for hibernation. A value of `true` means
    #     that the instance is enabled for hibernation.
    #
    #   * `host-id` - The ID of the Dedicated Host on which the instance is
    #     running, if applicable.
    #
    #   * `hypervisor` - The hypervisor type of the instance (`ovm` \| `xen`).
    #     The value `xen` is used for both Xen and Nitro hypervisors.
    #
    #   * `iam-instance-profile.arn` - The instance profile associated with
    #     the instance. Specified as an ARN.
    #
    #   * `image-id` - The ID of the image used to launch the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `instance-lifecycle` - Indicates whether this is a Spot Instance or
    #     a Scheduled Instance (`spot` \| `scheduled`).
    #
    #   * `instance-state-code` - The state of the instance, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are: 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-type` - The type of instance (for example, `t2.micro`).
    #
    #   * `instance.group-id` - The ID of the security group for the instance.
    #
    #   * `instance.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `ip-address` - The public IPv4 address of the instance.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `key-name` - The name of the key pair used when the instance was
    #     launched.
    #
    #   * `launch-index` - When launching multiple instances, this is the
    #     index for the instance in the launch group (for example, 0, 1, 2,
    #     and so on).
    #
    #   * `launch-time` - The time when the instance was launched.
    #
    #   * `metadata-options.http-tokens` - The metadata request authorization
    #     state (`optional` \| `required`)
    #
    #   * `metadata-options.http-put-response-hop-limit` - The http metadata
    #     request put response hop limit (integer, possible values `1` to
    #     `64`)
    #
    #   * `metadata-options.http-endpoint` - Enable or disable metadata access
    #     on http endpoint (`enabled` \| `disabled`)
    #
    #   * `monitoring-state` - Indicates whether detailed monitoring is
    #     enabled (`disabled` \| `enabled`).
    #
    #   * `network-interface.addresses.private-ip-address` - The private IPv4
    #     address associated with the network interface.
    #
    #   * `network-interface.addresses.primary` - Specifies whether the IPv4
    #     address of the network interface is the primary private IPv4
    #     address.
    #
    #   * `network-interface.addresses.association.public-ip` - The ID of the
    #     association of an Elastic IP address (IPv4) with a network
    #     interface.
    #
    #   * `network-interface.addresses.association.ip-owner-id` - The owner ID
    #     of the private IPv4 address associated with the network interface.
    #
    #   * `network-interface.association.public-ip` - The address of the
    #     Elastic IP address (IPv4) bound to the network interface.
    #
    #   * `network-interface.association.ip-owner-id` - The owner of the
    #     Elastic IP address (IPv4) associated with the network interface.
    #
    #   * `network-interface.association.allocation-id` - The allocation ID
    #     returned when you allocated the Elastic IP address (IPv4) for your
    #     network interface.
    #
    #   * `network-interface.association.association-id` - The association ID
    #     returned when the network interface was associated with an IPv4
    #     address.
    #
    #   * `network-interface.attachment.attachment-id` - The ID of the
    #     interface attachment.
    #
    #   * `network-interface.attachment.instance-id` - The ID of the instance
    #     to which the network interface is attached.
    #
    #   * `network-interface.attachment.instance-owner-id` - The owner ID of
    #     the instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.device-index` - The device index to
    #     which the network interface is attached.
    #
    #   * `network-interface.attachment.status` - The status of the attachment
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `network-interface.attachment.attach-time` - The time that the
    #     network interface was attached to an instance.
    #
    #   * `network-interface.attachment.delete-on-termination` - Specifies
    #     whether the attachment is deleted when an instance is terminated.
    #
    #   * `network-interface.availability-zone` - The Availability Zone for
    #     the network interface.
    #
    #   * `network-interface.description` - The description of the network
    #     interface.
    #
    #   * `network-interface.group-id` - The ID of a security group associated
    #     with the network interface.
    #
    #   * `network-interface.group-name` - The name of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
    #     associated with the network interface.
    #
    #   * `network-interface.mac-address` - The MAC address of the network
    #     interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.owner-id` - The ID of the owner of the network
    #     interface.
    #
    #   * `network-interface.private-dns-name` - The private DNS name of the
    #     network interface.
    #
    #   * `network-interface.requester-id` - The requester ID for the network
    #     interface.
    #
    #   * `network-interface.requester-managed` - Indicates whether the
    #     network interface is being managed by AWS.
    #
    #   * `network-interface.status` - The status of the network interface
    #     (`available`) \| `in-use`).
    #
    #   * `network-interface.source-dest-check` - Whether the network
    #     interface performs source/destination checking. A value of `true`
    #     means that checking is enabled, and `false` means that checking is
    #     disabled. The value must be `false` for the network interface to
    #     perform network address translation (NAT) in your VPC.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the network
    #     interface.
    #
    #   * `network-interface.vpc-id` - The ID of the VPC for the network
    #     interface.
    #
    #   * `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
    #
    #   * `owner-id` - The AWS account ID of the instance owner.
    #
    #   * `placement-group-name` - The name of the placement group for the
    #     instance.
    #
    #   * `placement-partition-number` - The partition in which the instance
    #     is located.
    #
    #   * `platform` - The platform. To list only Windows instances, use
    #     `windows`.
    #
    #   * `private-dns-name` - The private IPv4 DNS name of the instance.
    #
    #   * `private-ip-address` - The private IPv4 address of the instance.
    #
    #   * `product-code` - The product code associated with the AMI used to
    #     launch the instance.
    #
    #   * `product-code.type` - The type of product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `reason` - The reason for the current state of the instance (for
    #     example, shows "User Initiated \[date\]" when you stop or
    #     terminate the instance). Similar to the state-reason-code filter.
    #
    #   * `requester-id` - The ID of the entity that launched the instance on
    #     your behalf (for example, AWS Management Console, Auto Scaling, and
    #     so on).
    #
    #   * `reservation-id` - The ID of the instance's reservation. A
    #     reservation ID is created any time you launch an instance. A
    #     reservation ID has a one-to-one relationship with an instance launch
    #     request, but can be associated with more than one instance if you
    #     launch multiple instances using the same launch request. For
    #     example, if you launch one instance, you get one reservation ID. If
    #     you launch ten instances using the same launch request, you also get
    #     one reservation ID.
    #
    #   * `root-device-name` - The device name of the root device volume (for
    #     example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `source-dest-check` - Indicates whether the instance performs
    #     source/destination checking. A value of `true` means that checking
    #     is enabled, and `false` means that checking is disabled. The value
    #     must be `false` for the instance to perform network address
    #     translation (NAT) in your VPC.
    #
    #   * `spot-instance-request-id` - The ID of the Spot Instance request.
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - A message that describes the state change.
    #
    #   * `subnet-id` - The ID of the subnet for the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tenancy` - The tenancy of an instance (`dedicated` \| `default` \|
    #     `host`).
    #
    #   * `virtualization-type` - The virtualization type of the instance
    #     (`paravirtual` \| `hvm`).
    #
    #   * `vpc-id` - The ID of the VPC that the instance is running in.
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstancesResult#reservations #reservations} => Array&lt;Types::Reservation&gt;
    #   * {Types::DescribeInstancesResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe an Amazon EC2 instance
    #
    #   # This example describes the specified instance.
    #
    #   resp = client.describe_instances({
    #     instance_ids: [
    #       "i-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To describe the instances with a specific instance type
    #
    #   # This example describes the instances with the t2.micro instance type.
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "instance-type", 
    #         values: [
    #           "t2.micro", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To describe the instances with a specific tag
    #
    #   # This example describes the instances with the Purpose=test tag.
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "tag:Purpose", 
    #         values: [
    #           "test", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Filtering by tags examples
    #   # filtering by tag keys "key1" or "key2"
    #   ec2.describe_instances(filters:[{ name: 'tag-key', values: ['key1', 'key2'] }])
    #
    #   # filtering by tag values "value1" or "value1"
    #   ec2.describe_instances(filters:[{ name: 'tag-value', values: ['value1', 'value2'] }])
    #
    #   # filtering by key and value, key equals "key1" and value equals "value1" or "value2"
    #   ec2.describe_instances(filters:[{ name: "tag:key1", values: ['value1'] }])
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["InstanceId"],
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.reservations #=> Array
    #   resp.reservations[0].groups #=> Array
    #   resp.reservations[0].groups[0].group_name #=> String
    #   resp.reservations[0].groups[0].group_id #=> String
    #   resp.reservations[0].instances #=> Array
    #   resp.reservations[0].instances[0].ami_launch_index #=> Integer
    #   resp.reservations[0].instances[0].image_id #=> String
    #   resp.reservations[0].instances[0].instance_id #=> String
    #   resp.reservations[0].instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r6g.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6gd.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6gd.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "mac1.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal"
    #   resp.reservations[0].instances[0].kernel_id #=> String
    #   resp.reservations[0].instances[0].key_name #=> String
    #   resp.reservations[0].instances[0].launch_time #=> Time
    #   resp.reservations[0].instances[0].monitoring.state #=> String, one of "disabled", "disabling", "enabled", "pending"
    #   resp.reservations[0].instances[0].placement.availability_zone #=> String
    #   resp.reservations[0].instances[0].placement.affinity #=> String
    #   resp.reservations[0].instances[0].placement.group_name #=> String
    #   resp.reservations[0].instances[0].placement.partition_number #=> Integer
    #   resp.reservations[0].instances[0].placement.host_id #=> String
    #   resp.reservations[0].instances[0].placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.reservations[0].instances[0].placement.spread_domain #=> String
    #   resp.reservations[0].instances[0].placement.host_resource_group_arn #=> String
    #   resp.reservations[0].instances[0].platform #=> String, one of "Windows"
    #   resp.reservations[0].instances[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].product_codes #=> Array
    #   resp.reservations[0].instances[0].product_codes[0].product_code_id #=> String
    #   resp.reservations[0].instances[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.reservations[0].instances[0].public_dns_name #=> String
    #   resp.reservations[0].instances[0].public_ip_address #=> String
    #   resp.reservations[0].instances[0].ramdisk_id #=> String
    #   resp.reservations[0].instances[0].state.code #=> Integer
    #   resp.reservations[0].instances[0].state.name #=> String, one of "pending", "running", "shutting-down", "terminated", "stopping", "stopped"
    #   resp.reservations[0].instances[0].state_transition_reason #=> String
    #   resp.reservations[0].instances[0].subnet_id #=> String
    #   resp.reservations[0].instances[0].vpc_id #=> String
    #   resp.reservations[0].instances[0].architecture #=> String, one of "i386", "x86_64", "arm64"
    #   resp.reservations[0].instances[0].block_device_mappings #=> Array
    #   resp.reservations[0].instances[0].block_device_mappings[0].device_name #=> String
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.attach_time #=> Time
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.volume_id #=> String
    #   resp.reservations[0].instances[0].client_token #=> String
    #   resp.reservations[0].instances[0].ebs_optimized #=> Boolean
    #   resp.reservations[0].instances[0].ena_support #=> Boolean
    #   resp.reservations[0].instances[0].hypervisor #=> String, one of "ovm", "xen"
    #   resp.reservations[0].instances[0].iam_instance_profile.arn #=> String
    #   resp.reservations[0].instances[0].iam_instance_profile.id #=> String
    #   resp.reservations[0].instances[0].instance_lifecycle #=> String, one of "spot", "scheduled"
    #   resp.reservations[0].instances[0].elastic_gpu_associations #=> Array
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_id #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_id #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_state #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_time #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations #=> Array
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_arn #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_id #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_state #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_time #=> Time
    #   resp.reservations[0].instances[0].network_interfaces #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].association.carrier_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].association.ip_owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].association.public_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].association.public_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.attach_time #=> Time
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.attachment_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.delete_on_termination #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.device_index #=> Integer
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.network_card_index #=> Integer
    #   resp.reservations[0].instances[0].network_interfaces[0].description #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].groups #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].groups[0].group_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].groups[0].group_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].mac_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].network_interface_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.carrier_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.public_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].source_dest_check #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.reservations[0].instances[0].network_interfaces[0].subnet_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].vpc_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].interface_type #=> String
    #   resp.reservations[0].instances[0].outpost_arn #=> String
    #   resp.reservations[0].instances[0].root_device_name #=> String
    #   resp.reservations[0].instances[0].root_device_type #=> String, one of "ebs", "instance-store"
    #   resp.reservations[0].instances[0].security_groups #=> Array
    #   resp.reservations[0].instances[0].security_groups[0].group_name #=> String
    #   resp.reservations[0].instances[0].security_groups[0].group_id #=> String
    #   resp.reservations[0].instances[0].source_dest_check #=> Boolean
    #   resp.reservations[0].instances[0].spot_instance_request_id #=> String
    #   resp.reservations[0].instances[0].sriov_net_support #=> String
    #   resp.reservations[0].instances[0].state_reason.code #=> String
    #   resp.reservations[0].instances[0].state_reason.message #=> String
    #   resp.reservations[0].instances[0].tags #=> Array
    #   resp.reservations[0].instances[0].tags[0].key #=> String
    #   resp.reservations[0].instances[0].tags[0].value #=> String
    #   resp.reservations[0].instances[0].virtualization_type #=> String, one of "hvm", "paravirtual"
    #   resp.reservations[0].instances[0].cpu_options.core_count #=> Integer
    #   resp.reservations[0].instances[0].cpu_options.threads_per_core #=> Integer
    #   resp.reservations[0].instances[0].capacity_reservation_id #=> String
    #   resp.reservations[0].instances[0].capacity_reservation_specification.capacity_reservation_preference #=> String, one of "open", "none"
    #   resp.reservations[0].instances[0].capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.reservations[0].instances[0].capacity_reservation_specification.capacity_reservation_target.capacity_reservation_resource_group_arn #=> String
    #   resp.reservations[0].instances[0].hibernation_options.configured #=> Boolean
    #   resp.reservations[0].instances[0].licenses #=> Array
    #   resp.reservations[0].instances[0].licenses[0].license_configuration_arn #=> String
    #   resp.reservations[0].instances[0].metadata_options.state #=> String, one of "pending", "applied"
    #   resp.reservations[0].instances[0].metadata_options.http_tokens #=> String, one of "optional", "required"
    #   resp.reservations[0].instances[0].metadata_options.http_put_response_hop_limit #=> Integer
    #   resp.reservations[0].instances[0].metadata_options.http_endpoint #=> String, one of "disabled", "enabled"
    #   resp.reservations[0].instances[0].enclave_options.enabled #=> Boolean
    #   resp.reservations[0].instances[0].boot_mode #=> String, one of "legacy-bios", "uefi"
    #   resp.reservations[0].owner_id #=> String
    #   resp.reservations[0].requester_id #=> String
    #   resp.reservations[0].reservation_id #=> String
    #   resp.next_token #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * instance_exists
    #   * instance_running
    #   * instance_stopped
    #   * instance_terminated
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances AWS API Documentation
    #
    # @overload describe_instances(params = {})
    # @param [Hash] params ({})
    def describe_instances(params = {}, options = {})
      req = build_request(:describe_instances, params)
      req.send_request(options)
    end

    # Describes one or more of your internet gateways.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `attachment.state` - The current state of the attachment between the
    #     gateway and the VPC (`available`). Present only if a VPC is
    #     attached.
    #
    #   * `attachment.vpc-id` - The ID of an attached VPC.
    #
    #   * `internet-gateway-id` - The ID of the Internet gateway.
    #
    #   * `owner-id` - The ID of the AWS account that owns the internet
    #     gateway.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :internet_gateway_ids
    #   One or more internet gateway IDs.
    #
    #   Default: Describes all your internet gateways.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeInternetGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInternetGatewaysResult#internet_gateways #internet_gateways} => Array&lt;Types::InternetGateway&gt;
    #   * {Types::DescribeInternetGatewaysResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    #
    # @example Example: To describe the Internet gateway for a VPC
    #
    #   # This example describes the Internet gateway for the specified VPC.
    #
    #   resp = client.describe_internet_gateways({
    #     filters: [
    #       {
    #         name: "attachment.vpc-id", 
    #         values: [
    #           "vpc-a01106c2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     internet_gateways: [
    #       {
    #         attachments: [
    #           {
    #             state: "available", 
    #             vpc_id: "vpc-a01106c2", 
    #           }, 
    #         ], 
    #         internet_gateway_id: "igw-c0a643a9", 
    #         tags: [
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_internet_gateways({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     internet_gateway_ids: ["InternetGatewayId"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.internet_gateways #=> Array
    #   resp.internet_gateways[0].attachments #=> Array
    #   resp.internet_gateways[0].attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.internet_gateways[0].attachments[0].vpc_id #=> String
    #   resp.internet_gateways[0].internet_gateway_id #=> String
    #   resp.internet_gateways[0].owner_id #=> String
    #   resp.internet_gateways[0].tags #=> Array
    #   resp.internet_gateways[0].tags[0].key #=> String
    #   resp.internet_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways AWS API Documentation
    #
    # @overload describe_internet_gateways(params = {})
    # @param [Hash] params ({})
    def describe_internet_gateways(params = {}, options = {})
      req = build_request(:describe_internet_gateways, params)
      req.send_request(options)
    end

    # Describes your IPv6 address pools.
    #
    # @option params [Array<String>] :pool_ids
    #   The IDs of the IPv6 address pools.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @return [Types::DescribeIpv6PoolsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIpv6PoolsResult#ipv_6_pools #ipv_6_pools} => Array&lt;Types::Ipv6Pool&gt;
    #   * {Types::DescribeIpv6PoolsResult#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_ipv_6_pools({
    #     pool_ids: ["Ipv6PoolEc2Id"],
    #     next_token: "NextToken",
    #     max_results: 1,
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_pools #=> Array
    #   resp.ipv_6_pools[0].pool_id #=> String
    #   resp.ipv_6_pools[0].description #=> String
    #   resp.ipv_6_pools[0].pool_cidr_blocks #=> Array
    #   resp.ipv_6_pools[0].pool_cidr_blocks[0].cidr #=> String
    #   resp.ipv_6_pools[0].tags #=> Array
    #   resp.ipv_6_pools[0].tags[0].key #=> String
    #   resp.ipv_6_pools[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools AWS API Documentation
    #
    # @overload describe_ipv_6_pools(params = {})
    # @param [Hash] params ({})
    def describe_ipv_6_pools(params = {}, options = {})
      req = build_request(:describe_ipv_6_pools, params)
      req.send_request(options)
    end

    # Describes the specified key pairs or all of your key pairs.
    #
    # For more information about key pairs, see [Key Pairs][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `key-pair-id` - The ID of the key pair.
    #
    #   * `fingerprint` - The fingerprint of the key pair.
    #
    #   * `key-name` - The name of the key pair.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    # @option params [Array<String>] :key_names
    #   The key pair names.
    #
    #   Default: Describes all your key pairs.
    #
    # @option params [Array<String>] :key_pair_ids
    #   The IDs of the key pairs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeKeyPairsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeKeyPairsResult#key_pairs #key_pairs} => Array&lt;Types::KeyPairInfo&gt;
    #
    #
    # @example Example: To display a key pair
    #
    #   # This example displays the fingerprint for the specified key.
    #
    #   resp = client.describe_key_pairs({
    #     key_names: [
    #       "my-key-pair", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     key_pairs: [
    #       {
    #         key_fingerprint: "1f:51:ae:28:bf:89:e9:d8:1f:25:5d:37:2d:7d:b8:ca:9f:f5:f1:6f", 
    #         key_name: "my-key-pair", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_key_pairs({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     key_names: ["KeyPairName"],
    #     key_pair_ids: ["KeyPairId"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.key_pairs #=> Array
    #   resp.key_pairs[0].key_pair_id #=> String
    #   resp.key_pairs[0].key_fingerprint #=> String
    #   resp.key_pairs[0].key_name #=> String
    #   resp.key_pairs[0].tags #=> Array
    #   resp.key_pairs[0].tags[0].key #=> String
    #   resp.key_pairs[0].tags[0].value #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * key_pair_exists
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs AWS API Documentation
    #
    # @overload describe_key_pairs(params = {})
    # @param [Hash] params ({})
    def describe_key_pairs(params = {}, options = {})
      req = build_request(:describe_key_pairs, params)
      req.send_request(options)
    end

    # Describes one or more versions of a specified launch template. You can
    # describe all versions, individual versions, or a range of versions.
    # You can also describe all the latest versions or all the default
    # versions of all the launch templates in your account.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. To describe one or more versions of a
    #   specified launch template, you must specify either the launch template
    #   ID or the launch template name in the request. To describe all the
    #   latest or default launch template versions in your account, you must
    #   omit this parameter.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. To describe one or more versions of a
    #   specified launch template, you must specify either the launch template
    #   ID or the launch template name in the request. To describe all the
    #   latest or default launch template versions in your account, you must
    #   omit this parameter.
    #
    # @option params [Array<String>] :versions
    #   One or more versions of the launch template. Valid values depend on
    #   whether you are describing a specified launch template (by ID or name)
    #   or all launch templates in your account.
    #
    #   To describe one or more versions of a specified launch template, valid
    #   values are `$Latest`, `$Default`, and numbers.
    #
    #   To describe all launch templates in your account that are defined as
    #   the latest version, the valid value is `$Latest`. To describe all
    #   launch templates in your account that are defined as the default
    #   version, the valid value is `$Default`. You can specify `$Latest` and
    #   `$Default` in the same call. You cannot specify numbers.
    #
    # @option params [String] :min_version
    #   The version number after which to describe launch template versions.
    #
    # @option params [String] :max_version
    #   The version number up to which to describe launch template versions.
    #
    # @option