# -*- coding:binary -*-
require 'spec_helper'


RSpec.describe Msf::Exploit::Remote::HTTP::Wordpress::Base do
  subject do
    mod_klass = Class.new(::Msf::Exploit) do
      include ::Msf::Exploit::Remote::HTTP::Wordpress
    end
    features = instance_double(Msf::FeatureManager, enabled?: false)
    mod_klass.framework = instance_double(Msf::Framework, features: features, datastore: {})
    mod_klass.new
  end

  describe '#wordpress_and_online?' do
    before :example do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = wp_code
        res.body = wp_body
        res
      end
    end

    let(:wp_code) { 200 }

    context 'when wp-content in body' do
      let(:wp_body) { '<a href="http://domain.com/wp-content/themes/a/style.css">' }
      it { expect(subject.wordpress_and_online?).to be_kind_of Rex::Proto::Http::Response }
    end

    context 'when wlwmanifest in body' do
      let(:wp_body) { '<link rel="wlwmanifest" type="application/wlwmanifest+xml" href="https://domain.com/wp-includes/wlwmanifest.xml" />' }
      it { expect(subject.wordpress_and_online?).to be_kind_of Rex::Proto::Http::Response }
    end

    context 'when pingback in body' do
      let(:wp_body) { '<link rel="pingback" href="https://domain.com/xmlrpc.php" />' }
      it { expect(subject.wordpress_and_online?).to be_kind_of Rex::Proto::Http::Response }
    end

    context 'when status code != 200' do
      let(:wp_body) { nil }
      let(:wp_code) { 404 }
      it { expect(subject.wordpress_and_online?).to be_nil }
    end

    context 'when no match in body' do
      let(:wp_body) { 'Invalid body' }
      it { expect(subject.wordpress_and_online?).to be_nil }
    end

  end

end
