/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Channel;
import com.metasploit.meterpreter.Meterpreter;
import java.io.IOException;
import java.io.InputStream;

public class ProcessChannel
extends Channel {
    private final Process process;
    private final InputStream inputStream;
    private final InputStream err;

    public ProcessChannel(Meterpreter meterpreter, Process process) {
        super(meterpreter, null, process.getOutputStream());
        this.inputStream = process.getInputStream();
        this.err = process.getErrorStream();
        this.process = process;
        Channel.InteractThread interactThread = new Channel.InteractThread((Channel)this, this.inputStream, false);
        Channel.InteractThread interactThread2 = new Channel.InteractThread((Channel)this, this.err, false);
        new CloseThread((Thread)interactThread, (Thread)interactThread2).start();
    }

    public synchronized byte[] read(int n) throws IOException, InterruptedException {
        if (this.closed) {
            return null;
        }
        if (this.active) {
            throw new IllegalStateException("Cannot read; currently interacting with this channel");
        }
        if (!this.waiting || this.toRead != null && this.toRead.length == 0) {
            return new byte[0];
        }
        if (this.toRead == null) {
            return null;
        }
        return super.read(n);
    }

    public void close() throws IOException {
        this.process.destroy();
        this.inputStream.close();
        this.err.close();
        super.close();
    }

    class CloseThread
    extends Thread {
        private final Thread stdinThread;
        private final Thread stderrThread;

        public CloseThread(Thread thread, Thread thread2) {
            this.stdinThread = thread;
            this.stderrThread = thread2;
        }

        public void run() {
            try {
                this.stdinThread.start();
                this.stderrThread.start();
                this.stdinThread.join();
                this.stderrThread.join();
                ProcessChannel.this.handleInteract(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(ProcessChannel.this.meterpreter.getErrorStream());
            }
        }
    }
}

