/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public enum RuntimeMode {
    DEVELOPMENT("development"),
    DEPLOYMENT("deployment");

    private final String name;
    private static final Map<String, RuntimeMode> map;

    private RuntimeMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RuntimeMode byName(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        throw new NoSuchElementException("Cannot found PF4J runtime mode with name '" + name + "'. Must be 'development' or 'deployment'.");
    }

    static {
        map = new HashMap<String, RuntimeMode>();
        for (RuntimeMode mode : RuntimeMode.values()) {
            map.put(mode.name, mode);
        }
    }
}

