/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.AbstractPluginManager;
import ro.fortsoft.pf4j.DefaultExtensionFactory;
import ro.fortsoft.pf4j.DefaultExtensionFinder;
import ro.fortsoft.pf4j.DefaultPluginClasspath;
import ro.fortsoft.pf4j.DefaultPluginDescriptorFinder;
import ro.fortsoft.pf4j.DefaultPluginFactory;
import ro.fortsoft.pf4j.DefaultPluginLoader;
import ro.fortsoft.pf4j.DefaultPluginRepository;
import ro.fortsoft.pf4j.DefaultPluginStatusProvider;
import ro.fortsoft.pf4j.DevelopmentPluginClasspath;
import ro.fortsoft.pf4j.ExtensionFactory;
import ro.fortsoft.pf4j.ExtensionFinder;
import ro.fortsoft.pf4j.PluginClasspath;
import ro.fortsoft.pf4j.PluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.PluginFactory;
import ro.fortsoft.pf4j.PluginLoader;
import ro.fortsoft.pf4j.PluginRepository;
import ro.fortsoft.pf4j.PluginStatusProvider;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.PropertiesPluginDescriptorFinder;
import ro.fortsoft.pf4j.util.FileUtils;

public class DefaultPluginManager
extends AbstractPluginManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginManager.class);
    protected PluginClasspath pluginClasspath;

    public DefaultPluginManager() {
    }

    @Deprecated
    public DefaultPluginManager(File pluginsDir) {
        this(pluginsDir.toPath());
    }

    public DefaultPluginManager(Path pluginsRoot) {
        super(pluginsRoot);
    }

    @Override
    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return this.isDevelopment() ? new PropertiesPluginDescriptorFinder() : new DefaultPluginDescriptorFinder(this.pluginClasspath);
    }

    @Override
    protected ExtensionFinder createExtensionFinder() {
        DefaultExtensionFinder extensionFinder = new DefaultExtensionFinder(this);
        this.addPluginStateListener(extensionFinder);
        return extensionFinder;
    }

    @Override
    protected PluginFactory createPluginFactory() {
        return new DefaultPluginFactory();
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new DefaultExtensionFactory();
    }

    @Override
    protected PluginStatusProvider createPluginStatusProvider() {
        return new DefaultPluginStatusProvider(this.getPluginsRoot());
    }

    @Override
    protected PluginRepository createPluginRepository() {
        return new DefaultPluginRepository(this.getPluginsRoot(), this.isDevelopment());
    }

    @Override
    protected PluginLoader createPluginLoader() {
        return new DefaultPluginLoader(this, this.pluginClasspath);
    }

    protected PluginClasspath createPluginClasspath() {
        return this.isDevelopment() ? new DevelopmentPluginClasspath() : new DefaultPluginClasspath();
    }

    @Override
    protected void initialize() {
        this.pluginClasspath = this.createPluginClasspath();
        super.initialize();
        log.info("PF4J version {} in '{}' mode", (Object)this.getVersion(), (Object)this.getRuntimeMode());
    }

    @Override
    protected PluginWrapper loadPluginFromPath(Path pluginPath) throws PluginException {
        try {
            pluginPath = FileUtils.expandIfZip(pluginPath);
        }
        catch (Exception e) {
            log.warn("Failed to unzip " + pluginPath, e);
            return null;
        }
        return super.loadPluginFromPath(pluginPath);
    }
}

