/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.pf4j.AbstractPluginManager;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultExtensionFactory;
import org.pf4j.DefaultExtensionFinder;
import org.pf4j.DefaultPluginClasspath;
import org.pf4j.DefaultPluginFactory;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.DefaultPluginRepository;
import org.pf4j.DefaultPluginStatusProvider;
import org.pf4j.DefaultVersionManager;
import org.pf4j.DevelopmentPluginClasspath;
import org.pf4j.ExtensionFactory;
import org.pf4j.ExtensionFinder;
import org.pf4j.JarPluginLoader;
import org.pf4j.JarPluginRepository;
import org.pf4j.LoggingPluginStateListener;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginClasspath;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginException;
import org.pf4j.PluginFactory;
import org.pf4j.PluginLoader;
import org.pf4j.PluginRepository;
import org.pf4j.PluginStatusProvider;
import org.pf4j.PluginWrapper;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.pf4j.VersionManager;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginManager
extends AbstractPluginManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginManager.class);
    protected PluginClasspath pluginClasspath;

    public DefaultPluginManager() {
    }

    @Deprecated
    public DefaultPluginManager(File pluginsDir) {
        this(pluginsDir.toPath());
    }

    public DefaultPluginManager(Path pluginsRoot) {
        super(pluginsRoot);
    }

    @Override
    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new CompoundPluginDescriptorFinder().add(new PropertiesPluginDescriptorFinder()).add(new ManifestPluginDescriptorFinder());
    }

    @Override
    protected ExtensionFinder createExtensionFinder() {
        DefaultExtensionFinder extensionFinder = new DefaultExtensionFinder(this);
        this.addPluginStateListener(extensionFinder);
        return extensionFinder;
    }

    @Override
    protected PluginFactory createPluginFactory() {
        return new DefaultPluginFactory();
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new DefaultExtensionFactory();
    }

    @Override
    protected PluginStatusProvider createPluginStatusProvider() {
        String configDir = System.getProperty("pf4j.pluginsConfigDir");
        Path configPath = configDir != null ? Paths.get(configDir, new String[0]) : this.getPluginsRoot();
        return new DefaultPluginStatusProvider(configPath);
    }

    @Override
    protected PluginRepository createPluginRepository() {
        return new CompoundPluginRepository().add(new DefaultPluginRepository(this.getPluginsRoot(), this.isDevelopment())).add(new JarPluginRepository(this.getPluginsRoot()));
    }

    @Override
    protected PluginLoader createPluginLoader() {
        return new CompoundPluginLoader().add(new DefaultPluginLoader(this, this.pluginClasspath)).add(new JarPluginLoader(this));
    }

    @Override
    protected VersionManager createVersionManager() {
        return new DefaultVersionManager();
    }

    protected PluginClasspath createPluginClasspath() {
        return this.isDevelopment() ? new DevelopmentPluginClasspath() : new DefaultPluginClasspath();
    }

    @Override
    protected void initialize() {
        this.pluginClasspath = this.createPluginClasspath();
        super.initialize();
        if (this.isDevelopment()) {
            this.addPluginStateListener(new LoggingPluginStateListener());
        }
        log.info("PF4J version {} in '{}' mode", (Object)this.getVersion(), (Object)this.getRuntimeMode());
    }

    @Override
    protected PluginWrapper loadPluginFromPath(Path pluginPath) throws PluginException {
        try {
            pluginPath = FileUtils.expandIfZip(pluginPath);
        }
        catch (Exception e) {
            log.warn("Failed to unzip " + pluginPath, e);
            return null;
        }
        return super.loadPluginFromPath(pluginPath);
    }
}

