/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.properties;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.IF.TransparentIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.OUI;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.DummyPing;
import ch.rakudave.jnetmap.net.status.IsReachable;
import ch.rakudave.jnetmap.net.status.NativePing;
import ch.rakudave.jnetmap.net.status.NmapPing;
import ch.rakudave.jnetmap.net.status.OpenSocket;
import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import ch.rakudave.jnetmap.view.components.PortScanner;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class InterfaceProperties
extends EscapableDialog {
    public InterfaceProperties(Frame owner, NetworkIF i) {
        this(owner, i, null);
    }

    public InterfaceProperties(Frame owner, NetworkIF i, Consumer<Boolean> wasSaved) {
        super((Window)owner, Lang.getNoHTML("interface.properties"));
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(350, 420));
        this.setMinimumSize(new Dimension(350, 420));
        PreferencePanel main = InterfaceProperties.getInnerPanel(owner, i, true);
        JPanel bottomRow = new JPanel(new FlowLayout(4, 5, 5));
        InterfaceProperties _this = this;
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.addActionListener(e -> {
            if (wasSaved != null) {
                wasSaved.accept(false);
            }
            _this.dispose();
        });
        JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(e -> {
            main.save();
            if (wasSaved != null) {
                wasSaved.accept(true);
            }
            _this.dispose();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        bottomRow.add(cancel);
        bottomRow.add(ok);
        this.add((Component)main, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        SwingHelper.centerTo(owner, this);
        this.setVisible(true);
    }

    public static PreferencePanel getInnerPanel(final Frame owner, final NetworkIF i, boolean showCounterpart) {
        if (i == null) {
            return null;
        }
        final boolean isPhysical = i instanceof PhysicalIF;
        final boolean isTransparent = i instanceof TransparentIF;
        final String oldAddress = !isTransparent && i != null && i.getAddress() != null ? i.getAddress().getHostAddress() : "127.0.0.1";
        final String oldSubnet = i == null || i.getSubnet() == null ? "" : i.getSubnet().getInfo().getNetmask();
        final String oldGateway = i == null || i.getGateway() == null ? "" : i.getGateway().getHostAddress();
        final JTextField name = new JTextField(i.getName());
        final JTextField address = new JTextField(!isTransparent ? oldAddress : "");
        address.setEnabled(!isTransparent);
        try {
            address.setToolTipText(i.getAddress().getCanonicalHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JTextField subnet = new JTextField(oldSubnet);
        subnet.setEnabled(!isTransparent);
        final JTextField gateway = new JTextField();
        gateway.setEnabled(isPhysical);
        address.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                InterfaceProperties.autocomplete(address, subnet, gateway, false);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        address.addActionListener(e -> InterfaceProperties.autocomplete(address, subnet, gateway, true));
        final JLabel oui = new JLabel("");
        final JTextField mac = new JTextField();
        mac.setEnabled(isPhysical);
        mac.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                oui.setText("<html><small>" + OUI.getInstance().lookup(mac.getText()) + "</small></html>");
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        JPanel portWrapper = new JPanel(new BorderLayout(5, 5));
        final PingMethod oldMethod = isPhysical ? ((PhysicalIF)i).getPingMethod() : null;
        int portNr = isPhysical && oldMethod instanceof OpenSocket ? ((OpenSocket)((PhysicalIF)i).getPingMethod()).getPort() : 0;
        final JSpinner port = new JSpinner(new SpinnerNumberModel(portNr, 0, 65535, 1));
        port.setEditor(new JSpinner.NumberEditor(port, "#####"));
        port.setEnabled(isPhysical);
        JButton portScan = new JButton(new AbstractAction("", Icons.get("find")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortScanner ps = new PortScanner(owner, i.getAddress().getHostAddress());
                port.setValue(ps.getPort());
            }
        });
        portScan.setEnabled(isPhysical);
        portWrapper.add((Component)port, "Center");
        portWrapper.add((Component)portScan, "East");
        final JComboBox<String> method = new JComboBox<String>(new String[]{"Java Ping", "System Ping", "TCP Port", "Nmap Ping", "Dummy Ping"});
        method.addActionListener(e -> {
            boolean en = method.getSelectedIndex() == 2;
            port.setEnabled(en);
            portScan.setEnabled(en);
        });
        method.setEnabled(isPhysical);
        if (oldMethod != null) {
            method.setSelectedItem(oldMethod.toString());
        }
        if (isPhysical) {
            gateway.setText(oldGateway);
            String macAddress = ((PhysicalIF)i).getMacAddress();
            mac.setText(macAddress);
            oui.setText("<html><small>" + OUI.getInstance().lookup(macAddress) + "</small></html>");
        }
        final JCheckBox intIgnore = new JCheckBox(Lang.getNoHTML("event.ignore.text"));
        if (isPhysical) {
            intIgnore.setSelected(((PhysicalIF)i).isIgnore());
        }
        intIgnore.setEnabled(isPhysical);
        intIgnore.setToolTipText(Lang.getNoHTML("event.ignore.text"));
        final JCheckBox addressCheckbox = new JCheckBox(Lang.get("interface.address"));
        addressCheckbox.setEnabled(isPhysical || isTransparent);
        addressCheckbox.setSelected(isPhysical);
        addressCheckbox.addActionListener(e -> {
            boolean s = addressCheckbox.isSelected();
            address.setEnabled(s);
            subnet.setEnabled(s);
            gateway.setEnabled(s);
            mac.setEnabled(s);
            method.setEnabled(s);
            port.setEnabled(s);
            portScan.setEnabled(s);
            intIgnore.setEnabled(s);
        });
        final JComboBox<Device> counterpart = new JComboBox<Device>();
        if (showCounterpart) {
            Vector<Device> devices = new Vector<Device>(Controller.getCurrentMap().getVertices());
            Collections.sort(devices);
            counterpart.setModel(new DefaultComboBoxModel<Device>(devices));
            counterpart.setSelectedItem(Controller.getCurrentMap().getOpposite(i.getDevice(), i.getConnection()));
        }
        PreferencePanel p = new PreferencePanel(){

            @Override
            public void save() {
                Controller.getCurrentMap().getHistory().execute(new Command(){
                    String oldName;
                    String newName;
                    String newAddress;
                    String newSubnet;
                    String newGateway;
                    String oldMac;
                    String newMac;
                    PingMethod newMethod;
                    boolean oldIgnore;
                    boolean newIgnore;
                    Connection connection;
                    Device parent;
                    Device oldCounterpart;
                    Device newCounterpart;
                    NetworkIF newIF;
                    {
                        this.oldName = i.getName();
                        this.newName = name.getText();
                        this.newAddress = address.getText();
                        this.newSubnet = subnet.getText();
                        this.newGateway = gateway.getText();
                        this.oldMac = isPhysical ? ((PhysicalIF)i).getMacAddress() : null;
                        this.newMac = mac.getText();
                        this.newMethod = InterfaceProperties.nameToMethod((String)method.getSelectedItem(), (Integer)port.getValue());
                        this.oldIgnore = isPhysical && ((PhysicalIF)i).isIgnore();
                        this.newIgnore = intIgnore.isSelected();
                        this.connection = i.getConnection();
                        this.parent = i.getDevice();
                        this.oldCounterpart = Controller.getCurrentMap().getOpposite(this.parent, this.connection);
                        this.newCounterpart = (Device)counterpart.getSelectedItem();
                        this.newIF = null;
                    }

                    @Override
                    public Object undo() {
                        if (isPhysical && !addressCheckbox.isSelected()) {
                            PhysicalIF pif = new PhysicalIF(this.parent, this.connection, oldAddress);
                            pif.setSubnet(oldSubnet);
                            pif.setGateway(oldGateway);
                            pif.setMacAddress(this.oldMac);
                            pif.setPingMethod(oldMethod);
                            pif.setName(this.oldName);
                            pif.setIgnore(this.oldIgnore);
                            this.parent.addInterface(pif);
                            this.parent.removeInterface(this.newIF);
                        } else if (isTransparent && addressCheckbox.isSelected()) {
                            TransparentIF tif = new TransparentIF(this.parent, this.connection, Controller.getCurrentMap().getOpposite(this.parent, i.getConnection()).getInterfaceFor(this.connection));
                            tif.setName(this.oldName);
                            this.parent.addInterface(tif);
                            this.parent.removeInterface(this.newIF);
                        } else {
                            i.setAddress(oldAddress);
                            i.setSubnet(oldSubnet);
                            i.setGateway(oldGateway);
                            i.setName(this.oldName);
                            if (isPhysical) {
                                PhysicalIF pif = (PhysicalIF)i;
                                pif.setMacAddress(this.oldMac);
                                pif.setPingMethod(oldMethod);
                                pif.setIgnore(this.oldIgnore);
                            }
                        }
                        if (this.oldCounterpart != null && this.newCounterpart != null && this.oldCounterpart != this.newCounterpart) {
                            Controller.getCurrentMap().removeEdge(this.connection);
                            Controller.getCurrentMap().addEdge(this.connection, this.parent, this.oldCounterpart);
                            this.connection.clearStatusMap();
                        }
                        return null;
                    }

                    @Override
                    public Object redo() {
                        NetworkIF counterpart = Controller.getCurrentMap().getOpposite(this.parent, i.getConnection()).getInterfaceFor(this.connection);
                        if (isTransparent && addressCheckbox.isSelected()) {
                            PhysicalIF pif = new PhysicalIF(this.parent, this.connection, this.newAddress);
                            pif.setSubnet(this.newSubnet);
                            pif.setGateway(this.newGateway);
                            pif.setMacAddress(this.newMac);
                            pif.setPingMethod(this.newMethod);
                            pif.setName(this.newName);
                            pif.setIgnore(this.newIgnore);
                            this.newIF = pif;
                            this.parent.addInterface(pif);
                            this.parent.removeInterface(i);
                            if (counterpart instanceof TransparentIF) {
                                ((TransparentIF)counterpart).setCounterpart(pif);
                            }
                        } else if (isPhysical && !addressCheckbox.isSelected()) {
                            this.newIF = new TransparentIF(this.parent, this.connection, counterpart);
                            this.newIF.setName(this.newName);
                            this.parent.addInterface(this.newIF);
                            this.parent.removeInterface(i);
                        } else {
                            i.setAddress(this.newAddress);
                            i.setSubnet(this.newSubnet);
                            i.setGateway(this.newGateway);
                            i.setName(this.newName);
                            if (isPhysical) {
                                PhysicalIF pif = (PhysicalIF)i;
                                pif.setMacAddress(this.newMac);
                                pif.setPingMethod(this.newMethod);
                                pif.setIgnore(this.newIgnore);
                            }
                        }
                        if (this.oldCounterpart != null && this.newCounterpart != null && this.oldCounterpart != this.newCounterpart) {
                            Controller.getCurrentMap().removeEdge(this.connection);
                            Controller.getCurrentMap().addEdge(this.connection, this.parent, this.newCounterpart);
                            this.connection.clearStatusMap();
                        }
                        return null;
                    }

                    @Override
                    public String toString() {
                        return Lang.getNoHTML("command.update.interface") + ": " + i.getName() + " (" + this.parent.getName() + ")";
                    }
                });
            }
        };
        p.setLayout(new GridLayout(0, 2, 5, 5));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add(new JLabel(Lang.get("interface.name")));
        p.add(name);
        p.add(addressCheckbox);
        p.add(address);
        p.add(new JLabel("      " + Lang.getNoHTML("interface.subnet")));
        p.add(subnet);
        p.add(new JLabel("      " + Lang.getNoHTML("interface.gateway")));
        p.add(gateway);
        p.add(new JLabel("      " + Lang.getNoHTML("interface.mac")));
        p.add(mac);
        p.add(new JLabel(""));
        p.add(oui);
        p.add(new JLabel("      " + Lang.getNoHTML("interface.pingmethod")));
        p.add(method);
        p.add(new JLabel());
        p.add(portWrapper);
        p.add(new JLabel("      " + Lang.getNoHTML("event.ignore.title")));
        p.add(intIgnore);
        if (showCounterpart) {
            p.add(new JLabel("      " + Lang.getNoHTML("interface.connectedto")));
            p.add(counterpart);
        }
        if (isPhysical) {
            address.requestFocus();
        } else {
            name.requestFocus();
        }
        return p;
    }

    private static PingMethod nameToMethod(String name, int port) {
        if ("Java Ping".equals(name)) {
            return IsReachable.getInstance();
        }
        if ("System Ping".equals(name)) {
            return NativePing.getInstance();
        }
        if ("Nmap Ping".equals(name)) {
            return NmapPing.getInstance();
        }
        if ("Dummy Ping".equals(name)) {
            return new DummyPing();
        }
        return new OpenSocket(port);
    }

    private static void autocomplete(JTextField address, JTextField subnet, JTextField gateway, boolean force) {
        try {
            String addr = address.getText();
            String mask = subnet.getText();
            mask = mask.isEmpty() ? "255.255.255.0" : mask;
            Subnet s = addr.contains("/") ? new Subnet(addr) : new Subnet(addr, mask);
            address.setText(s.getInfo().getAddress());
            if (subnet.getText().isEmpty() || force) {
                subnet.setText(s.getInfo().getNetmask());
            }
            if (gateway.getText().isEmpty() || force) {
                gateway.setText(s.getInfo().getLowAddress());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

