/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.jung;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.Settings;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.apache.commons.collections15.Transformer;

public class EdgeTransformers {
    private static Color selectedColor = new Color(Settings.getInt("edge.selected.color", Color.black.getRGB()));

    public static Transformer<Connection, Stroke> strokeTransformer() {
        return connection -> EdgeTransformers.getStroke(connection.getType(), connection.getBandwidth());
    }

    public static BasicStroke getStroke(Connection.Type type, double bandwidth) {
        float[] dash;
        switch (type) {
            case Coaxial: {
                dash = new float[]{20.0f, 10.0f, 5.0f, 10.0f};
                break;
            }
            case Fiber: {
                dash = new float[]{20.0f, 10.0f};
                break;
            }
            case Phone: {
                dash = new float[]{20.0f, 7.0f, 2.0f, 7.0f};
                break;
            }
            case Serial: {
                dash = new float[]{20.0f, 7.0f, 50.0f, 7.0f};
                break;
            }
            case Wireless: {
                dash = new float[]{5.0f, 10.0f};
                break;
            }
            default: {
                dash = new float[]{1.0f};
            }
        }
        return new BasicStroke((float)Math.log(bandwidth), 1, 1, 10.0f, dash, 0.0f);
    }

    public static Transformer<Connection, Paint> paintTransformer(PickedInfo<Connection> pi) {
        return arg0 -> {
            if (pi.isPicked((Connection)arg0)) {
                if (Settings.getInt("edge.selected.color", Color.black.getRGB()) != selectedColor.getRGB()) {
                    selectedColor = new Color(Settings.getInt("edge.selected.color", Color.black.getRGB()));
                }
                return selectedColor;
            }
            return arg0.getStatus().getColor();
        };
    }

    public static void setEdgeShape(RenderContext<Device, Connection> rc) {
        switch (Shape.valueOf(Settings.get("edge.shape", "Quad"))) {
            case Line: {
                rc.setEdgeShapeTransformer(new EdgeShape.Line());
                break;
            }
            case Curve: {
                rc.setEdgeShapeTransformer(new EdgeShape.CubicCurve());
                break;
            }
            case Bent: {
                rc.setEdgeShapeTransformer(new EdgeShape.BentLine());
                break;
            }
            default: {
                rc.setEdgeShapeTransformer(new EdgeShape.QuadCurve());
            }
        }
    }

    public static enum Shape {
        Line,
        Curve,
        Quad,
        Bent;

    }
}

