/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.view.IStatusbar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel
implements IStatusbar {
    private static final long serialVersionUID = -5510132656286800042L;
    private static StatusBar instance;
    private static final Object lock;
    private JLabel label;
    private JLabel busyIndicator;
    private JProgressBar progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStatusbar getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new StatusBar();
                }
            }
        }
        return instance;
    }

    private StatusBar() {
        super(new BorderLayout());
        this.setVisible(Settings.getBoolean("statusbar.visible", true));
        this.busyIndicator = new JLabel(Icons.get("busy")){
            {
                this.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
                this.setVisible(false);
            }
        };
        this.add((Component)this.busyIndicator, "West");
        this.label = new JLabel(){
            {
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            }
        };
        this.add((Component)this.label, "Center");
        this.progress = new JProgressBar(0, 0, 100){
            {
                this.setStringPainted(true);
                this.setVisible(false);
            }
        };
        this.add((Component)this.progress, "East");
    }

    @Override
    public void clearMessage() {
        this.label.setText("\t");
    }

    @Override
    public void setBusy(boolean busy) {
        this.busyIndicator.setVisible(busy);
    }

    @Override
    public void setMessage(String message) {
        this.label.setText(message);
    }

    @Override
    public void setProgress(int percent) {
        this.progress.setValue(percent);
        this.progress.setVisible(percent >= 0);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        Settings.put("statusbar.visible", aFlag);
    }

    static {
        lock = new Object();
    }
}

