/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.net.PortScan;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class PortScanner
extends EscapableDialog {
    private int port;

    public PortScanner(Frame owner, String address) {
        super((Window)owner, Lang.getNoHTML("port.scanner"));
        try {
            PortScanner _this = this;
            this.setLayout(new BorderLayout(5, 5));
            this.setPreferredSize(new Dimension(500, 500));
            this.setMinimumSize(new Dimension(500, 500));
            this.setDefaultCloseOperation(2);
            JPanel main = new JPanel(new BorderLayout(5, 5));
            JPanel listHolder = new JPanel(new BorderLayout());
            final JList leftList = new JList();
            leftList.setPreferredSize(new Dimension(55, 400));
            final JList rightList = new JList();
            leftList.addListSelectionListener(e -> {
                rightList.setSelectedIndex(leftList.getSelectedIndex());
                try {
                    if (_this != null) {
                        _this.port = Integer.valueOf((String)leftList.getSelectedValue());
                    }
                }
                catch (Exception ex) {
                    Logger.debug("Unable to get int-value from list", ex);
                    _this.port = 0;
                }
            });
            rightList.addListSelectionListener(e -> leftList.setSelectedIndex(rightList.getSelectedIndex()));
            listHolder.add(leftList, "West");
            listHolder.add(rightList, "Center");
            JPanel topPanel = new JPanel(new BorderLayout());
            JPanel topInner = new JPanel(new GridLayout(0, 1, 5, 5));
            final JTextField addr = new JTextField(address);
            final JComboBox<String> scanType = new JComboBox<String>(new String[]{Lang.get("port.wellknown"), Lang.get("port.registered"), Lang.get("port.all"), Lang.get("port.manual")});
            JPanel manualPorts = new JPanel(new GridLayout(1, 0, 5, 5));
            final JSpinner fromPort = new JSpinner(new SpinnerNumberModel(0, 0, 65535, 1));
            fromPort.setEnabled(false);
            fromPort.setEditor(new JSpinner.NumberEditor(fromPort, "#"));
            final JSpinner toPort = new JSpinner(new SpinnerNumberModel(1023, 0, 65535, 1));
            toPort.setEnabled(false);
            toPort.setEditor(new JSpinner.NumberEditor(toPort, "#"));
            manualPorts.add(fromPort);
            manualPorts.add(toPort);
            scanType.addActionListener(e -> {
                fromPort.setEnabled(scanType.getSelectedIndex() == 3);
                toPort.setEnabled(scanType.getSelectedIndex() == 3);
            });
            topInner.add(addr);
            topInner.add(scanType);
            topInner.add(manualPorts);
            JButton scan = new JButton(new AbstractAction(Lang.get("port.scan")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InetAddress inetAddr;
                        try {
                            inetAddr = InetAddress.getByName(addr.getText());
                        }
                        catch (Exception e1) {
                            Logger.debug("Invalid address", e1);
                            JOptionPane.showMessageDialog(null, Lang.get("message.address.invalid"), Lang.getNoHTML("message.error"), 0);
                            return;
                        }
                        Map<Integer, String> map = scanType.getSelectedIndex() == 0 ? PortScan.wellKnownPortsScan(inetAddr) : (scanType.getSelectedIndex() == 1 ? PortScan.registeredPortscan(inetAddr) : (scanType.getSelectedIndex() == 1 ? PortScan.allPortsScan(inetAddr) : PortScan.scan(inetAddr, Integer.valueOf(fromPort.getValue().toString()), Integer.valueOf(toPort.getValue().toString()))));
                        Vector<String> leftData = new Vector<String>();
                        Vector<String> rightData = new Vector<String>();
                        for (int i : new TreeSet<Integer>(map.keySet())) {
                            leftData.add(String.valueOf(i));
                            rightData.add(map.get(i));
                        }
                        leftList.setListData(leftData);
                        rightList.setListData(rightData);
                    }
                    catch (Throwable e2) {
                        Logger.debug("Port scanner failed", e2);
                    }
                }
            });
            scan.setPreferredSize(new Dimension(70, 100));
            topPanel.add((Component)topInner, "Center");
            topPanel.add((Component)scan, "East");
            main.add((Component)topPanel, "North");
            main.add(listHolder);
            JPanel bottomRow = new JPanel(new FlowLayout(4, 5, 5));
            JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
            ok.setPreferredSize(new Dimension(60, 30));
            ok.addActionListener(e -> _this.dispose());
            bottomRow.add(ok);
            this.add((Component)main, "Center");
            this.add((Component)bottomRow, "South");
            this.pack();
            SwingHelper.centerTo(owner, this);
            this.setVisible(true);
        }
        catch (Throwable t) {
            Logger.error("Port scanner fail", t);
            this.dispose();
        }
    }

    public int getPort() {
        return this.port;
    }
}

