/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util.logging;

import ch.rakudave.jnetmap.util.logging.Appender;
import ch.rakudave.jnetmap.util.logging.Logger;

public class ConsoleAppender
extends Appender {
    private boolean colorize = true;
    static final String ANSI_RESET = "\u001b[0m";
    static final String ANSI_BLACK = "\u001b[30m";
    static final String ANSI_RED = "\u001b[31m";
    static final String ANSI_GREEN = "\u001b[32m";
    static final String ANSI_YELLOW = "\u001b[33m";
    static final String ANSI_BLUE = "\u001b[34m";
    static final String ANSI_PURPLE = "\u001b[35m";
    static final String ANSI_CYAN = "\u001b[36m";
    static final String ANSI_WHITE = "\u001b[37m";
    static final String ANSI_BLACK_BACKGROUND = "\u001b[40m";
    static final String ANSI_RED_BACKGROUND = "\u001b[41m";
    static final String ANSI_GREEN_BACKGROUND = "\u001b[42m";
    static final String ANSI_YELLOW_BACKGROUND = "\u001b[43m";
    static final String ANSI_BLUE_BACKGROUND = "\u001b[44m";
    static final String ANSI_PURPLE_BACKGROUND = "\u001b[45m";
    static final String ANSI_CYAN_BACKGROUND = "\u001b[46m";
    static final String ANSI_WHITE_BACKGROUND = "\u001b[47m";

    public ConsoleAppender(Logger.Level level) {
        this.setLevel(level);
    }

    public boolean isColorize() {
        return this.colorize;
    }

    public void setColorize(boolean colorize) {
        this.colorize = colorize;
    }

    @Override
    void append(Logger.Level l, String message, Throwable t) {
        if (this.level.compareTo(l) >= 0) {
            System.out.println(this.format(l, message));
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    @Override
    String format(Logger.Level l, String message) {
        return this.df.format(System.currentTimeMillis()) + (this.colorize ? this.colorize(l) : this.equalizeLevel(l)) + message;
    }

    private String colorize(Logger.Level l) {
        StringBuilder sb = new StringBuilder();
        switch (l) {
            case FATAL: {
                sb.append(ANSI_RED_BACKGROUND);
                break;
            }
            case ERROR: {
                sb.append(ANSI_RED);
                break;
            }
            case WARN: {
                sb.append(ANSI_YELLOW);
                break;
            }
            case DEBUG: {
                sb.append(ANSI_BLUE);
                break;
            }
            case TRACE: {
                sb.append(ANSI_GREEN);
                break;
            }
        }
        return sb.append(this.equalizeLevel(l)).append(ANSI_RESET).toString();
    }
}

