/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.plugins.JNetMapPlugin;
import ch.rakudave.jnetmap.util.logging.Logger;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class IO {
    private static IO instance = null;
    private static final int bufferSize = 4096;
    public static final File userDir = new File(System.getProperty("user.home") + "/.jNetMap");
    public static final String pluginDirName = "/plugins";
    public static final String langDirName = "/lang";
    public static final String iconsDirName = "/icons";
    public static final String devicesDirName = "/devices";
    public static final boolean isUnix = !System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final boolean isOSX = System.getProperty("os.name").toLowerCase().startsWith("mac");
    public static final boolean isLinux = isUnix && !isOSX;

    private IO() {
    }

    private static Class instance() {
        if (instance == null) {
            instance = new IO();
        }
        return instance.getClass();
    }

    public static URL getResource(String path) {
        return IO.instance().getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return IO.instance().getResourceAsStream(path);
    }

    private static List<String> listURI(URI uri, final boolean dirsOnly) {
        final ArrayList<String> files = new ArrayList<String>();
        try (FileSystem fileSystem = uri.getScheme().equals("jar") ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
            Path path = fileSystem != null ? fileSystem.getPath(uri.toString().split("!")[1], new String[0]) : Paths.get(uri);
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!(dirsOnly && !attrs.isDirectory() || file.startsWith(".") || file.endsWith("~"))) {
                        files.add(file.getFileName().toString().replaceAll("/$", ""));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            Logger.error("Failed to list resources in " + uri.toString());
        }
        return files;
    }

    public static Set<String> listFiles(String path, boolean dirsOnly) {
        TreeSet<String> files = new TreeSet<String>();
        try {
            files.addAll(IO.listURI(IO.getResource(path).toURI(), dirsOnly));
        }
        catch (Exception e) {
            Logger.warn("Failed to list internal resources for " + path, e);
        }
        try {
            File userDir = new File(IO.userDir, path);
            if (userDir.exists()) {
                files.addAll(IO.listURI(userDir.toURI(), dirsOnly));
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to list user resources for " + path, e);
        }
        return files;
    }

    public static Properties getMergedProps(String path) {
        Properties internal = new Properties();
        Properties custom = new Properties();
        try {
            InputStream rs = IO.getResourceAsStream(path);
            if (rs != null) {
                internal.load(rs);
            }
        }
        catch (Exception e) {
            Logger.error("Failed to load props from resources " + path, e);
        }
        File customFile = new File(userDir, path);
        if (customFile.exists()) {
            try {
                custom.load(new FileInputStream(customFile));
                internal.putAll((Map<?, ?>)custom);
            }
            catch (Exception e) {
                Logger.warn("Failed to load props from user dir " + path, e);
            }
        }
        return internal;
    }

    public static boolean copy(File source, File dest, List<String> ignoreList) {
        if (ignoreList != null && ignoreList.contains(source.getName())) {
            return true;
        }
        boolean result = true;
        if (source.isDirectory()) {
            Logger.trace("Copying dir " + dest.getName());
            dest.mkdirs();
            String[] list = source.list();
            if (list != null) {
                for (String aList : list) {
                    result &= IO.copy(new File(source, aList), new File(dest, aList), ignoreList);
                }
            }
        } else {
            if (dest.exists() && dest.lastModified() > source.lastModified()) {
                return true;
            }
            Logger.trace("Copying file " + dest.getName());
            try (FileInputStream fin = new FileInputStream(source);
                 FileOutputStream fout = new FileOutputStream(dest);){
                result = IO.copy((InputStream)fin, fout);
            }
            catch (IOException e) {
                Logger.error("Failed to open I/O-Stream(s)", e);
                return false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream in, OutputStream out) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.error("Failed to open I/O-stream(s)", e);
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean copy(InputStream in, File dest) {
        boolean bl;
        FileOutputStream out = new FileOutputStream(dest);
        try {
            bl = IO.copy(in, out);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.error("Failed to open output-stream", e);
                return false;
            }
        }
        out.close();
        return bl;
    }

    public static void updateUserFiles() {
        Logger.info("User directory: " + userDir.getAbsolutePath());
        new File(userDir, langDirName).mkdirs();
        new File(userDir, iconsDirName).mkdirs();
        new File(userDir, devicesDirName).mkdirs();
        File plugins = new File(userDir, pluginDirName);
        plugins.mkdirs();
        Arrays.stream(plugins.listFiles()).filter(file -> file.getName().endsWith(".jar") && !file.getName().contains("-")).forEach(file -> file.delete());
        try {
            URL pluginResource = IO.getResource(pluginDirName);
            if (pluginResource != null) {
                IO.listURI(pluginResource.toURI(), false).forEach(s -> IO.copy(IO.getResourceAsStream("/plugins/" + s), new File(plugins, (String)s)));
            } else {
                Logger.debug("No bundled plugins found");
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to update default plugins", e);
        }
    }

    public static boolean unzip(File zipFile, File destination) {
        boolean bl;
        if (!(zipFile != null && zipFile.exists() && zipFile.canRead() && zipFile.getName().contains(".zip"))) {
            return false;
        }
        ZipFile zip = new ZipFile(zipFile);
        try {
            boolean success = true;
            Enumeration<? extends ZipEntry> oEnum = zip.entries();
            while (oEnum.hasMoreElements()) {
                ZipEntry zipEntry = oEnum.nextElement();
                if (zipEntry.isDirectory()) {
                    success &= new File(destination.getAbsoluteFile() + "/" + zipEntry.getName()).mkdir();
                    continue;
                }
                success &= IO.copy(zip.getInputStream(zipEntry), new File(destination, zipEntry.getName()));
            }
            bl = success;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error("Failed to open ZIP-file", e);
                new File(destination, zipFile.getName().replace(".zip", "")).delete();
                return false;
            }
        }
        zip.close();
        return bl;
    }

    public static boolean exportImage(VisualizationViewer<Device, Connection> in, File out) {
        System.out.println(in.getSize());
        BufferedImage buff = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        Graphics g = buff.getGraphics();
        in.setDoubleBuffered(false);
        in.paintAll(g);
        in.setDoubleBuffered(true);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)buff, "png", out);
            return true;
        }
        catch (IOException e) {
            Logger.error("Unable to export image", e);
            return false;
        }
    }

    public static String getString(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[4096];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            int n;
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            Logger.error("Unable to read string", e);
            return null;
        }
        return ((Object)writer).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static boolean tryRemovePlugin(JNetMapPlugin p) {
        File[] fileArray = new File(userDir, "plugins").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().contains(".jar")) {
                try (ZipFile zip = new ZipFile(f);){
                    Enumeration<? extends ZipEntry> oEnum = zip.entries();
                    while (oEnum.hasMoreElements()) {
                        ZipEntry zipEntry = oEnum.nextElement();
                        if (zipEntry.isDirectory() || !zipEntry.getName().contains(p.getClass().getSimpleName() + ".class")) continue;
                        boolean bl = f.delete();
                        return bl;
                    }
                }
                catch (Exception ex) {
                    Logger.warn("Unable to read jar-file " + f, ex);
                }
            }
            ++n2;
        }
        return false;
    }

    public static String[] splitCommandArgs(String command, String args) {
        ArrayList<String> matchList = new ArrayList<String>();
        matchList.add(command);
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(args);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        String[] out = new String[matchList.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)matchList.get(i);
        }
        return out;
    }
}

